/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.pkt.test.unit;

import com.neeve.io.IOBuffer;
import com.neeve.pkt.EPktBodyClassInstantiateException;
import com.neeve.pkt.EPktBodyClassLoadException;
import com.neeve.pkt.EPktCorruptException;
import com.neeve.pkt.EPktTypeInvalidException;
import com.neeve.pkt.EPktVersionInvalidException;
import com.neeve.pkt.PktBody;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktHeader;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSerializable;
import com.neeve.pkt.PktSubheaderFMC;
import com.neeve.pkt.PktSubheaderFUC;
import com.neeve.pkt.PktSubheaderRR;
import com.neeve.pkt.test.unit.PktSerializableTest;
import com.neeve.pkt.test.unit.PktTestBodyVptfxb;
import com.neeve.pkt.test.unit.PktTestHelper;
import com.neeve.test.UnitTest;
import com.neeve.trace.Tracer;
import java.nio.ByteBuffer;
import java.util.Random;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public final class PktFactoryTest
extends UnitTest {
    private static Random random;

    @BeforeClass
    public static void createPacketTypeConfigFiles() {
        PktTestHelper.loadPacketTypes();
        random = new Random((int)System.currentTimeMillis());
        PktFactory.getInstance().getTracer().setLevel(Tracer.Level.OFF);
    }

    private void testCreateWithInvalidMagic(PktPacket packet) throws Exception {
        int val;
        ByteBuffer buffer = PktSerializableTest.testCopySerialization(packet, 1, false, true);
        int magic = 12246189;
        while (magic == ((val = buffer.getInt(0) & 0xFF | random.nextInt() & 0xFFFFFF00) & 0xFFFFFF00) >> 8) {
        }
        buffer.putInt(0, val);
        try {
            PktFactory.getInstance().createPacket(PktSerializable.DeserializeContext.create().setBuffer(buffer));
            PktFactoryTest.testFailure((String)"create did not catch an invalid magic number in a serialized packet");
        }
        catch (EPktCorruptException e) {
            PktFactoryTest.testSuccess((String)("Received corrupt packet exception [" + e.getMessage() + "] when creating a packet using a buffer with an invalid magic"));
        }
    }

    private void testCreateWithInvalidVersion(PktPacket packet) throws Exception {
        int val;
        ByteBuffer buffer = PktSerializableTest.testCopySerialization(packet, 1, false, true);
        short version = packet.getHeader().getVersion();
        while (version == (short)((val = buffer.getInt(0) & 0xFFFFFF00 | random.nextInt() & 0xFF) & 0xFF)) {
        }
        buffer.putInt(0, val);
        try {
            PktFactory.getInstance().createPacket(PktSerializable.DeserializeContext.create().setBuffer(buffer));
            PktFactoryTest.testFailure((String)("create did not catch an invalid version [" + (val & 0xFF) + " in a serialized packet"));
        }
        catch (EPktVersionInvalidException e) {
            PktFactoryTest.testSuccess((String)("Received invalid version exception [" + e.getMessage() + "] when creating a packet from a buffer with a valid magic and invalid header version"));
        }
    }

    private void testCreateWithLessMinLenBuffer(PktPacket packet) throws Exception {
        PktSerializable.DeserializeContext context = PktSerializable.DeserializeContext.create().setBuffer(ByteBuffer.allocate(0));
        PktFactory.getInstance().createPacket(context);
        int minLen = context.getNumBytes();
        ByteBuffer buffer = PktSerializableTest.testCopySerialization(packet, 1, false, true);
        context.setBuffer(buffer);
        for (int i = 0; i < minLen; ++i) {
            buffer.position(0).limit(i);
            if (PktFactory.getInstance().createPacket(context.reset()) != null) {
                PktFactoryTest.testFailure((String)("Creation of a packet from a " + i + " byte buffer returned non-null!"));
            }
            if (context.getNumBytes() != minLen - i) {
                PktFactoryTest.testFailure((String)("Invalid numBytes in context [exp=" + (minLen - i) + " actual=" + context.getNumBytes() + "] from creation of a packet from a " + i + " byte buffer"));
            }
            if (buffer.position() != 0) {
                PktFactoryTest.testFailure((String)("Packet create from buffer of length=" + i + " changed the buffer position marker [before=0 after=" + buffer.position() + "]"));
            }
            if (buffer.limit() != i) {
                PktFactoryTest.testFailure((String)("Packet create from buffer of length=" + i + " changed the buffer limit marker [before=" + i + " after=" + buffer.limit() + "]"));
            }
            PktFactoryTest.testSuccess((String)("Packet create from a buffer of length=" + i + " bytes returned false and requested " + context.getNumBytes() + " additional bytes"));
        }
    }

    private void testCreateWithLessOrEqualLenBuffer(PktPacket packet) throws Exception {
        ByteBuffer buffer = PktSerializableTest.testCopySerialization(packet, 1, false, true);
        int len = packet.getHeader().getLength();
        int lenSlabCapacity = IOBuffer.create((int)len, (boolean)false).getBufferUnsafe().capacity();
        if (lenSlabCapacity != buffer.capacity()) {
            PktFactoryTest.testFailure((String)("Incorrect test setup. Serialized buffer capacity is not the same as slab capacity for length in header [hdrLenSlabCapacity=" + lenSlabCapacity + " bufferCapacity=" + buffer.capacity() + "]"));
        }
        PktSerializable.DeserializeContext context = PktSerializable.DeserializeContext.create().setBuffer(ByteBuffer.allocate(0));
        PktHeader.preDeserialize(context);
        int minLen = context.getNumBytes();
        context.setBuffer(buffer);
        for (int i = minLen; i < len; ++i) {
            buffer.position(0).limit(i);
            if (PktFactory.getInstance().createPacket(context.reset()) != null) {
                PktFactoryTest.testFailure((String)("Predeserialise of a " + i + " byte buffer returned true!"));
            }
            if (context.getNumBytes() != len - i) {
                PktFactoryTest.testFailure((String)("Invalid numBytes in context [exp=" + (len - i) + " actual=" + context.getNumBytes() + "] from creation of a packet from a " + i + " byte buffer"));
            }
            if (buffer.position() != 0) {
                PktFactoryTest.testFailure((String)("Packet create from buffer of length=" + i + " changed the buffer position marker [before=0 after=" + buffer.position() + "]"));
            }
            if (buffer.limit() != i) {
                PktFactoryTest.testFailure((String)("Packet create from buffer of length=" + i + " changed the buffer limit marker [before=" + i + " after=" + buffer.limit() + "]"));
            }
            PktFactoryTest.testSuccess((String)("Packet create from a buffer of length=" + i + " bytes returned false and requested " + context.getNumBytes() + " additional bytes"));
        }
        buffer.position(0).limit(buffer.capacity());
        if (!PktHeader.preDeserialize(context.reset())) {
            PktFactoryTest.testFailure((String)"Predeserialize from fully serialized packet returned false!");
        }
        if (context.getNumBytes() != 0) {
            PktFactoryTest.testFailure((String)("Predeserialize from fully serialized packet changed the context.numBytes field [exp=0 actual=" + context.getNumBytes() + "]"));
        }
    }

    private void testCreatePostDeserialize(PktPacket packet, PktPacket newPacket, PktSerializable.DeserializeContext context, int pos, ByteBuffer buffer, int serializePolicy, int deserializePolicy, boolean hdrSerializeCopy, boolean hdrDeserializeCopy, boolean bodySerializeCopy, boolean bodyDeserializeCopy, short hver, int src, int dest, int flow, boolean nobuffer, boolean replyexpected, short htl, short clazz, int type, int len, int blen, short numSubheaders, PktBody rrSubheader, PktBody fmcSubheader, PktBody fucSubheader, byte b, char c, int i, double d) {
        if (buffer.position() - pos != len) {
            PktFactoryTest.testFailure((String)("Deserialization caused buffer pointer to advance by an incorrect amount [exp=" + len + " actual=" + (buffer.position() - pos) + "]"));
        }
        if (context.getNumBytes() != len) {
            PktFactoryTest.testFailure((String)("Deserialization did not update context with accurate byte count [exp=" + len + " actual=" + context.getNumBytes() + "]"));
        }
        if (PktHeader.getBodyType(newPacket.getHeader().getBuffer(), 0) != type) {
            PktFactoryTest.testFailure((String)("Incorrect TYPE in deserialized header buffer [exp=" + type + " actual=" + PktHeader.getBodyType(newPacket.getHeader().getBuffer(), 0) + "]"));
        }
        packet.getHeader().setSrc(random.nextInt());
        packet.getHeader().setDest(random.nextInt());
        packet.getHeader().setFlow(random.nextInt());
        packet.getHeader().setNoBuffering(!packet.getHeader().getNoBuffering());
        packet.getHeader().setReplyExpected(!packet.getHeader().getReplyExpected());
        packet.getHeader().setHtl((short)random.nextInt(255));
        packet.getHeader().setClazz((short)random.nextInt(255));
        String topic = null;
        if (rrSubheader != null) {
            // empty if block
        }
        if (fmcSubheader != null) {
            topic = ((PktSubheaderFMC)fmcSubheader).getTopic();
            ((PktSubheaderFMC)fmcSubheader).setTopic(topic + "ch");
        }
        if (fucSubheader != null) {
            // empty if block
        }
        PktSubheaderFMC newFmcSubheader = (PktSubheaderFMC)PktSubheaderFMC.create();
        newFmcSubheader.setTopic(topic);
        ((PktTestBodyVptfxb)packet.getBody()).setByte((byte)(random.nextInt(126) + 1));
        ((PktTestBodyVptfxb)packet.getBody()).setChar((char)(random.nextInt(65534) + 1));
        ((PktTestBodyVptfxb)packet.getBody()).setInt(random.nextInt());
        ((PktTestBodyVptfxb)packet.getBody()).setDouble(random.nextDouble());
        ((PktTestBodyVptfxb)packet.getBody()).setByte(b);
        ((PktTestBodyVptfxb)packet.getBody()).setChar(c);
        ((PktTestBodyVptfxb)packet.getBody()).setInt(i);
        ((PktTestBodyVptfxb)packet.getBody()).setDouble(d);
        packet.getHeader().setSrc(src);
        packet.getHeader().setDest(dest);
        packet.getHeader().setFlow(flow);
        packet.getHeader().setNoBuffering(nobuffer);
        packet.getHeader().setReplyExpected(replyexpected);
        packet.getHeader().setHtl(htl);
        packet.getHeader().setClazz(clazz);
        if (rrSubheader != null) {
            // empty if block
        }
        if (fmcSubheader != null) {
            ((PktSubheaderFMC)fmcSubheader).setTopic(topic);
        }
        if (fucSubheader != null) {
            // empty if block
        }
    }

    private void testCreateSimpleDeserialize(PktPacket packet, int serializePolicy, int deserializePolicy, boolean hdrSerializeCopy, boolean hdrDeserializeCopy, boolean bodySerializeCopy, boolean bodyDeserializeCopy, short hver, int src, int dest, int flow, boolean nobuffer, boolean replyexpected, short htl, short clazz, int type, int len, int blen, short numSubheaders, PktBody rrSubheader, PktBody fmcSubheader, PktBody fucSubheader, byte b, char c, int i, double d) throws Exception {
        ByteBuffer buffer = PktSerializableTest.testDeserializationSerialize(packet, serializePolicy, hdrSerializeCopy ? (bodySerializeCopy ? 1 : 3) : (bodySerializeCopy ? 3 : 2));
        int pos = buffer.position();
        PktSerializable.DeserializeContext context = PktSerializable.DeserializeContext.create().setBuffer(buffer).setPolicy(deserializePolicy);
        PktPacket newPacket = (PktPacket)PktSerializableTest.testDeserializationDeserialize(PktFactory.getInstance().createPacket(packet.getBody().getType()), context, -1);
        this.testCreatePostDeserialize(packet, newPacket, context, pos, buffer, serializePolicy, deserializePolicy, hdrSerializeCopy, hdrDeserializeCopy, bodySerializeCopy, bodyDeserializeCopy, hver, src, dest, flow, nobuffer, replyexpected, htl, clazz, type, len, blen, numSubheaders, rrSubheader, fmcSubheader, fucSubheader, b, c, i, d);
    }

    private void testCreateRepeatDeserialize(PktPacket packet, int serializePolicy, int deserializePolicy, boolean hdrSerializeCopy, boolean hdrDeserializeCopy, boolean bodySerializeCopy, boolean bodyDeserializeCopy, short hver, int src, int dest, int flow, boolean nobuffer, boolean replyexpected, short htl, short clazz, int type, int len, int blen, short numSubheaders, PktBody rrSubheader, PktBody fmcSubheader, PktBody fucSubheader, byte b, char c, int i, double d) throws Exception {
        this.testCreateSimpleDeserialize(packet, serializePolicy, deserializePolicy, hdrSerializeCopy, hdrDeserializeCopy, bodySerializeCopy, bodyDeserializeCopy, hver, src, dest, flow, nobuffer, replyexpected, htl, clazz, type, len, blen, numSubheaders, rrSubheader, fmcSubheader, fucSubheader, b, c, i, d);
        this.testCreateSimpleDeserialize(packet, serializePolicy, deserializePolicy, hdrSerializeCopy, hdrDeserializeCopy, bodySerializeCopy, bodyDeserializeCopy, hver, src, dest, flow, nobuffer, replyexpected, htl, clazz, type, len, blen, numSubheaders, rrSubheader, fmcSubheader, fucSubheader, b, c, i, d);
    }

    private void testCreateDeserializeFromLarger(PktPacket packet, int serializePolicy, int deserializePolicy, boolean hdrSerializeCopy, boolean hdrDeserializeCopy, boolean bodySerializeCopy, boolean bodyDeserializeCopy, short hver, int src, int dest, int flow, boolean nobuffer, boolean replyexpected, short htl, short clazz, int type, int len, int blen, short numSubheaders, PktBody rrSubheader, PktBody fmcSubheader, PktBody fucSubheader, byte b, char c, int i, double d) throws Exception {
        ByteBuffer buffer = PktSerializableTest.testDeserializationSerialize(packet, serializePolicy, hdrSerializeCopy ? (bodySerializeCopy ? 1 : 3) : (bodySerializeCopy ? 3 : 2));
        ByteBuffer buffer1 = ByteBuffer.allocate(buffer.capacity() * 3 / 2);
        buffer1.put(buffer);
        buffer1.flip();
        int pos = buffer1.position();
        PktSerializable.DeserializeContext context = PktSerializable.DeserializeContext.create().setBuffer(buffer1).setPolicy(deserializePolicy);
        PktPacket newPacket = (PktPacket)PktSerializableTest.testDeserializationDeserialize(PktFactory.getInstance().createPacket(packet.getBody().getType()), context, -1);
        this.testCreatePostDeserialize(packet, newPacket, context, pos, buffer1, serializePolicy, deserializePolicy, hdrSerializeCopy, hdrDeserializeCopy, bodySerializeCopy, bodyDeserializeCopy, hver, src, dest, flow, nobuffer, replyexpected, htl, clazz, type, len, blen, numSubheaders, rrSubheader, fmcSubheader, fucSubheader, b, c, i, d);
    }

    private void testCreateDeserializeTwice(PktPacket packet, int serializePolicy, int deserializePolicy, boolean hdrSerializeCopy, boolean hdrDeserializeCopy, boolean bodySerializeCopy, boolean bodyDeserializeCopy, short hver, int src, int dest, int flow, boolean nobuffer, boolean replyexpected, short htl, short clazz, int type, int len, int blen, short numSubheaders, PktBody rrSubheader, PktBody fmcSubheader, PktBody fucSubheader, byte b, char c, int i, double d) throws Exception {
        ByteBuffer buffer = PktSerializableTest.testDeserializationSerialize(packet, serializePolicy, hdrSerializeCopy ? (bodySerializeCopy ? 1 : 3) : (bodySerializeCopy ? 3 : 2));
        ByteBuffer buffer1 = PktSerializableTest.testDeserializationSerialize(packet, serializePolicy, hdrSerializeCopy ? (bodySerializeCopy ? 1 : 3) : (bodySerializeCopy ? 3 : 2));
        ByteBuffer buffer2 = ByteBuffer.allocate(buffer.capacity() + buffer1.capacity());
        buffer2.put(buffer).put(buffer1);
        buffer2.flip();
        int pos = buffer2.position();
        PktSerializable.DeserializeContext context = PktSerializable.DeserializeContext.create().setBuffer(buffer2).setPolicy(deserializePolicy);
        PktPacket newPacket = (PktPacket)PktSerializableTest.testDeserializationDeserialize(PktFactory.getInstance().createPacket(packet.getBody().getType()), context, -1);
        this.testCreatePostDeserialize(packet, newPacket, context, pos, buffer1, serializePolicy, deserializePolicy, hdrSerializeCopy, hdrDeserializeCopy, bodySerializeCopy, bodyDeserializeCopy, hver, src, dest, flow, nobuffer, replyexpected, htl, clazz, type, len, blen, numSubheaders, rrSubheader, fmcSubheader, fucSubheader, b, c, i, d);
        buffer2 = context.getBuffer();
        pos = buffer2.position();
        newPacket = (PktPacket)PktSerializableTest.testDeserializationDeserialize(PktFactory.getInstance().createPacket(packet.getBody().getType()), context.reset(), -1);
        PktSerializableTest.testDeserializationSerialize(packet, serializePolicy, hdrSerializeCopy ? (bodySerializeCopy ? 1 : 3) : (bodySerializeCopy ? 3 : 2));
        this.testCreatePostDeserialize(packet, newPacket, context, pos, buffer2, serializePolicy, deserializePolicy, hdrSerializeCopy, hdrDeserializeCopy, bodySerializeCopy, bodyDeserializeCopy, hver, src, dest, flow, nobuffer, replyexpected, htl, clazz, type, len, blen, numSubheaders, rrSubheader, fmcSubheader, fucSubheader, b, c, i, d);
    }

    private void testCreateDeserialization(PktPacket packet, int serializePolicy, int deserializePolicy, boolean hdrSerializeCopy, boolean hdrDeserializeCopy, boolean bodySerializeCopy, boolean bodyDeserializeCopy, short hver, int src, int dest, int flow, boolean nobuffer, boolean replyexpected, short htl, short clazz, int type, int len, int blen, short numSubheaders, PktBody rrSubheader, PktBody fmcSubheader, PktBody fucSubheader, byte b, char c, int i, double d, boolean repeat) throws Exception {
        this.testCreateSimpleDeserialize(packet, serializePolicy, deserializePolicy, hdrSerializeCopy, hdrDeserializeCopy, bodySerializeCopy, bodyDeserializeCopy, hver, src, dest, flow, nobuffer, replyexpected, htl, clazz, type, len, blen, numSubheaders, rrSubheader, fmcSubheader, fucSubheader, b, c, i, d);
        if (repeat) {
            this.testCreateRepeatDeserialize(packet, serializePolicy, deserializePolicy, hdrSerializeCopy, hdrDeserializeCopy, bodySerializeCopy, bodyDeserializeCopy, hver, src, dest, flow, nobuffer, replyexpected, htl, clazz, type, len, blen, numSubheaders, rrSubheader, fmcSubheader, fucSubheader, b, c, i, d);
        }
        this.testCreateDeserializeFromLarger(packet, serializePolicy, deserializePolicy, hdrSerializeCopy, hdrDeserializeCopy, bodySerializeCopy, bodyDeserializeCopy, hver, src, dest, flow, nobuffer, replyexpected, htl, clazz, type, len, blen, numSubheaders, rrSubheader, fmcSubheader, fucSubheader, b, c, i, d);
        this.testCreateDeserializeTwice(packet, serializePolicy, deserializePolicy, hdrSerializeCopy, hdrDeserializeCopy, bodySerializeCopy, bodyDeserializeCopy, hver, src, dest, flow, nobuffer, replyexpected, htl, clazz, type, len, blen, numSubheaders, rrSubheader, fmcSubheader, fucSubheader, b, c, i, d);
    }

    private void testCreateDeserialization(PktPacket packet, int serializePolicy, int deserializePolicy, boolean hdrSerializeCopy, boolean hdrDeserializeCopy, boolean bodySerializeCopy, boolean bodyDeserializeCopy, short hver, int type) throws Exception {
        PktHeader header = packet.getHeader();
        PktTestBodyVptfxb body = (PktTestBodyVptfxb)packet.getBody();
        int len = packet.getSerializedLength();
        int blen = len - packet.getHeader().getSerializedLength();
        this.testCreateDeserialization(packet, serializePolicy, deserializePolicy, hdrSerializeCopy, hdrDeserializeCopy, bodySerializeCopy, bodyDeserializeCopy, hver, 0, 0, 0, false, false, (short)255, (short)0, type, len, blen, (short)0, null, null, null, (byte)0, '\u0000', 0, 0.0, true);
        int newSrc = random.nextInt();
        header.setSrc(newSrc);
        len = packet.getSerializedLength();
        blen = len - packet.getHeader().getSerializedLength();
        this.testCreateDeserialization(packet, serializePolicy, deserializePolicy, hdrSerializeCopy, hdrDeserializeCopy, bodySerializeCopy, bodyDeserializeCopy, hver, newSrc, 0, 0, false, false, (short)255, (short)0, type, len, blen, (short)0, null, null, null, (byte)0, '\u0000', 0, 0.0, true);
        int newDest = random.nextInt();
        header.setDest(newDest);
        len = packet.getSerializedLength();
        blen = len - packet.getHeader().getSerializedLength();
        this.testCreateDeserialization(packet, serializePolicy, deserializePolicy, hdrSerializeCopy, hdrDeserializeCopy, bodySerializeCopy, bodyDeserializeCopy, hver, newSrc, newDest, 0, false, false, (short)255, (short)0, type, len, blen, (short)0, null, null, null, (byte)0, '\u0000', 0, 0.0, true);
        int newFlow = random.nextInt();
        header.setFlow(newFlow);
        len = packet.getSerializedLength();
        blen = len - packet.getHeader().getSerializedLength();
        this.testCreateDeserialization(packet, serializePolicy, deserializePolicy, hdrSerializeCopy, hdrDeserializeCopy, bodySerializeCopy, bodyDeserializeCopy, hver, newSrc, newDest, newFlow, false, false, (short)255, (short)0, type, len, blen, (short)0, null, null, null, (byte)0, '\u0000', 0, 0.0, true);
        boolean newNoBuffering = !header.getNoBuffering();
        header.setNoBuffering(newNoBuffering);
        len = packet.getSerializedLength();
        blen = len - packet.getHeader().getSerializedLength();
        this.testCreateDeserialization(packet, serializePolicy, deserializePolicy, hdrSerializeCopy, hdrDeserializeCopy, bodySerializeCopy, bodyDeserializeCopy, hver, newSrc, newDest, newFlow, newNoBuffering, false, (short)255, (short)0, type, len, blen, (short)0, null, null, null, (byte)0, '\u0000', 0, 0.0, true);
        boolean newReplyExpected = !header.getReplyExpected();
        header.setReplyExpected(newReplyExpected);
        len = packet.getSerializedLength();
        blen = len - packet.getHeader().getSerializedLength();
        this.testCreateDeserialization(packet, serializePolicy, deserializePolicy, hdrSerializeCopy, hdrDeserializeCopy, bodySerializeCopy, bodyDeserializeCopy, hver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, (short)255, (short)0, type, len, blen, (short)0, null, null, null, (byte)0, '\u0000', 0, 0.0, true);
        short newHtl = (short)random.nextInt(255);
        header.setHtl(newHtl);
        len = packet.getSerializedLength();
        blen = len - packet.getHeader().getSerializedLength();
        this.testCreateDeserialization(packet, serializePolicy, deserializePolicy, hdrSerializeCopy, hdrDeserializeCopy, bodySerializeCopy, bodyDeserializeCopy, hver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, (short)0, type, len, blen, (short)0, null, null, null, (byte)0, '\u0000', 0, 0.0, true);
        short newClazz = (short)random.nextInt(255);
        header.setClazz(newClazz);
        len = packet.getSerializedLength();
        blen = len - packet.getHeader().getSerializedLength();
        this.testCreateDeserialization(packet, serializePolicy, deserializePolicy, hdrSerializeCopy, hdrDeserializeCopy, bodySerializeCopy, bodyDeserializeCopy, hver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, len, blen, (short)0, null, null, null, (byte)0, '\u0000', 0, 0.0, true);
        PktSubheaderRR newRRSubheader = header.activateRRSubheader(false);
        len = packet.getSerializedLength();
        blen = len - packet.getHeader().getSerializedLength();
        this.testCreateDeserialization(packet, serializePolicy, deserializePolicy, hdrSerializeCopy, hdrDeserializeCopy, bodySerializeCopy, bodyDeserializeCopy, hver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, len, blen, (short)1, newRRSubheader, null, null, (byte)0, '\u0000', 0, 0.0, true);
        PktSubheaderFMC newFMCSubheader = header.activateFMCSubheader(false);
        len = packet.getSerializedLength();
        blen = len - packet.getHeader().getSerializedLength();
        this.testCreateDeserialization(packet, serializePolicy, deserializePolicy, hdrSerializeCopy, hdrDeserializeCopy, bodySerializeCopy, bodyDeserializeCopy, hver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, len, blen, (short)2, newRRSubheader, newFMCSubheader, null, (byte)0, '\u0000', 0, 0.0, true);
        PktSubheaderFUC newFUCSubheader = header.activateFUCSubheader(false);
        len = packet.getSerializedLength();
        blen = len - packet.getHeader().getSerializedLength();
        this.testCreateDeserialization(packet, serializePolicy, deserializePolicy, hdrSerializeCopy, hdrDeserializeCopy, bodySerializeCopy, bodyDeserializeCopy, hver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, len, blen, (short)3, newRRSubheader, newFMCSubheader, newFUCSubheader, (byte)0, '\u0000', 0, 0.0, true);
        header.deactivateRRSubheader();
        len = packet.getSerializedLength();
        blen = len - packet.getHeader().getSerializedLength();
        this.testCreateDeserialization(packet, serializePolicy, deserializePolicy, hdrSerializeCopy, hdrDeserializeCopy, bodySerializeCopy, bodyDeserializeCopy, hver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, len, blen, (short)2, null, newFMCSubheader, newFUCSubheader, (byte)0, '\u0000', 0, 0.0, true);
        header.deactivateFMCSubheader();
        len = packet.getSerializedLength();
        blen = len - packet.getHeader().getSerializedLength();
        this.testCreateDeserialization(packet, serializePolicy, deserializePolicy, hdrSerializeCopy, hdrDeserializeCopy, bodySerializeCopy, bodyDeserializeCopy, hver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, len, blen, (short)1, null, null, newFUCSubheader, (byte)0, '\u0000', 0, 0.0, true);
        header.deactivateFUCSubheader();
        len = packet.getSerializedLength();
        blen = len - packet.getHeader().getSerializedLength();
        this.testCreateDeserialization(packet, serializePolicy, deserializePolicy, hdrSerializeCopy, hdrDeserializeCopy, bodySerializeCopy, bodyDeserializeCopy, hver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, len, blen, (short)0, null, null, null, (byte)0, '\u0000', 0, 0.0, true);
        header.deactivateFUCSubheader();
        len = packet.getSerializedLength();
        blen = len - packet.getHeader().getSerializedLength();
        this.testCreateDeserialization(packet, serializePolicy, deserializePolicy, hdrSerializeCopy, hdrDeserializeCopy, bodySerializeCopy, bodyDeserializeCopy, hver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, len, blen, (short)0, null, null, null, (byte)0, '\u0000', 0, 0.0, true);
        header.deactivateFMCSubheader();
        len = packet.getSerializedLength();
        blen = len - packet.getHeader().getSerializedLength();
        this.testCreateDeserialization(packet, serializePolicy, deserializePolicy, hdrSerializeCopy, hdrDeserializeCopy, bodySerializeCopy, bodyDeserializeCopy, hver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, len, blen, (short)0, null, null, null, (byte)0, '\u0000', 0, 0.0, true);
        header.deactivateRRSubheader();
        len = packet.getSerializedLength();
        blen = len - packet.getHeader().getSerializedLength();
        this.testCreateDeserialization(packet, serializePolicy, deserializePolicy, hdrSerializeCopy, hdrDeserializeCopy, bodySerializeCopy, bodyDeserializeCopy, hver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, len, blen, (short)0, null, null, null, (byte)0, '\u0000', 0, 0.0, true);
        byte newByte = (byte)(random.nextInt(126) + 1);
        body.setByte(newByte);
        len = packet.getSerializedLength();
        blen = len - packet.getHeader().getSerializedLength();
        this.testCreateDeserialization(packet, serializePolicy, deserializePolicy, hdrSerializeCopy, hdrDeserializeCopy, bodySerializeCopy, bodyDeserializeCopy, hver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, len, blen, (short)0, null, null, null, newByte, '\u0000', 0, 0.0, true);
        char newChar = (char)(random.nextInt(65534) + 1);
        body.setChar(newChar);
        len = packet.getSerializedLength();
        blen = len - packet.getHeader().getSerializedLength();
        this.testCreateDeserialization(packet, serializePolicy, deserializePolicy, hdrSerializeCopy, hdrDeserializeCopy, bodySerializeCopy, bodyDeserializeCopy, hver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, len, blen, (short)0, null, null, null, newByte, newChar, 0, 0.0, true);
        int newInt = random.nextInt();
        body.setInt(newInt);
        len = packet.getSerializedLength();
        blen = len - packet.getHeader().getSerializedLength();
        this.testCreateDeserialization(packet, serializePolicy, deserializePolicy, hdrSerializeCopy, hdrDeserializeCopy, bodySerializeCopy, bodyDeserializeCopy, hver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, len, blen, (short)0, null, null, null, newByte, newChar, newInt, 0.0, true);
        double newDouble = random.nextDouble();
        body.setDouble(newDouble);
        len = packet.getSerializedLength();
        blen = len - packet.getHeader().getSerializedLength();
        this.testCreateDeserialization(packet, serializePolicy, deserializePolicy, hdrSerializeCopy, hdrDeserializeCopy, bodySerializeCopy, bodyDeserializeCopy, hver, newSrc, newDest, newFlow, newNoBuffering, newReplyExpected, newHtl, newClazz, type, len, blen, (short)0, null, null, null, newByte, newChar, newInt, newDouble, true);
    }

    @Test
    public void testCreate1() {
        String typeName = PktFactory.getInstance().getPacketTypeNameFromId(0);
        try {
            if (typeName.compareToIgnoreCase("invpt") == 0) {
                PktFactoryTest.testFailure((String)("Successfully got type name [" + typeName + "] for invalid type id [" + 0 + "]!"));
            }
            PktFactoryTest.testSuccess((String)"Successfully failed to get type name for invalid type id [0]");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate2() {
        try {
            PktFactory.getInstance().createPacketBody(0);
            PktFactoryTest.testFailure((String)"0 passed as a valid packet type id!");
        }
        catch (EPktTypeInvalidException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate3() {
        try {
            PktFactory.getInstance().createPacketBody("invpt");
            PktFactoryTest.testFailure((String)"'invpt' passed as a valid packet type name!");
        }
        catch (EPktTypeInvalidException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate4() {
        try {
            PktFactory.getInstance().createPacket(0);
            PktFactoryTest.testFailure((String)"0 passed as a valid packet type id!");
        }
        catch (EPktTypeInvalidException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate5() {
        try {
            PktFactory.getInstance().createPacket("invpt");
            PktFactoryTest.testFailure((String)"'invpt' passed as a valid packet type name!");
        }
        catch (EPktTypeInvalidException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate6() {
        String typeName = PktFactory.getInstance().getPacketTypeNameFromId(0);
        try {
            if (typeName.compareToIgnoreCase("vpt0") == 0) {
                PktFactoryTest.testFailure((String)("Successfully got type name [" + typeName + "] for invalid type id [" + 0 + "]!"));
            }
            PktFactoryTest.testSuccess((String)"Successfully failed to get type name for invalid type id [0]");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate7() {
        try {
            PktFactory.getInstance().createPacketBody(0);
            PktFactoryTest.testFailure((String)"0 passed as a valid packet type id!");
        }
        catch (EPktTypeInvalidException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate8() {
        try {
            PktFactory.getInstance().createPacketBody("vpt0");
            PktFactoryTest.testFailure((String)"'vpt0' passed as a valid packet type name!");
        }
        catch (EPktTypeInvalidException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate9() {
        try {
            PktFactory.getInstance().createPacket(0);
            PktFactoryTest.testFailure((String)"0 passed as a valid packet type id!");
        }
        catch (EPktTypeInvalidException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate10() {
        try {
            PktFactory.getInstance().createPacket("vpt0");
            PktFactoryTest.testFailure((String)"'vpt0' passed as a valid packet type name!");
        }
        catch (EPktTypeInvalidException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate11() {
        String typeName = PktFactory.getInstance().getPacketTypeNameFromId(901);
        try {
            if (typeName.compareToIgnoreCase("vpt1") == 0) {
                PktFactoryTest.testFailure((String)("Successfully got type name [" + typeName + "] for invalid type id [" + 901 + "]!"));
            }
            PktFactoryTest.testSuccess((String)"Successfully failed to get type name for invalid type id [901]");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate12() {
        try {
            PktFactory.getInstance().createPacketBody(901);
            PktFactoryTest.testFailure((String)"901 passed as a valid packet type id!");
        }
        catch (EPktTypeInvalidException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate13() {
        try {
            PktFactory.getInstance().createPacketBody("vpt1");
            PktFactoryTest.testFailure((String)"'vpt1' passed as a valid packet type name!");
        }
        catch (EPktTypeInvalidException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate14() {
        try {
            PktFactory.getInstance().createPacket(901);
            PktFactoryTest.testFailure((String)"901 passed as a valid packet type id!");
        }
        catch (EPktTypeInvalidException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate15() {
        try {
            PktFactory.getInstance().createPacket("vpt1");
            PktFactoryTest.testFailure((String)"'vpt1' passed as a valid packet type name!");
        }
        catch (EPktTypeInvalidException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate16() {
        String typeName = PktFactory.getInstance().getPacketTypeNameFromId(902);
        try {
            if (typeName.compareToIgnoreCase("vpt2") == 0) {
                PktFactoryTest.testFailure((String)("Successfully got type name [" + typeName + "] for invalid type id [" + 902 + "]!"));
            }
            PktFactoryTest.testSuccess((String)"Successfully failed to get type name for invalid type id [902]");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate17() {
        try {
            PktFactory.getInstance().createPacketBody(902);
            PktFactoryTest.testFailure((String)"902 passed as a valid packet type id!");
        }
        catch (EPktTypeInvalidException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate18() {
        try {
            PktFactory.getInstance().createPacketBody("vpt2");
            PktFactoryTest.testFailure((String)"'vpt2' passed as a valid packet type name!");
        }
        catch (EPktTypeInvalidException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate19() {
        try {
            PktFactory.getInstance().createPacket(902);
            PktFactoryTest.testFailure((String)"902 passed as a valid packet type id!");
        }
        catch (EPktTypeInvalidException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate20() {
        try {
            PktFactory.getInstance().createPacket("vpt2");
            PktFactoryTest.testFailure((String)"'vpt2' passed as a valid packet type name!");
        }
        catch (EPktTypeInvalidException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate21() {
        String typeName = PktFactory.getInstance().getPacketTypeNameFromId(903);
        try {
            if (typeName.compareToIgnoreCase("vpt3") == 0) {
                PktFactoryTest.testFailure((String)("Successfully got type name [" + typeName + "] for invalid type id [" + 903 + "]!"));
            }
            PktFactoryTest.testSuccess((String)"Successfully failed to get type name for invalid type id [903]");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate22() {
        try {
            PktFactory.getInstance().createPacketBody(903);
            PktFactoryTest.testFailure((String)"903 passed as a valid packet type id!");
        }
        catch (EPktTypeInvalidException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate23() {
        try {
            PktFactory.getInstance().createPacketBody("vpt3");
            PktFactoryTest.testFailure((String)"'vpt3' passed as a valid packet type name!");
        }
        catch (EPktTypeInvalidException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate24() {
        try {
            PktFactory.getInstance().createPacket(903);
            PktFactoryTest.testFailure((String)"903 passed as a valid packet type id!");
        }
        catch (EPktTypeInvalidException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate25() {
        try {
            PktFactory.getInstance().createPacket("vpt3");
            PktFactoryTest.testFailure((String)"'vpt3' passed as a valid packet type name!");
        }
        catch (EPktTypeInvalidException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate26() {
        String typeName = PktFactory.getInstance().getPacketTypeNameFromId(904);
        try {
            if (typeName.compareToIgnoreCase("vpt4") == 0) {
                PktFactoryTest.testFailure((String)("Successfully got type name [" + typeName + "] for invalid type id [" + 904 + "]!"));
            }
            PktFactoryTest.testSuccess((String)"Successfully failed to get type name for invalid type id [904]");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate27() {
        try {
            PktFactory.getInstance().createPacketBody(904);
            PktFactoryTest.testFailure((String)"904 passed as a valid packet type id!");
        }
        catch (EPktTypeInvalidException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate28() {
        try {
            PktFactory.getInstance().createPacketBody("vpt4");
            PktFactoryTest.testFailure((String)"'vpt4' passed as a valid packet type name!");
        }
        catch (EPktTypeInvalidException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate29() {
        try {
            PktFactory.getInstance().createPacket(904);
            PktFactoryTest.testFailure((String)"904 passed as a valid packet type id!");
        }
        catch (EPktTypeInvalidException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate30() {
        try {
            PktFactory.getInstance().createPacket("vpt4");
            PktFactoryTest.testFailure((String)"'vpt4' passed as a valid packet type name!");
        }
        catch (EPktTypeInvalidException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate31() {
        String typeName = PktFactory.getInstance().getPacketTypeNameFromId(905);
        try {
            if (typeName.compareToIgnoreCase("vpt5") == 0) {
                PktFactoryTest.testSuccess((String)("Successfully got type name [" + typeName + "] for type id [" + 905 + "]"));
            } else {
                PktFactoryTest.testFailure((String)("Got invalid type name [" + typeName + "] for type id [" + 905 + "]!"));
            }
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate32() {
        try {
            PktFactory.getInstance().createPacketBody(905);
            PktFactoryTest.testFailure((String)"905 passed as a valid packet type id!");
        }
        catch (EPktBodyClassLoadException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate33() {
        try {
            PktFactory.getInstance().createPacketBody("vpt5");
            PktFactoryTest.testFailure((String)"'vpt5' passed as a valid packet type name!");
        }
        catch (EPktBodyClassLoadException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate34() {
        try {
            PktFactory.getInstance().createPacket(905);
            PktFactoryTest.testFailure((String)"905 passed as a valid packet type id!");
        }
        catch (EPktBodyClassLoadException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate35() {
        try {
            PktFactory.getInstance().createPacket("vpt5");
            PktFactoryTest.testFailure((String)"'vpt5' passed as a valid packet type name!");
        }
        catch (EPktBodyClassLoadException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate36() {
        String typeName = PktFactory.getInstance().getPacketTypeNameFromId(906);
        try {
            if (typeName.compareToIgnoreCase("vpt6") == 0) {
                PktFactoryTest.testSuccess((String)("Successfully got type name [" + typeName + "] for type id [" + 906 + "]"));
            } else {
                PktFactoryTest.testFailure((String)("Got invalid type name [" + typeName + "] for type id [" + 906 + "]!"));
            }
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate37() {
        try {
            PktFactory.getInstance().createPacketBody(906);
            PktFactoryTest.testFailure((String)"906 passed as a valid packet type id!");
        }
        catch (EPktBodyClassInstantiateException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate38() {
        try {
            PktFactory.getInstance().createPacketBody("vpt6");
            PktFactoryTest.testFailure((String)"'vpt6' passed as a valid packet type name!");
        }
        catch (EPktBodyClassInstantiateException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate39() {
        try {
            PktFactory.getInstance().createPacket(906);
            PktFactoryTest.testFailure((String)"906 passed as a valid packet type id!");
        }
        catch (EPktBodyClassInstantiateException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate40() {
        try {
            PktFactory.getInstance().createPacket("vpt6");
            PktFactoryTest.testFailure((String)"'vpt6' passed as a valid packet type name!");
        }
        catch (EPktBodyClassInstantiateException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate41() {
        String typeName = PktFactory.getInstance().getPacketTypeNameFromId(907);
        try {
            if (typeName.compareToIgnoreCase("vpt7") == 0) {
                PktFactoryTest.testSuccess((String)("Successfully got type name [" + typeName + "] for type id [" + 907 + "]"));
            } else {
                PktFactoryTest.testFailure((String)("Got invalid type name [" + typeName + "] for type id [" + 907 + "]!"));
            }
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate42() {
        try {
            PktFactory.getInstance().createPacketBody(907);
            PktFactoryTest.testFailure((String)"907 passed as a valid packet type id!");
        }
        catch (EPktBodyClassInstantiateException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate43() {
        try {
            PktFactory.getInstance().createPacketBody("vpt7");
            PktFactoryTest.testFailure((String)"'vpt7' passed as a valid packet type name!");
        }
        catch (EPktBodyClassInstantiateException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate44() {
        try {
            PktFactory.getInstance().createPacket(907);
            PktFactoryTest.testFailure((String)"907 passed as a valid packet type id!");
        }
        catch (EPktBodyClassInstantiateException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate45() {
        try {
            PktFactory.getInstance().createPacket("vpt7");
            PktFactoryTest.testFailure((String)"'vpt7' passed as a valid packet type name!");
        }
        catch (EPktBodyClassInstantiateException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate46() {
        String typeName = PktFactory.getInstance().getPacketTypeNameFromId(908);
        try {
            if (typeName.compareToIgnoreCase("vpt8") == 0) {
                PktFactoryTest.testSuccess((String)("Successfully got type name [" + typeName + "] for type id [" + 908 + "]"));
            } else {
                PktFactoryTest.testFailure((String)("Got invalid type name [" + typeName + "] for type id [" + 908 + "]!"));
            }
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate47() {
        try {
            PktFactory.getInstance().createPacketBody(908);
            PktFactoryTest.testFailure((String)"908 passed as a valid packet type id!");
        }
        catch (EPktBodyClassInstantiateException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate48() {
        try {
            PktFactory.getInstance().createPacketBody("vpt8");
            PktFactoryTest.testFailure((String)"'vpt8' passed as a valid packet type name!");
        }
        catch (EPktBodyClassInstantiateException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate49() {
        try {
            PktFactory.getInstance().createPacket(908);
            PktFactoryTest.testFailure((String)"908 passed as a valid packet type id!");
        }
        catch (EPktBodyClassInstantiateException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate50() {
        try {
            PktFactory.getInstance().createPacket("vpt8");
            PktFactoryTest.testFailure((String)"'vpt8' passed as a valid packet type name!");
        }
        catch (EPktBodyClassInstantiateException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate51() {
        String typeName = PktFactory.getInstance().getPacketTypeNameFromId(909);
        try {
            if (typeName.compareToIgnoreCase("vpt9") == 0) {
                PktFactoryTest.testSuccess((String)("Successfully got type name [" + typeName + "] for type id [" + 909 + "]"));
            } else {
                PktFactoryTest.testFailure((String)("Got invalid type name [" + typeName + "] for type id [" + 909 + "]!"));
            }
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate52() {
        try {
            PktFactory.getInstance().createPacketBody(909);
            PktFactoryTest.testFailure((String)"909 passed as a valid packet type id!");
        }
        catch (EPktBodyClassInstantiateException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate53() {
        try {
            PktFactory.getInstance().createPacketBody("vpt9");
            PktFactoryTest.testFailure((String)"'vpt9' passed as a valid packet type name!");
        }
        catch (EPktBodyClassInstantiateException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate54() {
        try {
            PktFactory.getInstance().createPacket(909);
            PktFactoryTest.testFailure((String)"909 passed as a valid packet type id!");
        }
        catch (EPktBodyClassInstantiateException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate55() {
        try {
            PktFactory.getInstance().createPacket("vpt9");
            PktFactoryTest.testFailure((String)"'vpt9' passed as a valid packet type name!");
        }
        catch (EPktBodyClassInstantiateException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate56() {
        String typeName = PktFactory.getInstance().getPacketTypeNameFromId(910);
        try {
            if (typeName.compareToIgnoreCase("vpt10") == 0) {
                PktFactoryTest.testSuccess((String)("Successfully got type name [" + typeName + "] for type id [" + 910 + "]"));
            } else {
                PktFactoryTest.testFailure((String)("Got invalid type name [" + typeName + "] for type id [" + 910 + "]!"));
            }
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate57() {
        try {
            PktFactory.getInstance().createPacketBody(910);
            PktFactoryTest.testFailure((String)"910 passed as a valid packet type id!");
        }
        catch (EPktBodyClassInstantiateException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate58() {
        try {
            PktFactory.getInstance().createPacketBody("vpt10");
            PktFactoryTest.testFailure((String)"'vpt10' passed as a valid packet type name!");
        }
        catch (EPktBodyClassInstantiateException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate59() {
        try {
            PktFactory.getInstance().createPacket(910);
            PktFactoryTest.testFailure((String)"910 passed as a valid packet type id!");
        }
        catch (EPktBodyClassInstantiateException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate60() {
        try {
            PktFactory.getInstance().createPacket("vpt10");
            PktFactoryTest.testFailure((String)"'vpt10' passed as a valid packet type name!");
        }
        catch (EPktBodyClassInstantiateException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate61() {
        String typeName = PktFactory.getInstance().getPacketTypeNameFromId(911);
        try {
            if (typeName.compareToIgnoreCase("vpt11") == 0) {
                PktFactoryTest.testSuccess((String)("Successfully got type name [" + typeName + "] for type id [" + 911 + "]"));
            } else {
                PktFactoryTest.testFailure((String)("Got invalid type name [" + typeName + "] for type id [" + 911 + "]!"));
            }
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate62() {
        try {
            PktFactory.getInstance().createPacketBody(911);
            PktFactoryTest.testFailure((String)"911 passed as a valid packet type id!");
        }
        catch (EPktBodyClassInstantiateException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate63() {
        try {
            PktFactory.getInstance().createPacketBody("vpt11");
            PktFactoryTest.testFailure((String)"'vpt11' passed as a valid packet type name!");
        }
        catch (EPktBodyClassInstantiateException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate64() {
        try {
            PktFactory.getInstance().createPacket(911);
            PktFactoryTest.testFailure((String)"911 passed as a valid packet type id!");
        }
        catch (EPktBodyClassInstantiateException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate65() {
        try {
            PktFactory.getInstance().createPacket("vpt11");
            PktFactoryTest.testFailure((String)"'vpt11' passed as a valid packet type name!");
        }
        catch (EPktBodyClassInstantiateException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate66() {
        String typeName = PktFactory.getInstance().getPacketTypeNameFromId(912);
        try {
            if (typeName.compareToIgnoreCase("vpt12") == 0) {
                PktFactoryTest.testSuccess((String)("Successfully got type name [" + typeName + "] for type id [" + 912 + "]"));
            } else {
                PktFactoryTest.testFailure((String)("Got invalid type name [" + typeName + "] for type id [" + 912 + "]!"));
            }
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate67() {
        try {
            PktBody pktBody = PktFactory.getInstance().createPacketBody(912);
            PktTestHelper.checkCreatedPacketBody(912, pktBody);
            PktFactoryTest.testSuccess((String)"Successfully instantiated packet body using packet type id [912]");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate68() {
        try {
            PktBody pktBody = PktFactory.getInstance().createPacketBody("vpt12");
            PktTestHelper.checkCreatedPacketBody(912, pktBody);
            PktFactoryTest.testSuccess((String)"Successfully instantiated packet body using packet type name [vpt12]");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate69() {
        try {
            PktPacket pktPacket = PktFactory.getInstance().createPacket(912);
            PktTestHelper.checkCreatedPacket(912, pktPacket);
            PktFactoryTest.testSuccess((String)"Successfully instantiated packet using packet type id [912]");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate70() {
        try {
            PktPacket pktPacket = PktFactory.getInstance().createPacket("vpt12");
            PktTestHelper.checkCreatedPacket(912, pktPacket);
            PktFactoryTest.testSuccess((String)"Successfully instantiated packet using packet type name [vpt12]");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate71() {
        try {
            PktHeader pktHeader = PktFactory.getInstance().createPacket(912).getHeader();
            PktBody pktBody = PktFactory.getInstance().createPacketBody(912);
            PktTestHelper.checkCreatedPacketBody(912, pktBody);
            PktFactoryTest.testSuccess((String)"Successfully instantiated packet body using packet type id [912]");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate72() {
        try {
            PktHeader pktHeader = PktFactory.getInstance().createPacket(912).getHeader();
            PktBody pktBody = PktFactory.getInstance().createPacketBody("vpt12");
            PktTestHelper.checkCreatedPacketBody(912, pktBody);
            PktFactoryTest.testSuccess((String)"Successfully instantiated packet body using packet type name [vpt12]");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate73() {
        try {
            PktTestHelper.checkPoliciesInPacketBody(PktFactory.getInstance().createPacketBody(912), 1, 1);
            PktFactoryTest.testSuccess((String)"Serialization/deserialization policies for instantiated packet body [type id =912] are correct.");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate74() {
        try {
            PktTestHelper.checkPoliciesInPacket(PktFactory.getInstance().createPacket(912), 1, 1);
            PktFactoryTest.testSuccess((String)"Serialization/deserialization policies for instantiated packet [type id =912] are correct.");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate75() {
        try {
            PktTestHelper.checkPoliciesInPacketBody(PktFactory.getInstance().createPacketBody(913), 1, 1);
            PktFactoryTest.testSuccess((String)"Serialization/deserialization policies for instantiated packet body [type id =913] are correct.");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate76() {
        try {
            PktTestHelper.checkPoliciesInPacket(PktFactory.getInstance().createPacket(913), 1, 1);
            PktFactoryTest.testSuccess((String)"Serialization/deserialization policies for instantiated packet [type id =913] are correct.");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate77() {
        try {
            PktTestHelper.checkPoliciesInPacketBody(PktFactory.getInstance().createPacketBody(922), 1, 1);
            PktFactoryTest.testSuccess((String)"Serialization/deserialization policies for instantiated packet body [type id =922] are correct.");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate78() {
        try {
            PktTestHelper.checkPoliciesInPacket(PktFactory.getInstance().createPacket(922), 1, 1);
            PktFactoryTest.testSuccess((String)"Serialization/deserialization policies for instantiated packet [type id =922] are correct.");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate79() {
        try {
            PktTestHelper.checkPoliciesInPacketBody(PktFactory.getInstance().createPacketBody(914), 1, 1);
            PktFactoryTest.testSuccess((String)"Serialization/deserialization policies for instantiated packet body [type id =914] are correct.");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate80() {
        try {
            PktTestHelper.checkPoliciesInPacket(PktFactory.getInstance().createPacket(914), 1, 1);
            PktFactoryTest.testSuccess((String)"Serialization/deserialization policies for instantiated packet [type id =914] are correct.");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate81() {
        try {
            PktTestHelper.checkPoliciesInPacketBody(PktFactory.getInstance().createPacketBody(915), 2, 1);
            PktFactoryTest.testSuccess((String)"Serialization/deserialization policies for instantiated packet body [type id =915] are correct.");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate82() {
        try {
            PktTestHelper.checkPoliciesInPacket(PktFactory.getInstance().createPacket(915), 2, 1);
            PktFactoryTest.testSuccess((String)"Serialization/deserialization policies for instantiated packet [type id =915] are correct.");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate83() {
        try {
            PktTestHelper.checkPoliciesInPacketBody(PktFactory.getInstance().createPacketBody(916), 3, 1);
            PktFactoryTest.testSuccess((String)"Serialization/deserialization policies for instantiated packet body [type id =916] are correct.");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate84() {
        try {
            PktTestHelper.checkPoliciesInPacket(PktFactory.getInstance().createPacket(916), 3, 1);
            PktFactoryTest.testSuccess((String)"Serialization/deserialization policies for instantiated packet [type id =916] are correct.");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate85() {
        try {
            PktTestHelper.checkPoliciesInPacketBody(PktFactory.getInstance().createPacketBody(917), 1, 1);
            PktFactoryTest.testSuccess((String)"Serialization/deserialization policies for instantiated packet body [type id =917] are correct.");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate86() {
        try {
            PktTestHelper.checkPoliciesInPacket(PktFactory.getInstance().createPacket(917), 1, 1);
            PktFactoryTest.testSuccess((String)"Serialization/deserialization policies for instantiated packet [type id =917] are correct.");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate87() {
        try {
            PktTestHelper.checkPoliciesInPacketBody(PktFactory.getInstance().createPacketBody(923), 1, 1);
            PktFactoryTest.testSuccess((String)"Serialization/deserialization policies for instantiated packet body [type id =923] are correct.");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate88() {
        try {
            PktTestHelper.checkPoliciesInPacket(PktFactory.getInstance().createPacket(923), 1, 1);
            PktFactoryTest.testSuccess((String)"Serialization/deserialization policies for instantiated packet [type id =923] are correct.");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate89() {
        try {
            PktTestHelper.checkPoliciesInPacketBody(PktFactory.getInstance().createPacketBody(918), 1, 1);
            PktFactoryTest.testSuccess((String)"Serialization/deserialization policies for instantiated packet body [type id =918] are correct.");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate90() {
        try {
            PktTestHelper.checkPoliciesInPacket(PktFactory.getInstance().createPacket(918), 1, 1);
            PktFactoryTest.testSuccess((String)"Serialization/deserialization policies for instantiated packet [type id =918] are correct.");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate91() {
        try {
            PktTestHelper.checkPoliciesInPacketBody(PktFactory.getInstance().createPacketBody(919), 1, 2);
            PktFactoryTest.testSuccess((String)"Serialization/deserialization policies for instantiated packet body [type id =919] are correct.");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate92() {
        try {
            PktTestHelper.checkPoliciesInPacket(PktFactory.getInstance().createPacket(919), 1, 2);
            PktFactoryTest.testSuccess((String)"Serialization/deserialization policies for instantiated packet [type id =919] are correct.");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate93() {
        try {
            PktTestHelper.checkPoliciesInPacketBody(PktFactory.getInstance().createPacketBody(920), 1, 3);
            PktFactoryTest.testSuccess((String)"Serialization/deserialization policies for instantiated packet body [type id =920] are correct.");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate94() {
        try {
            PktTestHelper.checkPoliciesInPacket(PktFactory.getInstance().createPacket(920), 1, 3);
            PktFactoryTest.testSuccess((String)"Serialization/deserialization policies for instantiated packet [type id =920] are correct.");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate95() {
        String typeName = PktFactory.getInstance().getPacketTypeNameFromId(0);
        try {
            if (typeName.compareToIgnoreCase("vpt21") == 0) {
                PktFactoryTest.testFailure((String)("Successfully got type name [" + typeName + "] for invalid type id [" + 0 + "]!"));
            }
            PktFactoryTest.testSuccess((String)"Successfully failed to get type name for invalid type id [0]");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate96() {
        try {
            PktFactory.getInstance().createPacketBody(0);
            PktFactoryTest.testFailure((String)"0 passed as a valid packet type id!");
        }
        catch (EPktTypeInvalidException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate97() {
        try {
            PktFactory.getInstance().createPacketBody("vpt21");
            PktFactoryTest.testFailure((String)"'vpt21' passed as a valid packet type name!");
        }
        catch (EPktTypeInvalidException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate98() {
        try {
            PktFactory.getInstance().createPacket(0);
            PktFactoryTest.testFailure((String)"0 passed as a valid packet type id!");
        }
        catch (EPktTypeInvalidException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreate99() {
        try {
            PktFactory.getInstance().createPacket("vpt21");
            PktFactoryTest.testFailure((String)"'vpt21' passed as a valid packet type name!");
        }
        catch (EPktTypeInvalidException e) {
            PktFactoryTest.testSuccess((String)e.getMessage());
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateZeroLenBuffer() {
        try {
            PktSerializable.DeserializeContext context = PktSerializable.DeserializeContext.create().setBuffer(ByteBuffer.allocate(0));
            if (PktFactory.getInstance().createPacket(context) != null) {
                PktFactoryTest.testFailure((String)"Packet creation using a zero len buffer returned non-null value!");
            }
            if (context.getNumBytes() <= 0) {
                PktFactoryTest.testFailure((String)("Invalid numBytes in context [exp=(>0) actual=" + context.getNumBytes() + "] from packet creation from a zero len buffer"));
            }
            PktFactoryTest.testSuccess((String)("Packet creation from a zero length buffer returned null and requested " + context.getNumBytes() + " additional bytes"));
            PktFactoryTest.testSuccess((String)"Packet creation from a zero length buffer is working fine.");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateWithInvalidMagic() {
        try {
            PktPacket packet = PktFactory.getInstance().createPacket("vptfxb5");
            this.testCreateWithInvalidMagic(packet);
            PktFactoryTest.testSuccess((String)"Packet creation magic check is working fine.");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateWithInvalidVersion() {
        try {
            PktPacket packet = PktFactory.getInstance().createPacket("vptfxb5");
            this.testCreateWithInvalidVersion(packet);
            PktFactoryTest.testSuccess((String)"Packet creation version check is working fine.");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateWithLessMinLenBuffer() {
        try {
            PktPacket packet = PktFactory.getInstance().createPacket("vptfxb5");
            this.testCreateWithLessMinLenBuffer(packet);
            PktFactoryTest.testSuccess((String)"Packet creation min len buffer length check is working fine.");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateWithLessOrEqualLenBuffer() {
        try {
            PktPacket packet = PktFactory.getInstance().createPacket("vptfxb5");
            this.testCreateWithLessOrEqualLenBuffer(packet);
            PktFactoryTest.testSuccess((String)"Packet creation serialized length check is working fine.");
        }
        catch (Exception e) {
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateDeserialization1() {
        try {
            PktPacket packet = PktFactory.getInstance().createPacket(3005);
            this.testCreateDeserialization(packet, 1, 0, true, true, true, true, PktHeader.getLatestVersion(), 3005);
            PktFactoryTest.testSuccess((String)"Packet deserialization, body=VPTFXB5, 'default' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateDeserialization2() {
        try {
            PktPacket packet = PktFactory.getInstance().createPacket(3005);
            this.testCreateDeserialization(packet, 1, 1, true, true, true, true, PktHeader.getLatestVersion(), 3005);
            PktFactoryTest.testSuccess((String)"Packet deserialization, body=VPTFXB5, 'hdrbodycopy' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Ignore
    @Test
    public void testCreateDeserialization3() {
        try {
            PktPacket packet = PktFactory.getInstance().createPacket(3005);
            this.testCreateDeserialization(packet, 1, 2, true, true, true, false, PktHeader.getLatestVersion(), 3005);
            PktFactoryTest.testSuccess((String)"Packet deserialization, body=VPTFXB5, 'hdrcopybodyslice' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Ignore
    @Test
    public void testCreateDeserialization4() {
        try {
            PktPacket packet = PktFactory.getInstance().createPacket(3005);
            this.testCreateDeserialization(packet, 1, 3, true, false, true, false, PktHeader.getLatestVersion(), 3005);
            PktFactoryTest.testSuccess((String)"Packet deserialization, body=VPTFXB5, 'hdrbodyslice' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateDeserialization5() {
        try {
            PktPacket packet = PktFactory.getInstance().createPacket(3006);
            this.testCreateDeserialization(packet, 1, 0, true, true, true, true, PktHeader.getLatestVersion(), 3006);
            PktFactoryTest.testSuccess((String)"Packet deserialization, body=VPTFXB6, 'default' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateDeserialization6() {
        try {
            PktPacket packet = PktFactory.getInstance().createPacket(3006);
            this.testCreateDeserialization(packet, 1, 1, true, true, true, true, PktHeader.getLatestVersion(), 3006);
            PktFactoryTest.testSuccess((String)"Packet deserialization, body=VPTFXB6, 'hdrbodycopy' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Ignore
    @Test
    public void testCreateDeserialization7() {
        try {
            PktPacket packet = PktFactory.getInstance().createPacket(3006);
            this.testCreateDeserialization(packet, 1, 2, true, true, true, false, PktHeader.getLatestVersion(), 3006);
            PktFactoryTest.testSuccess((String)"Packet deserialization, body=VPTFXB6, 'hdrcopybodyslice' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Ignore
    @Test
    public void testCreateDeserialization8() {
        try {
            PktPacket packet = PktFactory.getInstance().createPacket(3006);
            this.testCreateDeserialization(packet, 1, 3, true, false, true, false, PktHeader.getLatestVersion(), 3006);
            PktFactoryTest.testSuccess((String)"Packet deserialization, body=VPTFXB6, 'hdrbodyslice' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Ignore
    @Test
    public void testCreateDeserialization9() {
        try {
            PktPacket packet = PktFactory.getInstance().createPacket(3007);
            this.testCreateDeserialization(packet, 1, 0, true, true, true, false, PktHeader.getLatestVersion(), 3007);
            PktFactoryTest.testSuccess((String)"Packet deserialization, body=VPTFXB7, 'default' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateDeserialization10() {
        try {
            PktPacket packet = PktFactory.getInstance().createPacket(3007);
            this.testCreateDeserialization(packet, 1, 1, true, true, true, true, PktHeader.getLatestVersion(), 3007);
            PktFactoryTest.testSuccess((String)"Packet deserialization, body=VPTFXB7, 'hdrbodycopy' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Ignore
    @Test
    public void testCreateDeserialization11() {
        try {
            PktPacket packet = PktFactory.getInstance().createPacket(3007);
            this.testCreateDeserialization(packet, 1, 2, true, true, true, false, PktHeader.getLatestVersion(), 3007);
            PktFactoryTest.testSuccess((String)"Packet deserialization, body=VPTFXB7, 'hdrcopybodyslice' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Ignore
    @Test
    public void testCreateDeserialization12() {
        try {
            PktPacket packet = PktFactory.getInstance().createPacket(3007);
            this.testCreateDeserialization(packet, 1, 3, true, false, true, false, PktHeader.getLatestVersion(), 3007);
            PktFactoryTest.testSuccess((String)"Packet deserialization, body=VPTFXB7, 'hdrbodyslice' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Ignore
    @Test
    public void testCreateDeserialization13() {
        try {
            PktPacket packet = PktFactory.getInstance().createPacket(3008);
            this.testCreateDeserialization(packet, 1, 0, true, false, true, false, PktHeader.getLatestVersion(), 3008);
            PktFactoryTest.testSuccess((String)"Packet deserialization, body=VPTFXB8, 'default' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateDeserialization14() {
        try {
            PktPacket packet = PktFactory.getInstance().createPacket(3008);
            this.testCreateDeserialization(packet, 1, 1, true, true, true, true, PktHeader.getLatestVersion(), 3008);
            PktFactoryTest.testSuccess((String)"Packet deserialization, body=VPTFXB8, 'hdrbodycopy' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Ignore
    @Test
    public void testCreateDeserialization15() {
        try {
            PktPacket packet = PktFactory.getInstance().createPacket(3008);
            this.testCreateDeserialization(packet, 1, 2, true, true, true, false, PktHeader.getLatestVersion(), 3008);
            PktFactoryTest.testSuccess((String)"Packet deserialization, body=VPTFXB8, 'hdrcopybodyslice' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Ignore
    @Test
    public void testCreateDeserialization16() {
        try {
            PktPacket packet = PktFactory.getInstance().createPacket(3008);
            this.testCreateDeserialization(packet, 1, 3, true, false, true, false, PktHeader.getLatestVersion(), 3008);
            PktFactoryTest.testSuccess((String)"Packet deserialization, body=VPTFXB8, 'hdrbodyslice' deserialization policy is working fine.");
        }
        catch (Exception e) {
            e.printStackTrace();
            PktFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }
}

