/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util;

import com.neeve.NativeKernel;
import com.neeve.util.UtlEnv;
import com.neeve.util.UtlUnit;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.compress.utils.IOUtils;

public final class UtlFile {
    private static final String userHome = System.getProperty("user.home");
    private static final File userHomeDir;
    public static final String FILE_USENATIVE_PROPNAME = "nv.file.usenative";
    private static final boolean USE_NATIVE;

    public static final boolean isNativeFileIOEnabled() {
        return USE_NATIVE;
    }

    public static final native long nativeWrap(int var0) throws Exception;

    public static final native long nativeWrite(long var0, ByteBuffer[] var2, int var3) throws Exception;

    public static final native void nativeDestroy(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copyFile(File source, File dest) throws IOException {
        if (!dest.exists() || dest.lastModified() < source.lastModified()) {
            if (dest.exists()) {
                dest.delete();
            }
            if (dest.createNewFile()) {
                dest.setLastModified(source.lastModified());
                FileInputStream fis = null;
                FileOutputStream fos = null;
                byte[] buffer = new byte[8192];
                try {
                    int bytesRead;
                    fis = new FileInputStream(source);
                    fos = new FileOutputStream(dest);
                    while ((bytesRead = fis.read(buffer)) >= 0) {
                        fos.write(buffer, 0, bytesRead);
                    }
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            throw new IOException("Failed to create file in workspace [file='" + source.getPath() + "']");
        }
    }

    public static final void copyFileWithNamespaceToDirectory(File source, File destination, String namespace, String nameWithExtension) throws IOException {
        File destWithNamespace = UtlFile.newDirWithNamespace(destination, namespace);
        if (!destWithNamespace.exists()) {
            destWithNamespace.mkdirs();
        }
        File destFile = UtlFile.newFileWithNamespace(destWithNamespace, null, nameWithExtension);
        UtlFile.copyFile(source, destFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copyFile(File source, File dest, Properties replacementMap) throws IOException {
        if (dest.exists()) {
            dest.delete();
        }
        if (dest.createNewFile()) {
            HashMap<Pattern, String> patternMap = new HashMap<Pattern, String>();
            for (String key : replacementMap.stringPropertyNames()) {
                patternMap.put(Pattern.compile("@{" + key + "}", 16), Matcher.quoteReplacement(replacementMap.getProperty(key)));
            }
            BufferedReader reader = null;
            BufferedWriter writer = null;
            try {
                String s;
                reader = new BufferedReader(new FileReader(source));
                writer = new BufferedWriter(new FileWriter(dest));
                while ((s = reader.readLine()) != null) {
                    for (Pattern pattern : patternMap.keySet()) {
                        s = pattern.matcher(s).replaceAll((String)patternMap.get(pattern));
                    }
                    writer.write(s, 0, s.length());
                    writer.newLine();
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                }
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        throw new IOException("Failed to create file in workspace [file='" + source.getPath() + "']");
    }

    public static final File copyToTempFile(InputStream is) throws IOException {
        File tmpFile = File.createTempFile("xmd", "xml");
        tmpFile.deleteOnExit();
        UtlFile.copyToFile(is, tmpFile);
        return tmpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copyToFile(InputStream is, File target) throws IOException {
        if (!target.exists()) {
            if (!target.getParentFile().exists()) {
                target.getParentFile().mkdirs();
            }
            target.createNewFile();
        } else if (target.isDirectory()) {
            throw new IllegalArgumentException("Target' " + target + " is a directory!");
        }
        BufferedInputStream bis = new BufferedInputStream(is);
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(target));
            try {
                int len;
                byte[] data = new byte[8192];
                while ((len = bis.read(data, 0, data.length)) >= 0) {
                    bos.write(data, 0, len);
                }
            }
            finally {
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                bis.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static final void copyDirectory(File source, File dest, FilenameFilter filter, boolean recursive) throws IOException {
        if (!dest.exists()) {
            if (dest.mkdirs()) {
                dest.setLastModified(source.lastModified());
            } else {
                throw new IOException("Failed to create directory '" + dest + "'");
            }
        }
        if (dest.isDirectory()) {
            File[] entries = source.listFiles(filter);
            if (entries != null) {
                for (int i = 0; i < entries.length; ++i) {
                    File destEntry = new File(dest.getPath() + File.separator + entries[i].getName());
                    if (entries[i].isDirectory()) {
                        if (!recursive) continue;
                        UtlFile.copyDirectory(entries[i], destEntry);
                        continue;
                    }
                    try {
                        UtlFile.copyFile(entries[i], destEntry);
                        continue;
                    }
                    catch (FileNotFoundException e) {
                        throw new InternalError("File reported to be not found when definitely exists!");
                    }
                }
            }
        } else {
            throw new InternalError("Directory copy request to a file destination!");
        }
    }

    public static final void copyDirectory(File source, File dest, FilenameFilter filter) throws IOException {
        UtlFile.copyDirectory(source, dest, filter, true);
    }

    public static final void copyDirectory(File source, File dest) throws IOException {
        UtlFile.copyDirectory(source, dest, null);
    }

    public static final void deleteDirectory(File dir) throws IOException {
        File[] entries = dir.listFiles();
        if (entries != null) {
            for (int i = 0; i < entries.length; ++i) {
                if (entries[i].isDirectory()) {
                    UtlFile.deleteDirectory(entries[i]);
                    continue;
                }
                entries[i].delete();
            }
        }
        dir.delete();
    }

    public static String readableFileSize(long size) {
        return UtlUnit.readableBytesSize(size);
    }

    public static String relativePath(File directory, File file) {
        return new File(directory.toURI().relativize(file.toURI()).getPath()).getPath();
    }

    public static final String getUserHome() {
        return userHome;
    }

    public static final File getUserHomeDir() {
        return userHomeDir;
    }

    public static String expandPath(String path) {
        if (path.startsWith("~") && userHome != null) {
            if (path.length() == 1) {
                return userHome;
            }
            return userHome + path.substring(1);
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String readFile(File file, String charset) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream((int)file.length());
        FileInputStream is = new FileInputStream(file);
        try {
            IOUtils.copy((InputStream)is, (OutputStream)baos, (int)8192);
            String string = new String(baos.toByteArray(), charset);
            return string;
        }
        finally {
            baos.close();
            ((InputStream)is).close();
        }
    }

    public static final File newFileWithNamespace(File parent, String namespace, String name, String extension) {
        if (parent == null) {
            throw new IllegalArgumentException("'parent' cannot be null");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("'name' cannot be null or empty string");
        }
        StringBuilder sb = new StringBuilder();
        if (namespace != null) {
            sb.append(namespace.replace(".", File.separator));
            sb.append(File.separator);
        }
        sb.append(name);
        if (extension != null && !extension.isEmpty()) {
            sb.append(".");
            sb.append(extension);
        }
        return new File(parent, sb.toString());
    }

    public static final File newFileWithNamespace(File parent, String namespace, String nameWithExtension) {
        return UtlFile.newFileWithNamespace(parent, namespace, nameWithExtension, null);
    }

    public static final File newDirWithNamespace(File parent, String namespace) {
        if (parent == null) {
            throw new IllegalArgumentException("'parent' cannot be null.");
        }
        if (namespace == null || namespace.isEmpty()) {
            throw new IllegalArgumentException("'namespace' cannot be null or empty string.");
        }
        return new File(parent, namespace.replace(".", File.separator));
    }

    public static final Collection<File> findFilesByEnding(File dir, String ending) {
        File[] files;
        ArrayList<File> foundFiles = new ArrayList<File>();
        if (dir == null) {
            throw new IllegalArgumentException("'dir' cannot be null");
        }
        if (!dir.exists() || !dir.isDirectory()) {
            throw new IllegalArgumentException("'dir' must exist in filesystem and must be a directory.");
        }
        if (ending == null || ending.isEmpty()) {
            throw new IllegalArgumentException("'ending' cannot be null or empty string.");
        }
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                foundFiles.addAll(UtlFile.findFilesByEnding(file, ending));
                continue;
            }
            if (!file.getName().toLowerCase().endsWith(ending)) continue;
            foundFiles.add(file);
        }
        return foundFiles;
    }

    static {
        boolean nativeKernelLoaded = false;
        try {
            NativeKernel.initialize();
            nativeKernelLoaded = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boolean bl = USE_NATIVE = nativeKernelLoaded && UtlEnv.getValue(FILE_USENATIVE_PROPNAME, true);
        if (UtlEnv.getValue("nv.native.configtrace", false)) {
            System.out.println("NATIVE FILE IO IS " + (USE_NATIVE ? "ENABLED" : "DISABLED"));
        }
        File homeDir = new File(userHome);
        if (userHome != null) {
            homeDir = new File(userHome);
        }
        userHomeDir = homeDir != null && homeDir.exists() ? homeDir : null;
    }
}

