/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang;

import com.neeve.lang.XCollection;
import com.neeve.lang.XIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class XLinkedList<E>
extends XCollection<E>
implements List<E> {
    private transient Node<E> _head = this.newNode();
    private transient Node<E> _tail = this.newNode();
    private transient int _size;

    public XLinkedList() {
        this(4);
    }

    public XLinkedList(int capacity) {
        ((Node)this._head)._next = (Node)this._tail;
        ((Node)this._tail)._previous = (Node)this._head;
        Node<E> previous = this._tail;
        int i = 0;
        while (i++ < capacity) {
            Node<E> newNode = this.newNode();
            ((Node)newNode)._previous = (Node)previous;
            ((Node)previous)._next = (Node)newNode;
            previous = newNode;
        }
    }

    public XLinkedList(Collection<? extends E> values) {
        this(values.size());
        this.addAll(values);
    }

    public static <E> XLinkedList<E> newInstance() {
        return new XLinkedList<E>();
    }

    @Override
    public final boolean add(E value) {
        this.addLast(value);
        return true;
    }

    @Override
    public final E get(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        return (E)((Node)this.nodeAt(index))._value;
    }

    @Override
    public final E set(int index, E value) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        Node<E> node = this.nodeAt(index);
        Object previousValue = ((Node)node)._value;
        ((Node)node)._value = value;
        return (E)previousValue;
    }

    @Override
    public final void add(int index, E value) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        this.addBefore(this.nodeAt(index), value);
    }

    @Override
    public final boolean addAll(int index, Collection<? extends E> values) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        Node<E> indexNode = this.nodeAt(index);
        Iterator<E> i = values.iterator();
        while (i.hasNext()) {
            this.addBefore(indexNode, i.next());
        }
        return values.size() != 0;
    }

    @Override
    public final E remove(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        Node<E> node = this.nodeAt(index);
        Object previousValue = ((Node)node)._value;
        this.delete(node);
        return (E)previousValue;
    }

    @Override
    public final int indexOf(Object value) {
        int index = 0;
        Node n = this._head;
        Node<E> end = this._tail;
        while ((n = n._next) != end) {
            if (XLinkedList.equals(value, n._value)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(Object value) {
        int index = this.size() - 1;
        Node n = this._tail;
        Node<E> end = this._head;
        while ((n = n._previous) != end) {
            if (XLinkedList.equals(value, n._value)) {
                return index;
            }
            --index;
        }
        return -1;
    }

    @Override
    public XIterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public XLinkedListIterator<E> listIterator() {
        return XLinkedListIterator.valueOf(this, ((Node)this._head)._next, 0, this._size);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        return XLinkedListIterator.valueOf(this, this.nodeAt(index), index, this._size);
    }

    @Override
    public final List<E> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this._size || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex + " for list of size: " + this._size);
        }
        return SubList.valueOf(this, ((Node)this.nodeAt(fromIndex))._previous, this.nodeAt(toIndex), toIndex - fromIndex);
    }

    @Override
    public final E getFirst() {
        Node node = ((Node)this._head)._next;
        if (node == this._tail) {
            throw new NoSuchElementException();
        }
        return (E)node._value;
    }

    @Override
    public final E getLast() {
        Node node = ((Node)this._tail)._previous;
        if (node == this._head) {
            throw new NoSuchElementException();
        }
        return (E)node._value;
    }

    @Override
    public final void addFirst(E value) {
        this.addBefore(((Node)this._head)._next, value);
    }

    @Override
    public void addLast(E value) {
        if (((Node)this._tail)._next == null) {
            this.increaseCapacity();
        }
        ((Node)this._tail)._value = value;
        this._tail = ((Node)this._tail)._next;
        ++this._size;
    }

    @Override
    public final E removeFirst() {
        Node first = ((Node)this._head)._next;
        if (first == this._tail) {
            throw new NoSuchElementException();
        }
        Object previousValue = first._value;
        this.delete(first);
        return (E)previousValue;
    }

    @Override
    public final E removeLast() {
        if (this._size == 0) {
            throw new NoSuchElementException();
        }
        --this._size;
        Node last = ((Node)this._tail)._previous;
        Object previousValue = last._value;
        this._tail = last;
        last._value = null;
        return (E)previousValue;
    }

    public final void addBefore(Node<E> next, E value) {
        Node newNode;
        Node tailNext;
        if (((Node)this._tail)._next == null) {
            this.increaseCapacity();
        }
        if ((tailNext = (((Node)this._tail)._next = (newNode = ((Node)this._tail)._next)._next)) != null) {
            tailNext._previous = (Node)this._tail;
        }
        Node previous = ((Node)next)._previous;
        previous._next = newNode;
        ((Node)next)._previous = newNode;
        newNode._next = (Node)next;
        newNode._previous = previous;
        newNode._value = value;
        ++this._size;
    }

    private final Node<E> nodeAt(int index) {
        Node node = this._head;
        int i = index;
        while (i-- >= 0) {
            node = node._next;
        }
        return node;
    }

    @Override
    public final Node<E> head() {
        return this._head;
    }

    @Override
    public final Node<E> tail() {
        return this._tail;
    }

    @Override
    public final E valueOf(XCollection.Record record) {
        return (E)((Node)record)._value;
    }

    @Override
    public final void delete(XCollection.Record record) {
        Node node = (Node)record;
        --this._size;
        node._value = null;
        node._previous._next = node._next;
        node._next._previous = node._previous;
        Node next = ((Node)this._tail)._next;
        node._previous = (Node)this._tail;
        node._next = next;
        ((Node)this._tail)._next = node;
        if (next != null) {
            next._previous = node;
        }
    }

    @Override
    public final boolean contains(Object value) {
        return this.indexOf(value) >= 0;
    }

    @Override
    public final int size() {
        return this._size;
    }

    @Override
    public final void clear() {
        this._size = 0;
        Node n = this._head;
        Node<E> end = this._tail;
        while ((n = n._next) != end) {
            n._value = null;
        }
        this._tail = ((Node)this._head)._next;
    }

    @Override
    public List<E> unmodifiable() {
        return (List)super.unmodifiable();
    }

    protected Node<E> newNode() {
        return new Node();
    }

    private void increaseCapacity() {
        Node<E> newNode0 = this.newNode();
        ((Node)this._tail)._next = (Node)newNode0;
        ((Node)newNode0)._previous = (Node)this._tail;
        Node<E> newNode1 = this.newNode();
        ((Node)newNode0)._next = (Node)newNode1;
        ((Node)newNode1)._previous = (Node)newNode0;
        Node<E> newNode2 = this.newNode();
        ((Node)newNode1)._next = (Node)newNode2;
        ((Node)newNode2)._previous = (Node)newNode1;
        Node<E> newNode3 = this.newNode();
        ((Node)newNode2)._next = (Node)newNode3;
        ((Node)newNode3)._previous = (Node)newNode2;
    }

    public void reset() {
        this.clear();
    }

    private static final class XLinkedListIterator<E>
    implements ListIterator<E>,
    XIterator<E> {
        private XLinkedList<E> _list;
        private Node<E> _nextNode;
        private Node<E> _currentNode;
        private int _length;
        private int _nextIndex;

        private XLinkedListIterator() {
        }

        public static <E> XLinkedListIterator<E> valueOf(XLinkedList<E> list, Node<E> nextNode, int nextIndex, int size) {
            XLinkedListIterator<E> itr = new XLinkedListIterator<E>();
            itr._list = list;
            itr._nextNode = nextNode;
            itr._nextIndex = nextIndex;
            itr._length = size;
            return itr;
        }

        @Override
        public boolean hasNext() {
            return this._nextIndex != this._length;
        }

        @Override
        public E next() {
            if (this._nextIndex == this._length) {
                throw new NoSuchElementException();
            }
            ++this._nextIndex;
            this._currentNode = this._nextNode;
            this._nextNode = ((Node)this._nextNode)._next;
            return (E)((Node)this._currentNode)._value;
        }

        @Override
        public int nextIndex() {
            return this._nextIndex;
        }

        @Override
        public boolean hasPrevious() {
            return this._nextIndex != 0;
        }

        @Override
        public E previous() {
            if (this._nextIndex == 0) {
                throw new NoSuchElementException();
            }
            --this._nextIndex;
            this._currentNode = this._nextNode = ((Node)this._nextNode)._previous;
            return (E)((Node)this._currentNode)._value;
        }

        @Override
        public int previousIndex() {
            return this._nextIndex - 1;
        }

        @Override
        public void add(E o) {
            if (!this._list.supportsIteratorModifications()) {
                throw new UnsupportedOperationException("not supported");
            }
            this._list.addBefore(this._nextNode, o);
            this._currentNode = null;
            ++this._length;
            ++this._nextIndex;
        }

        @Override
        public void set(E o) {
            if (!this._list.supportsIteratorModifications()) {
                throw new UnsupportedOperationException("not supported");
            }
            if (this._currentNode == null) {
                throw new IllegalStateException();
            }
            ((Node)this._currentNode)._value = o;
        }

        @Override
        public void remove() {
            if (!this._list.supportsIteratorModifications()) {
                throw new UnsupportedOperationException("not supported");
            }
            if (this._currentNode == null) {
                throw new IllegalStateException();
            }
            if (this._nextNode == this._currentNode) {
                this._nextNode = ((Node)this._nextNode)._next;
            } else {
                --this._nextIndex;
            }
            this._list.delete(this._currentNode);
            this._currentNode = null;
            --this._length;
        }

        @Override
        public XIterator<E> toFirst() {
            this._nextNode = ((XLinkedList)this._list)._head._next;
            this._nextIndex = 0;
            this._length = ((XLinkedList)this._list)._size;
            return this;
        }
    }

    private static final class SubList<E>
    extends XCollection<E>
    implements List<E> {
        private XLinkedList<E> _list;
        private Node<E> _head;
        private Node<E> _tail;
        private int _size;

        private SubList() {
        }

        public static <E> SubList<E> valueOf(XLinkedList<E> list, Node<E> head, Node<E> tail, int size) {
            SubList<E> subList = new SubList<E>();
            subList._list = list;
            subList._head = head;
            subList._tail = tail;
            subList._size = size;
            return subList;
        }

        @Override
        public int size() {
            return this._size;
        }

        @Override
        public XCollection.Record head() {
            return this._head;
        }

        @Override
        public XCollection.Record tail() {
            return this._tail;
        }

        @Override
        public E valueOf(XCollection.Record record) {
            return this._list.valueOf(record);
        }

        @Override
        public void delete(XCollection.Record record) {
            this._list.delete(record);
            if (record == this._head) {
                this._head = this._head.getNext();
            } else if (record == this._tail) {
                this._tail = this._tail.getPrevious();
            }
            --this._size;
        }

        @Override
        public boolean addAll(Collection<? extends E> values) {
            return this.addAll(this._size, values);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> values) {
            if (index < 0 || index > this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            Node<E> indexNode = this.nodeAt(index);
            Iterator<E> i = values.iterator();
            while (i.hasNext()) {
                this._list.addBefore(indexNode, i.next());
            }
            if (values.size() > 0) {
                if (index == 0) {
                    this._head = this._head.getPrevious();
                } else if (index == this._size) {
                    this._tail = indexNode.getPrevious();
                }
            }
            this._size += values.size();
            return values.size() != 0;
        }

        @Override
        public E get(int index) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            return (E)((Node)this.nodeAt(index))._value;
        }

        @Override
        public E set(int index, E value) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            Node<E> node = this.nodeAt(index);
            Object previousValue = ((Node)node)._value;
            ((Node)node)._value = value;
            return (E)previousValue;
        }

        @Override
        public boolean add(E element) {
            this.add(this._size, element);
            return true;
        }

        @Override
        public void add(int index, E element) {
            if (index < 0 || index > this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            this._list.addBefore(this.nodeAt(index), element);
            if (index == 0) {
                this._head = this._head.getPrevious();
            } else if (index == this._size) {
                this._tail = this._tail.getNext();
            }
            ++this._size;
        }

        @Override
        public E remove(int index) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            Node<E> node = this.nodeAt(index);
            Object previousValue = ((Node)node)._value;
            this._list.delete(node);
            if (index == 0) {
                this._head = this._head.getNext();
            } else if (index == this._size) {
                this._tail = this._tail.getPrevious();
            }
            --this._size;
            return (E)previousValue;
        }

        @Override
        public int indexOf(Object value) {
            int index = 0;
            Node n = this._head;
            Node<E> end = this._tail;
            while ((n = n._next) != end) {
                if (SubList.equals(value, n._value)) {
                    return index;
                }
                ++index;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object value) {
            int index = this.size() - 1;
            Node n = this._tail;
            Node<E> end = this._head;
            while ((n = n._previous) != end) {
                if (SubList.equals(value, n._value)) {
                    return index;
                }
                --index;
            }
            return -1;
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            if (index >= 0 && index <= this._size) {
                return XLinkedListIterator.valueOf(this._list, this.nodeAt(index), index, this._size);
            }
            throw new IndexOutOfBoundsException("index: " + index + " for list of size: " + this._size);
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            if (fromIndex < 0 || toIndex > this._size || fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex + " for list of size: " + this._size);
            }
            SubList<E> subList = SubList.valueOf(this._list, ((Node)this.nodeAt(fromIndex))._previous, this.nodeAt(toIndex), toIndex - fromIndex);
            return subList;
        }

        private final Node<E> nodeAt(int index) {
            if (index <= this._size >> 1) {
                Node node = this._head;
                int i = index;
                while (i-- >= 0) {
                    node = node._next;
                }
                return node;
            }
            Node node = this._tail;
            int i = this._size - index;
            while (i-- > 0) {
                node = node._previous;
            }
            return node;
        }

        @Override
        public void clear() {
            while (this._size > 0) {
                this.remove(0);
            }
        }
    }

    public static class Node<E>
    implements XCollection.Record {
        private Node<E> _next;
        private Node<E> _previous;
        private E _value;

        protected Node() {
        }

        public final E getValue() {
            return this._value;
        }

        @Override
        public final Node<E> getNext() {
            return this._next;
        }

        @Override
        public final Node<E> getPrevious() {
            return this._previous;
        }
    }
}

