/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.build.codegen;

import com.neeve.build.codegen.CgMappable;
import com.neeve.util.UtlMisc;
import java.io.File;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class CgBuildParameters {
    private boolean validated = false;
    private final Map<String, AdmParameter> parameters = new TreeMap<String, AdmParameter>();
    private final Map<String, AdmParameter> aliases = new HashMap<String, AdmParameter>();
    private final Map<String, AdmArgument> arguments = new TreeMap<String, AdmArgument>();
    public static final String PARAMETER_METADATA_HIDDEN = "hidden";
    public static final String PARAMETER_METADATA_TRANSIENT = "transient";

    private CgBuildParameters() {
    }

    public static final CgBuildParameters newInstance() {
        return new CgBuildParameters();
    }

    public void validate() throws AdmParametersException {
        for (AdmParameter admParameter : this.parameters.values()) {
            admParameter.validate();
        }
        for (Map.Entry entry : this.arguments.entrySet()) {
            String key = (String)entry.getKey();
            if (this.parameters.get(key) != null) continue;
            throw new AdmParametersException("Parameter '" + key + "' is not defined", null, (AdmArgument)entry.getValue());
        }
        this.validated = true;
    }

    public Object getValue(String nameOrAlias) {
        if (nameOrAlias == null || nameOrAlias.isEmpty()) {
            throw new IllegalArgumentException("'name' cannot be null or empty string.");
        }
        AdmParameter param = this.getParameter(nameOrAlias);
        if (param == null) {
            throw new IllegalArgumentException("'" + nameOrAlias + "' is not in defined parameters.");
        }
        return param.getValue();
    }

    public final Boolean getValueAsBoolean(String nameOrAlias, Boolean defaultValue) {
        AdmParameter param = this.getParameter(nameOrAlias);
        if (param == null) {
            throw new IllegalArgumentException("'" + nameOrAlias + "' is not in defined parameters.");
        }
        return param.getValueAsBoolean(defaultValue);
    }

    public final String getValueAsString(String nameOrAlias, String defaultValue) {
        AdmParameter param = this.getParameter(nameOrAlias);
        if (param == null) {
            throw new IllegalArgumentException("'" + nameOrAlias + "' is not in defined parameters.");
        }
        return param.getValueAsString(defaultValue);
    }

    public AdmParameter newParameter(String name, String description, Class<?>[] types, boolean required, Object defaultValue) {
        AdmParameter parameter = new AdmParameter(name, description, types, required, defaultValue);
        this.parameters.put(name, parameter);
        this.validated = false;
        return parameter;
    }

    public AdmParameter newParameter(AdmParameter parameter) {
        this.parameters.put(parameter.getName(), parameter);
        for (String alias : parameter.getAliases()) {
            parameter.setAlias(alias);
        }
        this.validated = false;
        return parameter;
    }

    public AdmParameter removeParameter(String nameOrAlias) {
        if (nameOrAlias == null || nameOrAlias.isEmpty()) {
            throw new IllegalArgumentException("'name' cannot be null or empty string.");
        }
        AdmParameter param = this.getParameter(nameOrAlias);
        if (param != null) {
            this.parameters.remove(param.getName());
            this.arguments.remove(param.getName());
            for (String alias : param.getAliases()) {
                this.aliases.remove(alias);
            }
        } else {
            throw new IllegalArgumentException("Parameter with name or alias '" + nameOrAlias + " is not defined.");
        }
        return param;
    }

    public AdmParameter newParameter(String name, String description, Object[] choices, boolean required, Object defaultValue) {
        AdmParameter parameter = new AdmParameter(name, description, choices, required, defaultValue);
        this.parameters.put(name, parameter);
        this.validated = false;
        return parameter;
    }

    private AdmParameter getParameter(String nameOrAlias) {
        AdmParameter retVal = this.parameters.get(nameOrAlias);
        if (retVal == null) {
            retVal = this.aliases.get(nameOrAlias);
        }
        return retVal;
    }

    public AdmArgument newArgument(String nameOrAlias, Object value) {
        if (nameOrAlias == null || nameOrAlias.isEmpty()) {
            throw new IllegalArgumentException("'nameOrAlias' cannot be null or empty string.");
        }
        AdmParameter parameter = this.getParameter(nameOrAlias);
        if (parameter == null) {
            throw new IllegalArgumentException("Parameter with name or alias '" + nameOrAlias + " is not defined.");
        }
        Object finalValue = value;
        if (parameter.argumentValueConverter != null) {
            try {
                finalValue = parameter.argumentValueConverter.convertValue(value);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Error converting argument: " + ex.getMessage(), ex);
            }
        }
        AdmArgument argument = new AdmArgument(parameter, finalValue);
        this.arguments.put(parameter.getName(), argument);
        this.validated = false;
        return argument;
    }

    public CgBuildParameters newArguments(Map<String, Object> arguments) {
        for (Map.Entry<String, Object> entry : arguments.entrySet()) {
            this.newArgument(entry.getKey().toString(), entry.getValue());
        }
        return this;
    }

    public CgBuildParameters newStringArguments(Map<String, String> arguments) {
        for (Map.Entry<String, String> entry : arguments.entrySet()) {
            this.newArgument(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public String checksum() {
        if (!this.validated) {
            throw new IllegalStateException("Cannot use argument values before validation is run.");
        }
        return "null";
    }

    public TreeMap<String, AdmArgument> getArguments() {
        TreeMap<String, AdmArgument> retVal = new TreeMap<String, AdmArgument>();
        retVal.putAll(this.arguments);
        return retVal;
    }

    public TreeMap<String, AdmParameter> getParameters() {
        TreeMap<String, AdmParameter> retVal = new TreeMap<String, AdmParameter>();
        retVal.putAll(this.parameters);
        return retVal;
    }

    public CgBuildParameters adoptParameters(CgBuildParameters otherInstance, Set<String> paramNames) {
        if (otherInstance == null) {
            throw new IllegalArgumentException("'otherInstance' cannot be null.");
        }
        Set<String> finalParamNames = paramNames;
        if (paramNames == null) {
            finalParamNames = otherInstance.parameters.keySet();
        }
        for (String name : finalParamNames) {
            AdmParameter otherParameter = otherInstance.parameters.get(name);
            if (otherParameter == null) {
                throw new IllegalArgumentException("'otherInstance' does not define parameter '" + name + "'.");
            }
            AdmParameter parameter = otherParameter.types != null ? this.newParameter(otherParameter.name, otherParameter.description, otherParameter.types, otherParameter.required, otherParameter.defaultValue) : this.newParameter(otherParameter.name, otherParameter.description, otherParameter.choices, otherParameter.required, otherParameter.defaultValue);
            parameter.additionalData.putAll(otherParameter.additionalData);
            parameter.setArgumentValueConverter(otherParameter.argumentValueConverter);
            for (String alias : otherParameter.aliases) {
                parameter.setAlias(alias);
            }
        }
        return this;
    }

    public Map<String, Map<String, Object>> paramsToMap() {
        TreeMap<String, Map<String, Object>> retVal = new TreeMap<String, Map<String, Object>>();
        for (AdmParameter parameter : this.parameters.values()) {
            retVal.put(parameter.getName(), parameter.toMap());
        }
        return retVal;
    }

    public class AdmParametersException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final AdmParameter parameter;
        private final AdmArgument argument;

        public AdmParametersException(String message, AdmParameter parameter, AdmArgument argument) {
            super(message);
            this.parameter = parameter;
            this.argument = argument;
        }

        public final AdmParameter getParameter() {
            return this.parameter;
        }

        public final AdmArgument getArgument() {
            return this.argument;
        }
    }

    public class AdmArgument {
        private final AdmParameter parameter;
        private final Object value;
        private final Map<String, Object> additionalData = new HashMap<String, Object>();

        private AdmArgument(AdmParameter parameter, Object value) {
            this.parameter = parameter;
            this.value = value;
        }

        private final Object getValue() {
            return this.value;
        }

        public AdmArgument putAdditionalData(String key, Object value) {
            this.additionalData.put(key, value);
            return this;
        }

        public Map<String, Object> getAdditionalData() {
            return new HashMap<String, Object>(this.additionalData);
        }

        public final CgBuildParameters getParent() {
            return CgBuildParameters.this;
        }

        public final AdmParameter getParameter() {
            return this.parameter;
        }
    }

    public static interface ArgumentValueConverter {
        public Object convertValue(Object var1) throws Exception;
    }

    public class AdmParameter
    implements CgMappable {
        private final String name;
        private final String description;
        private final Object[] choices;
        private final Class<?>[] types;
        private final boolean required;
        private final Object defaultValue;
        private final Map<String, Object> additionalData = new HashMap<String, Object>();
        private ArgumentValueConverter argumentValueConverter = null;
        private Set<String> aliases = new HashSet<String>();

        private AdmParameter(String name, String description, Class<?>[] types, boolean required, Object defaultValue) {
            if (name == null || name.isEmpty()) {
                throw new IllegalArgumentException("'name' cannot be null or empty string.");
            }
            if (description == null || description.isEmpty()) {
                throw new IllegalArgumentException("'description' cannot be null or empty string.");
            }
            if (types == null || types.length == 0) {
                throw new IllegalArgumentException("'types' cannot be null or empty.");
            }
            this.name = name;
            this.description = description;
            this.choices = null;
            this.types = types;
            this.required = required;
            this.defaultValue = defaultValue;
        }

        private AdmParameter(String name, String description, Object[] choices, boolean required, Object defaultValue) {
            if (name == null || name.isEmpty()) {
                throw new IllegalArgumentException("'name' cannot be null or empty string.");
            }
            if (description == null || description.isEmpty()) {
                throw new IllegalArgumentException("'description' cannot be null or empty string.");
            }
            if (choices == null || choices.length == 0) {
                throw new IllegalArgumentException("'choices' cannot be null or empty array");
            }
            this.name = name;
            this.description = description;
            this.choices = choices;
            this.types = null;
            this.required = required;
            this.defaultValue = defaultValue;
        }

        private void validate() throws AdmParametersException {
            Object value = this.getValue();
            if (this.required && value == null) {
                throw new AdmParametersException("'" + this.name + "' is required", this, null);
            }
            if (value != null) {
                boolean isInstance;
                if (this.types != null && !(isInstance = this.types[0].isAssignableFrom(value.getClass()))) {
                    throw new AdmParametersException("'" + this.name + "' type missmatch. Expected " + this.types[0].getName() + ", got " + value.getClass().getName() + " instead.", this, (AdmArgument)CgBuildParameters.this.arguments.get(this.name));
                }
                if (this.choices != null) {
                    boolean choiceMatch = false;
                    for (Object choice : this.choices) {
                        if (!choice.equals(value)) continue;
                        choiceMatch = true;
                        break;
                    }
                    if (!choiceMatch) {
                        throw new AdmParametersException("'" + this.name + "' choice missmatch: '" + value + "'. Value must be equal to one of choices defined for this parameter" + Arrays.toString(this.choices), this, (AdmArgument)CgBuildParameters.this.arguments.get(this.name));
                    }
                }
            }
        }

        private Object getValue() {
            if (CgBuildParameters.this.arguments.containsKey(this.name)) {
                return ((AdmArgument)CgBuildParameters.this.arguments.get(this.name)).getValue();
            }
            return this.defaultValue;
        }

        private final Boolean getValueAsBoolean(Boolean defaultValue) {
            Boolean retVal = defaultValue;
            Object value = this.getValue();
            try {
                if (value != null) {
                    retVal = Boolean.parseBoolean(value.toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return retVal;
        }

        public final String getValueAsString(String defaultValue) {
            String retVal = defaultValue;
            Object value = this.getValue();
            if (value != null) {
                if (value instanceof Iterable) {
                    StringBuilder sb = new StringBuilder();
                    Iterator iter = ((Iterable)value).iterator();
                    while (iter.hasNext()) {
                        sb.append(iter.next().toString());
                        sb.append(',');
                    }
                    if (sb.length() > 0) {
                        retVal = sb.substring(0, sb.length() - 1);
                    }
                } else if (value.getClass().isArray()) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < Array.getLength(value); ++i) {
                        sb.append(UtlMisc.coalesce(Array.get(value, i), "null"));
                        sb.append(',');
                    }
                    if (sb.length() > 0) {
                        retVal = sb.substring(0, sb.length() - 1);
                    }
                } else {
                    retVal = value.toString();
                }
            }
            return retVal;
        }

        public AdmParameter putAdditionalData(String key, Object value) {
            this.additionalData.put(key, value);
            return this;
        }

        public Map<String, Object> getAdditionalData() {
            return new HashMap<String, Object>(this.additionalData);
        }

        public final CgBuildParameters getParent() {
            return CgBuildParameters.this;
        }

        public String getDescription() {
            return this.description;
        }

        public AdmParameter setAlias(String alias) {
            if (alias == null) {
                throw new IllegalArgumentException("'alias' cannot be null.");
            }
            if (CgBuildParameters.this.parameters.containsKey(alias)) {
                throw new IllegalStateException("Alias " + alias + "is already used as a name of parameter");
            }
            this.aliases.add(alias);
            CgBuildParameters.this.aliases.put(alias, this);
            return this;
        }

        public final Set<String> getAliases() {
            return new TreeSet<String>(this.aliases);
        }

        public AdmParameter setArgumentValueConverter(ArgumentValueConverter argumentValueConverter) {
            this.argumentValueConverter = argumentValueConverter;
            return this;
        }

        public AdmParameter setStringToFileConverter() {
            return this.setArgumentValueConverter(new ArgumentValueConverter(){

                @Override
                public Object convertValue(Object value) {
                    Object retVal = value;
                    if (value != null && !(value instanceof File)) {
                        retVal = new File(value.toString());
                    }
                    return retVal;
                }
            });
        }

        public AdmParameter setStringArrayToFileArrayConverter() {
            return this.setArgumentValueConverter(new ArgumentValueConverter(){

                @Override
                public Object convertValue(Object value) {
                    File[] retVal = value;
                    if (value != null && !(value instanceof File[])) {
                        if (value instanceof String[]) {
                            String[] strValues = (String[])value;
                            File[] retValFiles = new File[strValues.length];
                            for (int i = 0; i < strValues.length; ++i) {
                                retValFiles[i] = new File(strValues[i]);
                            }
                            retVal = retValFiles;
                        } else {
                            throw new IllegalArgumentException("Error converting " + value.getClass().getName() + "to File[] for parameter '" + AdmParameter.this.name + "'");
                        }
                    }
                    return retVal;
                }
            });
        }

        public AdmParameter setStringToURLConverter() {
            return this.setArgumentValueConverter(new ArgumentValueConverter(){

                @Override
                public Object convertValue(Object value) throws Exception {
                    Object retVal = value;
                    if (value != null && !(value instanceof URL)) {
                        retVal = new URL(value.toString());
                    }
                    return retVal;
                }
            });
        }

        public AdmParameter setStringToBooleanConverter() {
            return this.setArgumentValueConverter(new ArgumentValueConverter(){

                @Override
                public Object convertValue(Object value) {
                    Object retVal = value;
                    if (value != null && !(value instanceof Boolean)) {
                        retVal = Boolean.parseBoolean(value.toString());
                    }
                    return retVal;
                }
            });
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Map<String, Object> toMap() {
            TreeMap<String, Object> retVal = new TreeMap<String, Object>();
            retVal.put("name", this.name);
            retVal.put("description", this.description);
            retVal.put("choices", this.choices);
            retVal.put("types", this.types);
            retVal.put("required", this.required);
            retVal.put("defaultValue", this.defaultValue);
            retVal.put("additionalData", this.additionalData);
            retVal.put("aliases", this.aliases);
            return retVal;
        }
    }
}

