/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.test.unit;

import com.neeve.discovery.DiscoveryCacheFactory;
import com.neeve.server.admin.AbstractAdminSessionEventHandler;
import com.neeve.server.admin.AdminSession;
import com.neeve.server.admin.AdminSessionFactory;
import com.neeve.server.admin.EAdminOpFailedException;
import com.neeve.server.config.SrvConfigDescriptor;
import com.neeve.server.mon.SrvMonAppInfo;
import com.neeve.server.mon.SrvMonHeartbeatMessage;
import com.neeve.server.mon.cnc.SrvMonTraceRecord;
import com.neeve.server.test.unit.AdminSessionTestApp;
import com.neeve.test.UnitTest;
import com.neeve.trace.Tracer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AdminSessionTest
extends UnitTest {
    private static String PRIMARY_XVM_NAME;
    private static String BACKUP_XVM_NAME;
    private static String APP_NAME;
    private static final Tracer tracer;
    private static AdminSessionTestApp app;
    private static AdminSessionTestApp app2;
    private static LinkedHashSet<AdminSession> openSessions;
    private final boolean adminOverSma;
    private final boolean passiveMonitoringOnly;
    private final XvmLayout xvmLayout;
    @Rule
    public ExpectedException commandsNotSupported = ExpectedException.none();

    @Parameterized.Parameters(name="{0}_{1}_{2}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> testCases = new ArrayList<Object[]>();
        for (XvmLayout xvmLayout : XvmLayout.values()) {
            for (Transport transport : Transport.values()) {
                for (MonitoringMode monitoringMode : MonitoringMode.values()) {
                    testCases.add(new Object[]{xvmLayout, transport, monitoringMode});
                }
            }
        }
        return testCases;
    }

    @AfterClass
    public static final void tearDown() throws Exception {
        if (app != null) {
            app.shutdown();
        }
        AdminSessionTest.setVerbose((boolean)false);
    }

    @Before
    public final void setup() throws TimeoutException, Throwable {
        if (app2 != null && this.xvmLayout == XvmLayout.SingleXvm) {
            app2.shutdown();
            app2 = null;
        }
        if (app != null) {
            if (app.getServerConfigDescriptor().getAdmin().getSma().isEnabled() == this.adminOverSma && app.getServerConfigDescriptor().getAdmin().getPassiveMonitoringOnly() == this.passiveMonitoringOnly) {
                return;
            }
            app.shutdown();
            if (app2 != null) {
                app2.shutdown();
            }
        }
        app = AdminSessionTestApp.launch(PRIMARY_XVM_NAME, APP_NAME, this.adminOverSma, this.passiveMonitoringOnly);
        if (this.xvmLayout == XvmLayout.MultipleXvm) {
            app2 = AdminSessionTestApp.launch(BACKUP_XVM_NAME, APP_NAME, this.adminOverSma, this.passiveMonitoringOnly);
        }
    }

    public AdminSessionTest(XvmLayout xvmLayout, Transport transport, MonitoringMode monitoringMode) {
        this.adminOverSma = transport == Transport.AdminOverSma;
        this.passiveMonitoringOnly = monitoringMode == MonitoringMode.PassiveMonitoring;
        this.xvmLayout = xvmLayout;
    }

    @After
    public final void closeAdminSessions() throws Exception {
        AdminSessionTest.disconnectAllSessions();
    }

    @Test
    public void testMultipleAdminSessions() throws Exception {
        AdminSessionTestEventHandler s1Handler = new AdminSessionTestEventHandler();
        AdminSession session1 = this.connectAdminSession(PRIMARY_XVM_NAME, "testMultipleAdminSessions-1", s1Handler);
        Assert.assertEquals((String)"Incorrect admin session type", (Object)(this.adminOverSma ? "sma" : "direct"), (Object)session1.getTransportType());
        Assert.assertEquals((String)"Incorrect passive monitoring configuration", (Object)this.passiveMonitoringOnly, (Object)session1.isPassiveMonitoringOnly());
        session1.startAppWatch();
        session1.waitForAppWatchJoin(5000);
        AdminSessionTestEventHandler s2Handler = new AdminSessionTestEventHandler();
        AdminSession session2 = this.connectAdminSession(PRIMARY_XVM_NAME, "testMultipleAdminSessions-2", s2Handler);
        Assert.assertEquals((String)"Incorrect admin session type", (Object)(this.adminOverSma ? "sma" : "direct"), (Object)session2.getTransportType());
        Assert.assertEquals((String)"Incorrect passive monitoring configuration", (Object)this.passiveMonitoringOnly, (Object)session2.isPassiveMonitoringOnly());
        session2.startAppWatch();
        session2.waitForAppWatchJoin(5000);
        if (!this.adminOverSma) {
            HashSet<String> expectedClients = new HashSet<String>(Arrays.asList("testMultipleAdminSessions-1", "testMultipleAdminSessions-2"));
            Assert.assertEquals((String)"Admin Session 1 has wrong clients", expectedClients, new HashSet<String>(Arrays.asList(session1.getWatchedAppClients("admin"))));
            Assert.assertEquals((String)"Session1 event handler got wrong number of app client connects", (long)1L, (long)s1Handler.numAppClientConnected);
            Assert.assertEquals((String)"Admin Session 2 has wrong clients", expectedClients, new HashSet<String>(Arrays.asList(session2.getWatchedAppClients("admin"))));
            Assert.assertEquals((String)"Session2 event handler got wrong number of app client connects", (long)0L, (long)s2Handler.numAppClientConnected);
        } else {
            HashSet<String> expectedChannels = new HashSet<String>();
            for (SrvConfigDescriptor.Admin.Sma.Channel channelConfig : app.getServerConfigDescriptor().getAdmin().getSma().getAdminChannels()) {
                if (!channelConfig.isEnabled()) continue;
                expectedChannels.add(channelConfig.getChannelName());
            }
            Assert.assertEquals((String)"Session1 Has wrong admin channels", expectedChannels, new HashSet<String>(Arrays.asList(session1.getWatchedAppBusChannels("admin", app.getServerConfigDescriptor().getAdmin().getSma().getBusName()))));
            Assert.assertEquals((String)"Session1 event handler got wrong number of admin client opens", (long)0L, (long)s1Handler.numAppClientConnected);
            Assert.assertEquals((String)"Sesssion2 Has wrong admin channels", expectedChannels, new HashSet<String>(Arrays.asList(session2.getWatchedAppBusChannels("admin", app.getServerConfigDescriptor().getAdmin().getSma().getBusName()))));
            Assert.assertEquals((String)"Session2 event handler got wrong number of admin client opens", (long)0L, (long)s2Handler.numAppClientConnected);
        }
        Assert.assertEquals((String)"Session1 event handler got the wrong number of fail notifications", (long)0L, (long)s1Handler.numFail);
        Assert.assertEquals((String)"Session2 event handler got the wrong number of fail notifications", (long)0L, (long)s2Handler.numFail);
        AdminSessionTest.disconnectAdminSession(session2);
        if (!this.adminOverSma) {
            tracer.log("Waiting for app client disconnects...", Tracer.Level.INFO);
            s1Handler.waitForAppClientDisconnects(1, 5, TimeUnit.SECONDS);
            tracer.log("Done Waiting for app client disconnects...", Tracer.Level.INFO);
            Assert.assertEquals((String)"Session1 event handler got wrong number of app client disconnects", (long)1L, (long)s1Handler.numAppClientDisconnected);
        }
    }

    @Test
    public void testAppWatchHeartbeats() throws Exception {
        AdminSessionTestEventHandler eventHandler = new AdminSessionTestEventHandler();
        eventHandler.holdHeartbeats = true;
        AdminSession session1 = this.connectAdminSession(PRIMARY_XVM_NAME, "testAppWatchHeartbeats", eventHandler);
        session1.startAppWatch();
        session1.waitForAppWatchJoin(2000);
        eventHandler.waitForHeartbeats(2, 20, TimeUnit.SECONDS);
        for (SrvMonHeartbeatMessage hb : eventHandler.heartbeats) {
            Assert.assertEquals((String)"Received wrong server name in heartbeat!", (Object)PRIMARY_XVM_NAME, (Object)hb.getServerName());
            Assert.assertTrue((String)"Heartbeat should have XvmHeader", (boolean)hb.hasXvmHeader());
            Assert.assertEquals((String)"Received wrong server name in heartbeat header!", (Object)PRIMARY_XVM_NAME, (Object)hb.getXvmHeader().getXvmName());
        }
    }

    @Test
    public void testAppReload() throws Exception {
        AdminSessionTestEventHandler eventHandler = new AdminSessionTestEventHandler();
        eventHandler.holdHeartbeats = true;
        AdminSession session1 = this.connectAdminSession(PRIMARY_XVM_NAME, "testAppWatchHeartbeats", eventHandler);
        session1.startAppWatch();
        session1.waitForAppWatchJoin(2000);
        try {
            session1.invokeCommand("admin", "app_unload", APP_NAME);
        }
        catch (EAdminOpFailedException e) {
            if (this.passiveMonitoringOnly) {
                Assert.assertTrue((String)"Wrong exception text expected 'Session is configured for passive monitoring only.'", (e.getMessage().indexOf("Session is configured for passive monitoring only.") >= 0 ? 1 : 0) != 0);
                return;
            }
            throw e;
        }
        int hbWithOutApp = eventHandler.numHeartbeats + 1;
        eventHandler.waitForHeartbeats(hbWithOutApp, 20, TimeUnit.SECONDS);
        SrvMonHeartbeatMessage hb = eventHandler.heartbeats.get(hbWithOutApp - 1);
        for (SrvMonAppInfo appInfo : hb.getAppsInfoEmptyIfNull()) {
            if (!appInfo.getName().equals(APP_NAME)) continue;
            Assert.fail((String)("Unloaded app was reported in heartbeat: " + appInfo));
        }
        if (Arrays.asList(session1.getWatchedApps()).indexOf(APP_NAME) != -1) {
            Assert.fail((String)("Unloaded app was reported in watched apps: " + Arrays.asList(session1.getWatchedApps())));
        }
        session1.invokeCommand("admin", "app_load", APP_NAME);
        int hbWithApp = eventHandler.numHeartbeats + 1;
        eventHandler.waitForHeartbeats(hbWithApp, 20, TimeUnit.SECONDS);
        hb = eventHandler.heartbeats.get(hbWithApp - 1);
        boolean foundApp = false;
        for (SrvMonAppInfo appInfo : hb.getAppsInfoEmptyIfNull()) {
            if (!appInfo.getName().equals(APP_NAME)) continue;
            foundApp = true;
            break;
        }
        Assert.assertTrue((String)"Reloaded app was not reported in next heartbeat", (boolean)foundApp);
        if (Arrays.asList(session1.getWatchedApps()).indexOf(APP_NAME) == -1) {
            Assert.fail((String)("Reloaded app was reported in watched apps: " + Arrays.asList(session1.getWatchedApps())));
        }
    }

    @Test
    public void testAppTraceWatch() throws Exception {
        TraceRecordMatcher traceMatcher;
        boolean matched;
        AdminSessionTestEventHandler eventHandler = new AdminSessionTestEventHandler();
        eventHandler.holdTraceRecords = true;
        AdminSession session1 = this.connectAdminSession(PRIMARY_XVM_NAME, "testAppTraceWatch", eventHandler);
        AdminSessionTestEventHandler backupEventHandler = new AdminSessionTestEventHandler();
        backupEventHandler.holdTraceRecords = true;
        AdminSession session2 = app2 != null ? this.connectAdminSession(BACKUP_XVM_NAME, "testAppTraceWatch2", backupEventHandler) : null;
        session1.startTraceWatch();
        if (app2 != null) {
            session2.startTraceWatch();
        }
        if (!this.passiveMonitoringOnly) {
            session1.invokeCommand(APP_NAME, "generateTraceOutput", APP_NAME + "-trace", 3, 100);
            Thread.sleep(1000L);
            if (app2 != null) {
                session2.invokeCommand(APP_NAME, "generateTraceOutput", APP_NAME + "-trace", 3, 100);
            }
        } else {
            app.generateTraceOutput(APP_NAME + "-trace", 3, 100);
            Thread.sleep(1000L);
            if (app2 != null) {
                app2.generateTraceOutput(APP_NAME + "-trace", 3, 100);
            }
        }
        if (!(matched = eventHandler.waitForTraceRecords(app2 != null ? 6 : 3, 30, TimeUnit.SECONDS, traceMatcher = new TraceRecordMatcher(){

            @Override
            public boolean match(SrvMonTraceRecord record) {
                return record.getTrace().startsWith("Trace Output ") && record.getTracerName().equals(APP_NAME + "-trace");
            }
        }))) {
            Assert.fail((String)("Didn't get expected trace records. Got: " + eventHandler.traceRecords));
        }
        session1.stopTraceWatch();
        for (SrvMonTraceRecord tr : eventHandler.traceRecords) {
            Assert.assertEquals((String)"Received wrong server name in traceRecord!", (Object)PRIMARY_XVM_NAME, (Object)tr.getXvmName());
            if (!tr.getTrace().startsWith("Trace Output ")) continue;
            Assert.assertTrue((String)"TraceRecord should have XvmHeader", (boolean)tr.hasXvmHeader());
            Assert.assertEquals((String)"Received wrong server name in traceRecord!", (Object)PRIMARY_XVM_NAME, (Object)tr.getXvmHeader().getXvmName());
        }
        if (app2 != null) {
            matched = backupEventHandler.waitForTraceRecords(6, 30, TimeUnit.SECONDS, traceMatcher);
            if (!matched) {
                Assert.fail((String)("Didn't get expected trace records from second XVM. Got: " + eventHandler.traceRecords));
            }
            session2.stopTraceWatch();
            for (SrvMonTraceRecord tr : backupEventHandler.traceRecords) {
                Assert.assertEquals((String)"Received wrong server name in traceRecord from second XVM !", (Object)BACKUP_XVM_NAME, (Object)tr.getXvmName());
                if (!tr.getTrace().startsWith("Trace Output ")) continue;
                Assert.assertTrue((String)"TraceRecord from second XVM should have XvmHeader", (boolean)tr.hasXvmHeader());
                Assert.assertEquals((String)"Received wrong server name in traceRecord from second XVM !", (Object)BACKUP_XVM_NAME, (Object)tr.getXvmHeader().getXvmName());
            }
        }
    }

    private final AdminSession connectAdminSession(String xvmName, String sessionName, AdminSession.EventHandler eventHandler) throws Exception {
        AdminSession session = null;
        Properties connectionProps = new Properties();
        connectionProps.put("nv.server.admin.connecthandshaketimeout", "30s");
        connectionProps.put("nv.server.admin.passivemonitoringonly", String.valueOf(this.passiveMonitoringOnly));
        SrvConfigDescriptor.Admin.Sma adminOverSmaConfig = app.getServerConfigDescriptor().getAdmin().getSma();
        if (this.adminOverSma) {
            connectionProps.put("nv.server.admin.transports", "sma");
            connectionProps.put("nv.server.admin.sma.bus.name", adminOverSmaConfig.getBusName());
        }
        session = AdminSessionFactory.getDefaultInstance().createAdminClientSession(sessionName, xvmName, eventHandler, DiscoveryCacheFactory.getInstance().getDefaultCache(), tracer, connectionProps);
        session.open();
        openSessions.add(session);
        return session;
    }

    private static final void disconnectAdminSession(AdminSession session) throws Exception {
        session.close();
        openSessions.remove(session);
    }

    private static final void disconnectAllSessions() throws Exception {
        while (!openSessions.isEmpty()) {
            for (AdminSession session : openSessions.toArray(new AdminSession[0])) {
                AdminSessionTest.disconnectAdminSession(session);
            }
        }
        openSessions.clear();
    }

    static {
        System.setProperty("nv.discovery.descriptor", "loopback://discovery&initWaitTime=0");
        PRIMARY_XVM_NAME = "admin-session-test-xvm-p";
        BACKUP_XVM_NAME = "admin-session-test-xvm-s";
        APP_NAME = "admin-session-test-app";
        tracer = Tracer.get((String)"test");
        openSessions = new LinkedHashSet();
    }

    private static enum XvmLayout {
        SingleXvm,
        MultipleXvm;

    }

    private static enum MonitoringMode {
        PassiveMonitoring,
        ActiveMonitoring;

    }

    private static enum Transport {
        AdminOverSma,
        AdminClient;

    }

    private static interface TraceRecordMatcher {
        public boolean match(SrvMonTraceRecord var1);
    }

    private static class AdminSessionTestEventHandler
    extends AbstractAdminSessionEventHandler {
        final ArrayList<SrvMonHeartbeatMessage> heartbeats = new ArrayList();
        final ArrayList<SrvMonTraceRecord> traceRecords = new ArrayList();
        volatile boolean holdHeartbeats;
        volatile boolean holdTraceRecords;
        volatile int numFail;
        volatile int numTraceStrings;
        volatile int numTraceRecords;
        volatile int numHeartbeats;
        volatile int numAppLoaded;
        volatile int numAppStateChanges;
        volatile int numAppBusBindingCreated;
        volatile int numAppBusBindingStateChanged;
        volatile int numAppBusBindingDestroyed;
        volatile int numAppFlowCreated;
        volatile int numAppClientDisconnected;
        volatile int numAppClientConnected;
        volatile int numAppBusChannelClosed;
        volatile int numAppBusChannelOpened;
        volatile int numAppUnloaded;

        private AdminSessionTestEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onHeartbeat(SrvMonHeartbeatMessage heartbeat) {
            ++this.numHeartbeats;
            ArrayList<SrvMonHeartbeatMessage> arrayList = this.heartbeats;
            synchronized (arrayList) {
                if (this.holdHeartbeats) {
                    this.heartbeats.add(heartbeat);
                }
                heartbeat.acquire();
                this.heartbeats.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitForHeartbeats(int numHeartbeats, int timeout, TimeUnit timeUnit) throws InterruptedException {
            ArrayList<SrvMonHeartbeatMessage> arrayList = this.heartbeats;
            synchronized (arrayList) {
                long deadline = System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
                while (this.numHeartbeats < numHeartbeats && System.currentTimeMillis() < deadline) {
                    this.heartbeats.wait(Math.max(1L, deadline - System.currentTimeMillis()));
                }
            }
            return this.numHeartbeats >= numHeartbeats;
        }

        @Override
        public void onFail(Exception cause) {
            ++this.numFail;
        }

        @Override
        public void onTraceRecord(String traceRecord) {
            ++this.numTraceStrings;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTraceRecord(SrvMonTraceRecord traceRecord) {
            ArrayList<SrvMonTraceRecord> arrayList = this.traceRecords;
            synchronized (arrayList) {
                ++this.numTraceRecords;
                ArrayList<SrvMonTraceRecord> arrayList2 = this.traceRecords;
                synchronized (arrayList2) {
                    if (this.holdTraceRecords) {
                        this.traceRecords.add(traceRecord);
                    }
                    traceRecord.acquire();
                    this.traceRecords.notifyAll();
                }
                System.out.println("GOT TRACE: <" + traceRecord.getThreadId() + "> " + traceRecord.getXvmName() + " - " + traceRecord.getTrace());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitForTraceRecords(int numTraceRecords, int timeout, TimeUnit timeUnit, TraceRecordMatcher matcher) throws InterruptedException {
            int matched = 0;
            ArrayList<SrvMonTraceRecord> arrayList = this.traceRecords;
            synchronized (arrayList) {
                long deadline = System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
                while (matched < numTraceRecords && System.currentTimeMillis() < deadline) {
                    if (matcher != null) {
                        for (int i = 0; i < this.traceRecords.size(); ++i) {
                            if (matcher.match(this.traceRecords.get(i))) {
                                ++matched;
                            }
                            if (matched < numTraceRecords) continue;
                            return true;
                        }
                        matched = 0;
                    } else {
                        matched = this.traceRecords.size();
                    }
                    this.traceRecords.wait(Math.max(1L, deadline - System.currentTimeMillis()));
                }
            }
            return matched >= numTraceRecords;
        }

        @Override
        public void onAppLoaded(String app) {
            ++this.numAppLoaded;
        }

        @Override
        public void onAppStateChanged(String app) {
            ++this.numAppStateChanges;
        }

        @Override
        public void onAppBusBindingCreated(String app, String bus) {
            ++this.numAppBusBindingCreated;
        }

        @Override
        public void onAppBusBindingStateChanged(String app, String bus) {
            ++this.numAppBusBindingStateChanged;
        }

        @Override
        public void onAppBusBindingDestroyed(String app, String bus) {
            ++this.numAppBusBindingDestroyed;
        }

        @Override
        public void onAppBusChannelOpened(String app, String bus, String channel) {
            ++this.numAppBusChannelOpened;
        }

        @Override
        public void onAppBusChannelClosed(String app, String bus, String channel) {
            ++this.numAppBusChannelClosed;
        }

        @Override
        public void onAppClientConnected(String app, String client) {
            ++this.numAppClientConnected;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAppClientDisconnected(String app, String client) {
            AdminSessionTestEventHandler adminSessionTestEventHandler = this;
            synchronized (adminSessionTestEventHandler) {
                System.out.println("App Client " + client + " Disconnected from app " + app);
                ++this.numAppClientDisconnected;
                this.notifyAll();
            }
        }

        @Override
        public void onAppFlowCreated(String app, int flowId) {
            ++this.numAppFlowCreated;
        }

        @Override
        public void onAppUnloaded(String app) {
            ++this.numAppUnloaded;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitForAppClientDisconnects(int numAppClientDisconnected, int timeout, TimeUnit timeUnit) throws InterruptedException {
            AdminSessionTestEventHandler adminSessionTestEventHandler = this;
            synchronized (adminSessionTestEventHandler) {
                long deadline = System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
                while (this.numAppClientDisconnected < numAppClientDisconnected && System.currentTimeMillis() < deadline) {
                    this.wait(Math.max(1L, deadline - System.currentTimeMillis()));
                }
            }
            return this.numAppClientDisconnected >= numAppClientDisconnected;
        }
    }
}

