/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.daemon.thread;

import com.neeve.util.UtlThread;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DmnScheduler {
    private static ScheduledExecutorService executor;
    private static AtomicInteger threadCount;

    public static ScheduledExecutorService getExecutor() {
        if (executor == null) {
            DmnScheduler.init();
        }
        return executor;
    }

    private static synchronized void init() {
        if (executor == null) {
            executor = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

                @Override
                public Thread newThread(final Runnable runnable) {
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            UtlThread.setDefaultCPUAffinityMask();
                            runnable.run();
                        }
                    }, "X-Scheduler-" + threadCount.incrementAndGet());
                    thread.setDaemon(true);
                    return thread;
                }
            });
        }
    }

    static {
        threadCount = new AtomicInteger(0);
    }
}

