/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools.interactive.commands;

import com.neeve.link.ILnkEventHandler;
import com.neeve.link.ILnkPeerEndpoint;
import com.neeve.link.LnkContainer;
import com.neeve.tools.interactive.commands.Command;

public final class Join
extends Command {
    private final LnkContainer container;
    private final ILnkEventHandler eventHandler;

    public Join(LnkContainer container, ILnkEventHandler eventHandler) {
        this.container = container;
        this.eventHandler = eventHandler;
    }

    private void processJoin(String name) {
        ILnkPeerEndpoint pep = this.container.getLink(name);
        if (pep != null) {
            System.out.println("Joining link ['" + name + "']...");
            try {
                pep.join((short)-1, this.eventHandler);
                System.out.println("Success.");
            }
            catch (Exception e) {
                System.out.println("Failure [" + e.toString() + "]");
            }
        } else {
            System.out.println("Invalid link ['" + name + "'].");
        }
    }

    public final void run(String[] args) {
        if (args.length != 1) {
            System.out.println("Syntax error: join <name>");
        } else {
            this.processJoin(args[0]);
        }
    }

    public final void help() {
        System.out.println("join <name>");
        System.out.println("  Join a link.");
    }

    public final String[] keywords() {
        return new String[]{"join"};
    }
}

