/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto.test.unit;

import com.neeve.sto.EStoFieldAlreadyPresentException;
import com.neeve.sto.EStoInsufficientSpaceException;
import com.neeve.sto.IStoBufferManager;
import com.neeve.sto.StoBooleanArrayField;
import com.neeve.sto.StoBooleanField;
import com.neeve.sto.StoBufferManager;
import com.neeve.sto.StoByteArrayField;
import com.neeve.sto.StoByteField;
import com.neeve.sto.StoCompoundArrayField;
import com.neeve.sto.StoCompoundField;
import com.neeve.sto.StoDoubleArrayField;
import com.neeve.sto.StoDoubleField;
import com.neeve.sto.StoField;
import com.neeve.sto.StoFieldContainer;
import com.neeve.sto.StoFixedLengthStringField;
import com.neeve.sto.StoFloatArrayField;
import com.neeve.sto.StoFloatField;
import com.neeve.sto.StoIntArrayField;
import com.neeve.sto.StoIntField;
import com.neeve.sto.StoLongArrayField;
import com.neeve.sto.StoShortArrayField;
import com.neeve.sto.StoShortField;
import com.neeve.sto.StoStringArrayField;
import com.neeve.sto.StoStringField;
import com.neeve.sto.test.unit.StoBooleanArrayFieldTest;
import com.neeve.sto.test.unit.StoByteArrayFieldTest;
import com.neeve.sto.test.unit.StoCompoundArrayFieldTest;
import com.neeve.sto.test.unit.StoCompoundFieldTest;
import com.neeve.sto.test.unit.StoDoubleArrayFieldTest;
import com.neeve.sto.test.unit.StoFloatArrayFieldTest;
import com.neeve.sto.test.unit.StoIntArrayFieldTest;
import com.neeve.sto.test.unit.StoLongArrayFieldTest;
import com.neeve.sto.test.unit.StoShortArrayFieldTest;
import com.neeve.sto.test.unit.StoStringArrayFieldTest;
import com.neeve.sto.test.unit.StoStringFieldTest;
import com.neeve.test.UnitTest;
import java.nio.ByteBuffer;
import java.util.Random;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class StoFieldContainerTest
extends UnitTest {
    private Random random;

    private static final StoField getFieldAtSamePos(StoFieldContainer in, StoFieldContainer from, StoField mark) {
        int i;
        for (i = 1; i <= from.count() && from.get(i) != mark; ++i) {
        }
        return i > from.count() ? null : in.get(i);
    }

    private static final void validate(TestContainer container, ByteBuffer buffer, IStoBufferManager bufferManager, StoField lateSyncBoundary, int lateSyncBoundaryMark) {
        container.validateFields(buffer);
        Assert.assertSame((Object)container.getBackingBuffer(), (Object)buffer);
        Assert.assertSame((Object)container.getBackingBufferManager(), (Object)bufferManager);
        Assert.assertSame((Object)container.getLateSyncBoundary(), (Object)lateSyncBoundary);
        if (buffer != null) {
            Assert.assertEquals((long)container.getLateSyncBoundaryMark(), (long)lateSyncBoundaryMark);
        }
    }

    private final void test_Create_SetValues(TestContainer container) {
        ((TestContainer)((TestContainer)container.createFields()).writeFields()).setFieldValues();
        StoFieldContainerTest.validate(container, null, null, container.expectedLateSyncBoundary(), container.expectedLateSyncBoundaryMark());
    }

    private final void test_Create_SetValues_SetBackingBuffer(TestContainer container) {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        ((StoFieldContainer)((TestContainer)((TestContainer)container.createFields()).writeFields()).setFieldValues()).setBackingBuffer(buffer);
        StoFieldContainerTest.validate(container, buffer, null, container.expectedLateSyncBoundary(), container.expectedLateSyncBoundaryMark());
    }

    private final void test_Create_SetBackingBuffer_SetValues(TestContainer container) {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        ((TestContainer)((StoFieldContainer)((TestContainer)container.createFields()).writeFields()).setBackingBuffer(buffer)).setFieldValues();
        StoFieldContainerTest.validate(container, buffer, null, container.expectedLateSyncBoundary(), container.expectedLateSyncBoundaryMark());
    }

    private final void test_Create_SetValues_SetBackingBufferManager(TestContainer container) {
        StoBufferManager bufferManager = StoBufferManager.create();
        ((StoFieldContainer)((TestContainer)((TestContainer)container.createFields()).writeFields()).setFieldValues()).setBackingBufferManager(bufferManager);
        StoFieldContainerTest.validate(container, bufferManager.last(), bufferManager, container.expectedLateSyncBoundary(), container.expectedLateSyncBoundaryMark());
    }

    private final void test_Create_SetBackingBufferManager_SetValues(TestContainer container) {
        StoBufferManager bufferManager = StoBufferManager.create();
        ((TestContainer)((StoFieldContainer)((TestContainer)container.createFields()).writeFields()).setBackingBufferManager(bufferManager)).setFieldValues();
        StoFieldContainerTest.validate(container, bufferManager.last(), bufferManager, container.expectedLateSyncBoundary(), container.expectedLateSyncBoundaryMark());
    }

    private final void test_Create_SetValues_SetBackingBuffer_SetBackingBuffer(TestContainer container) {
        ByteBuffer buffer1 = ByteBuffer.allocate(256);
        ByteBuffer buffer2 = ByteBuffer.allocate(256);
        ((StoFieldContainer)((TestContainer)((TestContainer)container.createFields()).writeFields()).setFieldValues()).setBackingBuffer(buffer1).setBackingBuffer(buffer2);
        StoFieldContainerTest.validate(container, buffer2, null, container.expectedLateSyncBoundary(), container.expectedLateSyncBoundaryMark());
    }

    private final void test_Create_SetBackingBuffer_SetValues_SetBackingBuffer(TestContainer container) {
        ByteBuffer buffer1 = ByteBuffer.allocate(256);
        ByteBuffer buffer2 = ByteBuffer.allocate(256);
        ((StoFieldContainer)((TestContainer)((StoFieldContainer)((TestContainer)container.createFields()).writeFields()).setBackingBuffer(buffer1)).setFieldValues()).setBackingBuffer(buffer2);
        StoFieldContainerTest.validate(container, buffer2, null, container.expectedLateSyncBoundary(), container.expectedLateSyncBoundaryMark());
    }

    private final void test_Create_SetValues_SetBackingBuffer_ClearBackingBuffer(TestContainer container) {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        ((StoFieldContainer)((TestContainer)((TestContainer)container.createFields()).writeFields()).setFieldValues()).setBackingBuffer(buffer).clearBackingBuffer();
        StoFieldContainerTest.validate(container, null, null, container.expectedLateSyncBoundary(), container.expectedLateSyncBoundaryMark());
    }

    private final void test_Create_SetBackingBuffer_SetValues_ClearBackingBuffer(TestContainer container) {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        ((StoFieldContainer)((TestContainer)((StoFieldContainer)((TestContainer)container.createFields()).writeFields()).setBackingBuffer(buffer)).setFieldValues()).clearBackingBuffer();
        StoFieldContainerTest.validate(container, null, null, container.expectedLateSyncBoundary(), container.expectedLateSyncBoundaryMark());
    }

    private final void test_Create_SetBackingBuffer_ClearBackingBuffer_SetValues(TestContainer container) {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        ((TestContainer)((StoFieldContainer)((TestContainer)container.createFields()).writeFields()).setBackingBuffer(buffer).clearBackingBuffer()).setFieldValues();
        StoFieldContainerTest.validate(container, null, null, container.expectedLateSyncBoundary(), container.expectedLateSyncBoundaryMark());
    }

    private final void test_Create_SetValues_SetBackingBufferManager_ClearBackingBufferManager(TestContainer container) {
        StoBufferManager bufferManager = StoBufferManager.create();
        ((StoFieldContainer)((TestContainer)((TestContainer)container.createFields()).writeFields()).setFieldValues()).setBackingBufferManager(bufferManager).clearBackingBufferManager();
        StoFieldContainerTest.validate(container, bufferManager.last(), null, container.expectedLateSyncBoundary(), container.expectedLateSyncBoundaryMark());
    }

    private final void test_Create_SetBackingBufferManager_SetValues_ClearBackingBufferManager(TestContainer container) {
        StoBufferManager bufferManager = StoBufferManager.create();
        ((StoFieldContainer)((TestContainer)((StoFieldContainer)((TestContainer)container.createFields()).writeFields()).setBackingBufferManager(bufferManager)).setFieldValues()).clearBackingBufferManager();
        StoFieldContainerTest.validate(container, bufferManager.last(), null, container.expectedLateSyncBoundary(), container.expectedLateSyncBoundaryMark());
    }

    private final void test_Create_SetBackingBufferManager_ClearBackingBufferManager_SetValues(TestContainer container) {
        StoBufferManager bufferManager = StoBufferManager.create();
        ((TestContainer)((StoFieldContainer)((TestContainer)container.createFields()).writeFields()).setBackingBufferManager(bufferManager).clearBackingBufferManager()).setFieldValues();
        StoFieldContainerTest.validate(container, bufferManager.last(), null, container.expectedLateSyncBoundary(), container.expectedLateSyncBoundaryMark());
    }

    private final void test_Create_SetValues_SetBackingBufferManager_SetBackingBufferManager(TestContainer container) {
        StoBufferManager bufferManager1 = StoBufferManager.create();
        StoBufferManager bufferManager2 = StoBufferManager.create();
        ((StoFieldContainer)((TestContainer)((TestContainer)container.createFields()).writeFields()).setFieldValues()).setBackingBufferManager(bufferManager1).setBackingBufferManager(bufferManager2);
        StoFieldContainerTest.validate(container, bufferManager1.last(), bufferManager2, container.expectedLateSyncBoundary(), container.expectedLateSyncBoundaryMark());
    }

    private final void test_Create_SetBackingBufferManager_SetValues_SetBackingBufferManager(TestContainer container) {
        StoBufferManager bufferManager1 = StoBufferManager.create();
        StoBufferManager bufferManager2 = StoBufferManager.create();
        ((StoFieldContainer)((TestContainer)((StoFieldContainer)((TestContainer)container.createFields()).writeFields()).setBackingBufferManager(bufferManager1)).setFieldValues()).setBackingBufferManager(bufferManager2);
        StoFieldContainerTest.validate(container, bufferManager1.last(), bufferManager2, container.expectedLateSyncBoundary(), container.expectedLateSyncBoundaryMark());
    }

    private final void test_Create_SetBackingBufferManager_SetBackingBufferManager_SetValues(TestContainer container) {
        StoBufferManager bufferManager1 = StoBufferManager.create();
        StoBufferManager bufferManager2 = StoBufferManager.create();
        ((TestContainer)((StoFieldContainer)((TestContainer)container.createFields()).writeFields()).setBackingBufferManager(bufferManager1).setBackingBufferManager(bufferManager2)).setFieldValues();
        StoFieldContainerTest.validate(container, bufferManager1.last(), bufferManager2, container.expectedLateSyncBoundary(), container.expectedLateSyncBoundaryMark());
    }

    private final void test_Create_SetValues_SetBackingBufferManager_ClearBackingBuffer(TestContainer container) {
        StoBufferManager bufferManager = StoBufferManager.create();
        ((StoFieldContainer)((TestContainer)((TestContainer)container.createFields()).writeFields()).setFieldValues()).setBackingBufferManager(bufferManager).clearBackingBuffer();
        StoFieldContainerTest.validate(container, null, bufferManager, container.expectedLateSyncBoundary(), container.expectedLateSyncBoundaryMark());
    }

    private final void test_Create_SetBackingBufferManager_SetValues_ClearBackingBuffer(TestContainer container) {
        StoBufferManager bufferManager = StoBufferManager.create();
        ((StoFieldContainer)((TestContainer)((StoFieldContainer)((TestContainer)container.createFields()).writeFields()).setBackingBufferManager(bufferManager)).setFieldValues()).clearBackingBuffer();
        StoFieldContainerTest.validate(container, null, bufferManager, container.expectedLateSyncBoundary(), container.expectedLateSyncBoundaryMark());
    }

    private final void test_Create_SetBackingBufferManager_ClearBackingBuffer_SetValues(TestContainer container) {
        StoBufferManager bufferManager = StoBufferManager.create();
        ((TestContainer)((StoFieldContainer)((TestContainer)container.createFields()).writeFields()).setBackingBufferManager(bufferManager).clearBackingBuffer()).setFieldValues();
        StoFieldContainerTest.validate(container, null, bufferManager, container.expectedLateSyncBoundary(), container.expectedLateSyncBoundaryMark());
    }

    private final void test_Create_SetValues_SetBackingBuffer_SetBackingBufferManager(TestContainer container) {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        StoBufferManager bufferManager = StoBufferManager.create();
        ((StoFieldContainer)((TestContainer)((TestContainer)container.createFields()).writeFields()).setFieldValues()).setBackingBuffer(buffer).setBackingBufferManager(bufferManager);
        StoFieldContainerTest.validate(container, buffer, bufferManager, container.expectedLateSyncBoundary(), container.expectedLateSyncBoundaryMark());
    }

    private final void test_Create_SetBackingBuffer_SetValues_SetBackingBufferManager(TestContainer container) {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        StoBufferManager bufferManager = StoBufferManager.create();
        ((StoFieldContainer)((TestContainer)((StoFieldContainer)((TestContainer)container.createFields()).writeFields()).setBackingBuffer(buffer)).setFieldValues()).setBackingBufferManager(bufferManager);
        StoFieldContainerTest.validate(container, buffer, bufferManager, container.expectedLateSyncBoundary(), container.expectedLateSyncBoundaryMark());
    }

    private final void test_Create_SetBackingBuffer_SetBackingBufferManager_SetValues(TestContainer container) {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        StoBufferManager bufferManager = StoBufferManager.create();
        ((TestContainer)((StoFieldContainer)((TestContainer)container.createFields()).writeFields()).setBackingBuffer(buffer).setBackingBufferManager(bufferManager)).setFieldValues();
        StoFieldContainerTest.validate(container, buffer, bufferManager, container.expectedLateSyncBoundary(), container.expectedLateSyncBoundaryMark());
    }

    private final void test_Create_SetValues_SetBackingBufferManager_SetBackingBuffer(TestContainer container) {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        StoBufferManager bufferManager = StoBufferManager.create();
        ((StoFieldContainer)((TestContainer)((TestContainer)container.createFields()).writeFields()).setFieldValues()).setBackingBufferManager(bufferManager).setBackingBuffer(buffer);
        StoFieldContainerTest.validate(container, buffer, bufferManager, container.expectedLateSyncBoundary(), container.expectedLateSyncBoundaryMark());
    }

    private final void test_Create_SetBackingBufferManager_SetValues_SetBackingBuffer(TestContainer container) {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        StoBufferManager bufferManager = StoBufferManager.create();
        ((StoFieldContainer)((TestContainer)((StoFieldContainer)((TestContainer)container.createFields()).writeFields()).setBackingBufferManager(bufferManager)).setFieldValues()).setBackingBuffer(buffer);
        StoFieldContainerTest.validate(container, buffer, bufferManager, container.expectedLateSyncBoundary(), container.expectedLateSyncBoundaryMark());
    }

    private final void test_Create_SetBackingBufferManager_SetBackingBuffer_SetValues(TestContainer container) {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        StoBufferManager bufferManager = StoBufferManager.create();
        ((TestContainer)((StoFieldContainer)((TestContainer)container.createFields()).writeFields()).setBackingBufferManager(bufferManager).setBackingBuffer(buffer)).setFieldValues();
        StoFieldContainerTest.validate(container, buffer, bufferManager, container.expectedLateSyncBoundary(), container.expectedLateSyncBoundaryMark());
    }

    private final void test_Create_SetValues_SetBackingBuffer_SetBackingBufferManager_ClearBackingBuffer(TestContainer container) {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        StoBufferManager bufferManager = StoBufferManager.create();
        ((StoFieldContainer)((TestContainer)((TestContainer)container.createFields()).writeFields()).setFieldValues()).setBackingBuffer(buffer).setBackingBufferManager(bufferManager).clearBackingBuffer();
        StoFieldContainerTest.validate(container, null, bufferManager, container.expectedLateSyncBoundary(), container.expectedLateSyncBoundaryMark());
    }

    private final void test_Create_SetBackingBuffer_SetValues_SetBackingBufferManager_ClearBackingBuffer(TestContainer container) {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        StoBufferManager bufferManager = StoBufferManager.create();
        ((StoFieldContainer)((TestContainer)((StoFieldContainer)((TestContainer)container.createFields()).writeFields()).setBackingBuffer(buffer)).setFieldValues()).setBackingBufferManager(bufferManager).clearBackingBuffer();
        StoFieldContainerTest.validate(container, null, bufferManager, container.expectedLateSyncBoundary(), container.expectedLateSyncBoundaryMark());
    }

    private final void test_Create_SetBackingBuffer_SetBackingBufferManager_SetValues_ClearBackingBuffer(TestContainer container) {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        StoBufferManager bufferManager = StoBufferManager.create();
        ((StoFieldContainer)((TestContainer)((StoFieldContainer)((TestContainer)container.createFields()).writeFields()).setBackingBuffer(buffer).setBackingBufferManager(bufferManager)).setFieldValues()).clearBackingBuffer();
        StoFieldContainerTest.validate(container, null, bufferManager, container.expectedLateSyncBoundary(), container.expectedLateSyncBoundaryMark());
    }

    private final void test_Create_SetBackingBuffer_SetBackingBufferManager_ClearBackingBuffer_SetValues(TestContainer container) {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        StoBufferManager bufferManager = StoBufferManager.create();
        ((TestContainer)((StoFieldContainer)((TestContainer)container.createFields()).writeFields()).setBackingBuffer(buffer).setBackingBufferManager(bufferManager).clearBackingBuffer()).setFieldValues();
        StoFieldContainerTest.validate(container, null, bufferManager, container.expectedLateSyncBoundary(), container.expectedLateSyncBoundaryMark());
    }

    private final <T extends TestContainer> void test_Deserialize(T container1, Deserializer<T> deserializer) {
        ((StoFieldContainer)((TestContainer)((TestContainer)container1.createFields()).writeFields()).setFieldValues()).setBackingBufferManager(StoBufferManager.create()).sync();
        ByteBuffer buffer = container1.getBackingBuffer();
        TestContainer container2 = (TestContainer)deserializer.deserialize(container1, (ByteBuffer)buffer.flip());
        container2.readFields();
        StoFieldContainerTest.validate(container2, buffer, null, container2.expectedLateSyncBoundary(), container2.expectedLateSyncBoundaryMark());
    }

    private final <T extends TestContainer> void test_Deserialize_UpdateFirstField(T container1, Deserializer<T> deserializer) {
        ((StoFieldContainer)((TestContainer)((TestContainer)container1.createFields()).writeFields()).setFieldValues()).setBackingBufferManager(StoBufferManager.create()).sync();
        ByteBuffer buffer = container1.getBackingBuffer();
        TestContainer container2 = (TestContainer)deserializer.deserialize(container1, (ByteBuffer)buffer.flip());
        container2.readFields();
        container2.updateFirstField();
        StoFieldContainerTest.validate(container2, buffer, null, container2.expectedLateSyncBoundary(), container2.expectedLateSyncBoundaryMark());
    }

    private final <T extends TestContainer> void test_Deserialize_UpdateMiddleField(T container1, Deserializer<T> deserializer) {
        ((StoFieldContainer)((TestContainer)((TestContainer)container1.createFields()).writeFields()).setFieldValues()).setBackingBufferManager(StoBufferManager.create()).sync();
        ByteBuffer buffer = container1.getBackingBuffer();
        TestContainer container2 = (TestContainer)deserializer.deserialize(container1, (ByteBuffer)buffer.flip());
        container2.readFields();
        container2.updateMiddleField();
        StoFieldContainerTest.validate(container2, buffer, null, container2.expectedLateSyncBoundary(), container2.expectedLateSyncBoundaryMark());
    }

    private final <T extends TestContainer> void test_Deserialize_UpdateLastField(T container1, Deserializer<T> deserializer) {
        ((StoFieldContainer)((TestContainer)((TestContainer)container1.createFields()).writeFields()).setFieldValues()).setBackingBufferManager(StoBufferManager.create()).sync();
        ByteBuffer buffer = container1.getBackingBuffer();
        TestContainer container2 = (TestContainer)deserializer.deserialize(container1, (ByteBuffer)buffer.flip());
        container2.readFields();
        container2.updateLastField();
        StoFieldContainerTest.validate(container2, buffer, null, container2.expectedLateSyncBoundary(), container2.expectedLateSyncBoundaryMark());
    }

    private final <T extends TestContainer> void test_Deserialize_SetBackingBuffer(int bufferLength, T container1, Deserializer<T> deserializer) {
        ((StoFieldContainer)((TestContainer)((TestContainer)container1.createFields()).writeFields()).setFieldValues()).setBackingBufferManager(StoBufferManager.create()).sync();
        ByteBuffer buffer = container1.getBackingBuffer();
        TestContainer container2 = (TestContainer)deserializer.deserialize(container1, (ByteBuffer)buffer.flip());
        container2.readFields();
        buffer = ByteBuffer.allocate(bufferLength);
        container2.setBackingBuffer(buffer);
        StoFieldContainerTest.validate(container2, buffer, null, container2.expectedLateSyncBoundary(), container2.expectedLateSyncBoundaryMark());
    }

    private final <T extends TestContainer> void test_Deserialize_SetBackingBuffer_Sync(int bufferLength, T container1, Deserializer<T> deserializer) {
        ((StoFieldContainer)((TestContainer)((TestContainer)container1.createFields()).writeFields()).setFieldValues()).setBackingBufferManager(StoBufferManager.create()).sync();
        ByteBuffer buffer = container1.getBackingBuffer();
        TestContainer container2 = (TestContainer)deserializer.deserialize(container1, (ByteBuffer)buffer.flip());
        container2.readFields();
        buffer = ByteBuffer.allocate(bufferLength);
        container2.setBackingBuffer(buffer).sync();
        StoFieldContainerTest.validate(container2, buffer, null, container2.expectedLateSyncBoundary(), container2.expectedLateSyncBoundaryMark());
    }

    private final <T extends TestContainer> void test_Deserialize_SetBackingBufferManager_SetBackingBuffer(int bufferLength, T container1, Deserializer<T> deserializer) {
        ((StoFieldContainer)((TestContainer)((TestContainer)container1.createFields()).writeFields()).setFieldValues()).setBackingBufferManager(StoBufferManager.create()).sync();
        ByteBuffer buffer = container1.getBackingBuffer();
        TestContainer container2 = (TestContainer)deserializer.deserialize(container1, (ByteBuffer)buffer.flip());
        container2.readFields();
        StoBufferManager bufferManager = StoBufferManager.create();
        buffer = ByteBuffer.allocate(bufferLength);
        container2.setBackingBufferManager(bufferManager).setBackingBuffer(buffer);
        StoFieldContainerTest.validate(container2, container2.getBackingBuffer(), bufferManager, container2.expectedLateSyncBoundary(), container2.expectedLateSyncBoundaryMark());
    }

    private final <T extends TestContainer> void test_Deserialize_SetBackingBufferManager_SetBackingBuffer_Sync(int bufferLength, T container1, Deserializer<T> deserializer) {
        ((StoFieldContainer)((TestContainer)((TestContainer)container1.createFields()).writeFields()).setFieldValues()).setBackingBufferManager(StoBufferManager.create()).sync();
        ByteBuffer buffer = container1.getBackingBuffer();
        TestContainer container2 = (TestContainer)deserializer.deserialize(container1, (ByteBuffer)buffer.flip());
        container2.readFields();
        StoBufferManager bufferManager = StoBufferManager.create();
        buffer = ByteBuffer.allocate(bufferLength);
        container2.setBackingBufferManager(bufferManager).setBackingBuffer(buffer).sync();
        StoFieldContainerTest.validate(container2, container2.getBackingBuffer(), bufferManager, container2.expectedLateSyncBoundary(), container2.expectedLateSyncBoundaryMark());
    }

    private final <T extends TestContainer> void test_Deserialize_SetNullBackingBuffer(T container1, Deserializer<T> deserializer) {
        ((StoFieldContainer)((TestContainer)((TestContainer)container1.createFields()).writeFields()).setFieldValues()).setBackingBufferManager(StoBufferManager.create()).sync();
        ByteBuffer buffer = container1.getBackingBuffer();
        TestContainer container2 = (TestContainer)deserializer.deserialize(container1, (ByteBuffer)buffer.flip());
        container2.readFields();
        container2.setBackingBuffer(null);
        StoFieldContainerTest.validate(container2, null, null, container2.expectedLateSyncBoundary(), container2.expectedLateSyncBoundaryMark());
    }

    private final <T extends TestContainer> void test_Deserialize_ClearBackingBuffer(T container1, Deserializer<T> deserializer) {
        ((StoFieldContainer)((TestContainer)((TestContainer)container1.createFields()).writeFields()).setFieldValues()).setBackingBufferManager(StoBufferManager.create()).sync();
        ByteBuffer buffer = container1.getBackingBuffer();
        TestContainer container2 = (TestContainer)deserializer.deserialize(container1, (ByteBuffer)buffer.flip());
        container2.readFields();
        container2.clearBackingBuffer();
        StoFieldContainerTest.validate(container2, null, null, container2.expectedLateSyncBoundary(), container2.expectedLateSyncBoundaryMark());
    }

    private final <T extends TestContainer> void test_Deserialize_AppendFixed(T container1, Deserializer<T> deserializer) {
        ((StoFieldContainer)((TestContainer)((TestContainer)container1.createFields()).writeFields()).setFieldValues()).setBackingBufferManager(StoBufferManager.create()).sync();
        ByteBuffer buffer = container1.getBackingBuffer();
        TestContainer container2 = (TestContainer)deserializer.deserialize(container1, (ByteBuffer)buffer.flip());
        container2.readFields();
        container2.appendAdditionalFixed();
    }

    private final <T extends TestContainer> void test_Deserialize_AppendFixed_Sync(T container1, Deserializer<T> deserializer) {
        ((StoFieldContainer)((TestContainer)((TestContainer)container1.createFields()).writeFields()).setFieldValues()).setBackingBufferManager(StoBufferManager.create()).sync();
        ByteBuffer buffer = container1.getBackingBuffer();
        TestContainer container2 = (TestContainer)deserializer.deserialize(container1, (ByteBuffer)buffer.flip());
        container2.readFields();
        ((StoFieldContainer)container2.appendAdditionalFixed()).sync();
    }

    private final <T extends TestContainer> void test_Deserialize_AppendVariable(T container1, Deserializer<T> deserializer) {
        ((StoFieldContainer)((TestContainer)((TestContainer)container1.createFields()).writeFields()).setFieldValues()).setBackingBufferManager(StoBufferManager.create()).sync();
        ByteBuffer buffer = container1.getBackingBuffer();
        TestContainer container2 = (TestContainer)deserializer.deserialize(container1, (ByteBuffer)buffer.flip());
        container2.readFields();
        container2.appendAdditionalVariable();
    }

    private final <T extends TestContainer> void test_Deserialize_AppendVariable_Sync(T container1, Deserializer<T> deserializer) {
        ((StoFieldContainer)((TestContainer)((TestContainer)container1.createFields()).writeFields()).setFieldValues()).setBackingBufferManager(StoBufferManager.create()).sync();
        ByteBuffer buffer = container1.getBackingBuffer();
        TestContainer container2 = (TestContainer)deserializer.deserialize(container1, (ByteBuffer)buffer.flip());
        container2.readFields();
        ((StoFieldContainer)container2.appendAdditionalVariable()).sync();
    }

    private final <T extends TestContainer> void test_Deserialize_SetBackingBufferManager_AppendFixed_Sync(T container1, Deserializer<T> deserializer) {
        ((StoFieldContainer)((TestContainer)((TestContainer)container1.createFields()).writeFields()).setFieldValues()).setBackingBufferManager(StoBufferManager.create()).sync();
        ByteBuffer buffer = container1.getBackingBuffer();
        TestContainer container2 = (TestContainer)deserializer.deserialize(container1, (ByteBuffer)buffer.flip());
        container2.readFields();
        StoBufferManager bufferManager = StoBufferManager.create();
        container2.setBackingBufferManager(bufferManager);
        StoFieldContainerTest.validate(container2, buffer, bufferManager, container2.expectedLateSyncBoundary(), container2.expectedLateSyncBoundaryMark());
        ((StoFieldContainer)container2.appendAdditionalFixed()).sync();
        StoFieldContainerTest.validate(container2, bufferManager.last(), bufferManager, container2.expectedLateSyncBoundary(), container2.expectedLateSyncBoundaryMark());
    }

    private final <T extends TestContainer> void test_Deserialize_SetBackingBufferManager_AppendVariable_Sync(T container1, Deserializer<T> deserializer) {
        ((StoFieldContainer)((TestContainer)((TestContainer)container1.createFields()).writeFields()).setFieldValues()).setBackingBufferManager(StoBufferManager.create()).sync();
        ByteBuffer buffer = container1.getBackingBuffer();
        TestContainer container2 = (TestContainer)deserializer.deserialize(container1, (ByteBuffer)buffer.flip());
        container2.readFields();
        StoBufferManager bufferManager = StoBufferManager.create();
        container2.setBackingBufferManager(bufferManager);
        StoFieldContainerTest.validate(container2, buffer, bufferManager, container2.expectedLateSyncBoundary(), container2.expectedLateSyncBoundaryMark());
        ((StoFieldContainer)container2.appendAdditionalVariable()).sync();
        StoFieldContainerTest.validate(container2, bufferManager.last(), bufferManager, container2.expectedLateSyncBoundary(), container2.expectedLateSyncBoundaryMark());
    }

    private final <T extends TestContainer> void test_Deserialize_Sync_Deserialize(T container1, Deserializer<T> deserializer) {
        ((StoFieldContainer)((TestContainer)((TestContainer)container1.createFields()).writeFields()).setFieldValues()).setBackingBufferManager(StoBufferManager.create()).sync();
        ByteBuffer buffer = container1.getBackingBuffer();
        TestContainer container2 = (TestContainer)deserializer.deserialize(container1, (ByteBuffer)buffer.flip());
        container2.readFields();
        container2.sync();
        buffer = container2.getBackingBuffer();
        TestContainer container3 = deserializer.deserialize(container2, (ByteBuffer)buffer.flip());
        container3.readFields();
        StoFieldContainerTest.validate(container3, buffer, null, container3.expectedLateSyncBoundary(), container3.expectedLateSyncBoundaryMark());
    }

    private final <T extends TestContainer> void test_Deserialize_SetBackingBufferManager_ClearBackingBuffer_Sync_Deserialize(T container1, Deserializer<T> deserializer) {
        ((StoFieldContainer)((TestContainer)((TestContainer)container1.createFields()).writeFields()).setFieldValues()).setBackingBufferManager(StoBufferManager.create()).sync();
        ByteBuffer buffer = container1.getBackingBuffer();
        TestContainer container2 = (TestContainer)deserializer.deserialize(container1, (ByteBuffer)buffer.flip());
        container2.readFields();
        StoBufferManager bufferManager = StoBufferManager.create();
        container2.setBackingBufferManager(bufferManager);
        container2.clearBackingBuffer();
        container2.sync();
        buffer = container2.getBackingBuffer();
        TestContainer container3 = deserializer.deserialize(container2, (ByteBuffer)buffer.flip());
        container3.readFields();
        StoFieldContainerTest.validate(container3, buffer, null, container3.expectedLateSyncBoundary(), container3.expectedLateSyncBoundaryMark());
    }

    private final <T extends TestContainer> void test_Deserialize_SetBackingBufferManager_AppendFixed_Sync_Deserialize(T container1, Deserializer<T> deserializer) {
        ((StoFieldContainer)((TestContainer)((TestContainer)container1.createFields()).writeFields()).setFieldValues()).setBackingBufferManager(StoBufferManager.create()).sync();
        ByteBuffer buffer = container1.getBackingBuffer();
        TestContainer container2 = (TestContainer)deserializer.deserialize(container1, (ByteBuffer)buffer.flip());
        container2.readFields();
        StoBufferManager bufferManager = StoBufferManager.create();
        container2.setBackingBufferManager(bufferManager);
        ((StoFieldContainer)container2.appendAdditionalFixed()).sync();
        buffer = container2.getBackingBuffer();
        TestContainer container3 = deserializer.deserialize(container2, (ByteBuffer)buffer.flip());
        container3.readFields();
        StoFieldContainerTest.validate(container3, buffer, null, container3.expectedLateSyncBoundary(), container3.expectedLateSyncBoundaryMark());
    }

    private final <T extends TestContainer> void test_Deserialize_SetBackingBufferManager_AppendVariable_Sync_Deserialize(T container1, Deserializer<T> deserializer) {
        ((StoFieldContainer)((TestContainer)((TestContainer)container1.createFields()).writeFields()).setFieldValues()).setBackingBufferManager(StoBufferManager.create()).sync();
        ByteBuffer buffer = container1.getBackingBuffer();
        TestContainer container2 = (TestContainer)deserializer.deserialize(container1, (ByteBuffer)buffer.flip());
        container2.readFields();
        StoBufferManager bufferManager = StoBufferManager.create();
        container2.setBackingBufferManager(bufferManager);
        ((StoFieldContainer)container2.appendAdditionalVariable()).sync();
        buffer = container2.getBackingBuffer();
        TestContainer container3 = deserializer.deserialize(container2, (ByteBuffer)buffer.flip());
        container3.readFields();
        StoFieldContainerTest.validate(container3, buffer, null, container3.expectedLateSyncBoundary(), container3.expectedLateSyncBoundaryMark());
    }

    private final <T extends TestContainer> void test_Deserialize_UpdateFirstField_Sync_Deserialize(T container1, Deserializer<T> deserializer) {
        ((StoFieldContainer)((TestContainer)((TestContainer)container1.createFields()).writeFields()).setFieldValues()).setBackingBufferManager(StoBufferManager.create()).sync();
        ByteBuffer buffer = container1.getBackingBuffer();
        TestContainer container2 = (TestContainer)deserializer.deserialize(container1, (ByteBuffer)buffer.flip());
        container2.readFields();
        ((StoFieldContainer)container2.updateFirstField()).sync();
        buffer = container2.getBackingBuffer();
        TestContainer container3 = deserializer.deserialize(container2, (ByteBuffer)buffer.flip());
        container3.readFields();
        StoFieldContainerTest.validate(container3, buffer, null, container3.expectedLateSyncBoundary(), container3.expectedLateSyncBoundaryMark());
    }

    private final <T extends TestContainer> void test_Deserialize_UpdateMiddleField_Sync_Deserialize(T container1, Deserializer<T> deserializer) {
        ((StoFieldContainer)((TestContainer)((TestContainer)container1.createFields()).writeFields()).setFieldValues()).setBackingBufferManager(StoBufferManager.create()).sync();
        ByteBuffer buffer = container1.getBackingBuffer();
        TestContainer container2 = (TestContainer)deserializer.deserialize(container1, (ByteBuffer)buffer.flip());
        container2.readFields();
        ((StoFieldContainer)container2.updateMiddleField()).sync();
        buffer = container2.getBackingBuffer();
        TestContainer container3 = deserializer.deserialize(container2, (ByteBuffer)buffer.flip());
        container3.readFields();
        StoFieldContainerTest.validate(container3, buffer, null, container3.expectedLateSyncBoundary(), container3.expectedLateSyncBoundaryMark());
    }

    private final <T extends TestContainer> void test_Deserialize_UpdateLastField_Sync_Deserialize(T container1, Deserializer<T> deserializer) {
        ((StoFieldContainer)((TestContainer)((TestContainer)container1.createFields()).writeFields()).setFieldValues()).setBackingBufferManager(StoBufferManager.create()).sync();
        ByteBuffer buffer = container1.getBackingBuffer();
        TestContainer container2 = (TestContainer)deserializer.deserialize(container1, (ByteBuffer)buffer.flip());
        container2.readFields();
        ((StoFieldContainer)container2.updateLastField()).sync();
        buffer = container2.getBackingBuffer();
        TestContainer container3 = deserializer.deserialize(container2, (ByteBuffer)buffer.flip());
        container3.readFields();
        StoFieldContainerTest.validate(container3, buffer, null, container3.expectedLateSyncBoundary(), container3.expectedLateSyncBoundaryMark());
    }

    private final <T extends TestContainer> void test_Deserialize_UpdateFirstField_SetBackingBufferManager_Sync_Deserialize(T container1, Deserializer<T> deserializer) {
        ((StoFieldContainer)((TestContainer)((TestContainer)container1.createFields()).writeFields()).setFieldValues()).setBackingBufferManager(StoBufferManager.create()).sync();
        ByteBuffer buffer = container1.getBackingBuffer();
        TestContainer container2 = (TestContainer)deserializer.deserialize(container1, (ByteBuffer)buffer.flip());
        container2.readFields();
        container2.updateFirstField();
        StoBufferManager bufferManager = StoBufferManager.create();
        container2.setBackingBufferManager(bufferManager);
        container2.sync();
        buffer = container2.getBackingBuffer();
        TestContainer container3 = deserializer.deserialize(container2, (ByteBuffer)buffer.flip());
        container3.readFields();
        StoFieldContainerTest.validate(container3, buffer, null, container3.expectedLateSyncBoundary(), container3.expectedLateSyncBoundaryMark());
    }

    private final <T extends TestContainer> void test_Deserialize_UpdateMiddleField_SetBackingBufferManager_Sync_Deserialize(T container1, Deserializer<T> deserializer) {
        ((StoFieldContainer)((TestContainer)((TestContainer)container1.createFields()).writeFields()).setFieldValues()).setBackingBufferManager(StoBufferManager.create()).sync();
        ByteBuffer buffer = container1.getBackingBuffer();
        TestContainer container2 = (TestContainer)deserializer.deserialize(container1, (ByteBuffer)buffer.flip());
        container2.readFields();
        container2.updateMiddleField();
        StoBufferManager bufferManager = StoBufferManager.create();
        container2.setBackingBufferManager(bufferManager);
        container2.sync();
        buffer = container2.getBackingBuffer();
        TestContainer container3 = deserializer.deserialize(container2, (ByteBuffer)buffer.flip());
        container3.readFields();
        StoFieldContainerTest.validate(container3, buffer, null, container3.expectedLateSyncBoundary(), container3.expectedLateSyncBoundaryMark());
    }

    private final <T extends TestContainer> void test_Deserialize_UpdateLastField_SetBackingBufferManager_Sync_Deserialize(T container1, Deserializer<T> deserializer) {
        ((StoFieldContainer)((TestContainer)((TestContainer)container1.createFields()).writeFields()).setFieldValues()).setBackingBufferManager(StoBufferManager.create()).sync();
        ByteBuffer buffer = container1.getBackingBuffer();
        TestContainer container2 = (TestContainer)deserializer.deserialize(container1, (ByteBuffer)buffer.flip());
        container2.readFields();
        container2.updateLastField();
        StoBufferManager bufferManager = StoBufferManager.create();
        container2.setBackingBufferManager(bufferManager);
        container2.sync();
        buffer = container2.getBackingBuffer();
        TestContainer container3 = deserializer.deserialize(container2, (ByteBuffer)buffer.flip());
        container3.readFields();
        StoFieldContainerTest.validate(container3, buffer, null, container3.expectedLateSyncBoundary(), container3.expectedLateSyncBoundaryMark());
    }

    private final <T extends TestContainer> void test_Deserialize_Detached(T container1, Deserializer<T> deserializer) {
        ((StoFieldContainer)((TestContainer)((TestContainer)container1.createFields()).writeFields()).setFieldValues()).setBackingBufferManager(StoBufferManager.create()).sync();
        ByteBuffer buffer = container1.getBackingBuffer();
        TestContainer container2 = (TestContainer)deserializer.deserialize(container1, (ByteBuffer)buffer.flip());
        container2.readFields();
        StoFieldContainerTest.validate(container2, null, null, container2.expectedLateSyncBoundary(), container2.expectedLateSyncBoundaryMark());
    }

    private final <T extends TestContainer> void test_Create_SetValues_Sync(int bufferLength, T container1, Deserializer<T> deserializer) {
        ByteBuffer buffer = ByteBuffer.allocate(bufferLength);
        ((StoFieldContainer)((TestContainer)((TestContainer)container1.createFields()).writeFields()).setFieldValues()).sync(buffer, 0);
        StoFieldContainerTest.validate(container1, null, null, container1.expectedLateSyncBoundary(), container1.expectedLateSyncBoundaryMark());
        TestContainer container2 = (TestContainer)deserializer.deserialize(container1, (ByteBuffer)buffer.flip());
        container2.readFields();
        StoFieldContainerTest.validate(container2, buffer, null, container2.expectedLateSyncBoundary(), container2.expectedLateSyncBoundaryMark());
    }

    private final <T extends TestContainer> void test_SetBackingBuffer_NoClear(T container1, T container2, Deserializer<T> deserializer) {
        ((StoFieldContainer)((TestContainer)((TestContainer)container1.createFields()).writeFields()).setFieldValues()).setBackingBufferManager(StoBufferManager.create()).sync();
        ((StoFieldContainer)((TestContainer)((TestContainer)container2.createFields()).writeFields()).setFieldValues()).setBackingBufferManager(StoBufferManager.create()).sync();
        container2.setBackingBuffer(container1.getBackingBuffer(), false);
        StoFieldContainerTest.validate(container2, container1.getBackingBuffer(), container2.getBackingBufferManager(), container2.expectedLateSyncBoundary(), container2.expectedLateSyncBoundaryMark());
    }

    private final <T extends TestContainer> void test_ChangeBackingBuffer(T container1, T container2, Deserializer<T> deserializer) {
        ((TestContainer)((TestContainer)container1.createFields()).writeFields()).setFieldValues();
        container1.setBackingBufferManager(StoBufferManager.create()).sync();
        ((TestContainer)((TestContainer)container2.createFields()).writeFields()).setFieldValues();
        container2.setBackingBufferManager(StoBufferManager.create()).sync();
        container2.init(container1);
        container2.changeBackingBuffer((ByteBuffer)container1.getBackingBuffer().flip());
        StoFieldContainerTest.validate(container2, container1.getBackingBuffer(), container2.getBackingBufferManager(), container2.expectedLateSyncBoundary(), container2.expectedLateSyncBoundaryMark());
    }

    @Before
    public void initialize() {
        this.random = new Random(System.currentTimeMillis());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateWithNullBuffer() {
        StoFieldContainer.create(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetFieldOffsetWithNullBuffer() {
        StoFieldContainer.getFieldOffset(null, 1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetFieldOffsetWithZeroPos() {
        StoFieldContainer.getFieldOffset(ByteBuffer.allocate(256), 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetFieldOffsetWithNegativePos() {
        StoFieldContainer.getFieldOffset(ByteBuffer.allocate(256), -10);
    }

    @Test
    public void testClearBackingBufferManagerOnContainerWithNoManager() {
        StoFieldContainer.create().clearBackingBufferManager();
    }

    @Test
    public void testClearBackingBufferManagerOnContainerWithNoBuffer() {
        StoFieldContainer.create().clearBackingBuffer();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAppendWithNullField() {
        StoFieldContainer container = StoFieldContainer.create();
        container.append(null);
    }

    @Test(expected=EStoFieldAlreadyPresentException.class)
    public void testAppendWithExistingField() {
        StoFieldContainer container = StoFieldContainer.create();
        StoIntField field = StoIntField.create(null);
        container.append(field);
        container.append(field);
    }

    @Test(expected=EStoFieldAlreadyPresentException.class)
    public void testAppendWithExistingFieldName() {
        StoFieldContainer container = StoFieldContainer.create();
        container.append(StoIntField.create("field"));
        container.append(StoIntField.create("field"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetWithWithZeroPos() {
        StoFieldContainer.create().get(0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetWithWithNegativePos() {
        StoFieldContainer.create().get(-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetWithWithNullName() {
        StoFieldContainer.create().get(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSyncWithNullBuffer() {
        StoFieldContainer.create().sync(null, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSyncWithNegativeOffset() {
        StoFieldContainer.create().sync(ByteBuffer.allocate(256), -1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSyncWithOffsetGreaterThanBufferCapacity() {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        StoFieldContainer.create().sync(buffer, buffer.capacity() + 1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testChangeBackingBufferWithNullBuffer() {
        StoFieldContainer.create().changeBackingBuffer(null);
    }

    @Test
    public void testEmptyContainer_Create_SetValues() {
        this.test_Create_SetValues(new EmptyContainer());
    }

    @Test
    public void testEmptyContainer_Create_SetValues_SetBackingBuffer() {
        this.test_Create_SetValues_SetBackingBuffer(new EmptyContainer());
    }

    @Test
    public void testEmptyContainer_Create_SetBackingBuffer_SetValues() {
        this.test_Create_SetBackingBuffer_SetValues(new EmptyContainer());
    }

    @Test
    public void testEmptyContainer_Create_SetValues_SetBackingBufferManager() {
        this.test_Create_SetValues_SetBackingBufferManager(new EmptyContainer());
    }

    @Test
    public void testEmptyContainer_Create_SetBackingBufferManager_SetValues() {
        this.test_Create_SetBackingBufferManager_SetValues(new EmptyContainer());
    }

    @Test
    public void testEmptyContainer_Create_SetValues_SetBackingBuffer_ClearBackingBuffer() {
        this.test_Create_SetValues_SetBackingBuffer_ClearBackingBuffer(new EmptyContainer());
    }

    @Test
    public void testEmptyContainer_Create_SetBackingBuffer_SetValues_ClearBackingBuffer() {
        this.test_Create_SetBackingBuffer_SetValues_ClearBackingBuffer(new EmptyContainer());
    }

    @Test
    public void testEmptyContainer_Create_SetValues_SetBackingBuffer_SetBackingBuffer() {
        this.test_Create_SetValues_SetBackingBuffer_SetBackingBuffer(new EmptyContainer());
    }

    @Test
    public void testEmptyContainer_Create_SetBackingBuffer_SetValues_SetBackingBuffer() {
        this.test_Create_SetBackingBuffer_SetValues_SetBackingBuffer(new EmptyContainer());
    }

    @Test
    public void testEmptyContainer_Create_SetBackingBuffer_ClearBackingBuffer_SetValues() {
        this.test_Create_SetBackingBuffer_ClearBackingBuffer_SetValues(new EmptyContainer());
    }

    @Test
    public void testEmptyContainer_Create_SetValues_SetBackingBufferManager_ClearBackingBufferManager() {
        this.test_Create_SetValues_SetBackingBufferManager_ClearBackingBufferManager(new EmptyContainer());
    }

    @Test
    public void testEmptyContainer_Create_SetBackingBufferManager_SetValues_ClearBackingBufferManager() {
        this.test_Create_SetBackingBufferManager_SetValues_ClearBackingBufferManager(new EmptyContainer());
    }

    @Test
    public void testEmptyContainer_Create_SetBackingBufferManager_ClearBackingBufferManager_SetValues() {
        this.test_Create_SetBackingBufferManager_ClearBackingBufferManager_SetValues(new EmptyContainer());
    }

    @Test
    public void testEmptyContainer_Create_SetValues_SetBackingBufferManager_SetBackingBufferManager() {
        this.test_Create_SetValues_SetBackingBufferManager_SetBackingBufferManager(new EmptyContainer());
    }

    @Test
    public void testEmptyContainer_Create_SetBackingBufferManager_SetValues_SetBackingBufferManager() {
        this.test_Create_SetBackingBufferManager_SetValues_SetBackingBufferManager(new EmptyContainer());
    }

    @Test
    public void testEmptyContainer_Create_SetBackingBufferManager_SetBackingBufferManager_SetValues() {
        this.test_Create_SetBackingBufferManager_SetBackingBufferManager_SetValues(new EmptyContainer());
    }

    @Test
    public void testEmptyContainer_Create_SetValues_SetBackingBufferManager_ClearBackingBuffer() {
        this.test_Create_SetValues_SetBackingBufferManager_ClearBackingBuffer(new EmptyContainer());
    }

    @Test
    public void testEmptyContainer_Create_SetBackingBufferManager_SetValues_ClearBackingBuffer() {
        this.test_Create_SetBackingBufferManager_SetValues_ClearBackingBuffer(new EmptyContainer());
    }

    @Test
    public void testEmptyContainer_Create_SetBackingBufferManager_ClearBackingBuffer_SetValues() {
        this.test_Create_SetBackingBufferManager_ClearBackingBuffer_SetValues(new EmptyContainer());
    }

    @Test
    public void testEmptyContainer_Create_SetValues_SetBackingBuffer_SetBackingBufferManager() {
        this.test_Create_SetValues_SetBackingBuffer_SetBackingBufferManager(new EmptyContainer());
    }

    @Test
    public void testEmptyContainer_Create_SetBackingBuffer_SetValues_SetBackingBufferManager() {
        this.test_Create_SetBackingBuffer_SetValues_SetBackingBufferManager(new EmptyContainer());
    }

    @Test
    public void testEmptyContainer_Create_SetBackingBuffer_SetBackingBufferManager_SetValues() {
        this.test_Create_SetBackingBuffer_SetBackingBufferManager_SetValues(new EmptyContainer());
    }

    @Test
    public void testEmptyContainer_Create_SetValues_SetBackingBufferManager_SetBackingBuffer() {
        this.test_Create_SetValues_SetBackingBufferManager_SetBackingBuffer(new EmptyContainer());
    }

    @Test
    public void testEmptyContainer_Create_SetBackingBufferManager_SetValues_SetBackingBuffer() {
        this.test_Create_SetBackingBufferManager_SetValues_SetBackingBuffer(new EmptyContainer());
    }

    @Test
    public void testEmptyContainer_Create_SetBackingBufferManager_SetBackingBuffer_SetValues() {
        this.test_Create_SetBackingBufferManager_SetBackingBuffer_SetValues(new EmptyContainer());
    }

    @Test
    public void testEmptyContainer_Create_SetValues_SetBackingBuffer_SetBackingBufferManager_ClearBackingBuffer() {
        this.test_Create_SetValues_SetBackingBuffer_SetBackingBufferManager_ClearBackingBuffer(new EmptyContainer());
    }

    @Test
    public void testEmptyContainer_Create_SetBackingBuffer_SetValues_SetBackingBufferManager_ClearBackingBuffer() {
        this.test_Create_SetBackingBuffer_SetValues_SetBackingBufferManager_ClearBackingBuffer(new EmptyContainer());
    }

    @Test
    public void testEmptyContainer_Create_SetBackingBuffer_SetBackingBufferManager_SetValues_ClearBackingBuffer() {
        this.test_Create_SetBackingBuffer_SetBackingBufferManager_SetValues_ClearBackingBuffer(new EmptyContainer());
    }

    @Test
    public void testEmptyContainer_Create_SetBackingBuffer_SetBackingBufferManager_ClearBackingBuffer_SetValues() {
        this.test_Create_SetBackingBuffer_SetBackingBufferManager_ClearBackingBuffer_SetValues(new EmptyContainer());
    }

    @Test
    public void testEmptyContainer_Deserialize() {
        this.test_Deserialize(new EmptyContainer(), new Deserializer<EmptyContainer>(){

            @Override
            final EmptyContainer deserialize(EmptyContainer from, ByteBuffer buffer) {
                return new EmptyContainer(from, buffer);
            }
        });
    }

    @Test
    public void testEmptyContainer_Deserialize_SetBackingBuffer() {
        this.test_Deserialize_SetBackingBuffer(32, new EmptyContainer(), new Deserializer<EmptyContainer>(){

            @Override
            final EmptyContainer deserialize(EmptyContainer from, ByteBuffer buffer) {
                return new EmptyContainer(from, buffer);
            }
        });
    }

    @Test
    public void testEmptyContainer_Deserialize_SetBackingBuffer_Sync() {
        this.test_Deserialize_SetBackingBuffer_Sync(32, new EmptyContainer(), new Deserializer<EmptyContainer>(){

            @Override
            final EmptyContainer deserialize(EmptyContainer from, ByteBuffer buffer) {
                return new EmptyContainer(from, buffer);
            }
        });
    }

    @Test
    public void testEmptyContainer_Deserialize_setBackingBufferManager_SetBackingBuffer() {
        this.test_Deserialize_SetBackingBufferManager_SetBackingBuffer(32, new EmptyContainer(), new Deserializer<EmptyContainer>(){

            @Override
            final EmptyContainer deserialize(EmptyContainer from, ByteBuffer buffer) {
                return new EmptyContainer(from, buffer);
            }
        });
    }

    @Test
    public void testEmptyContainer_Deserialize_setBackingBufferManager_SetBackingBuffer_Sync() {
        this.test_Deserialize_SetBackingBufferManager_SetBackingBuffer_Sync(32, new EmptyContainer(), new Deserializer<EmptyContainer>(){

            @Override
            final EmptyContainer deserialize(EmptyContainer from, ByteBuffer buffer) {
                return new EmptyContainer(from, buffer);
            }
        });
    }

    @Test
    public void testEmptyContainer_Deserialize_SetNullBackingBuffer() {
        this.test_Deserialize_SetNullBackingBuffer(new EmptyContainer(), new Deserializer<EmptyContainer>(){

            @Override
            final EmptyContainer deserialize(EmptyContainer from, ByteBuffer buffer) {
                return new EmptyContainer(from, buffer);
            }
        });
    }

    @Test
    public void testEmptyContainer_Deserialize_ClearBackingBuffer() {
        this.test_Deserialize_ClearBackingBuffer(new EmptyContainer(), new Deserializer<EmptyContainer>(){

            @Override
            final EmptyContainer deserialize(EmptyContainer from, ByteBuffer buffer) {
                return new EmptyContainer(from, buffer);
            }
        });
    }

    @Test(expected=EStoInsufficientSpaceException.class)
    public void testEmptyContainer_Deserialize_AppendFixed() {
        this.test_Deserialize_AppendFixed(new EmptyContainer(), new Deserializer<EmptyContainer>(){

            @Override
            final EmptyContainer deserialize(EmptyContainer from, ByteBuffer buffer) {
                return new EmptyContainer(from, buffer);
            }
        });
    }

    @Test(expected=EStoInsufficientSpaceException.class)
    public void testEmptyContainer_Deserialize_AppendFixed_Sync() {
        this.test_Deserialize_AppendFixed_Sync(new EmptyContainer(), new Deserializer<EmptyContainer>(){

            @Override
            final EmptyContainer deserialize(EmptyContainer from, ByteBuffer buffer) {
                return new EmptyContainer(from, buffer);
            }
        });
    }

    @Test
    public void testEmptyContainer_Deserialize_AppendVariable() {
        this.test_Deserialize_AppendVariable(new EmptyContainer(), new Deserializer<EmptyContainer>(){

            @Override
            final EmptyContainer deserialize(EmptyContainer from, ByteBuffer buffer) {
                return new EmptyContainer(from, buffer);
            }
        });
    }

    @Test(expected=EStoInsufficientSpaceException.class)
    public void testEmptyContainer_Deserialize_AppendVariable_Sync() {
        this.test_Deserialize_AppendVariable_Sync(new EmptyContainer(), new Deserializer<EmptyContainer>(){

            @Override
            final EmptyContainer deserialize(EmptyContainer from, ByteBuffer buffer) {
                return new EmptyContainer(from, buffer);
            }
        });
    }

    @Test
    public void testEmptyContainer_Deserialize_SetBackingBufferManager_AppendFixed_Sync() {
        this.test_Deserialize_SetBackingBufferManager_AppendFixed_Sync(new EmptyContainer(), new Deserializer<EmptyContainer>(){

            @Override
            final EmptyContainer deserialize(EmptyContainer from, ByteBuffer buffer) {
                return new EmptyContainer(from, buffer);
            }
        });
    }

    @Test
    public void testEmptyContainer_Deserialize_SetBackingBufferManager_AppendVariable_Sync() {
        this.test_Deserialize_SetBackingBufferManager_AppendVariable_Sync(new EmptyContainer(), new Deserializer<EmptyContainer>(){

            @Override
            final EmptyContainer deserialize(EmptyContainer from, ByteBuffer buffer) {
                return new EmptyContainer(from, buffer);
            }
        });
    }

    @Test
    public void testEmptyContainer_Deserialize_Sync_Deserialize() {
        this.test_Deserialize_Sync_Deserialize(new EmptyContainer(), new Deserializer<EmptyContainer>(){

            @Override
            final EmptyContainer deserialize(EmptyContainer from, ByteBuffer buffer) {
                return new EmptyContainer(from, buffer);
            }
        });
    }

    @Test
    public void testEmptyContainer_Deserialize_SetBackingBufferManager_ClearBackingBuffer_Sync_Deserialize() {
        this.test_Deserialize_SetBackingBufferManager_ClearBackingBuffer_Sync_Deserialize(new EmptyContainer(), new Deserializer<EmptyContainer>(){

            @Override
            final EmptyContainer deserialize(EmptyContainer from, ByteBuffer buffer) {
                return new EmptyContainer(from, buffer);
            }
        });
    }

    @Test
    public void testEmptyContainer_Deserialize_SetBackingBufferManager_AppendFixed_Sync_Deserialize() {
        this.test_Deserialize_SetBackingBufferManager_AppendFixed_Sync_Deserialize(new EmptyContainer(), new Deserializer<EmptyContainer>(){

            @Override
            final EmptyContainer deserialize(EmptyContainer from, ByteBuffer buffer) {
                return new EmptyContainer(from, buffer);
            }
        });
    }

    @Test
    public void testEmptyContainer_Deserialize_SetBackingBufferManager_AppendVariable_Sync_Deserialize() {
        this.test_Deserialize_SetBackingBufferManager_AppendVariable_Sync_Deserialize(new EmptyContainer(), new Deserializer<EmptyContainer>(){

            @Override
            final EmptyContainer deserialize(EmptyContainer from, ByteBuffer buffer) {
                return new EmptyContainer(from, buffer);
            }
        });
    }

    @Test
    public void testEmptyContainer_Deserialize_Detached() {
        this.test_Deserialize_Detached(new EmptyContainer(), new Deserializer<EmptyContainer>(){

            @Override
            final EmptyContainer deserialize(EmptyContainer from, ByteBuffer buffer) {
                return new EmptyContainer(from, buffer, false);
            }
        });
    }

    @Test
    public void testEmptyContainer_Create_SetValues_Sync() {
        this.test_Create_SetValues_Sync(256, new EmptyContainer(), new Deserializer<EmptyContainer>(){

            @Override
            final EmptyContainer deserialize(EmptyContainer from, ByteBuffer buffer) {
                return new EmptyContainer(from, buffer);
            }
        });
    }

    @Test
    public void testEmptyContainer_SetBackingBuffer_NoClear() {
        this.test_SetBackingBuffer_NoClear(new EmptyContainer(), new EmptyContainer(), new Deserializer<EmptyContainer>(){

            @Override
            final EmptyContainer deserialize(EmptyContainer from, ByteBuffer buffer) {
                return new EmptyContainer(from, buffer);
            }
        });
    }

    @Test
    public void testEmptyContainer_ChangeBackingBuffer() {
        this.test_ChangeBackingBuffer(new EmptyContainer(), new EmptyContainer(), new Deserializer<EmptyContainer>(){

            @Override
            final EmptyContainer deserialize(EmptyContainer from, ByteBuffer buffer) {
                return new EmptyContainer(from, buffer);
            }
        });
    }

    @Test
    public void testFixedLengthContainer_Create_SetValues() {
        this.test_Create_SetValues(new FixedLengthContainer());
    }

    @Test
    public void testFixedLengthContainer_Create_SetValues_SetBackingBuffer() {
        this.test_Create_SetValues_SetBackingBuffer(new FixedLengthContainer());
    }

    @Test
    public void testFixedLengthContainer_Create_SetBackingBuffer_SetValues() {
        this.test_Create_SetBackingBuffer_SetValues(new FixedLengthContainer());
    }

    @Test
    public void testFixedLengthContainer_Create_SetValues_SetBackingBufferManager() {
        this.test_Create_SetValues_SetBackingBufferManager(new FixedLengthContainer());
    }

    @Test
    public void testFixedLengthContainer_Create_SetBackingBufferManager_SetValues() {
        this.test_Create_SetBackingBufferManager_SetValues(new FixedLengthContainer());
    }

    @Test
    public void testFixedLengthContainer_Create_SetValues_SetBackingBuffer_ClearBackingBuffer() {
        this.test_Create_SetValues_SetBackingBuffer_ClearBackingBuffer(new FixedLengthContainer());
    }

    @Test
    public void testFixedLengthContainer_Create_SetBackingBuffer_SetValues_ClearBackingBuffer() {
        this.test_Create_SetBackingBuffer_SetValues_ClearBackingBuffer(new FixedLengthContainer());
    }

    @Test
    public void testFixedLengthContainer_Create_SetValues_SetBackingBuffer_SetBackingBuffer() {
        this.test_Create_SetValues_SetBackingBuffer_SetBackingBuffer(new FixedLengthContainer());
    }

    @Test
    public void testFixedLengthContainer_Create_SetBackingBuffer_SetValues_SetBackingBuffer() {
        this.test_Create_SetBackingBuffer_SetValues_SetBackingBuffer(new FixedLengthContainer());
    }

    @Test
    public void testFixedLengthContainer_Create_SetBackingBuffer_ClearBackingBuffer_SetValues() {
        this.test_Create_SetBackingBuffer_ClearBackingBuffer_SetValues(new FixedLengthContainer());
    }

    @Test
    public void testFixedLengthContainer_Create_SetValues_SetBackingBufferManager_ClearBackingBufferManager() {
        this.test_Create_SetValues_SetBackingBufferManager_ClearBackingBufferManager(new FixedLengthContainer());
    }

    @Test
    public void testFixedLengthContainer_Create_SetBackingBufferManager_SetValues_ClearBackingBufferManager() {
        this.test_Create_SetBackingBufferManager_SetValues_ClearBackingBufferManager(new FixedLengthContainer());
    }

    @Test
    public void testFixedLengthContainer_Create_SetBackingBufferManager_ClearBackingBufferManager_SetValues() {
        this.test_Create_SetBackingBufferManager_ClearBackingBufferManager_SetValues(new FixedLengthContainer());
    }

    @Test
    public void testFixedLengthContainer_Create_SetValues_SetBackingBufferManager_SetBackingBufferManager() {
        this.test_Create_SetValues_SetBackingBufferManager_SetBackingBufferManager(new FixedLengthContainer());
    }

    @Test
    public void testFixedLengthContainer_Create_SetBackingBufferManager_SetValues_SetBackingBufferManager() {
        this.test_Create_SetBackingBufferManager_SetValues_SetBackingBufferManager(new FixedLengthContainer());
    }

    @Test
    public void testFixedLengthContainer_Create_SetBackingBufferManager_SetBackingBufferManager_SetValues() {
        this.test_Create_SetBackingBufferManager_SetBackingBufferManager_SetValues(new FixedLengthContainer());
    }

    @Test
    public void testFixedLengthContainer_Create_SetValues_SetBackingBufferManager_ClearBackingBuffer() {
        this.test_Create_SetValues_SetBackingBufferManager_ClearBackingBuffer(new FixedLengthContainer());
    }

    @Test
    public void testFixedLengthContainer_Create_SetBackingBufferManager_SetValues_ClearBackingBuffer() {
        this.test_Create_SetBackingBufferManager_SetValues_ClearBackingBuffer(new FixedLengthContainer());
    }

    @Test
    public void testFixedLengthContainer_Create_SetBackingBufferManager_ClearBackingBuffer_SetValues() {
        this.test_Create_SetBackingBufferManager_ClearBackingBuffer_SetValues(new FixedLengthContainer());
    }

    @Test
    public void testFixedLengthContainer_Create_SetValues_SetBackingBuffer_SetBackingBufferManager() {
        this.test_Create_SetValues_SetBackingBuffer_SetBackingBufferManager(new FixedLengthContainer());
    }

    @Test
    public void testFixedLengthContainer_Create_SetBackingBuffer_SetValues_SetBackingBufferManager() {
        this.test_Create_SetBackingBuffer_SetValues_SetBackingBufferManager(new FixedLengthContainer());
    }

    @Test
    public void testFixedLengthContainer_Create_SetBackingBuffer_SetBackingBufferManager_SetValues() {
        this.test_Create_SetBackingBuffer_SetBackingBufferManager_SetValues(new FixedLengthContainer());
    }

    @Test
    public void testFixedLengthContainer_Create_SetValues_SetBackingBufferManager_SetBackingBuffer() {
        this.test_Create_SetValues_SetBackingBufferManager_SetBackingBuffer(new FixedLengthContainer());
    }

    @Test
    public void testFixedLengthContainer_Create_SetBackingBufferManager_SetValues_SetBackingBuffer() {
        this.test_Create_SetBackingBufferManager_SetValues_SetBackingBuffer(new FixedLengthContainer());
    }

    @Test
    public void testFixedLengthContainer_Create_SetBackingBufferManager_SetBackingBuffer_SetValues() {
        this.test_Create_SetBackingBufferManager_SetBackingBuffer_SetValues(new FixedLengthContainer());
    }

    @Test
    public void testFixedLengthContainer_Create_SetValues_SetBackingBuffer_SetBackingBufferManager_ClearBackingBuffer() {
        this.test_Create_SetValues_SetBackingBuffer_SetBackingBufferManager_ClearBackingBuffer(new FixedLengthContainer());
    }

    @Test
    public void testFixedLengthContainer_Create_SetBackingBuffer_SetValues_SetBackingBufferManager_ClearBackingBuffer() {
        this.test_Create_SetBackingBuffer_SetValues_SetBackingBufferManager_ClearBackingBuffer(new FixedLengthContainer());
    }

    @Test
    public void testFixedLengthContainer_Create_SetBackingBuffer_SetBackingBufferManager_SetValues_ClearBackingBuffer() {
        this.test_Create_SetBackingBuffer_SetBackingBufferManager_SetValues_ClearBackingBuffer(new FixedLengthContainer());
    }

    @Test
    public void testFixedLengthContainer_Create_SetBackingBuffer_SetBackingBufferManager_ClearBackingBuffer_SetValues() {
        this.test_Create_SetBackingBuffer_SetBackingBufferManager_ClearBackingBuffer_SetValues(new FixedLengthContainer());
    }

    @Test
    public void testFixedLengthContainer_Deserialize() {
        this.test_Deserialize(new FixedLengthContainer(), new Deserializer<FixedLengthContainer>(){

            @Override
            final FixedLengthContainer deserialize(FixedLengthContainer from, ByteBuffer buffer) {
                return new FixedLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testFixedLengthContainer_Deserialize_UpdateFirstField() {
        this.test_Deserialize_UpdateFirstField(new FixedLengthContainer(), new Deserializer<FixedLengthContainer>(){

            @Override
            final FixedLengthContainer deserialize(FixedLengthContainer from, ByteBuffer buffer) {
                return new FixedLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testFixedLengthContainer_Deserialize_UpdateMiddleField() {
        this.test_Deserialize_UpdateMiddleField(new FixedLengthContainer(), new Deserializer<FixedLengthContainer>(){

            @Override
            final FixedLengthContainer deserialize(FixedLengthContainer from, ByteBuffer buffer) {
                return new FixedLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testFixedLengthContainer_Deserialize_UpdateLastField() {
        this.test_Deserialize_UpdateLastField(new FixedLengthContainer(), new Deserializer<FixedLengthContainer>(){

            @Override
            final FixedLengthContainer deserialize(FixedLengthContainer from, ByteBuffer buffer) {
                return new FixedLengthContainer(from, buffer);
            }
        });
    }

    @Test(expected=EStoInsufficientSpaceException.class)
    public void testFixedLengthContainer_Deserialize_SetBackingBuffer_InsufficientSpace() {
        this.test_Deserialize_SetBackingBuffer(32, new FixedLengthContainer(), new Deserializer<FixedLengthContainer>(){

            @Override
            final FixedLengthContainer deserialize(FixedLengthContainer from, ByteBuffer buffer) {
                return new FixedLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testFixedLengthContainer_Deserialize_SetBackingBuffer_SufficientSpace() {
        this.test_Deserialize_SetBackingBuffer(256, new FixedLengthContainer(), new Deserializer<FixedLengthContainer>(){

            @Override
            final FixedLengthContainer deserialize(FixedLengthContainer from, ByteBuffer buffer) {
                return new FixedLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testFixedLengthContainer_Deserialize_SetBackingBuffer_SufficientSpace_Sync() {
        this.test_Deserialize_SetBackingBuffer_Sync(256, new FixedLengthContainer(), new Deserializer<FixedLengthContainer>(){

            @Override
            final FixedLengthContainer deserialize(FixedLengthContainer from, ByteBuffer buffer) {
                return new FixedLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testFixedLengthContainer_Deserialize_SetBackingBufferManager_SetBackingBuffer() {
        this.test_Deserialize_SetBackingBufferManager_SetBackingBuffer(32, new FixedLengthContainer(), new Deserializer<FixedLengthContainer>(){

            @Override
            final FixedLengthContainer deserialize(FixedLengthContainer from, ByteBuffer buffer) {
                return new FixedLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testFixedLengthContainer_Deserialize_SetBackingBufferManager_SetBackingBuffer_Sync() {
        this.test_Deserialize_SetBackingBufferManager_SetBackingBuffer_Sync(32, new FixedLengthContainer(), new Deserializer<FixedLengthContainer>(){

            @Override
            final FixedLengthContainer deserialize(FixedLengthContainer from, ByteBuffer buffer) {
                return new FixedLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testFixedLengthContainer_Deserialize_SetNullBackingBuffer() {
        this.test_Deserialize_SetNullBackingBuffer(new FixedLengthContainer(), new Deserializer<FixedLengthContainer>(){

            @Override
            final FixedLengthContainer deserialize(FixedLengthContainer from, ByteBuffer buffer) {
                return new FixedLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testFixedLengthContainer_Deserialize_ClearBackingBuffer() {
        this.test_Deserialize_ClearBackingBuffer(new FixedLengthContainer(), new Deserializer<FixedLengthContainer>(){

            @Override
            final FixedLengthContainer deserialize(FixedLengthContainer from, ByteBuffer buffer) {
                return new FixedLengthContainer(from, buffer);
            }
        });
    }

    @Test(expected=EStoInsufficientSpaceException.class)
    public void testFixedLengthContainer_Deserialize_AppendFixed() {
        this.test_Deserialize_AppendFixed(new FixedLengthContainer(), new Deserializer<FixedLengthContainer>(){

            @Override
            final FixedLengthContainer deserialize(FixedLengthContainer from, ByteBuffer buffer) {
                return new FixedLengthContainer(from, buffer);
            }
        });
    }

    @Test(expected=EStoInsufficientSpaceException.class)
    public void testFixedLengthContainer_Deserialize_AppendFixed_Sync() {
        this.test_Deserialize_AppendFixed_Sync(new FixedLengthContainer(), new Deserializer<FixedLengthContainer>(){

            @Override
            final FixedLengthContainer deserialize(FixedLengthContainer from, ByteBuffer buffer) {
                return new FixedLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testFixedLengthContainer_Deserialize_AppendVariable() {
        this.test_Deserialize_AppendVariable(new FixedLengthContainer(), new Deserializer<FixedLengthContainer>(){

            @Override
            final FixedLengthContainer deserialize(FixedLengthContainer from, ByteBuffer buffer) {
                return new FixedLengthContainer(from, buffer);
            }
        });
    }

    @Test(expected=EStoInsufficientSpaceException.class)
    public void testFixedLengthContainer_Deserialize_AppendVariable_Sync() {
        this.test_Deserialize_AppendVariable_Sync(new FixedLengthContainer(), new Deserializer<FixedLengthContainer>(){

            @Override
            final FixedLengthContainer deserialize(FixedLengthContainer from, ByteBuffer buffer) {
                return new FixedLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testFixedLengthContainer_Deserialize_SetBackingBufferManager_AppendFixed_Sync() {
        this.test_Deserialize_SetBackingBufferManager_AppendFixed_Sync(new FixedLengthContainer(), new Deserializer<FixedLengthContainer>(){

            @Override
            final FixedLengthContainer deserialize(FixedLengthContainer from, ByteBuffer buffer) {
                return new FixedLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testFixedLengthContainer_Deserialize_SetBackingBufferManager_AppendVariable_Sync() {
        this.test_Deserialize_SetBackingBufferManager_AppendVariable_Sync(new FixedLengthContainer(), new Deserializer<FixedLengthContainer>(){

            @Override
            final FixedLengthContainer deserialize(FixedLengthContainer from, ByteBuffer buffer) {
                return new FixedLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testFixedLengthContainer_Deserialize_Sync_Deserialize() {
        this.test_Deserialize_Sync_Deserialize(new FixedLengthContainer(), new Deserializer<FixedLengthContainer>(){

            @Override
            final FixedLengthContainer deserialize(FixedLengthContainer from, ByteBuffer buffer) {
                return new FixedLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testFixedLengthContainer_Deserialize_SetBackingBufferManager_ClearBackingBuffer_Sync_Deserialize() {
        this.test_Deserialize_SetBackingBufferManager_ClearBackingBuffer_Sync_Deserialize(new FixedLengthContainer(), new Deserializer<FixedLengthContainer>(){

            @Override
            final FixedLengthContainer deserialize(FixedLengthContainer from, ByteBuffer buffer) {
                return new FixedLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testFixedLengthContainer_Deserialize_SetBackingBufferManager_AppendFixed_Sync_Deserialize() {
        this.test_Deserialize_SetBackingBufferManager_AppendFixed_Sync_Deserialize(new FixedLengthContainer(), new Deserializer<FixedLengthContainer>(){

            @Override
            final FixedLengthContainer deserialize(FixedLengthContainer from, ByteBuffer buffer) {
                return new FixedLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testFixedLengthContainer_Deserialize_SetBackingBufferManager_AppendVariable_Sync_Deserialize() {
        this.test_Deserialize_SetBackingBufferManager_AppendVariable_Sync_Deserialize(new FixedLengthContainer(), new Deserializer<FixedLengthContainer>(){

            @Override
            final FixedLengthContainer deserialize(FixedLengthContainer from, ByteBuffer buffer) {
                return new FixedLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testFixedLengthContainer_Deserialize_UpdateFirstField_Sync_Deserialize() {
        this.test_Deserialize_UpdateFirstField_Sync_Deserialize(new FixedLengthContainer(), new Deserializer<FixedLengthContainer>(){

            @Override
            final FixedLengthContainer deserialize(FixedLengthContainer from, ByteBuffer buffer) {
                return new FixedLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testFixedLengthContainer_Deserialize_UpdateMiddleField_Sync_Deserialize() {
        this.test_Deserialize_UpdateMiddleField_Sync_Deserialize(new FixedLengthContainer(), new Deserializer<FixedLengthContainer>(){

            @Override
            final FixedLengthContainer deserialize(FixedLengthContainer from, ByteBuffer buffer) {
                return new FixedLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testFixedLengthContainer_Deserialize_UpdateLastField_Sync_Deserialize() {
        this.test_Deserialize_UpdateLastField_Sync_Deserialize(new FixedLengthContainer(), new Deserializer<FixedLengthContainer>(){

            @Override
            final FixedLengthContainer deserialize(FixedLengthContainer from, ByteBuffer buffer) {
                return new FixedLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testFixedLengthContainer_Deserialize_Detached() {
        this.test_Deserialize_Detached(new FixedLengthContainer(), new Deserializer<FixedLengthContainer>(){

            @Override
            final FixedLengthContainer deserialize(FixedLengthContainer from, ByteBuffer buffer) {
                return new FixedLengthContainer(from, buffer, false);
            }
        });
    }

    @Test
    public void testFixedLengthContainer_Create_SetValues_Sync() {
        this.test_Create_SetValues_Sync(256, new FixedLengthContainer(), new Deserializer<FixedLengthContainer>(){

            @Override
            final FixedLengthContainer deserialize(FixedLengthContainer from, ByteBuffer buffer) {
                return new FixedLengthContainer(from, buffer);
            }
        });
    }

    @Test(expected=Exception.class)
    public void testFixedLengthContainer_Create_SetValues_Sync_InsufficientSpace() {
        this.test_Create_SetValues_Sync(10, new FixedLengthContainer(), new Deserializer<FixedLengthContainer>(){

            @Override
            final FixedLengthContainer deserialize(FixedLengthContainer from, ByteBuffer buffer) {
                return new FixedLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testFixedLengthContainer_Deserialize_SetBackingBuffer_NoClear() {
        this.test_SetBackingBuffer_NoClear(new FixedLengthContainer(), new FixedLengthContainer(), new Deserializer<FixedLengthContainer>(){

            @Override
            final FixedLengthContainer deserialize(FixedLengthContainer from, ByteBuffer buffer) {
                return new FixedLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testFixedLengthContainer_ChangeBackingBuffer() {
        this.test_ChangeBackingBuffer(new FixedLengthContainer(), new FixedLengthContainer(), new Deserializer<FixedLengthContainer>(){

            @Override
            final FixedLengthContainer deserialize(FixedLengthContainer from, ByteBuffer buffer) {
                return new FixedLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testVariableLengthContainer_Create_SetValues() {
        this.test_Create_SetValues(new VariableLengthContainer());
    }

    @Test
    public void testVariableLengthContainer_Create_SetValues_SetBackingBuffer() {
        this.test_Create_SetValues_SetBackingBuffer(new VariableLengthContainer());
    }

    @Test
    public void testVariableLengthContainer_Create_SetBackingBuffer_SetValues() {
        this.test_Create_SetBackingBuffer_SetValues(new VariableLengthContainer());
    }

    @Test
    public void testVariableLengthContainer_Create_SetValues_SetBackingBufferManager() {
        this.test_Create_SetValues_SetBackingBufferManager(new VariableLengthContainer());
    }

    @Test
    public void testVariableLengthContainer_Create_SetBackingBufferManager_SetValues() {
        this.test_Create_SetBackingBufferManager_SetValues(new VariableLengthContainer());
    }

    @Test
    public void testVariableLengthContainer_Create_SetValues_SetBackingBuffer_ClearBackingBuffer() {
        this.test_Create_SetValues_SetBackingBuffer_ClearBackingBuffer(new VariableLengthContainer());
    }

    @Test
    public void testVariableLengthContainer_Create_SetBackingBuffer_SetValues_ClearBackingBuffer() {
        this.test_Create_SetBackingBuffer_SetValues_ClearBackingBuffer(new VariableLengthContainer());
    }

    @Test
    public void testVariableLengthContainer_Create_SetValues_SetBackingBuffer_SetBackingBuffer() {
        this.test_Create_SetValues_SetBackingBuffer_SetBackingBuffer(new VariableLengthContainer());
    }

    @Test
    public void testVariableLengthContainer_Create_SetBackingBuffer_SetValues_SetBackingBuffer() {
        this.test_Create_SetBackingBuffer_SetValues_SetBackingBuffer(new VariableLengthContainer());
    }

    @Test
    public void testVariableLengthContainer_Create_SetBackingBuffer_ClearBackingBuffer_SetValues() {
        this.test_Create_SetBackingBuffer_ClearBackingBuffer_SetValues(new VariableLengthContainer());
    }

    @Test
    public void testVariableLengthContainer_Create_SetValues_SetBackingBufferManager_ClearBackingBufferManager() {
        this.test_Create_SetValues_SetBackingBufferManager_ClearBackingBufferManager(new VariableLengthContainer());
    }

    @Test
    public void testVariableLengthContainer_Create_SetBackingBufferManager_SetValues_ClearBackingBufferManager() {
        this.test_Create_SetBackingBufferManager_SetValues_ClearBackingBufferManager(new VariableLengthContainer());
    }

    @Test
    public void testVariableLengthContainer_Create_SetBackingBufferManager_ClearBackingBufferManager_SetValues() {
        this.test_Create_SetBackingBufferManager_ClearBackingBufferManager_SetValues(new VariableLengthContainer());
    }

    @Test
    public void testVariableLengthContainer_Create_SetValues_SetBackingBufferManager_SetBackingBufferManager() {
        this.test_Create_SetValues_SetBackingBufferManager_SetBackingBufferManager(new VariableLengthContainer());
    }

    @Test
    public void testVariableLengthContainer_Create_SetBackingBufferManager_SetValues_SetBackingBufferManager() {
        this.test_Create_SetBackingBufferManager_SetValues_SetBackingBufferManager(new VariableLengthContainer());
    }

    @Test
    public void testVariableLengthContainer_Create_SetBackingBufferManager_SetBackingBufferManager_SetValues() {
        this.test_Create_SetBackingBufferManager_SetBackingBufferManager_SetValues(new VariableLengthContainer());
    }

    @Test
    public void testVariableLengthContainer_Create_SetValues_SetBackingBufferManager_ClearBackingBuffer() {
        this.test_Create_SetValues_SetBackingBufferManager_ClearBackingBuffer(new VariableLengthContainer());
    }

    @Test
    public void testVariableLengthContainer_Create_SetBackingBufferManager_SetValues_ClearBackingBuffer() {
        this.test_Create_SetBackingBufferManager_SetValues_ClearBackingBuffer(new VariableLengthContainer());
    }

    @Test
    public void testVariableLengthContainer_Create_SetBackingBufferManager_ClearBackingBuffer_SetValues() {
        this.test_Create_SetBackingBufferManager_ClearBackingBuffer_SetValues(new VariableLengthContainer());
    }

    @Test
    public void testVariableLengthContainer_Create_SetValues_SetBackingBuffer_SetBackingBufferManager() {
        this.test_Create_SetValues_SetBackingBuffer_SetBackingBufferManager(new VariableLengthContainer());
    }

    @Test
    public void testVariableLengthContainer_Create_SetBackingBuffer_SetValues_SetBackingBufferManager() {
        this.test_Create_SetBackingBuffer_SetValues_SetBackingBufferManager(new VariableLengthContainer());
    }

    @Test
    public void testVariableLengthContainer_Create_SetBackingBuffer_SetBackingBufferManager_SetValues() {
        this.test_Create_SetBackingBuffer_SetBackingBufferManager_SetValues(new VariableLengthContainer());
    }

    @Test
    public void testVariableLengthContainer_Create_SetValues_SetBackingBufferManager_SetBackingBuffer() {
        this.test_Create_SetValues_SetBackingBufferManager_SetBackingBuffer(new VariableLengthContainer());
    }

    @Test
    public void testVariableLengthContainer_Create_SetBackingBufferManager_SetValues_SetBackingBuffer() {
        this.test_Create_SetBackingBufferManager_SetValues_SetBackingBuffer(new VariableLengthContainer());
    }

    @Test
    public void testVariableLengthContainer_Create_SetBackingBufferManager_SetBackingBuffer_SetValues() {
        this.test_Create_SetBackingBufferManager_SetBackingBuffer_SetValues(new VariableLengthContainer());
    }

    @Test
    public void testVariableLengthContainer_Create_SetValues_SetBackingBuffer_SetBackingBufferManager_ClearBackingBuffer() {
        this.test_Create_SetValues_SetBackingBuffer_SetBackingBufferManager_ClearBackingBuffer(new VariableLengthContainer());
    }

    @Test
    public void testVariableLengthContainer_Create_SetBackingBuffer_SetValues_SetBackingBufferManager_ClearBackingBuffer() {
        this.test_Create_SetBackingBuffer_SetValues_SetBackingBufferManager_ClearBackingBuffer(new VariableLengthContainer());
    }

    @Test
    public void testVariableLengthContainer_Create_SetBackingBuffer_SetBackingBufferManager_SetValues_ClearBackingBuffer() {
        this.test_Create_SetBackingBuffer_SetBackingBufferManager_SetValues_ClearBackingBuffer(new VariableLengthContainer());
    }

    @Test
    public void testVariableLengthContainer_Create_SetBackingBuffer_SetBackingBufferManager_ClearBackingBuffer_SetValues() {
        this.test_Create_SetBackingBuffer_SetBackingBufferManager_ClearBackingBuffer_SetValues(new VariableLengthContainer());
    }

    @Test
    public void testVariableLengthContainer_Deserialize() {
        this.test_Deserialize(new VariableLengthContainer(), new Deserializer<VariableLengthContainer>(){

            @Override
            final VariableLengthContainer deserialize(VariableLengthContainer from, ByteBuffer buffer) {
                return new VariableLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testVariableLengthContainer_Deserialize_UpdateFirstField() {
        this.test_Deserialize_UpdateFirstField(new VariableLengthContainer(), new Deserializer<VariableLengthContainer>(){

            @Override
            final VariableLengthContainer deserialize(VariableLengthContainer from, ByteBuffer buffer) {
                return new VariableLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testVariableLengthContainer_Deserialize_UpdateMiddleField() {
        this.test_Deserialize_UpdateMiddleField(new VariableLengthContainer(), new Deserializer<VariableLengthContainer>(){

            @Override
            final VariableLengthContainer deserialize(VariableLengthContainer from, ByteBuffer buffer) {
                return new VariableLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testVariableLengthContainer_Deserialize_UpdateLastField() {
        this.test_Deserialize_UpdateLastField(new VariableLengthContainer(), new Deserializer<VariableLengthContainer>(){

            @Override
            final VariableLengthContainer deserialize(VariableLengthContainer from, ByteBuffer buffer) {
                return new VariableLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testVariableLengthContainer_Deserialize_SetNullBackingBuffer() {
        this.test_Deserialize_SetNullBackingBuffer(new VariableLengthContainer(), new Deserializer<VariableLengthContainer>(){

            @Override
            final VariableLengthContainer deserialize(VariableLengthContainer from, ByteBuffer buffer) {
                return new VariableLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testVariableLengthContainer_Deserialize_SetBackingBuffer_InsufficientSpace() {
        this.test_Deserialize_SetBackingBuffer(32, new VariableLengthContainer(), new Deserializer<VariableLengthContainer>(){

            @Override
            final VariableLengthContainer deserialize(VariableLengthContainer from, ByteBuffer buffer) {
                return new VariableLengthContainer(from, buffer);
            }
        });
    }

    @Test(expected=EStoInsufficientSpaceException.class)
    public void testVariableLengthContainer_Deserialize_SetBackingBuffer_InsufficientSpace_Sync() {
        this.test_Deserialize_SetBackingBuffer_Sync(32, new VariableLengthContainer(), new Deserializer<VariableLengthContainer>(){

            @Override
            final VariableLengthContainer deserialize(VariableLengthContainer from, ByteBuffer buffer) {
                return new VariableLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testVariableLengthContainer_Deserialize_SetBackingBuffer_SufficientSpace() {
        this.test_Deserialize_SetBackingBuffer(10240, new VariableLengthContainer(), new Deserializer<VariableLengthContainer>(){

            @Override
            final VariableLengthContainer deserialize(VariableLengthContainer from, ByteBuffer buffer) {
                return new VariableLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testVariableLengthContainer_Deserialize_SetBackingBuffer_SufficientSpace_Sync() {
        this.test_Deserialize_SetBackingBuffer_Sync(10240, new VariableLengthContainer(), new Deserializer<VariableLengthContainer>(){

            @Override
            final VariableLengthContainer deserialize(VariableLengthContainer from, ByteBuffer buffer) {
                return new VariableLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testVariableLengthContainer_Deserialize_SetBackingBufferManager_SetBackingBuffer() {
        this.test_Deserialize_SetBackingBufferManager_SetBackingBuffer(32, new VariableLengthContainer(), new Deserializer<VariableLengthContainer>(){

            @Override
            final VariableLengthContainer deserialize(VariableLengthContainer from, ByteBuffer buffer) {
                return new VariableLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testVariableLengthContainer_Deserialize_SetBackingBufferManager_SetBackingBuffer_Sync() {
        this.test_Deserialize_SetBackingBufferManager_SetBackingBuffer_Sync(32, new VariableLengthContainer(), new Deserializer<VariableLengthContainer>(){

            @Override
            final VariableLengthContainer deserialize(VariableLengthContainer from, ByteBuffer buffer) {
                return new VariableLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testVariableLengthContainer_Deserialize_ClearBackingBuffer() {
        this.test_Deserialize_ClearBackingBuffer(new VariableLengthContainer(), new Deserializer<VariableLengthContainer>(){

            @Override
            final VariableLengthContainer deserialize(VariableLengthContainer from, ByteBuffer buffer) {
                return new VariableLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testVariableLengthContainer_Deserialize_AppendFixed() {
        this.test_Deserialize_AppendFixed(new VariableLengthContainer(), new Deserializer<VariableLengthContainer>(){

            @Override
            final VariableLengthContainer deserialize(VariableLengthContainer from, ByteBuffer buffer) {
                return new VariableLengthContainer(from, buffer);
            }
        });
    }

    @Test(expected=EStoInsufficientSpaceException.class)
    public void testVariableLengthContainer_Deserialize_AppendFixed_Sync() {
        this.test_Deserialize_AppendFixed_Sync(new VariableLengthContainer(), new Deserializer<VariableLengthContainer>(){

            @Override
            final VariableLengthContainer deserialize(VariableLengthContainer from, ByteBuffer buffer) {
                return new VariableLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testVariableLengthContainer_Deserialize_AppendVariable() {
        this.test_Deserialize_AppendVariable(new VariableLengthContainer(), new Deserializer<VariableLengthContainer>(){

            @Override
            final VariableLengthContainer deserialize(VariableLengthContainer from, ByteBuffer buffer) {
                return new VariableLengthContainer(from, buffer);
            }
        });
    }

    @Test(expected=EStoInsufficientSpaceException.class)
    public void testVariableLengthContainer_Deserialize_AppendVariable_Sync() {
        this.test_Deserialize_AppendVariable_Sync(new VariableLengthContainer(), new Deserializer<VariableLengthContainer>(){

            @Override
            final VariableLengthContainer deserialize(VariableLengthContainer from, ByteBuffer buffer) {
                return new VariableLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testVariableLengthContainer_Deserialize_SetBackingBufferManager_AppendFixed_Sync() {
        this.test_Deserialize_SetBackingBufferManager_AppendFixed_Sync(new VariableLengthContainer(), new Deserializer<VariableLengthContainer>(){

            @Override
            final VariableLengthContainer deserialize(VariableLengthContainer from, ByteBuffer buffer) {
                return new VariableLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testVariableLengthContainer_Deserialize_SetBackingBufferManager_AppendVariable_Sync() {
        this.test_Deserialize_SetBackingBufferManager_AppendVariable_Sync(new VariableLengthContainer(), new Deserializer<VariableLengthContainer>(){

            @Override
            final VariableLengthContainer deserialize(VariableLengthContainer from, ByteBuffer buffer) {
                return new VariableLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testVariableLengthContainer_Deserialize_Sync_Deserialize() {
        this.test_Deserialize_Sync_Deserialize(new VariableLengthContainer(), new Deserializer<VariableLengthContainer>(){

            @Override
            final VariableLengthContainer deserialize(VariableLengthContainer from, ByteBuffer buffer) {
                return new VariableLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testVariableLengthContainer_Deserialize_SetBackingBufferManager_ClearBackingBuffer_Sync_Deserialize() {
        this.test_Deserialize_SetBackingBufferManager_ClearBackingBuffer_Sync_Deserialize(new VariableLengthContainer(), new Deserializer<VariableLengthContainer>(){

            @Override
            final VariableLengthContainer deserialize(VariableLengthContainer from, ByteBuffer buffer) {
                return new VariableLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testVariableLengthContainer_Deserialize_SetBackingBufferManager_AppendFixed_Sync_Deserialize() {
        this.test_Deserialize_SetBackingBufferManager_AppendFixed_Sync_Deserialize(new VariableLengthContainer(), new Deserializer<VariableLengthContainer>(){

            @Override
            final VariableLengthContainer deserialize(VariableLengthContainer from, ByteBuffer buffer) {
                return new VariableLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testVariableLengthContainer_Deserialize_SetBackingBufferManager_AppendVariable_Sync_Deserialize() {
        this.test_Deserialize_SetBackingBufferManager_AppendVariable_Sync_Deserialize(new VariableLengthContainer(), new Deserializer<VariableLengthContainer>(){

            @Override
            final VariableLengthContainer deserialize(VariableLengthContainer from, ByteBuffer buffer) {
                return new VariableLengthContainer(from, buffer);
            }
        });
    }

    @Test(expected=EStoInsufficientSpaceException.class)
    public void testVariableLengthContainer_Deserialize_UpdateFirstField_Sync_Deserialize() {
        this.test_Deserialize_UpdateFirstField_Sync_Deserialize(new VariableLengthContainer(), new Deserializer<VariableLengthContainer>(){

            @Override
            final VariableLengthContainer deserialize(VariableLengthContainer from, ByteBuffer buffer) {
                return new VariableLengthContainer(from, buffer);
            }
        });
    }

    @Test(expected=EStoInsufficientSpaceException.class)
    public void testVariableLengthContainer_Deserialize_UpdateMiddleField_Sync_Deserialize() {
        this.test_Deserialize_UpdateMiddleField_Sync_Deserialize(new VariableLengthContainer(), new Deserializer<VariableLengthContainer>(){

            @Override
            final VariableLengthContainer deserialize(VariableLengthContainer from, ByteBuffer buffer) {
                return new VariableLengthContainer(from, buffer);
            }
        });
    }

    @Test(expected=EStoInsufficientSpaceException.class)
    public void testVariableLengthContainer_Deserialize_UpdateLastField_Sync_Deserialize() {
        this.test_Deserialize_UpdateLastField_Sync_Deserialize(new VariableLengthContainer(), new Deserializer<VariableLengthContainer>(){

            @Override
            final VariableLengthContainer deserialize(VariableLengthContainer from, ByteBuffer buffer) {
                return new VariableLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testVariableLengthContainer_Deserialize_UpdateFirstField_SetBackingBufferManager_Sync_Deserialize() {
        this.test_Deserialize_UpdateFirstField_SetBackingBufferManager_Sync_Deserialize(new VariableLengthContainer(), new Deserializer<VariableLengthContainer>(){

            @Override
            final VariableLengthContainer deserialize(VariableLengthContainer from, ByteBuffer buffer) {
                return new VariableLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testVariableLengthContainer_Deserialize_UpdateMiddleField_SetBackingBufferManager_Sync_Deserialize() {
        this.test_Deserialize_UpdateMiddleField_SetBackingBufferManager_Sync_Deserialize(new VariableLengthContainer(), new Deserializer<VariableLengthContainer>(){

            @Override
            final VariableLengthContainer deserialize(VariableLengthContainer from, ByteBuffer buffer) {
                return new VariableLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testVariableLengthContainer_Deserialize_UpdateLastField_SetBackingBufferManager_Sync_Deserialize() {
        this.test_Deserialize_UpdateLastField_SetBackingBufferManager_Sync_Deserialize(new VariableLengthContainer(), new Deserializer<VariableLengthContainer>(){

            @Override
            final VariableLengthContainer deserialize(VariableLengthContainer from, ByteBuffer buffer) {
                return new VariableLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testVariableLengthContainer_Deserialize_Detached() {
        this.test_Deserialize_Detached(new VariableLengthContainer(), new Deserializer<VariableLengthContainer>(){

            @Override
            final VariableLengthContainer deserialize(VariableLengthContainer from, ByteBuffer buffer) {
                return new VariableLengthContainer(from, buffer, false);
            }
        });
    }

    @Test
    public void testVariableLengthContainer_Create_SetValues_Sync() {
        this.test_Create_SetValues_Sync(10240, new VariableLengthContainer(), new Deserializer<VariableLengthContainer>(){

            @Override
            final VariableLengthContainer deserialize(VariableLengthContainer from, ByteBuffer buffer) {
                return new VariableLengthContainer(from, buffer);
            }
        });
    }

    @Test(expected=Exception.class)
    public void testVariableLengthContainer_Create_SetValues_Sync_InsufficientSpace() {
        this.test_Create_SetValues_Sync(256, new VariableLengthContainer(), new Deserializer<VariableLengthContainer>(){

            @Override
            final VariableLengthContainer deserialize(VariableLengthContainer from, ByteBuffer buffer) {
                return new VariableLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testVariableLengthContainer_SetBackingBuffer_NoClear() {
        this.test_SetBackingBuffer_NoClear(new VariableLengthContainer(), new VariableLengthContainer(), new Deserializer<VariableLengthContainer>(){

            @Override
            final VariableLengthContainer deserialize(VariableLengthContainer from, ByteBuffer buffer) {
                return new VariableLengthContainer(from, buffer);
            }
        });
    }

    @Test
    public void testVariableLengthContainer_ChangeBackingBuffer() {
        this.test_ChangeBackingBuffer(new VariableLengthContainer(), new VariableLengthContainer(), new Deserializer<VariableLengthContainer>(){

            @Override
            final VariableLengthContainer deserialize(VariableLengthContainer from, ByteBuffer buffer) {
                return new VariableLengthContainer(from, buffer);
            }
        });
    }

    private abstract class Deserializer<T> {
        private Deserializer() {
        }

        abstract T deserialize(T var1, ByteBuffer var2);
    }

    private final class VariableLengthContainer
    extends TestContainer<VariableLengthContainer> {
        private int expectedSerializedLength;
        private int expectedLateSyncBoundaryMark;
        private StoField expectedLateSyncBoundary;
        private int additionalFields;
        private boolean[] boolarrval;
        private byte[] bytearrval;
        private short[] shortarrval;
        private int[] intarrval;
        private long[] longarrval;
        private float[] fltarrval;
        private double[] dblarrval;
        private String strval;
        private String[] strarrval;
        private StoFieldContainer compval;
        private StoFieldContainer[] comparrval;
        StoBooleanArrayField fld_boolarrval;
        StoByteArrayField fld_bytearrval;
        StoShortArrayField fld_shortarrval;
        StoIntArrayField fld_intarrval;
        StoLongArrayField fld_longarrval;
        StoFloatArrayField fld_fltarrval;
        StoDoubleArrayField fld_dblarrval;
        StoStringField fld_strval;
        StoStringArrayField fld_strarrval;
        StoCompoundField fld_compval;
        StoCompoundArrayField fld_comparrval;

        VariableLengthContainer() {
            this.expectedSerializedLength = 0;
            this.expectedLateSyncBoundaryMark = 0;
            this.expectedLateSyncBoundary = null;
            this.additionalFields = 0;
            this.init(StoBooleanArrayFieldTest.createArray(StoFieldContainerTest.this.random.nextInt(5) + 1), StoByteArrayFieldTest.createArray(StoFieldContainerTest.this.random.nextInt(5) + 1), StoShortArrayFieldTest.createArray(StoFieldContainerTest.this.random.nextInt(5) + 1), StoIntArrayFieldTest.createArray(StoFieldContainerTest.this.random.nextInt(5) + 1), StoLongArrayFieldTest.createArray(StoFieldContainerTest.this.random.nextInt(5) + 1), StoFloatArrayFieldTest.createArray(StoFieldContainerTest.this.random.nextInt(5) + 1), StoDoubleArrayFieldTest.createArray(StoFieldContainerTest.this.random.nextInt(5) + 1), StoStringFieldTest.createString(), StoStringArrayFieldTest.createArray(StoFieldContainerTest.this.random.nextInt(5) + 1), StoCompoundFieldTest.createContainer(true), StoCompoundArrayFieldTest.createArray(StoFieldContainerTest.this.random.nextInt(5) + 1));
        }

        VariableLengthContainer(VariableLengthContainer from, ByteBuffer buffer, boolean attach) {
            super(buffer, attach);
            this.expectedSerializedLength = 0;
            this.expectedLateSyncBoundaryMark = 0;
            this.expectedLateSyncBoundary = null;
            this.additionalFields = 0;
            this.init(from);
        }

        VariableLengthContainer(VariableLengthContainer from, ByteBuffer buffer) {
            this(from, buffer, true);
        }

        private final void init(boolean[] boolarrval, byte[] bytearrval, short[] shortarrval, int[] intarrval, long[] longarrval, float[] fltarrval, double[] dblarrval, String strval, String[] strarrval, StoFieldContainer compval, StoFieldContainer[] comparrval) {
            this.boolarrval = boolarrval;
            this.bytearrval = bytearrval;
            this.shortarrval = shortarrval;
            this.intarrval = intarrval;
            this.longarrval = longarrval;
            this.dblarrval = dblarrval;
            this.fltarrval = fltarrval;
            this.strval = strval;
            this.strarrval = strarrval;
            this.compval = compval;
            this.comparrval = comparrval;
        }

        private final void initExpected() {
            this.expectedSerializedLength = 0;
            this.expectedSerializedLength += this.fld_boolarrval.getLength();
            this.expectedSerializedLength += this.fld_bytearrval.getLength();
            this.expectedSerializedLength += this.fld_shortarrval.getLength();
            this.expectedSerializedLength += this.fld_intarrval.getLength();
            this.expectedSerializedLength += this.fld_longarrval.getLength();
            this.expectedSerializedLength += this.fld_fltarrval.getLength();
            this.expectedSerializedLength += this.fld_dblarrval.getLength();
            this.expectedSerializedLength += this.fld_strval.getLength();
            this.expectedSerializedLength += this.fld_strarrval.getLength();
            this.expectedSerializedLength += this.fld_compval.getLength();
            this.expectedSerializedLength += this.fld_comparrval.getLength();
            this.expectedLateSyncBoundary = this.fld_boolarrval;
            this.expectedLateSyncBoundaryMark = 0;
        }

        @Override
        final VariableLengthContainer init(VariableLengthContainer from) {
            this.init(from.boolarrval, from.bytearrval, from.shortarrval, from.intarrval, from.longarrval, from.fltarrval, from.dblarrval, from.strval, from.strarrval, from.compval, from.comparrval);
            this.expectedSerializedLength = from.expectedSerializedLength;
            this.expectedLateSyncBoundaryMark = from.expectedLateSyncBoundaryMark;
            this.expectedLateSyncBoundary = StoFieldContainerTest.getFieldAtSamePos(this, from, from.expectedLateSyncBoundary);
            this.additionalFields = from.additionalFields;
            return this;
        }

        @Override
        final VariableLengthContainer createFields() {
            this.fld_boolarrval = StoBooleanArrayField.create(null);
            this.fld_bytearrval = StoByteArrayField.create("bytearr");
            this.fld_shortarrval = StoShortArrayField.create(null);
            this.fld_intarrval = StoIntArrayField.create(null);
            this.fld_longarrval = StoLongArrayField.create(null);
            this.fld_fltarrval = StoFloatArrayField.create("fltarr");
            this.fld_dblarrval = StoDoubleArrayField.create(null);
            this.fld_strval = StoStringField.create(null);
            this.fld_strarrval = StoStringArrayField.create(null);
            this.fld_compval = StoCompoundField.create("comp");
            this.fld_comparrval = StoCompoundArrayField.create(null);
            return this;
        }

        @Override
        final VariableLengthContainer writeFields() {
            this.append(this.fld_boolarrval);
            this.append(this.fld_bytearrval);
            this.append(this.fld_shortarrval);
            this.append(this.fld_intarrval);
            this.append(this.fld_longarrval);
            this.append(this.fld_fltarrval);
            this.append(this.fld_dblarrval);
            this.append(this.fld_strval);
            this.append(this.fld_strarrval);
            this.append(this.fld_compval);
            this.append(this.fld_comparrval);
            this.initExpected();
            return this;
        }

        @Override
        final VariableLengthContainer readFields() {
            this.fld_boolarrval = (StoBooleanArrayField)this.next();
            this.fld_bytearrval = (StoByteArrayField)this.next();
            this.fld_shortarrval = (StoShortArrayField)this.next();
            this.fld_intarrval = (StoIntArrayField)this.next();
            this.fld_longarrval = (StoLongArrayField)this.next();
            this.fld_fltarrval = (StoFloatArrayField)this.next();
            this.fld_dblarrval = (StoDoubleArrayField)this.next();
            this.fld_strval = (StoStringField)this.next();
            this.fld_strarrval = (StoStringArrayField)this.next();
            this.fld_compval = (StoCompoundField)this.next();
            this.fld_comparrval = (StoCompoundArrayField)this.next();
            return this;
        }

        @Override
        final VariableLengthContainer setFieldValues() {
            this.fld_boolarrval.setValue(this.boolarrval);
            this.fld_bytearrval.setValue(this.bytearrval);
            this.fld_shortarrval.setValue(this.shortarrval);
            this.fld_intarrval.setValue(this.intarrval);
            this.fld_longarrval.setValue(this.longarrval);
            this.fld_fltarrval.setValue(this.fltarrval);
            this.fld_dblarrval.setValue(this.dblarrval);
            this.fld_strval.setValue(this.strval);
            this.fld_strarrval.setValue(this.strarrval);
            this.fld_compval.setValue(this.compval);
            this.fld_comparrval.setValue(this.comparrval);
            this.initExpected();
            return this;
        }

        @Override
        final VariableLengthContainer updateFirstField() {
            this.boolarrval = StoBooleanArrayFieldTest.createArray(this.boolarrval.length + 1);
            this.fld_boolarrval.setValue(this.boolarrval);
            this.initExpected();
            return this;
        }

        @Override
        final VariableLengthContainer updateMiddleField() {
            this.longarrval = StoLongArrayFieldTest.createArray(this.longarrval.length + 1);
            this.fld_longarrval.setValue(this.longarrval);
            this.initExpected();
            return this;
        }

        @Override
        final VariableLengthContainer updateLastField() {
            this.comparrval = StoCompoundArrayFieldTest.createArray(this.comparrval.length + 1);
            this.fld_comparrval.setValue(this.comparrval);
            this.initExpected();
            return this;
        }

        @Override
        final VariableLengthContainer validateFields(ByteBuffer buffer) {
            Assert.assertNull((Object)this.fld_boolarrval.getBackingBuffer());
            Assert.assertNull((Object)this.fld_bytearrval.getBackingBuffer());
            Assert.assertNull((Object)this.fld_shortarrval.getBackingBuffer());
            Assert.assertNull((Object)this.fld_intarrval.getBackingBuffer());
            Assert.assertNull((Object)this.fld_longarrval.getBackingBuffer());
            Assert.assertNull((Object)this.fld_fltarrval.getBackingBuffer());
            Assert.assertNull((Object)this.fld_dblarrval.getBackingBuffer());
            Assert.assertNull((Object)this.fld_strval.getBackingBuffer());
            Assert.assertNull((Object)this.fld_strarrval.getBackingBuffer());
            Assert.assertNull((Object)this.fld_compval.getBackingBuffer());
            Assert.assertNull((Object)this.fld_comparrval.getBackingBuffer());
            Assert.assertEquals((long)super.count(), (long)(11 + this.additionalFields));
            Assert.assertSame((Object)this.fld_boolarrval, (Object)this.first());
            Assert.assertSame((Object)this.fld_bytearrval, (Object)this.next());
            Assert.assertSame((Object)this.fld_shortarrval, (Object)this.next());
            Assert.assertSame((Object)this.fld_intarrval, (Object)this.next());
            Assert.assertSame((Object)this.fld_longarrval, (Object)this.next());
            Assert.assertSame((Object)this.fld_fltarrval, (Object)this.next());
            Assert.assertSame((Object)this.fld_dblarrval, (Object)this.next());
            Assert.assertSame((Object)this.fld_strval, (Object)this.next());
            Assert.assertSame((Object)this.fld_strarrval, (Object)this.next());
            Assert.assertSame((Object)this.fld_compval, (Object)this.next());
            Assert.assertSame((Object)this.fld_comparrval, (Object)this.next());
            int count = this.additionalFields;
            while (count-- > 0) {
                this.next();
            }
            Assert.assertNull((Object)this.next());
            Assert.assertSame((Object)this.fld_boolarrval, (Object)this.next());
            Assert.assertSame((Object)this.fld_boolarrval, (Object)this.get(1));
            Assert.assertSame((Object)this.fld_bytearrval, (Object)this.get(2));
            Assert.assertSame((Object)this.fld_shortarrval, (Object)this.get(3));
            Assert.assertSame((Object)this.fld_intarrval, (Object)this.get(4));
            Assert.assertSame((Object)this.fld_longarrval, (Object)this.get(5));
            Assert.assertSame((Object)this.fld_fltarrval, (Object)this.get(6));
            Assert.assertSame((Object)this.fld_dblarrval, (Object)this.get(7));
            Assert.assertSame((Object)this.fld_strval, (Object)this.get(8));
            Assert.assertSame((Object)this.fld_strarrval, (Object)this.get(9));
            Assert.assertSame((Object)this.fld_compval, (Object)this.get(10));
            Assert.assertSame((Object)this.fld_comparrval, (Object)this.get(11));
            Assert.assertNull((Object)this.get(11 + this.additionalFields + 1));
            Assert.assertSame((Object)this.fld_bytearrval, (Object)this.get("bytearr"));
            Assert.assertSame((Object)this.fld_fltarrval, (Object)this.get("fltarr"));
            Assert.assertSame((Object)this.fld_compval, (Object)this.get("comp"));
            Assert.assertNull((Object)this.get("str"));
            Assert.assertTrue((boolean)super.isVariableLength());
            Assert.assertEquals((long)super.getSerializedLength(), (long)this.expectedSerializedLength());
            StoBooleanArrayFieldTest.compare((boolean[])this.fld_boolarrval.getValue(), this.boolarrval, false);
            StoByteArrayFieldTest.compare((byte[])this.fld_bytearrval.getValue(), this.bytearrval, false);
            StoShortArrayFieldTest.compare((short[])this.fld_shortarrval.getValue(), this.shortarrval, false);
            StoIntArrayFieldTest.compare((int[])this.fld_intarrval.getValue(), this.intarrval, false);
            StoLongArrayFieldTest.compare((long[])this.fld_longarrval.getValue(), this.longarrval, false);
            StoFloatArrayFieldTest.compare((float[])this.fld_fltarrval.getValue(), this.fltarrval, false);
            StoDoubleArrayFieldTest.compare((double[])this.fld_dblarrval.getValue(), this.dblarrval, false);
            Assert.assertEquals(this.fld_strval.getValue(), (Object)this.strval);
            StoStringArrayFieldTest.compare((String[])this.fld_strarrval.getValue(), this.strarrval, false);
            Assert.assertTrue((boolean)this.compval.contentsEquals((StoFieldContainer)this.fld_compval.getValue()));
            StoCompoundArrayFieldTest.compare((StoFieldContainer[])this.fld_comparrval.getValue(), this.comparrval, false);
            return this;
        }

        @Override
        final StoField expectedLateSyncBoundary() {
            return this.expectedLateSyncBoundary;
        }

        @Override
        final int expectedLateSyncBoundaryMark() {
            return this.expectedLateSyncBoundaryMark;
        }

        @Override
        final int expectedSerializedLength() {
            return this.expectedSerializedLength;
        }

        @Override
        final VariableLengthContainer appendAdditionalFixed() {
            StoIntField field = StoIntField.create(null);
            this.append(field);
            this.expectedSerializedLength += field.getLength();
            ++this.additionalFields;
            return this;
        }

        @Override
        final VariableLengthContainer appendAdditionalVariable() {
            StoStringField field = StoStringField.create(null);
            this.append(field);
            this.expectedSerializedLength += field.getLength();
            ++this.additionalFields;
            return this;
        }
    }

    private final class FixedLengthContainer
    extends TestContainer<FixedLengthContainer> {
        private int expectedSerializedLength;
        private int expectedLateSyncBoundaryMark;
        private StoField expectedLateSyncBoundary;
        private int additionalFields;
        private int intval;
        private double dblval;
        private float fltval;
        private short shortval;
        private byte byteval;
        private boolean boolval;
        private String strval;
        StoIntField fld_intval;
        StoDoubleField fld_dblval;
        StoFloatField fld_fltval;
        StoFixedLengthStringField fld_strval;
        StoByteField fld_byteval;
        StoBooleanField fld_boolval;
        StoShortField fld_shortval;

        FixedLengthContainer() {
            this.expectedSerializedLength = 0;
            this.expectedLateSyncBoundaryMark = 0;
            this.expectedLateSyncBoundary = null;
            this.additionalFields = 0;
            this.init(StoFieldContainerTest.this.random.nextInt(), StoFieldContainerTest.this.random.nextDouble(), StoFieldContainerTest.this.random.nextFloat(), (short)StoFieldContainerTest.this.random.nextInt(Short.MAX_VALUE), (byte)StoFieldContainerTest.this.random.nextInt(127), StoFieldContainerTest.this.random.nextInt(2) == 0, "hello");
        }

        FixedLengthContainer(FixedLengthContainer from, ByteBuffer buffer, boolean attach) {
            super(buffer, attach);
            this.expectedSerializedLength = 0;
            this.expectedLateSyncBoundaryMark = 0;
            this.expectedLateSyncBoundary = null;
            this.additionalFields = 0;
            this.init(from);
        }

        FixedLengthContainer(FixedLengthContainer from, ByteBuffer buffer) {
            this(from, buffer, true);
        }

        private final void init(int intval, double dblval, float fltval, short shortval, byte byteval, boolean boolval, String strval) {
            this.intval = intval;
            this.dblval = dblval;
            this.fltval = fltval;
            this.shortval = shortval;
            this.byteval = byteval;
            this.boolval = boolval;
            this.strval = strval;
        }

        private final void initExpected() {
            this.expectedLateSyncBoundary = null;
            this.expectedSerializedLength = 0;
            this.expectedSerializedLength += this.fld_intval.getLength();
            this.expectedSerializedLength += this.fld_dblval.getLength();
            this.expectedSerializedLength += this.fld_fltval.getLength();
            this.expectedSerializedLength += this.fld_shortval.getLength();
            this.expectedSerializedLength += this.fld_byteval.getLength();
            this.expectedSerializedLength += this.fld_boolval.getLength();
            this.expectedSerializedLength += this.fld_strval.getLength();
            this.expectedLateSyncBoundaryMark = this.expectedSerializedLength;
        }

        @Override
        final FixedLengthContainer init(FixedLengthContainer from) {
            this.init(from.intval, from.dblval, from.fltval, from.shortval, from.byteval, from.boolval, from.strval);
            this.expectedSerializedLength = from.expectedSerializedLength;
            this.expectedLateSyncBoundaryMark = from.expectedLateSyncBoundaryMark;
            this.expectedLateSyncBoundary = StoFieldContainerTest.getFieldAtSamePos(this, from, from.expectedLateSyncBoundary);
            this.additionalFields = from.additionalFields;
            return this;
        }

        @Override
        final FixedLengthContainer createFields() {
            this.fld_intval = StoIntField.create("int");
            this.fld_dblval = StoDoubleField.create(null);
            this.fld_fltval = StoFloatField.create(null);
            this.fld_shortval = StoShortField.create("short");
            this.fld_byteval = StoByteField.create("byte");
            this.fld_boolval = StoBooleanField.create(null);
            this.fld_strval = StoFixedLengthStringField.create((String)null, 5);
            return this;
        }

        @Override
        final FixedLengthContainer writeFields() {
            this.append(this.fld_intval);
            this.append(this.fld_dblval);
            this.append(this.fld_fltval);
            this.append(this.fld_shortval);
            this.append(this.fld_byteval);
            this.append(this.fld_boolval);
            this.append(this.fld_strval);
            this.initExpected();
            return this;
        }

        @Override
        final FixedLengthContainer readFields() {
            this.fld_intval = (StoIntField)this.next();
            this.fld_dblval = (StoDoubleField)this.next();
            this.fld_fltval = (StoFloatField)this.next();
            this.fld_shortval = (StoShortField)this.next();
            this.fld_byteval = (StoByteField)this.next();
            this.fld_boolval = (StoBooleanField)this.next();
            this.fld_strval = (StoFixedLengthStringField)this.next();
            return this;
        }

        @Override
        final FixedLengthContainer setFieldValues() {
            this.fld_intval.setValue(this.intval);
            this.fld_dblval.setValue(this.dblval);
            this.fld_fltval.setValue(this.fltval);
            this.fld_shortval.setValue(this.shortval);
            this.fld_byteval.setValue(this.byteval);
            this.fld_boolval.setValue(this.boolval);
            this.fld_strval.setValue(this.strval);
            this.initExpected();
            return this;
        }

        @Override
        final FixedLengthContainer updateFirstField() {
            int oldval = this.intval;
            do {
                this.intval = StoFieldContainerTest.this.random.nextInt();
            } while (oldval == this.intval);
            this.fld_intval.setValue(this.intval);
            this.initExpected();
            return this;
        }

        @Override
        final FixedLengthContainer updateMiddleField() {
            this.strval = "hell3";
            this.fld_strval.setValue(this.strval);
            this.initExpected();
            return this;
        }

        @Override
        final FixedLengthContainer updateLastField() {
            short oldval = this.shortval;
            do {
                this.shortval = (short)StoFieldContainerTest.this.random.nextInt(Short.MAX_VALUE);
            } while (oldval == this.shortval);
            this.fld_shortval.setValue(this.shortval);
            this.initExpected();
            return this;
        }

        @Override
        final FixedLengthContainer validateFields(ByteBuffer buffer) {
            Assert.assertSame((Object)this.fld_intval.getBackingBuffer(), (Object)buffer);
            Assert.assertSame((Object)this.fld_dblval.getBackingBuffer(), (Object)buffer);
            Assert.assertSame((Object)this.fld_fltval.getBackingBuffer(), (Object)buffer);
            Assert.assertSame((Object)this.fld_shortval.getBackingBuffer(), (Object)buffer);
            Assert.assertSame((Object)this.fld_byteval.getBackingBuffer(), (Object)buffer);
            Assert.assertSame((Object)this.fld_boolval.getBackingBuffer(), (Object)buffer);
            Assert.assertSame((Object)this.fld_strval.getBackingBuffer(), (Object)buffer);
            Assert.assertEquals((long)super.count(), (long)(7 + this.additionalFields));
            Assert.assertSame((Object)this.fld_intval, (Object)this.first());
            Assert.assertSame((Object)this.fld_dblval, (Object)this.next());
            Assert.assertSame((Object)this.fld_fltval, (Object)this.next());
            Assert.assertSame((Object)this.fld_shortval, (Object)this.next());
            Assert.assertSame((Object)this.fld_byteval, (Object)this.next());
            Assert.assertSame((Object)this.fld_boolval, (Object)this.next());
            Assert.assertSame((Object)this.fld_strval, (Object)this.next());
            int count = this.additionalFields;
            while (count-- > 0) {
                this.next();
            }
            Assert.assertNull((Object)this.next());
            Assert.assertSame((Object)this.fld_intval, (Object)this.next());
            Assert.assertSame((Object)this.fld_intval, (Object)this.get(1));
            Assert.assertSame((Object)this.fld_dblval, (Object)this.get(2));
            Assert.assertSame((Object)this.fld_fltval, (Object)this.get(3));
            Assert.assertSame((Object)this.fld_shortval, (Object)this.get(4));
            Assert.assertSame((Object)this.fld_byteval, (Object)this.get(5));
            Assert.assertSame((Object)this.fld_boolval, (Object)this.get(6));
            Assert.assertSame((Object)this.fld_strval, (Object)this.get(7));
            Assert.assertNull((Object)super.get(7 + this.additionalFields + 1));
            Assert.assertSame((Object)this.fld_intval, (Object)this.get("int"));
            Assert.assertSame((Object)this.fld_shortval, (Object)this.get("short"));
            Assert.assertSame((Object)this.fld_byteval, (Object)this.get("byte"));
            Assert.assertNull((Object)this.get("double"));
            if (this.additionalFields == 0) {
                Assert.assertFalse((boolean)super.isVariableLength());
            }
            Assert.assertEquals((long)super.getSerializedLength(), (long)this.expectedSerializedLength());
            Assert.assertEquals((long)this.fld_intval.getValue(), (long)this.intval);
            Assert.assertEquals((double)this.fld_dblval.getValue(), (double)this.dblval, (double)0.0);
            Assert.assertEquals((float)this.fld_fltval.getValue(), (float)this.fltval, (float)0.0f);
            Assert.assertEquals((long)this.fld_shortval.getValue(), (long)this.shortval);
            Assert.assertEquals((long)this.fld_byteval.getValue(), (long)this.byteval);
            Assert.assertEquals((Object)this.fld_boolval.getValue(), (Object)this.boolval);
            Assert.assertEquals((Object)this.fld_strval.getValue(), (Object)this.strval);
            return this;
        }

        @Override
        final StoField expectedLateSyncBoundary() {
            return this.expectedLateSyncBoundary;
        }

        @Override
        final int expectedLateSyncBoundaryMark() {
            return this.expectedLateSyncBoundaryMark;
        }

        @Override
        final int expectedSerializedLength() {
            return this.expectedSerializedLength;
        }

        @Override
        final FixedLengthContainer appendAdditionalFixed() {
            StoIntField field = StoIntField.create(null);
            this.append(field);
            this.expectedSerializedLength += field.getLength();
            if (this.expectedLateSyncBoundary == null) {
                this.expectedLateSyncBoundaryMark = this.expectedSerializedLength;
            }
            ++this.additionalFields;
            return this;
        }

        @Override
        final FixedLengthContainer appendAdditionalVariable() {
            StoStringField field = StoStringField.create(null);
            this.append(field);
            this.expectedSerializedLength += field.getLength();
            if (this.expectedLateSyncBoundary == null) {
                this.expectedLateSyncBoundary = field;
            }
            ++this.additionalFields;
            return this;
        }
    }

    private final class EmptyContainer
    extends TestContainer<EmptyContainer> {
        private int expectedSerializedLength;
        private int expectedLateSyncBoundaryMark;
        private StoField expectedLateSyncBoundary;
        private int additionalFields;
        private boolean additionalVariable;

        EmptyContainer() {
            this.expectedSerializedLength = 0;
            this.expectedLateSyncBoundaryMark = 0;
            this.expectedLateSyncBoundary = null;
            this.additionalFields = 0;
            this.additionalVariable = false;
        }

        EmptyContainer(EmptyContainer from, ByteBuffer buffer, boolean attached) {
            super(buffer, attached);
            this.expectedSerializedLength = 0;
            this.expectedLateSyncBoundaryMark = 0;
            this.expectedLateSyncBoundary = null;
            this.additionalFields = 0;
            this.additionalVariable = false;
            this.expectedSerializedLength = from.expectedSerializedLength;
            this.expectedLateSyncBoundaryMark = from.expectedLateSyncBoundaryMark;
            this.expectedLateSyncBoundary = StoFieldContainerTest.getFieldAtSamePos(this, from, from.expectedLateSyncBoundary);
            this.additionalFields = from.additionalFields;
            this.additionalVariable = from.additionalVariable;
        }

        EmptyContainer(EmptyContainer from, ByteBuffer buffer) {
            this(from, buffer, true);
        }

        @Override
        final EmptyContainer init(EmptyContainer from) {
            return this;
        }

        @Override
        final EmptyContainer createFields() {
            return this;
        }

        @Override
        final EmptyContainer writeFields() {
            return this;
        }

        @Override
        final EmptyContainer readFields() {
            return this;
        }

        @Override
        final EmptyContainer setFieldValues() {
            return this;
        }

        @Override
        final EmptyContainer updateFirstField() {
            return this;
        }

        @Override
        final EmptyContainer updateMiddleField() {
            return this;
        }

        @Override
        final EmptyContainer updateLastField() {
            return this;
        }

        @Override
        final EmptyContainer validateFields(ByteBuffer buffer) {
            Assert.assertEquals((long)super.count(), (long)this.additionalFields);
            if (this.additionalFields == 0) {
                Assert.assertNull((Object)super.first());
                Assert.assertNull((Object)super.next());
                Assert.assertNull((Object)super.get(1));
                Assert.assertNull((Object)super.get(100));
            }
            Assert.assertEquals((Object)super.isVariableLength(), (Object)this.additionalVariable);
            Assert.assertEquals((long)super.getSerializedLength(), (long)this.expectedSerializedLength());
            return this;
        }

        @Override
        final StoField expectedLateSyncBoundary() {
            return this.expectedLateSyncBoundary;
        }

        @Override
        final int expectedLateSyncBoundaryMark() {
            return this.expectedLateSyncBoundaryMark;
        }

        @Override
        final int expectedSerializedLength() {
            return this.expectedSerializedLength;
        }

        @Override
        final EmptyContainer appendAdditionalFixed() {
            StoIntField field = StoIntField.create(null);
            this.append(field);
            this.expectedSerializedLength += field.getLength();
            if (this.expectedLateSyncBoundary == null) {
                this.expectedLateSyncBoundaryMark = this.expectedSerializedLength;
            }
            ++this.additionalFields;
            return this;
        }

        @Override
        final EmptyContainer appendAdditionalVariable() {
            StoStringField field = StoStringField.create(null);
            this.append(field);
            this.expectedSerializedLength += field.getLength();
            if (this.expectedLateSyncBoundary == null) {
                this.expectedLateSyncBoundary = field;
            }
            ++this.additionalFields;
            this.additionalVariable = true;
            return this;
        }
    }

    private abstract class TestContainer<T extends TestContainer<T>>
    extends StoFieldContainer {
        TestContainer() {
        }

        TestContainer(ByteBuffer buffer, boolean attach) {
            super(buffer, attach);
        }

        TestContainer(ByteBuffer buffer) {
            super(buffer, true);
        }

        abstract T init(T var1);

        abstract T createFields();

        abstract T writeFields();

        abstract T readFields();

        abstract T setFieldValues();

        abstract T updateFirstField();

        abstract T updateMiddleField();

        abstract T updateLastField();

        abstract T validateFields(ByteBuffer var1);

        abstract StoField expectedLateSyncBoundary();

        abstract int expectedLateSyncBoundaryMark();

        abstract int expectedSerializedLength();

        abstract T appendAdditionalFixed();

        abstract T appendAdditionalVariable();
    }
}

