/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto;

import com.neeve.sto.EStoFieldCorruptException;
import com.neeve.sto.EStoFieldVersionInvalidException;
import com.neeve.sto.StoByteField;
import com.neeve.sto.StoField;
import com.neeve.sto.StoStringField;
import java.nio.ByteBuffer;

final class StoFieldHeader
implements Cloneable {
    private static final int MAGIC_POS = 0;
    private static final int VERSION_BODY_TYPE_POS = 1;
    private static final int NAME_POS = 2;
    private static final byte V1 = 1;
    private static final byte VERSION = 1;
    private static final int STATIC_HEADER_LENGTH_V1 = 2;
    private static final int STATIC_HEADER_LENGTH = 2;
    private static final byte MAGIC = -3;
    private short version;
    private StoField.Type type;
    private String name;
    private int length;
    private ByteBuffer buffer;
    private int bufferOffset;

    StoFieldHeader(StoField.Type type, String name) throws EStoFieldCorruptException, EStoFieldVersionInvalidException {
        this.init((short)1, type, name, 2 + StoStringField.getSerializedLength(name));
    }

    StoFieldHeader(ByteBuffer buffer, int bufferOffset) {
        this.buffer = buffer;
        this.bufferOffset = bufferOffset;
    }

    private final void init(short version, StoField.Type type, String name, int length) {
        this.version = version;
        this.type = type;
        this.name = name;
        this.length = length;
        this.buffer = null;
        this.bufferOffset = 0;
    }

    static int getSerializedLength(ByteBuffer buffer, int bufferOffset) {
        return 2 + StoStringField.getSerializedLength(buffer, bufferOffset + 2);
    }

    static StoField.Type preDeserialize(ByteBuffer buffer, int bufferOffset) {
        int magicPlusVersionLen = 2;
        if (buffer.limit() - bufferOffset > 2) {
            byte magic = StoByteField.get(buffer, bufferOffset + 0);
            if (magic != -3) {
                throw new EStoFieldCorruptException("invalid field header magic number [" + magic + "]");
            }
            short version = StoFieldHeader.getVersion(buffer, bufferOffset);
            if (version > 1) {
                throw new EStoFieldVersionInvalidException("Invalid field header version [max supported=1 received=" + version);
            }
            if (buffer.limit() - bufferOffset >= 2) {
                short namelen = (short)StoStringField.getSerializedLength(buffer, bufferOffset + 2);
                if (buffer.limit() - bufferOffset >= 2 + namelen) {
                    return StoFieldHeader.getType(buffer, bufferOffset);
                }
                throw new EStoFieldCorruptException("incomplete field record");
            }
            throw new EStoFieldCorruptException("incomplete field record");
        }
        throw new EStoFieldCorruptException("incomplete field record");
    }

    final void sync(ByteBuffer buffer, int bufferOffset) {
        StoByteField.put(buffer, bufferOffset + 0, (byte)-3);
        StoByteField.put(buffer, bufferOffset + 1, (byte)(0xFF & (0x20 | this.type.encoding)));
        StoStringField.put(buffer, bufferOffset + 2, this.name);
    }

    final void setBackingBuffer(ByteBuffer buffer, int bufferOffset) {
        this.clearBackingBuffer();
        this.buffer = buffer;
        this.bufferOffset = bufferOffset;
        this.sync(buffer, bufferOffset);
    }

    final void clearBackingBuffer() {
        if (this.buffer != null) {
            this.version = StoFieldHeader.getVersion(this.buffer, this.bufferOffset);
            this.type = StoFieldHeader.getType(this.buffer, this.bufferOffset);
            this.name = StoStringField.get(this.buffer, this.bufferOffset + 2);
            if (this.length == 0) {
                this.length = StoFieldHeader.getSerializedLength(this.buffer, this.bufferOffset);
            }
            this.buffer = null;
            this.bufferOffset = -1;
        }
    }

    final void changeBackingBuffer(ByteBuffer buffer, int bufferOffset) {
        if (this.getType() != StoFieldHeader.getType(buffer, bufferOffset)) {
            throw new EStoFieldCorruptException("type in new backing buffer is different from field type (exp=" + (Object)((Object)this.getType()) + ", actual=" + (Object)((Object)StoFieldHeader.getType(buffer, bufferOffset)) + ")");
        }
        if (this.getVersion() != StoFieldHeader.getVersion(buffer, bufferOffset)) {
            throw new EStoFieldCorruptException("header version in new backing buffer is different from header version (exp=" + this.getVersion() + ", actual=" + StoFieldHeader.getVersion(buffer, bufferOffset) + ")");
        }
        this.name = null;
        this.length = 0;
        this.buffer = buffer;
        this.bufferOffset = bufferOffset;
    }

    static final boolean hasName(ByteBuffer buffer, int bufferOffset) {
        return !StoStringField.isNull(buffer, bufferOffset + 2);
    }

    final String getName() {
        if (this.name == null && this.buffer != null) {
            this.name = StoStringField.get(this.buffer, this.bufferOffset + 2);
        }
        return this.name;
    }

    private static final short getVersion(ByteBuffer buffer, int bufferOffset) {
        return (short)(0xFF & StoByteField.get(buffer, bufferOffset + 1) >> 5);
    }

    final short getVersion() {
        if (this.version == 0 && this.buffer != null) {
            this.version = StoFieldHeader.getVersion(this.buffer, this.bufferOffset);
        }
        return this.version;
    }

    static final StoField.Type getType(ByteBuffer buffer, int bufferOffset) {
        return StoField.Type.fromEncoding((byte)(0x1F & StoByteField.get(buffer, bufferOffset + 1)));
    }

    final StoField.Type getType() {
        if (this.type == null && this.buffer != null) {
            this.type = StoFieldHeader.getType(this.buffer, this.bufferOffset);
        }
        return this.type;
    }

    final int getSerializedLength() {
        if (this.length == 0 && this.buffer != null) {
            this.length = StoFieldHeader.getSerializedLength(this.buffer, this.bufferOffset);
        }
        return this.length;
    }

    final boolean contentsEquals(StoFieldHeader other) {
        boolean equals = this.getVersion() == other.getVersion();
        if (equals && (equals = this.getType() == other.getType())) {
            equals = this.getName() == null ? other.getName() == null : this.getName().equals(other.getName());
        }
        return equals;
    }

    public final Object clone() {
        StoFieldHeader clonee;
        try {
            clonee = (StoFieldHeader)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("Received CloneNotSupportedException even when Cloneable is implemented!");
        }
        clonee.init(this.getVersion(), this.getType(), this.getName(), 2 + StoStringField.getSerializedLength(clonee.name));
        return clonee;
    }

    public final String toString() {
        return "[" + this.getName() + "," + (Object)((Object)this.getType()) + ",V" + this.getVersion() + "]";
    }
}

