/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto;

import com.neeve.sto.EStoFieldCorruptException;
import com.neeve.sto.StoBooleanArrayField;
import com.neeve.sto.StoBooleanField;
import com.neeve.sto.StoBufferField;
import com.neeve.sto.StoByteArrayField;
import com.neeve.sto.StoByteField;
import com.neeve.sto.StoCompoundArrayField;
import com.neeve.sto.StoCompoundField;
import com.neeve.sto.StoDateField;
import com.neeve.sto.StoDoubleArrayField;
import com.neeve.sto.StoDoubleField;
import com.neeve.sto.StoFieldHeader;
import com.neeve.sto.StoFixedLengthStringField;
import com.neeve.sto.StoFloatArrayField;
import com.neeve.sto.StoFloatField;
import com.neeve.sto.StoIntArrayField;
import com.neeve.sto.StoIntField;
import com.neeve.sto.StoLongArrayField;
import com.neeve.sto.StoLongField;
import com.neeve.sto.StoShortArrayField;
import com.neeve.sto.StoShortField;
import com.neeve.sto.StoStringArrayField;
import com.neeve.sto.StoStringField;
import com.neeve.util.UtlListElement;
import java.nio.ByteBuffer;

public abstract class StoField
extends UtlListElement
implements Cloneable {
    private StoFieldHeader header;
    protected ByteBuffer buffer;
    protected int headerOffset;
    protected int bodyOffset;

    protected StoField(Type type, String name) {
        this.header = new StoFieldHeader(type, name);
    }

    protected StoField(ByteBuffer buffer, int bufferOffset) {
        this.buffer = buffer;
        this.headerOffset = bufferOffset;
        this.bodyOffset = this.headerOffset + StoFieldHeader.getSerializedLength(buffer, this.headerOffset);
    }

    private final void init() {
        this.header = null;
        this.buffer = null;
        this.headerOffset = 0;
        this.bodyOffset = 0;
    }

    final void switchBackingBuffer(ByteBuffer buffer) {
        if (this.buffer == null) {
            throw new InternalError("attempt to switch field's backing buffer with no existing backing buffer");
        }
        if (buffer == null) {
            throw new InternalError("attempt to switch field's backing buffer with a null buffer");
        }
        this.buffer = buffer;
    }

    protected abstract void doSyncToBuffer(ByteBuffer var1, int var2);

    protected abstract void onBackingBufferAttach();

    protected abstract void onBackingBufferDetach();

    protected abstract void onBackingBufferChange();

    protected abstract int getSerializedLength();

    protected abstract String getValueString();

    protected abstract boolean bodyContentsEquals(StoField var1);

    protected abstract void cloneBody(StoField var1);

    public abstract boolean isVariableLength();

    public static int getSerializedLength(Type type, ByteBuffer buffer, int bufferOffset) {
        int length = StoFieldHeader.getSerializedLength(buffer, bufferOffset);
        bufferOffset += length;
        switch (type) {
            case BYTE: {
                length += StoByteField.getSerializedLength(buffer, bufferOffset);
                break;
            }
            case SHORT: {
                length += StoShortField.getSerializedLength(buffer, bufferOffset);
                break;
            }
            case INTEGER: {
                length += StoIntField.getSerializedLength(buffer, bufferOffset);
                break;
            }
            case FLOAT: {
                length += StoFloatField.getSerializedLength(buffer, bufferOffset);
                break;
            }
            case LONG: {
                length += StoLongField.getSerializedLength(buffer, bufferOffset);
                break;
            }
            case DOUBLE: {
                length += StoDoubleField.getSerializedLength(buffer, bufferOffset);
                break;
            }
            case STRING: {
                length += StoStringField.getSerializedLength(buffer, bufferOffset);
                break;
            }
            case FIXLEN_STRING: {
                length += StoFixedLengthStringField.getSerializedLength(buffer, bufferOffset);
                break;
            }
            case BOOLEAN: {
                length += StoBooleanField.getSerializedLength(buffer, bufferOffset);
                break;
            }
            case BUFFER: {
                length += StoBufferField.getSerializedLength(buffer, bufferOffset);
                break;
            }
            case COMPOUND: {
                length += StoCompoundField.getSerializedLength(buffer, bufferOffset);
                break;
            }
            case BYTE_ARRAY: {
                length += StoByteArrayField.getSerializedLength(buffer, bufferOffset);
                break;
            }
            case SHORT_ARRAY: {
                length += StoShortArrayField.getSerializedLength(buffer, bufferOffset);
                break;
            }
            case INTEGER_ARRAY: {
                length += StoIntArrayField.getSerializedLength(buffer, bufferOffset);
                break;
            }
            case FLOAT_ARRAY: {
                length += StoFloatArrayField.getSerializedLength(buffer, bufferOffset);
                break;
            }
            case LONG_ARRAY: {
                length += StoLongArrayField.getSerializedLength(buffer, bufferOffset);
                break;
            }
            case DOUBLE_ARRAY: {
                length += StoDoubleArrayField.getSerializedLength(buffer, bufferOffset);
                break;
            }
            case STRING_ARRAY: {
                length += StoStringArrayField.getSerializedLength(buffer, bufferOffset);
                break;
            }
            case BOOLEAN_ARRAY: {
                length += StoBooleanArrayField.getSerializedLength(buffer, bufferOffset);
                break;
            }
            case COMPOUND_ARRAY: {
                length += StoCompoundArrayField.getSerializedLength(buffer, bufferOffset);
                break;
            }
            case DATE: {
                length += StoDateField.getSerializedLength(buffer, bufferOffset);
            }
        }
        return length;
    }

    public static int getSerializedLength(ByteBuffer buffer, int bufferOffset) {
        return StoField.getSerializedLength(StoFieldHeader.getType(buffer, bufferOffset), buffer, bufferOffset);
    }

    public static StoField create(ByteBuffer buffer, int bufferOffset) {
        Type type = StoFieldHeader.preDeserialize(buffer, bufferOffset);
        switch (type) {
            case BYTE: {
                return StoByteField.create(buffer, bufferOffset);
            }
            case SHORT: {
                return StoShortField.create(buffer, bufferOffset);
            }
            case INTEGER: {
                return StoIntField.create(buffer, bufferOffset);
            }
            case FLOAT: {
                return StoFloatField.create(buffer, bufferOffset);
            }
            case LONG: {
                return StoLongField.create(buffer, bufferOffset);
            }
            case DOUBLE: {
                return StoDoubleField.create(buffer, bufferOffset);
            }
            case STRING: {
                return StoStringField.create(buffer, bufferOffset);
            }
            case FIXLEN_STRING: {
                return StoFixedLengthStringField.create(buffer, bufferOffset);
            }
            case BOOLEAN: {
                return StoBooleanField.create(buffer, bufferOffset);
            }
            case BUFFER: {
                return StoBufferField.create(buffer, bufferOffset);
            }
            case COMPOUND: {
                return StoCompoundField.create(buffer, bufferOffset);
            }
            case BYTE_ARRAY: {
                return StoByteArrayField.create(buffer, bufferOffset);
            }
            case SHORT_ARRAY: {
                return StoShortArrayField.create(buffer, bufferOffset);
            }
            case INTEGER_ARRAY: {
                return StoIntArrayField.create(buffer, bufferOffset);
            }
            case FLOAT_ARRAY: {
                return StoFloatArrayField.create(buffer, bufferOffset);
            }
            case LONG_ARRAY: {
                return StoLongArrayField.create(buffer, bufferOffset);
            }
            case DOUBLE_ARRAY: {
                return StoDoubleArrayField.create(buffer, bufferOffset);
            }
            case STRING_ARRAY: {
                return StoStringArrayField.create(buffer, bufferOffset);
            }
            case BOOLEAN_ARRAY: {
                return StoBooleanArrayField.create(buffer, bufferOffset);
            }
            case COMPOUND_ARRAY: {
                return StoCompoundArrayField.create(buffer, bufferOffset);
            }
            case DATE: {
                return StoDateField.create(buffer, bufferOffset);
            }
        }
        return null;
    }

    public final StoField setBackingBuffer(ByteBuffer buffer, int bufferOffset) {
        this.clearBackingBuffer();
        this.buffer = buffer;
        this.headerOffset = bufferOffset;
        this.getHeader().setBackingBuffer(buffer, this.headerOffset);
        this.bodyOffset = this.headerOffset + StoFieldHeader.getSerializedLength(buffer, this.headerOffset);
        this.onBackingBufferAttach();
        return this;
    }

    public final StoField clearBackingBuffer() {
        if (this.buffer != null) {
            this.getHeader().clearBackingBuffer();
            this.onBackingBufferDetach();
            this.buffer = null;
            this.headerOffset = -1;
            this.bodyOffset = -1;
        }
        return this;
    }

    public final StoField changeBackingBuffer(ByteBuffer buffer, int bufferOffset) throws EStoFieldCorruptException {
        this.buffer = buffer;
        this.headerOffset = bufferOffset;
        this.getHeader().changeBackingBuffer(buffer, this.headerOffset);
        this.bodyOffset = this.headerOffset + StoFieldHeader.getSerializedLength(buffer, this.headerOffset);
        this.onBackingBufferChange();
        return this;
    }

    public final int shiftForHeader(int offset) {
        return offset + this.getHeader().getSerializedLength();
    }

    public final StoField sync(ByteBuffer buffer, int bufferOffset) {
        if (this.buffer != null) {
            throw new IllegalStateException("cannot sync a field that is already backed by a buffer");
        }
        this.getHeader().sync(buffer, bufferOffset);
        this.doSyncToBuffer(buffer, this.shiftForHeader(bufferOffset));
        return this;
    }

    public final StoFieldHeader getHeader() {
        if (this.header == null) {
            this.header = new StoFieldHeader(this.buffer, this.headerOffset);
        }
        return this.header;
    }

    public final boolean isNamed() {
        return this.header == null ? StoFieldHeader.hasName(this.buffer, this.headerOffset) : this.getName() != null;
    }

    public final String getName() {
        return this.getHeader().getName();
    }

    public final short getVersion() {
        return this.getHeader().getVersion();
    }

    public final Type getType() {
        return this.getHeader().getType();
    }

    public final int getLength() {
        return this.getHeader().getSerializedLength() + this.getSerializedLength();
    }

    public final ByteBuffer getBackingBuffer() {
        return this.buffer;
    }

    public final boolean contentsEquals(StoField other) {
        boolean equals = other != null;
        if (equals && (equals = this.getHeader().contentsEquals(other.getHeader()))) {
            equals = this.bodyContentsEquals(other);
        }
        return equals;
    }

    public final Object clone() {
        StoField clonee;
        try {
            clonee = (StoField)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("Received CloneNotSupportedException even when Cloneable is implemented!");
        }
        clonee.init();
        clonee.header = this.header == null ? null : (StoFieldHeader)this.header.clone();
        this.cloneBody(clonee);
        return clonee;
    }

    public abstract void reset();

    public final String toString() {
        return "{" + this.getHeader().toString() + ",[" + this.getValueString() + "]}";
    }

    public static enum Type {
        BYTE(1),
        SHORT(2),
        INTEGER(3),
        FLOAT(4),
        LONG(5),
        DOUBLE(6),
        STRING(7),
        FIXLEN_STRING(8),
        BOOLEAN(9),
        BUFFER(10),
        COMPOUND(11),
        BYTE_ARRAY(12),
        SHORT_ARRAY(13),
        INTEGER_ARRAY(14),
        FLOAT_ARRAY(15),
        LONG_ARRAY(16),
        DOUBLE_ARRAY(17),
        STRING_ARRAY(18),
        BOOLEAN_ARRAY(19),
        COMPOUND_ARRAY(20),
        DATE(21);

        public final byte encoding;

        private Type(byte encoding) {
            this.encoding = encoding;
        }

        public static final Type fromEncoding(byte encoding) {
            switch (encoding) {
                case 1: {
                    return BYTE;
                }
                case 2: {
                    return SHORT;
                }
                case 3: {
                    return INTEGER;
                }
                case 4: {
                    return FLOAT;
                }
                case 5: {
                    return LONG;
                }
                case 6: {
                    return DOUBLE;
                }
                case 7: {
                    return STRING;
                }
                case 8: {
                    return FIXLEN_STRING;
                }
                case 9: {
                    return BOOLEAN;
                }
                case 10: {
                    return BUFFER;
                }
                case 11: {
                    return COMPOUND;
                }
                case 12: {
                    return BYTE_ARRAY;
                }
                case 13: {
                    return SHORT_ARRAY;
                }
                case 14: {
                    return INTEGER_ARRAY;
                }
                case 15: {
                    return FLOAT_ARRAY;
                }
                case 16: {
                    return LONG_ARRAY;
                }
                case 17: {
                    return DOUBLE_ARRAY;
                }
                case 18: {
                    return STRING_ARRAY;
                }
                case 19: {
                    return BOOLEAN_ARRAY;
                }
                case 20: {
                    return COMPOUND_ARRAY;
                }
                case 21: {
                    return DATE;
                }
            }
            throw new EStoFieldCorruptException("unsupported field type encoding [" + encoding + "]");
        }
    }
}

