/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.pkt.log.test.unit;

import com.neeve.ci.XRuntime;
import com.neeve.io.IOElasticBuffer;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktHeader;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.log.EPktLogInvalidPositionException;
import com.neeve.pkt.log.PktRecoveryLog;
import com.neeve.test.UnitTest;
import java.io.File;
import java.io.FilenameFilter;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class PktRecoveryLogTest
extends UnitTest {
    private static final boolean isUnix = !System.getProperty("os.name").startsWith("Windows");
    private static final int PAGE_SIZE = 8192;
    private static final int NUM_LOG_ENTRIES = XRuntime.getValue((String)"numLogEntries", (int)10000);
    private static final long PREALLOCATED_LOG_SIZE = 0x20000000L;
    private static final Random random = new Random(System.currentTimeMillis());
    private static final List<RandomReadAtContext> randomReadAtPos = new ArrayList<RandomReadAtContext>();
    private static PktRecoveryLog log1 = null;
    private static PktRecoveryLog log2 = null;
    private final boolean flushUsingMappedMemory;
    private final int autoFlushSize;
    private final boolean supportsTailing;

    @Parameterized.Parameters(name="{index}: flushUsingMappedMemory={0}, autoFlushSize={1}, supportsTailing={2}")
    public static Collection<Object[]> data() {
        Object[][] objectArrayArray;
        if (isUnix) {
            Object[][] objectArrayArray2 = new Object[8][];
            objectArrayArray2[0] = new Object[]{false, 8192, false};
            objectArrayArray2[1] = new Object[]{false, 8192, true};
            objectArrayArray2[2] = new Object[]{false, 0, false};
            objectArrayArray2[3] = new Object[]{false, 0, true};
            objectArrayArray2[4] = new Object[]{true, 8192, false};
            objectArrayArray2[5] = new Object[]{true, 8192, true};
            objectArrayArray2[6] = new Object[]{true, 0, false};
            objectArrayArray = objectArrayArray2;
            objectArrayArray2[7] = new Object[]{true, 0, true};
        } else {
            Object[][] objectArrayArray3 = new Object[4][];
            objectArrayArray3[0] = new Object[]{false, 8192, false};
            objectArrayArray3[1] = new Object[]{false, 8192, true};
            objectArrayArray3[2] = new Object[]{false, 0, false};
            objectArrayArray = objectArrayArray3;
            objectArrayArray3[3] = new Object[]{false, 0, true};
        }
        Object[][] data = objectArrayArray;
        return Arrays.asList(data);
    }

    public PktRecoveryLogTest(boolean flushUsingMappedMemory, int autoFlushSize, boolean supportsTailing) {
        this.flushUsingMappedMemory = flushUsingMappedMemory;
        this.autoFlushSize = autoFlushSize;
        this.supportsTailing = supportsTailing;
    }

    private static final void getPacketBody(IOElasticBuffer buf, int i) {
        buf.setLength(i * 4);
        for (int j = 0; j < i; ++j) {
            buf.putInt(j * 4, i);
        }
    }

    private static final PktPacket createPacket(int i) {
        PktPacket packet = PktFactory.getInstance().createPacket(257);
        IOElasticBuffer buf = IOElasticBuffer.create(null, (int)1, (boolean)false);
        PktRecoveryLogTest.getPacketBody(buf, i);
        packet.getBody().deserialize(buf, 0, buf.getLength());
        return packet;
    }

    private static final PktPacket createPacketWithBodyLen(int bodyLen) {
        PktPacket packet = PktFactory.getInstance().createPacket(257);
        IOElasticBuffer buf = IOElasticBuffer.create(null, (int)bodyLen, (boolean)false);
        buf.ensureBackingBufferExists();
        packet.getBody().deserialize(buf, 0, buf.getLength());
        return packet;
    }

    private final PktRecoveryLog createLog(String name, long initialLength, boolean supportTailing) {
        PktRecoveryLog log = PktRecoveryLog.create(XRuntime.getDataDirectory(), name, PktRecoveryLog.FileOpenMode.rw, initialLength, false, this.flushUsingMappedMemory, this.autoFlushSize, 8192);
        log.open(supportTailing ? 128 : 0, 0L);
        return log;
    }

    private final PktRecoveryLog createLog(long initialLength, boolean supportTailing) {
        return this.createLog(String.valueOf(System.currentTimeMillis()) + ".log", initialLength, supportTailing);
    }

    private static final void writeLog(PktRecoveryLog log, boolean recordReadAtPos) {
        for (int i = 0; i < NUM_LOG_ENTRIES; ++i) {
            PktPacket packet = PktRecoveryLogTest.createPacket(i);
            log.write(packet, 0);
            if (!recordReadAtPos || random.nextInt(100) >= 30) continue;
            randomReadAtPos.add(new RandomReadAtContext(i, ((PktRecoveryLog.FilePosition)packet.getTag(4)).getPosition()));
        }
        Collections.shuffle(randomReadAtPos, new Random(System.currentTimeMillis()));
        log.flush(0);
    }

    private static final void closeLog(PktRecoveryLog log) {
        if (log != null) {
            log.close();
            new File(log.getDirname(), log.getFilename()).delete();
        }
    }

    @Before
    public final void before() {
        log1 = this.createLog(0L, this.supportsTailing);
        PktRecoveryLogTest.writeLog(log1, true);
        log2 = this.createLog(0x20000000L, this.supportsTailing);
        PktRecoveryLogTest.writeLog(log2, true);
    }

    private final void validatePacket(PktPacket packet, int i) {
        Assert.assertEquals((long)(i * 4), (long)packet.getBody().getBuffer().getLength());
        for (int j = 0; j < i; ++j) {
            Assert.assertEquals((long)i, (long)packet.getBody().getBuffer().getInt(j * 4));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void testRead(PktRecoveryLog log) throws Exception {
        try (PktRecoveryLog.Reader reader = log.createReader();){
            for (int i = 0; i < NUM_LOG_ENTRIES; ++i) {
                PktPacket packet = reader.next();
                Assert.assertNotNull((Object)((Object)packet));
                this.validatePacket(packet, i);
            }
            Assert.assertNull((Object)((Object)reader.next()));
        }
        PacketReceiver receiver = new PacketReceiver();
        try (PktRecoveryLog.MemoryMappedReader mmReader = log.createMemoryMappedReader(receiver);){
            for (int i = 0; i < NUM_LOG_ENTRIES; ++i) {
                Assert.assertNull((Object)((Object)mmReader.readOne()));
                Assert.assertNotNull((Object)((Object)receiver.packet));
                this.validatePacket(receiver.packet, i);
            }
            Assert.assertEquals((Object)((Object)PktRecoveryLog.MemoryMappedReader.ReadCompletionReason.EndOfFile), (Object)((Object)mmReader.readOne()));
        }
    }

    @Test
    public void testRead_NotPreallocated() throws Exception {
        this.testRead(log1);
    }

    @Test
    public void testRead_Preallocated() throws Exception {
        this.testRead(log2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void testReadAtInvalidPosition(PktRecoveryLog log, long position) throws Exception {
        try (PktRecoveryLog.Reader reader = log.createReader();){
            reader.readAt(position);
        }
    }

    @Test(expected=EPktLogInvalidPositionException.class)
    public void testReadAtPositionLessThanZero() throws Exception {
        this.testReadAtInvalidPosition(log1, -1L);
    }

    @Test(expected=EPktLogInvalidPositionException.class)
    public void testReadAtPositionEqualToZero() throws Exception {
        this.testReadAtInvalidPosition(log1, 0L);
    }

    @Test(expected=EPktLogInvalidPositionException.class)
    public void testReadAtPositionLessThanPreamble() throws Exception {
        this.testReadAtInvalidPosition(log1, 1L);
    }

    @Test(expected=EPktLogInvalidPositionException.class)
    public void testReadAtPositionGreaterThanFileLength() throws Exception {
        this.testReadAtInvalidPosition(log1, log1.getSize() + 1000L);
    }

    @Test(expected=EPktLogInvalidPositionException.class)
    public void testReadAtJustAfterPacketStart() throws Exception {
        this.testReadAtInvalidPosition(log1, PktRecoveryLogTest.randomReadAtPos.get((int)PktRecoveryLogTest.random.nextInt((int)PktRecoveryLogTest.randomReadAtPos.size())).pos + 1L);
    }

    @Test(expected=EPktLogInvalidPositionException.class)
    public void testReadAtJustBeforePacketEnd() throws Exception {
        this.testReadAtInvalidPosition(log1, PktRecoveryLogTest.randomReadAtPos.get((int)PktRecoveryLogTest.random.nextInt((int)PktRecoveryLogTest.randomReadAtPos.size())).pos - 1L);
    }

    @Test(expected=EPktLogInvalidPositionException.class)
    public void testReadAtMiddleOfEOFMarker() throws Exception {
        this.testReadAtInvalidPosition(log1, log1.getSize() + 10L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void testReadAtIsolated(PktRecoveryLog log) throws Exception {
        try (PktRecoveryLog.Reader reader = log.createReader();){
            for (int i = 0; i < randomReadAtPos.size(); ++i) {
                RandomReadAtContext readAtContext = randomReadAtPos.get(i);
                PktPacket packet = reader.readAt(readAtContext.pos);
                Assert.assertNotNull((Object)((Object)packet));
                this.validatePacket(packet, readAtContext.index);
            }
        }
        PacketReceiver receiver = new PacketReceiver();
        try (PktRecoveryLog.MemoryMappedReader mmReader = log.createMemoryMappedReader(receiver);){
            for (int i = 0; i < randomReadAtPos.size(); ++i) {
                RandomReadAtContext readAtContext = randomReadAtPos.get(i);
                mmReader.readAt(readAtContext.pos);
                Assert.assertNotNull((Object)((Object)receiver.packet));
                this.validatePacket(receiver.packet, readAtContext.index);
            }
        }
    }

    @Test
    public void testReadAtIsolated_NotPreallocated() throws Exception {
        this.testReadAtIsolated(log1);
    }

    @Test
    public void testReadAtIsolated_Preallocated() throws Exception {
        this.testReadAtIsolated(log2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void testReadAtDuringRead(PktRecoveryLog log) throws Exception {
        try (PktRecoveryLog.Reader reader = log.createReader();){
            for (int i = 0; i < NUM_LOG_ENTRIES; ++i) {
                PktPacket packet;
                if (i % 100 == 0) {
                    RandomReadAtContext readAtContext = randomReadAtPos.get(random.nextInt(randomReadAtPos.size()));
                    packet = reader.readAt(readAtContext.pos);
                    Assert.assertNotNull((Object)((Object)packet));
                    this.validatePacket(packet, readAtContext.index);
                }
                packet = reader.next();
                Assert.assertNotNull((Object)((Object)packet));
                this.validatePacket(packet, i);
            }
            Assert.assertNull((Object)((Object)reader.next()));
        }
    }

    @Test
    public void testReadAtDuringRead_NotPreallocated() throws Exception {
        this.testReadAtDuringRead(log1);
    }

    @Test
    public void testReadAtDuringRead_Preallocated() throws Exception {
        this.testReadAtDuringRead(log2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void testReadAtEof(PktRecoveryLog log) throws Exception {
        try (PktRecoveryLog.Reader reader = log.createReader();){
            PktPacket packet = null;
            for (int i = 0; i < NUM_LOG_ENTRIES; ++i) {
                packet = reader.next();
            }
            long pos = ((PktRecoveryLog.FilePosition)packet.getTag(4)).getPosition();
            int size = ((PktRecoveryLog.FilePosition)packet.getTag(4)).getSize();
            Assert.assertNull((Object)((Object)reader.readAt(pos + (long)size)));
        }
    }

    @Test
    public void testReadAtEof_NotPreallocated() throws Exception {
        this.testReadAtEof(log1);
    }

    @Test
    public void testReadAtEof_Preallocated() throws Exception {
        this.testReadAtEof(log2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void testSeek(PktRecoveryLog log) throws Exception {
        try (PktRecoveryLog.Reader reader = log.createReader();){
            for (int i = 0; i < randomReadAtPos.size(); ++i) {
                RandomReadAtContext readAtContext = randomReadAtPos.get(i);
                reader.seek(readAtContext.pos);
                PktPacket packet = reader.next();
                Assert.assertNotNull((Object)((Object)packet));
                this.validatePacket(packet, readAtContext.index);
            }
        }
        PacketReceiver receiver = new PacketReceiver();
        try (PktRecoveryLog.MemoryMappedReader mmReader = log.createMemoryMappedReader(receiver);){
            for (int i = 0; i < randomReadAtPos.size(); ++i) {
                RandomReadAtContext readAtContext = randomReadAtPos.get(i);
                mmReader.seek(readAtContext.pos);
                mmReader.readOne();
                Assert.assertNotNull((Object)((Object)receiver.packet));
                this.validatePacket(receiver.packet, readAtContext.index);
            }
        }
    }

    @Test
    public void testSeek_NotPreallocated() throws Exception {
        this.testSeek(log1);
    }

    @Test
    public void testSeek_Preallocated() throws Exception {
        this.testSeek(log2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void testTail(long initialLength) throws Exception {
        PktRecoveryLog log = this.createLog(initialLength, true);
        try {
            new Writer(log).start();
            try (PktRecoveryLog.Reader reader = log.createReader();){
                for (int i = 0; i < NUM_LOG_ENTRIES; ++i) {
                    PktPacket packet;
                    while ((packet = reader.next()) == null) {
                    }
                    this.validatePacket(packet, i);
                }
                Assert.assertNull((Object)((Object)reader.next()));
            }
        }
        finally {
            PktRecoveryLogTest.closeLog(log);
        }
    }

    @Test
    public final void testTail_NotPreallocated() throws Exception {
        this.testTail(0L);
    }

    @Test
    public final void testTail_Preallocated() throws Exception {
        this.testTail(0x20000000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void testTailSlowWrite(long preallocateLen, int initialPacketLen, int packetNum) throws Exception {
        String name = String.valueOf(System.currentTimeMillis()) + ".log";
        PktRecoveryLog log = this.createLog(name, preallocateLen, true);
        try {
            if (initialPacketLen > 0) {
                log.write(PktRecoveryLogTest.createPacketWithBodyLen(initialPacketLen), 0);
            }
            PktPacket packet = PktRecoveryLogTest.createPacket(packetNum);
            log.write(packet, 0);
            long packetPos = ((PktRecoveryLog.FilePosition)packet.getTag(4)).getPosition();
            int packetSize = ((PktRecoveryLog.FilePosition)packet.getTag(4)).getSize();
            if (PktRecoveryLogTest.verbose()) {
                System.out.println("** packet pos=" + packetPos + ", size=" + packetSize);
            }
            log.flush(0);
            RandomAccessFile raf = new RandomAccessFile(new File(log.getDirname(), name), "rw");
            raf.seek(packetPos);
            byte[] buf = new byte[16384];
            int logContentLength = packetSize + PktFactory.getInstance().createPacket(262).getSerializedLength();
            raf.read(buf, 0, logContentLength);
            if (preallocateLen > 0L) {
                byte[] buf2 = new byte[logContentLength];
                raf.seek(packetPos);
                raf.write(buf2, 0, buf2.length);
            } else {
                raf.setLength(packetPos);
            }
            raf.seek(packetPos);
            new SlowWriter(raf, buf, logContentLength).start();
            try (PktRecoveryLog.Reader reader = log.createReader();){
                PktPacket read = reader.next();
                if (initialPacketLen > 0) {
                    read = reader.next();
                }
                Assert.assertNotNull((Object)((Object)read));
                this.validatePacket(read, packetNum);
            }
        }
        finally {
            PktRecoveryLogTest.closeLog(log);
        }
    }

    @Test
    public final void testTailSlowWrite_NotPreallocatedNoInDoubt_FullPacketLessThanPageSizeByMoreThanEOF() throws Exception {
        this.testTailSlowWrite(0L, 0, 1);
    }

    @Test
    public final void testTailSlowWrite_NotPreallocatedNoInDoubt_FullPacketLessThanPageSizeByEOF() throws Exception {
        this.testTailSlowWrite(0L, 0, 2031);
    }

    @Test
    public final void testTailSlowWrite_NotPreallocatedNoInDoubt_FullPacketLessThanPageSizeByLessThanEOF() throws Exception {
        this.testTailSlowWrite(0L, 0, 2032);
    }

    @Test
    public final void testTailSlowWrite_NotPreallocatedNoInDoubt_FullPacketLessThanPageSizeByLessThanMagic() throws Exception {
        this.testTailSlowWrite(0L, 0, 2039);
    }

    @Test
    public final void testTailSlowWrite_NotPreallocatedWithInDoubt_FullPacketLessThanPageSizeByMoreThanEOF() throws Exception {
        this.testTailSlowWrite(0L, 1, 1);
    }

    @Test
    public final void testTailSlowWrite_NotPreallocatedWithInDoubt_FullPacketLessThanPageSizeByEOF() throws Exception {
        this.testTailSlowWrite(0L, 2, 2031);
    }

    @Test
    public final void testTailSlowWrite_NotPreallocatedWithInDoubt_FullPacketLessThanPageSizeByLessThanEOF() throws Exception {
        this.testTailSlowWrite(0L, 2, 2032);
    }

    @Test
    public final void testTailSlowWrite_NotPreallocatedWithInDoubt_FullPacketLessThanPageSizeByLessThanMagic() throws Exception {
        this.testTailSlowWrite(0L, 2, 2039);
    }

    @Test
    public final void testTailSlowWrite_PreallocatedNoInDoubt_FullPacketLessThanPageSizeByMoreThanEOF() throws Exception {
        this.testTailSlowWrite(0x20000000L, 0, 1);
    }

    @Test
    public final void testTailSlowWrite_PreallocatedNoInDoubt_FullPacketLessThanPageSizeByEOF() throws Exception {
        this.testTailSlowWrite(0x20000000L, 0, 2031);
    }

    @Test
    public final void testTailSlowWrite_PreallocatedNoInDoubt_FullPacketLessThanPageSizeByLessThanEOF() throws Exception {
        this.testTailSlowWrite(0x20000000L, 0, 2032);
    }

    @Test
    public final void testTailSlowWrite_PreallocatedNoInDoubt_FullPacketLessThanPageSizeByLessThanMagic() throws Exception {
        this.testTailSlowWrite(0x20000000L, 0, 2039);
    }

    @Test
    public final void testTailSlowWrite_PreallocatedWithInDoubt_FullPacketLessThanPageSizeByMoreThanEOF() throws Exception {
        this.testTailSlowWrite(0x20000000L, 1, 1);
    }

    @Test
    public final void testTailSlowWrite_PreallocatedWithInDoubt_FullPacketLessThanPageSizeByEOF() throws Exception {
        this.testTailSlowWrite(0x20000000L, 2, 2031);
    }

    @Test
    public final void testTailSlowWrite_PreallocatedWithInDoubt_FullPacketLessThanPageSizeByLessThanEOF() throws Exception {
        this.testTailSlowWrite(0x20000000L, 2, 2032);
    }

    @Test
    public final void testTailSlowWrite_PreallocatedWithInDoubt_FullPacketLessThanPageSizeByLessThanMagic() throws Exception {
        this.testTailSlowWrite(0x20000000L, 2, 2039);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void testBackupLog() throws Exception {
        String log1Dirname = log1.getDirname();
        String log1Filename = log1.getFilename();
        Assert.assertEquals((long)2L, (long)new File(log1Dirname).listFiles(new LogFilenameFilter()).length);
        log1.close();
        log1 = null;
        String log1BackupFilename = PktRecoveryLog.backup(log1Dirname, log1Filename, true, true, false);
        System.out.println("Log 1 backup filename is " + log1BackupFilename);
        try {
            String log2BackupFilename = PktRecoveryLog.backup(log2.getDirname(), log2.getFilename(), false, true, false);
            System.out.println("Log 2 backup filename is " + log2BackupFilename);
            try {
                File[] files;
                for (File file : files = new File(log1Dirname).listFiles(new LogFilenameFilter())) {
                    System.out.println("..." + file.getAbsolutePath());
                }
                Assert.assertEquals((long)1L, (long)files.length);
            }
            finally {
                new File(log2BackupFilename).delete();
            }
        }
        finally {
            new File(log1BackupFilename).delete();
        }
    }

    @After
    public final void after() {
        PktRecoveryLogTest.closeLog(log1);
        PktRecoveryLogTest.closeLog(log2);
    }

    private static final class LogFilenameFilter
    implements FilenameFilter {
        private LogFilenameFilter() {
        }

        @Override
        public final boolean accept(File dir, String name) {
            return !name.equals("$archive$");
        }
    }

    private static final class SlowWriter
    extends Thread {
        private final RandomAccessFile log;
        private final byte[] buf;
        private final int len;

        SlowWriter(RandomAccessFile log, byte[] buf, int len) {
            this.setDaemon(true);
            this.log = log;
            this.buf = buf;
            this.len = len;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            try {
                int pos;
                ByteBuffer bytebuf = ByteBuffer.wrap(this.buf);
                bytebuf.limit(this.len);
                PktHeader.clearMagic(bytebuf, 0);
                long fp = this.log.getFilePointer();
                int middleChunkSize = this.len - 45;
                for (pos = 0; pos < 5; ++pos) {
                    Thread.sleep(100L);
                    if (PktRecoveryLogTest.verbose()) {
                        System.out.println("Writing 1 byte from buffer position " + pos + " to file at position " + this.log.getFilePointer());
                    }
                    this.log.write(this.buf, pos, 1);
                }
                Thread.sleep(100L);
                if (PktRecoveryLogTest.verbose()) {
                    System.out.println("Writing " + middleChunkSize + " bytes from buffer position " + pos + " to file at position " + this.log.getFilePointer());
                }
                this.log.write(this.buf, pos, middleChunkSize);
                pos += middleChunkSize;
                while (pos < this.len) {
                    Thread.sleep(100L);
                    if (PktRecoveryLogTest.verbose()) {
                        System.out.println("Writing 1 byte from buffer position " + pos + " to file at position " + this.log.getFilePointer());
                    }
                    this.log.write(this.buf, pos, 1);
                    ++pos;
                }
                PktHeader.restoreClearedMagic(bytebuf, 0);
                this.log.seek(fp);
                if (PktRecoveryLogTest.verbose()) {
                    System.out.println("Writing 3 bytes from buffer position 0 to file at position " + this.log.getFilePointer());
                }
                this.log.write(this.buf, 0, 3);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    this.log.close();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static final class Writer
    extends Thread {
        private final PktRecoveryLog log;

        Writer(PktRecoveryLog log) {
            this.setDaemon(true);
            this.log = log;
        }

        @Override
        public final void run() {
            try {
                Thread.sleep(1000L);
                PktRecoveryLogTest.writeLog(this.log, false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static final class RandomReadAtContext {
        final int index;
        final long pos;

        RandomReadAtContext(int index, long pos) {
            this.index = index;
            this.pos = pos;
        }

        public final String toString() {
            return "[" + this.index + ", " + this.pos + "]";
        }
    }

    private static final class PacketReceiver
    implements PktRecoveryLog.IPacketReceiver {
        PktPacket packet;

        private PacketReceiver() {
        }

        void clear() {
        }

        @Override
        public final void onPacket(PktPacket val) {
            this.packet = val;
        }
    }
}

