/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.pkt;

import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.pkt.EPktDeserializeException;
import com.neeve.pkt.EPktSerializeException;
import com.neeve.pkt.PktBody;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktHeader;
import com.neeve.pkt.PktSerializable;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlReferenceTracker;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;

public final class PktPacket
extends PktSerializable
implements UtlPool.Item<PktPacket>,
UtlReferenceTracker.HasReferenceTracker {
    private UtlReferenceTracker refTracker;
    private AtomicInteger ownershipCount;
    private PktHeader header;
    private PktBody body;
    private Object[] tags;
    private UtlPool<PktPacket> pool;
    private long inTs;
    private long outTs;

    private PktPacket(PktHeader header, PktBody body, Parameters parameters, int flags) {
        if (header == null) {
            throw new IllegalArgumentException("header cannot be null");
        }
        if (body == null) {
            throw new IllegalArgumentException("body cannot be null");
        }
        if (header.getBody() != body) {
            throw new IllegalStateException("supplied body does not match with body associated with supplied header");
        }
        this.init(header, body, parameters == null ? new Parameters() : parameters, new Object[5]);
    }

    static PktPacket create(PktHeader header, PktBody body, Parameters parameters, int flags) {
        return new PktPacket(header, body, parameters, flags);
    }

    private final void init(PktHeader header, PktBody body, Parameters parameters, Object[] tags) {
        this.ownershipCount = new AtomicInteger(0);
        this.header = header;
        this.body = body;
        this.tags = tags;
        this.refTracker = UtlReferenceTracker.enabled(((Object)((Object)this)).getClass()) ? new UtlReferenceTracker((Object)this) : null;
    }

    private final PktPacket fork(boolean storageOnly, boolean forceNonPooled) {
        PktPacket packet = forceNonPooled ? PktFactory.getInstance().createPacketNonPooled(this.body.getType()) : PktFactory.getInstance().createPacket(this.body.getType());
        this.header.fork(packet.getHeader(), storageOnly);
        this.body.fork(packet.getBody(), storageOnly);
        return packet;
    }

    public final PktHeader getHeader() {
        return this.header;
    }

    public final PktBody getBody() {
        return this.body;
    }

    public final void setTag(int id, Object tag) {
        if (id < 0 || id >= 5) {
            throw new IllegalArgumentException("invalid tag id=" + id);
        }
        this.tags[id] = tag;
        if (UtlReferenceTracker.TYPE_TRACKING_ENABLED && this.refTracker != null && id == 3) {
            if (tag == null) {
                this.refTracker.setAssociatedTracker(null);
            } else if (tag instanceof UtlReferenceTracker.HasReferenceTracker) {
                this.refTracker.setAssociatedTracker(((UtlReferenceTracker.HasReferenceTracker)tag).referenceTracker());
            }
        }
    }

    public final Object getTag(int id) {
        if (id < 0 || id >= 5) {
            throw new IllegalArgumentException("invalid tag id=" + id);
        }
        return this.tags[id];
    }

    public final void setInTs(long ts) {
        this.inTs = ts;
    }

    public final long getInTs() {
        return this.inTs;
    }

    public final void setOutTs(ByteBuffer buffer, int pos, long ts) {
        this.outTs = ts;
        this.header.setOutTs(buffer, pos, ts);
    }

    public final long getOutTs() {
        if (this.outTs == 0L) {
            this.outTs = this.header.getOutTs();
        }
        return this.outTs;
    }

    public final PktPacket acquire() {
        int val = this.ownershipCount.incrementAndGet();
        if (UtlReferenceTracker.TYPE_TRACKING_ENABLED && this.refTracker != null) {
            this.refTracker.onAcquire(val);
        }
        if (val <= 1 && this.pool != null) {
            throw new IllegalStateException("attempt to acquire an already disposed packet (packet='" + ((Object)((Object)this.body)).getClass().getName() + "')");
        }
        return this;
    }

    public final int getOwnerCount() {
        return this.ownershipCount.get();
    }

    public final void dispose() {
        int val = this.ownershipCount.decrementAndGet();
        if (UtlReferenceTracker.TYPE_TRACKING_ENABLED && this.refTracker != null) {
            this.refTracker.onDispose(val);
        }
        if (val < 0 && this.pool != null) {
            throw new IllegalStateException("attempt to dispose an already disposed packet (packet='" + ((Object)((Object)this.body)).getClass().getName() + "')");
        }
        if (val == 0 && this.pool != null) {
            this.pool.put((UtlPool.Item)this);
        }
    }

    final PktPacket undispose() {
        int val = this.ownershipCount.getAndSet(1);
        if (UtlReferenceTracker.TYPE_TRACKING_ENABLED && this.refTracker != null) {
            this.refTracker.onInit(1);
        }
        if (val != 0 && this.pool != null) {
            throw new IllegalStateException("attempt to undispose a packet that's not disposed (packet='" + ((Object)((Object)this.body)).getClass().getName() + "')");
        }
        return this;
    }

    public final UtlReferenceTracker referenceTracker() {
        return this.refTracker;
    }

    public final PktPacket fork(boolean storageOnly) {
        return this.fork(storageOnly, false);
    }

    public final PktPacket fork() {
        return this.fork(false);
    }

    public final PktPacket forkNonPooled() {
        return this.fork(false, true);
    }

    @Override
    public final void setSerializationPolicy(int policy) {
        super.setSerializationPolicy(policy);
        this.header.setSerializationPolicy(policy);
        this.body.setSerializationPolicy(policy);
    }

    @Override
    public final void serialize(PktSerializable.SerializeContext context, Tracer tracer) throws EPktSerializeException {
        if (tracer != null && tracer.debug) {
            tracer.log("Serializing packet (body=" + ((Object)((Object)this.body)).getClass().getSimpleName() + " bufferCount=" + context.getBufferCount() + ")...", Tracer.Level.DEBUG);
        }
        this.header.serialize(context, tracer);
        this.body.serialize(context, tracer);
    }

    public final int serialize(ByteBuffer buf) {
        return this.serialize(buf, buf.position());
    }

    public final int serialize(ByteBuffer buf, int bufOffset) {
        int serializedLength = this.header.serialize(buf, bufOffset);
        serializedLength += this.body.serialize(buf, bufOffset + serializedLength);
        return serializedLength;
    }

    public final int serialize(byte[] array, int arrayOffset) {
        int serializedLength = this.header.serialize(array, arrayOffset);
        serializedLength += this.body.serialize(array, arrayOffset + serializedLength);
        return serializedLength;
    }

    public final int serialize(IOBuffer iobuf, int iobufOffset) {
        int serializedLength = this.header.serialize(iobuf, iobufOffset);
        serializedLength += this.body.serialize(iobuf, iobufOffset + serializedLength);
        return serializedLength;
    }

    public final int serialize(IOElasticBuffer iobuf, int iobufOffset) {
        int serializedLength = this.header.serialize(iobuf, iobufOffset);
        serializedLength += this.body.serialize(iobuf, iobufOffset + serializedLength);
        return serializedLength;
    }

    public final int serialize(long address, int addressOffset) {
        int serializedLength = this.header.serialize(address, addressOffset);
        serializedLength += this.body.serialize(address, addressOffset + serializedLength);
        return serializedLength;
    }

    @Override
    public final void setDeserializationPolicy(int policy) {
        super.setDeserializationPolicy(policy);
        this.header.setDeserializationPolicy(policy);
        this.body.setDeserializationPolicy(policy);
    }

    @Override
    public final void deserialize(PktSerializable.DeserializeContext context, int packetSerializedLength, Tracer tracer) throws EPktDeserializeException {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        if (packetSerializedLength != -1) {
            throw new IllegalArgumentException("serialized length must be -1 since packet lengths are pulled from the serialized form");
        }
        if (tracer != null && tracer.debug) {
            tracer.log("Deserializing packet (body=" + ((Object)((Object)this.body)).getClass().getSimpleName() + ")...", Tracer.Level.DEBUG);
        }
        ByteBuffer buffer = context.getBuffer();
        int pos = buffer.position();
        this.header.deserialize(context, -1, tracer);
        this.body.deserialize(context, this.header.getLength() - (buffer.position() - pos), tracer);
    }

    public final int deserialize(ByteBuffer buf, int bufOffset) {
        int headerSerializedLength = this.header.deserialize(buf, bufOffset);
        int bodySerializedLength = this.header.getLength() - headerSerializedLength;
        this.body.deserialize(buf, bufOffset + headerSerializedLength, bodySerializedLength);
        return headerSerializedLength + bodySerializedLength;
    }

    public final int deserialize(IOBuffer iobuf, int iobufOffset, boolean wrap) {
        int headerSerializedLength = this.header.deserialize(iobuf, iobufOffset, wrap);
        int bodySerializedLength = this.header.getLength() - headerSerializedLength;
        this.body.deserialize(iobuf, iobufOffset + headerSerializedLength, bodySerializedLength, wrap);
        return headerSerializedLength + bodySerializedLength;
    }

    @Override
    public final int getSerializedLength() {
        return this.header.getSerializedLength() + this.body.getSerializedLength();
    }

    public final int getInitialBufferLength() {
        return this.header.getInitialBufferLength() + this.body.getInitialBufferLength();
    }

    public final PktPacket init() {
        this.header.reset();
        if (!this.body.isResettable()) {
            throw new IllegalStateException("packet type '" + PktFactory.getInstance().getPacketTypeNameFromId(this.body.getType()) + "' is not a poolable packet type");
        }
        this.body.reset();
        this.outTs = 0L;
        this.inTs = 0L;
        return this;
    }

    public final PktPacket setPool(UtlPool<PktPacket> pool) {
        if (pool != null && this.pool != pool && this.refTracker == null) {
            UtlReferenceTracker utlReferenceTracker = this.refTracker = UtlReferenceTracker.enabled((String)pool.type()) ? new UtlReferenceTracker((Object)this) : null;
            if (this.refTracker != null) {
                this.refTracker.onInit(this.ownershipCount.get());
            }
        }
        this.pool = pool;
        return this;
    }

    public final UtlPool<PktPacket> getPool() {
        return this.pool;
    }

    public final String toString() {
        return "pkt<hdr=" + (Object)((Object)this.header) + " body=" + (Object)((Object)this.body) + ">";
    }

    static final class Parameters
    implements Cloneable {
        private Parameters() {
        }

        static Parameters create() {
            return new Parameters();
        }

        public final Object clone() {
            Parameters clonee;
            try {
                clonee = (Parameters)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError("Received CloneNotSupportedException even when Cloneable is implemented!");
            }
            return clonee;
        }
    }
}

