/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.emx.test.unit;

import com.neeve.emx.EmxFactory;
import com.neeve.emx.IEmxAlarmEvent;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.emx.IEmxEvent;
import com.neeve.emx.IEmxEventHandler;
import com.neeve.emx.test.unit.EmxEventTest;
import com.neeve.test.UnitTest;
import org.junit.Test;

public final class EmxAlarmEventTest
extends UnitTest {
    static void checkValues(IEmxAlarmEvent event, int priority, IEmxEventHandler handler, IEmxDispatcher dispatcher, int interval) {
        EmxEventTest.checkValues(event, IEmxEvent.EventType.ALARM, priority, handler, dispatcher);
        if (event.getInterval() != interval) {
            EmxAlarmEventTest.testFailure((String)("Event interval mismatch [exp=" + interval + " actual=" + event.getInterval() + "]"));
        }
    }

    static void unscheduledEventCheckValuesAndTestElementsSet(IEmxAlarmEvent event, int priority, IEmxEventHandler handler, IEmxDispatcher dispatcher, int interval) {
        EmxEventTest.unscheduledEventCheckValuesAndTestElementsSet(event, priority, handler, dispatcher);
        EmxAlarmEventTest.checkValues(event, priority, handler, dispatcher, interval);
    }

    static void scheduledEventCheckValuesAndTestElementsSet(IEmxAlarmEvent event, int priority, IEmxEventHandler handler, IEmxDispatcher dispatcher, int interval) {
        EmxEventTest.scheduledEventCheckValuesAndTestElementsSet(event, priority, handler, dispatcher);
        EmxAlarmEventTest.checkValues(event, priority, handler, dispatcher, interval);
    }

    private void testCreateAndElementsSet(EmxFactory.EmxImpl impl) throws Exception {
        IEmxEventHandler handler = new IEmxEventHandler(){

            @Override
            public final boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
                return false;
            }
        };
        IEmxAlarmEvent event = EmxFactory.getInstance().createAlarmEvent(impl, handler, 0);
        EmxAlarmEventTest.unscheduledEventCheckValuesAndTestElementsSet(event, 15, handler, null, 0);
        try {
            event = EmxFactory.getInstance().createAlarmEvent(impl, null, -1);
            EmxAlarmEventTest.testFailure((String)"Permitted to create an alarm event with a negative interval!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        event = EmxFactory.getInstance().createAlarmEvent(impl, null, 100);
        EmxAlarmEventTest.checkValues(event, 15, null, null, 100);
    }

    @Test
    public void testCreateAndElementsSetDefaultImpl() {
        try {
            this.testCreateAndElementsSet(EmxFactory.EmxImpl.DEFAULT);
        }
        catch (Exception e) {
            EmxAlarmEventTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateAndElementsSetNIOImpl() {
        try {
            this.testCreateAndElementsSet(EmxFactory.EmxImpl.NIO);
        }
        catch (Exception e) {
            EmxAlarmEventTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }
}

