/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.emx;

import com.neeve.emx.EEmxException;
import com.neeve.emx.EEmxNwLnkClosedGracefullyException;
import com.neeve.emx.EmxActionExecutor;
import com.neeve.emx.EmxFactory;
import com.neeve.emx.EmxNwLnk;
import com.neeve.emx.EmxNwLnkReader;
import com.neeve.emx.IEmxAction;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.emx.IEmxDispatcherRunCompletionChecker;
import com.neeve.emx.IEmxEvent;
import com.neeve.emx.IEmxEventHandler;
import com.neeve.emx.IEmxNwReadReadyEvent;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlThrowable;

public final class EmxNwLnkNonBlockingReader
extends EmxNwLnkReader
implements IEmxDispatcherRunCompletionChecker,
IEmxEventHandler {
    private final IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(EmxFactory.EmxImpl.NIO, null, IEmxDispatcher.Params.create(false, true));
    private final EmxActionExecutor<Object, Object> actionExecutor = new EmxActionExecutor();
    private final LinkAddAction linkAddAction = new LinkAddAction();
    private final ReaderUnblockAction readerUnblockAction = new ReaderUnblockAction();

    private EmxNwLnkNonBlockingReader(EmxNwLnkReader.Callback cb) throws EEmxException {
        super(cb);
    }

    public static final EmxNwLnkNonBlockingReader create(EmxNwLnkReader.Callback cb) throws EEmxException {
        return new EmxNwLnkNonBlockingReader(cb);
    }

    public final EmxNwLnkNonBlockingReader addLink(EmxNwLnk link) throws Exception {
        if (link == null) {
            throw new IllegalArgumentException("link cannot be null");
        }
        if (this.runner.get() == null) {
            throw new IllegalStateException("reader not started");
        }
        if (this.stopped) {
            throw new IllegalStateException("reader is stopped");
        }
        link.configureBlockingRead(false);
        this.actionExecutor.invoke(this.dispatcher, this.linkAddAction, (Object)link, 1);
        return this;
    }

    @Override
    protected final void doRunPrepare() {
        this.dispatcher.setOwner(0);
    }

    @Override
    protected final void doRun() {
        while (true) {
            try {
                this.dispatcher.run(-1, this);
                this.dispatcher.close(true);
            }
            catch (Throwable e) {
                StringBuilder sb = new StringBuilder();
                sb.append("EMX link ready dispatcher encountered fatal exception ' [" + e.toString() + "]").append("\n");
                sb.append("Stack Trace:").append("\n");
                sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
                continue;
            }
            break;
        }
    }

    @Override
    protected final void doUnblock() {
        try {
            this.actionExecutor.invoke(this.dispatcher, this.readerUnblockAction, null, 0);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public final boolean isDone() {
        return this.stopped;
    }

    @Override
    public final Object getCompletion() {
        return null;
    }

    @Override
    public final boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
        EmxNwLnk link = (EmxNwLnk)((Object)event.getAttachment());
        try {
            this.readAndDispatch(link);
            return true;
        }
        catch (Throwable e) {
            if (e instanceof EEmxNwLnkClosedGracefullyException) {
                this.cb.handleLinkClosure(link);
            } else if (!this.stopped) {
                this.tracer.log(UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.SEVERE);
                this.cb.handleLinkFailure(link, e);
            }
            return false;
        }
    }

    private final class ReaderUnblockAction
    implements IEmxAction<Object, Object> {
        private ReaderUnblockAction() {
        }

        @Override
        public final Object execute(IEmxDispatcher dispatcher, Object object) throws Exception {
            return null;
        }
    }

    private final class LinkAddAction
    implements IEmxAction<Object, Object> {
        private LinkAddAction() {
        }

        @Override
        public final Object execute(IEmxDispatcher dispatcher, Object object) throws Exception {
            IEmxNwReadReadyEvent readReadyEvent = ((EmxNwLnk)((Object)object)).getReadReadyEvent();
            readReadyEvent.setHandler(EmxNwLnkNonBlockingReader.this);
            dispatcher.schedNwReadReadyEv(readReadyEvent);
            return null;
        }
    }
}

