/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.perf.sma;

import com.neeve.config.ConfigRepositoryFactory;
import com.neeve.config.IConfigRepository;
import com.neeve.event.IEventHandler;
import com.neeve.perf.serialization.rumi.xbuf2.MessageFactory;
import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.MessageBusBindingFactory;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.MessageViewFactory;
import com.neeve.sma.MessageViewFactoryRegistry;
import com.neeve.sma.SmaException;
import com.neeve.tools.interactive.commands.AnnotatedCommand;

abstract class Common
extends AnnotatedCommand
implements IEventHandler {
    @AnnotatedCommand.Option(shortForm=117, longForm="username", required=true, description="The bus binding username")
    protected String _username;
    @AnnotatedCommand.Option(shortForm=100, longForm="descriptor", required=true, description="the messaging bus connection descriptor")
    protected String _descriptor;
    @AnnotatedCommand.Option(shortForm=99, longForm="testCount", defaultValue="3000000", description="number of messages to send if less than 1 then unlimited")
    protected int _testCount;
    @AnnotatedCommand.Option(shortForm=114, longForm="testRate", required=true, defaultValue="100000", description="The send rate. If less than 1 then unlimited")
    protected int _testRate;
    @AnnotatedCommand.Option(shortForm=107, longForm="channelKey", description="the channel key")
    protected String _channelKey;
    @AnnotatedCommand.Option(shortForm=102, longForm="channelFilter", description="the channel filter")
    protected String _channelFilter;
    @AnnotatedCommand.Option(shortForm=113, longForm="channelQos", defaultValue="Guaranteed", description="the delivery QOS")
    protected MessageChannel.Qos _channelQos;
    @AnnotatedCommand.Option(shortForm=101, longForm="encoding", defaultValue="rumi.xbuf2", description="the encoding type")
    protected String _encoding;
    @AnnotatedCommand.Option(shortForm=105, longForm="printIntervalStats", description="whether to output stats at periodic intervals instead of only at the end")
    protected boolean _printIntervalStats;
    @AnnotatedCommand.Option(shortForm=102, longForm="dontWriteLatenciesToFile", description="whether to suppress writing latency values to a file")
    protected boolean _dontWriteLatenciesToFile;
    protected MessageBusBinding _binding;
    protected MessageChannel _channel;

    Common() {
    }

    protected void connect(boolean join) throws Exception {
        MessageBusDescriptor busDescriptor = MessageBusDescriptor.load((IConfigRepository)ConfigRepositoryFactory.getInstance().getDefaultRepository(), (String)"nvx-perf-messaging", null);
        MessageChannelDescriptor channelDescriptor = busDescriptor.getChannel("default");
        busDescriptor.setProviderConfig(this._descriptor);
        channelDescriptor.setChannelId((short)1);
        channelDescriptor.setChannelQos(this._channelQos);
        channelDescriptor.setChannelKey(this._channelKey);
        channelDescriptor.setChannelFilter(this._channelFilter);
        this._binding = MessageBusBindingFactory.getInstance().createBinding(this._username, busDescriptor, (IEventHandler)this);
        this._channel = this._binding.getMessageChannel("default");
        if (join) {
            this._channel.join(0);
        }
        this._binding.start();
    }

    static {
        try {
            MessageBusDescriptor busDescriptor = MessageBusDescriptor.create((String)"nvx-perf-messaging");
            MessageChannelDescriptor channelDescriptor = MessageChannelDescriptor.create((String)"default", (MessageBusDescriptor)busDescriptor);
            busDescriptor.addChannel(channelDescriptor);
            busDescriptor.save(ConfigRepositoryFactory.getInstance().getDefaultRepository(), null);
            MessageViewFactoryRegistry.getInstance().registerMessageViewFactory((MessageViewFactory)new MessageFactory());
        }
        catch (SmaException e) {
            throw new RuntimeException(e);
        }
    }
}

