/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma.test.unit;

import com.neeve.io.IOBuffer;
import com.neeve.lang.XString;
import com.neeve.sma.MessageTransportHeaders;
import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class MessageTransportHeadersTest {
    @Test
    public void testBooleanValueAdditions() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("key1", true);
        values.put("key2", false);
        this.testMessageHeaderPopulateSerializeDeserialize(values);
    }

    @Test
    public void testByteValueAdditions() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("key1", (byte)-1);
        values.put("key2", (byte)0);
        values.put("key3", (byte)1);
        values.put("key4", (byte)127);
        values.put("key5", (byte)-128);
        this.testMessageHeaderPopulateSerializeDeserialize(values);
    }

    @Test
    public void testCharValueAdditions() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("key1", Character.valueOf('a'));
        values.put("key2", Character.valueOf('b'));
        values.put("key3", Character.valueOf('1'));
        values.put("key4", Character.valueOf('Z'));
        this.testMessageHeaderPopulateSerializeDeserialize(values);
    }

    @Test
    public void testShortValueAdditions() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("key1", (short)-1);
        values.put("key2", (short)0);
        values.put("key3", (short)1);
        values.put("key4", (short)Short.MAX_VALUE);
        values.put("key5", (short)Short.MIN_VALUE);
        this.testMessageHeaderPopulateSerializeDeserialize(values);
    }

    @Test
    public void testIntValueAdditions() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("key1", -1);
        values.put("key2", 0);
        values.put("key3", 1);
        values.put("key4", Integer.MAX_VALUE);
        values.put("key5", Integer.MIN_VALUE);
        this.testMessageHeaderPopulateSerializeDeserialize(values);
    }

    @Test
    public void testLongValueAdditions() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("key1", -1L);
        values.put("key2", 0L);
        values.put("key3", 1L);
        values.put("key4", Long.MAX_VALUE);
        values.put("key5", Long.MIN_VALUE);
        this.testMessageHeaderPopulateSerializeDeserialize(values);
    }

    @Test
    public void testFloatValueAdditions() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("key1", Float.valueOf(-1.1f));
        values.put("key2", Float.valueOf(0.0f));
        values.put("key3", Float.valueOf(1.1f));
        values.put("key4", Float.valueOf(Float.MAX_VALUE));
        values.put("key5", Float.valueOf(Float.MIN_VALUE));
        this.testMessageHeaderPopulateSerializeDeserialize(values);
    }

    @Test
    public void testDoubleValueAdditions() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("key1", -1.1);
        values.put("key2", 0.0);
        values.put("key3", 1.1);
        values.put("key4", Double.MAX_VALUE);
        values.put("key5", Double.MIN_VALUE);
        this.testMessageHeaderPopulateSerializeDeserialize(values);
    }

    @Test
    public void testStringValueAdditions() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("key1", "value1");
        values.put("key2", "");
        values.put("key3", "value\ud83d\ude003");
        values.put("key\ud83d\ude004", "null");
        values.put("key5", "string\u5b57");
        this.testMessageHeaderPopulateSerializeDeserialize(values);
    }

    @Test
    public void testMultiValueAdditions() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("booleanKey", true);
        values.put("byteKey", (byte)2);
        values.put("charKey", Character.valueOf('c'));
        values.put("shortKey", (short)4);
        values.put("intKey", 5);
        values.put("longKey", 6L);
        values.put("floatKey", Float.valueOf(7.7f));
        values.put("doubleKey", 7.7);
        values.put("strKey", "str8");
        values.put("booleanKey2", false);
        values.put("byteKey2", -2);
        values.put("charKey2", Character.valueOf('9'));
        values.put("shortKey2", (short)-4);
        values.put("intKey2", -5);
        values.put("longKey2", -6L);
        values.put("floatKey2", Float.valueOf(-14.4f));
        values.put("doubleKey2", -15.15);
        values.put("strKey2", "str16");
        values.put("binKey1", new byte[]{1, 2, 3});
        this.testMessageHeaderPopulateSerializeDeserialize(values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testMessageHeaderPopulateSerializeDeserialize(LinkedHashMap<String, Object> headerValues) {
        MessageTransportHeaders headers = MessageTransportHeaders.create();
        try {
            for (Map.Entry<String, Object> h : headerValues.entrySet()) {
                this.addHeader(headers, h.getKey(), h.getValue(), false);
            }
            this.testMessageHeaderSerializeDeserialize(headers, headerValues);
            headers.dispose();
            headers = MessageTransportHeaders.create();
            for (Map.Entry<String, Object> h : headerValues.entrySet()) {
                this.addHeader(headers, h.getKey(), h.getValue(), true);
            }
            this.testMessageHeaderSerializeDeserialize(headers, headerValues);
        }
        finally {
            headers.dispose();
        }
    }

    private void addHeader(MessageTransportHeaders headers, String key, Object value, boolean useXString) {
        if (useXString) {
            if (value instanceof String) {
                headers.addHeader(XString.create((String)key), XString.create((String)((String)value)));
            } else {
                headers.addHeader(XString.create((String)key), value);
            }
        } else if (value instanceof String) {
            headers.addHeader((CharSequence)key, (CharSequence)((String)value));
        } else {
            headers.addHeader((CharSequence)key, value);
        }
    }

    private int expectedEncodingLength(String key, Object value) {
        int expectedLength = 0;
        expectedLength += 2;
        expectedLength += IOBuffer.calculateUTFLength((CharSequence)key);
        ++expectedLength;
        if (value instanceof String) {
            return expectedLength + 2 + (value != null ? IOBuffer.calculateUTFLength((CharSequence)((String)value)) : 0);
        }
        if (value instanceof XString) {
            return expectedLength + 2 + (value != null ? ((XString)value).getSerializedLength() : 0);
        }
        if (value instanceof Boolean) {
            return expectedLength + 1;
        }
        if (value instanceof Byte) {
            return expectedLength + 1;
        }
        if (value instanceof Character) {
            return expectedLength + 2;
        }
        if (value instanceof Short) {
            return expectedLength + 2;
        }
        if (value instanceof Integer) {
            return expectedLength + 4;
        }
        if (value instanceof Long) {
            return expectedLength + 8;
        }
        if (value instanceof Float) {
            return expectedLength + 4;
        }
        if (value instanceof Double) {
            return expectedLength + 8;
        }
        if (value instanceof byte[]) {
            return expectedLength + 2 + ((byte[])value).length;
        }
        return expectedLength;
    }

    private void testMessageHeaderSerializeDeserialize(MessageTransportHeaders headers, LinkedHashMap<String, Object> headerValues) {
        long expectedLength = 5L;
        for (Map.Entry<String, Object> h : headerValues.entrySet()) {
            expectedLength += (long)this.expectedEncodingLength(h.getKey(), h.getValue());
        }
        Assert.assertEquals((String)"wrong serialized length", (long)expectedLength, (long)headers.serializedLength());
        LinkedHashMap<String, String> encodedStringValues = new LinkedHashMap<String, String>();
        LinkedHashMap<String, Object> encodedObjectValues = new LinkedHashMap<String, Object>();
        for (MessageTransportHeaders.Header h : headers) {
            encodedStringValues.put(h.getName().toString(), h.getStringValue().toString());
            encodedObjectValues.put(h.getName().toString(), h.getValue());
        }
        MessageTransportHeadersTest.assertMapEquals("Wrong encoded headervalues", headerValues, encodedObjectValues);
        MessageTransportHeadersTest.assertMapEquals("Wrong toMap headervalues", headerValues, headers.toMap());
        encodedObjectValues.clear();
        headers.getAllTo(encodedObjectValues);
        MessageTransportHeadersTest.assertMapEquals("Wrong getAllTo headervalues", headerValues, encodedObjectValues);
        IOBuffer buf = IOBuffer.create((int)headers.serializedLength(), (boolean)true);
        headers.serialize(buf, 0);
        Assert.assertEquals((String)"wrong buf serialized length", (long)expectedLength, (long)buf.getLength());
        MessageTransportHeaders deserialized = MessageTransportHeaders.create();
        deserialized.deserialize(buf, 0);
        Assert.assertEquals((String)"wrong deserialized length", (long)expectedLength, (long)deserialized.serializedLength());
        LinkedHashMap<String, Object> deserializedValues = new LinkedHashMap<String, Object>();
        for (MessageTransportHeaders.Header h : deserialized) {
            deserializedValues.put(h.getName(), h.getValue());
        }
        MessageTransportHeadersTest.assertMapEquals("Wrong deserialized headers", headerValues, deserializedValues);
    }

    public static void assertMapEquals(String message, Map<String, Object> expected, Map<String, Object> actual) {
        boolean diff = false;
        if (expected.keySet().equals(actual.keySet())) {
            for (Map.Entry<String, Object> source : expected.entrySet()) {
                Object e = source.getValue();
                Object a = actual.get(source.getKey());
                if (e == null) {
                    if (a == null) continue;
                    diff = true;
                } else if (e instanceof byte[]) {
                    try {
                        Assert.assertArrayEquals((byte[])((byte[])e), (byte[])((byte[])a));
                        continue;
                    }
                    catch (AssertionError ex) {
                        diff = true;
                    }
                } else {
                    if (e.equals(a)) continue;
                    diff = true;
                }
                break;
            }
        } else {
            diff = true;
        }
        if (diff) {
            Assert.fail((String)(message + " expected: <" + expected + "> but was <" + actual + ">"));
        }
    }

    @Test(expected=NullPointerException.class)
    public void testNPEOnNullKeyAdd() {
        MessageTransportHeaders headers = MessageTransportHeaders.create();
        try {
            headers.addHeader(null, "test");
        }
        finally {
            headers.dispose();
        }
    }

    @Test(expected=NullPointerException.class)
    public void testNPEOnNullXStringKeyAdd() {
        MessageTransportHeaders headers = MessageTransportHeaders.create();
        try {
            headers.addHeader((XString)null, XString.create((String)"test"));
        }
        finally {
            headers.dispose();
        }
    }

    @Test(expected=NullPointerException.class)
    public void testNPEOnNullValueAdd() {
        MessageTransportHeaders headers = MessageTransportHeaders.create();
        try {
            headers.addHeader(null, "test");
        }
        finally {
            headers.dispose();
        }
    }

    @Test(expected=NullPointerException.class)
    public void testNPEOnNullXStringValueAdd() {
        MessageTransportHeaders headers = MessageTransportHeaders.create();
        try {
            headers.addHeader((XString)null, XString.create((String)"test"));
        }
        finally {
            headers.dispose();
        }
    }
}

