/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma;

import cern.colt.map.OpenIntObjectHashMap;
import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.pkt.PktPacket;
import com.neeve.sma.MessageLatencyManager;
import com.neeve.sma.MessageTransportHeaders;
import com.neeve.sma.MessageView;
import com.neeve.util.UtlBuffer;
import com.neeve.util.UtlListElement;
import com.neeve.util.UtlReferenceTracker;
import com.neeve.util.UtlTime;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class MessageViewImpl
extends UtlListElement
implements MessageView {
    private final UtlReferenceTracker refTracker;
    private Object[] sysTags;
    private OpenIntObjectHashMap usrTags;
    protected int messageEncodingType;
    protected Object message;
    protected final short vfid;
    protected final short type;
    protected final AtomicInteger ownershipCount = new AtomicInteger(1);

    protected MessageViewImpl(short vfid, short type, int messageEncodingType, Object message) {
        if (MessageLatencyManager.captureMsgLatencyStats) {
            this.setCreateTs(UtlTime.now());
        }
        this.vfid = vfid;
        this.type = type;
        if (UtlReferenceTracker.enabled(this.getClass())) {
            this.refTracker = new UtlReferenceTracker((Object)this);
            if (!this.isPooled()) {
                this.refTracker.onInit(1);
            }
        } else {
            this.refTracker = null;
        }
        this.setMessage(messageEncodingType, message);
    }

    protected MessageViewImpl(short vfid, short type) {
        if (MessageLatencyManager.captureMsgLatencyStats) {
            this.setCreateTs(UtlTime.now());
        }
        this.vfid = vfid;
        this.type = type;
        if (UtlReferenceTracker.enabled(this.getClass())) {
            this.refTracker = new UtlReferenceTracker((Object)this);
            if (!this.isPooled()) {
                this.refTracker.onInit(1);
            }
        } else {
            this.refTracker = null;
        }
    }

    protected void copyCopyableFieldsToCopy(MessageView copy) {
        copy.setOriginTs(this.getOriginTs());
    }

    protected boolean isPooled() {
        return false;
    }

    protected final void setMessage(int messageEncodingType, Object message) {
        this.messageEncodingType = messageEncodingType;
        this.message = message;
    }

    protected void undispose() {
        int val = this.ownershipCount.getAndSet(1);
        if (UtlReferenceTracker.TYPE_TRACKING_ENABLED && this.refTracker != null) {
            this.refTracker.onInit(1);
        }
        if (val != 0) {
            throw new IllegalStateException("attempt to undispose a message view that's not disposed (view='" + this.getClass().getName() + "')");
        }
    }

    @Override
    public final void setTag(int id, Object tag) {
        if (id < 0) {
            throw new IllegalArgumentException("tag id must be >= 0");
        }
        if (id < 5) {
            if (this.sysTags == null) {
                this.sysTags = new Object[5];
            }
            this.sysTags[id] = tag;
        } else {
            if (this.usrTags == null) {
                this.usrTags = new OpenIntObjectHashMap();
            }
            this.usrTags.put(id, tag);
        }
    }

    @Override
    public final Object getTag(int id) {
        if (id < 0) {
            throw new IllegalArgumentException("tag id must be >= 0");
        }
        return id < 5 ? (this.sysTags != null ? this.sysTags[id] : null) : (this.usrTags != null ? this.usrTags.get(id) : null);
    }

    @Override
    public final short getVfid() {
        return this.vfid;
    }

    @Override
    public final short getType() {
        return this.type;
    }

    @Override
    public final int getMessageEncodingType() {
        return this.messageEncodingType;
    }

    @Override
    public MessageTransportHeaders getMessageTransportHeaders() {
        return null;
    }

    @Override
    public MessageView setMessageTransportHeaders(MessageTransportHeaders headers) {
        return this;
    }

    @Override
    public final Object getMessage() {
        return this.message;
    }

    @Override
    public int serializeTo(byte[] array, int offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int serializeTo(ByteBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IOBuffer serializeToIOBuffer(boolean useNative) {
        ByteBuffer serialized = this.serializeToByteBuffer();
        IOBuffer target = IOBuffer.create((int)serialized.remaining(), (boolean)useNative);
        UtlBuffer.copy((ByteBuffer)serialized, (int)serialized.position(), (ByteBuffer)target.getBufferUnsafe(), (int)0, (int)serialized.remaining());
        return target;
    }

    @Override
    public int serializeTo(IOBuffer buffer, int offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int serializeTo(IOElasticBuffer buffer, int offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int serializeTo(PktPacket packet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int serializeTo(long addr, int offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MessageView deserializeFrom(byte[] array, int offset, int len) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MessageView deserializeFrom(ByteBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MessageView deserializeFrom(IOBuffer buffer, int offset, int len) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MessageView deserializeFrom(IOElasticBuffer buffer, int offset, int len) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MessageView deserializeFrom(PktPacket packet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MessageView deserializeFrom(long addr, int offset, int len) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void acquire() {
        int val = this.ownershipCount.incrementAndGet();
        if (UtlReferenceTracker.TYPE_TRACKING_ENABLED && this.refTracker != null) {
            this.refTracker.onAcquire(val);
        }
        if (val <= 1) {
            throw new IllegalStateException("attempt to acquire an already disposed message view (view='" + this.getClass().getName() + "')");
        }
    }

    @Override
    public final int getOwnershipCount() {
        return this.ownershipCount.get();
    }

    @Override
    public int dispose() {
        int val = this.ownershipCount.decrementAndGet();
        if (UtlReferenceTracker.TYPE_TRACKING_ENABLED && this.refTracker != null) {
            this.refTracker.onDispose(val);
        }
        if (val < 0) {
            throw new IllegalStateException("attempt to dispose an already disposed message view (view='" + this.getClass().getName() + "')");
        }
        return val;
    }

    @Override
    public void saveMemory() {
    }

    public final UtlReferenceTracker referenceTracker() {
        return this.refTracker;
    }

    public String toString() {
        return "<messageEncodingType=" + this.messageEncodingType + "', message=" + this.message + ", vfid=" + this.vfid + ">";
    }
}

