/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma;

import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XString;
import com.neeve.pkt.PktBuffer;
import com.neeve.sma.SmaException;
import com.neeve.util.UtlBuffer;
import com.neeve.util.UtlListElement;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlReferenceTracker;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;

public final class MessageMetadata
extends UtlListElement
implements UtlPool.Item<MessageMetadata> {
    private static final int VERSION_POS = 0;
    private static final int V1_MESSAGE_ENCODING_TYPE_POS = 1;
    private static final int V1_MESSAGE_VIEW_FACTORY_POS = 2;
    private static final int V1_MESSAGE_SENDER_POS = 4;
    private static final int V1_MESSAGE_FLOW_POS = 8;
    private static final int V1_MESSAGE_SNO_POS = 12;
    private static final int V1_MESSAGE_CHANNEL_ID_POS = 20;
    private static final int V1_MESSAGE_CHANNEL_NAME_LEN_POS = 22;
    private static final int V1_MESSAGE_CHANNEL_NAME_POS = 24;
    private static final int V2_MESSAGE_ENCODING_TYPE_POS = 1;
    private static final int V2_MESSAGE_VIEW_FACTORY_POS = 2;
    private static final int V2_MESSAGE_VIEW_TYPE_POS = 4;
    private static final int V2_MESSAGE_SENDER_POS = 6;
    private static final int V2_MESSAGE_FLOW_POS = 10;
    private static final int V2_MESSAGE_SNO_POS = 14;
    private static final int V2_MESSAGE_CHANNEL_ID_POS = 22;
    private static final int V2_MESSAGE_CHANNEL_NAME_LEN_POS = 24;
    private static final int V2_MESSAGE_CHANNEL_NAME_POS = 26;
    public static final int FIXED_WIRE_LENGTH_V1 = 24;
    public static final int FIXED_WIRE_LENGTH_V2 = 26;
    public static final int FIXED_WIRE_LENGTH = 26;
    public static final byte V1 = 1;
    public static final byte V2 = 2;
    public static final byte VERSION = 2;
    private final PktBuffer buffer;
    private final XString channelName = XString.create((int)1, (boolean)true, (boolean)true);
    private UtlPool<MessageMetadata> pool;
    private AtomicInteger ownershipCount = new AtomicInteger(1);
    private final UtlReferenceTracker refTracker;

    MessageMetadata() {
        this.buffer = PktBuffer.create((IOElasticBuffer.Sizer)null, (int)26, (boolean)true);
        this.ownershipCount = new AtomicInteger(1);
        if (UtlReferenceTracker.enabled(((Object)((Object)this)).getClass())) {
            this.refTracker = new UtlReferenceTracker((Object)this);
            this.refTracker.onInit(1);
        } else {
            this.refTracker = null;
        }
    }

    public static final short getLatestVersion() {
        return 2;
    }

    private static final short getVersion(ByteBuffer buffer, int offset) {
        return (short)(0xFF & buffer.get(offset + 0));
    }

    private static final short getVersion(ByteBuffer buffer) {
        return MessageMetadata.getVersion(buffer, 0);
    }

    private static final int getFixedSerializedLength(short version) {
        int len;
        switch (version) {
            case 1: {
                len = 24;
                break;
            }
            case 2: {
                len = 26;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid version '" + version + "'");
            }
        }
        return len;
    }

    private final int getSerializedLength(short version) {
        return MessageMetadata.getFixedSerializedLength(version) + Math.max(this.buffer.getShort(version == 1 ? 22 : 24), 0);
    }

    public static final int getSerializedLength(short version, ByteBuffer buffer, int offset) {
        return MessageMetadata.getFixedSerializedLength(version) + Math.max(buffer.getShort(offset + (version == 1 ? 22 : 24)), 0);
    }

    public static final int getSerializedLength(short version, ByteBuffer buffer) {
        return MessageMetadata.getSerializedLength(version, buffer, 0);
    }

    public final short getVersion() {
        return (short)(0xFF & this.buffer.get(0));
    }

    public static final byte getMessageEncodingType(ByteBuffer buffer, int offset) {
        switch (MessageMetadata.getVersion(buffer, offset)) {
            case 1: {
                return buffer.get(offset + 1);
            }
            case 2: {
                return buffer.get(offset + 1);
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(buffer, offset) + "'");
    }

    public static final byte getMessageEncodingType(ByteBuffer buffer) {
        return MessageMetadata.getMessageEncodingType(buffer, 0);
    }

    public final byte getMessageEncodingType() {
        switch (this.getVersion()) {
            case 1: {
                return this.buffer.get(1);
            }
            case 2: {
                return this.buffer.get(1);
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + this.getVersion() + "'");
    }

    public static final short getMessageViewFactory(ByteBuffer buffer, int offset) {
        switch (MessageMetadata.getVersion(buffer, offset)) {
            case 1: {
                return buffer.getShort(offset + 2);
            }
            case 2: {
                return buffer.getShort(offset + 2);
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(buffer, offset) + "'");
    }

    public static final short getMessageViewFactory(ByteBuffer buffer) {
        return MessageMetadata.getMessageViewFactory(buffer, 0);
    }

    public final short getMessageViewFactory() {
        switch (this.getVersion()) {
            case 1: {
                return this.buffer.getShort(2);
            }
            case 2: {
                return this.buffer.getShort(2);
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + this.getVersion() + "'");
    }

    public static final short getMessageViewType(ByteBuffer buffer, int offset) {
        switch (MessageMetadata.getVersion(buffer, offset)) {
            case 1: {
                return 0;
            }
            case 2: {
                return buffer.getShort(offset + 4);
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(buffer, offset) + "'");
    }

    public static final short getMessageViewType(ByteBuffer buffer) {
        return MessageMetadata.getMessageViewType(buffer, 0);
    }

    public final short getMessageViewType() {
        switch (this.getVersion()) {
            case 1: {
                return 0;
            }
            case 2: {
                return this.buffer.getShort(4);
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + this.getVersion() + "'");
    }

    public static final int getMessageSender(ByteBuffer buffer, int offset) {
        switch (MessageMetadata.getVersion(buffer, offset)) {
            case 1: {
                return buffer.getInt(offset + 4);
            }
            case 2: {
                return buffer.getInt(offset + 6);
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(buffer, offset) + "'");
    }

    public static final int getMessageSender(ByteBuffer buffer) {
        return MessageMetadata.getMessageSender(buffer, 0);
    }

    public final int getMessageSender() {
        switch (this.getVersion()) {
            case 1: {
                return this.buffer.getInt(4);
            }
            case 2: {
                return this.buffer.getInt(6);
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + this.getVersion() + "'");
    }

    public static final int getMessageFlow(ByteBuffer buffer, int offset) {
        switch (MessageMetadata.getVersion(buffer, offset)) {
            case 1: {
                return buffer.getInt(offset + 8);
            }
            case 2: {
                return buffer.getInt(offset + 10);
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(buffer, offset) + "'");
    }

    public static final int getMessageFlow(ByteBuffer buffer) {
        return MessageMetadata.getMessageFlow(buffer, 0);
    }

    public final int getMessageFlow() {
        switch (this.getVersion()) {
            case 1: {
                return this.buffer.getInt(8);
            }
            case 2: {
                return this.buffer.getInt(10);
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + this.getVersion() + "'");
    }

    public static final long getMessageSno(ByteBuffer buffer, int offset) {
        switch (MessageMetadata.getVersion(buffer, offset)) {
            case 1: {
                return buffer.getLong(offset + 12);
            }
            case 2: {
                return buffer.getLong(offset + 14);
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(buffer, offset) + "'");
    }

    public static final long getMessageSno(ByteBuffer buffer) {
        return MessageMetadata.getMessageSno(buffer, 0);
    }

    public final long getMessageSno() {
        switch (this.getVersion()) {
            case 1: {
                return this.buffer.getLong(12);
            }
            case 2: {
                return this.buffer.getLong(14);
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + this.getVersion() + "'");
    }

    public static final short getMessageChannelId(ByteBuffer buffer, int offset) {
        switch (MessageMetadata.getVersion(buffer, offset)) {
            case 1: {
                return buffer.getShort(offset + 20);
            }
            case 2: {
                return buffer.getShort(offset + 22);
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(buffer, offset) + "'");
    }

    public static final short getMessageChannelId(ByteBuffer buffer) {
        return MessageMetadata.getMessageChannelId(buffer, 0);
    }

    public final short getMessageChannelId() {
        switch (this.getVersion()) {
            case 1: {
                return this.buffer.getShort(20);
            }
            case 2: {
                return this.buffer.getShort(22);
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + this.getVersion() + "'");
    }

    public static final String getMessageChannelName(ByteBuffer buffer, int offset) {
        int channelNamePos;
        int channelNameLenPos;
        switch (MessageMetadata.getVersion(buffer, offset)) {
            case 1: {
                channelNameLenPos = 22;
                channelNamePos = 24;
                break;
            }
            case 2: {
                channelNameLenPos = 24;
                channelNamePos = 26;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(buffer, offset) + "'");
            }
        }
        short len = buffer.getShort(offset + channelNameLenPos);
        if (len >= 0) {
            byte[] name = new byte[len];
            UtlBuffer.copy((ByteBuffer)buffer, (int)channelNamePos, (byte[])name, (int)0, (int)len);
            try {
                return new String(name, "UTF-8");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static final String getMessageChannelName(ByteBuffer buffer) {
        return MessageMetadata.getMessageChannelName(buffer, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void getMessageChannelNameToRaw(ByteBuffer buffer, int offset, XString target) {
        int channelNamePos;
        int channelNameLenPos;
        switch (MessageMetadata.getVersion(buffer, offset)) {
            case 1: {
                channelNameLenPos = offset + 22;
                channelNamePos = offset + 24;
                break;
            }
            case 2: {
                channelNameLenPos = offset + 24;
                channelNamePos = offset + 26;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(buffer, offset) + "'");
            }
        }
        short len = buffer.getShort(channelNameLenPos);
        int limit = buffer.limit();
        if (len < 0) {
            target.clear();
            return;
        }
        buffer.mark();
        try {
            buffer.position(channelNamePos);
            buffer.limit(channelNamePos + len);
            target.setValue(buffer);
        }
        finally {
            buffer.reset();
            buffer.limit(limit);
        }
    }

    public static final void getMessageChannelNameToRaw(ByteBuffer buffer, XString target) {
        MessageMetadata.getMessageChannelNameToRaw(buffer, 0, target);
    }

    public final XString getMessageChannelNameAsRaw() {
        if (!this.channelName.isInitialized()) {
            int channelNamePos;
            int channelNameLenPos;
            switch (this.getVersion()) {
                case 1: {
                    channelNameLenPos = 22;
                    channelNamePos = 24;
                    break;
                }
                case 2: {
                    channelNameLenPos = 24;
                    channelNamePos = 26;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown metadata version '" + this.getVersion() + "'");
                }
            }
            short len = this.buffer.getShort(channelNameLenPos);
            if (len >= 0) {
                this.channelName.setValue((IOElasticBuffer)this.buffer, channelNamePos, (int)len);
            }
        }
        return this.channelName.isInitialized() ? this.channelName : null;
    }

    public final String getMessageChannelName() {
        this.getMessageChannelNameAsRaw();
        return this.channelName.getValue();
    }

    public final PktBuffer getBuffer() {
        return this.buffer;
    }

    public static final int serializeV1(byte encodingType, short vfid, int sender, int flow, long sno, short channelId, XString channelName, PktBuffer buffer) {
        buffer.setLength(0);
        buffer.put(0, (byte)1);
        buffer.put(1, encodingType);
        buffer.putShort(2, vfid);
        buffer.putInt(4, sender);
        buffer.putInt(8, flow);
        buffer.putLong(12, sno);
        buffer.putShort(20, channelId);
        try {
            short serializedChannelNameLen = channelName == null || channelName.isNull() ? (short)-1 : (short)channelName.getSerializedLength();
            buffer.putShort(22, serializedChannelNameLen);
            if (channelName != null && !channelName.isNull()) {
                channelName.copyInto((IOElasticBuffer)buffer, 24);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return 24 + (channelName == null || channelName.isNull() ? 0 : channelName.getSerializedLength());
    }

    public final void serializeV1(byte encodingType, short vfid, int sender, int flow, long sno, short channelId, XString channelName) {
        MessageMetadata.serializeV1(encodingType, vfid, sender, flow, sno, channelId, channelName, this.buffer);
        if (channelName != null && !channelName.isNull()) {
            channelName.copyInto(this.channelName);
        }
    }

    public static final int serializeV2(byte encodingType, short vfid, short vid, int sender, int flow, long sno, short channelId, XString channelName, ByteBuffer buffer, int offset) {
        buffer.put(offset + 0, (byte)2);
        buffer.put(offset + 1, encodingType);
        buffer.putShort(offset + 2, vfid);
        buffer.putShort(offset + 4, vid);
        buffer.putInt(offset + 6, sender);
        buffer.putInt(offset + 10, flow);
        buffer.putLong(offset + 14, sno);
        buffer.putShort(offset + 22, channelId);
        try {
            short serializedChannelNameLen = channelName == null || channelName.isNull() ? (short)-1 : (short)channelName.getSerializedLength();
            buffer.putShort(offset + 24, serializedChannelNameLen);
            if (channelName != null && !channelName.isNull()) {
                channelName.copyInto(buffer, offset + 26);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return 26 + (channelName == null || channelName.isNull() ? 0 : channelName.getSerializedLength());
    }

    public static final int serializeV2(byte encodingType, short vfid, short vid, int sender, int flow, long sno, short channelId, XString channelName, PktBuffer buffer) {
        buffer.setLength(0);
        buffer.put(0, (byte)2);
        buffer.put(1, encodingType);
        buffer.putShort(2, vfid);
        buffer.putShort(4, vid);
        buffer.putInt(6, sender);
        buffer.putInt(10, flow);
        buffer.putLong(14, sno);
        buffer.putShort(22, channelId);
        try {
            short serializedChannelNameLen = channelName == null || channelName.isNull() ? (short)-1 : (short)channelName.getSerializedLength();
            buffer.putShort(24, serializedChannelNameLen);
            if (channelName != null && !channelName.isNull()) {
                channelName.copyInto((IOElasticBuffer)buffer, 26);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return 26 + (channelName == null || channelName.isNull() ? 0 : channelName.getSerializedLength());
    }

    public final void serializeV2(byte encodingType, short vfid, short vid, int sender, int flow, long sno, short channelId, XString channelName) {
        MessageMetadata.serializeV2(encodingType, vfid, vid, sender, flow, sno, channelId, channelName, this.buffer);
        if (channelName != null && !channelName.isNull()) {
            channelName.copyInto(this.channelName);
        }
    }

    public final int wrap(IOBuffer serializedMetadata) throws SmaException {
        int serializedMetadataLength = serializedMetadata.getLength();
        ByteBuffer serializedMetadataByteBuffer = serializedMetadata.getBufferUnsafe();
        if (serializedMetadataLength > 1) {
            short version = MessageMetadata.getVersion(serializedMetadataByteBuffer);
            if (version < 1 || version > 2) {
                throw new SmaException("Invalid message metadata wire format version [max supported=2 received=" + version);
            }
            int length = MessageMetadata.getSerializedLength(version, serializedMetadataByteBuffer);
            if (serializedMetadataLength >= length) {
                this.buffer.wrapIOBuffer(serializedMetadata, 0, length);
                return length;
            }
            throw new SmaException("supplied buffer too small to deserialize message metadata from");
        }
        throw new SmaException("supplied buffer too small to deserialize message metadata from");
    }

    public final int deserialize(ByteBuffer serializedMetadata) throws SmaException {
        IOBuffer ioBuffer = IOBuffer.create((int)serializedMetadata.remaining(), (boolean)serializedMetadata.isDirect());
        UtlBuffer.copy((ByteBuffer)serializedMetadata, (int)serializedMetadata.position(), (ByteBuffer)ioBuffer.getBufferUnsafe(), (int)0, (int)serializedMetadata.remaining());
        try {
            return this.wrap(ioBuffer);
        }
        catch (SmaException e) {
            ioBuffer.dispose();
            throw e;
        }
    }

    public final int getSerializedLength() {
        return this.getSerializedLength(this.getVersion());
    }

    public final MessageMetadata acquire() {
        int val = this.ownershipCount.incrementAndGet();
        if (UtlReferenceTracker.TYPE_TRACKING_ENABLED && this.refTracker != null) {
            this.refTracker.onAcquire(val);
        }
        if (val <= 1 && this.pool != null) {
            throw new IllegalStateException("attempt to acquire an already disposed MessageMetaData");
        }
        return this;
    }

    public final void dispose() {
        int val = this.ownershipCount.decrementAndGet();
        if (UtlReferenceTracker.TYPE_TRACKING_ENABLED && this.refTracker != null) {
            this.refTracker.onDispose(val);
        }
        if (val < 0 && this.pool != null) {
            throw new IllegalStateException("attempt to dispose an already disposed MessageMetaData");
        }
        if (val == 0 && this.pool != null) {
            this.pool.put((UtlPool.Item)this);
        }
    }

    public final MessageMetadata init() {
        this.buffer.reset();
        this.channelName.clear();
        this.ownershipCount.set(1);
        if (UtlReferenceTracker.TYPE_TRACKING_ENABLED && this.refTracker != null) {
            this.refTracker.onInit(1);
        }
        return this;
    }

    public final MessageMetadata setPool(UtlPool<MessageMetadata> pool) {
        this.pool = pool;
        return this;
    }

    public final UtlPool<MessageMetadata> getPool() {
        return this.pool;
    }

    public final String toString() {
        String str = "";
        str = str + "[";
        try {
            str = str + this.getVersion() + ",";
            str = str + this.getMessageEncodingType() + ",";
            str = str + this.getMessageViewFactory() + ",";
            str = str + this.getMessageViewType() + ",";
            str = str + this.getMessageSender() + ",";
            str = str + this.getMessageFlow() + ",";
            str = str + this.getMessageSno() + ",";
            str = str + this.getMessageChannelId() + ",";
            str = str + this.getMessageChannelName();
        }
        catch (Throwable thrown) {
            str = str + " INVALID (" + thrown.getMessage() + ")";
        }
        str = str + "]";
        return str;
    }
}

