/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.EAepException;
import com.neeve.aep.test.unit.AepEngineSplitBrainTestApp;
import com.neeve.aep.test.unit.AepEngineTest;
import com.neeve.aep.test.unit.AepEngineTestMessage;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.ods.IStoreBinding;
import com.neeve.rog.IRogMessage;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.impl.loopback.LoopbackBus;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class AepEngineSplitBrainTest
extends AepEngineTest {
    @Test
    public void testSplitBrainByDiscoveryFailtoDiscover() throws Exception {
        LoopbackBus.getInstance((String)"discovery").discardMessages();
        AepEngineSplitBrainTestApp sender = new AepEngineSplitBrainTestApp(null);
        String receiverName = "engine-" + System.currentTimeMillis() + "-" + AepEngineTest.engineCounter++;
        AepEngineSplitBrainTestApp receiver1 = new AepEngineSplitBrainTestApp(receiverName);
        AepEngineSplitBrainTestApp receiver2 = new AepEngineSplitBrainTestApp(receiverName);
        this.startSenderStandaloneReceiverRedundant(sender, null, receiverName, receiver1, null, receiver2, null, 15, 15, 15, 0, AepEngine.HAPolicy.EventSourcing, false, false, 0);
        try {
            ((AepEngine)((Object)this.engines.get(2))).waitForMessagingToStart();
            Assert.fail((String)"messaging successfully started on the backup after split brain!");
        }
        catch (EAepException e) {
            Assert.assertTrue((boolean)receiver2.waitForMessagingStartFailEvent());
            Assert.assertTrue((boolean)receiver2.waitForEngineStoppedEvent());
            Assert.assertEquals((long)0L, (long)receiver1.memberUpEventCount);
            Assert.assertEquals((long)0L, (long)receiver1.memberDownEventCount);
            Assert.assertEquals((Object)IStoreBinding.Role.Primary, (Object)((AepEngine)((Object)this.engines.get(1))).getStore().getRole());
            Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)((AepEngine)((Object)this.engines.get(1))).getState()));
            Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Started), (Object)((Object)((AepEngine)((Object)this.engines.get(1))).getMessagingState()));
        }
    }

    @Test
    public void testSplitBrainByDiscoveryFailWhileQuiescent() throws Exception {
        AepEngineSplitBrainTestApp sender = new AepEngineSplitBrainTestApp(null);
        String receiverName = "engine-" + System.currentTimeMillis() + "-" + AepEngineTest.engineCounter++;
        AepEngineSplitBrainTestApp receiver1 = new AepEngineSplitBrainTestApp(receiverName);
        AepEngineSplitBrainTestApp receiver2 = new AepEngineSplitBrainTestApp(receiverName);
        this.startSenderStandaloneReceiverRedundant(sender, null, receiverName, receiver1, null, receiver2, null, 15, 15, 15, 0, AepEngine.HAPolicy.EventSourcing, true, false, 0);
        LoopbackBus.getInstance((String)"discovery").discardMessages();
        try {
            ((AepEngine)((Object)this.engines.get(2))).waitForMessagingToStart();
            Assert.fail((String)"messaging successfully started on the backup after split brain!");
        }
        catch (EAepException e) {
            Assert.assertTrue((boolean)receiver2.waitForMessagingStartFailEvent());
            Assert.assertTrue((boolean)receiver2.waitForEngineStoppedEvent());
            Assert.assertEquals((long)1L, (long)receiver1.memberUpEventCount);
            Assert.assertEquals((long)1L, (long)receiver1.memberDownEventCount);
            Assert.assertEquals((Object)IStoreBinding.Role.Primary, (Object)((AepEngine)((Object)this.engines.get(1))).getStore().getRole());
            Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)((AepEngine)((Object)this.engines.get(1))).getState()));
            Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Started), (Object)((Object)((AepEngine)((Object)this.engines.get(1))).getMessagingState()));
        }
    }

    @Test
    public void testSplitBrainByDiscoveryFailWhileLive() throws Exception {
        AepEngineSplitBrainTestApp sender = new AepEngineSplitBrainTestApp(null);
        String receiverName = "engine-" + System.currentTimeMillis() + "-" + AepEngineTest.engineCounter++;
        AepEngineSplitBrainTestApp receiver1 = new AepEngineSplitBrainTestApp(receiverName, sender);
        AepEngineSplitBrainTestApp receiver2 = new AepEngineSplitBrainTestApp(receiverName);
        this.startSenderStandaloneReceiverRedundant(sender, null, receiverName, receiver1, null, receiver2, null, 15, 15, 15, 0, AepEngine.HAPolicy.EventSourcing, true, false, 0);
        SenderThread senderThread = new SenderThread((AepEngine)((Object)this.engines.get(0)), sender.channel, sender);
        senderThread.start();
        Thread.sleep(1000L);
        LoopbackBus.getInstance((String)"discovery").discardMessages();
        try {
            ((AepEngine)((Object)this.engines.get(2))).waitForMessagingToStart();
            Assert.fail((String)"messaging successfully started on the backup after split brain!");
        }
        catch (EAepException e) {
            senderThread.shutdown();
            Assert.assertNull((Object)senderThread.e);
            Assert.assertTrue((boolean)sender.waitForExpectedMessageStability(senderThread.messageCount));
            Assert.assertTrue((boolean)receiver2.waitForMessagingStartFailEvent());
            Assert.assertTrue((boolean)receiver2.waitForEngineStoppedEvent());
            Assert.assertTrue((boolean)receiver1.waitForExpectedMessageReceipt(senderThread.messageCount));
            Assert.assertEquals((long)1L, (long)receiver1.memberUpEventCount);
            Assert.assertEquals((long)1L, (long)receiver1.memberDownEventCount);
            Assert.assertEquals((Object)IStoreBinding.Role.Primary, (Object)((AepEngine)((Object)this.engines.get(1))).getStore().getRole());
            Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)((AepEngine)((Object)this.engines.get(1))).getState()));
            Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Started), (Object)((Object)((AepEngine)((Object)this.engines.get(1))).getMessagingState()));
            Assert.assertEquals((long)receiver1.messageCount, (long)senderThread.messageCount);
        }
    }

    @Test
    public void testSplitBrainByDiscoveryDualPrimaryRejoinWhileQuiescentFailOnMultiplePrimaries() throws Exception {
        LoopbackBus.getInstance((String)"discovery").discardMessages();
        AepEngineSplitBrainTestApp sender = new AepEngineSplitBrainTestApp(null);
        AepEngine engine1 = this.createEngine("engine1", null, null, null, null, null, false, false, false, false, null, 0, 0, sender, null, null, 0, false, false, null, null, null, false, false);
        engine1.start();
        engine1.waitForMessagingToStart();
        Assert.assertEquals((Object)((Object)engine1.getState()), (Object)((Object)AepEngine.State.Started));
        Assert.assertEquals((Object)((Object)engine1.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Started));
        String receiverName = "engine-" + System.currentTimeMillis() + "-" + AepEngineTest.engineCounter++;
        AepEngineSplitBrainTestApp receiver1 = new AepEngineSplitBrainTestApp(receiverName);
        AepEngine engine2 = this.createEngine(receiverName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, false, false, false, null, 0, 0, receiver1, null, null, 0, false, false, null, null, null, true, false);
        engine2.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine2.start();
        engine2.waitForMessagingToStart();
        Assert.assertEquals((Object)((Object)engine2.getState()), (Object)((Object)AepEngine.State.Started));
        Assert.assertEquals((Object)((Object)engine2.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Started));
        AepEngineSplitBrainTestApp receiver2 = new AepEngineSplitBrainTestApp(receiverName);
        AepEngine engine3 = this.createEngine(receiverName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, false, false, false, null, 0, 0, receiver2, null, null, 0, false, false, null, null, null, true, false);
        engine3.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine3.start();
        LoopbackBus.getInstance((String)"discovery").clearMessageDiscard();
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)receiver1.waitForEngineStoppedEvent());
        Assert.assertTrue((boolean)receiver2.waitForEngineStoppedEvent());
    }

    @Ignore
    @Test
    public void testSplitBrainByDiscoveryDualPrimaryRejoinWhileQuiescentNoFailOnMultiplePrimaries() throws Exception {
        LoopbackBus.getInstance((String)"discovery").discardMessages();
        AepEngineSplitBrainTestApp sender = new AepEngineSplitBrainTestApp(null);
        AepEngine engine1 = this.createEngine("engine1", null, null, null, null, null, false, false, false, false, null, 0, 0, sender, null, null, 0, false, false, null, null, null, false, false);
        engine1.start();
        engine1.waitForMessagingToStart();
        Assert.assertEquals((Object)((Object)engine1.getState()), (Object)((Object)AepEngine.State.Started));
        Assert.assertEquals((Object)((Object)engine1.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Started));
        String receiverName = "engine-" + System.currentTimeMillis() + "-" + AepEngineTest.engineCounter++;
        AepEngineSplitBrainTestApp receiver1 = new AepEngineSplitBrainTestApp(receiverName);
        AepEngine engine2 = this.createEngine(receiverName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, false, false, false, null, 0, 0, receiver1, null, null, 0, false, false, null, null, null, false, false);
        engine2.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine2.start();
        engine2.waitForMessagingToStart();
        Assert.assertEquals((Object)((Object)engine2.getState()), (Object)((Object)AepEngine.State.Started));
        Assert.assertEquals((Object)((Object)engine2.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Started));
        AepEngineSplitBrainTestApp receiver2 = new AepEngineSplitBrainTestApp(receiverName);
        AepEngine engine3 = this.createEngine(receiverName, AepEngine.HAPolicy.EventSourcing, null, null, null, null, true, false, false, false, null, 0, 0, receiver2, null, null, 0, false, false, null, null, null, false, false);
        engine3.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine3.start();
        LoopbackBus.getInstance((String)"discovery").clearMessageDiscard();
        try {
            Thread.sleep(15000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((Object)((Object)engine2.getState()), (Object)((Object)AepEngine.State.Started));
        Assert.assertEquals((Object)((Object)engine2.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Started));
        Assert.assertEquals((Object)engine2.getStore().getRole(), (Object)IStoreBinding.Role.Primary);
        Assert.assertEquals((Object)((Object)engine3.getState()), (Object)((Object)AepEngine.State.Started));
        Assert.assertEquals((Object)((Object)engine3.getMessagingState()), (Object)((Object)AepEngine.MessagingState.Started));
        Assert.assertEquals((Object)engine3.getStore().getRole(), (Object)IStoreBinding.Role.Primary);
    }

    private final class SenderThread
    extends Thread {
        final AepEngineSplitBrainTestApp sender;
        private final AepEngine engine;
        private final MessageChannel channel;
        Throwable e;
        int messageCount;
        volatile boolean done;

        SenderThread(AepEngine engine, MessageChannel channel, AepEngineSplitBrainTestApp sender) {
            this.engine = engine;
            this.channel = channel;
            this.sender = sender;
        }

        private final void send() {
            this.sender.onSend();
            if (!this.done) {
                IRogMessage message = new AepEngineTestMessage(AepEngineTestObject.EncodingType.Proto).getMessage();
                this.engine.sendMessage(this.channel, message);
                ++this.messageCount;
            }
        }

        final void shutdown() {
            this.done = true;
            this.sender.sendDone();
            while (true) {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        @Override
        public final void run() {
            long last = System.currentTimeMillis();
            while (!this.done) {
                try {
                    this.send();
                    if (System.currentTimeMillis() - last < 1000L) continue;
                    System.out.println("Sent..." + this.messageCount);
                    last = System.currentTimeMillis();
                }
                catch (Throwable e) {
                    this.e = e;
                    this.done = true;
                }
            }
        }
    }
}

