/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.AepEngineDescriptor;
import com.neeve.aep.test.unit.AepEngineSendFailTestApp;
import com.neeve.aep.test.unit.AepEngineTest;
import com.neeve.aep.test.unit.AepEngineTestMessage;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.ci.XRuntime;
import java.io.File;
import org.junit.Assert;
import org.junit.Test;

public class AepEngineSendFailTest
extends AepEngineTest {
    @Test(expected=RuntimeException.class)
    public void testStandaloneSendFail() throws Exception {
        AepEngineSendFailTestApp app = new AepEngineSendFailTestApp();
        this.startSenderStandaloneReceiverStandalone(app, null, null, null, null, 15, 15, 15, 0, AepEngine.HAPolicy.EventSourcing, false, false);
        for (int i = 0; i < 10; ++i) {
            ((AepEngine)((Object)this.engines.get(0))).sendMessage(app.channel4, new AepEngineTestMessage(AepEngineTestObject.EncodingType.Proto).getMessage());
        }
        this.messagingController.failNextSendWithException("aeptest1", ((AepEngine)((Object)this.engines.get(0))).getDescriptor().getName());
        ((AepEngine)((Object)this.engines.get(0))).sendMessage(app.channel4, new AepEngineTestMessage(AepEngineTestObject.EncodingType.Proto).getMessage());
    }

    @Test
    public void testStandaloneSendStabilityFail() throws Exception {
        AepEngineSendFailTestApp app = new AepEngineSendFailTestApp();
        this.startSenderStandaloneReceiverStandalone(app, null, null, null, null, 15, 15, 15, 0, AepEngine.HAPolicy.EventSourcing, false, false);
        for (int i = 0; i < 10; ++i) {
            ((AepEngine)((Object)this.engines.get(0))).sendMessage(app.channel4, new AepEngineTestMessage(AepEngineTestObject.EncodingType.Proto).getMessage());
        }
        this.messagingController.failNextSend("aeptest1", ((AepEngine)((Object)this.engines.get(0))).getDescriptor().getName());
        ((AepEngine)((Object)this.engines.get(0))).sendMessage(app.channel4, new AepEngineTestMessage(AepEngineTestObject.EncodingType.Proto).getMessage());
        Assert.assertTrue((boolean)app.waitForStabilityNotification(11));
        Assert.assertEquals((long)app.stabilitySuccessCount, (long)10L);
        Assert.assertEquals((long)app.stabilityFailCount, (long)1L);
    }

    @Test
    public void testClusteredSendFail_SendFailurePolicyTreatAsStabilityFailure() throws Exception {
        AepEngine engine3;
        AepEngine engine2;
        AepEngine engine1;
        AepEngineSendFailTestApp app11 = new AepEngineSendFailTestApp();
        String app1Name = "engine-" + System.currentTimeMillis();
        app11.engine = engine1 = this.createEngine(app1Name, AepEngine.HAPolicy.EventSourcing, null, null, null, AepEngine.OutboundMessageLoggingPolicy.UseDedicated, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 31, 16, app11, null, null, 0, false, false, null, null, AepEngine.MessageSendExceptionHandlingPolicy.TreatAsStabilityFailure, false, false);
        engine1.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine1.start();
        engine1.waitForMessagingToStart();
        AepEngineSendFailTestApp app12 = new AepEngineSendFailTestApp();
        app12.engine = engine2 = this.createEngine(app1Name, AepEngine.HAPolicy.EventSourcing, null, null, null, AepEngine.OutboundMessageLoggingPolicy.UseDedicated, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m2", 31, 16, app12, null, null, 0, false, false, null, null, AepEngine.MessageSendExceptionHandlingPolicy.TreatAsStabilityFailure, false, false);
        engine2.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine2.start();
        AepEngineSendFailTestApp app2 = new AepEngineSendFailTestApp();
        String app2Name = "engine-" + System.currentTimeMillis() + "-100";
        app2.engine = engine3 = this.createEngine(app2Name, AepEngine.HAPolicy.EventSourcing, null, null, null, null, false, false, false, false, null, 31, 0, app2, null, null, 0, false, false, null, null, null, false, false);
        engine3.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine3.start();
        engine3.waitForMessagingToStart();
        this.messagingController.failNextSendWithException("aeptest1", engine1.getDescriptor().getName());
        AepEngineTestMessage message = new AepEngineTestMessage(AepEngineTestObject.EncodingType.Proto);
        message.getMessage().setMessageBus("aeptest1");
        message.getMessage().setMessageChannel("channel5");
        engine3.sendMessage(app2.channel5, message.getMessage());
        app11.waitForEngineStopped();
        app12.waitForEngineStopped();
    }

    @Test
    public void testClusteredSendFail_SendFailurePolicyLogExceptionAndContinue() throws Exception {
        AepEngine engine3;
        AepEngine engine2;
        AepEngine engine1;
        AepEngineSendFailTestApp app11 = new AepEngineSendFailTestApp();
        String app1Name = "engine-" + System.currentTimeMillis();
        app11.engine = engine1 = this.createEngine(app1Name, AepEngine.HAPolicy.EventSourcing, null, null, null, AepEngine.OutboundMessageLoggingPolicy.UseDedicated, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 31, 16, app11, null, null, 0, false, false, null, null, AepEngine.MessageSendExceptionHandlingPolicy.LogExceptionAndContinue, false, false);
        engine1.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine1.start();
        engine1.waitForMessagingToStart();
        AepEngineSendFailTestApp app12 = new AepEngineSendFailTestApp();
        app12.engine = engine2 = this.createEngine(app1Name, AepEngine.HAPolicy.EventSourcing, null, null, null, AepEngine.OutboundMessageLoggingPolicy.UseDedicated, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m2", 31, 16, app12, null, null, 0, false, false, null, null, AepEngine.MessageSendExceptionHandlingPolicy.LogExceptionAndContinue, false, false);
        engine2.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine2.start();
        AepEngineSendFailTestApp app2 = new AepEngineSendFailTestApp();
        String app2Name = "engine-" + System.currentTimeMillis() + "-100";
        app2.engine = engine3 = this.createEngine(app2Name, AepEngine.HAPolicy.EventSourcing, null, null, null, null, false, false, false, false, null, 31, 0, app2, null, null, 0, false, false, null, null, null, false, false);
        engine3.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine3.start();
        engine3.waitForMessagingToStart();
        this.messagingController.failNextSendWithException("aeptest1", engine1.getDescriptor().getName());
        AepEngineTestMessage message = new AepEngineTestMessage(AepEngineTestObject.EncodingType.Proto);
        message.getMessage().setMessageBus("aeptest1");
        message.getMessage().setMessageChannel("channel5");
        engine3.sendMessage(app2.channel5, message.getMessage());
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine1.getState()));
        Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine2.getState()));
    }

    @Test
    public void testClusteredSendStabilityFail_SendStabilityFailurePolicyStopEngine() throws Exception {
        AepEngine engine3;
        AepEngine engine2;
        AepEngine engine1;
        AepEngineSendFailTestApp app11 = new AepEngineSendFailTestApp();
        String app1Name = "engine-" + System.currentTimeMillis();
        app11.engine = engine1 = this.createEngine(app1Name, AepEngine.HAPolicy.EventSourcing, null, null, null, AepEngine.OutboundMessageLoggingPolicy.UseDedicated, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 31, 16, app11, null, null, 0, false, false, null, null, null, false, false);
        engine1.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine1.start();
        engine1.waitForMessagingToStart();
        AepEngineSendFailTestApp app12 = new AepEngineSendFailTestApp();
        app12.engine = engine2 = this.createEngine(app1Name, AepEngine.HAPolicy.EventSourcing, null, null, null, AepEngine.OutboundMessageLoggingPolicy.UseDedicated, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m2", 31, 16, app12, null, null, 0, false, false, null, null, null, false, false);
        engine2.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine2.start();
        AepEngineSendFailTestApp app2 = new AepEngineSendFailTestApp();
        String app2Name = "engine-" + System.currentTimeMillis() + "-100";
        app2.engine = engine3 = this.createEngine(app2Name, AepEngine.HAPolicy.EventSourcing, null, null, null, null, false, false, false, false, null, 31, 0, app2, null, null, 0, false, false, null, null, null, false, false);
        engine3.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine3.start();
        engine3.waitForMessagingToStart();
        this.messagingController.failNextSend("aeptest1", engine1.getDescriptor().getName());
        AepEngineTestMessage message = new AepEngineTestMessage(AepEngineTestObject.EncodingType.Proto);
        message.getMessage().setMessageBus("aeptest1");
        message.getMessage().setMessageChannel("channel5");
        engine3.sendMessage(app2.channel5, message.getMessage());
        app11.waitForEngineStopped();
    }

    @Test
    public void testClusteredSendStabilityFail_SendStabilityFailurePolicyLogExceptionAndContinue() throws Exception {
        AepEngine engine3;
        AepEngine engine2;
        AepEngine engine1;
        AepEngineSendFailTestApp app11 = new AepEngineSendFailTestApp();
        String app1Name = "engine-" + System.currentTimeMillis();
        app11.engine = engine1 = this.createEngine(app1Name, AepEngine.HAPolicy.EventSourcing, null, null, null, AepEngine.OutboundMessageLoggingPolicy.UseDedicated, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m1", 31, 16, app11, null, null, 0, false, false, null, null, null, false, false, new AepEngineTest.BaseEngineCusomizer(){

            @Override
            public void customizeEngine(AepEngineDescriptor descriptor) {
                descriptor.setMessageSendStabilityFailureHandlingPolicy(AepEngine.MessageSendStabilityFailureHandlingPolicy.LogExceptionAndContinue);
            }
        });
        engine1.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine1.start();
        engine1.waitForMessagingToStart();
        AepEngineSendFailTestApp app12 = new AepEngineSendFailTestApp();
        app12.engine = engine2 = this.createEngine(app1Name, AepEngine.HAPolicy.EventSourcing, null, null, null, AepEngine.OutboundMessageLoggingPolicy.UseDedicated, true, true, false, false, XRuntime.getDataDirectory() + File.separator + "m2", 31, 16, app12, null, null, 0, false, false, null, null, null, false, false);
        engine2.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine2.start();
        AepEngineSendFailTestApp app2 = new AepEngineSendFailTestApp();
        String app2Name = "engine-" + System.currentTimeMillis() + "-100";
        app2.engine = engine3 = this.createEngine(app2Name, AepEngine.HAPolicy.EventSourcing, null, null, null, null, false, false, false, false, null, 31, 0, app2, null, null, 0, false, false, null, null, null, false, false);
        engine3.registerFactory(AepEngineTestMessage.getFactory(AepEngineTestObject.EncodingType.Proto));
        engine3.start();
        engine3.waitForMessagingToStart();
        this.messagingController.failNextSend("aeptest1", engine1.getDescriptor().getName());
        AepEngineTestMessage message = new AepEngineTestMessage(AepEngineTestObject.EncodingType.Proto);
        message.getMessage().setMessageBus("aeptest1");
        message.getMessage().setMessageChannel("channel5");
        engine3.sendMessage(app2.channel5, message.getMessage());
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine1.getState()));
        Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine2.getState()));
    }
}

