/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.EAepException;
import com.neeve.aep.test.unit.AepEngineMessagingStartFailTestApp;
import com.neeve.aep.test.unit.AepEngineTest;
import com.neeve.ci.XRuntime;
import java.io.File;
import org.junit.Assert;
import org.junit.Test;

public class AepEngineMessagingStartFailTest
extends AepEngineTest {
    private int engineCounter = 0;

    private final String createEnginesForRedundantTest(Object instance1, Object instance2, AepEngine.MessagingStartFailPolicy messagingStartFailPolicy, int channelMask) throws Exception {
        String engineName = "engine-" + System.currentTimeMillis() + "-" + this.engineCounter++;
        this.createEngine(engineName, null, messagingStartFailPolicy, null, null, null, true, false, false, false, XRuntime.getDataDirectory() + File.separator + "m1", channelMask, channelMask, instance1, null, null, 0, false, false, null, null, null, false, false);
        this.createEngine(engineName, null, messagingStartFailPolicy, null, null, null, true, false, false, false, XRuntime.getDataDirectory() + File.separator + "m2", channelMask, channelMask, instance2, null, null, 0, false, false, null, null, null, false, false);
        return engineName;
    }

    @Test
    public void testStandaloneNeverFailMessagingStartFailPolicyOneBindingFail() throws Exception {
        AepEngineMessagingStartFailTestApp app = new AepEngineMessagingStartFailTestApp();
        AepEngine engine = this.createEngine("engine1", null, AepEngine.MessagingStartFailPolicy.NeverFail, null, null, null, false, false, false, false, null, 1, 1, app, null, null, 0, false, false, null, null, null, false, false);
        this.messagingController.failAllConnects("aeptest1", "engine1", false);
        engine.start();
        Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine.getState()));
        engine.waitForMessagingToStart();
        Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine.getState()));
        Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Started), (Object)((Object)engine.getMessagingState()));
        Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest1", "engine1"));
        Assert.assertFalse((boolean)this.messagingController.agentHasSubscriptions("aeptest1", "engine1"));
        Assert.assertEquals((long)1L, (long)app.bindingCreatedEventCount);
        Assert.assertEquals((long)1L, (long)app.bindingOpeningEventCount);
        Assert.assertEquals((long)1L, (long)app.bindingOpenFailedEventCount);
        Assert.assertEquals((long)0L, (long)app.bindingOpenedEventCount);
        Assert.assertEquals((long)0L, (long)app.channelUpEventCount);
        Assert.assertEquals((long)0L, (long)app.bindingUpEventCount);
        Assert.assertEquals((long)0L, (long)app.channelDownEventCount);
        Assert.assertEquals((long)0L, (long)app.bindingDownEventCount);
        Assert.assertEquals((long)0L, (long)app.bindingDestroyedEventCount);
        Assert.assertEquals((long)1L, (long)app.messagingStartSuccessCount);
        Assert.assertEquals((long)0L, (long)app.messagingStartFailCount);
        Assert.assertEquals((long)1L, (long)app.engineActiveEventCount);
    }

    @Test(expected=EAepException.class)
    public void testStandaloneNeverFailMessagingStartFailPolicyOneBindingFailPermanent() throws Exception {
        AepEngineMessagingStartFailTestApp app = new AepEngineMessagingStartFailTestApp();
        AepEngine engine = this.createEngine("engine1", null, AepEngine.MessagingStartFailPolicy.NeverFail, null, null, null, false, false, false, false, null, 1, 1, app, null, null, 0, false, false, null, null, null, false, false);
        this.messagingController.failAllConnects("aeptest1", "engine1", true);
        try {
            engine.start();
            Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine.getState()));
        }
        catch (EAepException e) {
            Assert.fail((String)"start() threw exception when it should not have");
        }
        try {
            engine.waitForMessagingToStart();
        }
        catch (EAepException e) {
            Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Stopped), (Object)((Object)engine.getMessagingState()));
            Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest1", "engine1"));
            Assert.assertFalse((boolean)this.messagingController.agentHasSubscriptions("aeptest1", "engine1"));
            Assert.assertEquals((long)1L, (long)app.bindingCreatedEventCount);
            Assert.assertEquals((long)1L, (long)app.bindingOpeningEventCount);
            Assert.assertEquals((long)1L, (long)app.bindingOpenFailedEventCount);
            Assert.assertEquals((long)0L, (long)app.bindingOpenedEventCount);
            Assert.assertEquals((long)0L, (long)app.channelUpEventCount);
            Assert.assertEquals((long)0L, (long)app.bindingUpEventCount);
            Assert.assertEquals((long)0L, (long)app.channelDownEventCount);
            Assert.assertEquals((long)0L, (long)app.bindingDownEventCount);
            Assert.assertEquals((long)0L, (long)app.messagingStartSuccessCount);
            Assert.assertEquals((long)1L, (long)app.messagingStartFailCount);
            Assert.assertEquals((long)0L, (long)app.engineActiveEventCount);
            Assert.assertTrue((boolean)app.waitForEngineToStop());
            Assert.assertEquals((Object)((Object)AepEngine.State.Stopped), (Object)((Object)engine.getState()));
            Assert.assertEquals((long)1L, (long)app.bindingDestroyedEventCount);
            throw e;
        }
    }

    @Test(expected=EAepException.class)
    public void testRedundantNeverFailMessagingStartFailPolicyOneBindingFailPermanent() throws Exception {
        AepEngineMessagingStartFailTestApp instance1 = new AepEngineMessagingStartFailTestApp();
        AepEngineMessagingStartFailTestApp instance2 = new AepEngineMessagingStartFailTestApp();
        String engineName = this.createEnginesForRedundantTest(instance1, instance2, AepEngine.MessagingStartFailPolicy.NeverFail, 1);
        AepEngine engine1 = (AepEngine)((Object)this.engines.get(0));
        AepEngine engine2 = (AepEngine)((Object)this.engines.get(1));
        this.messagingController.failNextConnect("aeptest1", engineName, true);
        EngineStarter starter = new EngineStarter(engine2);
        starter.start();
        try {
            engine1.start();
            Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine1.getState()));
        }
        catch (EAepException e) {
            starter.join();
            Assert.fail((String)"start() threw exception when it should not have");
        }
        try {
            engine1.waitForMessagingToStart();
        }
        catch (EAepException e) {
            Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Stopped), (Object)((Object)engine1.getMessagingState()));
            Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest1", engineName));
            Assert.assertFalse((boolean)this.messagingController.agentHasSubscriptions("aeptest1", engineName));
            Assert.assertEquals((long)0L, (long)instance1.bindingUpEventCount);
            Assert.assertEquals((long)0L, (long)instance1.bindingDownEventCount);
            Assert.assertEquals((long)0L, (long)instance1.channelUpEventCount);
            Assert.assertEquals((long)0L, (long)instance1.channelDownEventCount);
            Assert.assertEquals((long)0L, (long)instance1.messagingStartSuccessCount);
            Assert.assertEquals((long)1L, (long)instance1.messagingStartFailCount);
            Assert.assertTrue((boolean)instance1.waitForEngineToStop());
            Assert.assertEquals((Object)((Object)AepEngine.State.Stopped), (Object)((Object)engine1.getState()));
            throw e;
        }
        finally {
            starter.join();
            if (starter.e != null) {
                Assert.fail((String)("backup start failed [" + starter.e.toString() + "]"));
            }
            try {
                engine2.waitForMessagingToStart();
                Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine2.getState()));
                Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Started), (Object)((Object)engine2.getMessagingState()));
                Assert.assertTrue((boolean)this.messagingController.isAgentConnected("aeptest1", engineName));
                Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest1", engineName));
                Assert.assertEquals((long)1L, (long)instance2.bindingUpEventCount);
                Assert.assertEquals((long)0L, (long)instance2.bindingDownEventCount);
                Assert.assertEquals((long)1L, (long)instance2.channelUpEventCount);
                Assert.assertEquals((long)0L, (long)instance2.channelDownEventCount);
                Assert.assertEquals((long)1L, (long)instance2.messagingStartSuccessCount);
                Assert.assertEquals((long)0L, (long)instance2.messagingStartFailCount);
            }
            catch (EAepException e) {
                e.printStackTrace();
                Assert.fail((String)"waitForMessagingToStart() threw exception when it should not have");
            }
        }
    }

    @Test
    public void testStandaloneNeverFailMessagingStartFailPolicyTwoBindingsFirstFail() throws Exception {
        AepEngineMessagingStartFailTestApp app = new AepEngineMessagingStartFailTestApp();
        AepEngine engine = this.createEngine("engine1", null, AepEngine.MessagingStartFailPolicy.NeverFail, null, null, null, false, false, false, false, null, 67, 67, app, null, null, 0, false, false, null, null, null, false, false);
        this.messagingController.failAllConnects("aeptest1", "engine1", false);
        engine.start();
        Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine.getState()));
        engine.waitForMessagingToStart();
        Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine.getState()));
        Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Started), (Object)((Object)engine.getMessagingState()));
        Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest1", "engine1"));
        Assert.assertFalse((boolean)this.messagingController.agentHasSubscriptions("aeptest1", "engine1"));
        Assert.assertTrue((boolean)this.messagingController.isAgentConnected("aeptest2", "engine1"));
        Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest2", "engine1"));
        Assert.assertEquals((long)1L, (long)app.bindingUpEventCount);
        Assert.assertEquals((long)0L, (long)app.bindingDownEventCount);
        Assert.assertEquals((long)1L, (long)app.channelUpEventCount);
        Assert.assertEquals((long)0L, (long)app.channelDownEventCount);
        Assert.assertEquals((long)1L, (long)app.messagingStartSuccessCount);
        Assert.assertEquals((long)0L, (long)app.messagingStartFailCount);
    }

    @Test
    public void testStandaloneNeverFailMessagingStartFailPolicyTwoBindingsFirstFailPermanent() throws Exception {
        AepEngineMessagingStartFailTestApp app = new AepEngineMessagingStartFailTestApp();
        AepEngine engine = this.createEngine("engine1", null, AepEngine.MessagingStartFailPolicy.NeverFail, null, null, null, false, false, false, false, null, 67, 67, app, null, null, 0, false, false, null, null, null, false, false);
        this.messagingController.failAllConnects("aeptest1", "engine1", true);
        engine.start();
        Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine.getState()));
        engine.waitForMessagingToStart();
        Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine.getState()));
        Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Started), (Object)((Object)engine.getMessagingState()));
        Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest1", "engine1"));
        Assert.assertFalse((boolean)this.messagingController.agentHasSubscriptions("aeptest1", "engine1"));
        Assert.assertTrue((boolean)this.messagingController.isAgentConnected("aeptest2", "engine1"));
        Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest2", "engine1"));
        Assert.assertEquals((long)1L, (long)app.bindingUpEventCount);
        Assert.assertEquals((long)0L, (long)app.bindingDownEventCount);
        Assert.assertEquals((long)1L, (long)app.channelUpEventCount);
        Assert.assertEquals((long)0L, (long)app.channelDownEventCount);
        Assert.assertEquals((long)1L, (long)app.messagingStartSuccessCount);
        Assert.assertEquals((long)0L, (long)app.messagingStartFailCount);
    }

    @Test
    public void testStandaloneNeverFailMessagingStartFailPolicyTwoBindingsSecondFail() throws Exception {
        AepEngineMessagingStartFailTestApp app = new AepEngineMessagingStartFailTestApp();
        AepEngine engine = this.createEngine("engine1", null, AepEngine.MessagingStartFailPolicy.NeverFail, null, null, null, false, false, false, false, null, 67, 67, app, null, null, 0, false, false, null, null, null, false, false);
        this.messagingController.failAllConnects("aeptest2", "engine1", false);
        engine.start();
        Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine.getState()));
        engine.waitForMessagingToStart();
        Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine.getState()));
        Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Started), (Object)((Object)engine.getMessagingState()));
        Assert.assertTrue((boolean)this.messagingController.isAgentConnected("aeptest1", "engine1"));
        Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest1", "engine1"));
        Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest2", "engine1"));
        Assert.assertFalse((boolean)this.messagingController.agentHasSubscriptions("aeptest2", "engine1"));
        Assert.assertEquals((long)1L, (long)app.bindingUpEventCount);
        Assert.assertEquals((long)0L, (long)app.bindingDownEventCount);
        Assert.assertEquals((long)2L, (long)app.channelUpEventCount);
        Assert.assertEquals((long)0L, (long)app.channelDownEventCount);
        Assert.assertEquals((long)1L, (long)app.messagingStartSuccessCount);
        Assert.assertEquals((long)0L, (long)app.messagingStartFailCount);
    }

    @Test
    public void testStandaloneNeverFailMessagingStartFailPolicyTwoBindingsSecondFailPermanent() throws Exception {
        AepEngineMessagingStartFailTestApp app = new AepEngineMessagingStartFailTestApp();
        AepEngine engine = this.createEngine("engine1", null, AepEngine.MessagingStartFailPolicy.NeverFail, null, null, null, false, false, false, false, null, 67, 67, app, null, null, 0, false, false, null, null, null, false, false);
        this.messagingController.failAllConnects("aeptest2", "engine1", true);
        engine.start();
        Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine.getState()));
        engine.waitForMessagingToStart();
        Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine.getState()));
        Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Started), (Object)((Object)engine.getMessagingState()));
        Assert.assertTrue((boolean)this.messagingController.isAgentConnected("aeptest1", "engine1"));
        Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest1", "engine1"));
        Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest2", "engine1"));
        Assert.assertFalse((boolean)this.messagingController.agentHasSubscriptions("aeptest2", "engine1"));
        Assert.assertEquals((long)1L, (long)app.bindingUpEventCount);
        Assert.assertEquals((long)0L, (long)app.bindingDownEventCount);
        Assert.assertEquals((long)2L, (long)app.channelUpEventCount);
        Assert.assertEquals((long)0L, (long)app.channelDownEventCount);
        Assert.assertEquals((long)1L, (long)app.messagingStartSuccessCount);
        Assert.assertEquals((long)0L, (long)app.messagingStartFailCount);
    }

    @Test
    public void testStandaloneNeverFailMessagingStartFailPolicyTwoBindingsBothFail() throws Exception {
        AepEngineMessagingStartFailTestApp app = new AepEngineMessagingStartFailTestApp();
        AepEngine engine = this.createEngine("engine1", null, AepEngine.MessagingStartFailPolicy.NeverFail, null, null, null, false, false, false, false, null, 67, 67, app, null, null, 0, false, false, null, null, null, false, false);
        this.messagingController.failAllConnects("aeptest1", "engine1", false);
        this.messagingController.failAllConnects("aeptest2", "engine1", false);
        engine.start();
        Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine.getState()));
        engine.waitForMessagingToStart();
        Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine.getState()));
        Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Started), (Object)((Object)engine.getMessagingState()));
        Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest1", "engine1"));
        Assert.assertFalse((boolean)this.messagingController.agentHasSubscriptions("aeptest1", "engine1"));
        Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest2", "engine1"));
        Assert.assertFalse((boolean)this.messagingController.agentHasSubscriptions("aeptest2", "engine1"));
        Assert.assertEquals((long)0L, (long)app.bindingUpEventCount);
        Assert.assertEquals((long)0L, (long)app.bindingDownEventCount);
        Assert.assertEquals((long)0L, (long)app.channelUpEventCount);
        Assert.assertEquals((long)0L, (long)app.channelDownEventCount);
        Assert.assertEquals((long)1L, (long)app.messagingStartSuccessCount);
        Assert.assertEquals((long)0L, (long)app.messagingStartFailCount);
    }

    @Test
    public void testStandaloneNeverFailMessagingStartFailPolicyTwoBindingsBothFailOnePermanent() throws Exception {
        AepEngineMessagingStartFailTestApp app = new AepEngineMessagingStartFailTestApp();
        AepEngine engine = this.createEngine("engine1", null, AepEngine.MessagingStartFailPolicy.NeverFail, null, null, null, false, false, false, false, null, 67, 67, app, null, null, 0, false, false, null, null, null, false, false);
        this.messagingController.failAllConnects("aeptest1", "engine1", false);
        this.messagingController.failAllConnects("aeptest2", "engine1", true);
        engine.start();
        Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine.getState()));
        engine.waitForMessagingToStart();
        Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine.getState()));
        Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Started), (Object)((Object)engine.getMessagingState()));
        Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest1", "engine1"));
        Assert.assertFalse((boolean)this.messagingController.agentHasSubscriptions("aeptest1", "engine1"));
        Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest2", "engine1"));
        Assert.assertFalse((boolean)this.messagingController.agentHasSubscriptions("aeptest2", "engine1"));
        Assert.assertEquals((long)0L, (long)app.bindingUpEventCount);
        Assert.assertEquals((long)0L, (long)app.bindingDownEventCount);
        Assert.assertEquals((long)0L, (long)app.channelUpEventCount);
        Assert.assertEquals((long)0L, (long)app.channelDownEventCount);
        Assert.assertEquals((long)1L, (long)app.messagingStartSuccessCount);
        Assert.assertEquals((long)0L, (long)app.messagingStartFailCount);
    }

    @Test(expected=EAepException.class)
    public void testStandaloneNeverFailMessagingStartFailPolicyTwoBindingsBothFailPermanent() throws Exception {
        AepEngineMessagingStartFailTestApp app = new AepEngineMessagingStartFailTestApp();
        AepEngine engine = this.createEngine("engine1", null, AepEngine.MessagingStartFailPolicy.NeverFail, null, null, null, false, false, false, false, null, 67, 67, app, null, null, 0, false, false, null, null, null, false, false);
        this.messagingController.failAllConnects("aeptest1", "engine1", true);
        this.messagingController.failAllConnects("aeptest2", "engine1", true);
        try {
            engine.start();
            Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine.getState()));
        }
        catch (EAepException e) {
            Assert.fail((String)"start() threw exception when it should not have");
        }
        try {
            engine.waitForMessagingToStart();
        }
        catch (EAepException e) {
            Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Stopped), (Object)((Object)engine.getMessagingState()));
            Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest1", "engine1"));
            Assert.assertFalse((boolean)this.messagingController.agentHasSubscriptions("aeptest1", "engine1"));
            Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest2", "engine1"));
            Assert.assertFalse((boolean)this.messagingController.agentHasSubscriptions("aeptest2", "engine1"));
            Assert.assertEquals((long)0L, (long)app.bindingUpEventCount);
            Assert.assertEquals((long)0L, (long)app.bindingDownEventCount);
            Assert.assertEquals((long)0L, (long)app.channelUpEventCount);
            Assert.assertEquals((long)0L, (long)app.channelDownEventCount);
            Assert.assertEquals((long)0L, (long)app.messagingStartSuccessCount);
            Assert.assertEquals((long)1L, (long)app.messagingStartFailCount);
            Assert.assertTrue((boolean)app.waitForEngineToStop());
            Assert.assertEquals((Object)((Object)AepEngine.State.Stopped), (Object)((Object)engine.getState()));
            throw e;
        }
    }

    @Test(expected=EAepException.class)
    public void testRedundantNeverFailMessagingStartFailPolicyTwoBindingsBothFailPermanent() throws Exception {
        AepEngineMessagingStartFailTestApp instance1 = new AepEngineMessagingStartFailTestApp();
        AepEngineMessagingStartFailTestApp instance2 = new AepEngineMessagingStartFailTestApp();
        String engineName = this.createEnginesForRedundantTest(instance1, instance2, AepEngine.MessagingStartFailPolicy.NeverFail, 67);
        AepEngine engine1 = (AepEngine)((Object)this.engines.get(0));
        AepEngine engine2 = (AepEngine)((Object)this.engines.get(1));
        this.messagingController.failNextConnect("aeptest1", engineName, true);
        this.messagingController.failNextConnect("aeptest2", engineName, true);
        EngineStarter starter = new EngineStarter(engine2);
        starter.start();
        try {
            engine1.start();
            Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine1.getState()));
        }
        catch (EAepException e) {
            Assert.fail((String)"start() threw exception when it should not have");
        }
        try {
            engine1.waitForMessagingToStart();
            Assert.fail((String)"waitForMessagingToStart() didn't throw exception when it should have");
        }
        catch (EAepException e) {
            Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Stopped), (Object)((Object)engine1.getMessagingState()));
            Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest1", engineName));
            Assert.assertFalse((boolean)this.messagingController.agentHasSubscriptions("aeptest1", engineName));
            Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest2", engineName));
            Assert.assertFalse((boolean)this.messagingController.agentHasSubscriptions("aeptest2", engineName));
            Assert.assertEquals((long)0L, (long)instance1.bindingUpEventCount);
            Assert.assertEquals((long)0L, (long)instance1.bindingDownEventCount);
            Assert.assertEquals((long)0L, (long)instance1.channelUpEventCount);
            Assert.assertEquals((long)0L, (long)instance1.channelDownEventCount);
            Assert.assertEquals((long)0L, (long)instance1.messagingStartSuccessCount);
            Assert.assertEquals((long)1L, (long)instance1.messagingStartFailCount);
            Assert.assertTrue((boolean)instance1.waitForEngineToStop());
            Assert.assertEquals((Object)((Object)AepEngine.State.Stopped), (Object)((Object)engine1.getState()));
            throw e;
        }
        finally {
            starter.join();
            if (starter.e != null) {
                Assert.fail((String)("backup start failed [" + starter.e.toString() + "]"));
            }
            try {
                engine2.waitForMessagingToStart();
                Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine2.getState()));
                Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Started), (Object)((Object)engine2.getMessagingState()));
                Assert.assertTrue((boolean)this.messagingController.isAgentConnected("aeptest1", engineName));
                Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest1", engineName));
                Assert.assertTrue((boolean)this.messagingController.isAgentConnected("aeptest2", engineName));
                Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest1", engineName));
                Assert.assertEquals((long)2L, (long)instance2.bindingUpEventCount);
                Assert.assertEquals((long)0L, (long)instance2.bindingDownEventCount);
                Assert.assertEquals((long)3L, (long)instance2.channelUpEventCount);
                Assert.assertEquals((long)0L, (long)instance2.channelDownEventCount);
                Assert.assertEquals((long)1L, (long)instance2.messagingStartSuccessCount);
                Assert.assertEquals((long)0L, (long)instance2.messagingStartFailCount);
            }
            catch (EAepException e) {
                Assert.fail((String)"waitForMessagingToStart() threw exception when it should not have");
            }
        }
    }

    private final void testStandaloneFailIfOneBindingFailsMessagingStartFailPolicyOneBindingFail(boolean permanent) throws Exception {
        AepEngineMessagingStartFailTestApp app = new AepEngineMessagingStartFailTestApp();
        AepEngine engine = this.createEngine("engine1", null, AepEngine.MessagingStartFailPolicy.FailIfOneBindingFails, null, null, null, false, false, false, false, null, 1, 1, app, null, null, 0, false, false, null, null, null, false, false);
        this.messagingController.failNextConnect("aeptest1", "engine1", permanent);
        try {
            engine.start();
        }
        catch (EAepException e) {
            Assert.fail((String)"start() threw exception when it should not have");
        }
        try {
            engine.waitForMessagingToStart();
        }
        catch (EAepException e) {
            Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Stopped), (Object)((Object)engine.getMessagingState()));
            Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest1", "engine1"));
            Assert.assertFalse((boolean)this.messagingController.agentHasSubscriptions("aeptest1", "engine1"));
            Assert.assertEquals((long)0L, (long)app.bindingUpEventCount);
            Assert.assertEquals((long)0L, (long)app.bindingDownEventCount);
            Assert.assertEquals((long)0L, (long)app.channelUpEventCount);
            Assert.assertEquals((long)0L, (long)app.channelDownEventCount);
            Assert.assertEquals((long)0L, (long)app.messagingStartSuccessCount);
            Assert.assertEquals((long)1L, (long)app.messagingStartFailCount);
            Assert.assertTrue((boolean)app.waitForEngineToStop());
            Assert.assertEquals((Object)((Object)AepEngine.State.Stopped), (Object)((Object)engine.getState()));
            throw e;
        }
    }

    @Test(expected=EAepException.class)
    public void testStandaloneFailIfOneBindingFailsMessagingStartFailPolicyOneBindingFail() throws Exception {
        this.testStandaloneFailIfOneBindingFailsMessagingStartFailPolicyOneBindingFail(false);
    }

    @Test(expected=EAepException.class)
    public void testStandaloneFailIfOneBindingFailsMessagingStartFailPolicyOneBindingFailPermanent() throws Exception {
        this.testStandaloneFailIfOneBindingFailsMessagingStartFailPolicyOneBindingFail(false);
    }

    private final void testRedundantFailIfOneBindingFailsMessagingStartFailPolicyOneBindingFail(boolean permanent) throws Exception {
        AepEngineMessagingStartFailTestApp instance1 = new AepEngineMessagingStartFailTestApp();
        AepEngineMessagingStartFailTestApp instance2 = new AepEngineMessagingStartFailTestApp();
        String engineName = this.createEnginesForRedundantTest(instance1, instance2, AepEngine.MessagingStartFailPolicy.FailIfOneBindingFails, 1);
        AepEngine engine1 = (AepEngine)((Object)this.engines.get(0));
        AepEngine engine2 = (AepEngine)((Object)this.engines.get(1));
        this.messagingController.failNextConnect("aeptest1", engineName, permanent);
        EngineStarter starter = new EngineStarter(engine2);
        starter.start();
        try {
            engine1.start();
        }
        catch (EAepException e) {
            Assert.fail((String)"start() threw exception when it should not have");
        }
        try {
            engine1.waitForMessagingToStart();
        }
        catch (EAepException e) {
            Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Stopped), (Object)((Object)engine1.getMessagingState()));
            Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest1", engineName));
            Assert.assertFalse((boolean)this.messagingController.agentHasSubscriptions("aeptest1", engineName));
            Assert.assertEquals((long)0L, (long)instance1.bindingUpEventCount);
            Assert.assertEquals((long)0L, (long)instance1.bindingDownEventCount);
            Assert.assertEquals((long)0L, (long)instance1.channelUpEventCount);
            Assert.assertEquals((long)0L, (long)instance1.channelDownEventCount);
            Assert.assertEquals((long)0L, (long)instance1.messagingStartSuccessCount);
            Assert.assertEquals((long)1L, (long)instance1.messagingStartFailCount);
            Assert.assertTrue((boolean)instance1.waitForEngineToStop());
            Assert.assertEquals((Object)((Object)AepEngine.State.Stopped), (Object)((Object)engine1.getState()));
            throw e;
        }
        finally {
            starter.join();
            if (starter.e != null) {
                Assert.fail((String)("backup start failed [" + starter.e.toString() + "]"));
            }
            try {
                engine2.waitForMessagingToStart();
                Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine2.getState()));
                Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Started), (Object)((Object)engine2.getMessagingState()));
                Assert.assertTrue((boolean)this.messagingController.isAgentConnected("aeptest1", engineName));
                Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest1", engineName));
                Assert.assertEquals((long)1L, (long)instance2.bindingUpEventCount);
                Assert.assertEquals((long)0L, (long)instance2.bindingDownEventCount);
                Assert.assertEquals((long)1L, (long)instance2.channelUpEventCount);
                Assert.assertEquals((long)0L, (long)instance2.channelDownEventCount);
                Assert.assertEquals((long)1L, (long)instance2.messagingStartSuccessCount);
                Assert.assertEquals((long)0L, (long)instance2.messagingStartFailCount);
            }
            catch (EAepException e) {
                Assert.fail((String)"waitForMessagingToStart() threw exception when it should not have");
            }
        }
    }

    @Test(expected=EAepException.class)
    public void testRedundantFailIfOneBindingFailsMessagingStartFailPolicyOneBindingFail() throws Exception {
        this.testRedundantFailIfOneBindingFailsMessagingStartFailPolicyOneBindingFail(false);
    }

    @Test(expected=EAepException.class)
    public void testRedundantFailIfOneBindingFailsMessagingStartFailPolicyOneBindingFailPermanent() throws Exception {
        this.testRedundantFailIfOneBindingFailsMessagingStartFailPolicyOneBindingFail(true);
    }

    private final void testStandaloneFailIfOneBindingFailsMessagingStartFailPolicyTwoBindingsFirstFail(boolean permanent) throws Exception {
        AepEngineMessagingStartFailTestApp app = new AepEngineMessagingStartFailTestApp();
        AepEngine engine = this.createEngine("engine1", null, AepEngine.MessagingStartFailPolicy.FailIfOneBindingFails, null, null, null, false, false, false, false, null, 67, 67, app, null, null, 0, false, false, null, null, null, false, false);
        this.messagingController.failNextConnect("aeptest1", "engine1", permanent);
        try {
            engine.start();
            Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine.getState()));
        }
        catch (EAepException e) {
            Assert.fail((String)"start() threw exception when it should not have");
        }
        try {
            engine.waitForMessagingToStart();
        }
        catch (EAepException e) {
            Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Stopped), (Object)((Object)engine.getMessagingState()));
            Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest1", "engine1"));
            Assert.assertFalse((boolean)this.messagingController.agentHasSubscriptions("aeptest1", "engine1"));
            Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest2", "engine1"));
            Assert.assertFalse((boolean)this.messagingController.agentHasSubscriptions("aeptest2", "engine1"));
            Assert.assertEquals((long)0L, (long)app.bindingUpEventCount);
            Assert.assertEquals((long)0L, (long)app.bindingDownEventCount);
            Assert.assertEquals((long)0L, (long)app.channelUpEventCount);
            Assert.assertEquals((long)0L, (long)app.channelDownEventCount);
            Assert.assertEquals((long)0L, (long)app.messagingStartSuccessCount);
            Assert.assertEquals((long)1L, (long)app.messagingStartFailCount);
            Assert.assertTrue((boolean)app.waitForEngineToStop());
            throw e;
        }
    }

    @Test(expected=EAepException.class)
    public void testStandaloneFailIfOneBindingFailsMessagingStartFailPolicyTwoBindingsFirstFail() throws Exception {
        this.testStandaloneFailIfOneBindingFailsMessagingStartFailPolicyTwoBindingsFirstFail(false);
    }

    @Test(expected=EAepException.class)
    public void testStandaloneFailIfOneBindingFailsMessagingStartFailPolicyTwoBindingsFirstFailPermanent() throws Exception {
        this.testStandaloneFailIfOneBindingFailsMessagingStartFailPolicyTwoBindingsFirstFail(true);
    }

    private final void testRedundantFailIfOneBindingFailsMessagingStartFailPolicyTwoBindingsFirstFail(boolean permanent) throws Exception {
        AepEngineMessagingStartFailTestApp instance1 = new AepEngineMessagingStartFailTestApp();
        AepEngineMessagingStartFailTestApp instance2 = new AepEngineMessagingStartFailTestApp();
        String engineName = this.createEnginesForRedundantTest(instance1, instance2, AepEngine.MessagingStartFailPolicy.FailIfOneBindingFails, 67);
        AepEngine engine1 = (AepEngine)((Object)this.engines.get(0));
        AepEngine engine2 = (AepEngine)((Object)this.engines.get(1));
        this.messagingController.failNextConnect("aeptest1", engineName, permanent);
        EngineStarter starter = new EngineStarter(engine2);
        starter.start();
        try {
            engine1.start();
        }
        catch (EAepException e) {
            Assert.fail((String)"start() threw exception when it should not have");
        }
        try {
            engine1.waitForMessagingToStart();
        }
        catch (EAepException e) {
            Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Stopped), (Object)((Object)engine1.getMessagingState()));
            Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest1", engineName));
            Assert.assertFalse((boolean)this.messagingController.agentHasSubscriptions("aeptest1", engineName));
            Assert.assertEquals((long)0L, (long)instance1.bindingUpEventCount);
            Assert.assertEquals((long)0L, (long)instance1.bindingDownEventCount);
            Assert.assertEquals((long)0L, (long)instance1.channelUpEventCount);
            Assert.assertEquals((long)0L, (long)instance1.channelDownEventCount);
            Assert.assertEquals((long)0L, (long)instance1.messagingStartSuccessCount);
            Assert.assertEquals((long)1L, (long)instance1.messagingStartFailCount);
            Assert.assertTrue((boolean)instance1.waitForEngineToStop());
            Assert.assertEquals((Object)((Object)AepEngine.State.Stopped), (Object)((Object)engine1.getState()));
            throw e;
        }
        finally {
            starter.join();
            if (starter.e != null) {
                Assert.fail((String)("backup start failed [" + starter.e.toString() + "]"));
            }
            try {
                engine2.waitForMessagingToStart();
                Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine2.getState()));
                Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Started), (Object)((Object)engine2.getMessagingState()));
                Assert.assertTrue((boolean)this.messagingController.isAgentConnected("aeptest1", engineName));
                Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest1", engineName));
                Assert.assertEquals((long)2L, (long)instance2.bindingUpEventCount);
                Assert.assertEquals((long)0L, (long)instance2.bindingDownEventCount);
                Assert.assertEquals((long)3L, (long)instance2.channelUpEventCount);
                Assert.assertEquals((long)0L, (long)instance2.channelDownEventCount);
                Assert.assertEquals((long)1L, (long)instance2.messagingStartSuccessCount);
                Assert.assertEquals((long)0L, (long)instance2.messagingStartFailCount);
            }
            catch (EAepException e) {
                Assert.fail((String)"waitForMessagingToStart() threw exception when it should not have");
            }
        }
    }

    @Test(expected=EAepException.class)
    public void testRedundantFailIfOneBindingFailsMessagingStartFailPolicyTwoBindingsFirstFail() throws Exception {
        this.testRedundantFailIfOneBindingFailsMessagingStartFailPolicyTwoBindingsFirstFail(false);
    }

    @Test(expected=EAepException.class)
    public void testRedundantFailIfOneBindingFailsMessagingStartFailPolicyTwoBindingsFirstFailPermanent() throws Exception {
        this.testRedundantFailIfOneBindingFailsMessagingStartFailPolicyTwoBindingsFirstFail(true);
    }

    private final void testStandaloneFailIfOneBindingFailsMessagingStartFailPolicyTwoBindingsSecondFail(boolean permanent) throws Exception {
        AepEngineMessagingStartFailTestApp app = new AepEngineMessagingStartFailTestApp();
        AepEngine engine = this.createEngine("engine1", null, AepEngine.MessagingStartFailPolicy.FailIfOneBindingFails, null, null, null, false, false, false, false, null, 67, 67, app, null, null, 0, false, false, null, null, null, false, false);
        this.messagingController.failNextConnect("aeptest2", "engine1", permanent);
        try {
            engine.start();
        }
        catch (EAepException e) {
            Assert.fail((String)"start() threw exception when it should not have");
        }
        try {
            engine.waitForMessagingToStart();
        }
        catch (EAepException e) {
            Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Stopped), (Object)((Object)engine.getMessagingState()));
            Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest1", "engine1"));
            Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest1", "engine1"));
            Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest2", "engine1"));
            Assert.assertFalse((boolean)this.messagingController.agentHasSubscriptions("aeptest2", "engine1"));
            Assert.assertEquals((long)1L, (long)app.bindingUpEventCount);
            Assert.assertEquals((long)0L, (long)app.bindingDownEventCount);
            Assert.assertEquals((long)2L, (long)app.channelUpEventCount);
            Assert.assertEquals((long)0L, (long)app.channelDownEventCount);
            Assert.assertEquals((long)0L, (long)app.messagingStartSuccessCount);
            Assert.assertEquals((long)1L, (long)app.messagingStartFailCount);
            Assert.assertTrue((boolean)app.waitForEngineToStop());
            Assert.assertEquals((Object)((Object)AepEngine.State.Stopped), (Object)((Object)engine.getState()));
            throw e;
        }
    }

    @Test(expected=EAepException.class)
    public void testStandaloneFailIfOneBindingFailsMessagingStartFailPolicyTwoBindingsSecondFail() throws Exception {
        this.testStandaloneFailIfOneBindingFailsMessagingStartFailPolicyTwoBindingsSecondFail(false);
    }

    @Test(expected=EAepException.class)
    public void testStandaloneFailIfOneBindingFailsMessagingStartFailPolicyTwoBindingsSecondFailPermanent() throws Exception {
        this.testStandaloneFailIfOneBindingFailsMessagingStartFailPolicyTwoBindingsSecondFail(true);
    }

    private final void testRedundantFailIfOneBindingFailsMessagingStartFailPolicyTwoBindingsSecondFail(boolean permanent) throws Exception {
        AepEngineMessagingStartFailTestApp instance1 = new AepEngineMessagingStartFailTestApp();
        AepEngineMessagingStartFailTestApp instance2 = new AepEngineMessagingStartFailTestApp();
        String engineName = this.createEnginesForRedundantTest(instance1, instance2, AepEngine.MessagingStartFailPolicy.FailIfOneBindingFails, 67);
        AepEngine engine1 = (AepEngine)((Object)this.engines.get(0));
        AepEngine engine2 = (AepEngine)((Object)this.engines.get(1));
        this.messagingController.failNextConnect("aeptest2", engineName, permanent);
        EngineStarter starter = new EngineStarter(engine2);
        starter.start();
        try {
            engine1.start();
        }
        catch (EAepException e) {
            Assert.fail((String)"start() threw exception when it should not have");
        }
        try {
            engine1.waitForMessagingToStart();
        }
        catch (EAepException e) {
            Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Stopped), (Object)((Object)engine1.getMessagingState()));
            Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest1", engineName));
            Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest1", engineName));
            Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest2", engineName));
            Assert.assertFalse((boolean)this.messagingController.agentHasSubscriptions("aeptest2", engineName));
            Assert.assertEquals((long)1L, (long)instance1.bindingUpEventCount);
            Assert.assertEquals((long)0L, (long)instance1.bindingDownEventCount);
            Assert.assertEquals((long)2L, (long)instance1.channelUpEventCount);
            Assert.assertEquals((long)0L, (long)instance1.channelDownEventCount);
            Assert.assertEquals((long)0L, (long)instance1.messagingStartSuccessCount);
            Assert.assertEquals((long)1L, (long)instance1.messagingStartFailCount);
            Assert.assertTrue((boolean)instance1.waitForEngineToStop());
            Assert.assertEquals((Object)((Object)AepEngine.State.Stopped), (Object)((Object)engine1.getState()));
            throw e;
        }
        finally {
            starter.join();
            if (starter.e != null) {
                Assert.fail((String)("backup start failed [" + starter.e.toString() + "]"));
            }
            try {
                engine2.waitForMessagingToStart();
                Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine2.getState()));
                Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Started), (Object)((Object)engine2.getMessagingState()));
                Assert.assertTrue((boolean)this.messagingController.isAgentConnected("aeptest1", engineName));
                Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest1", engineName));
                Assert.assertTrue((boolean)this.messagingController.isAgentConnected("aeptest2", engineName));
                Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest2", engineName));
                Assert.assertEquals((long)2L, (long)instance2.bindingUpEventCount);
                Assert.assertEquals((long)0L, (long)instance2.bindingDownEventCount);
                Assert.assertEquals((long)3L, (long)instance2.channelUpEventCount);
                Assert.assertEquals((long)0L, (long)instance2.channelDownEventCount);
                Assert.assertEquals((long)1L, (long)instance2.messagingStartSuccessCount);
                Assert.assertEquals((long)0L, (long)instance2.messagingStartFailCount);
            }
            catch (EAepException e) {
                Assert.fail((String)"waitForMessagingToStart() threw exception when it should not have");
            }
        }
    }

    @Test(expected=EAepException.class)
    public void testRedundantFailIfOneBindingFailsMessagingStartFailPolicyTwoBindingsSecondFail() throws Exception {
        this.testRedundantFailIfOneBindingFailsMessagingStartFailPolicyTwoBindingsSecondFail(false);
    }

    @Test(expected=EAepException.class)
    public void testRedundantFailIfOneBindingFailsMessagingStartFailPolicyTwoBindingsSecondFailPermanent() throws Exception {
        this.testRedundantFailIfOneBindingFailsMessagingStartFailPolicyTwoBindingsSecondFail(true);
    }

    private final void testStandaloneFailIfOneBindingFailsMessagingStartFailPolicyTwoBindingsBothFail(boolean permanent1, boolean permanent2) throws Exception {
        AepEngineMessagingStartFailTestApp app = new AepEngineMessagingStartFailTestApp();
        AepEngine engine = this.createEngine("engine1", null, AepEngine.MessagingStartFailPolicy.FailIfOneBindingFails, null, null, null, false, false, false, false, null, 67, 67, app, null, null, 0, false, false, null, null, null, false, false);
        this.messagingController.failNextConnect("aeptest1", "engine1", permanent1);
        this.messagingController.failNextConnect("aeptest2", "engine1", permanent2);
        try {
            engine.start();
        }
        catch (EAepException e) {
            Assert.fail((String)"start() threw exception when it should not have");
        }
        try {
            engine.waitForMessagingToStart();
        }
        catch (EAepException e) {
            Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Stopped), (Object)((Object)engine.getMessagingState()));
            Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest1", "engine1"));
            Assert.assertFalse((boolean)this.messagingController.agentHasSubscriptions("aeptest1", "engine1"));
            Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest2", "engine1"));
            Assert.assertFalse((boolean)this.messagingController.agentHasSubscriptions("aeptest2", "engine1"));
            Assert.assertEquals((long)0L, (long)app.bindingUpEventCount);
            Assert.assertEquals((long)0L, (long)app.bindingDownEventCount);
            Assert.assertEquals((long)0L, (long)app.channelUpEventCount);
            Assert.assertEquals((long)0L, (long)app.channelDownEventCount);
            Assert.assertEquals((long)0L, (long)app.messagingStartSuccessCount);
            Assert.assertEquals((long)1L, (long)app.messagingStartFailCount);
            Assert.assertTrue((boolean)app.waitForEngineToStop());
            Assert.assertEquals((Object)((Object)AepEngine.State.Stopped), (Object)((Object)engine.getState()));
            throw e;
        }
    }

    @Test(expected=EAepException.class)
    public void testStandaloneFailIfOneBindingFailsMessagingStartFailPolicyTwoBindingsBothFail() throws Exception {
        this.testStandaloneFailIfOneBindingFailsMessagingStartFailPolicyTwoBindingsBothFail(false, false);
    }

    @Test(expected=EAepException.class)
    public void testStandaloneFailIfOneBindingFailsMessagingStartFailPolicyTwoBindingsBothFailOnePermanent() throws Exception {
        this.testStandaloneFailIfOneBindingFailsMessagingStartFailPolicyTwoBindingsBothFail(false, true);
    }

    @Test(expected=EAepException.class)
    public void testStandaloneFailIfOneBindingFailsMessagingStartFailPolicyTwoBindingsBothFailPermanent() throws Exception {
        this.testStandaloneFailIfOneBindingFailsMessagingStartFailPolicyTwoBindingsBothFail(true, true);
    }

    private final void testRedundantFailIfOneBindingFailsMessagingStartFailPolicyTwoBindingsBothFail(boolean permanent1, boolean permanent2) throws Exception {
        AepEngineMessagingStartFailTestApp instance1 = new AepEngineMessagingStartFailTestApp();
        AepEngineMessagingStartFailTestApp instance2 = new AepEngineMessagingStartFailTestApp();
        String engineName = this.createEnginesForRedundantTest(instance1, instance2, AepEngine.MessagingStartFailPolicy.FailIfOneBindingFails, 67);
        AepEngine engine1 = (AepEngine)((Object)this.engines.get(0));
        AepEngine engine2 = (AepEngine)((Object)this.engines.get(1));
        this.messagingController.failNextConnect("aeptest1", engineName, permanent1);
        EngineStarter starter = new EngineStarter(engine2);
        starter.start();
        try {
            engine1.start();
        }
        catch (EAepException e) {
            Assert.fail((String)"start() threw exception when it should not have");
        }
        try {
            engine1.waitForMessagingToStart();
        }
        catch (EAepException e) {
            Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Stopped), (Object)((Object)engine1.getMessagingState()));
            Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest1", engineName));
            Assert.assertFalse((boolean)this.messagingController.agentHasSubscriptions("aeptest1", engineName));
            Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest2", engineName));
            Assert.assertFalse((boolean)this.messagingController.agentHasSubscriptions("aeptest2", engineName));
            Assert.assertEquals((long)0L, (long)instance1.bindingUpEventCount);
            Assert.assertEquals((long)0L, (long)instance1.bindingDownEventCount);
            Assert.assertEquals((long)0L, (long)instance1.channelUpEventCount);
            Assert.assertEquals((long)0L, (long)instance1.channelDownEventCount);
            Assert.assertEquals((long)0L, (long)instance1.messagingStartSuccessCount);
            Assert.assertEquals((long)1L, (long)instance1.messagingStartFailCount);
            Assert.assertTrue((boolean)instance1.waitForEngineToStop());
            Assert.assertEquals((Object)((Object)AepEngine.State.Stopped), (Object)((Object)engine1.getState()));
            throw e;
        }
        finally {
            starter.join();
            if (starter.e != null) {
                Assert.fail((String)("backup start failed [" + starter.e.toString() + "]"));
            }
            try {
                engine2.waitForMessagingToStart();
                Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine2.getState()));
                Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Started), (Object)((Object)engine2.getMessagingState()));
                Assert.assertTrue((boolean)this.messagingController.isAgentConnected("aeptest1", engineName));
                Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest1", engineName));
                Assert.assertTrue((boolean)this.messagingController.isAgentConnected("aeptest2", engineName));
                Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest2", engineName));
                Assert.assertEquals((long)2L, (long)instance2.bindingUpEventCount);
                Assert.assertEquals((long)0L, (long)instance2.bindingDownEventCount);
                Assert.assertEquals((long)3L, (long)instance2.channelUpEventCount);
                Assert.assertEquals((long)0L, (long)instance2.channelDownEventCount);
                Assert.assertEquals((long)1L, (long)instance2.messagingStartSuccessCount);
                Assert.assertEquals((long)0L, (long)instance2.messagingStartFailCount);
            }
            catch (EAepException e) {
                Assert.fail((String)"waitForMessagingToStart() threw exception when it should not have");
            }
        }
    }

    @Test(expected=EAepException.class)
    public void testRedundantFailIfOneBindingFailsMessagingStartFailPolicyTwoBindingsBothFail() throws Exception {
        this.testRedundantFailIfOneBindingFailsMessagingStartFailPolicyTwoBindingsBothFail(false, false);
    }

    @Test(expected=EAepException.class)
    public void testRedundantFailIfOneBindingFailsMessagingStartFailPolicyTwoBindingsBothFailOnePermanent() throws Exception {
        this.testRedundantFailIfOneBindingFailsMessagingStartFailPolicyTwoBindingsBothFail(false, true);
    }

    @Test(expected=EAepException.class)
    public void testRedundantFailIfOneBindingFailsMessagingStartFailPolicyTwoBindingsBothFailPermanent() throws Exception {
        this.testRedundantFailIfOneBindingFailsMessagingStartFailPolicyTwoBindingsBothFail(true, true);
    }

    private final void testStandaloneFailIfAllBindingsFailMessagingStartFailPolicyOneBindingFail(boolean permanent) throws Exception {
        AepEngineMessagingStartFailTestApp app = new AepEngineMessagingStartFailTestApp();
        AepEngine engine = this.createEngine("engine1", null, AepEngine.MessagingStartFailPolicy.FailIfAllBindingsFail, null, null, null, false, false, false, false, null, 1, 1, app, null, null, 0, false, false, null, null, null, false, false);
        this.messagingController.failNextConnect("aeptest1", "engine1", permanent);
        try {
            engine.start();
            Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine.getState()));
        }
        catch (EAepException e) {
            Assert.fail((String)"start() threw exception when it should not have");
        }
        try {
            engine.waitForMessagingToStart();
        }
        catch (EAepException e) {
            Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Stopped), (Object)((Object)engine.getMessagingState()));
            Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest1", "engine1"));
            Assert.assertFalse((boolean)this.messagingController.agentHasSubscriptions("aeptest1", "engine1"));
            Assert.assertEquals((long)0L, (long)app.bindingUpEventCount);
            Assert.assertEquals((long)0L, (long)app.bindingDownEventCount);
            Assert.assertEquals((long)0L, (long)app.channelUpEventCount);
            Assert.assertEquals((long)0L, (long)app.channelDownEventCount);
            Assert.assertEquals((long)0L, (long)app.messagingStartSuccessCount);
            Assert.assertEquals((long)1L, (long)app.messagingStartFailCount);
            Assert.assertTrue((boolean)app.waitForEngineToStop());
            Assert.assertEquals((Object)((Object)AepEngine.State.Stopped), (Object)((Object)engine.getState()));
            throw e;
        }
    }

    @Test(expected=EAepException.class)
    public void testStandaloneFailIfAllBindingsFailMessagingStartFailPolicyOneBindingFail() throws Exception {
        this.testStandaloneFailIfAllBindingsFailMessagingStartFailPolicyOneBindingFail(false);
    }

    @Test(expected=EAepException.class)
    public void testStandaloneFailIfAllBindingsFailMessagingStartFailPolicyOneBindingFailPermanent() throws Exception {
        this.testStandaloneFailIfAllBindingsFailMessagingStartFailPolicyOneBindingFail(true);
    }

    private final void testRedundantFailIfAllBindingsFailMessagingStartFailPolicyOneBindingFail(boolean permanent) throws Exception {
        AepEngineMessagingStartFailTestApp instance1 = new AepEngineMessagingStartFailTestApp();
        AepEngineMessagingStartFailTestApp instance2 = new AepEngineMessagingStartFailTestApp();
        String engineName = this.createEnginesForRedundantTest(instance1, instance2, AepEngine.MessagingStartFailPolicy.FailIfAllBindingsFail, 1);
        AepEngine engine1 = (AepEngine)((Object)this.engines.get(0));
        AepEngine engine2 = (AepEngine)((Object)this.engines.get(1));
        this.messagingController.failNextConnect("aeptest1", engineName, permanent);
        EngineStarter starter = new EngineStarter(engine2);
        starter.start();
        try {
            engine1.start();
            Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine1.getState()));
        }
        catch (EAepException e) {
            Assert.fail((String)"start() threw exception when it should not have");
        }
        try {
            engine1.waitForMessagingToStart();
        }
        catch (EAepException e) {
            Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Stopped), (Object)((Object)engine1.getMessagingState()));
            Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest1", engineName));
            Assert.assertFalse((boolean)this.messagingController.agentHasSubscriptions("aeptest1", engineName));
            Assert.assertEquals((long)0L, (long)instance1.bindingUpEventCount);
            Assert.assertEquals((long)0L, (long)instance1.bindingDownEventCount);
            Assert.assertEquals((long)0L, (long)instance1.channelUpEventCount);
            Assert.assertEquals((long)0L, (long)instance1.channelDownEventCount);
            Assert.assertEquals((long)0L, (long)instance1.messagingStartSuccessCount);
            Assert.assertEquals((long)1L, (long)instance1.messagingStartFailCount);
            Assert.assertTrue((boolean)instance1.waitForEngineToStop());
            Assert.assertEquals((Object)((Object)AepEngine.State.Stopped), (Object)((Object)engine1.getState()));
            throw e;
        }
        finally {
            starter.join();
            if (starter.e != null) {
                Assert.fail((String)("backup start failed [" + starter.e.toString() + "]"));
            }
            try {
                engine2.waitForMessagingToStart();
                Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine2.getState()));
                Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Started), (Object)((Object)engine2.getMessagingState()));
                Assert.assertTrue((boolean)this.messagingController.isAgentConnected("aeptest1", engineName));
                Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest1", engineName));
                Assert.assertEquals((long)1L, (long)instance2.bindingUpEventCount);
                Assert.assertEquals((long)0L, (long)instance2.bindingDownEventCount);
                Assert.assertEquals((long)1L, (long)instance2.channelUpEventCount);
                Assert.assertEquals((long)0L, (long)instance2.channelDownEventCount);
                Assert.assertEquals((long)1L, (long)instance2.messagingStartSuccessCount);
                Assert.assertEquals((long)0L, (long)instance2.messagingStartFailCount);
            }
            catch (EAepException e) {
                Assert.fail((String)"waitForMessagingToStart() threw exception when it should not have");
            }
        }
    }

    @Test(expected=EAepException.class, timeout=120000L)
    public void testRedundantFailIfAllBindingsFailMessagingStartFailPolicyOneBindingFail() throws Exception {
        this.testRedundantFailIfAllBindingsFailMessagingStartFailPolicyOneBindingFail(false);
    }

    @Test(expected=EAepException.class, timeout=120000L)
    public void testRedundantFailIfAllBindingsFailMessagingStartFailPolicyOneBindingFailPermanent() throws Exception {
        this.testRedundantFailIfAllBindingsFailMessagingStartFailPolicyOneBindingFail(true);
    }

    private final void testStandaloneFailIfAllBindingsFailMessagingStartFailPolicyTwoBindingsFirstFail(boolean permanent) throws Exception {
        AepEngineMessagingStartFailTestApp app = new AepEngineMessagingStartFailTestApp();
        AepEngine engine = this.createEngine("engine1", null, AepEngine.MessagingStartFailPolicy.FailIfAllBindingsFail, null, null, null, false, false, false, false, null, 67, 67, app, null, null, 0, false, false, null, null, null, false, false);
        this.messagingController.failAllConnects("aeptest1", "engine1", permanent);
        engine.start();
        Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine.getState()));
        engine.waitForMessagingToStart();
        Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine.getState()));
        Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Started), (Object)((Object)engine.getMessagingState()));
        Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest1", "engine1"));
        Assert.assertFalse((boolean)this.messagingController.agentHasSubscriptions("aeptest1", "engine1"));
        Assert.assertTrue((boolean)this.messagingController.isAgentConnected("aeptest2", "engine1"));
        Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest2", "engine1"));
        Assert.assertEquals((long)1L, (long)app.bindingUpEventCount);
        Assert.assertEquals((long)0L, (long)app.bindingDownEventCount);
        Assert.assertEquals((long)1L, (long)app.channelUpEventCount);
        Assert.assertEquals((long)0L, (long)app.channelDownEventCount);
        Assert.assertEquals((long)1L, (long)app.messagingStartSuccessCount);
        Assert.assertEquals((long)0L, (long)app.messagingStartFailCount);
    }

    @Test
    public void testStandaloneFailIfAllBindingsFailMessagingStartFailPolicyTwoBindingsFirstFail() throws Exception {
        this.testStandaloneFailIfAllBindingsFailMessagingStartFailPolicyTwoBindingsFirstFail(false);
    }

    @Test
    public void testStandaloneFailIfAllBindingsFailMessagingStartFailPolicyTwoBindingsFirstFailPermanent() throws Exception {
        this.testStandaloneFailIfAllBindingsFailMessagingStartFailPolicyTwoBindingsFirstFail(true);
    }

    private final void testStandaloneFailIfAllBindingsFailMessagingStartFailPolicyTwoBindingsSecondFail(boolean permanent) throws Exception {
        AepEngineMessagingStartFailTestApp app = new AepEngineMessagingStartFailTestApp();
        AepEngine engine = this.createEngine("engine1", null, AepEngine.MessagingStartFailPolicy.FailIfAllBindingsFail, null, null, null, false, false, false, false, null, 67, 67, app, null, null, 0, false, false, null, null, null, false, false);
        this.messagingController.failNextConnect("aeptest2", "engine1", permanent);
        engine.start();
        Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine.getState()));
        engine.waitForMessagingToStart();
        Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine.getState()));
        Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Started), (Object)((Object)engine.getMessagingState()));
        Assert.assertTrue((boolean)this.messagingController.isAgentConnected("aeptest1", "engine1"));
        Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest1", "engine1"));
        Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest2", "engine1"));
        Assert.assertFalse((boolean)this.messagingController.agentHasSubscriptions("aeptest2", "engine1"));
        Assert.assertEquals((long)1L, (long)app.bindingUpEventCount);
        Assert.assertEquals((long)0L, (long)app.bindingDownEventCount);
        Assert.assertEquals((long)2L, (long)app.channelUpEventCount);
        Assert.assertEquals((long)0L, (long)app.channelDownEventCount);
        Assert.assertEquals((long)1L, (long)app.messagingStartSuccessCount);
        Assert.assertEquals((long)0L, (long)app.messagingStartFailCount);
    }

    @Test
    public void testStandaloneFailIfAllBindingsFailMessagingStartFailPolicyTwoBindingsSecondFail() throws Exception {
        this.testStandaloneFailIfAllBindingsFailMessagingStartFailPolicyTwoBindingsSecondFail(false);
    }

    @Test
    public void testStandaloneFailIfAllBindingsFailMessagingStartFailPolicyTwoBindingsSecondFailPermanent() throws Exception {
        this.testStandaloneFailIfAllBindingsFailMessagingStartFailPolicyTwoBindingsSecondFail(true);
    }

    private final void testStandaloneFailIfAllBindingsFailMessagingStartFailPolicyTwoBindingsBothFail(boolean permanent1, boolean permanent2) throws Exception {
        AepEngineMessagingStartFailTestApp app = new AepEngineMessagingStartFailTestApp();
        AepEngine engine = this.createEngine("engine1", null, AepEngine.MessagingStartFailPolicy.FailIfAllBindingsFail, null, null, null, false, false, false, false, null, 67, 67, app, null, null, 0, false, false, null, null, null, false, false);
        this.messagingController.failNextConnect("aeptest1", "engine1", permanent1);
        this.messagingController.failNextConnect("aeptest2", "engine1", permanent2);
        try {
            engine.start();
            Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine.getState()));
        }
        catch (EAepException e) {
            Assert.fail((String)"start() threw exception when it should not have");
        }
        try {
            engine.waitForMessagingToStart();
        }
        catch (EAepException e) {
            Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Stopped), (Object)((Object)engine.getMessagingState()));
            Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest1", "engine1"));
            Assert.assertFalse((boolean)this.messagingController.agentHasSubscriptions("aeptest1", "engine1"));
            Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest2", "engine1"));
            Assert.assertFalse((boolean)this.messagingController.agentHasSubscriptions("aeptest2", "engine1"));
            Assert.assertEquals((long)0L, (long)app.bindingUpEventCount);
            Assert.assertEquals((long)0L, (long)app.bindingDownEventCount);
            Assert.assertEquals((long)0L, (long)app.channelUpEventCount);
            Assert.assertEquals((long)0L, (long)app.channelDownEventCount);
            Assert.assertEquals((long)0L, (long)app.messagingStartSuccessCount);
            Assert.assertEquals((long)1L, (long)app.messagingStartFailCount);
            Assert.assertTrue((boolean)app.waitForEngineToStop());
            Assert.assertEquals((Object)((Object)AepEngine.State.Stopped), (Object)((Object)engine.getState()));
            throw e;
        }
    }

    @Test(expected=EAepException.class)
    public void testStandaloneFailIfAllBindingsFailMessagingStartFailPolicyTwoBindingsBothFail() throws Exception {
        this.testStandaloneFailIfAllBindingsFailMessagingStartFailPolicyTwoBindingsBothFail(false, false);
    }

    @Test(expected=EAepException.class)
    public void testStandaloneFailIfAllBindingsFailMessagingStartFailPolicyTwoBindingsBothFailOnePermanent() throws Exception {
        this.testStandaloneFailIfAllBindingsFailMessagingStartFailPolicyTwoBindingsBothFail(false, true);
    }

    @Test(expected=EAepException.class)
    public void testStandaloneFailIfAllBindingsFailMessagingStartFailPolicyTwoBindingsBothFailPermanent() throws Exception {
        this.testStandaloneFailIfAllBindingsFailMessagingStartFailPolicyTwoBindingsBothFail(true, true);
    }

    private final void testRedundantFailIfAllBindingFailsMessagingStartFailPolicyTwoBindingsBothFail(boolean permanent1, boolean permanent2) throws Exception {
        AepEngineMessagingStartFailTestApp instance1 = new AepEngineMessagingStartFailTestApp();
        AepEngineMessagingStartFailTestApp instance2 = new AepEngineMessagingStartFailTestApp();
        String engineName = this.createEnginesForRedundantTest(instance1, instance2, AepEngine.MessagingStartFailPolicy.FailIfAllBindingsFail, 67);
        AepEngine engine1 = (AepEngine)((Object)this.engines.get(0));
        AepEngine engine2 = (AepEngine)((Object)this.engines.get(1));
        this.messagingController.failNextConnect("aeptest1", engineName, permanent1);
        this.messagingController.failNextConnect("aeptest2", engineName, permanent2);
        EngineStarter starter = new EngineStarter(engine2);
        starter.start();
        try {
            engine1.start();
        }
        catch (EAepException e) {
            Assert.fail((String)"start() threw exception when it should not have");
        }
        try {
            engine1.waitForMessagingToStart();
        }
        catch (EAepException e) {
            Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Stopped), (Object)((Object)engine1.getMessagingState()));
            Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest1", engineName));
            Assert.assertFalse((boolean)this.messagingController.agentHasSubscriptions("aeptest1", engineName));
            Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest2", engineName));
            Assert.assertFalse((boolean)this.messagingController.agentHasSubscriptions("aeptest2", engineName));
            Assert.assertEquals((long)0L, (long)instance1.bindingUpEventCount);
            Assert.assertEquals((long)0L, (long)instance1.bindingDownEventCount);
            Assert.assertEquals((long)0L, (long)instance1.channelUpEventCount);
            Assert.assertEquals((long)0L, (long)instance1.channelDownEventCount);
            Assert.assertEquals((long)0L, (long)instance1.messagingStartSuccessCount);
            Assert.assertEquals((long)1L, (long)instance1.messagingStartFailCount);
            Assert.assertTrue((boolean)instance1.waitForEngineToStop());
            Assert.assertEquals((Object)((Object)AepEngine.State.Stopped), (Object)((Object)engine1.getState()));
            throw e;
        }
        finally {
            starter.join();
            if (starter.e != null) {
                Assert.fail((String)("backup start failed [" + starter.e.toString() + "]"));
            }
            try {
                engine2.waitForMessagingToStart();
                Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine2.getState()));
                Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Started), (Object)((Object)engine2.getMessagingState()));
                Assert.assertTrue((boolean)this.messagingController.isAgentConnected("aeptest1", engineName));
                Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest1", engineName));
                Assert.assertTrue((boolean)this.messagingController.isAgentConnected("aeptest2", engineName));
                Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest2", engineName));
                Assert.assertEquals((long)2L, (long)instance2.bindingUpEventCount);
                Assert.assertEquals((long)0L, (long)instance2.bindingDownEventCount);
                Assert.assertEquals((long)3L, (long)instance2.channelUpEventCount);
                Assert.assertEquals((long)0L, (long)instance2.channelDownEventCount);
                Assert.assertEquals((long)1L, (long)instance2.messagingStartSuccessCount);
                Assert.assertEquals((long)0L, (long)instance2.messagingStartFailCount);
            }
            catch (EAepException e) {
                Assert.fail((String)"waitForMessagingToStart() threw exception when it should not have");
            }
        }
    }

    @Test(expected=EAepException.class)
    public void testRedundantFailIfAllBindingFailsMessagingStartFailPolicyTwoBindingsBothFail() throws Exception {
        this.testRedundantFailIfAllBindingFailsMessagingStartFailPolicyTwoBindingsBothFail(false, false);
    }

    @Test(expected=EAepException.class)
    public void testRedundantFailIfAllBindingFailsMessagingStartFailPolicyTwoBindingsBothFailOnePermanent() throws Exception {
        this.testRedundantFailIfAllBindingFailsMessagingStartFailPolicyTwoBindingsBothFail(false, true);
    }

    @Test(expected=EAepException.class)
    public void testRedundantFailIfAllBindingFailsMessagingStartFailPolicyTwoBindingsBothFailPermanent() throws Exception {
        this.testRedundantFailIfAllBindingFailsMessagingStartFailPolicyTwoBindingsBothFail(true, true);
    }

    @Test(expected=EAepException.class)
    public final void testStandaloneConnectSucceedButStartFailsOneBinding() throws Exception {
        AepEngineMessagingStartFailTestApp app = new AepEngineMessagingStartFailTestApp();
        AepEngine engine = this.createEngine("engine1", null, AepEngine.MessagingStartFailPolicy.NeverFail, null, null, null, false, false, false, false, null, 1, 1, app, null, null, 0, false, false, null, null, null, false, false);
        this.messagingController.failNextStart("aeptest1", "engine1");
        try {
            engine.start();
            Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine.getState()));
        }
        catch (EAepException e) {
            Assert.fail((String)"start() threw exception when it should not have");
        }
        try {
            engine.waitForMessagingToStart();
        }
        catch (EAepException e) {
            Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Stopped), (Object)((Object)engine.getMessagingState()));
            Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest1", "engine1"));
            Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest1", "engine1"));
            Assert.assertEquals((long)1L, (long)app.bindingUpEventCount);
            Assert.assertEquals((long)0L, (long)app.bindingDownEventCount);
            Assert.assertEquals((long)1L, (long)app.channelUpEventCount);
            Assert.assertEquals((long)0L, (long)app.channelDownEventCount);
            Assert.assertEquals((long)0L, (long)app.messagingStartSuccessCount);
            Assert.assertEquals((long)1L, (long)app.messagingStartFailCount);
            Assert.assertTrue((boolean)app.waitForEngineToStop());
            Assert.assertEquals((Object)((Object)AepEngine.State.Stopped), (Object)((Object)engine.getState()));
            throw e;
        }
    }

    @Test(expected=EAepException.class)
    public final void testRedundantConnectSucceedButStartFailsOneBinding() throws Exception {
        AepEngineMessagingStartFailTestApp instance1 = new AepEngineMessagingStartFailTestApp();
        AepEngineMessagingStartFailTestApp instance2 = new AepEngineMessagingStartFailTestApp();
        String engineName = this.createEnginesForRedundantTest(instance1, instance2, AepEngine.MessagingStartFailPolicy.NeverFail, 1);
        AepEngine engine1 = (AepEngine)((Object)this.engines.get(0));
        AepEngine engine2 = (AepEngine)((Object)this.engines.get(1));
        this.messagingController.failNextStart("aeptest1", engineName);
        EngineStarter starter = new EngineStarter(engine2);
        starter.start();
        try {
            engine1.start();
            Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine1.getState()));
        }
        catch (EAepException e) {
            Assert.fail((String)"start() threw exception when it should not have");
        }
        try {
            engine1.waitForMessagingToStart();
        }
        catch (EAepException e) {
            Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Stopped), (Object)((Object)engine1.getMessagingState()));
            Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest1", engineName));
            Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest1", engineName));
            Assert.assertEquals((long)1L, (long)instance1.bindingUpEventCount);
            Assert.assertEquals((long)0L, (long)instance1.bindingDownEventCount);
            Assert.assertEquals((long)1L, (long)instance1.channelUpEventCount);
            Assert.assertEquals((long)0L, (long)instance1.channelDownEventCount);
            Assert.assertEquals((long)0L, (long)instance1.messagingStartSuccessCount);
            Assert.assertEquals((long)1L, (long)instance1.messagingStartFailCount);
            Assert.assertTrue((boolean)instance1.waitForEngineToStop());
            Assert.assertEquals((Object)((Object)AepEngine.State.Stopped), (Object)((Object)engine1.getState()));
            throw e;
        }
        finally {
            starter.join();
            if (starter.e != null) {
                Assert.fail((String)("backup start failed [" + starter.e.toString() + "]"));
            }
            try {
                engine2.waitForMessagingToStart();
                Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine2.getState()));
                Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Started), (Object)((Object)engine2.getMessagingState()));
                Assert.assertTrue((boolean)this.messagingController.isAgentConnected("aeptest1", engineName));
                Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest1", engineName));
                Assert.assertEquals((long)1L, (long)instance2.bindingUpEventCount);
                Assert.assertEquals((long)0L, (long)instance2.bindingDownEventCount);
                Assert.assertEquals((long)1L, (long)instance2.channelUpEventCount);
                Assert.assertEquals((long)0L, (long)instance2.channelDownEventCount);
                Assert.assertEquals((long)1L, (long)instance2.messagingStartSuccessCount);
                Assert.assertEquals((long)0L, (long)instance2.messagingStartFailCount);
            }
            catch (EAepException e) {
                Assert.fail((String)"waitForMessagingToStart() threw exception when it should not have");
            }
        }
    }

    @Test(expected=EAepException.class)
    public final void testStandaloneConnectSucceedButStartFailsTwoBindingsFirstFail() throws Exception {
        AepEngineMessagingStartFailTestApp app = new AepEngineMessagingStartFailTestApp();
        AepEngine engine = this.createEngine("engine1", null, AepEngine.MessagingStartFailPolicy.NeverFail, null, null, null, false, false, false, false, null, 67, 67, app, null, null, 0, false, false, null, null, null, false, false);
        this.messagingController.failNextStart("aeptest1", "engine1");
        try {
            engine.start();
            Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine.getState()));
        }
        catch (EAepException e) {
            Assert.fail((String)"start() threw exception when it should not have");
        }
        try {
            engine.waitForMessagingToStart();
        }
        catch (EAepException e) {
            Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Stopped), (Object)((Object)engine.getMessagingState()));
            Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest1", "engine1"));
            Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest1", "engine1"));
            Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest2", "engine1"));
            Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest2", "engine1"));
            Assert.assertEquals((long)2L, (long)app.bindingUpEventCount);
            Assert.assertEquals((long)0L, (long)app.bindingDownEventCount);
            Assert.assertEquals((long)3L, (long)app.channelUpEventCount);
            Assert.assertEquals((long)0L, (long)app.channelDownEventCount);
            Assert.assertEquals((long)0L, (long)app.messagingStartSuccessCount);
            Assert.assertEquals((long)1L, (long)app.messagingStartFailCount);
            Assert.assertTrue((boolean)app.waitForEngineToStop());
            Assert.assertEquals((Object)((Object)AepEngine.State.Stopped), (Object)((Object)engine.getState()));
            throw e;
        }
    }

    @Test(expected=EAepException.class)
    public final void testRedundantConnectSucceedButStartFailsTwoBindingsFirstFail() throws Exception {
        AepEngineMessagingStartFailTestApp instance1 = new AepEngineMessagingStartFailTestApp();
        AepEngineMessagingStartFailTestApp instance2 = new AepEngineMessagingStartFailTestApp();
        String engineName = this.createEnginesForRedundantTest(instance1, instance2, AepEngine.MessagingStartFailPolicy.NeverFail, 67);
        AepEngine engine1 = (AepEngine)((Object)this.engines.get(0));
        AepEngine engine2 = (AepEngine)((Object)this.engines.get(1));
        this.messagingController.failNextStart("aeptest1", engineName);
        EngineStarter starter = new EngineStarter(engine2);
        starter.start();
        try {
            engine1.start();
            Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine1.getState()));
        }
        catch (EAepException e) {
            Assert.fail((String)"start() threw exception when it should not have");
        }
        try {
            engine1.waitForMessagingToStart();
        }
        catch (EAepException e) {
            Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Stopped), (Object)((Object)engine1.getMessagingState()));
            Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest1", engineName));
            Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest1", engineName));
            Assert.assertEquals((long)2L, (long)instance1.bindingUpEventCount);
            Assert.assertEquals((long)0L, (long)instance1.bindingDownEventCount);
            Assert.assertEquals((long)3L, (long)instance1.channelUpEventCount);
            Assert.assertEquals((long)0L, (long)instance1.channelDownEventCount);
            Assert.assertEquals((long)0L, (long)instance1.messagingStartSuccessCount);
            Assert.assertEquals((long)1L, (long)instance1.messagingStartFailCount);
            Assert.assertTrue((boolean)instance1.waitForEngineToStop());
            Assert.assertEquals((Object)((Object)AepEngine.State.Stopped), (Object)((Object)engine1.getState()));
            throw e;
        }
        finally {
            starter.join();
            if (starter.e != null) {
                Assert.fail((String)("backup start failed [" + starter.e.toString() + "]"));
            }
            try {
                engine2.waitForMessagingToStart();
                Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine2.getState()));
                Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Started), (Object)((Object)engine2.getMessagingState()));
                Assert.assertTrue((boolean)this.messagingController.isAgentConnected("aeptest1", engineName));
                Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest1", engineName));
                Assert.assertEquals((long)2L, (long)instance2.bindingUpEventCount);
                Assert.assertEquals((long)0L, (long)instance2.bindingDownEventCount);
                Assert.assertEquals((long)3L, (long)instance2.channelUpEventCount);
                Assert.assertEquals((long)0L, (long)instance2.channelDownEventCount);
                Assert.assertEquals((long)1L, (long)instance2.messagingStartSuccessCount);
                Assert.assertEquals((long)0L, (long)instance2.messagingStartFailCount);
            }
            catch (EAepException e) {
                Assert.fail((String)"waitForMessagingToStart() threw exception when it should not have");
            }
        }
    }

    @Test(expected=EAepException.class)
    public final void testStandaloneConnectSucceedButStartFailsTwoBindingsSecondFail() throws Exception {
        AepEngineMessagingStartFailTestApp app = new AepEngineMessagingStartFailTestApp();
        AepEngine engine = this.createEngine("engine1", null, AepEngine.MessagingStartFailPolicy.NeverFail, null, null, null, false, false, false, false, null, 67, 67, app, null, null, 0, false, false, null, null, null, false, false);
        this.messagingController.failNextStart("aeptest2", "engine1");
        try {
            engine.start();
            Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine.getState()));
        }
        catch (EAepException e) {
            Assert.fail((String)"start() threw exception when it should not have");
        }
        try {
            engine.waitForMessagingToStart();
        }
        catch (EAepException e) {
            Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Stopped), (Object)((Object)engine.getMessagingState()));
            Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest1", "engine1"));
            Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest1", "engine1"));
            Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest2", "engine1"));
            Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest2", "engine1"));
            Assert.assertEquals((long)2L, (long)app.bindingUpEventCount);
            Assert.assertEquals((long)0L, (long)app.bindingDownEventCount);
            Assert.assertEquals((long)3L, (long)app.channelUpEventCount);
            Assert.assertEquals((long)0L, (long)app.channelDownEventCount);
            Assert.assertEquals((long)0L, (long)app.messagingStartSuccessCount);
            Assert.assertEquals((long)1L, (long)app.messagingStartFailCount);
            Assert.assertTrue((boolean)app.waitForEngineToStop());
            Assert.assertEquals((Object)((Object)AepEngine.State.Stopped), (Object)((Object)engine.getState()));
            throw e;
        }
    }

    @Test(expected=EAepException.class)
    public final void testRedundantConnectSucceedButStartFailsTwoBindingsSecondFail() throws Exception {
        AepEngineMessagingStartFailTestApp instance1 = new AepEngineMessagingStartFailTestApp();
        AepEngineMessagingStartFailTestApp instance2 = new AepEngineMessagingStartFailTestApp();
        String engineName = this.createEnginesForRedundantTest(instance1, instance2, AepEngine.MessagingStartFailPolicy.NeverFail, 67);
        AepEngine engine1 = (AepEngine)((Object)this.engines.get(0));
        AepEngine engine2 = (AepEngine)((Object)this.engines.get(1));
        this.messagingController.failNextStart("aeptest2", engineName);
        EngineStarter starter = new EngineStarter(engine2);
        starter.start();
        try {
            engine1.start();
            Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine1.getState()));
        }
        catch (EAepException e) {
            Assert.fail((String)"start() threw exception when it should not have");
        }
        try {
            engine1.waitForMessagingToStart();
        }
        catch (EAepException e) {
            Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Stopped), (Object)((Object)engine1.getMessagingState()));
            Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest1", engineName));
            Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest1", engineName));
            Assert.assertFalse((boolean)this.messagingController.isAgentConnected("aeptest2", engineName));
            Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest2", engineName));
            Assert.assertEquals((long)2L, (long)instance1.bindingUpEventCount);
            Assert.assertEquals((long)0L, (long)instance1.bindingDownEventCount);
            Assert.assertEquals((long)3L, (long)instance1.channelUpEventCount);
            Assert.assertEquals((long)0L, (long)instance1.channelDownEventCount);
            Assert.assertEquals((long)0L, (long)instance1.messagingStartSuccessCount);
            Assert.assertEquals((long)1L, (long)instance1.messagingStartFailCount);
            Assert.assertTrue((boolean)instance1.waitForEngineToStop());
            Assert.assertEquals((Object)((Object)AepEngine.State.Stopped), (Object)((Object)engine1.getState()));
            throw e;
        }
        finally {
            starter.join();
            if (starter.e != null) {
                Assert.fail((String)("backup start failed [" + starter.e.toString() + "]"));
            }
            try {
                engine2.waitForMessagingToStart();
                Assert.assertEquals((Object)((Object)AepEngine.State.Started), (Object)((Object)engine2.getState()));
                Assert.assertEquals((Object)((Object)AepEngine.MessagingState.Started), (Object)((Object)engine2.getMessagingState()));
                Assert.assertTrue((boolean)this.messagingController.isAgentConnected("aeptest1", engineName));
                Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest1", engineName));
                Assert.assertTrue((boolean)this.messagingController.isAgentConnected("aeptest2", engineName));
                Assert.assertTrue((boolean)this.messagingController.agentHasSubscriptions("aeptest2", engineName));
                Assert.assertEquals((long)2L, (long)instance2.bindingUpEventCount);
                Assert.assertEquals((long)0L, (long)instance2.bindingDownEventCount);
                Assert.assertEquals((long)3L, (long)instance2.channelUpEventCount);
                Assert.assertEquals((long)0L, (long)instance2.channelDownEventCount);
                Assert.assertEquals((long)1L, (long)instance2.messagingStartSuccessCount);
                Assert.assertEquals((long)0L, (long)instance2.messagingStartFailCount);
            }
            catch (EAepException e) {
                Assert.fail((String)"waitForMessagingToStart() threw exception when it should not have");
            }
        }
    }

    @Test(expected=EAepException.class)
    public void testTwinConnectFails() throws Exception {
        String engineName = "engine-" + System.currentTimeMillis() + "-" + this.engineCounter++;
        AepEngineMessagingStartFailTestApp instance1 = new AepEngineMessagingStartFailTestApp();
        AepEngine engine1 = this.createEngine(engineName, null, null, null, null, null, false, false, false, false, null, 1, 1, instance1, null, null, 0, false, false, null, null, null, false, false);
        try {
            engine1.start();
            engine1.waitForMessagingToStart();
        }
        catch (EAepException e) {
            Assert.fail((String)"engine start()/waitForMessagingToStart() threw exception when it should not have");
        }
        AepEngineMessagingStartFailTestApp instance2 = new AepEngineMessagingStartFailTestApp();
        AepEngine engine2 = this.createEngine(engineName, null, null, null, null, null, false, false, false, false, null, 1, 1, instance2, null, null, 0, false, false, null, null, null, false, false);
        engine2.start();
        engine2.waitForMessagingToStart();
    }

    private final class EngineStarter
    extends Thread {
        AepEngine engine;
        Exception e;

        EngineStarter(AepEngine engine) {
            this.engine = engine;
        }

        @Override
        public final void run() {
            try {
                Thread.sleep(6000L);
                this.engine.start();
            }
            catch (Exception e) {
                this.e = e;
            }
        }
    }
}

