/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.eaio.uuid.UUID;
import com.neeve.aep.AepEngine;
import com.neeve.aep.AepEngineDescriptor;
import com.neeve.aep.IAepApplicationStateFactory;
import com.neeve.aep.test.unit.AepEngineLogRestartTestApp;
import com.neeve.aep.test.unit.AepEngineLogTestApp;
import com.neeve.aep.test.unit.AepEngineTest;
import com.neeve.aep.test.unit.AepEngineTestApp;
import com.neeve.aep.test.unit.AepEngineTestObject;
import com.neeve.aep.test.unit.generated.json.Message;
import com.neeve.aep.test.unit.generated.proto.Repository;
import com.neeve.aep.test.unit.generated.xbuf.Factory;
import com.neeve.ci.XRuntime;
import com.neeve.ods.IStoreCheckpointingController;
import com.neeve.ods.IStorePersister;
import com.neeve.ods.OdsException;
import com.neeve.ods.StoreDescriptor;
import com.neeve.ods.StorePersisterDescriptor;
import com.neeve.rog.IRogChangeDataCaptureHandler;
import com.neeve.rog.IRogMessage;
import com.neeve.rog.IRogNode;
import com.neeve.rog.impl.RogNode;
import com.neeve.rog.log.RogLog;
import com.neeve.rog.log.RogLogCdcProcessor;
import com.neeve.rog.log.RogLogFactory;
import com.neeve.sma.MessageView;
import com.neeve.test.util.ProcessWrapper;
import com.neeve.tools.TransactionLogTool;
import com.neeve.util.UtlFile;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class AepEngineLogRestartTest
extends AepEngineTest {
    private AepEngineTestObject.EncodingType encoding = AepEngineTestObject.EncodingType.Proto;
    AepEngineTestApp app;
    String appName;
    AepEngine engine;

    private void sendMessages(int count) {
        block5: for (int i = 0; i < count; ++i) {
            switch (this.encoding) {
                case Json: {
                    RogNode message = Message.create();
                    message.setMessageBus("aeptest1");
                    message.setMessageChannel("channel1");
                    this.engine.sendMessage(this.app.channel1, (IRogMessage)message);
                    continue block5;
                }
                case Proto: {
                    RogNode message = com.neeve.aep.test.unit.generated.proto.Message.create();
                    message.setMessageBus("aeptest1");
                    message.setMessageChannel("channel1");
                    this.engine.sendMessage(this.app.channel1, (IRogMessage)message);
                    continue block5;
                }
                case Xbuf: {
                    RogNode message = com.neeve.aep.test.unit.generated.xbuf.Message.create();
                    message.setMessageBus("aeptest1");
                    message.setMessageChannel("channel1");
                    this.engine.sendMessage(this.app.channel1, (IRogMessage)message);
                    continue block5;
                }
                default: {
                    throw new UnsupportedOperationException((Object)((Object)this.encoding) + " encoding is not supported in this test");
                }
            }
        }
    }

    private AepEngine createEngine() throws Exception {
        AepEngine engine = this.createEngine(this.appName, AepEngine.HAPolicy.StateReplication, AepEngine.InboundMessageLoggingPolicy.Off, AepEngine.OutboundMessageLoggingPolicy.Off, true, true, 15, 1, this.app, null, new IAepApplicationStateFactory(){

            @Override
            public IRogNode createState(MessageView message) throws Exception {
                switch (AepEngineLogRestartTest.this.encoding) {
                    case Json: {
                        return com.neeve.aep.test.unit.generated.json.Repository.create();
                    }
                    case Proto: {
                        return Repository.create();
                    }
                    case Xbuf: {
                        return com.neeve.aep.test.unit.generated.xbuf.Repository.create();
                    }
                }
                throw new UnsupportedOperationException((Object)((Object)AepEngineLogRestartTest.this.encoding) + " encoding is not supported in this test");
            }
        }, new AepEngineTest.BaseEngineCusomizer(){

            @Override
            public void customizeStore(StoreDescriptor descriptor) {
                descriptor.setCheckpointingType(IStoreCheckpointingController.Type.CDC);
                descriptor.setCheckpointThreshold(99);
                descriptor.setCheckpointMaxInterval(500L);
            }

            @Override
            public void customizePersister(StorePersisterDescriptor descriptor) {
                descriptor.setProperty("cdcEnabled", "true");
            }

            @Override
            public void customizeEngine(AepEngineDescriptor descriptor) {
                descriptor.setAdaptiveCommitBatchCeiling(1);
            }
        });
        switch (this.encoding) {
            case Json: {
                engine.registerFactory(new com.neeve.aep.test.unit.generated.json.Factory());
                break;
            }
            case Proto: {
                engine.registerFactory(new com.neeve.aep.test.unit.generated.proto.Factory());
                break;
            }
            case Xbuf: {
                engine.registerFactory(new Factory());
                break;
            }
            default: {
                throw new UnsupportedOperationException((Object)((Object)this.encoding) + " encoding is not supported in this test");
            }
        }
        if (this.app instanceof AepEngineLogRestartTestApp) {
            ((AepEngineLogRestartTestApp)this.app).engine = engine;
        }
        if (this.app instanceof AepEngineLogTestApp) {
            ((AepEngineLogTestApp)this.app).engine = engine;
        }
        engine.start();
        engine.waitForMessagingToStart();
        return engine;
    }

    private final void waitForEngineToStop(AepEngine engine) throws InterruptedException {
        int tries = 0;
        while (engine.getState() != AepEngine.State.Stopped) {
            Thread.sleep(1000L);
            if (tries > 50) {
                System.out.println("Waiting for engine to stop...");
            }
            ++tries;
        }
        if (engine.getState() != AepEngine.State.Stopping) {
            engine.stop();
        }
        if (engine.getState() != AepEngine.State.Stopped) {
            Assert.fail((String)"Failed to stop engine");
        }
    }

    @Ignore
    @Test
    public void testRestartWithObjectRemove() throws Exception {
        this.appName = ((Object)((Object)this)).getClass().getSimpleName() + System.currentTimeMillis();
        this.app = new AepEngineLogRestartTestApp();
        this.engine = this.createEngine();
        this.sendMessages(5);
        this.waitForEngineToStop(this.engine);
        this.engine = this.createEngine();
        this.sendMessages(2);
        this.waitForEngineToStop(this.engine);
        this.engine = this.createEngine();
    }

    @Ignore
    @Test
    public void testRestartAndCompactWithObjectRemove() throws Exception {
        this.appName = ((Object)((Object)this)).getClass().getSimpleName() + System.currentTimeMillis();
        this.app = new AepEngineLogRestartTestApp();
        this.engine = this.createEngine();
        RogLog log = (RogLog)this.engine.getStore().getPersister();
        this.sendMessages(5);
        this.waitForEngineToStop(this.engine);
        log.open();
        log.getCompactor().compact().waitForCompactionToComplete();
        log.close();
        this.engine = this.createEngine();
        this.sendMessages(2);
        this.waitForEngineToStop(this.engine);
        this.engine = this.createEngine();
    }

    @Test
    public void testRestartAndCompact() throws Exception {
        this.appName = ((Object)((Object)this)).getClass().getSimpleName() + System.currentTimeMillis();
        this.app = new AepEngineLogTestApp();
        this.engine = this.createEngine();
        RogLog log = (RogLog)this.engine.getStore().getPersister();
        this.sendMessages(9);
        while (this.engine.getStats().getNumCommitsCompleted() <= 9L) {
            Thread.sleep(100L);
        }
        this.sendMessages(1);
        while (this.engine.getStats().getNumCommitsCompleted() <= 10L) {
            Thread.sleep(100L);
        }
        Thread.sleep(1000L);
        this.engine.stop();
        log = RogLogFactory.createLog((String)log.getName());
        log.open();
        log.getCompactor().compact().waitForCompactionToComplete();
        log.close();
        this.engine = this.createEngine();
        this.sendMessages(10);
        this.app.waitForMessageReceipt(20);
        this.engine.stop();
        this.waitForEngineToStop(this.engine);
        this.engine = this.createEngine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestartAfterTLTRewrite() throws Exception {
        this.appName = this.testcaseName.getMethodName();
        this.app = new AepEngineLogTestApp();
        this.engine = this.createEngine();
        RogLog log = (RogLog)this.engine.getStore().getPersister();
        this.sendMessages(9);
        while (this.engine.getStats().getNumCommitsCompleted() <= 9L) {
            Thread.sleep(100L);
        }
        this.sendMessages(1);
        while (this.engine.getStats().getNumCommitsCompleted() <= 10L) {
            Thread.sleep(100L);
        }
        File logFile = log.getLogFile();
        Thread.sleep(1000L);
        this.engine.stop();
        System.out.println("Testing tlt rewrite...");
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java");
        cmd.add("-DNVROOT=" + System.getProperty("NVROOT"));
        cmd.add("-Djansi.strip=true");
        cmd.add("-Dnv.console.jline.disable=true");
        cmd.add("-classpath");
        cmd.add(System.getProperty("java.class.path"));
        cmd.add(TransactionLogTool.class.getName());
        try (ProcessWrapper pw = ProcessWrapper.launch(cmd, (File)logFile.getParentFile());){
            pw.setOutputEchoEnabled(true);
            pw.waitForOutputAndQuiesence(1000L, 5000L);
            Assert.assertEquals((String)"Unexpected error output", (Object)"", (Object)pw.getErrorOutput());
            pw.markOutputPosistions();
            pw.writeLn("set stacktraces on");
            pw.waitForOutputAndQuiesence(1000L, 5000L);
            pw.markOutputPosistions();
            pw.writeLn("open " + logFile.getName());
            pw.writeLn("list open");
            if (!pw.waitForOutputAndQuiesence(1000L, 20000L, "There are 1 open logs")) {
                Assert.fail((String)"Log file failed to open");
            }
            pw.writeLn("select entryType, simpleClassName, id, parentId, transactionId from logs where transactionId != 4");
            pw.writeLn("next 100");
            if (!pw.waitForOutputAndQuiesence(1000L, 20000L, "No more results")) {
                Assert.fail((String)"Log file failed to open");
            }
            pw.writeLn("rewrite " + logFile.getParentFile() + File.separator + "repaired");
            if (!pw.waitForOutputAndQuiesence(1000L, 20000L, "Flushing and closing rewritten log")) {
                Assert.fail((String)"Failed to rewrite log");
            }
            pw.markOutputPosistions();
            pw.writeLn("exit");
            pw.waitForOutputAndQuiesence(1000L, 5000L);
        }
        UtlFile.copyDirectory((File)logFile.getParentFile(), (File)new File(logFile.getParentFile(), "repaired"), (FilenameFilter)new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return true;
            }
        }, (boolean)false);
        this.engine = this.createEngine();
        this.sendMessages(10);
        this.app.waitForCommitCompletions(this.engine, 19, 5L);
        this.app.waitForCommitCompletions(this.engine, 20, 1L);
        Assert.assertEquals((String)"Message was not filtered during repair", (long)19L, (long)this.engine.getStats().getNumCommitsCompleted());
        this.engine.stop();
        this.waitForEngineToStop(this.engine);
    }

    @Ignore
    @Test
    public void testChangeDataCapture() throws Exception {
        int i;
        this.appName = ((Object)((Object)this)).getClass().getSimpleName() + System.currentTimeMillis();
        this.app = new AepEngineLogTestApp();
        this.engine = this.createEngine();
        IStorePersister persister = this.engine.getStore().getPersister();
        System.out.println(" >> >> Starting handler...");
        CDCHandler handler = new CDCHandler(persister.getName());
        handler.start();
        System.out.println(" >> >> Sending messages batch 1...");
        this.sendMessages(100);
        while (this.engine.getStats().getNumCommitsCompleted() <= 100L) {
            Thread.sleep(100L);
        }
        System.out.println(" >> >> Sending messages batch 2...");
        this.sendMessages(100);
        while (this.engine.getStats().getNumCommitsCompleted() <= 200L) {
            Thread.sleep(100L);
        }
        System.out.println(" >> >> Sending messages batch 3 - time delayed...");
        for (i = 0; i < 4; ++i) {
            Thread.sleep(200L);
            this.sendMessages(2);
        }
        System.out.println(" >> >> Sending messages batch 4...");
        this.sendMessages(100);
        while (this.engine.getStats().getNumCommitsCompleted() <= 308L) {
            Thread.sleep(100L);
        }
        System.out.println(" >> >> Sending messages batch 5...");
        this.sendMessages(100);
        while (this.engine.getStats().getNumCommitsCompleted() <= 408L) {
            Thread.sleep(100L);
        }
        System.out.println("Waiting for CDC...");
        for (i = 0; i < 5; ++i) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                System.out.println(" >> >> --interrupted - stopping handler...");
                break;
            }
            this.sendMessages(1);
        }
        System.out.println(" >> >> Wait complete, exiting...");
        handler.stop();
        this.engine.stop();
    }

    private final class CDCHandler
    implements IRogChangeDataCaptureHandler,
    Runnable {
        int numChanges = 0;
        private Thread thread;
        private String logName;
        private RogLog log;
        private RogLogCdcProcessor processor;

        CDCHandler(String logName) throws OdsException {
            this.logName = logName;
        }

        public void start() throws Exception {
            Properties props = new Properties();
            props.setProperty("detachedPersist", "false");
            props.setProperty("storeRoot", XRuntime.getDataDirectory());
            props.setProperty("autoRepair", "false");
            props.setProperty("logMode", "r");
            this.log = RogLog.create((String)this.logName, (Properties)props);
            this.log.open();
            this.processor = this.log.createCdcProcessor((IRogChangeDataCaptureHandler)this);
            this.thread = new Thread((Runnable)this, "CDCHandler");
            this.thread.start();
        }

        public void shutdown() {
            this.processor.close();
        }

        public void stop() throws InterruptedException {
            this.shutdown();
            Thread.sleep(110L);
            this.thread.interrupt();
            this.thread.join();
            this.log.close();
        }

        @Override
        public void run() {
            try {
                System.out.println(" = = = ** =HANDLER - calling CDC...");
                this.processor.run();
                System.out.println(" = = = ** =HANDLER - exit from CDC...");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public final void onLogStart(int logNumber) {
        }

        public final void onCheckpointStart(long checkpointVersion) {
        }

        public boolean handleChange(UUID objectId, IRogChangeDataCaptureHandler.ChangeType changeType, List<IRogNode> entries) {
            IRogNode object = entries.get(0);
            System.out.println(" = = = ** =" + this.numChanges++ + " HANDLER GOT " + (object != null ? object.getClass().getSimpleName() : "null") + "[" + objectId + "] " + changeType + " (" + entries.size() + " changes)");
            return true;
        }

        public final boolean onCheckpointComplete(long checkpointVersion) {
            return true;
        }

        public final void onWait() {
        }

        public final void onLogComplete(int logNumber, IRogChangeDataCaptureHandler.LogCompletionReason reason, Throwable errorCause) {
        }
    }
}

