/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.IAepEnvironmentProvider;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.event.AepChannelUpEvent;
import com.neeve.aep.event.AepEngineStoppedEvent;
import com.neeve.aep.event.AepMessagingStartedEvent;
import com.neeve.aep.test.unit.generated.proto.Message;
import com.neeve.sma.MessageChannel;
import java.nio.ByteBuffer;

public final class AepEngineEnvironmentProviderTestApp
implements IAepEnvironmentProvider {
    MessageChannel channel1;
    IAepEnvironmentProvider.BufferManager bufferManager;
    int setBufferManagerCalled;
    int transactionStartCalled;
    int transactionEndCalled;
    int closeCalled;
    ByteBuffer buffer;
    IAepEnvironmentProvider.TransactionAction action;
    boolean messagingStarted;
    Object messagingStartedSynchronizer = new Object();
    boolean messagingStartReleased;
    Object messagingStartReleaseSynchronizer = new Object();
    int numMessagesReceived;
    Object messageReceiptSynchronizer = new Object();
    boolean[] messageHandlerReleased;
    Object messageHandlerReleaseSynchronizer = new Object();
    boolean blockInMessageHandler = true;
    boolean engineStopped;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForMessagingStartedEvent() {
        Object object = this.messagingStartedSynchronizer;
        synchronized (object) {
            long startTime = System.currentTimeMillis();
            long remainingTime = 10000L;
            while (!this.messagingStarted && remainingTime > 0L) {
                try {
                    this.messagingStartedSynchronizer.wait(remainingTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                remainingTime = 10000L - (System.currentTimeMillis() - startTime);
            }
            return this.messagingStarted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseFromMessagingStart() {
        Object object = this.messagingStartReleaseSynchronizer;
        synchronized (object) {
            this.messagingStartReleased = true;
            this.messagingStartReleaseSynchronizer.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForMessageReceipt(int count) {
        Object object = this.messageReceiptSynchronizer;
        synchronized (object) {
            long startTime = System.currentTimeMillis();
            long remainingTime = 10000L;
            while (this.numMessagesReceived <= count && remainingTime > 0L) {
                try {
                    this.messageReceiptSynchronizer.wait(remainingTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                remainingTime = 10000L - (System.currentTimeMillis() - startTime);
            }
            return this.numMessagesReceived > count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseFromMessageHandler() {
        Object object = this.messageHandlerReleaseSynchronizer;
        synchronized (object) {
            this.messageHandlerReleased[this.numMessagesReceived - 1] = true;
            this.messageHandlerReleaseSynchronizer.notifyAll();
        }
    }

    final boolean waitForEngineStopped() {
        for (int i = 0; i < 10; ++i) {
            if (!this.engineStopped) {
                System.out.println("Engine not stopped");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public void setBufferManager(IAepEnvironmentProvider.BufferManager bufferManager) {
        ++this.setBufferManagerCalled;
        this.bufferManager = bufferManager;
    }

    @Override
    public void onTransactionStart(ByteBuffer buffer, IAepEnvironmentProvider.TransactionAction action) {
        ++this.transactionStartCalled;
        this.buffer = buffer;
        this.action = action;
    }

    @Override
    public void onTransactionEnd() {
        ++this.transactionEndCalled;
        this.buffer = null;
    }

    @Override
    public void close() {
        ++this.closeCalled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    public void onMessagingStarted(AepMessagingStartedEvent event) {
        Object object = this.messagingStartedSynchronizer;
        synchronized (object) {
            this.messagingStarted = true;
            this.messagingStartedSynchronizer.notifyAll();
        }
        object = this.messagingStartReleaseSynchronizer;
        synchronized (object) {
            while (!this.messagingStartReleased) {
                try {
                    this.messagingStartReleaseSynchronizer.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    @EventHandler(source="channel1@aeptest1")
    public void onChannel1UpEventHandler(AepChannelUpEvent event) {
        this.channel1 = event.getMessageChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    public void onChannel1ProtoMessageHandler(Message message) {
        Object object = this.messageReceiptSynchronizer;
        synchronized (object) {
            ++this.numMessagesReceived;
            this.messageReceiptSynchronizer.notifyAll();
        }
        object = this.messageHandlerReleaseSynchronizer;
        synchronized (object) {
            while (this.blockInMessageHandler && !this.messageHandlerReleased[this.numMessagesReceived - 1]) {
                try {
                    this.messageHandlerReleaseSynchronizer.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    @EventHandler
    public void onEngineStopped(AepEngineStoppedEvent event) {
        this.engineStopped = true;
    }
}

