/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.test.unit;

import com.neeve.aep.AepEngine;
import com.neeve.aep.AepEngineDescriptor;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStorePersister;
import com.neeve.test.UnitTest;
import org.junit.Assert;
import org.junit.Test;

public class AepEngineDescriptorTest
extends UnitTest {
    @Test(expected=IllegalStateException.class)
    public void testTransactionCommitSuspensionWithStateReplication1() throws Exception {
        AepEngineDescriptor descriptor = AepEngineDescriptor.create("test");
        descriptor.setHAPolicy(AepEngine.HAPolicy.StateReplication).setEnableTransactionCommitSuspension(true);
    }

    @Test(expected=IllegalStateException.class)
    public void testTransactionCommitSuspensionWithStateReplication2() throws Exception {
        AepEngineDescriptor descriptor = AepEngineDescriptor.create("test");
        descriptor.setHAPolicy(AepEngine.HAPolicy.EventSourcing);
        descriptor.setEnableTransactionCommitSuspension(true).setHAPolicy(AepEngine.HAPolicy.StateReplication);
    }

    @Test(expected=IllegalStateException.class)
    public void testTransactionCommitSuspensionWithClustering1() throws Exception {
        AepEngineDescriptor descriptor = AepEngineDescriptor.create("test");
        descriptor.setHAPolicy(AepEngine.HAPolicy.EventSourcing);
        descriptor.setStore("test").setEnableTransactionCommitSuspension(true);
    }

    @Test(expected=IllegalStateException.class)
    public void testTransactionCommitSuspensionWithClustering2() throws Exception {
        AepEngineDescriptor descriptor = AepEngineDescriptor.create("test");
        descriptor.setHAPolicy(AepEngine.HAPolicy.EventSourcing);
        descriptor.setEnableTransactionCommitSuspension(true).setStore("test");
    }

    @Test(expected=IllegalStateException.class)
    public void testTransactionCommitSuspensionWithAdaptiveCommitBatching1() throws Exception {
        AepEngineDescriptor descriptor = AepEngineDescriptor.create("test");
        descriptor.setHAPolicy(AepEngine.HAPolicy.EventSourcing);
        descriptor.setAdaptiveCommitBatchCeiling(1).setEnableTransactionCommitSuspension(true);
    }

    @Test(expected=IllegalStateException.class)
    public void testTransactionCommitSuspensionWithAdaptiveBatching2() throws Exception {
        AepEngineDescriptor descriptor = AepEngineDescriptor.create("test");
        descriptor.setHAPolicy(AepEngine.HAPolicy.EventSourcing);
        descriptor.setEnableTransactionCommitSuspension(true).setAdaptiveCommitBatchCeiling(1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testQuarantineChannelInvalidFormat() throws Exception {
        AepEngineDescriptor descriptor = AepEngineDescriptor.create("test");
        descriptor.setQuarantineChannel("stringwithoutatsymbol");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullAppExceptionHandlingPolicy() throws Exception {
        AepEngineDescriptor descriptor = AepEngineDescriptor.create("test");
        descriptor.setAppExceptionHandlingPolicy(null);
    }

    public void testReplicateSolicitedSendsDefault() throws Exception {
        Assert.assertTrue((boolean)AepEngineDescriptor.create("test").getReplicateSolicitedSends());
    }

    public void testReplicateUnsolicitedSendsDefault() throws Exception {
        Assert.assertFalse((boolean)AepEngineDescriptor.create("test").getReplicateUnsolicitedSends());
    }

    @Test(expected=IllegalStateException.class)
    public void testReplicateUnsolicitedSendsWithEventSourcing1() throws Exception {
        AepEngineDescriptor descriptor = AepEngineDescriptor.create("test");
        descriptor.setHAPolicy(AepEngine.HAPolicy.EventSourcing).setReplicateUnsolicitedSends(true);
    }

    @Test(expected=IllegalStateException.class)
    public void testReplicateUnsolicitedSendsWithEventSourcing2() throws Exception {
        AepEngineDescriptor descriptor = AepEngineDescriptor.create("test");
        descriptor.setHAPolicy(AepEngine.HAPolicy.StateReplication);
        descriptor.setReplicateUnsolicitedSends(true).setHAPolicy(AepEngine.HAPolicy.EventSourcing);
    }

    @Test(expected=IllegalStateException.class)
    public void testReplicateUnsolicitedSendsWithNoReplicateSolicitedSends1() throws Exception {
        AepEngineDescriptor descriptor = AepEngineDescriptor.create("test");
        descriptor.setReplicateUnsolicitedSends(true).setReplicateSolicitedSends(false);
    }

    @Test(expected=IllegalStateException.class)
    public void testReplicateUnsolicitedSendsWithNoReplicateSolicitedSends2() throws Exception {
        AepEngineDescriptor descriptor = AepEngineDescriptor.create("test");
        descriptor.setReplicateSolicitedSends(false).setReplicateUnsolicitedSends(true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddChannelWithDescriptorWithAmpBeforeAt() throws Exception {
        AepEngineDescriptor descriptor = AepEngineDescriptor.create("test");
        descriptor.addChannel("channel&name@busName");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddChannelWithDescriptorEndingWithAmp() throws Exception {
        AepEngineDescriptor descriptor = AepEngineDescriptor.create("test");
        descriptor.addChannel("channel@bus&");
    }

    @Test
    public void testGetBusesOnAfreshDescriptor() throws Exception {
        AepEngineDescriptor descriptor = AepEngineDescriptor.create("test");
        Assert.assertEquals((long)0L, (long)descriptor.getBuses().size());
    }

    @Test
    public void testAddBusViaDescriptorUsingNullChannelName() throws Exception {
        AepEngineDescriptor descriptor = AepEngineDescriptor.create("test");
        descriptor.addChannel("null@bus");
        Assert.assertEquals((long)1L, (long)descriptor.getBuses().size());
        Assert.assertEquals((long)0L, (long)descriptor.getChannels("bus").size());
    }

    @Test
    public void testRemoveBusViaDescriptorUsingNullChannelName() throws Exception {
        AepEngineDescriptor descriptor = AepEngineDescriptor.create("test");
        descriptor.addChannel("null@bus").removeChannel("null@bus");
        Assert.assertEquals((long)0L, (long)descriptor.getBuses().size());
    }

    @Test
    public void testAddBusViaDescriptorUsingNoChannelName() throws Exception {
        AepEngineDescriptor descriptor = AepEngineDescriptor.create("test");
        descriptor.addChannel("@bus");
        Assert.assertEquals((long)1L, (long)descriptor.getBuses().size());
        Assert.assertEquals((long)0L, (long)descriptor.getChannels("bus").size());
    }

    @Test
    public void testRemoveBusViaDescriptorUsingNoChannelName() throws Exception {
        AepEngineDescriptor descriptor = AepEngineDescriptor.create("test");
        descriptor.addChannel("@bus").removeChannel("@bus");
        Assert.assertEquals((long)0L, (long)descriptor.getBuses().size());
    }

    @Test
    public void testAddGlobalBusViaDescriptorUsingNullChannelName() throws Exception {
        AepEngineDescriptor descriptor = AepEngineDescriptor.create("test");
        descriptor.addChannel("null");
        Assert.assertEquals((long)1L, (long)descriptor.getBuses().size());
        Assert.assertEquals((long)0L, (long)descriptor.getChannels("$global$").size());
    }

    @Test
    public void testRemoveGlobalBusViaDescriptorUsingNullChannelName() throws Exception {
        AepEngineDescriptor descriptor = AepEngineDescriptor.create("test");
        descriptor.addChannel("null").removeChannel("null");
        Assert.assertEquals((long)0L, (long)descriptor.getBuses().size());
    }

    @Test
    public void testAddGlobalBusViaDescriptorUsingNoChannelName() throws Exception {
        AepEngineDescriptor descriptor = AepEngineDescriptor.create("test");
        descriptor.addChannel("");
        Assert.assertEquals((long)1L, (long)descriptor.getBuses().size());
        Assert.assertEquals((long)0L, (long)descriptor.getChannels("$global$").size());
    }

    @Test
    public void testRemoveGlobalBusViaDescriptorUsingNoChannelName() throws Exception {
        AepEngineDescriptor descriptor = AepEngineDescriptor.create("test");
        descriptor.addChannel("").removeChannel("");
        Assert.assertEquals((long)0L, (long)descriptor.getBuses().size());
    }

    @Test
    public void testAddGlobalChannelViaDescriptor() throws Exception {
        AepEngineDescriptor descriptor = AepEngineDescriptor.create("test");
        descriptor.addChannel("channel");
        Assert.assertEquals((long)1L, (long)descriptor.getBuses().size());
        Assert.assertEquals((long)1L, (long)descriptor.getChannels("$global$").size());
        Assert.assertFalse((boolean)descriptor.getChannels("$global$").get("channel").getShouldJoin());
    }

    @Test
    public void testRemoveGlobalChannelViaDescriptor() throws Exception {
        AepEngineDescriptor descriptor = AepEngineDescriptor.create("test");
        descriptor.addChannel("channel").removeChannel("channel");
        Assert.assertEquals((long)0L, (long)descriptor.getBuses().size());
        Assert.assertNull(descriptor.getChannels("$global$"));
    }

    @Test
    public void testAddGlobalChannelViaDescriptorWithJoinFalse() throws Exception {
        AepEngineDescriptor descriptor = AepEngineDescriptor.create("test");
        descriptor.addChannel("channel&join=false");
        Assert.assertEquals((long)1L, (long)descriptor.getBuses().size());
        Assert.assertEquals((long)1L, (long)descriptor.getChannels("$global$").size());
        Assert.assertFalse((boolean)descriptor.getChannels("$global$").get("channel").getShouldJoin());
    }

    @Test
    public void testAddGlobalChannelViaDescriptorWithJoinTrue() throws Exception {
        AepEngineDescriptor descriptor = AepEngineDescriptor.create("test");
        descriptor.addChannel("channel&join=true");
        Assert.assertEquals((long)1L, (long)descriptor.getBuses().size());
        Assert.assertEquals((long)1L, (long)descriptor.getChannels("$global$").size());
        Assert.assertTrue((boolean)descriptor.getChannels("$global$").get("channel").getShouldJoin());
    }

    @Test
    public void testAddBusSpecificChannelViaDescriptor() throws Exception {
        AepEngineDescriptor descriptor = AepEngineDescriptor.create("test");
        descriptor.addChannel("channel@bus");
        Assert.assertEquals((long)1L, (long)descriptor.getBuses().size());
        Assert.assertEquals((long)1L, (long)descriptor.getChannels("bus").size());
        Assert.assertFalse((boolean)descriptor.getChannels("bus").get("channel").getShouldJoin());
    }

    @Test
    public void testRemoveBusSpecificChannelViaDescriptor() throws Exception {
        AepEngineDescriptor descriptor = AepEngineDescriptor.create("test");
        descriptor.addChannel("channel@bus").removeChannel("channel@bus");
        Assert.assertEquals((long)0L, (long)descriptor.getBuses().size());
        Assert.assertNull(descriptor.getChannels("bus"));
    }

    @Test
    public void testAddBusSpecificChannelViaDescriptorWithJoinFalse() throws Exception {
        AepEngineDescriptor descriptor = AepEngineDescriptor.create("test");
        descriptor.addChannel("channel@bus&join=false");
        Assert.assertEquals((long)1L, (long)descriptor.getBuses().size());
        Assert.assertEquals((long)1L, (long)descriptor.getChannels("bus").size());
        Assert.assertFalse((boolean)descriptor.getChannels("bus").get("channel").getShouldJoin());
    }

    @Test
    public void testAddBusSpecificChannelViaDescriptorWithJoinTrue() throws Exception {
        AepEngineDescriptor descriptor = AepEngineDescriptor.create("test");
        descriptor.addChannel("channel@bus&join=true");
        Assert.assertEquals((long)1L, (long)descriptor.getBuses().size());
        Assert.assertEquals((long)1L, (long)descriptor.getChannels("bus").size());
        Assert.assertTrue((boolean)descriptor.getChannels("bus").get("channel").getShouldJoin());
    }

    @Test
    public void testSetRoleStartupExpectation() throws Exception {
        AepEngineDescriptor descriptor = AepEngineDescriptor.create("test");
        Assert.assertNull(descriptor.getStartupExpectation(AepEngine.StartupExpectation.Role));
        descriptor.save();
        try {
            Assert.assertNull(AepEngineDescriptor.load("test").getStartupExpectation(AepEngine.StartupExpectation.Role));
        }
        finally {
            descriptor.delete();
        }
        descriptor.setStartupExpectation(AepEngine.StartupExpectation.Role, (Enum<?>)IStoreBinding.Role.Primary);
        Assert.assertEquals((Object)IStoreBinding.Role.Primary, descriptor.getStartupExpectation(AepEngine.StartupExpectation.Role));
        Assert.assertEquals((Object)IStoreBinding.Role.Primary, descriptor.getStartupExpectations().get((Object)AepEngine.StartupExpectation.Role));
        descriptor.save();
        try {
            Assert.assertEquals((Object)IStoreBinding.Role.Primary, AepEngineDescriptor.load("test").getStartupExpectation(AepEngine.StartupExpectation.Role));
        }
        finally {
            descriptor.delete();
        }
    }

    @Test
    public void testSetLogEmptinessStartupExpectation() throws Exception {
        AepEngineDescriptor descriptor = AepEngineDescriptor.create("test");
        Assert.assertNull(descriptor.getStartupExpectation(AepEngine.StartupExpectation.LogEmptiness));
        descriptor.save();
        try {
            Assert.assertNull(AepEngineDescriptor.load("test").getStartupExpectation(AepEngine.StartupExpectation.LogEmptiness));
        }
        finally {
            descriptor.delete();
        }
        descriptor.setStartupExpectation(AepEngine.StartupExpectation.LogEmptiness, (Enum<?>)IStorePersister.LogEmptinessExpectation.Empty);
        Assert.assertEquals((Object)IStorePersister.LogEmptinessExpectation.Empty, descriptor.getStartupExpectation(AepEngine.StartupExpectation.LogEmptiness));
        Assert.assertEquals((Object)IStorePersister.LogEmptinessExpectation.Empty, descriptor.getStartupExpectations().get((Object)AepEngine.StartupExpectation.LogEmptiness));
        descriptor.save();
        try {
            Assert.assertEquals((Object)IStorePersister.LogEmptinessExpectation.Empty, AepEngineDescriptor.load("test").getStartupExpectation(AepEngine.StartupExpectation.LogEmptiness));
        }
        finally {
            descriptor.delete();
        }
    }

    @Test
    public void testSetLogNotEmptyStartupExpectation() throws Exception {
        AepEngineDescriptor descriptor = AepEngineDescriptor.create("test");
        Assert.assertNull(descriptor.getStartupExpectation(AepEngine.StartupExpectation.LogEmptiness));
        descriptor.save();
        try {
            Assert.assertNull(AepEngineDescriptor.load("test").getStartupExpectation(AepEngine.StartupExpectation.LogEmptiness));
        }
        finally {
            descriptor.delete();
        }
        descriptor.setStartupExpectation(AepEngine.StartupExpectation.LogEmptiness, (Enum<?>)IStorePersister.LogEmptinessExpectation.NotEmpty);
        Assert.assertEquals((Object)IStorePersister.LogEmptinessExpectation.NotEmpty, descriptor.getStartupExpectation(AepEngine.StartupExpectation.LogEmptiness));
        Assert.assertEquals((Object)IStorePersister.LogEmptinessExpectation.NotEmpty, descriptor.getStartupExpectations().get((Object)AepEngine.StartupExpectation.LogEmptiness));
        descriptor.save();
        try {
            Assert.assertEquals((Object)IStorePersister.LogEmptinessExpectation.NotEmpty, AepEngineDescriptor.load("test").getStartupExpectation(AepEngine.StartupExpectation.LogEmptiness));
        }
        finally {
            descriptor.delete();
        }
    }
}

