/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep;

import com.neeve.aep.mon.txnstats.AepMonOutboundMessageTimings;
import com.neeve.event.Event;
import com.neeve.event.EventFactory;
import com.neeve.event.IEventSource;
import com.neeve.rog.IRogMessage;
import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.event.MessageStabilityEvent;
import com.neeve.util.UtlList;
import com.neeve.util.UtlListElement;
import com.neeve.util.UtlPlist;
import com.neeve.util.UtlTime;
import java.util.Properties;

public final class AepSendCommitCompletionEvent
extends Event {
    private final UtlList stabilityEvents = UtlList.create();
    private final UtlPlist<AepMonOutboundMessageTimings> sendTimings = UtlPlist.create();
    private boolean includeStabilityEvents;
    private boolean captureTimings;
    private int stabilizedMessageCount;
    private long meanOutTs;
    private int meanOutTsMsgCount;
    private Exception status;

    private AepSendCommitCompletionEvent() {
        super((short)506);
    }

    public static Event create(Properties props) {
        return new AepSendCommitCompletionEvent();
    }

    public static AepSendCommitCompletionEvent create(MessageBusBinding binding, boolean includeStabilityEvents, boolean captureTimings) {
        return ((AepSendCommitCompletionEvent)EventFactory.getInstance().createEvent((short)506)).init(binding, includeStabilityEvents, captureTimings);
    }

    private final AepSendCommitCompletionEvent init(MessageBusBinding binding, boolean includeStabilityEvents, boolean captureTimings) {
        super.init((IEventSource)binding, null);
        this.includeStabilityEvents = includeStabilityEvents;
        this.captureTimings = captureTimings;
        this.status = null;
        return this;
    }

    protected final void reset() {
        this.meanOutTs = 0L;
        this.meanOutTsMsgCount = 0;
        this.stabilizedMessageCount = 0;
        this.stabilityEvents.clear();
        this.status = null;
        if (this.sendTimings.count() > 0) {
            while (this.sendTimings.count() > 0) {
                UtlPlist.Element first = this.sendTimings.first();
                ((AepMonOutboundMessageTimings)first.getObject()).dispose();
                this.sendTimings.remove(first);
            }
        }
    }

    public final void onMessageSend(IRogMessage message) {
        long ts = message.getPreWireTs();
        if (ts > 0L) {
            this.meanOutTs = ((long)this.meanOutTsMsgCount * this.meanOutTs + ts) / (long)(++this.meanOutTsMsgCount);
        }
        if (this.captureTimings) {
            AepMonOutboundMessageTimings timings = AepMonOutboundMessageTimings.create();
            timings.setTransactionInSequenceNumber(message.getTransactionInSequenceNumber());
            timings.setTransactionOutSequenceNumber(message.getTransactionOutSequenceNumber());
            timings.setSMACreateTsMicros(message.getCreateTs());
            timings.setAEPSendEnterTsMicros(message.getAppSendBeginTs());
            timings.setAEPSendExitTsMicros(message.getAppSendDoneTs());
            timings.setAEPSendCommitTsMicros(message.getSendTs());
            timings.setSMASendStartTsMicros(message.getSendStartTs());
            timings.setSMAPreSerializeTsMicros(message.getPreSerializeTs());
            timings.setSMAPostSerializeTsMicros(message.getPostSerializeTs());
            timings.setSMAPreWireTsMicros(message.getPreWireTs());
            timings.setSMAPostWireTsMicros(message.getPostWireSendTs());
            timings.setSMASendEndTsMicros(UtlTime.now());
            this.sendTimings.append((Object)timings);
        }
    }

    public final long getMeanOutTs() {
        return this.meanOutTs;
    }

    public final void onMessageStability(MessageStabilityEvent event) {
        ++this.stabilizedMessageCount;
        if (event != null) {
            if (this.status == null && event.getStatus() != null) {
                this.status = event.getStatus();
            }
            if (this.includeStabilityEvents) {
                event.acquire();
                this.stabilityEvents.append((UtlListElement)event);
            }
        }
    }

    public final Exception getStatus() {
        return this.status;
    }

    public final int getStabilizedMessageCount() {
        return this.stabilizedMessageCount;
    }

    public final boolean includesStabilityEvents() {
        return this.includeStabilityEvents;
    }

    public final UtlList getStabilityEvents() {
        return this.stabilityEvents;
    }

    final UtlPlist<AepMonOutboundMessageTimings> getTimings() {
        return this.sendTimings;
    }
}

