/*
 * Decompiled with CFR 0.152.
 */
package com.mdimension.jchronic.tags;

import com.mdimension.jchronic.Options;
import com.mdimension.jchronic.tags.Pointer;
import com.mdimension.jchronic.tags.Scalar;
import com.mdimension.jchronic.utils.Token;
import java.util.regex.Pattern;

public class ScalarYear
extends Scalar {
    public static final Pattern YEAR_PATTERN = Pattern.compile("^([1-9]\\d)?\\d\\d?$");

    public ScalarYear(Integer type) {
        super(type);
    }

    @Override
    public String toString() {
        return super.toString() + "-year-" + this.getType();
    }

    public static ScalarYear scan(Token token, Token postToken, Options options) {
        if (YEAR_PATTERN.matcher(token.getWord()).matches()) {
            int scalarValue = Integer.parseInt(token.getWord());
            if (postToken == null || !Scalar.TIMES.contains(postToken.getWord())) {
                Pointer.PointerType context = options.getContext();
                switch (context) {
                    case NONE: {
                        if (scalarValue <= 37) {
                            scalarValue += 2000;
                            break;
                        }
                        if (scalarValue > 137 || scalarValue < 69) break;
                        scalarValue += 1900;
                        break;
                    }
                    case PAST: {
                        if (scalarValue <= 19) {
                            scalarValue += 2000;
                            break;
                        }
                        if (scalarValue <= 99) {
                            scalarValue += 1900;
                            break;
                        }
                        if (scalarValue > 137) break;
                        scalarValue += 1900;
                        break;
                    }
                    case FUTURE: {
                        if (scalarValue <= 68) {
                            scalarValue += 2000;
                            break;
                        }
                        if (scalarValue > 137) break;
                        scalarValue += 1900;
                    }
                }
                return new ScalarYear(scalarValue);
            }
        }
        return null;
    }
}

