/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util;

import com.neeve.util.UtlConstants;
import com.neeve.util.UtlEnv;
import java.util.HashSet;
import java.util.concurrent.ConcurrentLinkedQueue;

public class UtlReferenceTracker {
    public static final boolean ENABLED;
    public static final boolean TYPE_TRACKING_ENABLED;
    private static final HashSet<String> ENABLED_TYPES;
    private static final int HISTORY_SIZE;
    private final Object item;
    private UtlReferenceTracker associatedTracker;
    private ConcurrentLinkedQueue<ConcurrentLinkedQueue<ReferenceRecord>> previousHistories = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<ReferenceRecord> history = new ConcurrentLinkedQueue();

    public UtlReferenceTracker(Object item) {
        this.item = item;
    }

    public final void onUndispose(int oldCount, int initCount) {
    }

    public final void onInit(int initCount) {
        if (this.history != null) {
            this.previousHistories.add(this.history);
        }
        this.history = new ConcurrentLinkedQueue();
        while (this.previousHistories.size() > HISTORY_SIZE) {
            this.previousHistories.remove();
        }
        this.history.add(new InitializationRecord(initCount));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onAcquire(int newCount) {
        this.history.add(new AcquisitionRecord(newCount));
        if (newCount <= 1) {
            UtlReferenceTracker utlReferenceTracker = this;
            synchronized (utlReferenceTracker) {
                this.dump();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onDispose(int newCount) {
        this.history.add(new DisposalRecord(newCount));
        if (newCount < 0) {
            UtlReferenceTracker utlReferenceTracker = this;
            synchronized (utlReferenceTracker) {
                this.dump();
            }
        }
    }

    public final void dump() {
        StringBuilder sb = new StringBuilder();
        this.dump(sb);
        System.err.println(sb);
    }

    public final void dump(StringBuilder sb) {
        UtlReferenceTracker associated = this.associatedTracker;
        sb.append("Reference History for ").append(this.item.getClass().getSimpleName()).append("@").append(this.item.hashCode()).append("\n");
        sb.append("   History:\n").append(this.history.toString());
        if (!this.previousHistories.isEmpty()) {
            sb.append("\nPrevious Histories:\n").append(this.previousHistories.toString());
        }
        if (associated != null) {
            sb.append("\n\nAssociacted Tracker History\n");
            associated.dump(sb);
        }
        sb.append("\n");
    }

    public void setAssociatedTracker(UtlReferenceTracker associatedTracker) {
        this.associatedTracker = associatedTracker;
    }

    public static boolean enabled(Class<?> type) {
        return ENABLED || !ENABLED_TYPES.isEmpty() && ENABLED_TYPES.contains(type.getName());
    }

    public static boolean enabled(String typeName) {
        return ENABLED || !ENABLED_TYPES.isEmpty() && ENABLED_TYPES.contains(typeName);
    }

    static {
        ENABLED_TYPES = new HashSet();
        boolean enabled = UtlEnv.getValue("nv.reftracking.enabled", false);
        String types = UtlEnv.getValue("nv.reftracking.types", UtlConstants.REFTRACKING_TYPES_DEFAULT);
        boolean allTypes = false;
        if (types != null) {
            for (String type : types.split("\\|")) {
                if (type.trim().equals("*")) {
                    allTypes = true;
                    break;
                }
                ENABLED_TYPES.add(type.trim());
            }
        }
        ENABLED = enabled || allTypes;
        TYPE_TRACKING_ENABLED = ENABLED || !ENABLED_TYPES.isEmpty();
        HISTORY_SIZE = UtlEnv.getValue("nv.reftracking.historysize", 5);
        if (ENABLED) {
            System.err.println("REFERENCE TRACKING IS ENABLED");
        } else if (!ENABLED_TYPES.isEmpty()) {
            System.err.println("REFERENCE TRACKING IS ENABLED FOR: " + ENABLED_TYPES);
        }
    }

    public static interface HasReferenceTracker {
        public UtlReferenceTracker referenceTracker();
    }

    private static final class DisposalRecord
    extends ReferenceRecord {
        protected DisposalRecord(int count) {
            super(count);
        }

        @Override
        public final String toString() {
            return "\nDISPOSE [" + (this.count + 1) + " -> " + this.count + "]" + super.toString();
        }
    }

    private static final class AcquisitionRecord
    extends ReferenceRecord {
        protected AcquisitionRecord(int count) {
            super(count);
        }

        @Override
        public final String toString() {
            return "\nACQUIRE [" + (this.count - 1) + " -> " + this.count + "]" + super.toString();
        }
    }

    private static final class InitializationRecord
    extends ReferenceRecord {
        protected InitializationRecord(int count) {
            super(count);
        }

        @Override
        public final String toString() {
            return "\nINIT [" + this.count + "]" + super.toString();
        }
    }

    private static abstract class ReferenceRecord {
        private final Exception stackHolder;
        final String threadName;
        protected final int count;

        protected ReferenceRecord(int count) {
            this.count = count;
            this.stackHolder = new Exception();
            this.threadName = Thread.currentThread().getName();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("\n");
            sb.append(this.threadName).append(":").append("\n");
            StackTraceElement[] stack = this.stackHolder.getStackTrace();
            for (int i = 3; i < stack.length; ++i) {
                sb.append("  ").append(stack[i].toString()).append("\n");
            }
            return sb.toString();
        }
    }
}

