/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools;

import com.neeve.trace.Tracer;
import jargs.gnu.CmdLineParser;
import java.io.ByteArrayInputStream;
import java.io.File;

public class ConfigTool
extends com.neeve.config.ConfigTool {
    private ConfigTool(String configDescriptor, boolean createRepo, Tracer.Level traceLevel) throws Exception {
        super(configDescriptor, createRepo, traceLevel);
    }

    private static void printUsage() {
        System.err.println("Usage ConfigTool [{-r, --repository} repository_descriptor ('default' for the default repository)] ");
        System.err.println("                 [{-c, --create} create repository]");
        System.err.println("                 [{-s, --script <script name>} run the tool from a script]");
        System.err.println("                 [{-y, --scriptify} scriptify the specified repo to the specified script name (script name must be specified and should not exist)]");
        System.err.println("                 [{-t, --trace <level>} the tool's initial trace level]");
        System.err.println("                 [{-h, --help} print this help string]");
    }

    public static void main(String[] args) {
        block15: {
            try {
                CmdLineParser parser = new CmdLineParser();
                CmdLineParser.Option repoDescriptorOption = parser.addStringOption('r', "repository");
                CmdLineParser.Option scriptNameOption = parser.addStringOption('s', "script");
                CmdLineParser.Option scriptifyOption = parser.addBooleanOption('y', "scriptify");
                CmdLineParser.Option createOption = parser.addBooleanOption('c', "create");
                CmdLineParser.Option traceLevelOption = parser.addStringOption('t', "trace");
                CmdLineParser.Option helpOption = parser.addBooleanOption('h', "help");
                try {
                    parser.parse(args);
                    if (!((Boolean)parser.getOptionValue(helpOption, (Object)false)).booleanValue()) {
                        String configDescriptor = (String)parser.getOptionValue(repoDescriptorOption, null);
                        boolean createRepo = (Boolean)parser.getOptionValue(createOption, (Object)false);
                        String scriptName = (String)parser.getOptionValue(scriptNameOption, null);
                        boolean scriptify = (Boolean)parser.getOptionValue(scriptifyOption, (Object)false);
                        File scriptFile = scriptName == null ? null : new File(scriptName);
                        String traceLevelStr = (String)parser.getOptionValue(traceLevelOption, (Object)"info");
                        Tracer.Level traceLevel = null;
                        try {
                            traceLevel = Tracer.getLevel((String)traceLevelStr);
                        }
                        catch (IllegalArgumentException e) {
                            System.err.println(e.toString());
                            ConfigTool.printUsage();
                        }
                        if (scriptFile == null || scriptFile.exists()) {
                            if (scriptify) {
                                if (scriptFile == null) {
                                    System.err.println("Script file must be specified with the scriptify (-y) option");
                                } else {
                                    System.err.println("Specified script file cannot exist when scriptifying the repo");
                                }
                            } else {
                                ConfigTool tool = new ConfigTool(configDescriptor, createRepo, traceLevel);
                                tool.getInteractiveTool().setEnvironmentSubstitutionEnabled(false);
                                tool.run(scriptFile);
                            }
                        } else if (scriptify) {
                            ConfigTool tool = new ConfigTool(configDescriptor, createRepo, traceLevel);
                            tool.getInteractiveTool().setEnvironmentSubstitutionEnabled(false);
                            String command = "repo_scriptify " + scriptFile.getAbsolutePath();
                            tool.run(new ByteArrayInputStream(command.getBytes("UTF-8")));
                        } else {
                            System.err.println("Cannot find script file '" + scriptFile + "'");
                        }
                        break block15;
                    }
                    ConfigTool.printUsage();
                }
                catch (CmdLineParser.OptionException e) {
                    System.err.println(e.getMessage());
                    ConfigTool.printUsage();
                }
            }
            catch (Throwable e) {
                System.out.println("Unhandled fault [" + e.toString() + "]");
                e.printStackTrace();
            }
        }
    }
}

