/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.io;

import com.neeve.io.IOBuffer;
import com.neeve.util.UtlBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class IOElasticBuffer {
    private static final ThreadLocal<StringBuilder> UTF_BUILDER = new ThreadLocal();
    private final Sizer owner;
    private final boolean isNative;
    private final int bufferLength;
    private final InputStreamImpl is;
    private final OutputStreamImpl os;
    private IOBuffer ioBuffer;
    private Initializer initializer;
    private int offset;
    private int length;
    private int capacity;
    private boolean copyOnWrite;
    private boolean failOnWrite;
    private int resumptionLength;
    private ByteOrder byteOrder;
    private boolean inCreateBackingBuffer;

    protected IOElasticBuffer(Sizer owner, int bufferLength, boolean isNative) {
        if (bufferLength <= 0 && owner == null) {
            throw new IllegalArgumentException("buffer length or buffer owner needs to be provided");
        }
        this.owner = owner;
        this.bufferLength = bufferLength;
        this.isNative = isNative;
        this.is = new InputStreamImpl();
        this.os = new OutputStreamImpl();
    }

    public static IOElasticBuffer create(Sizer sizer, int bufferLength, boolean isNative) {
        return new IOElasticBuffer(sizer, bufferLength, isNative);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IOBuffer createBackingBuffer(int length) {
        if (this.inCreateBackingBuffer) {
            throw new IllegalStateException("backing buffer creation invoked recursively!");
        }
        this.inCreateBackingBuffer = true;
        try {
            int allocLength = Math.max(length, this.resumptionLength > 0 ? this.resumptionLength : (this.bufferLength > 0 ? this.bufferLength : this.owner.getInitialBufferLength()));
            boolean replaceExisting = this.ioBuffer != null;
            this.ioBuffer = IOBuffer.create(allocLength, length, this.isNative);
            this.offset = 0;
            this.length = replaceExisting ? length : allocLength;
            this.resumptionLength = 0;
            this.capacity = this.ioBuffer.getCapacity();
            this.copyOnWrite = false;
            if (this.byteOrder != null) {
                this.ioBuffer.setByteOrder(this.byteOrder);
            }
            if (!replaceExisting && this.initializer != null) {
                this.initializer.initializeBuffer();
            }
            IOBuffer iOBuffer = this.ioBuffer;
            return iOBuffer;
        }
        finally {
            this.inCreateBackingBuffer = false;
        }
    }

    private final IOElasticBuffer setLength(int newLength, boolean fromPut) {
        if (newLength < 0) {
            throw new IllegalArgumentException("length cannot be < 0");
        }
        if (this.ioBuffer == null) {
            this.createBackingBuffer(newLength);
            if (!fromPut) {
                this.length = newLength;
            }
        } else if (newLength > this.length && newLength > this.capacity) {
            IOBuffer ioBuffer = this.ioBuffer;
            int offset = this.offset;
            int length = this.length;
            IOBuffer newBuffer = this.createBackingBuffer(newLength);
            this.length = newLength;
            UtlBuffer.copy(ioBuffer.getBufferUnsafe(), offset, newBuffer.getBufferUnsafe(), 0, length);
            ioBuffer.dispose();
        } else {
            this.length = newLength;
            this.ioBuffer.adjustHighwater(this.offset + this.length);
        }
        return this;
    }

    public final boolean isResizeNeededFor(int index, int numBytes) {
        if (index < 0) {
            throw new IllegalArgumentException("index cannot be < 0");
        }
        if (numBytes < 0) {
            throw new IllegalArgumentException("numBytes cannot be < 0");
        }
        int newLength = index + numBytes;
        return this.ioBuffer == null || newLength > this.length && newLength > this.capacity;
    }

    private final boolean getUTFInternal(int index, int len, Appendable appendable) throws IOException {
        byte c;
        int pos;
        if (len < -1 || len > Integer.MAX_VALUE) {
            throw new UTFDataFormatException("UTF length invalid " + len);
        }
        if (len == -1) {
            return false;
        }
        int utflen = len;
        for (pos = 0; pos < utflen && (c = this.get(index + pos)) >= 0; ++pos) {
            appendable.append((char)c);
        }
        block7: while (pos < utflen) {
            int c1 = this.getUnsignedByte(index + pos++);
            switch (c1 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    appendable.append((char)c1);
                    continue block7;
                }
                case 12: 
                case 13: {
                    int c2;
                    if (pos == utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    if (((c2 = this.getUnsignedByte(index + pos++)) & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + pos);
                    }
                    appendable.append((char)((c1 & 0x1F) << 6 | c2 & 0x3F));
                    continue block7;
                }
                case 14: {
                    if (pos == utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    int c2 = this.getUnsignedByte(index + pos++);
                    if (pos == utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    int c3 = this.get(index + pos++);
                    if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (pos - 1));
                    }
                    appendable.append((char)((c1 & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F));
                    continue block7;
                }
                case 15: {
                    if (pos == utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    int c2 = this.getUnsignedByte(index + pos++);
                    if (pos == utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    int c3 = this.getUnsignedByte(index + pos++);
                    if (pos == utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte c4 = this.get(index + pos++);
                    if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128 || (c4 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (pos - 1));
                    }
                    int c5 = (c1 & 7) << 18 | (c2 & 0x3F) << 12 | (c3 & 0x3F) << 6 | c4 & 0x3F;
                    appendable.append(Character.highSurrogate(c5));
                    appendable.append(Character.lowSurrogate(c5));
                    continue block7;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + --pos);
        }
        return true;
    }

    private final ByteBuffer getBufferForRead() {
        return this.ensureBackingBufferExists().getBufferUnsafe();
    }

    private final ByteBuffer getBufferForWrite() {
        return this.getIOBufferForWrite().getBufferUnsafe();
    }

    public final IOElasticBuffer setInitializer(Initializer initializer) {
        this.initializer = initializer;
        return this;
    }

    public final Initializer getInitializer() {
        return this.initializer;
    }

    public final boolean isNative() {
        return this.isNative;
    }

    public final IOElasticBuffer setByteOrder(ByteOrder order) {
        this.byteOrder = order;
        if (this.ioBuffer != null) {
            this.ioBuffer.setByteOrder(order);
        }
        return this;
    }

    public final ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public final void reset() {
        if (this.ioBuffer != null) {
            this.resumptionLength = this.ioBuffer.getHighwater() - this.offset;
            this.ioBuffer.dispose();
            this.ioBuffer = null;
        }
        this.capacity = 0;
        this.length = 0;
        this.offset = 0;
        this.copyOnWrite = false;
        this.failOnWrite = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IOBuffer ensureBackingBufferExists() {
        if (this.ioBuffer == null) {
            IOElasticBuffer iOElasticBuffer = this;
            synchronized (iOElasticBuffer) {
                if (this.ioBuffer == null) {
                    this.createBackingBuffer(0);
                }
            }
        }
        return this.ioBuffer;
    }

    public final void wrapIOBuffer(IOBuffer ioBuffer, int offset, int length) {
        if (ioBuffer == null) {
            throw new IllegalArgumentException("the IO buffer to set cannot be null");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("the IO buffer offset must be >= 0");
        }
        if (length < 0) {
            throw new IllegalArgumentException("the buffer length must be >= 0");
        }
        if (offset + length > ioBuffer.getCapacity()) {
            throw new IllegalArgumentException("the buffer length + offset goes beyond buffer capacity");
        }
        if (this.ioBuffer != ioBuffer) {
            if (this.ioBuffer != null) {
                this.ioBuffer.dispose();
            }
            this.ioBuffer = ioBuffer;
            this.ioBuffer.acquire();
        }
        this.offset = offset;
        this.length = length;
        this.ioBuffer.adjustHighwater(this.offset + this.length);
        this.capacity = -1;
    }

    public final IOBuffer getIOBuffer() {
        return this.getIOBufferForRead();
    }

    public final IOBuffer getIOBufferForRead() {
        return this.ioBuffer;
    }

    public final IOBuffer getIOBufferForWrite() {
        if (this.failOnWrite) {
            throw new IllegalStateException("attempt to modify a read-only buffer");
        }
        if (this.ioBuffer != null && this.copyOnWrite) {
            IOBuffer ioBuffer = this.ioBuffer;
            int offset = this.offset;
            int length = this.length;
            IOBuffer newBuffer = this.createBackingBuffer(length);
            UtlBuffer.copy(ioBuffer.getBufferUnsafe(), offset, newBuffer.getBufferUnsafe(), 0, length);
            ioBuffer.dispose();
        }
        return this.ensureBackingBufferExists();
    }

    public final IOElasticBuffer setFailOnWrite() {
        this.failOnWrite = true;
        this.copyOnWrite = false;
        return this;
    }

    public final IOElasticBuffer clearFailOnWrite() {
        this.failOnWrite = false;
        return this;
    }

    public final boolean isFailOnWrite() {
        return this.failOnWrite;
    }

    public final IOElasticBuffer setCopyOnWrite() {
        if (this.failOnWrite) {
            throw new IllegalStateException("'copy on write' cannot be set on a buffer that is already marked as 'fail on write'");
        }
        this.copyOnWrite = true;
        return this;
    }

    public final IOElasticBuffer clearCopyOnWrite() {
        this.copyOnWrite = false;
        return this;
    }

    public final boolean isCopyOnWrite() {
        return this.copyOnWrite;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final int getResumptionLength() {
        return this.resumptionLength;
    }

    public final IOElasticBuffer setLength(int newLength) {
        return this.setLength(newLength, false);
    }

    public final int getLength() {
        return this.length;
    }

    public final IOElasticBuffer put(int index, byte value) {
        int offsetBeyondLastSerializedByte = index + 1;
        if (offsetBeyondLastSerializedByte > this.length) {
            this.setLength(offsetBeyondLastSerializedByte, true);
        }
        this.getBufferForWrite().put(this.offset + index, value);
        return this;
    }

    public final IOElasticBuffer putChar(int index, char value) {
        int offsetBeyondLastSerializedByte = index + 2;
        if (offsetBeyondLastSerializedByte > this.length) {
            this.setLength(offsetBeyondLastSerializedByte, true);
        }
        this.getBufferForWrite().putChar(this.offset + index, value);
        return this;
    }

    public final int putCharUTF8(int index, char c) {
        int utflen = IOElasticBuffer.calculateUTFLength(c);
        if (utflen == 0) {
            throw new IllegalArgumentException(c + " is a surrogate character");
        }
        int offsetBeyondLastSerializedByte = index + utflen * 1;
        if (offsetBeyondLastSerializedByte > this.length) {
            this.setLength(offsetBeyondLastSerializedByte, true);
        }
        ByteBuffer buffer = this.getBufferForWrite();
        if (c >= '\u0001' && c <= '\u007f') {
            buffer.put(index + this.offset, (byte)c);
            return 1;
        }
        if (c <= '\u07ff') {
            buffer.put(index, (byte)(0xC0 | c >> 6 & 0x1F));
            buffer.put(index + 1, (byte)(0x80 | c & 0x3F));
            return 2;
        }
        buffer.put(index + this.offset, (byte)(0xE0 | c >> 12 & 0xF));
        buffer.put(index + this.offset + 1, (byte)(0x80 | c >> 6 & 0x3F));
        buffer.put(index + this.offset + 2, (byte)(0x80 | c & 0x3F));
        return 3;
    }

    public final IOElasticBuffer putShort(int index, short value) {
        int offsetBeyondLastSerializedByte = index + 2;
        if (offsetBeyondLastSerializedByte > this.length) {
            this.setLength(offsetBeyondLastSerializedByte, true);
        }
        this.getBufferForWrite().putShort(this.offset + index, value);
        return this;
    }

    public final IOElasticBuffer putInt(int index, int value) {
        int offsetBeyondLastSerializedByte = index + 4;
        if (offsetBeyondLastSerializedByte > this.length) {
            this.setLength(offsetBeyondLastSerializedByte, true);
        }
        this.getBufferForWrite().putInt(this.offset + index, value);
        return this;
    }

    public final IOElasticBuffer putFloat(int index, float value) {
        int offsetBeyondLastSerializedByte = index + 4;
        if (offsetBeyondLastSerializedByte > this.length) {
            this.setLength(offsetBeyondLastSerializedByte, true);
        }
        this.getBufferForWrite().putFloat(this.offset + index, value);
        return this;
    }

    public final IOElasticBuffer putLong(int index, long value) {
        int offsetBeyondLastSerializedByte = index + 8;
        if (offsetBeyondLastSerializedByte > this.length) {
            this.setLength(offsetBeyondLastSerializedByte, true);
        }
        this.getBufferForWrite().putLong(this.offset + index, value);
        return this;
    }

    public final IOElasticBuffer putDouble(int index, double value) {
        int offsetBeyondLastSerializedByte = index + 8;
        if (offsetBeyondLastSerializedByte > this.length) {
            this.setLength(offsetBeyondLastSerializedByte, true);
        }
        this.getBufferForWrite().putDouble(this.offset + index, value);
        return this;
    }

    public final int putString(int index, String value) {
        return this.putCharSequenceUTF(index, value);
    }

    public static final int calculateUTFLength(char c) {
        if (c >= '\u0001' && c <= '\u007f') {
            return 1;
        }
        if (c <= '\u07ff') {
            return 2;
        }
        if (!Character.isSurrogate(c)) {
            return 3;
        }
        return 0;
    }

    public static final int calculateUTFLength(CharSequence str) {
        if (str == null) {
            return 0;
        }
        int strlen = str.length();
        int utflen = 0;
        for (int i = 0; i < strlen; ++i) {
            int cutflen = IOElasticBuffer.calculateUTFLength(str.charAt(i));
            if (cutflen == 0) {
                if (i == strlen - 1) {
                    throw new IllegalArgumentException("supplied char sequence has an incomplete surrogate character pair");
                }
                utflen += 4;
                ++i;
                continue;
            }
            utflen += cutflen;
        }
        return utflen;
    }

    public final int putCharSequenceUTF(int index, CharSequence str) {
        char c;
        if (str == null) {
            return 0;
        }
        int utflen = IOElasticBuffer.calculateUTFLength(str);
        if (utflen > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(new UTFDataFormatException("encoded string too long: " + utflen + " bytes"));
        }
        int offsetBeyondLastSerializedByte = index + utflen * 1;
        if (offsetBeyondLastSerializedByte > this.length) {
            this.setLength(offsetBeyondLastSerializedByte, true);
        }
        ByteBuffer buffer = this.getBufferForWrite();
        int pos = index + this.offset;
        long strlen = str.length();
        int i = 0;
        while ((long)i < strlen && (c = str.charAt(i)) >= '\u0001' && c <= '\u007f') {
            buffer.put(pos++, (byte)c);
            ++i;
        }
        while ((long)i < strlen) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                buffer.put(pos++, (byte)c);
            } else if (c <= '\u07ff') {
                buffer.put(pos++, (byte)(0xC0 | c >> 6 & 0x1F));
                buffer.put(pos++, (byte)(0x80 | c & 0x3F));
            } else if (Character.isSurrogate(c)) {
                if ((long)i == strlen - 1L) {
                    throw new IllegalArgumentException("supplied char sequence has an incomplete surrogate character pair");
                }
                int uc = Character.toCodePoint(c, str.charAt(++i));
                buffer.put(pos++, (byte)(0xF0 | uc >> 18 & 7));
                buffer.put(pos++, (byte)(0x80 | uc >> 12 & 0x3F));
                buffer.put(pos++, (byte)(0x80 | uc >> 6 & 0x3F));
                buffer.put(pos++, (byte)(0x80 | uc & 0x3F));
            } else {
                buffer.put(pos++, (byte)(0xE0 | c >> 12 & 0xF));
                buffer.put(pos++, (byte)(0x80 | c >> 6 & 0x3F));
                buffer.put(pos++, (byte)(0x80 | c & 0x3F));
            }
            ++i;
        }
        return utflen;
    }

    public final IOElasticBuffer putFrom(int index, ByteBuffer buffer, int bufferOffset, int length) {
        int offsetBeyondLastSerializedByte = index + length;
        if (offsetBeyondLastSerializedByte > this.length) {
            this.setLength(offsetBeyondLastSerializedByte, true);
        }
        UtlBuffer.copy(buffer, bufferOffset, this.getBufferForWrite(), this.offset + index, length);
        return this;
    }

    public final IOElasticBuffer putFrom(int index, ByteBuffer buffer, int length) {
        return this.putFrom(index, buffer, buffer.position(), length);
    }

    public final IOElasticBuffer putFrom(int index, IOBuffer buffer, int bufferOffset, int length) {
        int offsetBeyondLastSerializedByte = index + length;
        if (offsetBeyondLastSerializedByte > this.length) {
            this.setLength(offsetBeyondLastSerializedByte, true);
        }
        UtlBuffer.copy(buffer.getBufferUnsafe(), bufferOffset, this.getBufferForWrite(), this.offset + index, length);
        return this;
    }

    public final void putFrom(int index, IOElasticBuffer buffer, int bufferOffset, int length) {
        if (length == 0) {
            return;
        }
        int offsetBeyondLastSerializedByte = index + length;
        if (offsetBeyondLastSerializedByte > this.length) {
            this.setLength(offsetBeyondLastSerializedByte, true);
        }
        UtlBuffer.copy(buffer.getIOBuffer().getBufferUnsafe(), buffer.getOffset() + bufferOffset, this.getBufferForWrite(), this.offset + index, length);
    }

    public final IOElasticBuffer putFrom(int index, byte[] array, int arrayOffset, int length) {
        int offsetBeyondLastSerializedByte = index + length;
        if (offsetBeyondLastSerializedByte > this.length) {
            this.setLength(offsetBeyondLastSerializedByte, true);
        }
        UtlBuffer.copy(array, arrayOffset, this.getBufferForWrite(), this.offset + index, length);
        return this;
    }

    public final IOElasticBuffer putFrom(int index, char[] array, int arrayOffset, int length) {
        int offsetBeyondLastSerializedByte = index + length * 2;
        if (offsetBeyondLastSerializedByte > this.length) {
            this.setLength(offsetBeyondLastSerializedByte, true);
        }
        UtlBuffer.copy(array, arrayOffset, this.getBufferForWrite(), this.offset + index, length);
        return this;
    }

    public final IOElasticBuffer putFrom(int index, short[] array, int arrayOffset, int length) {
        int offsetBeyondLastSerializedByte = index + length * 2;
        if (offsetBeyondLastSerializedByte > this.length) {
            this.setLength(offsetBeyondLastSerializedByte, true);
        }
        UtlBuffer.copy(array, arrayOffset, this.getBufferForWrite(), this.offset + index, length);
        return this;
    }

    public final IOElasticBuffer putFrom(int index, int[] array, int arrayOffset, int length) {
        int offsetBeyondLastSerializedByte = index + length * 4;
        if (offsetBeyondLastSerializedByte > this.length) {
            this.setLength(offsetBeyondLastSerializedByte, true);
        }
        UtlBuffer.copy(array, arrayOffset, this.getBufferForWrite(), this.offset + index, length);
        return this;
    }

    public final IOElasticBuffer putFrom(int index, float[] array, int arrayOffset, int length) {
        int offsetBeyondLastSerializedByte = index + length * 4;
        if (offsetBeyondLastSerializedByte > this.length) {
            this.setLength(offsetBeyondLastSerializedByte, true);
        }
        UtlBuffer.copy(array, arrayOffset, this.getBufferForWrite(), this.offset + index, length);
        return this;
    }

    public final IOElasticBuffer putFrom(int index, long[] array, int arrayOffset, int length) {
        int offsetBeyondLastSerializedByte = index + length * 8;
        if (offsetBeyondLastSerializedByte > this.length) {
            this.setLength(offsetBeyondLastSerializedByte, true);
        }
        UtlBuffer.copy(array, arrayOffset, this.getBufferForWrite(), this.offset + index, length);
        return this;
    }

    public final IOElasticBuffer putFrom(int index, double[] array, int arrayOffset, int length) {
        int offsetBeyondLastSerializedByte = index + length * 8;
        if (offsetBeyondLastSerializedByte > this.length) {
            this.setLength(offsetBeyondLastSerializedByte, true);
        }
        UtlBuffer.copy(array, arrayOffset, this.getBufferForWrite(), this.offset + index, length);
        return this;
    }

    public final void putFromNative(int index, long address, int addressOffset, int length) {
        int offsetBeyondLastSerializedByte = index + length;
        if (offsetBeyondLastSerializedByte > this.length) {
            this.setLength(offsetBeyondLastSerializedByte, true);
        }
        UtlBuffer.copyFromNative(address, addressOffset, this.getBufferForWrite(), this.offset + index, length);
    }

    public final byte get(int index) {
        return this.getBufferForRead().get(this.offset + index);
    }

    public final int getUnsignedByte(int index) {
        return this.getBufferForRead().get(this.offset + index) & 0xFF;
    }

    public final char getChar(int index) {
        return this.getBufferForRead().getChar(this.offset + index);
    }

    public final short getShort(int index) {
        return this.getBufferForRead().getShort(this.offset + index);
    }

    public final int getUnsignedShort(int index) {
        return this.getBufferForRead().getShort(this.offset + index) & 0xFFFF;
    }

    public final int getInt(int index) {
        return this.getBufferForRead().getInt(this.offset + index);
    }

    public final long getUnsignedInt(int index) {
        return this.getBufferForRead().getLong(this.offset + index) & 0xFFFFFFFFL;
    }

    public final float getFloat(int index) {
        return this.getBufferForRead().getFloat(this.offset + index);
    }

    public final long getLong(int index) {
        return this.getBufferForRead().getLong(this.offset + index);
    }

    public final double getDouble(int index) {
        return this.getBufferForRead().getDouble(this.offset + index);
    }

    public final String getString(int index, int length) {
        StringBuilder sb = UTF_BUILDER.get();
        if (sb == null) {
            sb = new StringBuilder(Math.max(32, length));
            UTF_BUILDER.set(sb);
        } else {
            sb.setLength(0);
        }
        try {
            if (this.getUTFInternal(index, length, sb)) {
                return sb.toString();
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading String value from buffer: " + e.getMessage(), e);
        }
    }

    public final IOElasticBuffer getTo(int index, ByteBuffer buffer, int bufferOffset, int length) {
        UtlBuffer.copy(this.getBufferForRead(), this.offset + index, buffer, bufferOffset, length);
        return this;
    }

    public final IOElasticBuffer getTo(int index, ByteBuffer buffer, int length) {
        return this.getTo(index, buffer, buffer.position(), length);
    }

    public final IOElasticBuffer getTo(int index, IOBuffer buffer, int bufferOffset, int length) {
        UtlBuffer.copy(this.getBufferForRead(), this.offset + index, buffer.getBufferUnsafe(), bufferOffset, length);
        return this;
    }

    public final IOElasticBuffer getTo(int index, byte[] array, int arrayOffset, int length) {
        UtlBuffer.copy(this.getBufferForRead(), this.offset + index, array, arrayOffset, length);
        return this;
    }

    public final IOElasticBuffer getTo(int index, char[] array, int arrayOffset, int length) {
        UtlBuffer.copy(this.getBufferForRead(), this.offset + index, array, arrayOffset, length);
        return this;
    }

    public final IOElasticBuffer getTo(int index, short[] array, int arrayOffset, int length) {
        UtlBuffer.copy(this.getBufferForRead(), this.offset + index, array, arrayOffset, length);
        return this;
    }

    public final IOElasticBuffer getTo(int index, int[] array, int arrayOffset, int length) {
        UtlBuffer.copy(this.getBufferForRead(), this.offset + index, array, arrayOffset, length);
        return this;
    }

    public final IOElasticBuffer getTo(int index, float[] array, int arrayOffset, int length) {
        UtlBuffer.copy(this.getBufferForRead(), this.offset + index, array, arrayOffset, length);
        return this;
    }

    public final IOElasticBuffer getTo(int index, long[] array, int arrayOffset, int length) {
        UtlBuffer.copy(this.getBufferForRead(), this.offset + index, array, arrayOffset, length);
        return this;
    }

    public final IOElasticBuffer getTo(int index, double[] array, int arrayOffset, int length) {
        UtlBuffer.copy(this.getBufferForRead(), this.offset + index, array, arrayOffset, length);
        return this;
    }

    public final IOElasticBuffer getToNative(int index, long address, int addressOffset, int length) {
        UtlBuffer.copyToNative(this.getBufferForRead(), this.offset + index, address, addressOffset, length);
        return this;
    }

    public final InputStream inputStream(int index) {
        return this.is.init(index);
    }

    public final OutputStream outputStream(int index) {
        return this.os.init(index);
    }

    public final void wipe(int index, int len) {
        UtlBuffer.wipe(this.getBufferForWrite(), this.offset + index, len);
    }

    public IOElasticBuffer fork() {
        throw new UnsupportedOperationException("packet buffer forking is currently not supported");
    }

    public final String dump(String prefix, int index, int len) {
        return UtlBuffer.dump(prefix, this.getBufferForRead(), this.offset + index, len);
    }

    public final String toString() {
        return "[buf=" + this.ioBuffer + ", offset=" + this.offset + ", length=" + this.length + ", fow=" + this.failOnWrite + ", cow=" + this.copyOnWrite + "]";
    }

    public static interface Sizer {
        public int getInitialBufferLength();
    }

    public static interface Initializer {
        public void initializeBuffer();
    }

    private final class OutputStreamImpl
    extends OutputStream {
        private int pos;

        private OutputStreamImpl() {
        }

        final OutputStreamImpl init(int pos) {
            this.pos = pos;
            return this;
        }

        @Override
        public final void write(int b) throws IOException {
            IOElasticBuffer.this.put(this.pos++, (byte)b);
        }

        @Override
        public final void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public final void write(byte[] b, int off, int len) throws IOException {
            IOElasticBuffer.this.putFrom(this.pos, b, off, len);
            this.pos += len;
        }
    }

    private final class InputStreamImpl
    extends InputStream {
        private int pos;

        private InputStreamImpl() {
        }

        final InputStreamImpl init(int pos) {
            this.pos = pos;
            return this;
        }

        @Override
        public final int read() throws IOException {
            return this.pos < IOElasticBuffer.this.length ? 0xFF & IOElasticBuffer.this.get(this.pos++) : -1;
        }

        @Override
        public final int read(byte[] bytes, int off, int len) throws IOException {
            int remaining = IOElasticBuffer.this.length - this.pos;
            if (remaining > 0) {
                len = Math.min(len, remaining);
                IOElasticBuffer.this.getTo(this.pos, bytes, off, len);
                this.pos += len;
                return len;
            }
            return -1;
        }
    }
}

