/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.cli;

import java.io.BufferedWriter;
import java.io.IOException;

public class IndentingWriter {
    private final String indent;
    private final BufferedWriter writer;
    private int indentCount = 0;
    boolean isNewline = true;

    public IndentingWriter(BufferedWriter bw, String indent) {
        this.writer = bw;
        this.indent = indent;
    }

    public IndentingWriter indent() {
        ++this.indentCount;
        return this;
    }

    public IndentingWriter deindent() {
        --this.indentCount;
        return this;
    }

    public IndentingWriter println(String line, boolean ignoreIndent) throws IOException {
        if (!ignoreIndent && line.trim().length() > 0) {
            this.writeIndent();
        }
        this.writer.write(line);
        this.newLine();
        return this;
    }

    public IndentingWriter println(String line) throws IOException {
        if (line.trim().length() > 0) {
            this.writeIndent();
        }
        this.writer.write(line);
        this.newLine();
        return this;
    }

    public IndentingWriter print(String line) throws IOException {
        this.writeIndent();
        this.writer.write(line);
        return this;
    }

    public void newLine() throws IOException {
        this.writer.newLine();
        this.isNewline = true;
    }

    private void writeIndent() throws IOException {
        if (this.isNewline) {
            for (int i = 0; i < this.indentCount; ++i) {
                this.writer.append(this.indent);
            }
        }
    }

    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }
}

