/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.cli;

import com.neeve.cli.ValueApplier;
import com.neeve.util.UtlDataTypes;
import java.lang.reflect.Field;

final class FieldValueApplier
implements ValueApplier {
    private final Field field;
    private final Object containerObject;

    FieldValueApplier(Object fieldContainer, Field field) {
        this.field = field;
        this.containerObject = fieldContainer;
        this.field.setAccessible(true);
    }

    @Override
    public final void applyParsedValue(Object val) throws Exception {
        val = UtlDataTypes.convert(this.field.getType(), val);
        if (val != null) {
            if (val instanceof Boolean) {
                this.field.setBoolean(this.containerObject, (Boolean)val);
                return;
            }
            if (val instanceof Byte) {
                this.field.setByte(this.containerObject, (Byte)val);
            } else if (val instanceof Character) {
                this.field.setChar(this.containerObject, ((Character)val).charValue());
            } else if (val instanceof Short) {
                this.field.setShort(this.containerObject, (Short)val);
            } else if (val instanceof Integer) {
                this.field.setInt(this.containerObject, (Integer)val);
            } else if (val instanceof Long) {
                this.field.setLong(this.containerObject, (Long)val);
            } else if (val instanceof Float) {
                this.field.setFloat(this.containerObject, ((Float)val).floatValue());
            } else if (val instanceof Double) {
                this.field.setDouble(this.containerObject, (Double)val);
            }
        }
        this.field.set(this.containerObject, val);
    }

    @Override
    public final Class<?> getTargetType() {
        return this.field.getType();
    }
}

