/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.cli;

import com.neeve.cli.CommandExecutor;
import com.neeve.cli.annotations.Command;
import com.neeve.cli.annotations.RemainingArgs;
import java.util.Currency;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class CliTest {
    @Test
    public void testStringMethodInvocation() throws Exception {
        CommandExecutor executor = CommandExecutor.createExecutor((Object)new UnannotatedParamatersTestObject(), UnannotatedParamatersTestObject.class.getMethod("echoString", String.class));
        Assert.assertEquals((String)"Expected same string to be echoed", (Object)"Test String", (Object)executor.execute("Test String"));
        executor.help(System.out);
    }

    @Test
    public void testCharMethodInvocation() throws Exception {
        CommandExecutor executor = CommandExecutor.createExecutor((Object)new UnannotatedParamatersTestObject(), UnannotatedParamatersTestObject.class.getMethod("echoChar", Character.TYPE));
        Assert.assertEquals((String)"Expected same char to be echoed", (Object)new Character('T'), (Object)executor.execute("T"));
        executor.help(System.out);
    }

    @Test
    public void testByteMethodInvocation() throws Exception {
        CommandExecutor executor = CommandExecutor.createExecutor((Object)new UnannotatedParamatersTestObject(), UnannotatedParamatersTestObject.class.getMethod("echoByte", Byte.TYPE));
        Assert.assertEquals((String)"Expected same byte to be echoed", (Object)127, (Object)executor.execute("127"));
        executor.help(System.out);
    }

    @Test
    public void testShortMethodInvocation() throws Exception {
        CommandExecutor executor = CommandExecutor.createExecutor((Object)new UnannotatedParamatersTestObject(), UnannotatedParamatersTestObject.class.getMethod("echoShort", Short.TYPE));
        Assert.assertEquals((String)"Expected same short to be echoed", (Object)127, (Object)executor.execute("127"));
        executor.help(System.out);
    }

    @Test
    public void testIntMethodInvocation() throws Exception {
        CommandExecutor executor = CommandExecutor.createExecutor((Object)new UnannotatedParamatersTestObject(), UnannotatedParamatersTestObject.class.getMethod("echoInt", Integer.TYPE));
        Assert.assertEquals((String)"Expected same int to be echoed", (Object)127, (Object)executor.execute("127"));
        executor.help(System.out);
    }

    @Test
    public void testLongMethodInvocation() throws Exception {
        CommandExecutor executor = CommandExecutor.createExecutor((Object)new UnannotatedParamatersTestObject(), UnannotatedParamatersTestObject.class.getMethod("echoLong", Long.TYPE));
        Assert.assertEquals((String)"Expected same long to be echoed", (Object)127L, (Object)executor.execute("127"));
        executor.help(System.out);
    }

    @Test
    public void testEnumMethodInvocation() throws Exception {
        CommandExecutor executor = CommandExecutor.createExecutor((Object)new UnannotatedParamatersTestObject(), UnannotatedParamatersTestObject.class.getMethod("echoEnum", TestEnum.class));
        Assert.assertEquals((String)"Expected same enum to be echoed", (Object)((Object)TestEnum.Value1), (Object)executor.execute("Value1"));
        executor.help(System.out);
    }

    @Test
    public void testStringRemainingArgs() throws Exception {
        CommandExecutor executor = CommandExecutor.createExecutor((Object)new UnannotatedParamatersTestObject(), UnannotatedParamatersTestObject.class.getMethod("echoStringArray", String.class));
        Assert.assertEquals((String)"Expected same String to be echoed", (Object)"Value1", (Object)executor.execute("Value1"));
        executor.help(System.out);
    }

    @Test
    public void testStringRemainingArgsDefaultValue() throws Exception {
        CommandExecutor executor = CommandExecutor.createExecutor((Object)new UnannotatedParamatersTestObject(), UnannotatedParamatersTestObject.class.getMethod("echoStringArray", String.class));
        Assert.assertEquals((String)"Expected same String to be echoed", (Object)"one \"two three \"", (Object)executor.execute(new String[0]));
        executor.help(System.out);
    }

    @Test
    public void testStringRemainingArgsDefaultValueMultiSpace() throws Exception {
        CommandExecutor executor = CommandExecutor.createExecutor((Object)new UnannotatedParamatersTestObject(), UnannotatedParamatersTestObject.class.getMethod("echoStringArrayMultiSpaceDefault", String.class));
        Assert.assertEquals((String)"Expected same String to be echoed", (Object)"one \"two  three \"", (Object)executor.execute(new String[0]));
        executor.help(System.out);
    }

    public class UnannotatedParamatersTestObject {
        @Command
        public String echoString(String echo) throws Exception {
            return echo;
        }

        @Command
        public char echoChar(char echo) throws Exception {
            return echo;
        }

        @Command
        public byte echoByte(byte echo) throws Exception {
            return echo;
        }

        @Command
        public short echoShort(short echo) throws Exception {
            return echo;
        }

        @Command
        public int echoInt(int echo) throws Exception {
            return echo;
        }

        @Command
        public long echoLong(long echo) throws Exception {
            return echo;
        }

        @Command
        public float echoFloat(float echo) throws Exception {
            return echo;
        }

        @Command
        public double echoDouble(double echo) throws Exception {
            return echo;
        }

        @Command
        public Currency echoCurrency(Currency echo) throws Exception {
            return echo;
        }

        @Command
        public Date echoDate(Date echo) throws Exception {
            return echo;
        }

        @Command
        public TestEnum echoEnum(TestEnum echo) throws Exception {
            return echo;
        }

        @Command
        public String echoMultiArgumentCommand(byte aByte, char aChar, short aShort, int aInt, long aLong, float aFloat, double aDouble, String aString, Currency aCurrency) throws Exception {
            return aByte + " " + aChar + " " + aShort + " " + aInt + " " + aLong + " " + aFloat + " " + aDouble + " " + aString + " " + aCurrency + " ";
        }

        @Command
        public String echoStringArray(@RemainingArgs(name="echo", defaultValue="one \"two three \"", description="echos a String array") String echo) throws Exception {
            return echo;
        }

        @Command
        public String echoStringArrayMultiSpaceDefault(@RemainingArgs(name="echo", defaultValue="one \"two  three \"", description="echos a String array") String echo) throws Exception {
            return echo;
        }
    }

    public static enum TestEnum {
        Value1,
        Value2;

    }
}

