/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.build.codegen;

import com.neeve.build.codegen.CgCodeSource;
import com.neeve.build.codegen.CgResourceChangeTracker;
import com.neeve.build.codegen.CgSourceCodeErrorAggregator;
import com.neeve.build.codegen.ECgException;
import com.neeve.util.UtlThrowable;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

public final class CgExtendedDOMBuilder {
    public static final String SRC_INFO = "srcInfo";

    @Deprecated
    public static Document readXML(URL xmlUrl, String xmlSchema, PrintStream errorOutput, CgResourceChangeTracker changeTracker) throws ECgException, SAXException, IOException {
        return CgExtendedDOMBuilder.readXML(xmlUrl, xmlSchema, changeTracker);
    }

    public static Document readXML(URL xmlUrl, String xmlSchema, CgResourceChangeTracker changeTracker) throws ECgException, SAXException, IOException {
        if (xmlSchema == null) {
            throw new IllegalArgumentException("'xmlSchema' cannot be null");
        }
        return CgExtendedDOMBuilder.parse(xmlUrl, null, xmlSchema, changeTracker);
    }

    public static Document readXML(URL xmlUrl, CgResourceChangeTracker changeTracker) throws ECgException, SAXException, IOException {
        return CgExtendedDOMBuilder.parse(xmlUrl, null, null, changeTracker);
    }

    public static Document readXML(String xml) throws ECgException, SAXException, IOException {
        return CgExtendedDOMBuilder.parse(null, xml, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document parse(URL xmlUrl, String xml, String xmlSchema, CgResourceChangeTracker changeTracker) throws ECgException, SAXException, IOException {
        Document doc;
        SAXParser parser;
        if (xmlUrl == null && xml == null) {
            throw new IllegalArgumentException("Either 'xmlUrl' or 'xml' must be supplied.");
        }
        if (xmlUrl != null && xml != null) {
            throw new IllegalArgumentException("Either 'xmlUrl' or 'xml' can be supplied but not both.");
        }
        if (xml != null && changeTracker != null) {
            throw new IllegalArgumentException("'changeTracker' is only applicable when 'xmlUrl' is supplied.");
        }
        InputStream schemaIs = null;
        CgSourceCodeErrorAggregator errorAggregator = new CgSourceCodeErrorAggregator();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            if (xmlSchema != null) {
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                schemaIs = CgExtendedDOMBuilder.class.getResourceAsStream(xmlSchema);
                Schema schema = schemaFactory.newSchema(new StreamSource(schemaIs));
                factory.setSchema(schema);
            }
            parser = factory.newSAXParser();
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            docBuilderFactory.setIgnoringComments(false);
            docBuilderFactory.setIgnoringElementContentWhitespace(false);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            doc = docBuilder.newDocument();
        }
        catch (Exception e) {
            ECgException adme = new ECgException("Failed to setup a schema validating XML parser for " + xmlUrl + " [" + UtlThrowable.prepareStackTrace((Throwable)e) + "]", e);
            throw adme;
        }
        ParseHandler handler = new ParseHandler(xmlUrl, doc, errorAggregator);
        parser.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
        InputStream inputIs = null;
        inputIs = xmlUrl != null ? (changeTracker != null ? new BufferedInputStream(changeTracker.getSourceFile(xmlUrl).getInputStream()) : xmlUrl.openStream()) : new ByteArrayInputStream(xml.getBytes("UTF-8"));
        try {
            parser.parse(inputIs, (DefaultHandler)handler);
        }
        finally {
            if (inputIs != null) {
                inputIs.close();
            }
            if (schemaIs != null) {
                schemaIs.close();
            }
        }
        if (errorAggregator.getNumErrors() > 0) {
            throw new ECgException("Error parsing '" + xmlUrl + "'", errorAggregator);
        }
        doc.setXmlStandalone(true);
        return doc;
    }

    public static String writeDocumentToString(Document doc) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        CgExtendedDOMBuilder.writeDocument(doc, os);
        String str = os.toString("UTF-8");
        return str;
    }

    public static void writeDocument(Document doc, OutputStream outputStream) throws Exception {
        if (doc == null) {
            throw new IllegalArgumentException("'doc' cannot be null");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("'outputStream' cannot be null");
        }
        TransformerFactory tFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("standalone", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(outputStream);
            transformer.transform(source, result);
        }
        catch (Exception ex) {
            throw new Exception("Unable to write document to output.", ex);
        }
    }

    public static final CgCodeSource getCodeSource(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("'node' cannot be null");
        }
        CgCodeSource retVal = null;
        if (node instanceof Element) {
            retVal = (CgCodeSource)node.getUserData(SRC_INFO);
        } else {
            Node parent = null;
            parent = node instanceof Attr ? ((Attr)node).getOwnerElement() : node.getParentNode();
            if (parent != null) {
                retVal = CgExtendedDOMBuilder.getCodeSource(parent);
            }
        }
        return retVal;
    }

    public static Element getOrCreate(Element parent, String name, boolean first) {
        Element retVal;
        if (parent == null) {
            throw new IllegalArgumentException("'parent' cannot be null");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("'name' cannot be null or empty string.");
        }
        NodeList list = parent.getElementsByTagNameNS(parent.getNamespaceURI(), name);
        if (list.getLength() > 1) {
            throw new IllegalStateException("Ambiguous resolution: multiple elements of name '" + name + "' were found.");
        }
        if (list.getLength() == 0) {
            retVal = parent.getOwnerDocument().createElementNS(parent.getNamespaceURI(), name);
            if (first) {
                parent.insertBefore(retVal, parent.getFirstChild());
            } else {
                parent.appendChild(retVal);
            }
        } else {
            retVal = (Element)list.item(0);
        }
        return retVal;
    }

    private static class ParseHandler
    extends DefaultHandler2 {
        private Locator locator;
        private final LinkedList<Element> elementStack = new LinkedList();
        private final StringBuilder textBuffer = new StringBuilder();
        private final Document document;
        private final URL xmlUrl;
        private final CgSourceCodeErrorAggregator errorAggregator;

        public ParseHandler(URL xmlUrl, Document document, CgSourceCodeErrorAggregator errorAggregator) {
            if (document == null) {
                throw new IllegalArgumentException("'document' cannot be null");
            }
            this.document = document;
            this.xmlUrl = xmlUrl;
            if (errorAggregator == null) {
                throw new IllegalArgumentException("'errorAggregator' cannot be null");
            }
            this.errorAggregator = errorAggregator;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.addTextIfNeeded();
            Element el = this.document.createElementNS(uri, qName);
            for (int i = 0; i < attributes.getLength(); ++i) {
                el.setAttribute(attributes.getQName(i), attributes.getValue(i));
            }
            CgCodeSource srcInfo = this.xmlUrl == null ? new CgCodeSource(this.locator.getLineNumber(), this.locator.getColumnNumber()) : new CgCodeSource(this.xmlUrl, this.locator.getLineNumber(), this.locator.getColumnNumber());
            el.setUserData(CgExtendedDOMBuilder.SRC_INFO, srcInfo, null);
            this.elementStack.push(el);
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            this.addTextIfNeeded();
            Element closedEl = this.elementStack.pop();
            if (this.elementStack.isEmpty()) {
                this.document.appendChild(closedEl);
            } else {
                Element parentEl = this.elementStack.peek();
                parentEl.appendChild(closedEl);
            }
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            Comment c = this.document.createComment(new String(ch, start, length));
            if (this.elementStack.size() > 0) {
                this.elementStack.getFirst().appendChild(c);
            } else {
                this.document.appendChild(c);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.textBuffer.append(ch, start, length);
        }

        @Override
        public final void error(SAXParseException e) {
            this.handleSAXException(e);
        }

        @Override
        public final void fatalError(SAXParseException e) {
            this.handleSAXException(e);
        }

        @Override
        public final void warning(SAXParseException e) {
            this.handleSAXException(e);
        }

        private void addTextIfNeeded() {
            if (this.textBuffer.length() > 0) {
                Element el = this.elementStack.peek();
                Text textNode = this.document.createTextNode(this.textBuffer.toString());
                el.appendChild(textNode);
                this.textBuffer.delete(0, this.textBuffer.length());
            }
        }

        private void handleSAXException(SAXParseException e) {
            int columnNumber;
            int lineNumber;
            String message = e.getMessage();
            if (message.contains("cvc-elt.1: Cannot find the declaration of element 'model'")) {
                message = "Element 'model' has incorrect 'xmlns' attribute (W3C cvc-elt.1). Ensure that model's target XML namespace is as required by ADM XSD schema.";
            }
            if ((lineNumber = e.getLineNumber()) == -1) {
                lineNumber = 1;
            }
            if ((columnNumber = e.getColumnNumber()) == -1) {
                columnNumber = 1;
            }
            CgCodeSource srcInfo = this.xmlUrl == null ? new CgCodeSource(lineNumber, columnNumber) : new CgCodeSource(this.xmlUrl, lineNumber, columnNumber);
            this.errorAggregator.add(message, CgSourceCodeErrorAggregator.Severity.ERROR, srcInfo, e);
        }
    }
}

