/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.root;

import com.neeve.env.Env;
import com.neeve.trace.Tracer;
import java.util.Hashtable;

public class RootConfig {
    private static final Hashtable<String, Boolean> threadedTable;
    private static final Hashtable<String, Boolean> checkedTable;
    private static ObjectConfig defaultObjectConfig;

    private static final synchronized ObjectConfig defaultObjectConfig() {
        if (defaultObjectConfig == null) {
            defaultObjectConfig = new ObjectConfig("default", false, Env.getValue("nv.checked", true));
        }
        return defaultObjectConfig;
    }

    public static void setThreaded(String name, boolean val) {
        if (name == null) {
            RootConfig.defaultObjectConfig().threaded = val;
        } else {
            threadedTable.put(name, new Boolean(val));
        }
    }

    public static boolean getThreaded(String name) {
        if (name == null) {
            return RootConfig.defaultObjectConfig().threaded;
        }
        Boolean val = threadedTable.get(name);
        return val == null ? RootConfig.defaultObjectConfig().threaded : val;
    }

    public static void setChecked(String name, boolean val) {
        if (name == null) {
            RootConfig.defaultObjectConfig().checked = val;
        } else {
            checkedTable.put(name, new Boolean(val));
        }
    }

    public static boolean getChecked(String name) {
        if (name == null) {
            return RootConfig.defaultObjectConfig().checked;
        }
        Boolean val = checkedTable.get(name);
        return val == null ? RootConfig.defaultObjectConfig().checked : val;
    }

    public static void flushConfig() {
        defaultObjectConfig = null;
    }

    static {
        checkedTable = new Hashtable();
        threadedTable = new Hashtable();
    }

    public static class ObjectConfig {
        public String name;
        public boolean threaded;
        public boolean checked;

        private ObjectConfig(String name, boolean threaded, boolean checked) {
            this.name = name;
            this.threaded = threaded;
            this.checked = checked;
        }

        private ObjectConfig(String name) {
            this(name, RootConfig.getThreaded(name), RootConfig.getChecked(name));
        }

        public static ObjectConfig get(String name) {
            return new ObjectConfig(name);
        }

        public static Tracer createTracer(ObjectConfig config) {
            return config != null ? Tracer.get(config.name) : Tracer.create();
        }

        public final String toString() {
            return "[name=" + this.name + " thr=" + this.threaded + " chkd=" + this.checked + "]";
        }
    }
}

