/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.env;

import com.neeve.util.UtlLinkedHashMap;
import com.neeve.util.UtlProps;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public final class Env {
    private static final Map<String, Object> env = Env.getExternalEnvironment();
    private static final Map<String, PropertyChangeCallback> cbs = new UtlLinkedHashMap<String, PropertyChangeCallback>();
    public static final String APP_PROPFILE_PROPNAME = "nv.app.propfile";
    private static final String APP_PROPFILE_DEFAULT = "conf/application.conf";

    private static final void dispatchChangeNotifications(Map<String, Object> newEnv) {
        for (Map.Entry<String, Object> entry : env.entrySet()) {
            String key = entry.getKey();
            PropertyChangeCallback cb = cbs.get(key);
            if (cb == null) continue;
            Object currentValue = entry.getValue();
            Object newValue = newEnv.get(key);
            Object v1 = currentValue != null ? currentValue : newValue;
            if (v1 == null || v1.equals(v1 == currentValue ? newValue : currentValue)) continue;
            try {
                cb.onPropertyChange(key, currentValue, newValue);
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Map<String, Object> getExternalEnvironment() {
        UtlLinkedHashMap<String, Object> env = new UtlLinkedHashMap<String, Object>();
        String nvRootFromEnv = System.getenv("NVROOT");
        String nvRoot = UtlProps.getValue(System.getProperties(), "NVROOT", nvRootFromEnv != null ? nvRootFromEnv : ".");
        String propfile = System.getProperty(APP_PROPFILE_PROPNAME, System.getenv(APP_PROPFILE_PROPNAME.replace(".", "_")));
        if (propfile == null && new File(nvRoot + File.separator + APP_PROPFILE_DEFAULT).exists()) {
            propfile = nvRoot + File.separator + APP_PROPFILE_DEFAULT;
        }
        Properties systemProps = System.getProperties();
        for (String key : systemProps.stringPropertyNames()) {
            String value = systemProps.getProperty(key);
            if (value == null) continue;
            env.put(key, value);
        }
        Properties props = new Properties();
        if (propfile != null) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(propfile);
                props.load(fis);
            }
            catch (Exception value) {
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException value) {}
            }
        }
        for (String key : props.stringPropertyNames()) {
            String value = props.getProperty(key);
            env.put(key, value);
        }
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            env.put(entry.getKey(), entry.getValue());
            env.put(entry.getKey().replace('_', '.'), entry.getValue());
        }
        return env;
    }

    public static final void setEnvironment(Map<String, Object> val) {
        if (val == null) {
            throw new IllegalArgumentException("supplied environment cannot be null");
        }
        Env.dispatchChangeNotifications(val);
        env.clear();
        env.putAll(val);
    }

    public static final Properties getEnvironment() {
        Properties props = new Properties();
        for (String key : env.keySet()) {
            props.setProperty(key, (String)env.get(key));
        }
        return props;
    }

    public static final void updateEnvironment(Map<String, Object> val) {
        if (val == null) {
            throw new IllegalArgumentException("supplied environment cannot be null");
        }
        UtlLinkedHashMap<String, Object> props = new UtlLinkedHashMap<String, Object>();
        props.putAll(env);
        props.putAll(val);
        Env.setEnvironment(props);
    }

    public static final void resetEnvironment() {
        Env.setEnvironment(Env.getExternalEnvironment());
    }

    public static final PropertyChangeCallback getChangeCallback(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return cbs.get(name);
    }

    public static final PropertyChangeCallback setChangeCallback(String name, PropertyChangeCallback cb) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (cb == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return cbs.put(name, cb);
    }

    public static final PropertyChangeCallback removeChangeCallback(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return cbs.remove(name);
    }

    public static final String getValue(String name, PropertyChangeCallback cb) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (cb != null) {
            Env.setChangeCallback(name, cb);
        }
        return UtlProps.getValue(env, name, (String)null);
    }

    public static final String getValue(String name) {
        return Env.getValue(name, (PropertyChangeCallback)null);
    }

    public static final String getValue(String name, String defValue, PropertyChangeCallback cb) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (cb != null) {
            Env.setChangeCallback(name, cb);
        }
        return UtlProps.getValue(env, name, defValue);
    }

    public static final String getValue(String name, String defValue) {
        return Env.getValue(name, defValue, null);
    }

    public static final short getValue(String name, short defValue, PropertyChangeCallback cb) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (cb != null) {
            Env.setChangeCallback(name, cb);
        }
        return UtlProps.getValue(env, name, defValue);
    }

    public static final short getValue(String name, short defValue) {
        return Env.getValue(name, defValue, null);
    }

    public static final int getValue(String name, int defValue, PropertyChangeCallback cb) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (cb != null) {
            Env.setChangeCallback(name, cb);
        }
        return UtlProps.getValue(env, name, defValue);
    }

    public static final int getValue(String name, int defValue) {
        return Env.getValue(name, defValue, null);
    }

    public static final double getValue(String name, double defValue, PropertyChangeCallback cb) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (cb != null) {
            Env.setChangeCallback(name, cb);
        }
        return UtlProps.getValue(env, name, defValue);
    }

    public static final double getValue(String name, double defValue) {
        return Env.getValue(name, defValue, null);
    }

    public static final boolean getValue(String name, boolean defValue, PropertyChangeCallback cb) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (cb != null) {
            Env.setChangeCallback(name, cb);
        }
        return UtlProps.getValue(env, name, defValue);
    }

    public static final boolean getValue(String name, boolean defValue) {
        return Env.getValue(name, defValue, null);
    }

    public static interface PropertyChangeCallback {
        public void onPropertyChange(String var1, Object var2, Object var3);
    }
}

