/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.config.impl;

import com.neeve.config.ConfigObject;
import com.neeve.config.EConfigException;
import com.neeve.config.IConfigComplexEntity;
import com.neeve.config.IConfigComplexEntityContainer;
import com.neeve.config.IConfigEntity;
import com.neeve.config.IConfigEntityContainer;
import com.neeve.config.IConfigRepository;
import com.neeve.config.IConfigSimpleEntity;
import com.neeve.config.IConfigSimpleEntityContainer;
import com.neeve.config.IConfigTraversalCallback;
import com.neeve.config.impl.ConfigComplexEntityContainerBase;
import com.neeve.config.impl.ConfigEntityContainerBase;
import com.neeve.config.impl.ConfigSimpleEntityContainerBase;
import com.neeve.hstr.EHstrFormatException;
import com.neeve.hstr.HstrTable;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class ConfigRepositoryBase
extends ConfigObject
implements IConfigRepository {
    private final UtlAddressDescriptor descriptor;
    private final HstrTable<Object> table;
    private final HashSet<IConfigEntityContainer<? extends IConfigEntity>> createdContainers;
    private final HashSet<IConfigEntityContainer<? extends IConfigEntity>> removedContainers;

    protected ConfigRepositoryBase(UtlAddressDescriptor descriptor) {
        this.descriptor = descriptor;
        this.table = new HstrTable(null, 0);
        this.createdContainers = new HashSet();
        this.removedContainers = new HashSet();
    }

    private final Object getObject(String address) {
        HstrTable.Node node = this.table.get(address);
        if (node != null) {
            return node.getObject();
        }
        return null;
    }

    private final boolean isParentSimpleEntity(String addr) {
        Object object;
        String parentAddr = addr.substring(0, addr.lastIndexOf(47));
        return parentAddr.length() > 0 && (object = this.getObject(parentAddr)) != null && object instanceof IConfigSimpleEntity;
    }

    private final IConfigEntityContainer<? extends IConfigEntity> createEntityContainer(boolean simple, String address, boolean markAsDirty) throws EConfigException {
        if (address.startsWith("/")) {
            if (!this.isParentSimpleEntity(address)) {
                Object object = this.getObject(address);
                if (object == null) {
                    IConfigEntityContainer<IConfigSimpleEntity> container = simple ? this.doCreateSimpleEntityContainer(address) : this.doCreateComplexEntityContainer(address);
                    try {
                        this.table.put(address, container);
                    }
                    catch (EHstrFormatException e) {
                        throw new EConfigException(e);
                    }
                    if (markAsDirty) {
                        this.createdContainers.add(container);
                    }
                    return container;
                }
                if (!simple && object instanceof IConfigSimpleEntityContainer) {
                    throw new EConfigException("A simple entity container exists at '" + address + "'");
                }
                if (simple && object instanceof IConfigComplexEntityContainer) {
                    throw new EConfigException("An complex entity container exists at '" + address + "'");
                }
                return simple ? (IConfigSimpleEntityContainer)object : (IConfigComplexEntityContainer)object;
            }
            throw new EConfigException("The parent node of an entity container cannot be a simple entity (simple entity must be a leaf node)");
        }
        throw new IllegalArgumentException("Container address must start with '/'");
    }

    private final void removeEntityContainer(IConfigEntityContainer<? extends IConfigEntity> container) {
        if (this.tracer.debug) {
            this.tracer.log("...Clearing out the container of its entities...", Tracer.Level.DEBUG);
        }
        container.clear();
        try {
            if (this.tracer.debug) {
                this.tracer.log("...Removing from repository table...", Tracer.Level.DEBUG);
            }
            this.table.remove(container.getAddress());
        }
        catch (EHstrFormatException e) {
            throw new InternalError("Fatal error: HSTR put reports bad format on remove when get succeeded!");
        }
        if (this.createdContainers.contains(container)) {
            if (this.tracer.debug) {
                this.tracer.log("...Removing container from created container list...", Tracer.Level.DEBUG);
            }
            this.createdContainers.remove(container);
        } else {
            if (this.tracer.debug) {
                this.tracer.log("...Adding container to deleted container list...", Tracer.Level.DEBUG);
            }
            this.removedContainers.add(container);
        }
    }

    final Set<Object> matches(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("pattern cannot be null");
        }
        try {
            LinkedHashMap<String, HstrTable.Node> nodes = this.table.matches(pattern);
            LinkedHashSet<Object> objects = new LinkedHashSet<Object>();
            for (HstrTable.Node node : nodes.values()) {
                if (node.getObject() == null) continue;
                objects.add(node.getObject());
            }
            return objects;
        }
        catch (EHstrFormatException e) {
            throw new InternalError("Unexpected error when matching nodes in the hstr table!");
        }
    }

    final void onCreateEntity(IConfigEntity entity) {
        Object object = this.getObject(entity.getAddress());
        if (object == null) {
            try {
                if (this.tracer.debug) {
                    this.tracer.log("Putting object '" + entity + "' at address " + entity.getAddress() + "...", Tracer.Level.DEBUG);
                }
                this.table.put(entity.getAddress(), entity);
            }
            catch (EHstrFormatException e) {
                throw new InternalError("Request to put an entity into the table with an invalid address format!");
            }
        } else {
            throw new InternalError("request to add an entity to an address that already has an object [object=" + object + "]!");
        }
    }

    final void onRemoveEntity(IConfigEntity entity) {
        try {
            if (this.tracer.debug) {
                this.tracer.log("Removing object from address " + entity.getAddress() + "...", Tracer.Level.DEBUG);
            }
            this.table.remove(entity.getAddress());
        }
        catch (EHstrFormatException e) {
            throw new InternalError("Request to put an entity into the table with an invalid address format!");
        }
    }

    protected abstract IConfigSimpleEntityContainer doCreateSimpleEntityContainer(String var1) throws EConfigException;

    protected abstract IConfigComplexEntityContainer doCreateComplexEntityContainer(String var1) throws EConfigException;

    protected abstract void doCommitStart() throws EConfigException;

    protected abstract void doCreateContainers(Set<IConfigEntityContainer<? extends IConfigEntity>> var1) throws EConfigException;

    protected abstract void doClearContainers(Set<IConfigEntityContainer<? extends IConfigEntity>> var1) throws EConfigException;

    protected abstract void doDeleteContainers(Set<IConfigEntityContainer<? extends IConfigEntity>> var1) throws EConfigException;

    protected abstract void doSaveEntities(Set<IConfigEntity> var1) throws EConfigException;

    protected abstract void doCommitEnd() throws EConfigException;

    protected abstract void doClose() throws EConfigException;

    public final IConfigSimpleEntityContainer createSimpleEntityContainerObject(String address, boolean markAsDirty) throws EConfigException {
        if (this.tracer.debug) {
            this.tracer.log("Creating simple entity container object at '" + address + "' (dirty=" + markAsDirty + ")...", Tracer.Level.DEBUG);
        }
        return (IConfigSimpleEntityContainer)this.createEntityContainer(true, address, markAsDirty);
    }

    public final IConfigComplexEntityContainer createComplexEntityContainerObject(String address, boolean markAsDirty) throws EConfigException {
        if (this.tracer.debug) {
            this.tracer.log("Creating complex entity container object at '" + address + "' (dirty=" + markAsDirty + ")...", Tracer.Level.DEBUG);
        }
        return (IConfigComplexEntityContainer)this.createEntityContainer(false, address, markAsDirty);
    }

    @Override
    public final String getDescriptor() {
        return this.descriptor == null ? null : this.descriptor.toFullString();
    }

    @Override
    public final IConfigSimpleEntityContainer createSimpleEntityContainer(String address) throws EConfigException {
        return this.createSimpleEntityContainerObject(address, true);
    }

    @Override
    public final IConfigComplexEntityContainer createComplexEntityContainer(String address) throws EConfigException {
        return this.createComplexEntityContainerObject(address, true);
    }

    @Override
    public final IConfigSimpleEntityContainer getSimpleEntityContainer(String address) {
        Object object = this.getObject(address);
        if (object != null && object instanceof IConfigSimpleEntityContainer) {
            return (IConfigSimpleEntityContainer)object;
        }
        return null;
    }

    @Override
    public final IConfigComplexEntityContainer getComplexEntityContainer(String address) {
        Object object = this.getObject(address);
        if (object != null && object instanceof IConfigComplexEntityContainer) {
            return (IConfigComplexEntityContainer)object;
        }
        return null;
    }

    @Override
    public final IConfigSimpleEntity getSimpleEntity(String address) {
        Object object = this.getObject(address);
        if (object != null && object instanceof IConfigSimpleEntity) {
            return (IConfigSimpleEntity)object;
        }
        return null;
    }

    @Override
    public final IConfigComplexEntity getComplexEntity(String address) {
        Object object = this.getObject(address);
        if (object != null && object instanceof IConfigComplexEntity) {
            return (IConfigComplexEntity)object;
        }
        return null;
    }

    @Override
    public final IConfigSimpleEntityContainer removeSimpleEntityContainer(String address) {
        Object object;
        if (this.tracer.debug) {
            this.tracer.log("Removing simple entity container from '" + address + "'...", Tracer.Level.DEBUG);
        }
        if ((object = this.getObject(address)) != null && object instanceof IConfigSimpleEntityContainer) {
            IConfigSimpleEntityContainer container = (IConfigSimpleEntityContainer)object;
            this.removeEntityContainer(container);
            return container;
        }
        if (this.tracer.debug) {
            this.tracer.log("Object at '" + address + "' is not a simple entity container.", Tracer.Level.DEBUG);
        }
        return null;
    }

    @Override
    public final IConfigComplexEntityContainer removeComplexEntityContainer(String address) {
        Object object;
        if (this.tracer.debug) {
            this.tracer.log("Removing complex entity container from '" + address + "'...", Tracer.Level.DEBUG);
        }
        if ((object = this.getObject(address)) != null && object instanceof IConfigComplexEntityContainer) {
            IConfigComplexEntityContainer container = (IConfigComplexEntityContainer)object;
            this.removeEntityContainer(container);
            return container;
        }
        return null;
    }

    @Override
    public final void traverse(String filter, IConfigTraversalCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        if (this.tracer.debug) {
            this.tracer.log("Traversing repository using filter '" + filter + "'...", Tracer.Level.DEBUG);
        }
        Set<Object> matches = this.matches(filter);
        for (Object object : matches) {
            if (object instanceof IConfigSimpleEntityContainer) {
                callback.onSimpleEntityContainer((IConfigSimpleEntityContainer)object);
                continue;
            }
            if (object instanceof IConfigComplexEntityContainer) {
                callback.onComplexEntityContainer((IConfigComplexEntityContainer)object);
                continue;
            }
            if (object instanceof IConfigSimpleEntity) {
                callback.onSimpleEntity((IConfigSimpleEntity)object);
                continue;
            }
            if (!(object instanceof IConfigComplexEntity)) continue;
            callback.onComplexEntity((IConfigComplexEntity)object);
        }
    }

    @Override
    public final void serialize(StringBuilder builder) {
        if (this.tracer.debug) {
            this.tracer.log("Serialize the repository to a string...", Tracer.Level.DEBUG);
        }
        try {
            LinkedHashMap<String, HstrTable.Node> nodes = this.table.matches("...");
            Iterator<HstrTable.Node> iterator = nodes.values().iterator();
            while (iterator.hasNext()) {
                ConfigEntityContainerBase container;
                Object object = iterator.next().getObject();
                if (object instanceof IConfigSimpleEntityContainer) {
                    container = (ConfigSimpleEntityContainerBase)object;
                    if (this.tracer.debug) {
                        this.tracer.log("...Serializing simple container '" + container.getAddress() + "'...", Tracer.Level.DEBUG);
                    }
                    builder.append("S").append(container.getAddress());
                    builder.append("|");
                    container.serialize(builder);
                    builder.append("|");
                    continue;
                }
                if (!(object instanceof IConfigComplexEntityContainer)) continue;
                container = (ConfigComplexEntityContainerBase)object;
                if (this.tracer.debug) {
                    this.tracer.log("...Serializing complex container '" + container.getAddress() + "'...", Tracer.Level.DEBUG);
                }
                builder.append("C").append(container.getAddress());
                builder.append("|");
                container.serialize(builder);
                builder.append("|");
            }
        }
        catch (EHstrFormatException e) {
            throw new InternalError("really!!");
        }
    }

    @Override
    public final void deserialize(String str, boolean markAsDirty) throws EConfigException {
        if (this.tracer.debug) {
            this.tracer.log("Deserializing the repository from a string...\n[\n" + str + "\n", Tracer.Level.DEBUG);
        }
        int pos = 0;
        while (pos < str.length()) {
            IConfigEntityContainer<IConfigSimpleEntity> container;
            char containerType = str.charAt(pos);
            int containerStartMarkerPos = str.indexOf(124, pos);
            if (containerStartMarkerPos < 0) {
                throw new IllegalArgumentException("Supplied string is not a valid serialized repository");
            }
            String containerAddr = str.substring(pos + 1, containerStartMarkerPos);
            if (containerType == 'S') {
                if (this.tracer.debug) {
                    this.tracer.log("Found simple entity container at '" + containerAddr + "'...", Tracer.Level.DEBUG);
                }
                container = this.createSimpleEntityContainerObject(containerAddr, markAsDirty);
            } else if (containerType == 'C') {
                if (this.tracer.debug) {
                    this.tracer.log("Found complex entity container at '" + containerAddr + "'...", Tracer.Level.DEBUG);
                }
                container = this.createComplexEntityContainerObject(containerAddr, markAsDirty);
            } else {
                throw new IllegalArgumentException("Supplied string is not a valid serialized repository");
            }
            int containerEndMarkerPos = str.indexOf(124, containerStartMarkerPos + 1);
            if (containerEndMarkerPos < 0) {
                throw new IllegalArgumentException("Supplied string is not a valid serialized repository");
            }
            container.deserialize(str.substring(containerStartMarkerPos + 1, containerEndMarkerPos), markAsDirty);
            pos = containerEndMarkerPos + 1;
        }
    }

    @Override
    public final void commit() throws EConfigException {
        if (this.tracer.debug) {
            this.tracer.log("Starting the commit process...", Tracer.Level.DEBUG);
        }
        this.doCommitStart();
        if (this.tracer.debug) {
            this.tracer.log("Preparing dirty entity and container sets...", Tracer.Level.DEBUG);
        }
        HashSet<IConfigEntityContainer<? extends IConfigEntity>> dirtyContainers = new HashSet<IConfigEntityContainer<? extends IConfigEntity>>();
        HashSet<IConfigEntity> dirtyEntities = new HashSet<IConfigEntity>();
        try {
            LinkedHashMap<String, HstrTable.Node> nodes = this.table.matches("...");
            Iterator<HstrTable.Node> iterator = nodes.values().iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next().getObject();
                if (object instanceof IConfigSimpleEntityContainer || object instanceof IConfigComplexEntityContainer) {
                    IConfigEntityContainer container = (IConfigEntityContainer)object;
                    if (!container.isDirty()) continue;
                    if (this.tracer.debug) {
                        this.tracer.log("...Container '" + container.getAddress() + "' is dirty.", Tracer.Level.DEBUG);
                    }
                    if (!this.createdContainers.contains(container)) {
                        if (this.tracer.debug) {
                            this.tracer.log(".....Container -> dirty container list...", Tracer.Level.DEBUG);
                        }
                        dirtyContainers.add(container);
                    } else if (this.tracer.debug) {
                        this.tracer.log(".....Container X dirty container list (in created list)...", Tracer.Level.DEBUG);
                    }
                    Iterator entityIterator = container.iterator();
                    while (entityIterator.hasNext()) {
                        IConfigEntity entity = (IConfigEntity)entityIterator.next();
                        if (this.tracer.debug) {
                            this.tracer.log(".....Entity '" + entity.getAddress() + "' --> dirty entity set...", Tracer.Level.DEBUG);
                        }
                        dirtyEntities.add(entity);
                    }
                    continue;
                }
                if (!(object instanceof IConfigEntity)) {
                    throw new InternalError("Unknown object type in repository table!");
                }
                IConfigEntity entity = (IConfigEntity)object;
                if (!entity.isDirty()) continue;
                if (this.tracer.debug) {
                    this.tracer.log("...Adding entity '" + entity.getAddress() + "' to dirty entity set...", Tracer.Level.DEBUG);
                }
                dirtyEntities.add(entity);
            }
        }
        catch (EHstrFormatException e) {
            throw new InternalError("really!!");
        }
        if (this.tracer.debug) {
            this.tracer.log("Creating new containers (count=" + this.createdContainers.size() + ")...", Tracer.Level.DEBUG);
        }
        this.doCreateContainers(this.createdContainers);
        if (this.tracer.debug) {
            this.tracer.log("Clearing the dirty containers (count=" + dirtyContainers.size() + ")...", Tracer.Level.DEBUG);
        }
        this.doClearContainers(dirtyContainers);
        if (this.tracer.debug) {
            this.tracer.log("Deleting the removed containers (count=" + this.removedContainers.size() + ")...", Tracer.Level.DEBUG);
        }
        this.doDeleteContainers(this.removedContainers);
        if (this.tracer.debug) {
            this.tracer.log("Saving the dirty entities (count=" + dirtyEntities.size() + ")...", Tracer.Level.DEBUG);
        }
        this.doSaveEntities(dirtyEntities);
        if (this.tracer.debug) {
            this.tracer.log("Ending the commit process...", Tracer.Level.DEBUG);
        }
        this.doCommitEnd();
        if (this.tracer.debug) {
            this.tracer.log("Marking created containers as clean...", Tracer.Level.DEBUG);
        }
        Iterator<IConfigEntityContainer<? extends IConfigEntity>> createdContainerIterator = this.createdContainers.iterator();
        while (createdContainerIterator.hasNext()) {
            createdContainerIterator.next().setDirty(false);
        }
        if (this.tracer.debug) {
            this.tracer.log("Marking dirty containers as clean...", Tracer.Level.DEBUG);
        }
        Iterator<IConfigEntityContainer<? extends IConfigEntity>> dirtyContainerIterator = dirtyContainers.iterator();
        while (dirtyContainerIterator.hasNext()) {
            dirtyContainerIterator.next().setDirty(false);
        }
        if (this.tracer.debug) {
            this.tracer.log("Marking dirty entities as clean...", Tracer.Level.DEBUG);
        }
        Iterator<IConfigEntity> entityIterator = dirtyEntities.iterator();
        while (entityIterator.hasNext()) {
            entityIterator.next().setDirty(false);
        }
        this.createdContainers.clear();
        this.removedContainers.clear();
        dirtyContainers.clear();
        dirtyEntities.clear();
        if (this.tracer.debug) {
            this.tracer.log("Commit complete.", Tracer.Level.DEBUG);
        }
    }

    @Override
    public final void close() throws EConfigException {
        this.doClose();
    }

    public final String toString() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.table.dump(new PrintStream(os));
        return os.toString();
    }
}

