/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.config.impl;

import com.neeve.config.EConfigException;
import com.neeve.config.IConfigContentNode;
import com.neeve.config.IConfigEntity;
import com.neeve.config.IConfigEntityContainer;
import com.neeve.config.IConfigRepository;
import com.neeve.config.impl.ConfigContentNodeBase;
import com.neeve.config.impl.ConfigRepositoryBase;
import com.neeve.trace.Tracer;
import java.util.HashMap;
import java.util.Iterator;

public abstract class ConfigEntityContainerBase<T extends IConfigEntity>
extends ConfigContentNodeBase
implements IConfigEntityContainer<T> {
    protected final HashMap<String, T> entities = new HashMap();

    protected ConfigEntityContainerBase(IConfigRepository repository, String address) throws EConfigException {
        super(repository, address);
    }

    protected abstract T doCreateEntity(String var1);

    @Override
    public final T createEntity(String name) throws EConfigException {
        if (name == null) {
            throw new IllegalArgumentException("entity name cannot be null");
        }
        if (name.contains("/")) {
            throw new IllegalArgumentException("An entity name cannot contain the '/' character");
        }
        if (name.contains("\\")) {
            throw new IllegalArgumentException("An entity name cannot contain the '\\' character");
        }
        if (this.getEntity(name) != null) {
            throw new EConfigException("An entity with name '" + name + "' already exists at address '" + this.getAddress() + "'");
        }
        T entity = this.doCreateEntity(name);
        this.entities.put(name, entity);
        ((ConfigRepositoryBase)this.repository).onCreateEntity((IConfigEntity)entity);
        this.setDirty(true);
        return entity;
    }

    @Override
    public final T getEntity(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return (T)((IConfigEntity)this.entities.get(name));
    }

    @Override
    public T removeEntity(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        IConfigEntity entity = (IConfigEntity)this.entities.remove(name);
        if (entity != null) {
            ((ConfigRepositoryBase)this.repository).onRemoveEntity(entity);
        }
        this.setDirty(true);
        return (T)entity;
    }

    @Override
    public final void serialize(StringBuilder builder) {
        builder.append(this.entities.size());
        for (IConfigEntity entity : this.entities.values()) {
            builder.append("[").append(entity.getName()).append("<");
            entity.serialize(builder);
            builder.append(">]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void deserialize(String str, boolean markAsDirty) throws EConfigException {
        if (this.tracer.debug) {
            this.tracer.log("Deserializing container at '" + this.getAddress() + "' from '" + str + "'...", Tracer.Level.DEBUG);
        }
        boolean dirty = this.isDirty();
        try {
            int entityCountEndMarkerPos = str.indexOf(91, 0);
            int count = 0;
            if (entityCountEndMarkerPos >= 0) {
                count = Integer.valueOf(str.substring(0, entityCountEndMarkerPos));
            }
            if (this.tracer.debug) {
                this.tracer.log("Number of entities=" + count, Tracer.Level.DEBUG);
            }
            int entityEndMarkerPos = 0;
            for (int i = 0; i < count; ++i) {
                int entityStartMarkerPos = str.indexOf(91, entityEndMarkerPos);
                if (entityStartMarkerPos < 0) {
                    throw new IllegalArgumentException("Supplied string is not a valid serialized repository");
                }
                int entityContentStartMarkerPos = str.indexOf(60, entityStartMarkerPos);
                if (entityContentStartMarkerPos < 0) {
                    throw new IllegalArgumentException("Supplied string is not a valid serialized repository");
                }
                int entityContentEndMarkerPos = str.indexOf(62, entityContentStartMarkerPos);
                if (entityContentEndMarkerPos < 0) {
                    throw new IllegalArgumentException("Supplied string is not a valid serialized repository");
                }
                String name = str.substring(entityStartMarkerPos + 1, entityContentStartMarkerPos);
                if (this.tracer.debug) {
                    this.tracer.log("Found entity with name '" + name + "'", Tracer.Level.DEBUG);
                }
                Object entity = this.createEntity(name);
                entity.deserialize(str.substring(entityContentStartMarkerPos + 1, entityContentEndMarkerPos), markAsDirty);
                entityEndMarkerPos = str.indexOf(93, entityContentEndMarkerPos);
                if (entityEndMarkerPos >= 0) continue;
                throw new IllegalArgumentException("Supplied string is not a valid serialized repository");
            }
            this.setDirty(dirty || markAsDirty);
        }
        catch (Throwable throwable) {
            this.setDirty(dirty || markAsDirty);
            throw throwable;
        }
    }

    @Override
    public final Iterator<T> iterator() {
        return this.entities.values().iterator();
    }

    @Override
    public final IConfigContentNode clear() {
        Iterator<T> iterator = this.iterator();
        while (iterator.hasNext()) {
            this.removeEntity(((IConfigEntity)iterator.next()).getName());
            iterator = this.iterator();
        }
        this.setDirty(true);
        return this;
    }
}

