/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.test.unit;

import com.neeve.rog.IRogRawMessage;
import com.neeve.rog.impl.RogRawMessageFactory;
import com.neeve.rog.impl.RogRawMessageImpl;
import com.neeve.sma.MessageView;
import com.neeve.sma.MessageViewFactory;
import com.neeve.sma.MessageViewFactoryRegistry;
import com.neeve.test.UnitTest;
import com.neeve.util.UtlObjectGraph;
import java.nio.ByteBuffer;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class RogRawMessageTest
extends UnitTest {
    private void testSerializeDeserialize(IRogRawMessage message) {
        byte[] byteArray = message.serializeToByteArray();
        Assert.assertEquals((String)"Wrong content encoding type", (long)1L, (long)message.getMessageEncodingType());
        Assert.assertEquals((String)"Wrong object", (Object)message.getRawMessage(), (Object)ByteBuffer.wrap(byteArray));
        IRogRawMessage deserialized = RogRawMessageImpl.createFrom(byteArray);
        Assert.assertEquals((String)"Wrong content encoding type", (long)1L, (long)deserialized.getMessageEncodingType());
        Assert.assertEquals((String)"Wrong object", (Object)message.getRawMessage(), (Object)deserialized.getRawMessage());
        ByteBuffer buffer = message.serializeToByteBuffer();
        Assert.assertEquals((String)"Wrong content encoding type", (long)1L, (long)message.getMessageEncodingType());
        Assert.assertEquals((String)"Wrong object", (Object)message.getRawMessage(), (Object)buffer);
        deserialized = RogRawMessageImpl.createFrom(buffer);
        Assert.assertEquals((String)"Wrong content encoding type", (long)1L, (long)deserialized.getMessageEncodingType());
        Assert.assertEquals((String)"Wrong object", (Object)message.getRawMessage(), (Object)ByteBuffer.wrap(byteArray));
        String json = message.serializeToJson();
        System.out.println("Json encoded: " + json);
        deserialized = RogRawMessageImpl.createFrom(buffer);
        Assert.assertEquals((String)"Objects should be equal after serialize to/from json", (Object)message.getRawMessage(), (Object)deserialized.getRawMessage());
    }

    @Test
    public void testMessageViewFactoryCreate() {
        ByteBuffer rawData = ByteBuffer.wrap(UtlObjectGraph.BuiltInHandler.createRandomByteArray((int)50, (Random)new Random()));
        MessageViewFactory factory = MessageViewFactoryRegistry.getInstance().getMessageViewFactory((short)7);
        Assert.assertNotNull((String)"RogRawMessageFactory was not registered as message view factory", (Object)factory);
        Assert.assertEquals((String)"Wrong factory type returned from message view factory", RogRawMessageFactory.class, factory.getClass());
        MessageView message = factory.wrap((short)0, 1, (Object)rawData);
        Assert.assertNotNull((String)"Failed to wrap raw message payload", (Object)message);
        Assert.assertTrue((String)"Wrapped message is not a raw message ", (boolean)(message instanceof IRogRawMessage));
        this.testSerializeDeserialize((IRogRawMessage)message);
    }

    @Test
    public void testMessageViewFactoryCreateFromBytes() {
        byte[] rawData = UtlObjectGraph.BuiltInHandler.createRandomByteArray((int)50, (Random)new Random());
        MessageViewFactory factory = MessageViewFactoryRegistry.getInstance().getMessageViewFactory((short)7);
        Assert.assertNotNull((String)"RogRawMessageFactory was not registered as message view factory", (Object)factory);
        Assert.assertEquals((String)"Wrong factory type returned from message view factory", RogRawMessageFactory.class, factory.getClass());
        MessageView message = factory.wrap((short)0, 1, (Object)rawData);
        Assert.assertNotNull((String)"Failed to wrap raw message payload", (Object)message);
        Assert.assertTrue((String)"Wrapped message is not a raw message ", (boolean)(message instanceof IRogRawMessage));
        this.testSerializeDeserialize((IRogRawMessage)message);
    }

    @Test
    public void testMessageViewFactoryCreateFromDirect() {
        byte[] rawBytes = UtlObjectGraph.BuiltInHandler.createRandomByteArray((int)50, (Random)new Random());
        ByteBuffer rawData = ByteBuffer.allocateDirect(rawBytes.length);
        rawData.put(rawBytes, 0, rawBytes.length);
        rawData.position(0);
        MessageViewFactory factory = MessageViewFactoryRegistry.getInstance().getMessageViewFactory((short)7);
        Assert.assertNotNull((String)"RogRawMessageFactory was not registered as message view factory", (Object)factory);
        Assert.assertEquals((String)"Wrong factory type returned from message view factory", RogRawMessageFactory.class, factory.getClass());
        MessageView message = factory.wrap((short)0, 1, (Object)rawData);
        Assert.assertNotNull((String)"Failed to wrap raw message payload", (Object)message);
        Assert.assertTrue((String)"Wrapped message is not a raw message ", (boolean)(message instanceof IRogRawMessage));
        this.testSerializeDeserialize((IRogRawMessage)message);
    }
}

