/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.log.test.unit;

import com.neeve.ci.XRuntime;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.log.EPktLogCorruptException;
import com.neeve.pkt.log.PktRecoveryLog;
import com.neeve.rog.log.RogLog;
import com.neeve.rog.log.RogLogReader;
import com.neeve.rog.log.test.unit.messages.proto.Factory;
import com.neeve.rog.log.test.unit.messages.proto.OutMessage;
import com.neeve.test.UnitTest;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.Properties;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public final class RogLogCorruptTest
extends UnitTest {
    private RogLog log;
    private RogLogReader reader;
    private RandomAccessFile raf;
    private int logCount;

    private final String logName() {
        return "logCorruptTest-" + System.currentTimeMillis() + "-" + ++this.logCount;
    }

    private final String createLog(String logName, boolean autoRepair) throws Exception {
        if (logName == null) {
            logName = this.logName();
        }
        Properties props = new Properties();
        props.setProperty("detachedPersist", "false");
        props.setProperty("initialLogLength", "0.01");
        props.setProperty("autoRepair", String.valueOf(autoRepair));
        this.log = RogLog.create(logName, props);
        this.log.open();
        this.reader = this.log.createReader();
        RogLogReader.registerFactory(new Factory());
        this.raf = new RandomAccessFile(XRuntime.getDataDirectory((boolean)false) + File.separator + logName + ".log", "rw");
        return logName;
    }

    private final OutMessage createMessage() {
        OutMessage message = OutMessage.create();
        message.setVal("test");
        return message;
    }

    private final void logNoCommitEnd(int count, long lastTransactionId) {
        for (int i = 0; i < count; ++i) {
            OutMessage message = this.createMessage();
            message.setTransactionId(lastTransactionId + (long)i + 1L);
            message.setStableTransactionId(lastTransactionId + (long)i + 1L);
            message.sync();
            this.log.log(message, false);
        }
        this.log.flush(true);
    }

    private final void log(int count, long lastTransactionId, boolean commitEachEntry) {
        for (int i = 0; i < count; ++i) {
            OutMessage message = this.createMessage();
            message.setTransactionId(lastTransactionId + (long)i + 1L);
            message.setStableTransactionId(lastTransactionId + (long)i + 1L);
            message.sync();
            this.log.log(message, commitEachEntry || i == count - 1);
        }
        this.log.flush(true);
    }

    private final void log(int count, boolean commitEachEntry) {
        this.log(count, 0L, commitEachEntry);
    }

    private final void log(int count) {
        this.log(count, false);
    }

    @After
    public void testCleanup() throws Exception {
        if (this.log != null) {
            this.log.close();
            this.log = null;
        }
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        if (this.raf != null) {
            this.raf.close();
            this.raf = null;
        }
    }

    @Test
    public void testNoCorrupt() throws Exception {
        String logName = this.createLog(null, false);
        this.log(1000);
        this.log.close();
        this.reader.close();
        this.createLog(logName, false);
        Assert.assertFalse((boolean)this.log.wasRepaired());
        int count = 0;
        while (this.reader.next() != null) {
            ++count;
        }
        Assert.assertEquals((long)1000L, (long)count);
    }

    private final void testCorruptEOFNoRepair(int numEntries) throws Exception {
        String logName = this.createLog(null, false);
        this.log(numEntries);
        this.log.close();
        this.raf.close();
        PktPacket eofPacket = PktFactory.getInstance().createPacket(262);
        int eofSize = eofPacket.getSerializedLength();
        int eofBodySize = eofSize - eofPacket.getHeader().getSerializedLength() - eofPacket.getBody().getSerializedLength();
        int eofHeaderSize = eofSize - eofBodySize;
        System.out.println("eofSize=" + eofSize + ", header=" + eofHeaderSize + ", body=" + eofBodySize);
        for (int i = 1; i <= eofHeaderSize; ++i) {
            int j;
            System.out.println("for " + i + " bytes...");
            logName = this.createLog(null, false);
            System.out.println("...create '" + logName + "'.");
            this.log(numEntries);
            long size = this.log.getSize();
            System.out.println("......size=" + size);
            this.log.close();
            this.raf.seek(size - (long)eofBodySize);
            System.out.println("...body clear begin " + this.raf.getFilePointer() + ".");
            for (j = 0; j < eofBodySize; ++j) {
                this.raf.writeByte(0);
            }
            System.out.println("...body clear end " + this.raf.getFilePointer() + ".");
            this.raf.getFD().sync();
            this.raf.seek(size - (long)eofBodySize - (long)i);
            System.out.println("...header clear begin " + this.raf.getFilePointer() + ".");
            for (j = 0; j < i; ++j) {
                this.raf.writeByte(0);
            }
            System.out.println("...header clear end " + this.raf.getFilePointer() + ".");
            this.raf.getFD().sync();
            this.raf.close();
            try {
                System.out.println("...test '" + logName + "'.");
                this.createLog(logName, false);
                Assert.fail((String)"log open on a corrupt log succeeded");
                continue;
            }
            catch (EPktLogCorruptException e) {
                this.log.close();
                this.log = null;
                this.raf.close();
                this.raf = null;
            }
        }
    }

    @Test
    public void testCorruptEOFNoRepairZeroEntries() throws Exception {
        this.testCorruptEOFNoRepair(0);
    }

    @Test
    public void testCorruptEOFNoRepairMultipleEntries() throws Exception {
        this.testCorruptEOFNoRepair(1000);
    }

    private void testCorruptEOFRepair(int numEntries) throws Exception {
        String logName = this.createLog(null, false);
        this.log(numEntries);
        this.log.close();
        this.raf.close();
        PktPacket eofPacket = PktFactory.getInstance().createPacket(262);
        int eofSize = eofPacket.getSerializedLength();
        int eofBodySize = eofSize - eofPacket.getHeader().getSerializedLength() - eofPacket.getBody().getSerializedLength();
        int eofHeaderSize = eofSize - eofBodySize;
        System.out.println("eofSize=" + eofSize + ", header=" + eofHeaderSize + ", body=" + eofBodySize);
        for (int i = 2; i <= eofHeaderSize; ++i) {
            int j;
            System.out.println("for " + i + " bytes...");
            logName = this.createLog(null, false);
            System.out.println("...create '" + logName + "'.");
            this.log(numEntries);
            long size = this.log.getSize();
            this.log.close();
            this.raf.seek(size - (long)eofBodySize);
            System.out.println("...body clear begin " + this.raf.getFilePointer() + ".");
            for (j = 0; j < eofBodySize; ++j) {
                this.raf.writeByte(0);
            }
            System.out.println("...body clear end " + this.raf.getFilePointer() + ".");
            this.raf.getFD().sync();
            this.raf.seek(size - (long)eofBodySize - (long)i);
            System.out.println("...header clear begin " + this.raf.getFilePointer() + ".");
            for (j = 0; j < i; ++j) {
                this.raf.writeByte(0);
            }
            System.out.println("...header clear end " + this.raf.getFilePointer() + ".");
            this.raf.getFD().sync();
            this.raf.close();
            System.out.println("...test '" + logName + "'.");
            this.createLog(logName, true);
            Assert.assertTrue((boolean)this.log.wasRepaired());
            int count = 0;
            while (this.reader.next() != null) {
                ++count;
            }
            Assert.assertEquals((String)("Wrong number of packets after corrupting " + i + " bytes of eof header"), (long)numEntries, (long)count);
            this.log.close();
            this.raf.close();
            this.log.delete();
            this.reader.close();
            this.log = null;
            this.raf = null;
        }
    }

    @Test
    public void testCorruptEOFRepairZeroEntries() throws Exception {
        this.testCorruptEOFRepair(0);
    }

    @Test
    public void testCorruptEOFRepairMultipleEntries() throws Exception {
        this.testCorruptEOFRepair(1000);
    }

    private void testCorruptDataNoRepair(int numEntries) throws Exception {
        String logName = this.createLog(null, false);
        this.log(numEntries, true);
        this.log.close();
        this.raf.close();
        PktPacket eofPacket = PktFactory.getInstance().createPacket(262);
        int eofSize = eofPacket.getSerializedLength();
        System.out.println("eofSize=" + eofSize);
        PktRecoveryLog rlog = PktRecoveryLog.create((String)XRuntime.getDataDirectory((boolean)false), (String)(logName + ".log"), (PktRecoveryLog.FileOpenMode)PktRecoveryLog.FileOpenMode.rw, (long)10737418L, (int)8192, (int)8192);
        rlog.open();
        PktRecoveryLog.Reader rlogreader = rlog.createReader();
        PktPacket dataPacket = rlogreader.next();
        Assert.assertNotNull((Object)dataPacket);
        int dataSize = dataPacket.getSerializedLength();
        int dataBodySize = dataPacket.getBody().getSerializedLength();
        int dataHeaderSize = dataSize - dataBodySize;
        System.out.println("dataSize=" + dataSize + ", header=" + dataHeaderSize + ", body=" + dataBodySize);
        rlogreader.close();
        rlog.close();
        for (int i = 1; i <= dataHeaderSize; ++i) {
            int j;
            System.out.println("for " + i + " bytes...");
            logName = this.createLog(null, false);
            System.out.println("...create '" + logName + "'.");
            this.log(numEntries, true);
            long size = this.log.getSize();
            this.log.close();
            this.raf.seek(size - (long)(dataBodySize + eofSize));
            System.out.println("...body clear begin " + this.raf.getFilePointer() + ".");
            for (j = 0; j < dataBodySize + eofSize; ++j) {
                this.raf.writeByte(0);
            }
            System.out.println("...body clear end " + this.raf.getFilePointer() + ".");
            this.raf.getFD().sync();
            this.raf.seek(size - (long)(dataBodySize + eofSize) - (long)i);
            System.out.println("...header clear begin " + this.raf.getFilePointer() + ".");
            for (j = 0; j < i; ++j) {
                this.raf.writeByte(0);
            }
            System.out.println("...header clear end " + this.raf.getFilePointer() + ".");
            this.raf.getFD().sync();
            this.raf.close();
            try {
                System.out.println("...test '" + logName + "'.");
                this.createLog(logName, false);
                Assert.fail((String)"log open on a corrupt log succeeded");
                continue;
            }
            catch (EPktLogCorruptException e) {
                this.log.close();
                this.log = null;
                this.raf.close();
                this.raf = null;
            }
        }
    }

    @Test
    public void testCorruptDataNoRepairSingleEntry() throws Exception {
        this.testCorruptDataNoRepair(1);
    }

    @Test
    public void testCorruptDataNoRepairMultipleEntries() throws Exception {
        this.testCorruptDataNoRepair(1000);
    }

    private void testCorruptDataRepair(int numEntries) throws Exception {
        PktPacket packet;
        String logName = this.createLog(null, false);
        this.log(numEntries, true);
        this.log.close();
        this.raf.close();
        PktPacket eofPacket = PktFactory.getInstance().createPacket(262);
        int eofSize = eofPacket.getSerializedLength();
        System.out.println("eofSize=" + eofSize);
        PktRecoveryLog rlog = PktRecoveryLog.create((String)XRuntime.getDataDirectory((boolean)false), (String)(logName + ".log"), (PktRecoveryLog.FileOpenMode)PktRecoveryLog.FileOpenMode.rw, (long)10737418L, (int)8192, (int)8192);
        rlog.open();
        PktRecoveryLog.Reader rlogreader = rlog.createReader();
        PktPacket dataPacket = null;
        while ((packet = rlogreader.next()) != null) {
            dataPacket = packet;
        }
        Assert.assertNotNull((Object)dataPacket);
        int dataSize = dataPacket.getSerializedLength();
        int dataHeaderSize = dataPacket.getHeader().getSerializedLength();
        int dataBodySize = dataPacket.getBody().getSerializedLength();
        System.out.println("dataSize=" + dataSize + ", header=" + dataHeaderSize + ", body=" + dataBodySize);
        rlogreader.close();
        rlog.close();
        for (int i = 2; i <= 34; ++i) {
            int j;
            System.out.println("for " + i + " bytes...");
            logName = this.createLog(null, false);
            System.out.println("...create '" + logName + "'.");
            this.log(numEntries, true);
            long size = this.log.getSize();
            System.out.println(".......size=" + size);
            this.log.close();
            this.raf.seek(size - (long)(dataHeaderSize - 34 + dataBodySize + eofSize));
            System.out.println("...body clear begin " + this.raf.getFilePointer() + ".");
            for (j = 0; j < dataBodySize + eofSize; ++j) {
                this.raf.writeByte(0);
            }
            System.out.println("...body clear end " + this.raf.getFilePointer() + ".");
            this.raf.getFD().sync();
            this.raf.seek(size - (long)(dataHeaderSize - 34 + dataBodySize + eofSize) - (long)i);
            System.out.println("...header clear begin " + this.raf.getFilePointer() + ".");
            for (j = 0; j < i; ++j) {
                this.raf.writeByte(0);
            }
            System.out.println("...header clear end " + this.raf.getFilePointer() + ".");
            this.raf.getFD().sync();
            this.raf.close();
            System.out.println("...test '" + logName + "'.");
            this.createLog(logName, true);
            Assert.assertTrue((boolean)this.log.wasRepaired());
            int count = 0;
            while (this.reader.next() != null) {
                ++count;
            }
            this.reader.close();
            Assert.assertEquals((String)("Wrong number of packets read after clearing header byte " + i), (long)(numEntries - 1), (long)count);
            this.log.close();
            this.raf.close();
            this.log.delete();
            this.log = null;
            this.raf = null;
        }
    }

    @Test
    public void testCorruptDataRepairSingleEntry() throws Exception {
        this.testCorruptDataRepair(1);
    }

    @Test
    public void testCorruptDataRepairMultipleEntries() throws Exception {
        this.testCorruptDataRepair(1000);
    }

    private void testPartialLastTransactionNoRepair(int numTransactions, int[] numEntriesPerTransaction) throws Exception {
        String logName = this.createLog(null, false);
        for (int i = 0; i < numTransactions; ++i) {
            if (i == numTransactions - 1) {
                this.logNoCommitEnd(numEntriesPerTransaction[i], i * numEntriesPerTransaction[i]);
                continue;
            }
            this.log(numEntriesPerTransaction[i], i * numEntriesPerTransaction[i], false);
        }
        this.log.close();
        this.raf.close();
        try {
            System.out.println("...test '" + logName + "'.");
            this.createLog(logName, false);
            Assert.fail((String)"log open on a corrupt log succeeded");
        }
        catch (EPktLogCorruptException e) {
            this.log.close();
            this.log = null;
            this.raf.close();
            this.raf = null;
        }
    }

    @Test
    public void testPartialLastTransactionNoRepairOneTransaction() throws Exception {
        this.testPartialLastTransactionNoRepair(1, new int[]{5});
    }

    @Test
    public void testPartialLastTransactionNoRepairMultipleTransactions() throws Exception {
        this.testPartialLastTransactionNoRepair(5, new int[]{5, 4, 6, 1, 1});
    }

    private void testPartialLastTransactionRepair(int numTransactions, int[] numEntriesPerTransaction) throws Exception {
        int numEntries = 0;
        String logName = this.createLog(null, false);
        for (int i = 0; i < numTransactions; ++i) {
            if (i == numTransactions - 1) {
                this.logNoCommitEnd(numEntriesPerTransaction[i], i * numEntriesPerTransaction[i]);
            } else {
                this.log(numEntriesPerTransaction[i], i * numEntriesPerTransaction[i], false);
            }
            numEntries += numEntriesPerTransaction[i];
        }
        this.log.close();
        this.raf.close();
        System.out.println("...test '" + logName + "'.");
        this.createLog(logName, true);
        Assert.assertTrue((boolean)this.log.wasRepaired());
        int count = 0;
        while (this.reader.next() != null) {
            ++count;
        }
        this.reader.close();
        Assert.assertEquals((String)"Wrong number of packets read after repair", (long)(numEntries - numEntriesPerTransaction[numEntriesPerTransaction.length - 1]), (long)count);
        this.log.close();
        this.log.delete();
        this.log = null;
    }

    @Test
    public void testPartialLastTransactionRepairOneTransaction() throws Exception {
        this.testPartialLastTransactionRepair(1, new int[]{5});
    }

    @Test
    public void testPartialLastTransactionRepairMultipleTransactions() throws Exception {
        this.testPartialLastTransactionRepair(5, new int[]{5, 4, 6, 1, 3});
    }

    private void testMissingEOFNoRepair(int numEntries) throws Exception {
        block2: {
            String logName = this.createLog(null, false);
            this.log(numEntries);
            long logSize = this.log.getSize();
            this.log.close();
            PktPacket eofPacket = PktFactory.getInstance().createPacket(262);
            int eofSize = eofPacket.getSerializedLength();
            int eofBodySize = eofSize - eofPacket.getHeader().getSerializedLength() - eofPacket.getBody().getSerializedLength();
            int eofHeaderSize = eofSize - eofBodySize;
            System.out.println("eofSize=" + eofSize + ", header=" + eofHeaderSize + ", body=" + eofBodySize);
            this.raf.setLength(logSize - (long)eofSize);
            this.raf.getFD().sync();
            this.raf.close();
            try {
                logName = this.createLog(logName, false);
                Assert.fail((String)"Should have gotten EPktLogCorruptException");
            }
            catch (EPktLogCorruptException plce) {
                if (plce.getMessage().indexOf("EOF but no EOF marker") != -1) break block2;
                Assert.fail((String)("Should have gotten EPktLogCorruptException with 'EOF but no EOF marker', but got: " + plce.getMessage()));
            }
        }
    }

    @Test
    public void testMissingEOFNoRepairZeroEntries() throws Exception {
        this.testMissingEOFNoRepair(0);
    }

    @Test
    public void testMissingEOFNoRepairMultipleEntries() throws Exception {
        this.testMissingEOFNoRepair(1000);
    }

    private void testMissingEOFRepair(int numEntries) throws Exception {
        String logName = this.createLog(null, false);
        this.log(numEntries);
        long logSize = this.log.getSize();
        this.log.close();
        PktPacket eofPacket = PktFactory.getInstance().createPacket(262);
        int eofSize = eofPacket.getSerializedLength();
        int eofBodySize = eofSize - eofPacket.getHeader().getSerializedLength() - eofPacket.getBody().getSerializedLength();
        int eofHeaderSize = eofSize - eofBodySize;
        System.out.println("eofSize=" + eofSize + ", header=" + eofHeaderSize + ", body=" + eofBodySize);
        this.raf.setLength(logSize - (long)eofSize);
        this.raf.getFD().sync();
        this.raf.close();
        logName = this.createLog(logName, true);
        Assert.assertTrue((String)"Log should have been repaired", (boolean)this.log.wasRepaired());
        RogLogReader reader = this.log.createReader();
        for (int i = 0; i < numEntries; ++i) {
            reader.next();
        }
        Assert.assertEquals((String)"Wrong number of sends in repaired log", (long)numEntries, (long)reader.getStats().getNumSends());
    }

    @Test
    public void testMissingEOFRepairZeroEntries() throws Exception {
        this.testMissingEOFRepair(0);
    }

    @Test
    public void testMissingEOFRepairMultipleEntries() throws Exception {
        this.testMissingEOFRepair(1000);
    }
}

