/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.log.test.unit;

import com.neeve.adm.AdmEncodingType;
import com.neeve.adm.test.unit.proto.Factory;
import com.neeve.ods.IStoreCheckpointingController;
import com.neeve.ods.IStoreObject;
import com.neeve.ods.IStoreObjectFactory;
import com.neeve.ods.OdsException;
import com.neeve.ods.StoreDescriptor;
import com.neeve.ods.StorePersisterDescriptor;
import com.neeve.ods.StoreReplicatorDescriptor;
import com.neeve.rog.IRogMetadata;
import com.neeve.rog.IRogRootNode;
import com.neeve.rog.impl.RogNode;
import com.neeve.rog.log.RogLog;
import com.neeve.rog.log.RogLogCheckpointReaderParams;
import com.neeve.rog.log.RogLogReader;
import com.neeve.rog.test.unit.RogReplicatedStoreTestBase;
import com.neeve.util.UtlObjectGraph;
import com.neeve.util.UtlReflection;
import com.neeve.util.UtlTableFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RogLogCompactionTest
extends RogReplicatedStoreTestBase {
    @Parameterized.Parameter(value=0)
    public AdmEncodingType encoding;
    @Parameterized.Parameter(value=1)
    public boolean cdcEnabled = false;
    @Parameterized.Parameter(value=2)
    public boolean clustered = true;

    @Parameterized.Parameters(name="{index}_{0}_cdc_{1}_clustered_{2}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{AdmEncodingType.Protobuf, true, false}};
        return Arrays.asList(data);
    }

    @Before
    public void setup() throws OdsException {
        this.memberCount = !this.clustered ? 1 : 2;
        ((RogReplicatedStoreTestBase)this).cdcEnabled = this.cdcEnabled;
    }

    @After
    public void tearDown() throws OdsException, InterruptedException {
        RogLogCompactionTest.closeOpenMembers();
    }

    @Override
    protected Collection<IStoreObjectFactory> getObjectFactories() {
        switch (this.encoding) {
            case Protobuf: {
                return Arrays.asList(new Factory());
            }
            case Xbuf: {
                return Arrays.asList(new com.neeve.adm.test.unit.xbuf.Factory());
            }
            case Json: {
                return Arrays.asList(new com.neeve.adm.test.unit.json.Factory());
            }
        }
        return null;
    }

    @Override
    protected void configureStoreDescriptor(StoreDescriptor descriptor) {
        descriptor.setCheckpointingType(IStoreCheckpointingController.Type.Default);
        descriptor.setCheckpointThreshold(1);
    }

    @Override
    protected void configurePersisterDescriptor(StorePersisterDescriptor persisterDescriptor) {
        persisterDescriptor.setProperty("logScavengePolicy", "Delete");
        persisterDescriptor.setProperty("initialLogLength", "0");
        persisterDescriptor.setProperty("cdcEnabled", String.valueOf(this.cdcEnabled));
        persisterDescriptor.setCompactorProperty("compactionThreshold", "128k");
        persisterDescriptor.setCompactorProperty("conflateCheckpoints", String.valueOf(true));
        persisterDescriptor.setCompactorProperty("offheapBuffering", String.valueOf(true));
        persisterDescriptor.setCompactorProperty("offheapBufferingLoadStrategy", RogLogCheckpointReaderParams.OffheapBufferingLoadStrategy.MemoryMappedRead.name());
        persisterDescriptor.setCompactorProperty("memMappedReadBufferMaxSize", "4k");
    }

    @Override
    public void configureReplicatorDescriptor(StoreReplicatorDescriptor replicatorDescriptor) {
    }

    @Test
    @Ignore
    public void testObjectMoveToDifferentFieldSameTxn() throws Exception {
    }

    @Test
    public void testObjectMoveToNewParentDifferentTxn() throws Exception {
        RogLogCompactionTest.setVerbose((boolean)true);
        RogReplicatedStoreTestBase.Member m1 = this.primaryMember();
        int graphId = this.nextGraphId();
        IRogRootNode parent = (IRogRootNode)this.createFactoryObject("Parent2", graphId);
        m1.addRootObject(parent);
        Map stringMap = (Map)this.invoke((Object)parent, "getStringMapField", new Object[0]);
        RogNode childL1_1 = (RogNode)this.createFactoryObject("ChildEntity");
        RogNode childL1_2 = (RogNode)this.createFactoryObject("ChildEntity");
        RogNode childL2 = (RogNode)this.createFactoryObject("ChildEntityL2");
        this.invoke((Object)childL2, "setStringField", "TestValue");
        stringMap.put("key1", childL1_1);
        stringMap.put("key2", childL1_2);
        this.invoke((Object)childL1_1, "setChildEntityField", childL2);
        m1.commit(true);
        this.invoke((Object)childL1_1, "setChildEntityField", new Class[]{childL2.getClass()}, new Object[]{null});
        m1.commit(true);
        this.invoke((Object)childL1_2, "setChildEntityField", childL2);
        m1.commit(true);
        m1.getStore().send((IStoreObject)this.createFactoryObject("Message"));
        m1.commit(true);
        List<RogLog.Entry.Type> expected = Arrays.asList(RogLog.Entry.Type.Put, RogLog.Entry.Type.Put, RogLog.Entry.Type.Put, RogLog.Entry.Type.Put, RogLog.Entry.Type.Put, RogLog.Entry.Type.Update, RogLog.Entry.Type.Remove, RogLog.Entry.Type.Update, RogLog.Entry.Type.Put, RogLog.Entry.Type.Send);
        this.validateLogEntries("pre compaction", m1, expected);
        m1.restart();
        this.validateLogEntries("pre compaction", m1, expected);
        Object parent2 = m1.getRootObject(graphId);
        Map stringMap2 = (Map)this.invoke(parent2, "getStringMapField", new Object[0]);
        RogNode childL1_12 = (RogNode)stringMap2.get("key1");
        RogNode childL1_22 = (RogNode)stringMap2.get("key2");
        Assert.assertEquals((String)"Wrong store size after pre compact restart", (long)5L, (long)m1.getStore().size());
        Assert.assertEquals((String)"Wrong string map size after pre compact restart", (long)2L, (long)stringMap2.size());
        Assert.assertNotNull((String)"No value for key1 after pre compact restart", (Object)childL1_12);
        Assert.assertNotNull((String)"No value for key2 after pre compact restart", (Object)childL1_22);
        Assert.assertNull((String)"First parent should not have chield field afer pre compact restart", (Object)this.invoke((Object)childL1_12, "getChildEntityField", new Object[0]));
        Assert.assertNotNull((String)"Second parent should have chield field afer pre compact restart", (Object)this.invoke((Object)childL1_22, "getChildEntityField", new Object[0]));
        Assert.assertEquals((String)"Wrong value for child field", (Object)"TestValue", (Object)this.invoke(this.invoke((Object)childL1_22, "getChildEntityField", new Object[0]), "getStringField", new Object[0]));
        m1.getCompactor().compact();
        m1.getCompactor().waitForCompactionToComplete();
        m1.getPersister().sync();
        expected = Arrays.asList(RogLog.Entry.Type.Put, RogLog.Entry.Type.Put, RogLog.Entry.Type.Put, RogLog.Entry.Type.Put, RogLog.Entry.Type.Put, RogLog.Entry.Type.Send);
        this.validateLogEntries("post compaction", m1, expected);
        m1.restart();
        Object parent3 = m1.getRootObject(graphId);
        Map stringMap3 = (Map)this.invoke(parent3, "getStringMapField", new Object[0]);
        RogNode child1_13 = (RogNode)stringMap3.get("key1");
        RogNode child1_23 = (RogNode)stringMap3.get("key2");
        Assert.assertEquals((String)"Wrong store size after pre compact restart", (long)5L, (long)m1.getStore().size());
        Assert.assertEquals((String)"Wrong string map size after pre compact restart", (long)2L, (long)stringMap2.size());
        Assert.assertNotNull((String)"No value for key1 after pre compact restart", (Object)child1_13);
        Assert.assertNotNull((String)"No value for key2 after pre compact restart", (Object)child1_23);
        Assert.assertNull((String)"First parent should not have chield field afer pre compact restart", (Object)this.invoke((Object)child1_13, "getChildEntityField", new Object[0]));
        Assert.assertNotNull((String)"Second parent should have chield field afer pre compact restart", (Object)this.invoke((Object)child1_23, "getChildEntityField", new Object[0]));
        Assert.assertEquals((String)"Wrong value for child field", (Object)"TestValue", (Object)this.invoke(this.invoke((Object)child1_23, "getChildEntityField", new Object[0]), "getStringField", new Object[0]));
        this.assertGraphObjectsEqual(parent, parent3);
        this.validateLogEntries("post restart", m1, expected);
    }

    @Test
    public void testObjectMoveToNewParentSameTxn() throws Exception {
        RogLogCompactionTest.setVerbose((boolean)true);
        RogReplicatedStoreTestBase.Member m1 = this.primaryMember();
        int graphId = this.nextGraphId();
        IRogRootNode parent = (IRogRootNode)this.createFactoryObject("Parent2", graphId);
        m1.addRootObject(parent);
        Map stringMap = (Map)this.invoke((Object)parent, "getStringMapField", new Object[0]);
        RogNode childL1_1 = (RogNode)this.createFactoryObject("ChildEntity");
        RogNode childL1_2 = (RogNode)this.createFactoryObject("ChildEntity");
        RogNode childL2 = (RogNode)this.createFactoryObject("ChildEntityL2");
        this.invoke((Object)childL2, "setStringField", "TestValue");
        stringMap.put("key1", childL1_1);
        stringMap.put("key2", childL1_2);
        this.invoke((Object)childL1_1, "setChildEntityField", childL2);
        m1.commit(true);
        this.invoke((Object)childL1_1, "setChildEntityField", new Class[]{childL2.getClass()}, new Object[]{null});
        this.invoke((Object)childL1_2, "setChildEntityField", childL2);
        m1.commit(true);
        m1.getStore().send((IStoreObject)this.createFactoryObject("Message"));
        m1.commit(true);
        List<RogLog.Entry.Type> expected = Arrays.asList(RogLog.Entry.Type.Put, RogLog.Entry.Type.Put, RogLog.Entry.Type.Put, RogLog.Entry.Type.Put, RogLog.Entry.Type.Put, RogLog.Entry.Type.Update, RogLog.Entry.Type.Update, RogLog.Entry.Type.Update, RogLog.Entry.Type.Send);
        this.validateLogEntries("pre compaction", m1, expected);
        m1.restart();
        this.validateLogEntries("pre compaction", m1, expected);
        Object parent2 = m1.getRootObject(graphId);
        Map stringMap2 = (Map)this.invoke(parent2, "getStringMapField", new Object[0]);
        RogNode childL1_12 = (RogNode)stringMap2.get("key1");
        RogNode childL1_22 = (RogNode)stringMap2.get("key2");
        Assert.assertEquals((String)"Wrong store size after pre compact restart", (long)5L, (long)m1.getStore().size());
        Assert.assertEquals((String)"Wrong string map size after pre compact restart", (long)2L, (long)stringMap2.size());
        Assert.assertNotNull((String)"No value for key1 after pre compact restart", (Object)childL1_12);
        Assert.assertNotNull((String)"No value for key2 after pre compact restart", (Object)childL1_22);
        Assert.assertNull((String)"First parent should not have child field afer pre compact restart", (Object)this.invoke((Object)childL1_12, "getChildEntityField", new Object[0]));
        Assert.assertNotNull((String)"Second parent should have child field afer pre compact restart", (Object)this.invoke((Object)childL1_22, "getChildEntityField", new Object[0]));
        Assert.assertEquals((String)"Wrong value for child field", (Object)"TestValue", (Object)this.invoke(this.invoke((Object)childL1_22, "getChildEntityField", new Object[0]), "getStringField", new Object[0]));
        m1.getCompactor().compact();
        m1.getCompactor().waitForCompactionToComplete();
        m1.getPersister().sync();
        expected = Arrays.asList(RogLog.Entry.Type.Put, RogLog.Entry.Type.Put, RogLog.Entry.Type.Put, RogLog.Entry.Type.Put, RogLog.Entry.Type.Put, RogLog.Entry.Type.Send);
        this.validateLogEntries("post compaction", m1, expected);
        m1.restart();
        Object parent3 = m1.getRootObject(graphId);
        Map stringMap3 = (Map)this.invoke(parent3, "getStringMapField", new Object[0]);
        RogNode child1_13 = (RogNode)stringMap3.get("key1");
        RogNode child1_23 = (RogNode)stringMap3.get("key2");
        Assert.assertEquals((String)"Wrong store size after pre compact restart", (long)5L, (long)m1.getStore().size());
        Assert.assertEquals((String)"Wrong string map size after pre compact restart", (long)2L, (long)stringMap2.size());
        Assert.assertNotNull((String)"No value for key1 after pre compact restart", (Object)child1_13);
        Assert.assertNotNull((String)"No value for key2 after pre compact restart", (Object)child1_23);
        Assert.assertNull((String)"First parent should not have chield field afer pre compact restart", (Object)this.invoke((Object)child1_13, "getChildEntityField", new Object[0]));
        Assert.assertNotNull((String)"Second parent should have chield field afer pre compact restart", (Object)this.invoke((Object)child1_23, "getChildEntityField", new Object[0]));
        Assert.assertEquals((String)"Wrong value for child field", (Object)"TestValue", (Object)this.invoke(this.invoke((Object)child1_23, "getChildEntityField", new Object[0]), "getStringField", new Object[0]));
        this.assertGraphObjectsEqual(parent, parent3);
        this.validateLogEntries("post restart", m1, expected);
    }

    @Test
    public void testObjectMoveToNewCollectionDifferentTxn() throws Exception {
        RogLogCompactionTest.setVerbose((boolean)true);
        RogReplicatedStoreTestBase.Member m1 = this.primaryMember();
        int graphId = this.nextGraphId();
        IRogRootNode parent = (IRogRootNode)this.createFactoryObject("Parent2", graphId);
        m1.addRootObject(parent);
        Map stringMap = (Map)this.invoke((Object)parent, "getStringMapField", new Object[0]);
        Map longMap = (Map)this.invoke((Object)parent, "getLongMapField", new Object[0]);
        RogNode childL1 = (RogNode)this.createFactoryObject("ChildEntity");
        this.invoke((Object)childL1, "setStringField", "TestValue");
        stringMap.put("key1", childL1);
        m1.commit(true);
        childL1 = (RogNode)stringMap.remove("key1");
        m1.commit(true);
        longMap.put(1L, childL1);
        m1.commit(true);
        m1.getStore().send((IStoreObject)this.createFactoryObject("Message"));
        m1.commit(true);
        List<RogLog.Entry.Type> expected = Arrays.asList(RogLog.Entry.Type.Put, RogLog.Entry.Type.Put, RogLog.Entry.Type.Put, RogLog.Entry.Type.Put, RogLog.Entry.Type.Update, RogLog.Entry.Type.Remove, RogLog.Entry.Type.Update, RogLog.Entry.Type.Put, RogLog.Entry.Type.Send);
        this.validateLogEntries("pre compaction", m1, expected);
        m1.restart();
        this.validateLogEntries("pre compaction", m1, expected);
        Object parent2 = m1.getRootObject(graphId);
        Map stringMap2 = (Map)this.invoke(parent2, "getStringMapField", new Object[0]);
        Map longMap2 = (Map)this.invoke(parent2, "getLongMapField", new Object[0]);
        Assert.assertEquals((String)"Wrong store size after pre compact restart", (long)4L, (long)m1.getStore().size());
        Assert.assertTrue((String)"Expected string map to be empty after pre compact restart", (boolean)stringMap2.isEmpty());
        Assert.assertEquals((String)"Wrong number of values in string map after size after pre compact restart", (long)1L, (long)longMap2.size());
        Assert.assertNotNull((String)"No value for key 1 after pre compact restart", longMap2.get(1L));
        Assert.assertEquals((String)"Wrong value for key 1after pre compact restart", (Object)childL1.getId(), (Object)((RogNode)longMap2.get(1L)).getId());
        Assert.assertEquals((String)"Wrong getStringField value for object in map", (Object)"TestValue", (Object)this.invoke(longMap2.get(1L), "getStringField", new Object[0]));
        m1.getCompactor().compact();
        m1.getCompactor().waitForCompactionToComplete();
        m1.getPersister().sync();
        expected = Arrays.asList(RogLog.Entry.Type.Put, RogLog.Entry.Type.Put, RogLog.Entry.Type.Put, RogLog.Entry.Type.Put, RogLog.Entry.Type.Send);
        this.validateLogEntries("post compaction", m1, expected);
        m1.restart();
        Object parent3 = m1.getRootObject(graphId);
        Map stringMap3 = (Map)this.invoke(parent3, "getStringMapField", new Object[0]);
        Map longMap3 = (Map)this.invoke(parent3, "getLongMapField", new Object[0]);
        Assert.assertEquals((String)"Wrong store size after post compact restart", (long)4L, (long)m1.getStore().size());
        Assert.assertTrue((String)"Expected string map to be empty after post compact restart", (boolean)stringMap3.isEmpty());
        Assert.assertEquals((String)"Wrong number of values in string map after post compact restart", (long)1L, (long)longMap3.size());
        Assert.assertNotNull((String)"No value for key 1 after post compact restart", longMap3.get(1L));
        Assert.assertEquals((String)"Wrong value for key 1after post compact restart", (Object)childL1.getId(), (Object)((RogNode)longMap3.get(1L)).getId());
        Assert.assertEquals((String)"Wrong getStringField value for object in map", (Object)"TestValue", (Object)this.invoke(longMap3.get(1L), "getStringField", new Object[0]));
        this.assertGraphObjectsEqual(parent, m1.getRootObject(graphId));
        this.validateLogEntries("post restart", m1, expected);
    }

    @Test
    public void testObjectMoveToNewCollectionSameTxn() throws Exception {
        RogLogCompactionTest.setVerbose((boolean)true);
        RogReplicatedStoreTestBase.Member m1 = this.primaryMember();
        int graphId = this.nextGraphId();
        IRogRootNode parent = (IRogRootNode)this.createFactoryObject("Parent", graphId);
        m1.addRootObject(parent);
        Map stringMap = (Map)this.invoke((Object)parent, "getStringMapField", new Object[0]);
        Map longMap = (Map)this.invoke((Object)parent, "getLongMapField", new Object[0]);
        RogNode childObject = (RogNode)this.createFactoryObject("Child1");
        stringMap.put("key1", childObject);
        m1.commit(true);
        childObject = (RogNode)stringMap.remove("key1");
        longMap.put(1L, childObject);
        m1.commit(true);
        m1.getStore().send((IStoreObject)this.createFactoryObject("Message"));
        m1.commit(true);
        List<RogLog.Entry.Type> expected = Arrays.asList(RogLog.Entry.Type.Put, RogLog.Entry.Type.Put, RogLog.Entry.Type.Put, RogLog.Entry.Type.Put, RogLog.Entry.Type.Update, RogLog.Entry.Type.Update, RogLog.Entry.Type.Update, RogLog.Entry.Type.Send);
        this.validateLogEntries("pre compaction", m1, expected);
        m1.restart();
        this.validateLogEntries("pre compaction", m1, expected);
        Object parent2 = m1.getRootObject(graphId);
        Map stringMap2 = (Map)this.invoke(parent2, "getStringMapField", new Object[0]);
        Map longMap2 = (Map)this.invoke(parent2, "getLongMapField", new Object[0]);
        Assert.assertEquals((String)"Wrong store size after pre compact restart", (long)4L, (long)m1.getStore().size());
        Assert.assertTrue((String)"Expected string map to be empty after pre compact restart", (boolean)stringMap2.isEmpty());
        Assert.assertEquals((String)"Wrong number of values in string map after pre compact restart", (long)1L, (long)longMap2.size());
        Assert.assertNotNull((String)"No value for key 1 after pre compact restart", longMap2.get(1L));
        Assert.assertEquals((String)"Wrong value for key 1after pre compact restart", (Object)childObject.getId(), (Object)((RogNode)longMap2.get(1L)).getId());
        m1.getCompactor().compact();
        m1.getCompactor().waitForCompactionToComplete();
        m1.getPersister().sync();
        expected = Arrays.asList(RogLog.Entry.Type.Put, RogLog.Entry.Type.Put, RogLog.Entry.Type.Put, RogLog.Entry.Type.Put, RogLog.Entry.Type.Send);
        this.validateLogEntries("post compaction", m1, expected);
        m1.restart();
        Object parent3 = m1.getRootObject(graphId);
        Map stringMap3 = (Map)this.invoke(parent3, "getStringMapField", new Object[0]);
        Map longMap3 = (Map)this.invoke(parent3, "getLongMapField", new Object[0]);
        Assert.assertEquals((String)"Wrong store size after post compact restart", (long)4L, (long)m1.getStore().size());
        Assert.assertTrue((String)"Expected string map to be empty after post compact restart", (boolean)stringMap3.isEmpty());
        Assert.assertEquals((String)"Wrong number of values in string map after post compact restart", (long)1L, (long)longMap3.size());
        Assert.assertNotNull((String)"No value for key 1 after post compact restart", longMap3.get(1L));
        Assert.assertEquals((String)"Wrong value for key 1after post compact restart", (Object)childObject.getId(), (Object)((RogNode)longMap3.get(1L)).getId());
        this.assertGraphObjectsEqual(parent, m1.getRootObject(graphId));
        this.validateLogEntries("post restart", m1, expected);
    }

    @Test
    public void testObjectMoveToNewCollectionMultipleTxn() throws Exception {
        RogLogCompactionTest.setVerbose((boolean)true);
        RogReplicatedStoreTestBase.Member m1 = this.primaryMember();
        int graphId = this.nextGraphId();
        IRogRootNode parent = (IRogRootNode)this.createFactoryObject("Parent2", graphId);
        m1.addRootObject(parent);
        Map stringMap = (Map)this.invoke((Object)parent, "getStringMapField", new Object[0]);
        Map longMap = (Map)this.invoke((Object)parent, "getLongMapField", new Object[0]);
        RogNode childObject = (RogNode)this.createFactoryObject("ChildEntity");
        stringMap.put("key1", childObject);
        m1.commit(true);
        childObject = (RogNode)stringMap.remove("key1");
        longMap.put(1L, childObject);
        m1.commit(true);
        childObject = (RogNode)longMap.remove(1L);
        m1.commit(true);
        stringMap.put("key2", childObject);
        m1.commit(true);
        List<RogLog.Entry.Type> expected = Arrays.asList(RogLog.Entry.Type.Put, RogLog.Entry.Type.Put, RogLog.Entry.Type.Put, RogLog.Entry.Type.Put, RogLog.Entry.Type.Update, RogLog.Entry.Type.Update, RogLog.Entry.Type.Update, RogLog.Entry.Type.Update, RogLog.Entry.Type.Remove, RogLog.Entry.Type.Update, RogLog.Entry.Type.Put);
        this.validateLogEntries("pre compaction", m1, expected);
        m1.restart();
        this.validateLogEntries("pre compaction", m1, expected);
        Object parent2 = m1.getRootObject(graphId);
        Map stringMap2 = (Map)this.invoke(parent2, "getStringMapField", new Object[0]);
        Map longMap2 = (Map)this.invoke(parent2, "getLongMapField", new Object[0]);
        Assert.assertEquals((String)"Wrong store size after pre compact restart", (long)4L, (long)m1.getStore().size());
        Assert.assertTrue((String)"Expected long map to be empty after size after pre compact restart", (boolean)longMap2.isEmpty());
        Assert.assertEquals((String)"Wrong number of values in string map after size after pre compact restart", (long)1L, (long)stringMap2.size());
        Assert.assertNotNull((String)"No value for key2 size after pre compact restart", stringMap2.get("key2"));
        Assert.assertEquals((String)"Wrong value for key2 size after pre compact restart", (Object)childObject.getId(), (Object)((RogNode)stringMap2.get("key2")).getId());
        Assert.assertEquals((String)"Wrong getStringField value for object in map", (Object)"TestValue", (Object)this.invoke(stringMap2.get("key2"), "getStringField", new Object[0]));
        m1.getCompactor().compact();
        m1.getCompactor().waitForCompactionToComplete();
        m1.getPersister().sync();
        m1.getStore().send((IStoreObject)this.createFactoryObject("Message"));
        m1.commit(true);
        expected = Arrays.asList(RogLog.Entry.Type.Put, RogLog.Entry.Type.Put, RogLog.Entry.Type.Put, RogLog.Entry.Type.Update, RogLog.Entry.Type.Put, RogLog.Entry.Type.Send);
        this.validateLogEntries("post compaction", m1, expected);
        m1.restart();
        Object parent3 = m1.getRootObject(graphId);
        Map stringMap3 = (Map)this.invoke(parent3, "getStringMapField", new Object[0]);
        Map longMap3 = (Map)this.invoke(parent2, "getLongMapField", new Object[0]);
        Assert.assertEquals((String)"Wrong store size after restart", (long)4L, (long)m1.getStore().size());
        Assert.assertTrue((String)"Expected long map to be empty after post compact restart", (boolean)longMap3.isEmpty());
        Assert.assertEquals((String)"Wrong number of values in string map after post compact restart", (long)1L, (long)stringMap3.size());
        Assert.assertNotNull((String)"No value for key2 after post compact restart", stringMap3.get("key2"));
        Assert.assertEquals((String)"Wrong value for key2 after post compact restart", (Object)childObject.getId(), (Object)((RogNode)stringMap3.get("key2")).getId());
        Assert.assertEquals((String)"Wrong getStringField value for object in map after post compact restart", (Object)"TestValue", (Object)this.invoke(stringMap3.get("key2"), "getStringField", new Object[0]));
        this.assertGraphObjectsEqual(parent, m1.getRootObject(graphId));
        this.validateLogEntries("post restart", m1, expected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateLogEntries(String description, RogReplicatedStoreTestBase.Member member, List<RogLog.Entry.Type> expected) throws Exception {
        try (RogLogReader reader = member.getPersister().createReader();){
            reader.rewind();
            RogLog.Entry entry = null;
            ArrayList<RogLog.Entry.Type> entries = new ArrayList<RogLog.Entry.Type>();
            if (RogLogCompactionTest.verbose()) {
                System.out.println("Entries " + description + ":");
            }
            while ((entry = reader.next()) != null) {
                entries.add(entry.getEntryType());
                if (!RogLogCompactionTest.verbose()) continue;
                System.out.println(new Date(entry.getTimestamp()) + "," + (Object)((Object)entry.getEntryType()) + "," + entry.getObject().getClass().getSimpleName() + ",txn=" + entry.getTransactionId() + ",sbl=" + entry.getStableTransactionId() + ",cpt=" + entry.getCheckpointVersion() + ",cs=" + entry.isCommitStart() + ",ce=" + entry.isCommitEnd());
            }
            Assert.assertEquals((String)("Unexpected log entries " + description), expected, entries);
        }
    }

    private void assertGraphObjectsEqual(Object parent1, Object parent2) throws Exception {
        StringBuffer diffs = new StringBuffer();
        if (!UtlObjectGraph.deepApiEquals((Object)parent1, (Object)parent2, (StringBuffer)diffs, (UtlTableFormatter.Format)UtlTableFormatter.Format.TABULAR, Arrays.asList(IRogMetadata.class, this.factoryType("IParent"), this.factoryType("IChildEntity"), this.factoryType("IChildEntityL2"), this.factoryType("IChild2"), this.factoryType("IChild3")), (UtlObjectGraph.ComparatorFactory)new UtlObjectGraph.ComparatorFactory(){

            public boolean treatEmptyAndNullArraysAsSame() {
                return true;
            }

            public Comparator<?> getComparator(Class<?> clazz, Stack<String> getterStack) {
                return null;
            }
        })) {
            Assert.fail((String)("Recovered parent differs from original parent:\n" + diffs));
        }
    }

    private Class<?> factoryType(String name) throws Exception {
        switch (this.encoding) {
            case Protobuf: {
                return Class.forName("com.neeve.adm.test.unit.proto." + name);
            }
            case Xbuf: {
                return Class.forName("com.neeve.adm.test.unit.xbuf." + name);
            }
            case Json: {
                return Class.forName("com.neeve.adm.test.unit.json." + name);
            }
        }
        throw new IllegalArgumentException();
    }

    private Object createFactoryObject(String name) throws Exception {
        Class<?> clazz = this.factoryType(name);
        return UtlReflection.getMethod(clazz, (String)"create", (Class[])new Class[0]).invoke(null, new Object[0]);
    }

    private Object createFactoryObject(String name, int graphId) throws Exception {
        Class<?> clazz = this.factoryType(name);
        return UtlReflection.getMethod(clazz, (String)"create", (Class[])new Class[]{Integer.TYPE}).invoke(null, new Integer(graphId));
    }

    public Object invoke(Object object, String method, Object ... params) throws Exception {
        Class<?> clazz = object.getClass();
        if (params.length == 0) {
            return UtlReflection.getMethod(clazz, (String)method, (Class[])new Class[0]).invoke(object, new Object[0]);
        }
        Class[] parameterTypes = new Class[params.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = params[i].getClass();
        }
        return UtlReflection.getMethod(clazz, (String)method, (Class[])parameterTypes).invoke(object, params);
    }

    public Object invoke(Object object, String method, Class<?>[] parameterTypes, Object ... params) throws Exception {
        Class<?> clazz = object.getClass();
        if (params.length == 0) {
            return UtlReflection.getMethod(clazz, (String)method, (Class[])new Class[0]).invoke(object, new Object[0]);
        }
        return UtlReflection.getMethod(clazz, (String)method, (Class[])parameterTypes).invoke(object, params);
    }
}

