/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.log.test.unit;

import com.neeve.rog.log.RogLog;
import com.neeve.rog.log.test.unit.messages.proto.OutMessage;
import com.neeve.test.UnitTest;
import java.util.Properties;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public final class RogLogCheckpointTest
extends UnitTest {
    private RogLog log;
    private int logCount;
    private long checkpointVersion;

    private final String logName() {
        return "logCheckpointTest-" + System.currentTimeMillis() + "-" + ++this.logCount;
    }

    private final String createLog(String logName, boolean open, boolean compactionEnabled) throws Exception {
        if (logName == null) {
            logName = this.logName();
        }
        Properties props = new Properties();
        props.setProperty("detachedPersist", "false");
        props.setProperty("initialLogLength", "0.01");
        if (compactionEnabled) {
            props.setProperty("compactionThreshold", "1");
        }
        this.log = RogLog.create(logName, props);
        if (open) {
            this.log.open();
        }
        return logName;
    }

    private final String createLog(String logName, boolean open) throws Exception {
        return this.createLog(logName, open, false);
    }

    private final OutMessage createMessage(boolean checkpointed) {
        OutMessage message = OutMessage.create();
        if (checkpointed) {
            message.setCheckpointVersion(++this.checkpointVersion);
        }
        message.setVal("test");
        return message;
    }

    private final void log(int count, boolean checkpointed) {
        for (int i = 0; i < count; ++i) {
            OutMessage message = this.createMessage(checkpointed);
            message.sync();
            this.log.log(message, i == count - 1);
        }
        this.log.flush(true);
    }

    @After
    public void testCleanup() throws Exception {
        if (this.log != null) {
            this.log.close();
            this.log = null;
        }
        this.checkpointVersion = 0L;
    }

    @Test(expected=IllegalStateException.class)
    public void testCheckpointStateThrowsExceptionOnUnopenedLog() throws Exception {
        this.createLog(null, false);
        this.log.getCheckpointState();
    }

    @Test(expected=IllegalStateException.class)
    public void testCheckpointStateThrowsExceptionOnClosedLog() throws Exception {
        this.createLog(null, false);
        this.log.close();
        this.log.getCheckpointState();
    }

    @Test
    public void testCheckpointStateOnNewLog() throws Exception {
        this.createLog(null, true);
        Assert.assertEquals((Object)((Object)RogLog.CheckpointState.Pending), (Object)((Object)this.log.getCheckpointState()));
    }

    @Test
    public void testCheckpointStateOnEmptyLog() throws Exception {
        String logName = this.createLog(null, true);
        this.log.close();
        this.createLog(logName, true);
        Assert.assertEquals((Object)((Object)RogLog.CheckpointState.Pending), (Object)((Object)this.log.getCheckpointState()));
    }

    @Test
    public void testCheckpointStateOnLogWithCheckpointedEntry() throws Exception {
        String logName = this.createLog(null, true);
        this.log(1, true);
        this.log.close();
        this.createLog(logName, true);
        Assert.assertEquals((Object)((Object)RogLog.CheckpointState.AllEntriesCheckpointed), (Object)((Object)this.log.getCheckpointState()));
    }

    @Test
    public void testCheckpointStateOnLogWithNonCheckpointedEntry() throws Exception {
        String logName = this.createLog(null, true);
        this.log(1, false);
        this.log.close();
        this.createLog(logName, true);
        Assert.assertEquals((Object)((Object)RogLog.CheckpointState.NoEntriesCheckpointed), (Object)((Object)this.log.getCheckpointState()));
    }

    @Test
    public void testCheckpointStateOnNewLogAfterLoggingACheckpointedEntry() throws Exception {
        this.createLog(null, true);
        Assert.assertEquals((Object)((Object)RogLog.CheckpointState.Pending), (Object)((Object)this.log.getCheckpointState()));
        this.log(1, true);
        Assert.assertEquals((Object)((Object)RogLog.CheckpointState.AllEntriesCheckpointed), (Object)((Object)this.log.getCheckpointState()));
        this.log(1, true);
        Assert.assertEquals((Object)((Object)RogLog.CheckpointState.AllEntriesCheckpointed), (Object)((Object)this.log.getCheckpointState()));
    }

    @Test
    public void testCheckpointStateOnNewLogAfterLoggingANonCheckpointedEntry() throws Exception {
        this.createLog(null, true);
        Assert.assertEquals((Object)((Object)RogLog.CheckpointState.Pending), (Object)((Object)this.log.getCheckpointState()));
        this.log(1, false);
        Assert.assertEquals((Object)((Object)RogLog.CheckpointState.NoEntriesCheckpointed), (Object)((Object)this.log.getCheckpointState()));
        this.log(1, false);
        Assert.assertEquals((Object)((Object)RogLog.CheckpointState.NoEntriesCheckpointed), (Object)((Object)this.log.getCheckpointState()));
    }

    @Test(expected=RuntimeException.class)
    public void testLogCheckpointedEntryOnNonCheckpointedLog() throws Exception {
        this.createLog(null, true);
        this.log(1, false);
        this.log(1, true);
    }

    @Test(expected=RuntimeException.class)
    public void testLogNonCheckpointedEntryOnCheckpointedLog() throws Exception {
        this.createLog(null, true);
        this.log(1, true);
        this.log(1, false);
    }

    @Test(expected=RuntimeException.class)
    public void testLogNonCheckpointedEntryOnNewLogWithCompactionEnabled() throws Exception {
        this.createLog(null, true, true);
        this.log(1, false);
    }

    @Test(expected=IllegalStateException.class)
    public void testOpenNonCheckpointedLogWithCompactionEnabled() throws Exception {
        String logName = this.createLog(null, true, false);
        this.log(1, false);
        Assert.assertEquals((Object)((Object)RogLog.CheckpointState.NoEntriesCheckpointed), (Object)((Object)this.log.getCheckpointState()));
        this.log.close();
        this.createLog(logName, true, true);
    }

    @Test(expected=Exception.class)
    public void testCompactOnNonCheckpointedLog() throws Exception {
        this.createLog(null, true, false);
        this.log(1, false);
        this.log.getCompactor().compact().waitForCompactionToComplete();
    }
}

