/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.log;

import com.eaio.uuid.UUID;
import com.neeve.ods.IStoreObjectFactory;
import com.neeve.ods.OdsException;
import com.neeve.ods.StoreObjectFactoryRegistry;
import com.neeve.pkt.PktBuffer;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSubheaderODS;
import com.neeve.pkt.log.PktRecoveryLog;
import com.neeve.rog.log.RogLog;
import com.neeve.sma.MessageViewFactory;
import com.neeve.sma.MessageViewFactoryRegistry;
import com.neeve.trace.Tracer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class RogLogReader {
    private final RogLog log;
    private final PktRecoveryLog.Reader reader;
    private final RogLog.Stats stats = new RogLog.Stats();
    private final Tracer tracer;
    private final String tracePrefix;
    private boolean lazyDeserialization = false;
    private Transaction currentTransaction;

    RogLogReader(RogLog log, PktRecoveryLog.Reader reader, Tracer tracer, String tracePrefix) throws IOException {
        this.log = log;
        this.reader = reader;
        this.reader.reset();
        this.currentTransaction = null;
        this.tracer = tracer;
        this.tracePrefix = tracePrefix;
    }

    private final RogLog.Entry.Type toEntryType(short commitEntryType) {
        switch (commitEntryType) {
            case 1: {
                return RogLog.Entry.Type.Put;
            }
            case 2: {
                return RogLog.Entry.Type.Update;
            }
            case 3: {
                return RogLog.Entry.Type.Remove;
            }
            case 4: {
                return RogLog.Entry.Type.Send;
            }
            case 5: {
                return RogLog.Entry.Type.Message;
            }
        }
        throw new InternalError("invalid  commit entry type '" + commitEntryType + "'");
    }

    private final RogLog.Entry toEntry(PktPacket packet) throws Exception {
        RogLog.Entry entry = null;
        if (packet != null) {
            PktSubheaderODS subheader = packet.getHeader().getODSSubheader();
            if (subheader == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("Detected log packet without an ODS header:!\n  ");
                PktBuffer headerBuffer = packet.getHeader().getBuffer();
                PktBuffer bodyBuffer = packet.getBody().getBuffer();
                sb.append(headerBuffer != null ? headerBuffer.dump("Header Buffer: ", 0, headerBuffer.getLength()) : " no header buffer!").append("\n  ");
                sb.append(headerBuffer != null ? bodyBuffer.dump("Body Buffer: ", 0, bodyBuffer.getLength()) : " no body buffer!");
                sb.append("[ body type: ").append(packet.getBody().getClass().getSimpleName()).append("]\n  ");
                sb.append("Packet: " + packet.toString());
                this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
            }
            short ofid = subheader.getObjectFactoryId();
            short otype = subheader.getObjectType();
            UUID id = subheader.getObjectId() == null ? null : new UUID(subheader.getObjectId());
            short contentEncodingType = subheader.getContentEncodingType();
            PktBuffer metadata = subheader.getObjectMetadata();
            boolean commitStart = subheader.getFlagCommitStart();
            boolean commitEnd = subheader.getFlagCommitEnd();
            long timestamp = subheader.getTimestamp();
            long transactionId = subheader.getTransactionId();
            long stableTransactionId = subheader.getStableTransactionId();
            long checkpointVersion = subheader.getCheckpointVersion();
            PktRecoveryLog.FilePosition filePosition = (PktRecoveryLog.FilePosition)packet.getTag(4);
            long filePointer = filePosition.getPosition();
            int serializedSize = filePosition.getSize();
            switch (subheader.getCommitEntryType()) {
                case 1: {
                    entry = this.log().createEntry(filePointer, serializedSize, RogLog.Entry.Type.Put, id, ofid, otype, transactionId, stableTransactionId, checkpointVersion, packet, contentEncodingType, metadata, timestamp, commitStart, commitEnd);
                    break;
                }
                case 2: {
                    entry = this.log().createEntry(filePointer, serializedSize, RogLog.Entry.Type.Update, id, ofid, otype, transactionId, stableTransactionId, checkpointVersion, packet, contentEncodingType, metadata, timestamp, commitStart, commitEnd);
                    break;
                }
                case 3: {
                    entry = this.log().createEntry(filePointer, serializedSize, RogLog.Entry.Type.Remove, id, ofid, otype, transactionId, stableTransactionId, checkpointVersion, packet, contentEncodingType, metadata, timestamp, commitStart, commitEnd);
                    break;
                }
                case 4: {
                    entry = this.log().createEntry(filePointer, serializedSize, RogLog.Entry.Type.Send, id, ofid, otype, transactionId, stableTransactionId, checkpointVersion, packet, contentEncodingType, metadata, timestamp, commitStart, commitEnd);
                    break;
                }
                case 5: {
                    entry = this.log().createEntry(filePointer, serializedSize, RogLog.Entry.Type.Message, id, ofid, otype, transactionId, stableTransactionId, checkpointVersion, packet, contentEncodingType, metadata, timestamp, commitStart, commitEnd);
                    break;
                }
                default: {
                    throw new OdsException("entry in transaction log is corrupt (unsupported  commit entry type '" + subheader.getCommitEntryType() + "'). See nv.rog logs for more details");
                }
            }
            if (!this.lazyDeserialization) {
                entry.getObject();
            }
        }
        return entry;
    }

    private final Transaction getCurrentIfComplete() {
        Transaction transaction = null;
        if (this.currentTransaction != null && (this.currentTransaction.getId() == 0L || this.currentTransaction.isComplete())) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "...transaction " + this.currentTransaction.getId() + " is complete.", Tracer.Level.DEBUG);
            }
            transaction = this.currentTransaction;
            this.currentTransaction = null;
        }
        return transaction;
    }

    public static final void registerFactory(Object factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory cannot be null");
        }
        if (factory instanceof MessageViewFactory) {
            MessageViewFactoryRegistry.getInstance().registerMessageViewFactory((MessageViewFactory)factory);
        }
        if (factory instanceof IStoreObjectFactory) {
            StoreObjectFactoryRegistry.getInstance().registerObjectFactory((IStoreObjectFactory)factory);
        }
    }

    public void setLazyDeserialization(boolean lazyDeserialization) {
        this.lazyDeserialization = lazyDeserialization;
    }

    public final RogLog log() {
        return this.log;
    }

    public final RogLog.Entry next() throws Exception {
        return this.stats.update(this.toEntry(this.reader.next()));
    }

    public final Transaction nextTransaction() throws Exception {
        Transaction transaction;
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Getting next transaction...", Tracer.Level.DEBUG);
        }
        if ((transaction = this.getCurrentIfComplete()) == null) {
            RogLog.Entry entry = this.next();
            while (entry != null) {
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "...got an entry (" + entry + ").", Tracer.Level.DEBUG);
                }
                long txnId = entry.getTransactionId();
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "...transaction id = " + txnId + ".", Tracer.Level.DEBUG);
                }
                if (txnId >= 0L) {
                    if (this.currentTransaction != null && this.currentTransaction.getId() != txnId) {
                        if (this.tracer.debug) {
                            this.tracer.log(this.tracePrefix + "...transaction is incomplete. resetting current transaction.", Tracer.Level.DEBUG);
                        }
                        this.currentTransaction = null;
                    }
                    if ((transaction = this.currentTransaction) == null) {
                        if (this.tracer.debug) {
                            this.tracer.log(this.tracePrefix + "...first entry of transaction. set as current transaction.", Tracer.Level.DEBUG);
                        }
                        transaction = this.currentTransaction = new Transaction(txnId, this.tracer, this.tracePrefix);
                    } else if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "...current transaction already in progress.", Tracer.Level.DEBUG);
                    }
                    transaction.onNext(entry);
                    transaction = this.getCurrentIfComplete();
                    if (transaction != null) {
                        break;
                    }
                } else {
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "...orphaned entry.", Tracer.Level.DEBUG);
                    }
                    transaction = new Transaction(txnId, this.tracer, this.tracePrefix);
                    transaction.entries.add(entry);
                    break;
                }
                entry = this.next();
            }
        } else if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...got from working list.", Tracer.Level.DEBUG);
        }
        return transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RogLogReader skip(int count, SkipCallback cb) throws IOException {
        for (int i = 0; i < count; ++i) {
            boolean lazy = this.lazyDeserialization;
            try {
                this.lazyDeserialization = true;
                PktPacket packet = this.reader.next();
                if (packet == null) break;
                try {
                    if (cb == null) continue;
                    RogLog.Entry.Type type = this.toEntryType(packet.getHeader().getODSSubheader().getCommitEntryType());
                    cb.onSkip(type);
                    this.stats.update(type);
                    continue;
                }
                finally {
                    packet.dispose();
                }
            }
            finally {
                this.lazyDeserialization = lazy;
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RogLogReader skipTransaction(int count, TransactionSkipCallback cb) throws Exception {
        for (int i = 0; i < count; ++i) {
            boolean lazy = this.lazyDeserialization;
            try {
                this.lazyDeserialization = true;
                Transaction transaction = this.nextTransaction();
                if (transaction == null) break;
                if (cb == null) continue;
                cb.onTransactionSkip(transaction);
                continue;
            }
            finally {
                this.lazyDeserialization = lazy;
            }
        }
        return this;
    }

    public final void seek(long pos) throws IOException {
        this.reader.seek(pos);
        this.currentTransaction = null;
        this.stats.reset();
    }

    public final RogLogReader rewind() throws IOException {
        this.reader.reset();
        this.currentTransaction = null;
        this.stats.reset();
        return this;
    }

    public RogLog.Stats getStats() {
        return this.stats;
    }

    public RogLog.Stats computeStats() throws Exception {
        while (this.nextTransaction() != null) {
        }
        return this.stats;
    }

    public RogLog.Entry getEntryAt(long filePosition) throws Exception {
        PktPacket packet = this.reader.readAt(filePosition);
        if (packet != null) {
            return this.toEntry(packet);
        }
        return null;
    }

    public final void close() throws Exception {
        this.reader.close();
        this.currentTransaction = null;
    }

    public static interface TransactionSkipCallback {
        public void onTransactionSkip(Transaction var1);
    }

    public static interface SkipCallback {
        public void onSkip(RogLog.Entry.Type var1);
    }

    public static final class Transaction {
        private final long id;
        private final List<RogLog.Entry> entries;
        private final Tracer tracer;
        private final String tracePrefix;
        private boolean complete;

        Transaction(long id, Tracer tracer, String tracePrefix) {
            this.id = id;
            this.entries = new ArrayList<RogLog.Entry>();
            this.tracer = tracer;
            this.tracePrefix = tracePrefix;
        }

        final void onNext(RogLog.Entry entry) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "...(txn " + this.id + ") processing next entry (complete=" + this.complete + ", entryType=" + (Object)((Object)entry.getEntryType()) + ")...", Tracer.Level.DEBUG);
            }
            try {
                this.entries.add(entry);
                if (this.complete) {
                    throw new InternalError("Received state update when in done state");
                }
                if (entry.isCommitEnd()) {
                    this.complete = true;
                }
            }
            finally {
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "...(txn " + this.id + ") processing complete (complete=" + this.complete + ")...", Tracer.Level.DEBUG);
                }
            }
        }

        public final long getId() {
            return this.id;
        }

        public final boolean isComplete() {
            return this.complete;
        }

        @Deprecated
        public final List<RogLog.Entry> getEntries(boolean sorted) {
            return this.getEntries();
        }

        public final List<RogLog.Entry> getEntries() {
            return this.entries;
        }
    }
}

