/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.test.unit;

import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.neeve.query.Query;
import com.neeve.query.QueryResultSet;
import com.neeve.query.impl.QueryEngineImpl;
import com.neeve.query.impl.QueryImpl;
import com.neeve.query.impl.QueryMonotonicField;
import com.neeve.query.impl.QueryPlanImpl;
import com.neeve.query.impl.QueryResultSetImpl;
import com.neeve.query.impl.QueryStaticField;
import com.neeve.query.impl.QueryStatsImpl;
import com.neeve.query.impl.mem.MemQuerySetRepository;
import com.neeve.query.impl.mock.MockRecord;
import com.neeve.query.impl.util.collect.UtlIntegerRange;
import com.neeve.query.impl.util.collect.UtlRangeBase;
import com.neeve.query.index.IdxField;
import com.neeve.query.index.IdxRange;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class QueryPlanTest {
    private static final Comparator<Integer> idSorter = Ordering.natural();
    public static final IdxField<MockRecord, String> payloadField = new QueryStaticField<MockRecord, String>(MockRecord.class, "object", String.class){
        private static final long serialVersionUID = 1L;

        @Override
        public String applyUnchecked(MockRecord rec) {
            return (String)rec.getObject();
        }
    };
    private static QueryEngineImpl<Integer, MockRecord> engine;
    private static MemQuerySetRepository<Integer, MockRecord> repository;

    @BeforeClass
    public static void setup() throws Exception {
        System.setProperty("nv.unittest", "true");
        engine = new QueryEngineImpl(MockRecord.class);
        repository = new MemQuerySetRepository<Integer, MockRecord>("mock", MockRecord.keyMapper);
        repository.open();
        engine.addRepository(repository, "repo");
        repository.createIndex(MockRecord.staticRecordId, true);
        repository.createIndex(payloadField, false);
        repository.add(new MockRecord(1, "Apple"));
        repository.add(new MockRecord(2, "Orange"));
        repository.add(new MockRecord(3, "Pear"));
        repository.add(new MockRecord(4, "Peach"));
        repository.add(new MockRecord(5, "Apple"));
        repository.add(new MockRecord(6, "Orange"));
    }

    @AfterClass
    public static void teardown() {
        System.setProperty("nv.unittest", "false");
        repository.dropIndex(MockRecord.staticRecordId);
        repository.dropIndex(payloadField);
    }

    @Test
    public void testFullRead() {
        QueryResultSetImpl<Integer, MockRecord> rs = engine.createResultSet();
        QueryPlanImpl.FullRead<Integer, MockRecord> fullRead = new QueryPlanImpl.FullRead<Integer, MockRecord>();
        fullRead.associateResultSet(rs);
        fullRead.setGenerateLatencies(true);
        QueryPlanImpl.StepResult<Integer, MockRecord> stepResult = ((QueryPlanImpl.StepImpl)fullRead).getResult(repository, null);
        QueryPlanImpl.PlanQueryResult<MockRecord> queryResult = stepResult.getQueryResult();
        Assert.assertEquals((String)"all 6", (long)6L, (long)queryResult.estimatedSize());
        for (QueryResultSet.Row row : queryResult) {
        }
        QueryStatsImpl.DeltaLatencies latencies = fullRead.getLatencies();
        latencies.compute();
        Assert.assertEquals((String)"expected 6 latency samples", (long)6L, (long)latencies.sample());
    }

    @Test
    public void testUniqueIndexRead() {
        QueryResultSetImpl<Integer, MockRecord> rs = engine.createResultSet();
        QueryPlanImpl.UniqueIndexRead<Integer, MockRecord, Integer> indexRead = new QueryPlanImpl.UniqueIndexRead<Integer, MockRecord, Integer>(MockRecord.staticRecordId, idSorter);
        indexRead.associateResultSet(rs);
        indexRead.setGenerateLatencies(true);
        indexRead.addFieldValue(4);
        indexRead.addFieldValue(3);
        indexRead.addFieldValue(2);
        QueryPlanImpl.StepResult<Integer, MockRecord> stepResult = indexRead.getResult(repository, null);
        QueryPlanImpl.PlanQueryResult<MockRecord> queryResult = stepResult.getQueryResult();
        Assert.assertEquals((String)"expected 3", (long)3L, (long)queryResult.estimatedSize());
        Iterator iter = queryResult.iterator();
        Assert.assertEquals((String)"first Orange", (Object)"Orange", (Object)((MockRecord)((QueryResultSet.Row)iter.next()).getRecord()).getObject());
        Assert.assertEquals((String)"second Pear", (Object)"Pear", (Object)((MockRecord)((QueryResultSet.Row)iter.next()).getRecord()).getObject());
        Assert.assertEquals((String)"third Peach", (Object)"Peach", (Object)((MockRecord)((QueryResultSet.Row)iter.next()).getRecord()).getObject());
        Assert.assertFalse((String)"no more records", (boolean)iter.hasNext());
        QueryStatsImpl.DeltaLatencies latencies = indexRead.getLatencies();
        latencies.compute();
        Assert.assertEquals((String)"expected 3 latency samples", (long)3L, (long)latencies.sample());
    }

    @Test
    public void testUniqueRangeRead() {
        UtlIntegerRange idRange = new UtlIntegerRange(2, 4);
        QueryResultSetImpl<Integer, MockRecord> rs = engine.createResultSet();
        QueryPlanImpl.UniqueRangeRead<Integer, MockRecord, Integer> indexRead = new QueryPlanImpl.UniqueRangeRead<Integer, MockRecord, Integer>(MockRecord.staticRecordId, idRange, idSorter, 0.5);
        indexRead.associateResultSet(rs);
        QueryPlanImpl.StepResult<Integer, MockRecord> stepResult = indexRead.getResult(repository, null);
        QueryPlanImpl.PlanQueryResult<MockRecord> queryResult = stepResult.getQueryResult();
        Assert.assertEquals((String)"expected 3", (long)3L, (long)queryResult.estimatedSize());
        Iterator iter = queryResult.iterator();
        Assert.assertEquals((String)"first Orange", (Object)"Orange", (Object)((MockRecord)((QueryResultSet.Row)iter.next()).getRecord()).getObject());
        Assert.assertEquals((String)"second Pear", (Object)"Pear", (Object)((MockRecord)((QueryResultSet.Row)iter.next()).getRecord()).getObject());
        Assert.assertEquals((String)"third Peach", (Object)"Peach", (Object)((MockRecord)((QueryResultSet.Row)iter.next()).getRecord()).getObject());
    }

    @Test
    public void testNonUniqueIndexRead() {
        QueryResultSetImpl<Integer, MockRecord> rs = engine.createResultSet();
        QueryPlanImpl.NonUniqueIndexRead<Integer, MockRecord, String> indexRead = new QueryPlanImpl.NonUniqueIndexRead<Integer, MockRecord, String>(payloadField, idSorter);
        indexRead.associateResultSet(rs);
        indexRead.addFieldValue("Orange");
        indexRead.addFieldValue("Pear");
        indexRead.addFieldValue("Apple");
        QueryPlanImpl.StepResult<Integer, MockRecord> stepResult = indexRead.getResult(repository, null);
        QueryPlanImpl.PlanQueryResult<MockRecord> queryResult = stepResult.getQueryResult();
        Assert.assertEquals((String)"expected 5", (long)5L, (long)queryResult.estimatedSize());
        Iterator iter = queryResult.iterator();
        Assert.assertEquals((String)"first Apple", (Object)"Apple", (Object)((MockRecord)((QueryResultSet.Row)iter.next()).getRecord()).getObject());
        Assert.assertEquals((String)"second Orange", (Object)"Orange", (Object)((MockRecord)((QueryResultSet.Row)iter.next()).getRecord()).getObject());
        Assert.assertEquals((String)"third Pear", (Object)"Pear", (Object)((MockRecord)((QueryResultSet.Row)iter.next()).getRecord()).getObject());
        Assert.assertEquals((String)"fourth Apple", (Object)"Apple", (Object)((MockRecord)((QueryResultSet.Row)iter.next()).getRecord()).getObject());
        Assert.assertEquals((String)"fifth Orange", (Object)"Orange", (Object)((MockRecord)((QueryResultSet.Row)iter.next()).getRecord()).getObject());
    }

    @Test
    public void testNonUniqueRangeRead() {
        UtlRangeBase<String> stringRange = new UtlRangeBase<String>("Orange", "Pear");
        QueryResultSetImpl<Integer, MockRecord> rs = engine.createResultSet();
        QueryPlanImpl.NonUniqueRangeRead<Integer, MockRecord, String> indexRead = new QueryPlanImpl.NonUniqueRangeRead<Integer, MockRecord, String>(payloadField, stringRange, idSorter, 0.5);
        indexRead.associateResultSet(rs);
        QueryPlanImpl.StepResult<Integer, MockRecord> stepResult = indexRead.getResult(repository, null);
        QueryPlanImpl.PlanQueryResult<MockRecord> queryResult = stepResult.getQueryResult();
        Assert.assertEquals((String)"expected 4", (long)4L, (long)queryResult.estimatedSize());
        Iterator iter = queryResult.iterator();
        Assert.assertEquals((String)"first Orange", (Object)"Orange", (Object)((MockRecord)((QueryResultSet.Row)iter.next()).getRecord()).getObject());
        Assert.assertEquals((String)"second Pear", (Object)"Pear", (Object)((MockRecord)((QueryResultSet.Row)iter.next()).getRecord()).getObject());
        Assert.assertEquals((String)"third Peach", (Object)"Peach", (Object)((MockRecord)((QueryResultSet.Row)iter.next()).getRecord()).getObject());
        Assert.assertEquals((String)"fourth Orange", (Object)"Orange", (Object)((MockRecord)((QueryResultSet.Row)iter.next()).getRecord()).getObject());
    }

    @Test
    public void testSortedIntersection() {
        QueryPlanImpl.UniqueIndexRead indexRead1 = new QueryPlanImpl.UniqueIndexRead(MockRecord.staticRecordId, Ordering.natural());
        indexRead1.addFieldValue(1);
        indexRead1.addFieldValue(2);
        QueryPlanImpl.UniqueIndexRead indexRead2 = new QueryPlanImpl.UniqueIndexRead(MockRecord.staticRecordId, Ordering.natural());
        indexRead2.addFieldValue(2);
        indexRead2.addFieldValue(3);
        ArrayList indexReads = Lists.newArrayList();
        indexReads.add(indexRead1);
        indexReads.add(indexRead2);
        QueryResultSetImpl<Integer, MockRecord> rs = engine.createResultSet();
        QueryPlanImpl.SortedIntersectionRead<Integer, MockRecord> intersection = new QueryPlanImpl.SortedIntersectionRead<Integer, MockRecord>(indexReads, idSorter);
        intersection.associateResultSet(rs);
        QueryPlanImpl.StepResult<Integer, MockRecord> stepResult = intersection.getResult(repository, null);
        QueryPlanImpl.PlanQueryResult<MockRecord> queryResult = stepResult.getQueryResult();
        Assert.assertEquals((String)"expected 2/3", (long)1L, (long)queryResult.estimatedSize());
    }

    @Test
    public void testHashIntersection() {
        QueryPlanImpl.UniqueIndexRead indexRead1 = new QueryPlanImpl.UniqueIndexRead(MockRecord.staticRecordId, Ordering.natural());
        indexRead1.addFieldValue(1);
        indexRead1.addFieldValue(2);
        QueryPlanImpl.UniqueIndexRead indexRead2 = new QueryPlanImpl.UniqueIndexRead(MockRecord.staticRecordId, Ordering.natural());
        indexRead2.addFieldValue(2);
        indexRead2.addFieldValue(3);
        ArrayList indexReads = Lists.newArrayList();
        indexReads.add(indexRead1);
        indexReads.add(indexRead2);
        QueryPlanImpl.HashIntersectionRead<Integer, MockRecord> intersection = new QueryPlanImpl.HashIntersectionRead<Integer, MockRecord>(indexReads);
        intersection.associateResultSet(engine.createResultSet());
        QueryPlanImpl.StepResult<Integer, MockRecord> stepResult = intersection.getResult(repository, null);
        QueryPlanImpl.PlanQueryResult<MockRecord> queryResult = stepResult.getQueryResult();
        Assert.assertEquals((String)"expected 2/3", (long)1L, (long)queryResult.estimatedSize());
        int count = 0;
        for (QueryResultSet.Row row : queryResult) {
            MockRecord record = (MockRecord)row.getRecord();
            Object payload = record.getObject();
            Assert.assertEquals((String)"expected Orange", (Object)"Orange", (Object)payload);
            ++count;
        }
        Assert.assertEquals((String)"expected to query 1 row", (long)1L, (long)count);
    }

    @Test
    public void testOrExpansion() {
        QueryPlanImpl.UniqueIndexRead indexRead1 = new QueryPlanImpl.UniqueIndexRead(MockRecord.staticRecordId, Ordering.natural());
        indexRead1.addFieldValue(1);
        indexRead1.addFieldValue(2);
        QueryPlanImpl.UniqueIndexRead indexRead2 = new QueryPlanImpl.UniqueIndexRead(MockRecord.staticRecordId, Ordering.natural());
        indexRead2.addFieldValue(2);
        indexRead2.addFieldValue(3);
        ArrayList indexReads = Lists.newArrayList();
        indexReads.add(indexRead1);
        indexReads.add(indexRead2);
        QueryPlanImpl.OrExpansion<Integer, MockRecord> orExpansion = new QueryPlanImpl.OrExpansion<Integer, MockRecord>(indexReads, idSorter);
        QueryResultSetImpl<Integer, MockRecord> rs = engine.createResultSet();
        orExpansion.associateResultSet(rs);
        QueryPlanImpl.StepResult<Integer, MockRecord> stepResult = orExpansion.getResult(repository, null);
        QueryPlanImpl.PlanQueryResult<MockRecord> queryResult = stepResult.getQueryResult();
        Assert.assertEquals((String)"expected 10/3", (long)3L, (long)queryResult.estimatedSize());
    }

    @Test
    public void testFullIndexRead() {
        QueryResultSetImpl<Integer, MockRecord> rs = engine.createResultSet();
        QueryPlanImpl.FullIndexRead<Integer, MockRecord, Integer> ascendingRecordIdRead = new QueryPlanImpl.FullIndexRead<Integer, MockRecord, Integer>(MockRecord.staticRecordId, true);
        ascendingRecordIdRead.associateResultSet(rs);
        ascendingRecordIdRead.setGenerateLatencies(true);
        QueryPlanImpl.StepResult<Integer, MockRecord> stepResult = ((QueryPlanImpl.StepImpl)ascendingRecordIdRead).getResult(repository, null);
        int expectedId = 1;
        for (QueryResultSet.Row row : stepResult.getQueryResult()) {
            Assert.assertEquals((String)"ascending ids", (long)expectedId, (long)((MockRecord)row.getRecord()).getId());
            ++expectedId;
        }
        QueryStatsImpl.DeltaLatencies latencies = ascendingRecordIdRead.getLatencies();
        latencies.compute();
        Assert.assertEquals((String)"expect 6 latency samples", (long)6L, (long)latencies.sample());
        QueryPlanImpl.FullIndexRead<Integer, MockRecord, Integer> fullIndexRead = new QueryPlanImpl.FullIndexRead<Integer, MockRecord, Integer>(MockRecord.staticRecordId, false);
        fullIndexRead.associateResultSet(rs);
        fullIndexRead.setGenerateLatencies(true);
        stepResult = ((QueryPlanImpl.StepImpl)fullIndexRead).getResult(repository, null);
        expectedId = 6;
        for (QueryResultSet.Row row : stepResult.getQueryResult()) {
            Assert.assertEquals((String)"descending ids", (long)expectedId, (long)((MockRecord)row.getRecord()).getId());
            --expectedId;
        }
        latencies = fullIndexRead.getLatencies();
        latencies.compute();
        Assert.assertEquals((String)"expect 6 latency samples", (long)6L, (long)latencies.sample());
    }

    @Test
    public void testOrderBy() {
        QueryResultSetImpl<Integer, MockRecord> rs = engine.createResultSet();
        QueryPlanImpl.FullRead<Integer, MockRecord> fullRead = new QueryPlanImpl.FullRead<Integer, MockRecord>();
        fullRead.associateResultSet(rs);
        QueryPlanImpl.StepResult<Integer, MockRecord> stepResult = ((QueryPlanImpl.StepImpl)fullRead).getResult(repository, null);
        QueryPlanImpl.PlanQueryResult<MockRecord> queryResult = stepResult.getQueryResult();
        Assert.assertEquals((String)"FullRead should return all rows", (long)6L, (long)queryResult.estimatedSize());
        QueryImpl<MockRecord> query = new QueryImpl<MockRecord>();
        query.select(MockRecord.selectAll).from("repo").orderBy(MockRecord.recordId).limit(3);
        QueryPlanImpl.OrderBy<Integer, MockRecord> orderBy = new QueryPlanImpl.OrderBy<Integer, MockRecord>(query);
        orderBy.associateResultSet(rs);
        QueryPlanImpl.StepResult<Integer, MockRecord> allRows = ((QueryPlanImpl.StepImpl)fullRead).getResult(repository, null);
        QueryPlanImpl.StepResult<Integer, MockRecord> orderedRows = ((QueryPlanImpl.StepImpl)orderBy).getResult(repository, allRows);
        Assert.assertEquals((String)"Only 3 rows with limit", (long)3L, (long)orderedRows.getQueryResult().size());
        query = new QueryImpl();
        query.select(MockRecord.selectAll).from("repo").orderBy(MockRecord.recordId, Query.SortOrder.DESCENDING).limit(3);
        orderBy = new QueryPlanImpl.OrderBy(query);
        orderBy.associateResultSet(rs);
        allRows = ((QueryPlanImpl.StepImpl)fullRead).getResult(repository, null);
        orderedRows = ((QueryPlanImpl.StepImpl)orderBy).getResult(repository, allRows);
        Assert.assertEquals((String)"Only 3 rows with limit", (long)3L, (long)orderedRows.getQueryResult().size());
    }

    @Test
    public void testMonotonicScan() {
        QueryMonotonicField<MockRecord, Integer, Integer> monotonicField = new QueryMonotonicField<MockRecord, Integer, Integer>(MockRecord.recordId, true);
        ArrayList scanIds = Lists.newArrayList((Object[])new Integer[]{2, 3, 5});
        QueryPlanImpl.PlanQueryResult<MockRecord> queryResult = this.scanForRecordIds(monotonicField, scanIds);
        List<Integer> queryResultRecordIds = this.extractRecordIds(queryResult);
        Assert.assertEquals((String)"recordId mismatch", (Object)scanIds, queryResultRecordIds);
        scanIds = Lists.newArrayList((Object[])new Integer[]{1});
        queryResult = this.scanForRecordIds(monotonicField, scanIds);
        queryResultRecordIds = this.extractRecordIds(queryResult);
        Assert.assertEquals((String)"recordId mismatch", (Object)scanIds, queryResultRecordIds);
        scanIds = Lists.newArrayList((Object[])new Integer[]{5, 6});
        queryResult = this.scanForRecordIds(monotonicField, scanIds);
        queryResultRecordIds = this.extractRecordIds(queryResult);
        Assert.assertEquals((String)"recordId mismatch", (Object)scanIds, queryResultRecordIds);
        scanIds = Lists.newArrayList((Object[])new Integer[]{5, 6, 7, 8});
        queryResult = this.scanForRecordIds(monotonicField, scanIds);
        queryResultRecordIds = this.extractRecordIds(queryResult);
        Assert.assertEquals((String)"recordId mismatch", (Object)Lists.newArrayList((Object[])new Integer[]{5, 6}), queryResultRecordIds);
        scanIds = Lists.newArrayList((Object[])new Integer[]{0, 1, 2});
        queryResult = this.scanForRecordIds(monotonicField, scanIds);
        queryResultRecordIds = this.extractRecordIds(queryResult);
        Assert.assertEquals((String)"recordId mismatch", (Object)Lists.newArrayList((Object[])new Integer[]{1, 2}), queryResultRecordIds);
        scanIds = Lists.newArrayList((Object[])new Integer[]{0});
        queryResult = this.scanForRecordIds(monotonicField, scanIds);
        queryResultRecordIds = this.extractRecordIds(queryResult);
        Assert.assertEquals((String)"recordId mismatch", (Object)Lists.newArrayList(), queryResultRecordIds);
        scanIds = Lists.newArrayList((Object[])new Integer[]{44});
        queryResult = this.scanForRecordIds(monotonicField, scanIds);
        queryResultRecordIds = this.extractRecordIds(queryResult);
        Assert.assertEquals((String)"recordId mismatch", (Object)Lists.newArrayList(), queryResultRecordIds);
    }

    @Test
    public void testMonotonicRangeScan() {
        QueryMonotonicField<MockRecord, Integer, Integer> monotonicField = new QueryMonotonicField<MockRecord, Integer, Integer>(MockRecord.recordId, true);
        UtlRangeBase<Integer> range = new UtlRangeBase<Integer>(2, 5);
        QueryPlanImpl.PlanQueryResult<MockRecord> queryResult = this.scanForRange(monotonicField, range);
        List<Integer> queryResultRecordIds = this.extractRecordIds(queryResult);
        Assert.assertEquals((String)"recordId mismatch", (Object)Lists.newArrayList((Object[])new Integer[]{2, 3, 4, 5}), queryResultRecordIds);
        range.setIncludeStart(false);
        range.setIncludeEnd(false);
        queryResult = this.scanForRange(monotonicField, range);
        queryResultRecordIds = this.extractRecordIds(queryResult);
        Assert.assertEquals((String)"recordId mismatch", (Object)Lists.newArrayList((Object[])new Integer[]{3, 4}), queryResultRecordIds);
        range = new UtlRangeBase<Integer>(-6, 1);
        queryResult = this.scanForRange(monotonicField, range);
        queryResultRecordIds = this.extractRecordIds(queryResult);
        Assert.assertEquals((String)"recordId mismatch", (Object)Lists.newArrayList((Object[])new Integer[]{1}), queryResultRecordIds);
        range.setIncludeEnd(false);
        queryResult = this.scanForRange(monotonicField, range);
        queryResultRecordIds = this.extractRecordIds(queryResult);
        Assert.assertEquals((String)"recordId mismatch", (Object)Lists.newArrayList(), queryResultRecordIds);
        range = new UtlRangeBase<Integer>(6, 100);
        queryResult = this.scanForRange(monotonicField, range);
        queryResultRecordIds = this.extractRecordIds(queryResult);
        Assert.assertEquals((String)"recordId mismatch", (Object)Lists.newArrayList((Object[])new Integer[]{6}), queryResultRecordIds);
        range.setIncludeStart(false);
        queryResult = this.scanForRange(monotonicField, range);
        queryResultRecordIds = this.extractRecordIds(queryResult);
        Assert.assertEquals((String)"recordId mismatch", (Object)Lists.newArrayList(), queryResultRecordIds);
        range = new UtlRangeBase<Integer>(1, 6);
        queryResult = this.scanForRange(monotonicField, range);
        queryResultRecordIds = this.extractRecordIds(queryResult);
        Assert.assertEquals((String)"recordId mismatch", (Object)Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5, 6}), queryResultRecordIds);
        range = new UtlRangeBase<Integer>(-100, 100);
        queryResult = this.scanForRange(monotonicField, range);
        queryResultRecordIds = this.extractRecordIds(queryResult);
        Assert.assertEquals((String)"recordId mismatch", (Object)Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5, 6}), queryResultRecordIds);
    }

    private QueryPlanImpl.PlanQueryResult<MockRecord> scanForRecordIds(QueryMonotonicField<MockRecord, Integer, Integer> monotonicField, List<Integer> recordIds) {
        QueryResultSetImpl<Integer, MockRecord> rs = engine.createResultSet();
        QueryPlanImpl.MonotonicValueScan<Integer, MockRecord, Integer> scan = new QueryPlanImpl.MonotonicValueScan<Integer, MockRecord, Integer>(monotonicField);
        scan.associateResultSet(rs);
        for (int id : recordIds) {
            scan.addFieldValue(id);
        }
        QueryPlanImpl.StepResult<Integer, MockRecord> stepResult = scan.getResult(repository, null);
        return stepResult.getQueryResult();
    }

    private QueryPlanImpl.PlanQueryResult<MockRecord> scanForRange(QueryMonotonicField<MockRecord, Integer, Integer> monotonicField, IdxRange<Integer> range) {
        QueryResultSetImpl<Integer, MockRecord> rs = engine.createResultSet();
        QueryPlanImpl.MonotonicRangeScan<Integer, MockRecord, Integer> rangeScan = new QueryPlanImpl.MonotonicRangeScan<Integer, MockRecord, Integer>(monotonicField, range);
        rangeScan.associateResultSet(rs);
        QueryPlanImpl.StepResult<Integer, MockRecord> stepResult = rangeScan.getResult(repository, null);
        return stepResult.getQueryResult();
    }

    private List<Integer> extractRecordIds(QueryPlanImpl.PlanQueryResult<MockRecord> queryResult) {
        ArrayList queryIds = Lists.newArrayList();
        for (QueryResultSet.Row row : queryResult) {
            MockRecord record = (MockRecord)row.getRecord();
            queryIds.add(record.getId());
        }
        return queryIds;
    }

    @Test
    public void testDistinct() {
        QueryResultSetImpl<Integer, MockRecord> rs = engine.createResultSet();
        rs.addColumn(MockRecord.payload);
        QueryPlanImpl.FullRead<Integer, MockRecord> fullRead = new QueryPlanImpl.FullRead<Integer, MockRecord>();
        fullRead.associateResultSet(rs);
        fullRead.setGenerateLatencies(true);
        QueryPlanImpl.StepResult<Integer, MockRecord> allRows = ((QueryPlanImpl.StepImpl)fullRead).getResult(repository, null);
        QueryPlanImpl.Distinct<Integer, MockRecord> distinct = new QueryPlanImpl.Distinct<Integer, MockRecord>(){};
        distinct.associateResultSet(rs);
        QueryPlanImpl.StepResult<Integer, MockRecord> distinctRows = distinct.getResult(repository, allRows);
        ArrayList payloads = Lists.newArrayList();
        for (QueryResultSet.Row row : distinctRows.getQueryResult()) {
            Object payload = row.getValue(MockRecord.payload);
            payloads.add(payload);
        }
        Assert.assertEquals((String)"4 payloads", (long)4L, (long)payloads.size());
        Assert.assertTrue((String)"contains apple", (boolean)payloads.contains("Apple"));
        Assert.assertTrue((String)"contains apple", (boolean)payloads.contains("Orange"));
        Assert.assertTrue((String)"contains apple", (boolean)payloads.contains("Pear"));
        Assert.assertTrue((String)"contains apple", (boolean)payloads.contains("Peach"));
    }
}

