/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.test.unit;

import com.google.common.collect.Lists;
import com.neeve.query.Query;
import com.neeve.query.QueryPlan;
import com.neeve.query.QueryResultSet;
import com.neeve.query.impl.QueryImpl;
import com.neeve.query.impl.QueryOptimizer;
import com.neeve.query.impl.QueryPlanImpl;
import com.neeve.query.impl.QueryStaticField;
import com.neeve.query.impl.mem.ListRepository;
import com.neeve.query.impl.mem.MemQuerySetRepository;
import com.neeve.query.impl.mock.MockQueryEngine;
import com.neeve.query.impl.mock.MockRecord;
import com.neeve.query.impl.predicates.FieldPredicate;
import com.neeve.query.impl.predicates.PredicateOperators;
import com.neeve.query.impl.predicates.PredicatesImpl;
import com.neeve.query.impl.test.unit.QueryPlanTest;
import com.neeve.query.index.IdxIndex;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class OptimizerTest {
    private static MockQueryEngine engine;
    private static MemQuerySetRepository<Integer, MockRecord> repository;
    private static IdxIndex<Integer, Integer> idIndex;
    private static IdxIndex<String, Integer> nameIndex;
    private PredicatesImpl predicates = PredicatesImpl.get();

    @BeforeClass
    public static void setup() throws Exception {
        System.setProperty("nv.unittest", "true");
        engine = new MockQueryEngine();
        repository = new MemQuerySetRepository<Integer, MockRecord>("mock", MockRecord.keyMapper);
        repository.open();
        engine.addRepository(repository, "mock");
        idIndex = repository.createIndex(MockRecord.staticRecordId, true);
        nameIndex = repository.createIndex(QueryPlanTest.payloadField, false);
        repository.add(new MockRecord(1, "Apple"));
        repository.add(new MockRecord(2, "Orange"));
        repository.add(new MockRecord(3, "Pear"));
        repository.add(new MockRecord(4, "Peach"));
        repository.add(new MockRecord(5, "Apple"));
        repository.add(new MockRecord(6, "Orange"));
        for (int id = 7; id <= 100; ++id) {
            repository.add(new MockRecord(id, null));
        }
        repository.flushIndexing();
    }

    @AfterClass
    public static void teardown() throws Exception {
        System.setProperty("nv.unittest", "false");
        repository.dropIndex(MockRecord.staticRecordId);
        repository.dropIndex(QueryPlanTest.payloadField);
        engine.close();
    }

    @Test
    public void testUniformLocation() {
        double location = QueryOptimizer.OperatorSelectivity.uniformLocation(10, 20, 10);
        Assert.assertEquals((String)"low value should return 0.0", (double)0.0, (double)location, (double)0.0);
        location = QueryOptimizer.OperatorSelectivity.uniformLocation("Aardvark", "Zebra", "Zebra");
        Assert.assertEquals((String)"high value should return 1.0", (double)1.0, (double)location, (double)0.0);
        location = QueryOptimizer.OperatorSelectivity.uniformLocation(Color.RED, Color.GREEN, Color.BLUE);
        Assert.assertEquals((String)"middle value should return 0.5", (double)0.5, (double)location, (double)0.0);
        Calendar cal = Calendar.getInstance();
        cal.set(1, 2014);
        cal.set(2, 7);
        cal.set(5, 1);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date first = cal.getTime();
        cal.set(5, 31);
        Date thirtyFirst = cal.getTime();
        cal.set(5, 21);
        Date twentyFirst = cal.getTime();
        location = QueryOptimizer.OperatorSelectivity.uniformLocation(first, thirtyFirst, twentyFirst);
        Assert.assertEquals((String)"date value should be 20 days out of 30 days", (double)0.6666666666666666, (double)location, (double)1.0E-6);
        location = QueryOptimizer.OperatorSelectivity.uniformLocation(10, 20, 5);
        Assert.assertTrue((String)"5 is below [10,20]", (location < 0.0 ? 1 : 0) != 0);
        location = QueryOptimizer.OperatorSelectivity.uniformLocation(10, 20, 45);
        Assert.assertTrue((String)"45 is above [10,20]", (location > 1.0 ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsSelectivity() {
        IdentityField<String> passThru = new IdentityField<String>(String.class);
        FieldPredicate predicate = (FieldPredicate)this.predicates.createBinary(passThru, PredicateOperators.EQUALS, "Apple");
        double fetchRatio = QueryOptimizer.OperatorSelectivity.DISCRETE_SELECTIVITY.getFetchRatio(predicate, nameIndex, repository);
        Assert.assertEquals((String)"expected 1/4 of entries", (double)0.02, (double)fetchRatio, (double)0.0);
        predicate = (FieldPredicate)this.predicates.createBinary(passThru, PredicateOperators.EQUALS, "tamale");
        fetchRatio = QueryOptimizer.OperatorSelectivity.DISCRETE_SELECTIVITY.getFetchRatio(predicate, nameIndex, repository);
        Assert.assertEquals((String)"expected no results", (double)0.0, (double)fetchRatio, (double)0.0);
        predicate = (FieldPredicate)this.predicates.createBinary(passThru, PredicateOperators.EQUALS, (String)null);
        fetchRatio = QueryOptimizer.OperatorSelectivity.DISCRETE_SELECTIVITY.getFetchRatio(predicate, nameIndex, repository);
        Assert.assertEquals((String)"expected no results", (double)0.0, (double)fetchRatio, (double)0.0);
    }

    @Test
    public void testInSelectivity() {
        IdentityField<String> passThru = new IdentityField<String>(String.class);
        FieldPredicate predicate = (FieldPredicate)this.predicates.createNary(passThru, PredicateOperators.IN, Lists.newArrayList((Object[])new String[]{"Pear"}));
        double fetchRatio = QueryOptimizer.OperatorSelectivity.DISCRETE_SELECTIVITY.getFetchRatio(predicate, nameIndex, repository);
        Assert.assertEquals((String)"expected 1 entry", (double)0.01, (double)fetchRatio, (double)0.0);
        predicate = (FieldPredicate)this.predicates.createNary(passThru, PredicateOperators.IN, Lists.newArrayList((Object[])new String[]{"Pear", "Pear", "Palamino"}));
        fetchRatio = QueryOptimizer.OperatorSelectivity.DISCRETE_SELECTIVITY.getFetchRatio(predicate, nameIndex, repository);
        Assert.assertEquals((String)"expected 2 entries", (double)0.02, (double)fetchRatio, (double)0.0);
        predicate = (FieldPredicate)this.predicates.createNary(passThru, PredicateOperators.IN, Lists.newArrayList((Object[])new String[]{"Palamino"}));
        fetchRatio = QueryOptimizer.OperatorSelectivity.DISCRETE_SELECTIVITY.getFetchRatio(predicate, nameIndex, repository);
        Assert.assertEquals((String)"expected no entries", (double)0.0, (double)fetchRatio, (double)0.0);
        predicate = (FieldPredicate)this.predicates.createNary(passThru, PredicateOperators.IN, Lists.newArrayList());
        fetchRatio = QueryOptimizer.OperatorSelectivity.DISCRETE_SELECTIVITY.getFetchRatio(predicate, nameIndex, repository);
        Assert.assertEquals((String)"expected no entries", (double)0.0, (double)fetchRatio, (double)0.0);
    }

    @Test
    public void testGreaterThanSelectivity() {
        IdentityField<String> passThru = new IdentityField<String>(String.class);
        FieldPredicate predicate = (FieldPredicate)this.predicates.createBinary(passThru, PredicateOperators.GREATER_THAN, "Pear");
        double fetchRatio = QueryOptimizer.OperatorSelectivity.GREATER_THAN_SELECTIVITY.getFetchRatio(predicate, nameIndex, repository);
        Assert.assertEquals((String)"expected no entries", (double)0.0, (double)fetchRatio, (double)0.0);
        predicate = (FieldPredicate)this.predicates.createBinary(passThru, PredicateOperators.GREATER_THAN, "Lemon");
        fetchRatio = QueryOptimizer.OperatorSelectivity.GREATER_THAN_SELECTIVITY.getFetchRatio(predicate, nameIndex, repository);
        Assert.assertEquals((String)"expected 2 entries", (double)0.02, (double)fetchRatio, (double)0.001);
        predicate = (FieldPredicate)this.predicates.createBinary(passThru, PredicateOperators.GREATER_THAN, "Palamino");
        fetchRatio = QueryOptimizer.OperatorSelectivity.GREATER_THAN_SELECTIVITY.getFetchRatio(predicate, nameIndex, repository);
        Assert.assertEquals((String)"expected 0 entries", (double)0.0, (double)fetchRatio, (double)0.001);
        predicate = (FieldPredicate)this.predicates.createBinary(passThru, PredicateOperators.GREATER_THAN, "Aardvark");
        fetchRatio = QueryOptimizer.OperatorSelectivity.GREATER_THAN_SELECTIVITY.getFetchRatio(predicate, nameIndex, repository);
        Assert.assertEquals((String)"expected 100% of non-null entries", (double)0.06, (double)fetchRatio, (double)0.0);
    }

    @Test
    public void testLessThanSelectivity() {
        IdentityField<String> passThru = new IdentityField<String>(String.class);
        FieldPredicate predicate = (FieldPredicate)this.predicates.createBinary(passThru, PredicateOperators.LESS_THAN, "Pear");
        double fetchRatio = QueryOptimizer.OperatorSelectivity.LESS_THAN_SELECTIVITY.getFetchRatio(predicate, nameIndex, repository);
        Assert.assertEquals((String)"expected all non-null entries", (double)0.06, (double)fetchRatio, (double)0.0);
        predicate = (FieldPredicate)this.predicates.createBinary(passThru, PredicateOperators.LESS_THAN, "Nambia");
        fetchRatio = QueryOptimizer.OperatorSelectivity.LESS_THAN_SELECTIVITY.getFetchRatio(predicate, nameIndex, repository);
        Assert.assertEquals((String)"expected 5 entries", (double)0.05, (double)fetchRatio, (double)0.001);
        predicate = (FieldPredicate)this.predicates.createBinary(passThru, PredicateOperators.LESS_THAN, "Palamino");
        fetchRatio = QueryOptimizer.OperatorSelectivity.LESS_THAN_SELECTIVITY.getFetchRatio(predicate, nameIndex, repository);
        Assert.assertEquals((String)"expected all non-null entries", (double)0.06, (double)fetchRatio, (double)0.001);
        predicate = (FieldPredicate)this.predicates.createBinary(passThru, PredicateOperators.LESS_THAN, "Aardvark");
        fetchRatio = QueryOptimizer.OperatorSelectivity.LESS_THAN_SELECTIVITY.getFetchRatio(predicate, nameIndex, repository);
        Assert.assertEquals((String)"expected no entries", (double)0.0, (double)fetchRatio, (double)0.0);
    }

    @Test
    public void testBetweenSelectivity() {
        IdentityField<String> passThru = new IdentityField<String>(String.class);
        FieldPredicate predicate = (FieldPredicate)this.predicates.createTernary(passThru, PredicateOperators.BETWEEN, "Apple", "Pear");
        double fetchRatio = QueryOptimizer.OperatorSelectivity.BETWEEN_SELECTIVITY.getFetchRatio(predicate, nameIndex, repository);
        Assert.assertEquals((String)"expected all six", (double)0.06, (double)fetchRatio, (double)0.0);
        predicate = (FieldPredicate)this.predicates.createTernary(passThru, PredicateOperators.BETWEEN, "Aardvark", "Zebra");
        fetchRatio = QueryOptimizer.OperatorSelectivity.BETWEEN_SELECTIVITY.getFetchRatio(predicate, nameIndex, repository);
        Assert.assertEquals((String)"expected all six", (double)0.06, (double)fetchRatio, (double)0.001);
        predicate = (FieldPredicate)this.predicates.createTernary(passThru, PredicateOperators.BETWEEN, "Nambia", "Zebra");
        fetchRatio = QueryOptimizer.OperatorSelectivity.BETWEEN_SELECTIVITY.getFetchRatio(predicate, nameIndex, repository);
        Assert.assertEquals((String)"expected one entries", (double)0.01, (double)fetchRatio, (double)0.001);
        predicate = (FieldPredicate)this.predicates.createTernary(passThru, PredicateOperators.BETWEEN, "Aardvark", "Nambia");
        fetchRatio = QueryOptimizer.OperatorSelectivity.BETWEEN_SELECTIVITY.getFetchRatio(predicate, nameIndex, repository);
        Assert.assertEquals((String)"expected half of non-null entries", (double)0.05, (double)fetchRatio, (double)0.001);
        predicate = (FieldPredicate)this.predicates.createTernary(passThru, PredicateOperators.BETWEEN, "Peach", "Pear");
        fetchRatio = QueryOptimizer.OperatorSelectivity.BETWEEN_SELECTIVITY.getFetchRatio(predicate, nameIndex, repository);
        Assert.assertEquals((String)"expected no entries", (double)0.0, (double)fetchRatio, (double)0.0);
    }

    @Test
    public void testNotNullSelectivity() {
        IdentityField<String> passThru = new IdentityField<String>(String.class);
        FieldPredicate predicate = (FieldPredicate)this.predicates.createUnary(passThru, PredicateOperators.IS_NOT_NULL);
        double fetchRatio = QueryOptimizer.OperatorSelectivity.FULL_INDEX_SELECTIVITY.getFetchRatio(predicate, nameIndex, repository);
        Assert.assertEquals((String)"expected all six", (double)0.06, (double)fetchRatio, (double)0.0);
        Query query = engine.createQuery("select * from mock where object is not null");
        QueryResultSet rs = engine.execute(query);
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        Assert.assertEquals((String)"should find 6 rows", (long)6L, (long)numRows);
    }

    @Test
    public void testIndexOrderedPlan() {
        QueryOptimizer<Integer, MockRecord> optimizer = new QueryOptimizer<Integer, MockRecord>(engine);
        QueryImpl<MockRecord> query = new QueryImpl<MockRecord>();
        query.select(MockRecord.selectAll).from("mock").orderBy(MockRecord.recordId);
        QueryPlanImpl<Integer, MockRecord> plan = optimizer.createPlan(repository, query);
        QueryPlan.Step firstStep = plan.getSteps().get(0);
        Assert.assertTrue((String)"The firstStep should be a FullIndexRead", (boolean)(firstStep instanceof QueryPlanImpl.FullIndexRead));
    }

    @Test
    public void testMonotonicScan() throws Exception {
        ArrayList records = Lists.newArrayList();
        records.add(new MockRecord(1, "tuba"));
        records.add(new MockRecord(2, "swan"));
        records.add(new MockRecord(3, "rose"));
        records.add(new MockRecord(4, "quartz"));
        records.add(new MockRecord(5, "puma"));
        records.add(new MockRecord(6, "orange"));
        ListRepository<MockRecord> listRepo = new ListRepository<MockRecord>("records", records);
        listRepo.registerMonotonicField(MockRecord.staticRecordId, true);
        listRepo.open();
        MockQueryEngine engine2 = new MockQueryEngine();
        engine2.addRepository(listRepo, "records");
        QueryOptimizer<Integer, MockRecord> optimizer = new QueryOptimizer<Integer, MockRecord>(engine2);
        QueryImpl query = (QueryImpl)engine2.createQuery();
        query.select(MockRecord.selectAll).from("records").where(MockRecord.staticRecordId.in((Integer[])new Integer[]{2, 3, 5}));
        QueryPlanImpl<Integer, MockRecord> plan = optimizer.createPlan(listRepo, query);
        QueryPlan.Step firstStep = plan.getSteps().get(0);
        Assert.assertTrue((String)"The firstStep should be a MonotonicValueScan", (boolean)(firstStep instanceof QueryPlanImpl.MonotonicValueScan));
        query = (QueryImpl)engine2.createQuery();
        query.select(MockRecord.selectAll).from("records").where(MockRecord.staticRecordId.between(2, 5));
        plan = optimizer.createPlan(listRepo, query);
        firstStep = plan.getSteps().get(0);
        Assert.assertTrue((String)"The firstStep should be a MonotonicValueScan", (boolean)(firstStep instanceof QueryPlanImpl.MonotonicRangeScan));
        engine2.close();
    }

    private static enum Color {
        RED,
        BLUE,
        GREEN;

    }

    private static class IdentityField<T>
    extends QueryStaticField<T, T> {
        private static final long serialVersionUID = 1L;

        public IdentityField(Class<T> type) {
            super(type, "", type);
        }

        @Override
        protected T applyUnchecked(T record) {
            return record;
        }
    }
}

