/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.test.unit;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.neeve.query.impl.predicates.PredicateOperator;
import com.neeve.test.UnitTest;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class OperatorTest
extends UnitTest {
    @Test
    public void testEquals() {
        Assert.assertFalse((String)"this is not that", (boolean)PredicateOperator.EQUALS.apply("this", "that"));
        Assert.assertTrue((String)"4 is 4", (boolean)PredicateOperator.EQUALS.apply(4, 4));
        long now = System.currentTimeMillis();
        Date d1 = new Date(now);
        Date d2 = new Date(now);
        Assert.assertTrue((String)"same date", (boolean)PredicateOperator.EQUALS.apply(d1, d2));
        Assert.assertTrue((String)"null is null", (boolean)PredicateOperator.EQUALS.apply(null, null));
        Assert.assertFalse((String)"null is not d1", (boolean)PredicateOperator.EQUALS.apply(null, d1));
        Assert.assertFalse((String)"d1 is not null", (boolean)PredicateOperator.EQUALS.apply(d1, null));
    }

    @Test
    public void testIn() {
        Assert.assertFalse((String)"nothing in empty list", (boolean)PredicateOperator.IN.apply("asdf", Lists.newArrayList()));
        Assert.assertTrue((String)"value in singleton set", (boolean)PredicateOperator.IN.apply(Integer.valueOf(3), Sets.newHashSet((Object[])new Integer[]{3})));
        Assert.assertTrue((String)"value in set", (boolean)PredicateOperator.IN.apply(Double.valueOf(3.5), Sets.newHashSet((Object[])new Double[]{3.0, 3.5, 4.0})));
        Assert.assertFalse((String)"value not in list", (boolean)PredicateOperator.IN.apply("xyz", Lists.newArrayList((Object[])new String[]{"a", "b", "c"})));
        Assert.assertFalse((String)"null not in list", (boolean)PredicateOperator.IN.apply(null, Lists.newArrayList((Object[])new String[]{"a", "b", "c"})));
        Assert.assertTrue((String)"null in list", (boolean)PredicateOperator.IN.apply(null, Lists.newArrayList((Object[])new String[]{"a", "b", "c", null})));
    }

    @Test
    public void testLessThan() {
        Assert.assertTrue((String)"3 < 4", (boolean)PredicateOperator.LESS_THAN.apply(3, 4));
        Assert.assertFalse((String)"3 !< 3", (boolean)PredicateOperator.LESS_THAN.apply(3.0, 3.0));
        Assert.assertTrue((String)"a < b", (boolean)PredicateOperator.LESS_THAN.apply("a", "b"));
        Assert.assertFalse((String)"b !< a", (boolean)PredicateOperator.LESS_THAN.apply("b", "a"));
        Assert.assertFalse((String)"null < a", (boolean)PredicateOperator.LESS_THAN.apply(null, "a"));
        Assert.assertFalse((String)"null < null", (boolean)PredicateOperator.LESS_THAN.apply(null, null));
        Assert.assertFalse((String)"a < null", (boolean)PredicateOperator.LESS_THAN.apply("a", null));
    }

    @Test
    public void testLessThanOrEqual() {
        Assert.assertTrue((String)"3 <= 4", (boolean)PredicateOperator.LESS_THAN_OR_EQUAL.apply(3, 4));
        Assert.assertTrue((String)"3 <= 3", (boolean)PredicateOperator.LESS_THAN_OR_EQUAL.apply(3.0, 3.0));
        Assert.assertTrue((String)"a <= b", (boolean)PredicateOperator.LESS_THAN_OR_EQUAL.apply("a", "b"));
        Assert.assertFalse((String)"b <= a", (boolean)PredicateOperator.LESS_THAN_OR_EQUAL.apply("b", "a"));
        Assert.assertFalse((String)"null <= a", (boolean)PredicateOperator.LESS_THAN_OR_EQUAL.apply(null, "a"));
        Assert.assertFalse((String)"null <= null", (boolean)PredicateOperator.LESS_THAN_OR_EQUAL.apply(null, null));
        Assert.assertFalse((String)"a <= null", (boolean)PredicateOperator.LESS_THAN_OR_EQUAL.apply("a", null));
    }

    @Test
    public void testGreaterThan() {
        Assert.assertTrue((String)"4 > 3", (boolean)PredicateOperator.GREATER_THAN.apply(4, 3));
        Assert.assertFalse((String)"3 > 3", (boolean)PredicateOperator.GREATER_THAN.apply(3.0, 3.0));
        Assert.assertTrue((String)"B > A", (boolean)PredicateOperator.GREATER_THAN.apply("b", "a"));
        Assert.assertFalse((String)"a > b", (boolean)PredicateOperator.GREATER_THAN.apply("a", "b"));
        Assert.assertFalse((String)"null < a", (boolean)PredicateOperator.GREATER_THAN.apply(null, "a"));
        Assert.assertFalse((String)"null < null", (boolean)PredicateOperator.GREATER_THAN.apply(null, null));
        Assert.assertFalse((String)"a < null", (boolean)PredicateOperator.GREATER_THAN.apply("a", null));
    }

    @Test
    public void testGreaterThanOrEqual() {
        Assert.assertTrue((String)"4 >= 3", (boolean)PredicateOperator.GREATER_THAN_OR_EQUAL.apply(4, 3));
        Assert.assertTrue((String)"3 >= 3", (boolean)PredicateOperator.GREATER_THAN_OR_EQUAL.apply(3.0, 3.0));
        Assert.assertTrue((String)"B >= A", (boolean)PredicateOperator.GREATER_THAN_OR_EQUAL.apply("b", "a"));
        Assert.assertFalse((String)"a >= b", (boolean)PredicateOperator.GREATER_THAN_OR_EQUAL.apply("a", "b"));
        Assert.assertFalse((String)"null <= a", (boolean)PredicateOperator.GREATER_THAN_OR_EQUAL.apply(null, "a"));
        Assert.assertFalse((String)"null <= null", (boolean)PredicateOperator.GREATER_THAN_OR_EQUAL.apply(null, null));
        Assert.assertFalse((String)"a <= null", (boolean)PredicateOperator.GREATER_THAN_OR_EQUAL.apply("a", null));
    }

    @Test
    public void testBetween() {
        Assert.assertTrue((String)"2 between 1 and 3", (boolean)PredicateOperator.BETWEEN.apply(2, 1, 3));
        Assert.assertTrue((String)"1 between 1 and 3", (boolean)PredicateOperator.BETWEEN.apply(1, 1, 3));
        Assert.assertTrue((String)"3 between 1 and 3", (boolean)PredicateOperator.BETWEEN.apply(3.0, 1.0, 3.0));
        Assert.assertTrue((String)"monkey between banana and tree", (boolean)PredicateOperator.BETWEEN.apply("monkey", "banana", "tree"));
        Assert.assertFalse((String)"banana between monkey and tree", (boolean)PredicateOperator.BETWEEN.apply("banana", "monkey", "tree"));
        Assert.assertFalse((String)"null between monkey and tree", (boolean)PredicateOperator.BETWEEN.apply(null, "monkey", "tree"));
        Assert.assertFalse((String)"banana between null and tree", (boolean)PredicateOperator.BETWEEN.apply("banana", null, "tree"));
        Assert.assertFalse((String)"banana between monkey and null", (boolean)PredicateOperator.BETWEEN.apply("banana", "monkey", null));
        Assert.assertFalse((String)"banana between null and null", (boolean)PredicateOperator.BETWEEN.apply("banana", null, null));
    }
}

