/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.index;

import com.neeve.query.impl.index.IdxBaseIndex;
import com.neeve.query.index.IdxUniqueIndex;
import java.util.Iterator;
import java.util.Map;

public abstract class IdxUniqueBaseIndex<T, ID>
extends IdxBaseIndex<T, ID>
implements IdxUniqueIndex<T, ID> {
    private Map<Object, ID> map;

    public IdxUniqueBaseIndex(String name, Map<Object, ID> backingMap) {
        super(name, true);
        this.map = backingMap;
    }

    protected Map<Object, ID> getBackingMap() {
        return this.map;
    }

    protected Map<Object, ID> getBackingMap(boolean ascending) {
        return this.getBackingMap();
    }

    @Override
    public void put(T fieldValue, ID recordId) {
        Object indexKey = this.getIndexKey(fieldValue);
        if (this.map.put(indexKey, recordId) == null) {
            this.stats.onKeyAdded(fieldValue);
            this.stats.onValueAdded();
        }
    }

    @Override
    public void remove(T fieldValue, ID id) {
        ID removed = this.map.remove(fieldValue);
        if (removed != null && removed.equals(id)) {
            this.stats.onKeyRemoved(fieldValue, this);
            this.stats.onValueRemoved();
        } else {
            this.map.put(fieldValue, removed);
        }
    }

    @Override
    public ID getId(T fieldValue) {
        return this.map.get(fieldValue);
    }

    @Override
    public boolean containsKey(T fieldValue) {
        return this.map.containsKey(fieldValue);
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public int valueCount(Iterable<? extends Object> keys) {
        int count = 0;
        for (Object object : keys) {
            if (object == null || !this.map.containsKey(object)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void computeStats() {
        this.stats.setCardinality(this.map.size());
        this.stats.setKeyCardinality(this.map.size());
        this.stats.setHighKey(null);
        this.stats.setLowKey(null);
        this.stats.setUnique(true);
    }

    @Override
    public Iterable<Map.Entry<T, ID>> allEntries(boolean ascending) {
        Iterator<Map.Entry<Object, ID>> rawIter = this.getBackingMap(ascending).entrySet().iterator();
        return (Iterable)((Object)rawIter);
    }

    protected static class LazyValues<K, V>
    implements Iterable<V> {
        private Map<K, V> map;

        public LazyValues(Map<K, V> map) {
            this.map = map;
        }

        @Override
        public Iterator<V> iterator() {
            return new Iterator<V>(){
                private Iterator<Map.Entry<K, V>> entryIter;
                {
                    this.entryIter = map.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.entryIter.hasNext();
                }

                @Override
                public V next() {
                    Map.Entry next = this.entryIter.next();
                    return next.getValue();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

