/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl;

import com.google.common.collect.Lists;
import com.neeve.query.QueryException;
import com.neeve.query.impl.QueryAggregateField;
import com.neeve.query.impl.QueryConfig;
import com.neeve.query.impl.QueryEngineImpl;
import com.neeve.query.impl.QueryImpl;
import com.neeve.query.impl.QueryIndexableRepository;
import com.neeve.query.impl.QueryMonotonicField;
import com.neeve.query.impl.QueryObject;
import com.neeve.query.impl.QueryPlanImpl;
import com.neeve.query.impl.QueryRepositoryBase;
import com.neeve.query.impl.predicates.FieldPredicate;
import com.neeve.query.impl.predicates.PredicateBase;
import com.neeve.query.impl.predicates.PredicateOperator;
import com.neeve.query.impl.predicates.Predicates;
import com.neeve.query.impl.predicates.PredicatesImpl;
import com.neeve.query.impl.util.collect.UtlRangeBase;
import com.neeve.query.index.IdxField;
import com.neeve.query.index.IdxIndex;
import com.neeve.query.index.IdxRange;
import com.neeve.query.predicates.Predicate;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlText;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class QueryOptimizer<ID, REC>
extends QueryObject {
    private static final FilterCostComparator FILTER_COST_COMPARATOR = new FilterCostComparator();
    private double fetchRatioThreshold = 0.3;
    private Comparator<ID> naturalKeyOrder;
    private final QueryEngineImpl<ID, REC> queryEngine;
    private Predicates predicates = PredicatesImpl.get();

    private static OperatorSelectivity determineSelectivity(PredicateOperator operator) {
        if (operator.equals(PredicateOperator.EQUALS) || operator.equals(PredicateOperator.IN)) {
            return OperatorSelectivity.DISCRETE_SELECTIVITY;
        }
        if (operator.equals(PredicateOperator.LESS_THAN) || operator.equals(PredicateOperator.LESS_THAN_OR_EQUAL)) {
            return OperatorSelectivity.LESS_THAN_SELECTIVITY;
        }
        if (operator.equals(PredicateOperator.GREATER_THAN) || operator.equals(PredicateOperator.GREATER_THAN_OR_EQUAL)) {
            return OperatorSelectivity.GREATER_THAN_SELECTIVITY;
        }
        if (operator.equals(PredicateOperator.BETWEEN)) {
            return OperatorSelectivity.BETWEEN_SELECTIVITY;
        }
        if (operator.equals(PredicateOperator.IS_NOT_NULL)) {
            return OperatorSelectivity.FULL_INDEX_SELECTIVITY;
        }
        return OperatorSelectivity.FULL_SCAN_SELECTIVITY;
    }

    public QueryOptimizer(QueryEngineImpl<ID, REC> queryEngine) {
        super(QueryConfig.getConfig());
        this.queryEngine = queryEngine;
    }

    public void setFetchRatioThreshold(double threshold) {
        this.fetchRatioThreshold = threshold;
    }

    public double getFetchRatioThreshold() {
        return this.fetchRatioThreshold;
    }

    private IdxIndex<?, ?> getIndex(QueryIndexableRepository<ID, REC> repository, FieldPredicate<REC, ?, ?> fieldPredicate) {
        IdxField<REC, ?> field = fieldPredicate.getField();
        return this.getIndex(repository, field);
    }

    private IdxIndex<?, ?> getIndex(QueryIndexableRepository<ID, REC> repository, IdxField<REC, ?> field) {
        IdxIndex index = repository.getIndex(field);
        if (index != null) {
            boolean indexIsUpToDate;
            IdxIndex.Stats<?> stats = index.getStats();
            boolean bl = indexIsUpToDate = stats.isLive() && repository.isLiveIndexingUpToDate();
            if (!indexIsUpToDate) {
                switch (this.queryEngine.getBackgroundIndexingPolicy()) {
                    case FLUSH_ON_CREATE: 
                    case FLUSH_ON_QUERY: 
                    case FLUSH_ON_USE: {
                        if (this.tracer.debug) {
                            this.tracer.log("Flushing Index for " + field + " on " + repository.getName(), Tracer.Level.DEBUG);
                        }
                        repository.flushIndexing();
                        if (!this.tracer.debug) break;
                        this.tracer.log("Index complete for " + field + " on " + repository.getName(), Tracer.Level.DEBUG);
                        break;
                    }
                    case FLUSH_NEVER: {
                        if (this.tracer.debug) {
                            this.tracer.log("Skipping unbuilt index for " + field + " on " + repository.getName(), Tracer.Level.DEBUG);
                        }
                        index = null;
                    }
                }
            }
        }
        return index;
    }

    public QueryPlanImpl<ID, REC> createPlan(QueryIndexableRepository<ID, REC> repository, QueryImpl<REC> query) {
        Predicate<REC> having;
        Predicate<REC> where = query.getWhere();
        if (where instanceof PredicateBase) {
            PredicateBase whereImpl = (PredicateBase)where;
            whereImpl.regularize();
            whereImpl.prioritizeByCost();
        }
        Set<IdxField<REC, ?>> allFields = query.getAllFields();
        QueryPlanImpl plan = this.createPlan(repository, allFields, where);
        if (query.isDistinct()) {
            plan.addStep(new QueryPlanImpl.Distinct());
        }
        if (query.isAggregated()) {
            plan = this.aggregate(plan, query);
        }
        if (!query.getOrderBy().isEmpty()) {
            plan = this.sort(plan, query, repository);
        }
        if ((having = query.getHaving()) != null) {
            plan.addStep(new QueryPlanImpl.FilterImpl(having));
        }
        return plan;
    }

    private boolean isEfficientRead(QueryIndexableRepository<ID, REC> repository, QueryPlanImpl.IndexRead<ID, REC> readStep, double threshold) {
        int stepReadSize = readStep.estimateSize(repository);
        double readRatio = (double)stepReadSize / (double)repository.getSize();
        return readRatio <= threshold;
    }

    private QueryPlanImpl<ID, REC> createPlan(QueryIndexableRepository<ID, REC> repository, Collection<IdxField<REC, ?>> allFields, Predicate<REC> predicate) {
        QueryPlanImpl<ID, REC> plan;
        if (allFields.size() == 1 && (plan = this.createIndexDataRead(repository, allFields, predicate)) != null) {
            return plan;
        }
        if (predicate instanceof FieldPredicate) {
            FieldPredicate fieldPredicate = (FieldPredicate)predicate;
            plan = this.createFieldReadPlan(repository, fieldPredicate);
        } else if (predicate instanceof PredicatesImpl.And) {
            ArrayList plans = Lists.newArrayList();
            for (Predicate<REC> child : this.extractAndChildren(predicate)) {
                QueryPlanImpl<ID, REC> childPlan = this.createPlan(repository, allFields, child);
                plans.add(childPlan);
            }
            plan = this.and(repository, plans);
        } else if (predicate instanceof PredicatesImpl.Or) {
            ArrayList plans = Lists.newArrayList();
            for (Predicate<REC> child : this.extractOrChildren(predicate)) {
                QueryPlanImpl<ID, REC> childPlan = this.createPlan(repository, allFields, child);
                plans.add(childPlan);
            }
            plan = this.or(repository, plans);
        } else if (predicate instanceof PredicatesImpl.Not) {
            FieldPredicate childFieldPred;
            Object operator;
            plan = null;
            PredicatesImpl.Not not = (PredicatesImpl.Not)predicate;
            Predicate childPredicate = not.getChild();
            if (childPredicate instanceof FieldPredicate && (operator = (childFieldPred = (FieldPredicate)childPredicate).getOperator()) == PredicateOperator.IS_NULL) {
                plan = this.createFullIndexRead(repository, predicate);
            }
            if (plan == null) {
                plan = this.createFullRead(predicate);
            }
        } else {
            plan = this.createFullRead(predicate);
        }
        return plan;
    }

    private QueryPlanImpl<ID, REC> createIndexDataRead(QueryIndexableRepository<ID, REC> repository, Collection<IdxField<REC, ?>> allFields, Predicate<REC> predicate) {
        if (allFields.size() != 1) {
            return null;
        }
        IdxField<REC, ?> field = allFields.iterator().next();
        IdxIndex<?, ?> index = this.getIndex(repository, field);
        if (index == null) {
            return null;
        }
        return this.createIndexDataRead(repository, index, predicate);
    }

    private QueryPlanImpl<ID, REC> createIndexDataRead(QueryIndexableRepository<ID, REC> repository, IdxIndex<?, ?> index, Predicate<REC> predicate) {
        QueryPlanImpl<ID, REC> plan = null;
        if (predicate instanceof FieldPredicate) {
            // empty if block
        }
        return plan;
    }

    private QueryPlanImpl<ID, REC> createFieldReadPlan(QueryIndexableRepository<ID, REC> repository, FieldPredicate<REC, ?, ?> fieldPredicate) {
        Class<?> fieldType;
        if (((PredicateOperator)fieldPredicate.getOperator()).isRanged() && (fieldType = fieldPredicate.getField().getFieldType()) != Object.class && !Comparable.class.isAssignableFrom(fieldPredicate.getField().getFieldType())) {
            throw new QueryException("Cannot create a ranged query on " + fieldPredicate.getField().getFieldType().getSimpleName());
        }
        IdxField<REC, ?> field = fieldPredicate.getField();
        IdxIndex<?, ?> index = this.getIndex(repository, fieldPredicate);
        if (index != null) {
            return this.createIndexRead(repository, fieldPredicate, field, index);
        }
        QueryMonotonicField monotonicField = ((QueryRepositoryBase)repository).getMonotonicField(field);
        if (monotonicField != null) {
            return this.createMonotonicScan(repository, fieldPredicate, monotonicField);
        }
        return this.createFullRead(fieldPredicate);
    }

    private QueryPlanImpl<ID, REC> createIndexRead(QueryIndexableRepository<ID, REC> repository, FieldPredicate<REC, ?, ?> fieldPredicate, IdxField<REC, ?> field, IdxIndex<?, ID> index) {
        IdxIndex.Stats<?> stats = repository.getIndexStats(field);
        Object operator = fieldPredicate.getOperator();
        OperatorSelectivity selectivity = QueryOptimizer.determineSelectivity(operator);
        double fetchRatio = selectivity.getFetchRatio(fieldPredicate, index, repository);
        if (fetchRatio > this.fetchRatioThreshold) {
            return this.createFullRead(fieldPredicate);
        }
        QueryPlanImpl plan = new QueryPlanImpl();
        QueryPlanImpl.IndexReadBase indexRead = null;
        if (((PredicateOperator)operator).isRanged()) {
            IdxRange range = this.createRange(fieldPredicate);
            indexRead = stats.isUnique() ? new QueryPlanImpl.UniqueRangeRead(field, range, this.naturalKeyOrder, fetchRatio) : new QueryPlanImpl.NonUniqueRangeRead(field, range, this.naturalKeyOrder, fetchRatio);
        } else {
            IdxField<REC, ?> objectField = field;
            QueryPlanImpl.IndexReadBase indexReadBase = stats.isUnique() ? new QueryPlanImpl.UniqueIndexRead(objectField, this.naturalKeyOrder) : new QueryPlanImpl.NonUniqueIndexRead(objectField, this.naturalKeyOrder);
            for (Object value : fieldPredicate.getValues()) {
                indexReadBase.addFieldValue(value);
            }
            indexRead = indexReadBase;
        }
        indexRead.setPredicate(fieldPredicate);
        plan.addStep(indexRead);
        return plan;
    }

    private <T extends Comparable<T>> QueryPlanImpl<ID, REC> createMonotonicScan(QueryIndexableRepository<ID, REC> repository, FieldPredicate<REC, ?, ?> fieldPredicate, QueryMonotonicField<REC, T, ID> monotonicField) {
        QueryPlanImpl plan = new QueryPlanImpl();
        Object operator = fieldPredicate.getOperator();
        if (((PredicateOperator)operator).isRanged()) {
            IdxRange range = this.createRange(fieldPredicate);
            QueryPlanImpl.MonotonicRangeScan<ID, REC, T> scan = new QueryPlanImpl.MonotonicRangeScan<ID, REC, T>(monotonicField, range);
            scan.setPredicate(fieldPredicate);
            plan.addStep(scan);
        } else {
            QueryPlanImpl.MonotonicValueScan<ID, REC, Comparable> scan = new QueryPlanImpl.MonotonicValueScan<ID, REC, Comparable>(monotonicField);
            for (Object val : fieldPredicate.getValues()) {
                scan.addFieldValue((Comparable)val);
            }
            scan.setPredicate(fieldPredicate);
            plan.addStep(scan);
        }
        return plan;
    }

    private QueryPlanImpl<ID, REC> createFullRead(Predicate<REC> predicate) {
        QueryPlanImpl plan = new QueryPlanImpl();
        plan.addStep(new QueryPlanImpl.FullRead());
        if (predicate != null) {
            plan.addStep(new QueryPlanImpl.FilterImpl(predicate));
        }
        return plan;
    }

    private QueryPlanImpl<ID, REC> and(QueryIndexableRepository<ID, REC> repository, List<QueryPlanImpl<ID, REC>> plans) {
        if (plans.isEmpty()) {
            throw new QueryException("Cannot create the AND conjunction of an empty set of plans");
        }
        if (plans.size() == 1) {
            return plans.get(0);
        }
        ArrayList indexReads = Lists.newArrayList();
        ArrayList monotonicScans = Lists.newArrayList();
        ArrayList filters = Lists.newArrayList();
        for (QueryPlanImpl<ID, REC> plan : plans) {
            for (QueryPlanImpl.StepImpl<ID, REC> step : plan.getSteps()) {
                if (step instanceof QueryPlanImpl.FullRead) continue;
                if (step instanceof QueryPlanImpl.IndexRead) {
                    indexReads.add((QueryPlanImpl.IndexRead)step);
                    continue;
                }
                if (step instanceof QueryPlanImpl.MonotonicScan) {
                    monotonicScans.add((QueryPlanImpl.MonotonicScan)step);
                    continue;
                }
                if (step instanceof QueryPlanImpl.Filter) {
                    filters.add((QueryPlanImpl.Filter)((Object)step));
                    continue;
                }
                throw new QueryException("Unrecognized Plan.Step: " + step.getClass());
            }
        }
        QueryPlanImpl plan = new QueryPlanImpl();
        if (!indexReads.isEmpty()) {
            if (indexReads.size() == 1) {
                plan.addStep((QueryPlanImpl.StepImpl)indexReads.get(0));
            } else {
                QueryPlanImpl.IntersectionRead intersection = this.naturalKeyOrder != null ? new QueryPlanImpl.SortedIntersectionRead(indexReads, this.naturalKeyOrder) : new QueryPlanImpl.HashIntersectionRead(indexReads);
                if (this.isEfficientRead(repository, intersection, this.fetchRatioThreshold)) {
                    plan.addStep(intersection);
                } else {
                    plan.addStep(new QueryPlanImpl.FullRead());
                    filters.add(this.createFilterStep(intersection));
                }
            }
            for (QueryPlanImpl.MonotonicScan scan : monotonicScans) {
                Predicate predicate = scan.getPredicate();
                plan.addStep(new QueryPlanImpl.FilterImpl(predicate));
            }
        } else if (!monotonicScans.isEmpty()) {
            QueryPlanImpl.MonotonicScan bestScan = null;
            int estimatedSizeOfBestScan = repository.getSize();
            ArrayList otherScans = Lists.newArrayList();
            for (QueryPlanImpl.MonotonicScan scan : monotonicScans) {
                int estimatedSize = scan.estimateSize(repository);
                if (bestScan == null || estimatedSize < estimatedSizeOfBestScan) {
                    bestScan = scan;
                    estimatedSizeOfBestScan = estimatedSize;
                    continue;
                }
                otherScans.add(scan);
            }
            plan.addStep(bestScan);
            for (QueryPlanImpl.MonotonicScan scan : otherScans) {
                Predicate predicate = scan.getPredicate();
                plan.addStep(new QueryPlanImpl.FilterImpl(predicate));
            }
        } else {
            plan.addStep(new QueryPlanImpl.FullRead());
        }
        Collections.sort(filters, FILTER_COST_COMPARATOR);
        for (QueryPlanImpl.Filter filter : filters) {
            plan.addStep((QueryPlanImpl.StepImpl)((Object)filter));
        }
        return plan;
    }

    private QueryPlanImpl<ID, REC> or(QueryIndexableRepository<ID, REC> repository, List<QueryPlanImpl<ID, REC>> plans) {
        Predicate filterPredicate;
        if (plans.isEmpty()) {
            throw new QueryException("Cannot create the OR conjunction of an empty set of plans");
        }
        if (plans.size() == 1) {
            return plans.get(0);
        }
        ArrayList indexReads = Lists.newArrayList();
        ArrayList monotonicScans = Lists.newArrayList();
        ArrayList planPredicates = Lists.newArrayList();
        boolean foundFullRead = false;
        boolean foundFilter = false;
        for (QueryPlanImpl<ID, REC> queryPlanImpl : plans) {
            ArrayList stepPredicates = Lists.newArrayList();
            for (QueryPlanImpl.StepImpl<ID, REC> step : queryPlanImpl.getSteps()) {
                if (step instanceof QueryPlanImpl.FullRead) {
                    foundFullRead = true;
                    continue;
                }
                if (step instanceof QueryPlanImpl.IndexRead) {
                    QueryPlanImpl.IndexRead indexRead = (QueryPlanImpl.IndexRead)step;
                    indexReads.add(indexRead);
                    stepPredicates.add(step.getPredicate());
                    continue;
                }
                if (step instanceof QueryPlanImpl.MonotonicScan) {
                    monotonicScans.add((QueryPlanImpl.MonotonicScan)step);
                    stepPredicates.add(step.getPredicate());
                    continue;
                }
                if (step instanceof QueryPlanImpl.FilterImpl) {
                    stepPredicates.add(step.getPredicate());
                    foundFilter = true;
                    continue;
                }
                throw new QueryException("Unrecognized Plan.Step: " + step.getClass());
            }
            if (stepPredicates.isEmpty()) continue;
            Predicate planPredicate = this.predicates.and(stepPredicates);
            planPredicates.add(planPredicate);
        }
        if (planPredicates.isEmpty()) {
            filterPredicate = null;
        } else {
            Collections.sort(planPredicates, PredicateBase.COST_COMPARATOR);
            filterPredicate = this.predicates.or(planPredicates);
        }
        QueryPlanImpl queryPlanImpl = new QueryPlanImpl();
        if (foundFullRead) {
            queryPlanImpl.addStep(new QueryPlanImpl.FullRead());
        } else if (!monotonicScans.isEmpty()) {
            queryPlanImpl.addStep(new QueryPlanImpl.FullRead());
        } else if (!indexReads.isEmpty()) {
            QueryPlanImpl.OrExpansion indexReadStep = null;
            if (indexReads.size() == 1) {
                indexReadStep = (QueryPlanImpl.OrExpansion)indexReads.get(0);
            } else if (this.naturalKeyOrder != null && !this.isEfficientRead(repository, indexReadStep = new QueryPlanImpl.OrExpansion(indexReads, this.naturalKeyOrder), this.fetchRatioThreshold)) {
                indexReadStep = null;
            }
            if (indexReadStep == null) {
                queryPlanImpl.addStep(new QueryPlanImpl.FullRead());
            } else {
                queryPlanImpl.addStep(indexReadStep);
                if (!foundFilter) {
                    filterPredicate = null;
                }
            }
        }
        if (filterPredicate != null) {
            queryPlanImpl.addStep(new QueryPlanImpl.FilterImpl(filterPredicate));
        }
        return queryPlanImpl;
    }

    private QueryPlanImpl.FilterImpl<ID, REC> createFilterStep(QueryPlanImpl.IndexRead<ID, REC> indexRead) {
        Predicate<REC> predicate = indexRead.getPredicate();
        return new QueryPlanImpl.FilterImpl(predicate);
    }

    private List<Predicate<REC>> extractAndChildren(Predicate<REC> parent) {
        ArrayList predicates = Lists.newArrayList();
        if (parent instanceof PredicatesImpl.And) {
            PredicatesImpl.And and = (PredicatesImpl.And)parent;
            for (Predicate pred : and.getChildPredicates()) {
                List children = this.extractAndChildren(pred);
                predicates.addAll(children);
            }
        } else if (parent != null) {
            predicates.add(parent);
        }
        return predicates;
    }

    private List<Predicate<REC>> extractOrChildren(Predicate<REC> parent) {
        ArrayList predicates = Lists.newArrayList();
        if (parent instanceof PredicatesImpl.Or) {
            PredicatesImpl.Or or = (PredicatesImpl.Or)parent;
            for (Predicate pred : or.getChildPredicates()) {
                List children = this.extractOrChildren(pred);
                predicates.addAll(children);
            }
        } else if (parent != null) {
            predicates.add(parent);
        }
        return predicates;
    }

    private QueryPlanImpl<ID, REC> sort(QueryPlanImpl<ID, REC> plan, QueryImpl<REC> query, QueryIndexableRepository<ID, REC> repository) {
        for (QueryImpl.OrderByField<REC, ?> orderByField : query.getOrderBy()) {
            IdxField<REC, ?> field = orderByField.getField();
            try {
                field.validateIndexable();
            }
            catch (Exception qe) {
                String message = "Cannot order by " + field + " because " + qe.getMessage();
                throw new QueryException(message);
            }
        }
        if (plan.isFullScan() && this.viableIndexOrdered(query)) {
            plan = this.createIndexOrderedPlan(query, repository);
        } else {
            plan.addStep(new QueryPlanImpl.OrderBy(query));
        }
        return plan;
    }

    private boolean viableIndexOrdered(QueryImpl<REC> query) {
        if (query.isAggregated()) {
            return false;
        }
        List<QueryImpl.OrderByField<REC, ?>> orderBy = query.getOrderBy();
        if (orderBy.size() > 1) {
            return false;
        }
        QueryImpl.OrderByField<REC, ?> orderByField = orderBy.get(0);
        IdxField<REC, ?> firstField = orderByField.getField();
        return !(firstField instanceof QueryAggregateField);
    }

    private QueryPlanImpl<ID, REC> createFullIndexRead(QueryIndexableRepository<ID, REC> repository, Predicate<REC> notNullPredicate) {
        IdxField notNullField;
        FieldPredicate isNull;
        try {
            PredicatesImpl.Not isNotNull = (PredicatesImpl.Not)notNullPredicate;
            isNull = (FieldPredicate)isNotNull.getChild();
            notNullField = isNull.getField();
        }
        catch (Exception e) {
            throw new QueryException("Malformed NotNull predicate: " + e.getMessage());
        }
        IdxIndex index = this.getIndex(repository, notNullField);
        if (index == null) {
            return this.createFullRead(notNullPredicate);
        }
        OperatorSelectivity selectivity = QueryOptimizer.determineSelectivity(PredicateOperator.IS_NOT_NULL);
        double fetchRatio = selectivity.getFetchRatio(isNull, index, repository);
        if (fetchRatio > this.fetchRatioThreshold) {
            return this.createFullRead(notNullPredicate);
        }
        QueryPlanImpl plan = new QueryPlanImpl();
        plan.addStep(new QueryPlanImpl.FullIndexRead(notNullField, true));
        return plan;
    }

    private QueryPlanImpl<ID, REC> createIndexOrderedPlan(QueryImpl<REC> query, QueryIndexableRepository<ID, REC> repository) {
        List<QueryImpl.OrderByField<REC, ?>> orderBy = query.getOrderBy();
        QueryImpl.OrderByField<REC, ?> orderByField = orderBy.get(0);
        IdxField<REC, ?> field = orderByField.getField();
        IdxIndex<?, Object> index = this.getIndex(repository, field);
        if (index == null) {
            index = repository.createIndex(field, false);
        }
        if (this.tracer.debug) {
            this.tracer.log("Flushing Indexed Ordered Plan index for " + field + " on " + repository.getName(), Tracer.Level.DEBUG);
        }
        repository.flushIndexing();
        QueryPlanImpl indexReadPlan = new QueryPlanImpl();
        indexReadPlan.addStep(new QueryPlanImpl.FullIndexRead(field, orderByField.isAscending()));
        Predicate<REC> where = query.getWhere();
        if (where != null) {
            indexReadPlan.addStep(new QueryPlanImpl.FilterImpl(where));
        }
        return indexReadPlan;
    }

    private QueryPlanImpl<ID, REC> aggregate(QueryPlanImpl<ID, REC> plan, QueryImpl<REC> query) {
        this.validateAggregation(query);
        plan.addStep(new QueryPlanImpl.Aggregation(query));
        return plan;
    }

    private void validateAggregation(QueryImpl<REC> query) {
        List<IdxField<REC, ?>> groupBy = query.getGroupBy();
        for (IdxField<REC, ?> field : query.getSelect()) {
            boolean aggregateKey = groupBy.contains(field);
            boolean aggregateField = field instanceof QueryAggregateField;
            if (aggregateKey || aggregateField) continue;
            throw new QueryException("Cannot SELECT field that is not contained in the GROUP BY clause: " + field);
        }
    }

    private IdxRange createRange(FieldPredicate<REC, ?, ?> predicate) {
        UtlRangeBase<Comparable> range;
        Object operator = predicate.getOperator();
        List<?> values = predicate.getValues();
        if (operator.equals(PredicateOperator.LESS_THAN)) {
            Comparable high = (Comparable)values.get(0);
            range = new UtlRangeBase<Comparable>(null, high);
            range.setIncludeEnd(false);
        } else if (operator.equals(PredicateOperator.LESS_THAN_OR_EQUAL)) {
            Comparable high = (Comparable)values.get(0);
            range = new UtlRangeBase<Comparable>(null, high);
            range.setIncludeEnd(true);
        } else if (operator.equals(PredicateOperator.GREATER_THAN)) {
            Comparable low = (Comparable)values.get(0);
            range = new UtlRangeBase<Object>(low, null);
            range.setIncludeStart(false);
        } else if (operator.equals(PredicateOperator.GREATER_THAN_OR_EQUAL)) {
            Comparable low = (Comparable)values.get(0);
            range = new UtlRangeBase<Object>(low, null);
            range.setIncludeStart(true);
        } else if (operator.equals(PredicateOperator.BETWEEN)) {
            Comparable low = (Comparable)values.get(0);
            Comparable high = (Comparable)values.get(1);
            range = new UtlRangeBase<Comparable>(low, high);
            range.setIncludeStart(true);
            range.setIncludeEnd(true);
        } else {
            throw new QueryException("Unrecognized operator: " + operator);
        }
        return range;
    }

    final void setNaturalKeyOrder(Comparator<ID> naturalKeyOrder) {
        this.naturalKeyOrder = naturalKeyOrder;
    }

    private static class BetweenSelectivity
    extends UniformSelectivity {
        private BetweenSelectivity() {
        }

        @Override
        protected double calculateIndexFetchRatio(FieldPredicate<?, ?, ?> predicate, IdxIndex<?, ?> index) {
            IdxIndex.Stats<?> stats = index.getStats();
            Comparable lowKey = (Comparable)stats.getLowKey();
            Comparable highKey = (Comparable)stats.getHighKey();
            FieldPredicate.TernaryFieldPredicate p = (FieldPredicate.TernaryFieldPredicate)predicate;
            Comparable lowPredicateValue = (Comparable)p.getLowValue();
            Comparable highPredicateValue = (Comparable)p.getHighValue();
            double location1 = BetweenSelectivity.uniformLocation(lowKey, highKey, lowPredicateValue);
            double location2 = BetweenSelectivity.uniformLocation(lowKey, highKey, highPredicateValue);
            if (location1 > 1.0 || location2 < 0.0) {
                return 0.0;
            }
            location1 = this.boundFetchRatio(location1);
            location2 = this.boundFetchRatio(location2);
            return location2 - location1;
        }
    }

    private static class GreaterThanSelectivity
    extends UniformSelectivity {
        private GreaterThanSelectivity() {
        }

        @Override
        protected double calculateIndexFetchRatio(FieldPredicate<?, ?, ?> predicate, IdxIndex<?, ?> index) {
            IdxIndex.Stats<?> stats = index.getStats();
            Comparable low = (Comparable)stats.getLowKey();
            Comparable high = (Comparable)stats.getHighKey();
            FieldPredicate.BinaryFieldPredicate p = (FieldPredicate.BinaryFieldPredicate)predicate;
            Comparable value = (Comparable)p.getValue();
            double location = GreaterThanSelectivity.uniformLocation(low, high, value);
            location = this.boundFetchRatio(location);
            return 1.0 - location;
        }
    }

    private static class LessThanSelectivity
    extends UniformSelectivity {
        private LessThanSelectivity() {
        }

        @Override
        protected double calculateIndexFetchRatio(FieldPredicate<?, ?, ?> predicate, IdxIndex<?, ?> index) {
            IdxIndex.Stats<?> stats = index.getStats();
            Comparable low = (Comparable)stats.getLowKey();
            Comparable high = (Comparable)stats.getHighKey();
            FieldPredicate.BinaryFieldPredicate p = (FieldPredicate.BinaryFieldPredicate)predicate;
            Comparable value = (Comparable)p.getValue();
            double location = LessThanSelectivity.uniformLocation(low, high, value);
            location = this.boundFetchRatio(location);
            return location;
        }
    }

    private static abstract class UniformSelectivity
    extends OperatorSelectivity {
        private UniformSelectivity() {
        }

        protected abstract double calculateIndexFetchRatio(FieldPredicate<?, ?, ?> var1, IdxIndex<?, ?> var2);

        @Override
        public final int calculateReadCardinality(FieldPredicate<?, ?, ?> predicate, IdxIndex<?, ?> index) {
            double indexFetchRatio = this.calculateIndexFetchRatio(predicate, index);
            return (int)Math.round((double)index.getStats().getCardinality() * indexFetchRatio);
        }
    }

    private static class DiscreteSelectivity
    extends OperatorSelectivity {
        private DiscreteSelectivity() {
        }

        @Override
        public int calculateReadCardinality(FieldPredicate<?, ?, ?> predicate, IdxIndex<?, ?> index) {
            int valuesPerKey;
            if (index.isUnique()) {
                valuesPerKey = 1;
            } else {
                IdxIndex.Stats<?> stats = index.getStats();
                valuesPerKey = stats.getCardinality() / stats.getKeyCardinality();
            }
            int fetchSize = 0;
            List<?> predicateValues = predicate.getValues();
            if (valuesPerKey <= 500) {
                fetchSize = index.valueCount(predicateValues);
            } else {
                IdxIndex<?, ?> untypedIndex = index;
                for (Object predicateValue : predicateValues) {
                    if (!untypedIndex.containsKey(predicateValue)) continue;
                    fetchSize += valuesPerKey;
                }
            }
            return fetchSize;
        }
    }

    private static class FullIndexSelectivity
    extends OperatorSelectivity {
        private FullIndexSelectivity() {
        }

        @Override
        protected int calculateReadCardinality(FieldPredicate<?, ?, ?> predicate, IdxIndex<?, ?> index) {
            return index.getStats().getCardinality();
        }
    }

    private static class FullScanSelectivity
    extends OperatorSelectivity {
        private FullScanSelectivity() {
        }

        @Override
        public double getFetchRatio(FieldPredicate<?, ?, ?> predicate, IdxIndex<?, ?> index, QueryIndexableRepository<?, ?> repository) {
            return 1.0;
        }

        @Override
        protected int calculateReadCardinality(FieldPredicate<?, ?, ?> predicate, IdxIndex<?, ?> index) {
            return index.getStats().getCardinality();
        }
    }

    public static abstract class OperatorSelectivity {
        protected static final int VALUE_COUNT_THRESHOLD = 500;
        protected static final double BELOW_LOWER_BOUND = -1.0;
        protected static final double ABOVE_UPPER_BOUND = 2.0;
        public static final OperatorSelectivity DISCRETE_SELECTIVITY = new DiscreteSelectivity();
        public static final OperatorSelectivity LESS_THAN_SELECTIVITY = new LessThanSelectivity();
        public static final OperatorSelectivity GREATER_THAN_SELECTIVITY = new GreaterThanSelectivity();
        public static final OperatorSelectivity BETWEEN_SELECTIVITY = new BetweenSelectivity();
        public static final OperatorSelectivity FULL_SCAN_SELECTIVITY = new FullScanSelectivity();
        public static final OperatorSelectivity FULL_INDEX_SELECTIVITY = new FullIndexSelectivity();

        public static <T extends Comparable<T>> double uniformLocation(T low, T high, T value) {
            if (value == null) {
                return 0.0;
            }
            int compareToLow = value.compareTo(low);
            if (compareToLow < 0) {
                return -1.0;
            }
            if (compareToLow == 0) {
                return 0.0;
            }
            int compareToHigh = value.compareTo(high);
            if (compareToHigh > 0) {
                return 2.0;
            }
            if (compareToHigh == 0) {
                return 1.0;
            }
            if (low.equals(high)) {
                return 0.5;
            }
            double lowerBound = 0.0;
            double upperBound = 1.0;
            double location = 0.5;
            T untypedLow = low;
            T untypedHigh = high;
            T untypedValue = value;
            if (untypedValue instanceof Number) {
                lowerBound = ((Number)((Object)untypedLow)).doubleValue();
                upperBound = ((Number)((Object)untypedHigh)).doubleValue();
                location = ((Number)((Object)untypedValue)).doubleValue();
            } else if (untypedValue instanceof Date) {
                lowerBound = ((Date)untypedLow).getTime();
                upperBound = ((Date)untypedHigh).getTime();
                location = ((Date)untypedValue).getTime();
            } else if (untypedValue instanceof String) {
                lowerBound = UtlText.uniformMetric((String)untypedLow.toString());
                upperBound = UtlText.uniformMetric((String)untypedHigh.toString());
                location = UtlText.uniformMetric((String)untypedValue.toString());
            } else if (untypedValue instanceof Enum) {
                lowerBound = ((Enum)((Object)untypedLow)).ordinal();
                upperBound = ((Enum)((Object)untypedHigh)).ordinal();
                location = ((Enum)((Object)untypedValue)).ordinal();
            } else {
                return 0.5;
            }
            return (location - lowerBound) / (upperBound - lowerBound);
        }

        protected double boundFetchRatio(double ratio) {
            double bounded = Math.max(0.0, ratio);
            bounded = Math.min(1.0, bounded);
            return bounded;
        }

        public double getFetchRatio(FieldPredicate<?, ?, ?> predicate, IdxIndex<?, ?> index, QueryIndexableRepository<?, ?> repository) {
            if (index.getStats().getCardinality() == 0) {
                return 0.0;
            }
            return this.calculateFetchRatio(predicate, index, repository);
        }

        protected abstract int calculateReadCardinality(FieldPredicate<?, ?, ?> var1, IdxIndex<?, ?> var2);

        protected double calculateFetchRatio(FieldPredicate<?, ?, ?> predicate, IdxIndex<?, ?> index, QueryIndexableRepository<?, ?> repository) {
            int readCardinality = this.calculateReadCardinality(predicate, index);
            return (double)readCardinality / (double)repository.getSize();
        }
    }

    private static final class FilterCostComparator
    implements Comparator<QueryPlanImpl.Filter<?>> {
        private FilterCostComparator() {
        }

        @Override
        public int compare(QueryPlanImpl.Filter<?> filter1, QueryPlanImpl.Filter<?> filter2) {
            Predicate predicate1 = filter1.getPredicate();
            Predicate predicate2 = filter2.getPredicate();
            return PredicateBase.COST_COMPARATOR.compare(predicate1, predicate2);
        }
    }
}

