/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods.test.unit;

import com.neeve.ods.IStoreEvent;
import com.neeve.ods.IStoreEventHandler;
import com.neeve.ods.OdsException;
import com.neeve.ods.StoreBinding;
import com.neeve.ods.StoreBindingFactory;
import com.neeve.ods.StoreDescriptor;
import com.neeve.ods.impl.StoreBindingImpl;
import com.neeve.test.UnitTest;
import org.junit.Assert;
import org.junit.Test;

public final class StoreBindingFactoryTest
extends UnitTest {
    @Test
    public void testGetInstanceIsNonNull() {
        Assert.assertNotNull((Object)((Object)StoreBindingFactory.getInstance()));
    }

    @Test
    public void testGetInstanceAlwaysReturnsSameFactoryInstance() {
        StoreBindingFactory factory = StoreBindingFactory.getInstance();
        Assert.assertEquals((Object)((Object)factory), (Object)((Object)StoreBindingFactory.getInstance()));
    }

    @Test
    public void testCreateBindingWithoutCoreFlag() throws Exception {
        Assert.assertTrue((boolean)(StoreBindingFactory.getInstance().createBinding("m1", StoreDescriptor.create("store"), (IStoreEventHandler)new EmptyEventHandler()) instanceof StoreBinding));
    }

    @Test
    public void testCreateBindingWithCoreFlag() throws Exception {
        Assert.assertTrue((boolean)(StoreBindingFactory.getInstance().createBinding("m1", StoreDescriptor.create("store"), (IStoreEventHandler)new EmptyEventHandler(), 2) instanceof StoreBindingImpl));
    }

    @Test
    public void testCreateBindingWithNullMemberName() throws Exception {
        StoreBindingFactory.getInstance().createBinding(null, StoreDescriptor.create("store"), null).close(0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateBindingWithNullDescriptor() throws Exception {
        StoreBindingFactory.getInstance().createBinding("m1", (StoreDescriptor)null, (IStoreEventHandler)new EmptyEventHandler());
    }

    @Test
    public void testCreateBindingWithNullEventHandler() throws Exception {
        StoreBindingFactory.getInstance().createBinding("m1", StoreDescriptor.create("store"), null).close(0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateBindingWithNullStoreName() throws Exception {
        StoreBindingFactory.getInstance().createBinding("m1", (String)null, (IStoreEventHandler)new EmptyEventHandler());
    }

    @Test(expected=OdsException.class)
    public void testCreateBindingWithInvalidStoreName() throws Exception {
        StoreBindingFactory.getInstance().createBinding("m1", "nonexistentStore", (IStoreEventHandler)new EmptyEventHandler());
    }

    private final class EmptyEventHandler
    implements IStoreEventHandler {
        private EmptyEventHandler() {
        }

        @Override
        public final void onEvent(IStoreEvent event) {
        }
    }
}

