/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm.test.unit;

import com.neeve.adm.AdmEncodingType;
import com.neeve.adm.AdmEntity;
import com.neeve.adm.AdmField;
import com.neeve.adm.AdmMessage;
import com.neeve.adm.AdmModel;
import com.neeve.adm.AdmXMLParser;
import com.neeve.adm.test.unit.evo.v1.json.EvoEntity;
import com.neeve.adm.test.unit.evo.v2.proto.CharEnumeration;
import com.neeve.adm.test.unit.evo.v2.xbuf.EvoMessage;
import com.neeve.adm.test.unit.json.Child1;
import com.neeve.adm.test.unit.json.Child2;
import com.neeve.adm.test.unit.json.Child3;
import com.neeve.adm.test.unit.proto.ChildQueue;
import com.neeve.adm.test.unit.proto.Factory;
import com.neeve.adm.test.unit.proto.IChild2;
import com.neeve.adm.test.unit.proto.IChild3;
import com.neeve.adm.test.unit.proto.IMessage;
import com.neeve.adm.test.unit.proto.Message;
import com.neeve.adm.test.unit.proto.Model;
import com.neeve.adm.test.unit.proto.SocialSecurityNumber;
import com.neeve.adm.test.unit.xbuf.BackingBufferSizeTestEntity;
import com.neeve.adm.test.unit.xbuf.Enumeration;
import com.neeve.adm.types.protobuf.AdmTypes;
import com.neeve.ci.XRuntime;
import com.neeve.io.IOBuffer;
import com.neeve.lang.XByteIterator;
import com.neeve.lang.XFactory;
import com.neeve.lang.XIterator;
import com.neeve.lang.XString;
import com.neeve.ods.StoreObjectFactoryRegistry;
import com.neeve.query.impl.util.UtlQueryReflection;
import com.neeve.rog.impl.RogNode;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.MessageReflector;
import com.neeve.sma.MessageView;
import com.neeve.sma.SmaException;
import com.neeve.sma.impl.DefaultMessageChannelKeyResolver;
import com.neeve.test.UnitTest;
import com.neeve.util.UtlObjectGraph;
import com.neeve.util.UtlReflection;
import com.neeve.util.UtlText;
import com.neeve.util.UtlThrowable;
import com.neeve.util.UtlTime;
import java.lang.constant.Constable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Random;
import java.util.Stack;
import junit.framework.AssertionFailedError;
import org.junit.Assert;
import org.junit.Test;

public final class AdmGeneratedCodeTest
extends UnitTest {
    private UtlObjectGraph.ComparatorFactory nullAndEmptyArraysEquivalentComparator = new UtlObjectGraph.ComparatorFactory(){

        public boolean treatEmptyAndNullArraysAsSame() {
            return true;
        }

        public Comparator<?> getComparator(Class<?> clazz, Stack<String> getterStack) {
            return null;
        }
    };

    @Test
    public void testEnumValueOptions() {
        Assert.assertEquals((Object)"char", (Object)Model.CharEnumeration.getDescriptor().getOptions().getExtension(AdmTypes.enumType));
        Assert.assertEquals((Object)"0", (Object)Model.CharEnumeration.CharEnumeration_Value1.getValueDescriptor().getOptions().getExtension(AdmTypes.stringvalue));
        Assert.assertEquals((Object)"int", (Object)Model.IntEnumeration.getDescriptor().getOptions().getExtension(AdmTypes.enumType));
        Assert.assertEquals((Object)"", (Object)Model.IntEnumeration.IntEnumeration_Value1.getValueDescriptor().getOptions().getExtension(AdmTypes.stringvalue));
        Assert.assertEquals((Object)"string", (Object)Model.StringEnumeration.getDescriptor().getOptions().getExtension(AdmTypes.enumType));
        Assert.assertEquals((Object)"zero", (Object)Model.StringEnumeration.StringEnumeration_Value1.getValueDescriptor().getOptions().getExtension(AdmTypes.stringvalue));
    }

    public static final <T> void compare(char[] array1, char[] array2, boolean same) {
        if (array1 == null) {
            Assert.assertNull((Object)array2);
        } else if (same) {
            Assert.assertSame((Object)array1, (Object)array2);
        } else {
            Assert.assertNotNull((Object)array2);
            Assert.assertEquals((String)(array1.getClass().getComponentType().getSimpleName() + " array lengths differ"), (long)array1.length, (long)array2.length);
            for (int i = 0; i < array1.length; ++i) {
                Assert.assertEquals((long)array1[i], (long)array2[i]);
            }
        }
    }

    public static final <T> void compare(T[] array1, T[] array2, boolean same) {
        if (array1 == null) {
            Assert.assertNull(array2);
        } else if (same) {
            Assert.assertSame(array1, array2);
        } else {
            Assert.assertNotNull(array2);
            Assert.assertEquals((String)(array1.getClass().getComponentType().getSimpleName() + " array lengths differ"), (long)array1.length, (long)array2.length);
            for (int i = 0; i < array1.length; ++i) {
                Assert.assertEquals(array1[i], array2[i]);
            }
        }
    }

    @Test
    public void testPooledStringFactory() {
        SocialSecurityNumber ssn;
        int i;
        HashMap<String, Constable> props = new HashMap<String, Constable>();
        props.put("initialLength", Integer.valueOf(64));
        props.put("isNative", Boolean.valueOf(true));
        props.put("pool.enabled", Boolean.valueOf(true));
        props.put("pool.preallocateCount", Integer.valueOf(1000));
        props.put("pool.threaded", Boolean.valueOf(false));
        XString.Factory ssnFactory = XFactory.createXPooledStringFactory(SocialSecurityNumber.class, (String)"TestFactory", props);
        for (i = 0; i < 1000; ++i) {
            ssn = (SocialSecurityNumber)ssnFactory.create("555-555-5555", false);
            Assert.assertEquals((String)("Shouldn't have a pool miss on get #" + i + " when preallocated with 1000"), (long)0L, (long)ssn.getPool().stats().misses());
            Assert.assertEquals((String)"Should have a backing buffer that is 64 bytes in size", (long)64L, (long)ssn.getBackingBuffer().getIOBuffer().getCapacity());
            Assert.assertEquals((String)"Should have a native buffer that is native", (Object)true, (Object)ssn.getBackingBuffer().getIOBuffer().isNative());
        }
        for (i = 0; i < 1; ++i) {
            ssn = (SocialSecurityNumber)ssnFactory.create("555-555-5555", false);
            Assert.assertEquals((String)("Shouldn have a pool miss on get #" + i + " when preallocated with 1000"), (long)1L, (long)ssn.getPool().stats().misses());
        }
        SocialSecurityNumber ssn2 = (SocialSecurityNumber)ssnFactory.create("555-555-5556", false);
        com.neeve.adm.test.unit.xbuf.Message message = com.neeve.adm.test.unit.xbuf.Message.create();
        message.setPooledStringFieldFrom((XString)ssn2);
        SocialSecurityNumber ssn22 = message.getPooledStringFieldTo(ssnFactory, ssn2);
        Assert.assertFalse((String)"Should have taken pooled string from factory", (ssn22 == ssn2 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Should have taken pooled string from factory", (Object)"555-555-5556", (Object)ssn22.getValue());
    }

    @Test
    public void testMessageReflectionProtobuf() throws Throwable {
        Message message = Message.create();
        com.neeve.adm.test.unit.proto.Child2 child2 = com.neeve.adm.test.unit.proto.Child2.create();
        com.neeve.adm.test.unit.proto.Child3 child3 = com.neeve.adm.test.unit.proto.Child3.create();
        UtlObjectGraph.populateObject((Object)message, (Class[])new Class[]{IMessage.class});
        UtlObjectGraph.populateObject((Object)child2, (Class[])new Class[]{IChild2.class});
        UtlObjectGraph.populateObject((Object)child3, (Class[])new Class[]{IChild3.class});
        message.setChildField(child2);
        child2.setChildField(child3);
        AdmModel model = this.loadTestModel(AdmEncodingType.Protobuf);
        AdmMessage messageModel = model.getMessage("Message");
        this.testFieldReflection(message.getMessageReflector(), message, (AdmEntity)messageModel, message, null);
    }

    @Test
    public void testMessageReflectionJson() throws Throwable {
        com.neeve.adm.test.unit.json.Message message = com.neeve.adm.test.unit.json.Message.create();
        MessageReflector reflector = message.getMessageReflector();
        if (reflector == null) {
            return;
        }
        Child2 child2 = Child2.create();
        Child3 child3 = Child3.create();
        UtlObjectGraph.populateObject((Object)child2, (Class[])new Class[]{com.neeve.adm.test.unit.json.IChild2.class});
        UtlObjectGraph.populateObject((Object)child3, (Class[])new Class[]{com.neeve.adm.test.unit.json.IChild3.class});
        message.setChildField(child2);
        child2.setChildField(child3);
        AdmModel model = this.loadTestModel(AdmEncodingType.Json);
        AdmMessage messageModel = model.getMessage("Message");
        this.testFieldReflection(reflector, message, (AdmEntity)messageModel, message, null);
    }

    @Test
    public void testMessageReflectionXbuf() throws Throwable {
        com.neeve.adm.test.unit.xbuf.Message message = com.neeve.adm.test.unit.xbuf.Message.create();
        com.neeve.adm.test.unit.xbuf.Child2 child2 = com.neeve.adm.test.unit.xbuf.Child2.create();
        com.neeve.adm.test.unit.xbuf.Child3 child3 = com.neeve.adm.test.unit.xbuf.Child3.create();
        UtlObjectGraph.populateObject((Object)message, (Class[])new Class[]{com.neeve.adm.test.unit.xbuf.IMessage.class});
        UtlObjectGraph.populateObject((Object)child2, (Class[])new Class[]{com.neeve.adm.test.unit.xbuf.IChild2.class});
        UtlObjectGraph.populateObject((Object)child3, (Class[])new Class[]{com.neeve.adm.test.unit.xbuf.IChild3.class});
        message.setChildField(child2);
        child2.setChildField(child3);
        AdmModel model = this.loadTestModel(AdmEncodingType.Xbuf);
        AdmMessage messageModel = model.getMessage("Message");
        this.testFieldReflection(message.getMessageReflector(), message, (AdmEntity)messageModel, message, null);
    }

    private void testFieldReflection(MessageReflector reflector, MessageView message, AdmEntity entityModel, Object targetObject, String targetObjectPath) throws Throwable {
        for (AdmField field : entityModel.fields().values()) {
            String fieldPath;
            String string = fieldPath = targetObjectPath == null ? UtlText.toFirstLetterUppercase((String)field.getName()) : targetObjectPath + "." + UtlText.toFirstLetterUppercase((String)field.getName());
            if (field.getType() instanceof AdmEntity) {
                Object nestedEntity = UtlQueryReflection.getGetter(targetObject.getClass(), (String)field.getName()).invoke(targetObject, new Object[0]);
                this.testFieldReflection(reflector, message, (AdmEntity)field.getType(), nestedEntity, fieldPath);
                continue;
            }
            if (!reflector.isFieldReflectable((Object)reflector, fieldPath) || !reflector.fieldExists((Object)message, fieldPath)) continue;
            Method accessor = UtlQueryReflection.getGetter(targetObject.getClass(), (String)field.getName());
            Object expectedObject = accessor.invoke(targetObject, new Object[0]);
            String expected = expectedObject == null ? null : expectedObject.toString();
            String actual = reflector.getFieldValueAsString((Object)message, fieldPath);
            System.out.println("Testing field reflection for '" + fieldPath + "' (a " + field.getType().getJavaTypeName() + ") expecting ... " + expected);
            try {
                if (expected == null && actual == null) continue;
                Assert.assertEquals((String)("Message reflector returned unexpected value for '" + fieldPath + "'"), (Object)expected, (Object)actual);
            }
            catch (Throwable e) {
                reflector.getFieldValueAsString((Object)message, fieldPath);
                throw e;
            }
            MessageBusDescriptor busDescriptor = MessageBusDescriptor.create((String)"testBus");
            MessageChannelDescriptor channelDescriptor = MessageChannelDescriptor.create((String)"test", (MessageBusDescriptor)busDescriptor);
            channelDescriptor.setChannelKey("TEST/${" + fieldPath + "}");
            DefaultMessageChannelKeyResolver keyResolver = DefaultMessageChannelKeyResolver.create((MessageChannelDescriptor)channelDescriptor);
            XString resolvedKey = XString.create((int)256, (boolean)true);
            boolean isFieldSet = UtlReflection.getHasPropertyCheckerValue((Object)message, (String)fieldPath);
            try {
                resolvedKey = keyResolver.resolveMessageKey(resolvedKey, message, null);
                if (!isFieldSet) {
                    Assert.fail((String)("Should not have been able to resolve message key for '" + fieldPath + "' with a value of '" + expected + "'"));
                }
                Assert.assertEquals((String)("Channel key resolution reflector returned unexpected value for '" + fieldPath + "'"), (Object)("TEST/" + expected), (Object)resolvedKey.getValue());
            }
            catch (SmaException e) {
                if (!isFieldSet) continue;
                if (e.getMessage().indexOf("is not an ascii character") >= 0) {
                    e.printStackTrace();
                    continue;
                }
                Assert.fail((String)("Error resolving channel key that should have been resolvable for '" + fieldPath + "' with a value of '" + expected + "', got: " + UtlThrowable.prepareStackTrace((Throwable)e)));
            }
        }
    }

    @Test
    public void testZGChannelKeyResolutionXbuf() throws Throwable {
        com.neeve.adm.test.unit.xbuf.Message message = com.neeve.adm.test.unit.xbuf.Message.create();
        message.setIntField(-18000);
        message.setLongField(250000L);
        message.setStringField("AStringFieldValue");
        message.setPooledStringField("PooledStringFieldValue");
        message.setEnumField(Enumeration.Value2);
        message.setShortField((short)15000);
        message.setByteField((byte)-16);
        message.setCharField('Z');
        String expected = message.getIntField() + "/" + message.getLongField() + "/" + message.getStringField() + "/" + message.getPooledStringField() + "/" + (Object)((Object)message.getEnumField()) + "/" + message.getShortField() + "/" + message.getByteField() + "/" + message.getCharField();
        this.testKeyBuilder(message, "${IntField}/${LongField}/${StringField}/${PooledStringField}/${EnumField}/${shortField}/${ByteField}/${charField}", expected);
    }

    private void testKeyBuilder(MessageView message, String key, String expected) throws Throwable {
        MessageBusDescriptor busDescriptor = MessageBusDescriptor.create((String)"testBus");
        MessageChannelDescriptor channelDescriptor = MessageChannelDescriptor.create((String)"test", (MessageBusDescriptor)busDescriptor);
        channelDescriptor.setChannelKey(key);
        DefaultMessageChannelKeyResolver keyResolver = DefaultMessageChannelKeyResolver.create((MessageChannelDescriptor)channelDescriptor);
        XString resolvedKey = XString.create((int)256, (boolean)true);
        for (int i = 0; i < 100; ++i) {
            resolvedKey.clear();
            resolvedKey = keyResolver.resolveMessageKey(resolvedKey, message, null);
        }
        Assert.assertEquals((String)"Didn't get expected resolved key", (Object)expected, (Object)resolvedKey.getValue());
    }

    private AdmModel loadTestModel(AdmEncodingType encoding) throws Exception {
        String nsSuffix = encoding.toString().toLowerCase();
        if (encoding == AdmEncodingType.Protobuf) {
            nsSuffix = "proto";
        }
        return AdmXMLParser.parse((URL)((Object)((Object)this)).getClass().getResource("/com/neeve/adm/test/unit/" + nsSuffix + "/model.xml"), (String)"com.neeve.adm.test.unit");
    }

    @Test
    public void testArraysXbufMessage() throws Throwable {
        this.verifyArrayAccessors(com.neeve.adm.test.unit.xbuf.Message.create(), false);
    }

    @Test
    public void testArraysXbufEntity() throws Throwable {
        this.verifyArrayAccessors(com.neeve.adm.test.unit.xbuf.Child1.create(), false);
    }

    @Test
    public void testArraysXbufEmbeddedEntity() throws Throwable {
        this.verifyArrayAccessors(com.neeve.adm.test.unit.xbuf.Child2.create(), false);
    }

    @Test
    public void testArraysJsonMessage() throws Throwable {
        this.verifyArrayAccessors(com.neeve.adm.test.unit.json.Message.create(), false);
    }

    @Test
    public void testArraysJsonEntity() throws Throwable {
        this.verifyArrayAccessors(Child1.create(), false);
    }

    @Test
    public void testArraysJsonEmbeddedEntity() throws Throwable {
        this.verifyArrayAccessors(Child2.create(), false);
    }

    @Test
    public void testArraysProtobufMessage() throws Throwable {
        this.verifyArrayAccessors(Message.create(), false);
    }

    @Test
    public void testArraysProtoEntity() throws Throwable {
        this.verifyArrayAccessors(com.neeve.adm.test.unit.proto.Child1.create(), false);
    }

    @Test
    public void testArraysProtobufEmbeddedEntity() throws Throwable {
        this.verifyArrayAccessors(com.neeve.adm.test.unit.proto.Child2.create(), false);
    }

    @Test
    public void testArraysXbufMessageGeneratedEmptyIfNull() throws Throwable {
        this.verifyArrayAccessors(com.neeve.adm.test.unit.style2.xbuf.Message.create(), true);
    }

    @Test
    public void testArraysXbufEntityGeneratedEmptyIfNull() throws Throwable {
        this.verifyArrayAccessors(com.neeve.adm.test.unit.style2.xbuf.Child1.create(), true);
    }

    @Test
    public void testArraysXbufEmbeddedEntityGeneratedEmptyIfNull() throws Throwable {
        this.verifyArrayAccessors(com.neeve.adm.test.unit.style2.xbuf.Child2.create(), true);
    }

    @Test
    public void testArraysJsonMessageGeneratedEmptyIfNull() throws Throwable {
        this.verifyArrayAccessors(com.neeve.adm.test.unit.style2.json.Message.create(), true);
    }

    @Test
    public void testArraysJsonEntityGeneratedEmptyIfNull() throws Throwable {
        this.verifyArrayAccessors(com.neeve.adm.test.unit.style2.json.Child1.create(), true);
    }

    @Test
    public void testArraysJsonEmbeddedEntityGeneratedEmptyIfNull() throws Throwable {
        this.verifyArrayAccessors(com.neeve.adm.test.unit.style2.json.Child2.create(), true);
    }

    @Test
    public void testArraysProtobufMessageGeneratedEmptyIfNull() throws Throwable {
        this.verifyArrayAccessors(com.neeve.adm.test.unit.style2.proto.Message.create(), true);
    }

    @Test
    public void testArraysProtoEntityGeneratedEmptyIfNull() throws Throwable {
        this.verifyArrayAccessors(com.neeve.adm.test.unit.style2.proto.Child1.create(), true);
    }

    @Test
    public void testArraysProtobufEmbeddedEntityGeneratedEmptyIfNull() throws Throwable {
        this.verifyArrayAccessors(com.neeve.adm.test.unit.style2.proto.Child2.create(), true);
    }

    private void verifyArrayAccessors(Object object, boolean generatedArrayEmptyIfNull) throws Throwable {
        for (int i = 1; i <= 2; ++i) {
            for (String field : UtlReflection.getDecamelcasedProperties(object.getClass())) {
                if (!UtlReflection.getUnwrappedReturnType(object.getClass(), (String)field).isArray()) continue;
                if (AdmGeneratedCodeTest.verbose()) {
                    System.out.println("Testing: " + field);
                }
                Method getter = object.getClass().getMethod("get" + UtlText.toFirstLetterUppercase((String)field), new Class[0]);
                if (generatedArrayEmptyIfNull) {
                    Object value = getter.invoke(object, new Object[0]);
                    Assert.assertNotNull((String)(field + " should not be null from call " + i + " of " + object.getClass().getName() + "." + getter.getName() + "()"), (Object)value);
                    Assert.assertEquals((String)(field + " should be zero length from call " + i + " of " + getter.getName() + "()"), (long)0L, (long)Array.getLength(value));
                } else {
                    Assert.assertNull((String)(field + " should be null from call " + i + " of " + getter.getName() + "()"), (Object)getter.invoke(object, new Object[0]));
                }
                Method getterEmptyIfNull = object.getClass().getMethod("get" + UtlText.toFirstLetterUppercase((String)field) + "EmptyIfNull", new Class[0]);
                Object value = getterEmptyIfNull.invoke(object, new Object[0]);
                Assert.assertNotNull((String)(field + " should not be null from call " + i + " of " + object.getClass().getName() + "." + getterEmptyIfNull.getName() + "()"), (Object)value);
                Assert.assertEquals((String)(field + " should be zero length from call " + i + " of " + getterEmptyIfNull.getName() + "()"), (long)0L, (long)Array.getLength(value));
                Method iteratorAccessor = object.getClass().getMethod("get" + UtlText.toFirstLetterUppercase((String)field) + "Iterator", new Class[0]);
                Object iterator = iteratorAccessor.invoke(object, new Object[0]);
                Assert.assertNotNull((Object)"XIterator should not be null");
                Method hasNextMethod = iterator.getClass().getMethod("hasNext", new Class[0]);
                hasNextMethod.setAccessible(true);
                Object ret = hasNextMethod.invoke(iterator, new Object[0]);
                Assert.assertEquals((String)("Wrong value from call " + i + " of " + iteratorAccessor + "." + hasNextMethod.getName()), (Object)Boolean.FALSE, (Object)ret);
                Method nextMethod = iterator.getClass().getMethod("next", new Class[0]);
                nextMethod.setAccessible(true);
                try {
                    nextMethod.invoke(iterator, new Object[0]);
                }
                catch (InvocationTargetException ire) {
                    Assert.assertEquals((String)("Wrong exception from call " + i + " of " + iteratorAccessor + "." + nextMethod.getName()), NoSuchElementException.class, ire.getTargetException().getClass());
                }
            }
        }
    }

    @Test
    public void testNewEnumValueBackwardsCompatibilityProto() {
        com.neeve.adm.test.unit.evo.v2.proto.EvoMessage v2 = com.neeve.adm.test.unit.evo.v2.proto.EvoMessage.create();
        v2.setCharEnumField(CharEnumeration.NewValue);
        com.neeve.adm.test.unit.evo.v1.proto.EvoMessage v1 = com.neeve.adm.test.unit.evo.v1.proto.EvoMessage.createFrom(v2.serializeToByteArray());
        Assert.assertNull((String)"Unrecognized enum value should be treated as null", (Object)((Object)v1.getCharEnumField()));
        Assert.assertFalse((String)"Unrecognized enum value should result in hasField being flase", (boolean)v1.hasCharEnumField());
        v2 = com.neeve.adm.test.unit.evo.v2.proto.EvoMessage.createFrom(v1.serializeToByteArray());
        Assert.assertEquals((String)"Unrecognized enum value should be passed through", (Object)((Object)CharEnumeration.NewValue), (Object)((Object)v2.getCharEnumField()));
        Assert.assertTrue((String)"Unrecognized enum value should result in hasField being flase", (boolean)v2.hasCharEnumField());
    }

    @Test
    public void testNewEnumValueBackwardsCompatibilityXbuf() {
        EvoMessage v2 = EvoMessage.create();
        v2.setCharEnumField(com.neeve.adm.test.unit.evo.v2.xbuf.CharEnumeration.NewValue);
        com.neeve.adm.test.unit.evo.v1.xbuf.EvoMessage v1 = com.neeve.adm.test.unit.evo.v1.xbuf.EvoMessage.createFrom(v2.serializeToByteArray());
        Assert.assertNull((String)"Unrecognized enum value should be treated as null", (Object)((Object)v1.getCharEnumField()));
        Assert.assertFalse((String)"Unrecognized enum value should result in hasField being flase", (boolean)v1.hasCharEnumField());
        v2 = EvoMessage.createFrom(v1.serializeToByteArray());
        Assert.assertEquals((String)"Unrecognized enum value should be passed through", (Object)((Object)com.neeve.adm.test.unit.evo.v2.xbuf.CharEnumeration.NewValue), (Object)((Object)v2.getCharEnumField()));
        Assert.assertTrue((String)"Unrecognized enum value should result in hasField being flase", (boolean)v2.hasCharEnumField());
    }

    @Test
    public void testNewEnumValueBackwardsCompatibilityJson() {
        com.neeve.adm.test.unit.evo.v2.json.EvoMessage v2 = com.neeve.adm.test.unit.evo.v2.json.EvoMessage.create();
        v2.setCharEnumField(com.neeve.adm.test.unit.evo.v2.json.CharEnumeration.NewValue);
        com.neeve.adm.test.unit.evo.v1.json.EvoMessage v1 = com.neeve.adm.test.unit.evo.v1.json.EvoMessage.createFrom(v2.serializeToByteArray());
        Assert.assertNull((String)"Unrecognized enum value should be treated as null", (Object)((Object)v1.getCharEnumField()));
        Assert.assertTrue((String)"Unrecognized enum value should result in hasField being flase", (boolean)v1.hasCharEnumField());
        v2 = com.neeve.adm.test.unit.evo.v2.json.EvoMessage.createFrom(v1.serializeToByteArray());
        Assert.assertEquals((String)"Unrecognized enum value should not be passed through", null, (Object)((Object)v2.getCharEnumField()));
        Assert.assertTrue((String)"Unrecognized enum value should result in hasField being flase", (boolean)v2.hasCharEnumField());
    }

    @Test
    public void testNewEnumValueArrayBackwardsCompatibilityProto() {
        com.neeve.adm.test.unit.evo.v2.proto.EvoMessage v2 = com.neeve.adm.test.unit.evo.v2.proto.EvoMessage.create();
        v2.addCharEnumArrayField(CharEnumeration.NewValue);
        v2.addCharEnumArrayField(CharEnumeration.Value1);
        com.neeve.adm.test.unit.evo.v1.proto.EvoMessage v1 = com.neeve.adm.test.unit.evo.v1.proto.EvoMessage.createFrom(v2.serializeToByteArray());
        Assert.assertEquals((String)"Wrong arrays size, expected unrecognized enum array value to be ignored", (long)1L, (long)v1.getCharEnumArrayFieldEmptyIfNull().length);
        Assert.assertEquals((String)"Wrong array value", (Object)((Object)com.neeve.adm.test.unit.evo.v1.proto.CharEnumeration.Value1), (Object)((Object)v1.getCharEnumArrayFieldEmptyIfNull()[0]));
        v2 = com.neeve.adm.test.unit.evo.v2.proto.EvoMessage.createFrom(v1.serializeToByteArray());
        Assert.assertEquals((String)"Wrong arrays size, expected unrecognized enum array value to passed through", (long)2L, (long)v2.getCharEnumArrayFieldEmptyIfNull().length);
        Assert.assertEquals((String)"Wrong array value", (Object)((Object)CharEnumeration.Value1), (Object)((Object)v2.getCharEnumArrayFieldEmptyIfNull()[0]));
        Assert.assertEquals((String)"Wrong array value", (Object)((Object)CharEnumeration.NewValue), (Object)((Object)v2.getCharEnumArrayFieldEmptyIfNull()[1]));
        v1 = com.neeve.adm.test.unit.evo.v1.proto.EvoMessage.createFromJson(v2.serializeToJson());
        Assert.assertEquals((String)"Wrong arrays size, expected unrecognized enum array value to be ignored", (long)2L, (long)v1.getCharEnumArrayFieldEmptyIfNull().length);
        Assert.assertEquals((String)"Wrong array value", (Object)((Object)com.neeve.adm.test.unit.evo.v1.proto.CharEnumeration.Value1), (Object)((Object)v1.getCharEnumArrayFieldEmptyIfNull()[0]));
        Assert.assertEquals((String)"Wrong array value", null, (Object)((Object)v1.getCharEnumArrayFieldEmptyIfNull()[1]));
    }

    @Test
    public void testNewEnumValueArrayBackwardsCompatibilityXbuf() {
        EvoMessage v2 = EvoMessage.create();
        v2.addCharEnumArrayField(com.neeve.adm.test.unit.evo.v2.xbuf.CharEnumeration.NewValue);
        v2.addCharEnumArrayField(com.neeve.adm.test.unit.evo.v2.xbuf.CharEnumeration.Value1);
        com.neeve.adm.test.unit.evo.v1.xbuf.EvoMessage v1 = com.neeve.adm.test.unit.evo.v1.xbuf.EvoMessage.createFrom(v2.serializeToByteArray());
        Assert.assertEquals((String)"Wrong arrays size, expected unrecognized enum array value to be ignored", (long)1L, (long)v1.getCharEnumArrayFieldEmptyIfNull().length);
        Assert.assertEquals((String)"Wrong array value", (Object)((Object)com.neeve.adm.test.unit.evo.v1.xbuf.CharEnumeration.Value1), (Object)((Object)v1.getCharEnumArrayFieldEmptyIfNull()[0]));
        v2 = EvoMessage.createFrom(v1.serializeToByteArray());
        Assert.assertEquals((String)"Wrong arrays size, expected unrecognized enum array value to passed through", (long)2L, (long)v2.getCharEnumArrayFieldEmptyIfNull().length);
        Assert.assertEquals((String)"Wrong array value", (Object)((Object)com.neeve.adm.test.unit.evo.v2.xbuf.CharEnumeration.NewValue), (Object)((Object)v2.getCharEnumArrayFieldEmptyIfNull()[0]));
        Assert.assertEquals((String)"Wrong array value", (Object)((Object)com.neeve.adm.test.unit.evo.v2.xbuf.CharEnumeration.Value1), (Object)((Object)v2.getCharEnumArrayFieldEmptyIfNull()[1]));
        v1 = com.neeve.adm.test.unit.evo.v1.xbuf.EvoMessage.createFromJson(v2.serializeToJson());
        Assert.assertEquals((String)"Wrong arrays size, expected unrecognized enum array value to be ignored", (long)1L, (long)v1.getCharEnumArrayFieldEmptyIfNull().length);
        Assert.assertEquals((String)"Wrong array value", (Object)((Object)com.neeve.adm.test.unit.evo.v1.xbuf.CharEnumeration.Value1), (Object)((Object)v1.getCharEnumArrayFieldEmptyIfNull()[0]));
    }

    @Test
    public void testNewEnumValueArrayBackwardsCompatibilityJson() {
        com.neeve.adm.test.unit.evo.v2.json.EvoMessage v2 = com.neeve.adm.test.unit.evo.v2.json.EvoMessage.create();
        v2.addCharEnumArrayField(com.neeve.adm.test.unit.evo.v2.json.CharEnumeration.NewValue);
        v2.addCharEnumArrayField(com.neeve.adm.test.unit.evo.v2.json.CharEnumeration.Value1);
        com.neeve.adm.test.unit.evo.v1.json.EvoMessage v1 = com.neeve.adm.test.unit.evo.v1.json.EvoMessage.createFrom(v2.serializeToByteArray());
        Assert.assertEquals((String)"Wrong arrays size, expected unrecognized enum array value to be ignored", (long)2L, (long)v1.getCharEnumArrayFieldEmptyIfNull().length);
        Assert.assertEquals((String)"Wrong array value", null, (Object)((Object)v1.getCharEnumArrayFieldEmptyIfNull()[0]));
        Assert.assertEquals((String)"Wrong array value", (Object)((Object)com.neeve.adm.test.unit.evo.v1.json.CharEnumeration.Value1), (Object)((Object)v1.getCharEnumArrayFieldEmptyIfNull()[1]));
        v2 = com.neeve.adm.test.unit.evo.v2.json.EvoMessage.createFrom(v1.serializeToByteArray());
        Assert.assertEquals((String)"Wrong arrays size, expected unrecognized enum array value to passed through", (long)2L, (long)v2.getCharEnumArrayFieldEmptyIfNull().length);
        Assert.assertEquals((String)"Wrong array value", null, (Object)((Object)v2.getCharEnumArrayFieldEmptyIfNull()[0]));
        Assert.assertEquals((String)"Wrong array value", (Object)((Object)com.neeve.adm.test.unit.evo.v2.json.CharEnumeration.Value1), (Object)((Object)v2.getCharEnumArrayFieldEmptyIfNull()[1]));
    }

    @Test
    public void testNewEmbeddedEnumValueBackwardsCompatibilityProto() {
        com.neeve.adm.test.unit.evo.v2.proto.EvoMessage v2 = com.neeve.adm.test.unit.evo.v2.proto.EvoMessage.create();
        v2.setChildField(com.neeve.adm.test.unit.evo.v2.proto.EvoEntity.create());
        v2.getChildField().setCharEnumField(CharEnumeration.NewValue);
        com.neeve.adm.test.unit.evo.v1.proto.EvoMessage v1 = com.neeve.adm.test.unit.evo.v1.proto.EvoMessage.createFrom(v2.serializeToByteArray());
        Assert.assertNull((String)"Unrecognized enum value should be treated as null", (Object)((Object)v1.getChildField().getCharEnumField()));
        Assert.assertFalse((String)"Unrecognized enum value should result in hasField being flase", (boolean)v1.getChildField().hasCharEnumField());
        v2 = com.neeve.adm.test.unit.evo.v2.proto.EvoMessage.createFrom(v1.serializeToByteArray());
        Assert.assertEquals((String)"Unrecognized enum value should be passed through", (Object)((Object)CharEnumeration.NewValue), (Object)((Object)v2.getChildField().getCharEnumField()));
        Assert.assertTrue((String)"Unrecognized enum value should result in hasField being flase", (boolean)v2.getChildField().hasCharEnumField());
    }

    @Test
    public void testNewEmbeddedEnumValueBackwardsCompatibilityXbuf() {
        EvoMessage v2 = EvoMessage.create();
        v2.setChildField(com.neeve.adm.test.unit.evo.v2.xbuf.EvoEntity.create());
        v2.getChildField().setCharEnumField(com.neeve.adm.test.unit.evo.v2.xbuf.CharEnumeration.NewValue);
        com.neeve.adm.test.unit.evo.v1.xbuf.EvoMessage v1 = com.neeve.adm.test.unit.evo.v1.xbuf.EvoMessage.createFrom(v2.serializeToByteArray());
        Assert.assertNull((String)"Unrecognized enum value should be treated as null", (Object)((Object)v1.getChildField().getCharEnumField()));
        Assert.assertFalse((String)"Unrecognized enum value should result in hasField being flase", (boolean)v1.getChildField().hasCharEnumField());
        v2 = EvoMessage.createFrom(v1.serializeToByteArray());
        Assert.assertEquals((String)"Unrecognized enum value should be passed through", (Object)((Object)com.neeve.adm.test.unit.evo.v2.xbuf.CharEnumeration.NewValue), (Object)((Object)v2.getChildField().getCharEnumField()));
        Assert.assertTrue((String)"Unrecognized enum value should result in hasField being flase", (boolean)v2.getChildField().hasCharEnumField());
    }

    @Test
    public void testNewEmbeddedEnumValueBackwardsCompatibilityJson() {
        com.neeve.adm.test.unit.evo.v2.json.EvoMessage v2 = com.neeve.adm.test.unit.evo.v2.json.EvoMessage.create();
        v2.setChildField(com.neeve.adm.test.unit.evo.v2.json.EvoEntity.create());
        v2.getChildField().setCharEnumField(com.neeve.adm.test.unit.evo.v2.json.CharEnumeration.NewValue);
        com.neeve.adm.test.unit.evo.v1.json.EvoMessage v1 = com.neeve.adm.test.unit.evo.v1.json.EvoMessage.createFrom(v2.serializeToByteArray());
        Assert.assertNull((String)"Unrecognized enum value should be treated as null", (Object)((Object)v1.getChildField().getCharEnumField()));
        Assert.assertTrue((String)"Unrecognized enum value should result in hasField being flase", (boolean)v1.getChildField().hasCharEnumField());
        v2 = com.neeve.adm.test.unit.evo.v2.json.EvoMessage.createFrom(v1.serializeToByteArray());
        Assert.assertEquals((String)"Unrecognized enum value should not be passed through", null, (Object)((Object)v2.getChildField().getCharEnumField()));
        Assert.assertTrue((String)"Unrecognized enum value should result in hasField being flase", (boolean)v2.getChildField().hasCharEnumField());
    }

    @Test
    public void testNewEmbeddedEnumValueArrayBackwardsCompatibilityProto() {
        com.neeve.adm.test.unit.evo.v2.proto.EvoMessage v2 = com.neeve.adm.test.unit.evo.v2.proto.EvoMessage.create();
        v2.setChildField(com.neeve.adm.test.unit.evo.v2.proto.EvoEntity.create());
        v2.getChildField().addCharEnumArrayField(CharEnumeration.NewValue);
        v2.getChildField().addCharEnumArrayField(CharEnumeration.Value1);
        com.neeve.adm.test.unit.evo.v1.proto.EvoMessage v1 = com.neeve.adm.test.unit.evo.v1.proto.EvoMessage.createFrom(v2.serializeToByteArray());
        Assert.assertEquals((String)"Wrong arrays size, expected unrecognized enum array value to be ignored", (long)1L, (long)v1.getChildField().getCharEnumArrayFieldEmptyIfNull().length);
        Assert.assertEquals((String)"Wrong array value", (Object)((Object)com.neeve.adm.test.unit.evo.v1.proto.CharEnumeration.Value1), (Object)((Object)v1.getChildField().getCharEnumArrayFieldEmptyIfNull()[0]));
        v2 = com.neeve.adm.test.unit.evo.v2.proto.EvoMessage.createFrom(v1.serializeToByteArray());
        Assert.assertEquals((String)"Wrong arrays size, expected unrecognized enum array value to passed through", (long)2L, (long)v2.getChildField().getCharEnumArrayFieldEmptyIfNull().length);
        Assert.assertEquals((String)"Wrong array value", (Object)((Object)CharEnumeration.Value1), (Object)((Object)v2.getChildField().getCharEnumArrayFieldEmptyIfNull()[0]));
        Assert.assertEquals((String)"Wrong array value", (Object)((Object)CharEnumeration.NewValue), (Object)((Object)v2.getChildField().getCharEnumArrayFieldEmptyIfNull()[1]));
        v1 = com.neeve.adm.test.unit.evo.v1.proto.EvoMessage.createFromJson(v2.serializeToJson());
        Assert.assertEquals((String)"Wrong arrays size, expected unrecognized enum array value to be ignored", (long)2L, (long)v1.getChildField().getCharEnumArrayFieldEmptyIfNull().length);
        Assert.assertEquals((String)"Wrong array value", (Object)((Object)com.neeve.adm.test.unit.evo.v1.proto.CharEnumeration.Value1), (Object)((Object)v1.getChildField().getCharEnumArrayFieldEmptyIfNull()[0]));
        Assert.assertEquals((String)"Wrong array value", null, (Object)((Object)v1.getChildField().getCharEnumArrayFieldEmptyIfNull()[1]));
    }

    @Test
    public void testNewEmbeddedEnumValueArrayBackwardsCompatibilityXbuf() {
        EvoMessage v2 = EvoMessage.create();
        v2.setChildField(com.neeve.adm.test.unit.evo.v2.xbuf.EvoEntity.create());
        v2.getChildField().addCharEnumArrayField(com.neeve.adm.test.unit.evo.v2.xbuf.CharEnumeration.NewValue);
        v2.getChildField().addCharEnumArrayField(com.neeve.adm.test.unit.evo.v2.xbuf.CharEnumeration.Value1);
        com.neeve.adm.test.unit.evo.v1.xbuf.EvoMessage v1 = com.neeve.adm.test.unit.evo.v1.xbuf.EvoMessage.createFrom(v2.serializeToByteArray());
        Assert.assertEquals((String)"Wrong arrays size, expected unrecognized enum array value to be ignored", (long)1L, (long)v1.getChildField().getCharEnumArrayFieldEmptyIfNull().length);
        Assert.assertEquals((String)"Wrong array value", (Object)((Object)com.neeve.adm.test.unit.evo.v1.xbuf.CharEnumeration.Value1), (Object)((Object)v1.getChildField().getCharEnumArrayFieldEmptyIfNull()[0]));
        v2 = EvoMessage.createFrom(v1.serializeToByteArray());
        Assert.assertEquals((String)"Wrong arrays size, expected unrecognized enum array value to passed through", (long)2L, (long)v2.getChildField().getCharEnumArrayFieldEmptyIfNull().length);
        Assert.assertEquals((String)"Wrong array value", (Object)((Object)com.neeve.adm.test.unit.evo.v2.xbuf.CharEnumeration.NewValue), (Object)((Object)v2.getChildField().getCharEnumArrayFieldEmptyIfNull()[0]));
        Assert.assertEquals((String)"Wrong array value", (Object)((Object)com.neeve.adm.test.unit.evo.v2.xbuf.CharEnumeration.Value1), (Object)((Object)v2.getChildField().getCharEnumArrayFieldEmptyIfNull()[1]));
        v1 = com.neeve.adm.test.unit.evo.v1.xbuf.EvoMessage.createFromJson(v2.serializeToJson());
        Assert.assertEquals((String)"Wrong arrays size, expected unrecognized enum array value to be ignored", (long)1L, (long)v1.getChildField().getCharEnumArrayFieldEmptyIfNull().length);
        Assert.assertEquals((String)"Wrong array value", (Object)((Object)com.neeve.adm.test.unit.evo.v1.xbuf.CharEnumeration.Value1), (Object)((Object)v1.getChildField().getCharEnumArrayFieldEmptyIfNull()[0]));
    }

    @Test
    public void testNewEmbeddedEnumValueArrayBackwardsCompatibilityJson() {
        com.neeve.adm.test.unit.evo.v2.json.EvoMessage v2 = com.neeve.adm.test.unit.evo.v2.json.EvoMessage.create();
        v2.setChildField(com.neeve.adm.test.unit.evo.v2.json.EvoEntity.create());
        v2.getChildField().addCharEnumArrayField(com.neeve.adm.test.unit.evo.v2.json.CharEnumeration.NewValue);
        v2.getChildField().addCharEnumArrayField(com.neeve.adm.test.unit.evo.v2.json.CharEnumeration.Value1);
        com.neeve.adm.test.unit.evo.v1.json.EvoMessage v1 = com.neeve.adm.test.unit.evo.v1.json.EvoMessage.createFrom(v2.serializeToByteArray());
        Assert.assertEquals((String)"Wrong arrays size, expected unrecognized enum array value to be ignored", (long)2L, (long)v1.getChildField().getCharEnumArrayFieldEmptyIfNull().length);
        Assert.assertEquals((String)"Wrong array value", null, (Object)((Object)v1.getChildField().getCharEnumArrayFieldEmptyIfNull()[0]));
        Assert.assertEquals((String)"Wrong array value", (Object)((Object)com.neeve.adm.test.unit.evo.v1.json.CharEnumeration.Value1), (Object)((Object)v1.getChildField().getCharEnumArrayFieldEmptyIfNull()[1]));
        v2 = com.neeve.adm.test.unit.evo.v2.json.EvoMessage.createFrom(v1.serializeToByteArray());
        Assert.assertEquals((String)"Wrong arrays size, expected unrecognized enum array value to passed through", (long)2L, (long)v2.getChildField().getCharEnumArrayFieldEmptyIfNull().length);
        Assert.assertEquals((String)"Wrong array value", null, (Object)((Object)v2.getChildField().getCharEnumArrayFieldEmptyIfNull()[0]));
        Assert.assertEquals((String)"Wrong array value", (Object)((Object)com.neeve.adm.test.unit.evo.v2.json.CharEnumeration.Value1), (Object)((Object)v2.getChildField().getCharEnumArrayFieldEmptyIfNull()[1]));
    }

    @Test
    public void testNewEmbeddedEntityFieldValuePassthroughXbuf() {
        EvoMessage v2 = EvoMessage.create();
        v2.setChildField(com.neeve.adm.test.unit.evo.v2.xbuf.EvoEntity.create());
        v2.getChildField().setNewIntField(1);
        com.neeve.adm.test.unit.evo.v1.xbuf.EvoMessage v1 = com.neeve.adm.test.unit.evo.v1.xbuf.EvoMessage.createFrom(v2.serializeToByteArray());
        v2 = EvoMessage.createFrom(v1.serializeToByteArray());
        Assert.assertEquals((String)"NewIntField should have been passed through", (long)1L, (long)v2.getChildField().getNewIntField());
    }

    @Test
    public void testNewEmbeddedEntityFieldValuePassthroughProto() {
        com.neeve.adm.test.unit.evo.v2.proto.EvoMessage v2 = com.neeve.adm.test.unit.evo.v2.proto.EvoMessage.create();
        v2.setChildField(com.neeve.adm.test.unit.evo.v2.proto.EvoEntity.create());
        v2.getChildField().setNewIntField(1);
        com.neeve.adm.test.unit.evo.v1.proto.EvoMessage v1 = com.neeve.adm.test.unit.evo.v1.proto.EvoMessage.createFrom(v2.serializeToByteArray());
        v2 = com.neeve.adm.test.unit.evo.v2.proto.EvoMessage.createFrom(v1.serializeToByteArray());
        Assert.assertEquals((String)"NewIntField should have been passed through", (long)1L, (long)v2.getChildField().getNewIntField());
    }

    @Test
    public void testNewEmbeddedEntityFieldValuePassthroughJson() {
        com.neeve.adm.test.unit.evo.v2.json.EvoMessage v2 = com.neeve.adm.test.unit.evo.v2.json.EvoMessage.create();
        v2.setChildField(com.neeve.adm.test.unit.evo.v2.json.EvoEntity.create());
        v2.getChildField().setNewIntField(1);
        com.neeve.adm.test.unit.evo.v1.json.EvoMessage v1 = com.neeve.adm.test.unit.evo.v1.json.EvoMessage.createFrom(v2.serializeToByteArray());
        v2 = com.neeve.adm.test.unit.evo.v2.json.EvoMessage.createFrom(v1.serializeToByteArray());
        Assert.assertEquals((String)"NewIntField should have been passed through", (Object)false, (Object)v2.hasNewIntField());
    }

    @Test
    public void testNewEmbeddedEntityFieldValuePassthroughViaEntityCopyXbuf() {
        EvoMessage v2 = EvoMessage.create();
        v2.setChildField(com.neeve.adm.test.unit.evo.v2.xbuf.EvoEntity.create());
        v2.getChildField().setNewIntField(1);
        com.neeve.adm.test.unit.evo.v1.xbuf.EvoMessage v1 = com.neeve.adm.test.unit.evo.v1.xbuf.EvoMessage.createFrom(v2.serializeToByteArray());
        com.neeve.adm.test.unit.evo.v1.xbuf.EvoEntity e1 = com.neeve.adm.test.unit.evo.v1.xbuf.EvoEntity.create();
        v1.getChildFieldTo(e1);
        v1.dispose();
        com.neeve.adm.test.unit.evo.v1.xbuf.EvoMessage v1_2 = com.neeve.adm.test.unit.evo.v1.xbuf.EvoMessage.create();
        v1_2.setChildField(e1);
        v2 = EvoMessage.createFrom(v1_2.serializeToByteArray());
        v1_2.dispose();
        Assert.assertEquals((String)"NewIntField should have been passed through", (long)1L, (long)v2.getChildField().getNewIntField());
    }

    @Test
    public void testNewEmbeddedEntityFieldValuePassthroughViaEntityCopyProto() {
        com.neeve.adm.test.unit.evo.v2.proto.EvoMessage v2 = com.neeve.adm.test.unit.evo.v2.proto.EvoMessage.create();
        v2.setChildField(com.neeve.adm.test.unit.evo.v2.proto.EvoEntity.create());
        v2.getChildField().setNewIntField(1);
        com.neeve.adm.test.unit.evo.v1.proto.EvoMessage v1 = com.neeve.adm.test.unit.evo.v1.proto.EvoMessage.createFrom(v2.serializeToByteArray());
        com.neeve.adm.test.unit.evo.v1.proto.EvoEntity e1 = com.neeve.adm.test.unit.evo.v1.proto.EvoEntity.create();
        v1.getChildFieldTo(e1);
        v1.dispose();
        com.neeve.adm.test.unit.evo.v1.proto.EvoMessage v1_2 = com.neeve.adm.test.unit.evo.v1.proto.EvoMessage.create();
        v1_2.setChildField(e1);
        v2 = com.neeve.adm.test.unit.evo.v2.proto.EvoMessage.createFrom(v1_2.serializeToByteArray());
        v1_2.dispose();
        Assert.assertEquals((String)"NewIntField should have been passed through", (long)1L, (long)v2.getChildField().getNewIntField());
    }

    @Test
    public void testNewEmbeddedEntityFieldValuePassthroughViaEntityCopyJson() {
        com.neeve.adm.test.unit.evo.v2.json.EvoMessage v2 = com.neeve.adm.test.unit.evo.v2.json.EvoMessage.create();
        v2.setChildField(com.neeve.adm.test.unit.evo.v2.json.EvoEntity.create());
        v2.getChildField().setNewIntField(1);
        com.neeve.adm.test.unit.evo.v1.json.EvoMessage v1 = com.neeve.adm.test.unit.evo.v1.json.EvoMessage.createFrom(v2.serializeToByteArray());
        EvoEntity e1 = v1.getChildField().copy();
        v1.dispose();
        com.neeve.adm.test.unit.evo.v1.json.EvoMessage v1_2 = com.neeve.adm.test.unit.evo.v1.json.EvoMessage.create();
        v1_2.setChildField(e1);
        v2 = com.neeve.adm.test.unit.evo.v2.json.EvoMessage.createFrom(v1_2.serializeToByteArray());
        v1_2.dispose();
        Assert.assertEquals((String)"NewIntField should not have been passed through", (Object)false, (Object)v2.getChildField().hasNewIntField());
    }

    @Test
    public void testGetEmbeddedEntityToXbuf() throws Exception {
        com.neeve.adm.test.unit.xbuf.Message message = com.neeve.adm.test.unit.xbuf.Message.create();
        com.neeve.adm.test.unit.xbuf.Child2 child2 = com.neeve.adm.test.unit.xbuf.Child2.create();
        com.neeve.adm.test.unit.xbuf.Child3 child3 = com.neeve.adm.test.unit.xbuf.Child3.create();
        UtlObjectGraph.populateObject((Object)message, (Class[])new Class[]{com.neeve.adm.test.unit.xbuf.IMessage.class});
        UtlObjectGraph.populateObject((Object)child2, (Class[])new Class[]{com.neeve.adm.test.unit.xbuf.IChild2.class});
        UtlObjectGraph.populateObject((Object)child3, (Class[])new Class[]{com.neeve.adm.test.unit.xbuf.IChild3.class});
        message.setChildField(child2);
        child2.setChildField(child3);
        com.neeve.adm.test.unit.xbuf.Child2 child2Copy = com.neeve.adm.test.unit.xbuf.Child2.create();
        message.getChildFieldTo(child2Copy);
        StringBuffer diffSummary = new StringBuffer();
        message.sync();
        child2Copy.sync();
        if (!UtlObjectGraph.deepApiEquals((Object)message.getChildField(), (Object)child2Copy, (StringBuffer)diffSummary, Arrays.asList(com.neeve.adm.test.unit.xbuf.Child2.class, com.neeve.adm.test.unit.xbuf.Child3.class))) {
            Assert.fail((String)("GetXXXTo differs: " + diffSummary));
        }
    }

    @Test
    public void testGetEmbeddedEntityToProto() throws Exception {
        Message message = Message.create();
        com.neeve.adm.test.unit.proto.Child2 child2 = com.neeve.adm.test.unit.proto.Child2.create();
        com.neeve.adm.test.unit.proto.Child3 child3 = com.neeve.adm.test.unit.proto.Child3.create();
        UtlObjectGraph.populateObject((Object)message, (Class[])new Class[]{IMessage.class});
        UtlObjectGraph.populateObject((Object)child2, (Class[])new Class[]{IChild2.class});
        UtlObjectGraph.populateObject((Object)child3, (Class[])new Class[]{IChild3.class});
        message.setChildField(child2);
        child2.setChildField(child3);
        com.neeve.adm.test.unit.proto.Child2 child2Copy = com.neeve.adm.test.unit.proto.Child2.create();
        message.getChildFieldTo(child2Copy);
        StringBuffer diffSummary = new StringBuffer();
        message.sync();
        child2Copy.sync();
        if (!UtlObjectGraph.deepApiEquals((Object)message.getChildField(), (Object)child2Copy, (StringBuffer)diffSummary, Arrays.asList(com.neeve.adm.test.unit.proto.Child2.class, com.neeve.adm.test.unit.proto.Child3.class), (UtlObjectGraph.ComparatorFactory)this.nullAndEmptyArraysEquivalentComparator)) {
            Assert.fail((String)("GetXXXTo differs: " + diffSummary));
        }
    }

    @Test
    public void testGetEmbeddedEntityToJson() throws Exception {
        com.neeve.adm.test.unit.json.Message message = com.neeve.adm.test.unit.json.Message.create();
        Child2 child2 = Child2.create();
        Child3 child3 = Child3.create();
        UtlObjectGraph.populateObject((Object)message, (Class[])new Class[]{com.neeve.adm.test.unit.json.IMessage.class});
        UtlObjectGraph.populateObject((Object)child2, (Class[])new Class[]{com.neeve.adm.test.unit.json.IChild2.class});
        UtlObjectGraph.populateObject((Object)child3, (Class[])new Class[]{com.neeve.adm.test.unit.json.IChild3.class});
        message.setChildField(child2);
        child2.setChildField(child3);
        Child2 child2Copy = Child2.create();
        message.getChildFieldTo(child2Copy);
        StringBuffer diffSummary = new StringBuffer();
        message.sync();
        if (!UtlObjectGraph.deepApiEquals((Object)message.getChildField(), (Object)child2Copy, (StringBuffer)diffSummary, Arrays.asList(Child2.class, Child3.class))) {
            Assert.fail((String)("GetXXXTo differs: " + diffSummary));
        }
    }

    @Test
    public void testGetEmbeddedEntityToClearsFieldsXbuf() throws Exception {
        com.neeve.adm.test.unit.xbuf.Message message = com.neeve.adm.test.unit.xbuf.Message.create();
        com.neeve.adm.test.unit.xbuf.Child2 child2 = com.neeve.adm.test.unit.xbuf.Child2.create();
        child2.setIntField(1);
        message.setChildField(child2);
        com.neeve.adm.test.unit.xbuf.Child2 child2Copy = com.neeve.adm.test.unit.xbuf.Child2.create();
        com.neeve.adm.test.unit.xbuf.Child3 child3 = com.neeve.adm.test.unit.xbuf.Child3.create();
        UtlObjectGraph.populateObject((Object)child2Copy, (Class[])new Class[]{com.neeve.adm.test.unit.xbuf.IChild2.class});
        UtlObjectGraph.populateObject((Object)child3, (Class[])new Class[]{com.neeve.adm.test.unit.xbuf.IChild3.class});
        child2Copy.setChildField(child3);
        message.getChildFieldTo(child2Copy);
        StringBuffer diffSummary = new StringBuffer();
        message.sync();
        child2Copy.sync();
        if (!UtlObjectGraph.deepApiEquals((Object)message.getChildField(), (Object)child2Copy, (StringBuffer)diffSummary, Arrays.asList(com.neeve.adm.test.unit.xbuf.Child2.class, com.neeve.adm.test.unit.xbuf.Child3.class))) {
            Assert.fail((String)("GetXXXTo differs: " + diffSummary));
        }
    }

    @Test
    public void testGetEmbeddedEntityToClearsFieldsProto() throws Exception {
        Message message = Message.create();
        com.neeve.adm.test.unit.proto.Child2 child2 = com.neeve.adm.test.unit.proto.Child2.create();
        child2.setIntField(1);
        message.setChildField(child2);
        com.neeve.adm.test.unit.proto.Child2 child2Copy = com.neeve.adm.test.unit.proto.Child2.create();
        com.neeve.adm.test.unit.proto.Child3 child3 = com.neeve.adm.test.unit.proto.Child3.create();
        UtlObjectGraph.populateObject((Object)child2Copy, (Class[])new Class[]{IChild2.class});
        UtlObjectGraph.populateObject((Object)child3, (Class[])new Class[]{IChild3.class});
        child2Copy.setChildField(child3);
        message.getChildFieldTo(child2Copy);
        StringBuffer diffSummary = new StringBuffer();
        message.sync();
        child2Copy.sync();
        if (!UtlObjectGraph.deepApiEquals((Object)message.getChildField(), (Object)child2Copy, (StringBuffer)diffSummary, Arrays.asList(com.neeve.adm.test.unit.proto.Child2.class, com.neeve.adm.test.unit.proto.Child3.class))) {
            Assert.fail((String)("GetXXXTo differs: " + diffSummary));
        }
    }

    @Test
    public void testGetEmbeddedEntityToClearsFieldsJson() throws Exception {
        com.neeve.adm.test.unit.json.Message message = com.neeve.adm.test.unit.json.Message.create();
        Child2 child2 = Child2.create();
        child2.setIntField(1);
        message.setChildField(child2);
        Child2 child2Copy = Child2.create();
        Child3 child3 = Child3.create();
        UtlObjectGraph.populateObject((Object)child2Copy, (Class[])new Class[]{com.neeve.adm.test.unit.json.IChild2.class});
        UtlObjectGraph.populateObject((Object)child3, (Class[])new Class[]{com.neeve.adm.test.unit.json.IChild3.class});
        child2Copy.setChildField(child3);
        message.getChildFieldTo(child2Copy);
        StringBuffer diffSummary = new StringBuffer();
        message.sync();
        if (!UtlObjectGraph.deepApiEquals((Object)message.getChildField(), (Object)child2Copy, (StringBuffer)diffSummary, Arrays.asList(Child2.class, Child3.class))) {
            Assert.fail((String)("GetXXXTo differs: " + diffSummary));
        }
    }

    @Test
    public void testEmbeddedPassThroughFieldSerializationXbuf() {
        Random random = new Random(0L);
        for (int c = 0; c < 10; ++c) {
            for (int i = 0; i < 500; ++i) {
                com.neeve.adm.test.unit.evo.v2.xbuf.EvoEntity v2entity1 = com.neeve.adm.test.unit.evo.v2.xbuf.EvoEntity.create();
                for (int a = 0; a < i; ++a) {
                    v2entity1.addFieldA((byte)random.nextInt());
                }
                v2entity1.setFieldB("StringValue");
                v2entity1.setFieldC("StringValueC");
                EvoMessage v2message1 = EvoMessage.create();
                v2message1.lendChildField(v2entity1);
                IOBuffer buffer1 = v2message1.serializeToIOBuffer(true);
                v2message1.dispose();
                com.neeve.adm.test.unit.evo.v1.xbuf.EvoMessage v1Message1 = com.neeve.adm.test.unit.evo.v1.xbuf.EvoMessage.createFrom(buffer1.takeBuffer());
                buffer1.releaseBuffer().dispose();
                com.neeve.adm.test.unit.evo.v1.xbuf.EvoEntity v1entity1 = com.neeve.adm.test.unit.evo.v1.xbuf.EvoEntity.create();
                v1Message1.getChildFieldTo(v1entity1);
                v1Message1.dispose();
                this.assertIteratorEquals("Field A doesn't match", v2entity1.getFieldAIterator(), v1entity1.getFieldAIterator());
                Assert.assertEquals((String)"Field C doesn't match", (Object)v2entity1.getFieldCUnsafe(), (Object)v1entity1.getFieldCUnsafe());
                v1Message1 = com.neeve.adm.test.unit.evo.v1.xbuf.EvoMessage.create();
                v1Message1.setChildField(v1entity1);
                buffer1 = v1Message1.serializeToIOBuffer(true);
                EvoMessage v2Message2 = EvoMessage.createFrom(buffer1.takeBuffer());
                buffer1.releaseBuffer().dispose();
                v1Message1.dispose();
                com.neeve.adm.test.unit.evo.v2.xbuf.EvoEntity v2entity2 = com.neeve.adm.test.unit.evo.v2.xbuf.EvoEntity.create();
                v2Message2.getChildFieldTo(v2entity2);
                v2Message2.dispose();
                this.assertIteratorEquals("Field A doesn't match", v2entity1.getFieldAIterator(), v2entity2.getFieldAIterator());
                Assert.assertEquals((String)"Field B doesn't match", (Object)v2entity1.getFieldBUnsafe(), (Object)v2entity2.getFieldBUnsafe());
                Assert.assertEquals((String)"Field C doesn't match", (Object)v2entity1.getFieldCUnsafe(), (Object)v2entity2.getFieldCUnsafe());
                v2entity1.dispose();
                v2entity2.dispose();
            }
        }
    }

    @Test
    public void testEmbeddedPassThroughFieldSerializationProto() {
        Random random = new Random(0L);
        for (int c = 0; c < 100; ++c) {
            for (int i = 0; i < 500; ++i) {
                com.neeve.adm.test.unit.evo.v2.proto.EvoEntity v2entity1 = com.neeve.adm.test.unit.evo.v2.proto.EvoEntity.create();
                for (int a = 0; a < i; ++a) {
                    v2entity1.addFieldA((byte)random.nextInt());
                }
                v2entity1.setFieldB("StringValue");
                v2entity1.setFieldC("StringValueC");
                com.neeve.adm.test.unit.evo.v2.proto.EvoMessage v2message1 = com.neeve.adm.test.unit.evo.v2.proto.EvoMessage.create();
                v2message1.lendChildField(v2entity1);
                IOBuffer buffer1 = v2message1.serializeToIOBuffer(true);
                v2message1.dispose();
                com.neeve.adm.test.unit.evo.v1.proto.EvoMessage v1Message1 = com.neeve.adm.test.unit.evo.v1.proto.EvoMessage.createFromSerializedProtoMessage(buffer1.takeBuffer());
                buffer1.releaseBuffer().dispose();
                com.neeve.adm.test.unit.evo.v1.proto.EvoEntity v1entity1 = com.neeve.adm.test.unit.evo.v1.proto.EvoEntity.create();
                v1Message1.getChildFieldTo(v1entity1);
                v1Message1.dispose();
                this.assertIteratorEquals("Field A doesn't match", v2entity1.getFieldAIterator(), v1entity1.getFieldAIterator());
                Assert.assertEquals((String)"Field C doesn't match", (Object)v2entity1.getFieldCUnsafe(), (Object)v1entity1.getFieldCUnsafe());
                v1Message1 = com.neeve.adm.test.unit.evo.v1.proto.EvoMessage.create();
                v1Message1.setChildField(v1entity1);
                buffer1 = v2message1.serializeToIOBuffer(true);
                com.neeve.adm.test.unit.evo.v2.proto.EvoMessage v2Message2 = com.neeve.adm.test.unit.evo.v2.proto.EvoMessage.createFromSerializedProtoMessage(buffer1.takeBuffer());
                buffer1.releaseBuffer().dispose();
                com.neeve.adm.test.unit.evo.v2.proto.EvoEntity v2entity2 = com.neeve.adm.test.unit.evo.v2.proto.EvoEntity.create();
                v2Message2.getChildFieldTo(v2entity2);
                v2Message2.dispose();
                this.assertIteratorEquals("Field A doesn't match", v2entity1.getFieldAIterator(), v2entity2.getFieldAIterator());
                Assert.assertEquals((String)"Field B doesn't match", (Object)v2entity1.getFieldBUnsafe(), (Object)v2entity2.getFieldBUnsafe());
                Assert.assertEquals((String)"Field C doesn't match", (Object)v2entity1.getFieldCUnsafe(), (Object)v2entity2.getFieldCUnsafe());
                v2entity1.dispose();
                v2entity2.dispose();
            }
        }
    }

    @Test
    public void testMessageCopyXbuf() throws Exception {
        com.neeve.adm.test.unit.xbuf.Message message = com.neeve.adm.test.unit.xbuf.Message.create();
        com.neeve.adm.test.unit.xbuf.Child2 child2 = com.neeve.adm.test.unit.xbuf.Child2.create();
        com.neeve.adm.test.unit.xbuf.Child3 child3 = com.neeve.adm.test.unit.xbuf.Child3.create();
        UtlObjectGraph.populateObject((Object)message, (Class[])new Class[]{com.neeve.adm.test.unit.xbuf.IMessage.class});
        UtlObjectGraph.populateObject((Object)child2, (Class[])new Class[]{com.neeve.adm.test.unit.xbuf.IChild2.class});
        UtlObjectGraph.populateObject((Object)child3, (Class[])new Class[]{com.neeve.adm.test.unit.xbuf.IChild3.class});
        message.setChildField(child2);
        child2.setChildField(child3);
        Date now = new Date(UtlTime.now() / 1000L);
        message.setOriginTs(System.currentTimeMillis() - 10000L);
        message.setPreDeserializeTs(UtlTime.now());
        message.ensureId();
        com.neeve.adm.test.unit.xbuf.Message copy = message.copy();
        Date createTs = new Date(copy.getCreateTs() / 1000L);
        Assert.assertTrue((String)("Copy's creation time should be greater than " + now + " but was " + createTs), (now.getTime() <= createTs.getTime() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Copy's origin time should be the same as the original", (long)message.getOriginTs(), (long)copy.getOriginTs());
        Assert.assertEquals((String)"Copy's predesrialize ts should not be set", (long)0L, (long)copy.getPreDeserializeTs());
        Assert.assertNotEquals((String)"Copy's ids should be different", (Object)copy.getId(), (Object)message.getId());
        StringBuffer diffSummary = new StringBuffer();
        if (!UtlObjectGraph.deepApiEquals((Object)message, (Object)copy, (StringBuffer)diffSummary, Arrays.asList(com.neeve.adm.test.unit.xbuf.IMessage.class, com.neeve.adm.test.unit.xbuf.Child2.class, com.neeve.adm.test.unit.xbuf.Child3.class))) {
            Assert.fail((String)("Copy differs: " + diffSummary));
        }
        if (UtlObjectGraph.deepApiEquals((Object)message, (Object)copy, (StringBuffer)diffSummary, Arrays.asList(RogNode.class, MessageView.class))) {
            Assert.fail((String)("Copy picked up RogNode or MessageView fields: " + diffSummary));
        }
        copy.setBooleanField(!copy.getBooleanField());
        Assert.assertFalse((String)"Changed field on copy should differ from original", (copy.getBooleanField() == message.getBooleanField() ? 1 : 0) != 0);
        copy.getChildField().setBooleanField(!copy.getChildField().getBooleanField());
        Assert.assertFalse((String)"Changed field on copy.getChildField() should differ from original.getChildField()", (copy.getChildField().getBooleanField() == message.getChildField().getBooleanField() ? 1 : 0) != 0);
        message.setIntField(message.getIntField() + 1);
        Assert.assertFalse((String)"Changed field on copy should differ from original", (copy.getIntField() == message.getIntField() ? 1 : 0) != 0);
        copy.getChildField().setIntField(copy.getChildField().getIntField() + 1);
        Assert.assertFalse((String)"Changed field on copy.getChildField() should differ from original.getChildField()", (copy.getChildField().getIntField() == message.getChildField().getIntField() ? 1 : 0) != 0);
    }

    @Test
    public void testMessageCopyProto() throws Exception {
        Message message = Message.create();
        com.neeve.adm.test.unit.proto.Child2 child2 = com.neeve.adm.test.unit.proto.Child2.create();
        com.neeve.adm.test.unit.proto.Child3 child3 = com.neeve.adm.test.unit.proto.Child3.create();
        UtlObjectGraph.populateObject((Object)message, (Class[])new Class[]{IMessage.class});
        UtlObjectGraph.populateObject((Object)child2, (Class[])new Class[]{IChild2.class});
        UtlObjectGraph.populateObject((Object)child3, (Class[])new Class[]{IChild3.class});
        message.setChildField(child2);
        child2.setChildField(child3);
        Date now = new Date(UtlTime.now() / 1000L);
        message.setOriginTs(System.currentTimeMillis() - 10000L);
        message.setPreDeserializeTs(UtlTime.now());
        message.ensureId();
        Message copy = message.copy();
        Date createTs = new Date(copy.getCreateTs() / 1000L);
        Assert.assertTrue((String)("Copy's creation time should be greater than " + now + " but was " + createTs), (now.getTime() <= createTs.getTime() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Copy's origin time should be the same as the original", (long)message.getOriginTs(), (long)copy.getOriginTs());
        Assert.assertEquals((String)"Copy's predesrialize ts should not be set", (long)0L, (long)copy.getPreDeserializeTs());
        Assert.assertNotEquals((String)"Copy's ids should be different", (Object)copy.getId(), (Object)message.getId());
        StringBuffer diffSummary = new StringBuffer();
        message.sync();
        copy.sync();
        if (!UtlObjectGraph.deepApiEquals((Object)message, (Object)copy, (StringBuffer)diffSummary, Arrays.asList(IMessage.class, com.neeve.adm.test.unit.proto.Child2.class, com.neeve.adm.test.unit.proto.Child3.class), (UtlObjectGraph.ComparatorFactory)this.nullAndEmptyArraysEquivalentComparator)) {
            Assert.fail((String)("Copy differs: " + diffSummary));
        }
        if (UtlObjectGraph.deepApiEquals((Object)message, (Object)copy, (StringBuffer)diffSummary, Arrays.asList(RogNode.class, MessageView.class), (UtlObjectGraph.ComparatorFactory)this.nullAndEmptyArraysEquivalentComparator)) {
            Assert.fail((String)("Copy picked up RogNode or MessageView fields: " + diffSummary));
        }
        copy.setBooleanField(!copy.getBooleanField());
        Assert.assertFalse((String)"Changed field on copy should differ from original", (copy.getBooleanField() == message.getBooleanField() ? 1 : 0) != 0);
        copy.getChildField().setBooleanField(!copy.getChildField().getBooleanField());
        Assert.assertFalse((String)"Changed field on copy.getChildField() should differ from original.getChildField()", (copy.getChildField().getBooleanField() == message.getChildField().getBooleanField() ? 1 : 0) != 0);
        message.setIntField(message.getIntField() + 1);
        Assert.assertFalse((String)"Changed field on copy should differ from original", (copy.getIntField() == message.getIntField() ? 1 : 0) != 0);
        copy.getChildField().setIntField(copy.getChildField().getIntField() + 1);
        Assert.assertFalse((String)"Changed field on copy.getChildField() should differ from original.getChildField()", (copy.getChildField().getIntField() == message.getChildField().getIntField() ? 1 : 0) != 0);
    }

    @Test
    public void testMessageCopyJson() throws Exception {
        com.neeve.adm.test.unit.json.Message message = com.neeve.adm.test.unit.json.Message.create();
        Child2 child2 = Child2.create();
        Child3 child3 = Child3.create();
        UtlObjectGraph.populateObject((Object)message, (Class[])new Class[]{com.neeve.adm.test.unit.json.IMessage.class});
        UtlObjectGraph.populateObject((Object)child2, (Class[])new Class[]{com.neeve.adm.test.unit.json.IChild2.class});
        UtlObjectGraph.populateObject((Object)child3, (Class[])new Class[]{com.neeve.adm.test.unit.json.IChild3.class});
        message.setChildField(child2);
        child2.setChildField(child3);
        Date now = new Date(UtlTime.now() / 1000L);
        message.setOriginTs(System.currentTimeMillis() - 10000L);
        message.setPreDeserializeTs(UtlTime.now());
        message.ensureId();
        com.neeve.adm.test.unit.json.Message copy = message.copy();
        Date createTs = new Date(copy.getCreateTs() / 1000L);
        Assert.assertTrue((String)("Copy's creation time should be greater than " + now + " but was " + createTs), (now.getTime() <= createTs.getTime() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Copy's origin time should be the same as the original", (long)message.getOriginTs(), (long)copy.getOriginTs());
        Assert.assertEquals((String)"Copy's predesrialize ts should not be set", (long)0L, (long)copy.getPreDeserializeTs());
        Assert.assertNotEquals((String)"Copy's ids should be different", (Object)copy.getId(), (Object)message.getId());
        StringBuffer diffSummary = new StringBuffer();
        if (!UtlObjectGraph.deepApiEquals((Object)message, (Object)copy, (StringBuffer)diffSummary, Arrays.asList(com.neeve.adm.test.unit.json.IMessage.class, Child2.class, com.neeve.adm.test.unit.proto.Child3.class))) {
            Assert.fail((String)("Copy differs: " + diffSummary));
        }
        if (UtlObjectGraph.deepApiEquals((Object)message, (Object)copy, (StringBuffer)diffSummary, Arrays.asList(RogNode.class, MessageView.class))) {
            Assert.fail((String)("Copy picked up RogNode or MessageView fields: " + diffSummary));
        }
        copy.setBooleanField(!copy.getBooleanField());
        Assert.assertFalse((String)"Changed field on copy should differ from original", (copy.getBooleanField() == message.getBooleanField() ? 1 : 0) != 0);
        copy.getChildField().setBooleanField(!copy.getChildField().getBooleanField());
        Assert.assertFalse((String)"Changed field on copy.getChildField() should differ from original.getChildField()", (copy.getChildField().getBooleanField() == message.getChildField().getBooleanField() ? 1 : 0) != 0);
        message.setIntField(message.getIntField() + 1);
        Assert.assertFalse((String)"Changed field on copy should differ from original", (copy.getIntField() == message.getIntField() ? 1 : 0) != 0);
        copy.getChildField().setIntField(copy.getChildField().getIntField() + 1);
        Assert.assertFalse((String)"Changed field on copy.getChildField() should differ from original.getChildField()", (copy.getChildField().getIntField() == message.getChildField().getIntField() ? 1 : 0) != 0);
    }

    @Test
    public void testInitialXbufEmbeddedEntityBackingBufferSize() {
        XRuntime.getProps().setProperty("nv.xbuf.com.neeve.adm.test.unit.xbuf.BackingBufferSizeTestEntity.initialbackingbuffersize", "64");
        BackingBufferSizeTestEntity entity = BackingBufferSizeTestEntity.create();
        Assert.assertEquals((String)"Unexpected backing buffer size", (long)64L, (long)entity.getBackingBuffer().getIOBuffer().getCapacity());
    }

    @Test
    public void testQueueIterationJson() throws Exception {
        com.neeve.adm.test.unit.json.ChildQueue queue = com.neeve.adm.test.unit.json.ChildQueue.create();
        for (int i = 1; i <= 3; ++i) {
            Child1 child = Child1.create();
            child.setIntField(i);
            queue.add(child);
        }
        XIterator it = queue.iterator();
        XIterator rit = queue.reusableIterator();
        for (int i = 1; i <= 3; ++i) {
            Assert.assertEquals((String)("Wrong element returned by iterator on iteration " + i), (long)i, (long)((Child1)it.next()).getIntField());
            Assert.assertEquals((String)("Wrong element returned by reusable iterator on iteration " + i), (long)i, (long)((Child1)rit.next()).getIntField());
        }
        try {
            it.next();
            Assert.fail((String)"Iterator shouldn't have had another element");
        }
        catch (NoSuchElementException i) {
            // empty catch block
        }
        try {
            rit.next();
            Assert.fail((String)"Iterator shouldn't have had another element");
        }
        catch (NoSuchElementException i) {
            // empty catch block
        }
        it = queue.reverseIterator();
        rit = queue.reusableReverseIterator();
        for (int i = 3; i >= 1; --i) {
            Assert.assertEquals((String)("Wrong element returned by iterator on iteration " + i), (long)i, (long)((Child1)it.next()).getIntField());
            Assert.assertEquals((String)("Wrong element returned by reusable iterator on iteration " + i), (long)i, (long)((Child1)rit.next()).getIntField());
        }
        try {
            it.next();
            Assert.fail((String)"Iterator shouldn't have had another element");
        }
        catch (NoSuchElementException i) {
            // empty catch block
        }
        try {
            rit.next();
            Assert.fail((String)"Iterator shouldn't have had another element");
        }
        catch (NoSuchElementException i) {
            // empty catch block
        }
        it = queue.iterator();
        rit = queue.reusableIterator();
        for (int i = 1; i <= 3; ++i) {
            Assert.assertEquals((String)("Wrong element returned by iterator on iteration " + i), (long)i, (long)((Child1)it.next()).getIntField());
            Assert.assertEquals((String)("Wrong element returned by reusable iterator on iteration " + i), (long)i, (long)((Child1)rit.next()).getIntField());
        }
        try {
            it.next();
            Assert.fail((String)"Iterator shouldn't have had another element");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            rit.next();
            Assert.fail((String)"Iterator shouldn't have had another element");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testQueueIterationProto() throws Exception {
        ChildQueue queue = ChildQueue.create();
        for (int i = 1; i <= 3; ++i) {
            com.neeve.adm.test.unit.proto.Child1 child = com.neeve.adm.test.unit.proto.Child1.create();
            child.setIntField(i);
            queue.add(child);
        }
        XIterator it = queue.iterator();
        XIterator rit = queue.reusableIterator();
        for (int i = 1; i <= 3; ++i) {
            Assert.assertEquals((String)("Wrong element returned by iterator on iteration " + i), (long)i, (long)((com.neeve.adm.test.unit.proto.Child1)it.next()).getIntField());
            Assert.assertEquals((String)("Wrong element returned by reusable iterator on iteration " + i), (long)i, (long)((com.neeve.adm.test.unit.proto.Child1)rit.next()).getIntField());
        }
        try {
            it.next();
            Assert.fail((String)"Iterator shouldn't have had another element");
        }
        catch (NoSuchElementException i) {
            // empty catch block
        }
        try {
            rit.next();
            Assert.fail((String)"Iterator shouldn't have had another element");
        }
        catch (NoSuchElementException i) {
            // empty catch block
        }
        it = queue.reverseIterator();
        rit = queue.reusableReverseIterator();
        for (int i = 3; i >= 1; --i) {
            Assert.assertEquals((String)("Wrong element returned by iterator on iteration " + i), (long)i, (long)((com.neeve.adm.test.unit.proto.Child1)it.next()).getIntField());
            Assert.assertEquals((String)("Wrong element returned by reusable iterator on iteration " + i), (long)i, (long)((com.neeve.adm.test.unit.proto.Child1)rit.next()).getIntField());
        }
        try {
            it.next();
            Assert.fail((String)"Iterator shouldn't have had another element");
        }
        catch (NoSuchElementException i) {
            // empty catch block
        }
        try {
            rit.next();
            Assert.fail((String)"Iterator shouldn't have had another element");
        }
        catch (NoSuchElementException i) {
            // empty catch block
        }
        it = queue.iterator();
        rit = queue.reusableIterator();
        for (int i = 1; i <= 3; ++i) {
            Assert.assertEquals((String)("Wrong element returned by iterator on iteration " + i), (long)i, (long)((com.neeve.adm.test.unit.proto.Child1)it.next()).getIntField());
            Assert.assertEquals((String)("Wrong element returned by reusable iterator on iteration " + i), (long)i, (long)((com.neeve.adm.test.unit.proto.Child1)rit.next()).getIntField());
        }
        try {
            it.next();
            Assert.fail((String)"Iterator shouldn't have had another element");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            rit.next();
            Assert.fail((String)"Iterator shouldn't have had another element");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testQueueIterationXbuf() throws Exception {
        com.neeve.adm.test.unit.xbuf.ChildQueue queue = com.neeve.adm.test.unit.xbuf.ChildQueue.create();
        for (int i = 1; i <= 3; ++i) {
            com.neeve.adm.test.unit.xbuf.Child1 child = com.neeve.adm.test.unit.xbuf.Child1.create();
            child.setIntField(i);
            queue.add(child);
        }
        XIterator it = queue.iterator();
        XIterator rit = queue.reusableIterator();
        for (int i = 1; i <= 3; ++i) {
            Assert.assertEquals((String)("Wrong element returned by iterator on iteration " + i), (long)i, (long)((com.neeve.adm.test.unit.xbuf.Child1)it.next()).getIntField());
            Assert.assertEquals((String)("Wrong element returned by reusable iterator on iteration " + i), (long)i, (long)((com.neeve.adm.test.unit.xbuf.Child1)rit.next()).getIntField());
        }
        try {
            it.next();
            Assert.fail((String)"Iterator shouldn't have had another element");
        }
        catch (NoSuchElementException i) {
            // empty catch block
        }
        try {
            rit.next();
            Assert.fail((String)"Iterator shouldn't have had another element");
        }
        catch (NoSuchElementException i) {
            // empty catch block
        }
        it = queue.reverseIterator();
        rit = queue.reusableReverseIterator();
        for (int i = 3; i >= 1; --i) {
            Assert.assertEquals((String)("Wrong element returned by iterator on iteration " + i), (long)i, (long)((com.neeve.adm.test.unit.xbuf.Child1)it.next()).getIntField());
            Assert.assertEquals((String)("Wrong element returned by reusable iterator on iteration " + i), (long)i, (long)((com.neeve.adm.test.unit.xbuf.Child1)rit.next()).getIntField());
        }
        try {
            it.next();
            Assert.fail((String)"Iterator shouldn't have had another element");
        }
        catch (NoSuchElementException i) {
            // empty catch block
        }
        try {
            rit.next();
            Assert.fail((String)"Iterator shouldn't have had another element");
        }
        catch (NoSuchElementException i) {
            // empty catch block
        }
        it = queue.iterator();
        rit = queue.reusableIterator();
        for (int i = 1; i <= 3; ++i) {
            Assert.assertEquals((String)("Wrong element returned by iterator on iteration " + i), (long)i, (long)((com.neeve.adm.test.unit.xbuf.Child1)it.next()).getIntField());
            Assert.assertEquals((String)("Wrong element returned by reusable iterator on iteration " + i), (long)i, (long)((com.neeve.adm.test.unit.xbuf.Child1)rit.next()).getIntField());
        }
        try {
            it.next();
            Assert.fail((String)"Iterator shouldn't have had another element");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            rit.next();
            Assert.fail((String)"Iterator shouldn't have had another element");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    static final void compareByteArrayValues(String assertion, byte[] src, byte[] comp, int ... offsets) {
        for (int i = 0; i < offsets.length; ++i) {
            Assert.assertEquals((String)(assertion + " (at offset " + i + ")"), (long)src[i], (long)comp[i]);
        }
    }

    public void assertIteratorEquals(String message, XByteIterator source, XByteIterator target) {
        int index = 0;
        while (source.hasNext()) {
            byte t;
            if (!target.hasNext()) {
                throw new AssertionFailedError("target has fewer items than source at " + index);
            }
            byte s = source.next();
            if (s != (t = target.next())) {
                throw new AssertionFailedError("source differs from target at index " + index + " source=" + s + ", target=" + t);
            }
            ++index;
        }
    }

    static {
        System.setProperty("nv.msg.latency.stats", "true");
        System.getProperties().setProperty("nv.packet.sto.defaultbuffersize", "102400");
        System.getProperties().setProperty("nv.optimizefor", "latency");
        System.getProperties().setProperty("nv.conservecpu", "true");
        Factory factory = new Factory();
        StoreObjectFactoryRegistry.getInstance().registerObjectFactory(factory);
        XRuntime.updateProps((Properties)System.getProperties());
    }
}

