/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.solxf.impl.jni;

import com.neeve.sma.SmaException;
import com.neeve.solxf.ISolFlowReceiver;
import com.neeve.solxf.ISolMessageListener;
import com.neeve.solxf.ISolQueue;
import com.neeve.solxf.impl.jni.SolJniListener;
import com.neeve.solxf.impl.jni.SolJniUtils;
import java.util.Properties;

public final class SolJniFlowReceiver
implements ISolFlowReceiver {
    private final long _nsession;
    private final long _nthis;
    private final ISolMessageListener _listener;

    SolJniFlowReceiver(long nsession, ISolQueue queue, ISolMessageListener listener, Properties props) throws SmaException {
        this._nsession = nsession;
        this._listener = listener;
        this._nthis = SolJniFlowReceiver.nativeCreate(this._nsession, queue.getName(), SolJniUtils.props2Array(props));
    }

    private static final native long nativeCreate(long var0, String var2, String[] var3) throws SmaException;

    private static final native void nativeStart(long var0);

    private static final native void nativeAck(long var0, long var2);

    private static final native void nativeStop(long var0);

    private static final native void nativeDestroy(long var0);

    @Override
    public final void start() {
        SolJniListener.registerFlowReceiver(this._nthis, this._listener);
        SolJniFlowReceiver.nativeStart(this._nthis);
    }

    @Override
    public final void ack(long messageId) {
        SolJniFlowReceiver.nativeAck(this._nthis, messageId);
    }

    @Override
    public final void stop() {
        SolJniListener.deregisterFlowReceiver(this._nthis);
        SolJniFlowReceiver.nativeStop(this._nthis);
    }

    @Override
    public final void close() {
        this.stop();
        SolJniFlowReceiver.nativeDestroy(this._nthis);
    }
}

